// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/**
 * Returns a tuple of two arrays with the first one containing all elements in the given array that match the given predicate
 * and the second one containing all that do not
 *
 * Example:
 *
 * ```ts
 * import { partition } from "https://deno.land/std@$STD_VERSION/collections/partition.ts";
 * import { assertEquals } from "https://deno.land/std@$STD_VERSION/testing/asserts.ts";
 *
 * const numbers = [ 5, 6, 7, 8, 9 ]
 * const [ even, odd ] = partition(numbers, it => it % 2 == 0)
 *
 * assertEquals(even, [ 6, 8 ])
 * assertEquals(odd, [ 5, 7, 9 ])
 * ```
 */ export function partition(array, predicate) {
    const matches = [];
    const rest = [];
    for (const element of array){
        if (predicate(element)) {
            matches.push(element);
        } else {
            rest.push(element);
        }
    }
    return [
        matches,
        rest
    ];
}
//# sourceMappingURL=data:application/json;base64,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