// Ported from js-yaml v3.13.1:
// https://github.com/nodeca/js-yaml/commit/665aadda42349dcae869f12040d9b10ef18d12da
// Copyright 2011-2015 by Vitaly Puzrin. All rights reserved. MIT license.
// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
import { State } from "../state.ts";
const { hasOwn  } = Object;
function compileStyleMap(schema, map) {
    if (typeof map === "undefined" || map === null) return {};
    let type;
    const result = {};
    const keys = Object.keys(map);
    let tag, style;
    for(let index = 0, length = keys.length; index < length; index += 1){
        tag = keys[index];
        style = String(map[tag]);
        if (tag.slice(0, 2) === "!!") {
            tag = `tag:yaml.org,2002:${tag.slice(2)}`;
        }
        type = schema.compiledTypeMap.fallback[tag];
        if (type && typeof type.styleAliases !== "undefined" && hasOwn(type.styleAliases, style)) {
            style = type.styleAliases[style];
        }
        result[tag] = style;
    }
    return result;
}
export class DumperState extends State {
    indent;
    noArrayIndent;
    skipInvalid;
    flowLevel;
    sortKeys;
    lineWidth;
    noRefs;
    noCompatMode;
    condenseFlow;
    implicitTypes;
    explicitTypes;
    tag = null;
    result = "";
    duplicates = [];
    usedDuplicates = [];
    styleMap;
    dump;
    constructor({ schema , indent =2 , noArrayIndent =false , skipInvalid =false , flowLevel =-1 , styles =null , sortKeys =false , lineWidth =80 , noRefs =false , noCompatMode =false , condenseFlow =false  }){
        super(schema);
        this.indent = Math.max(1, indent);
        this.noArrayIndent = noArrayIndent;
        this.skipInvalid = skipInvalid;
        this.flowLevel = flowLevel;
        this.styleMap = compileStyleMap(this.schema, styles);
        this.sortKeys = sortKeys;
        this.lineWidth = lineWidth;
        this.noRefs = noRefs;
        this.noCompatMode = noCompatMode;
        this.condenseFlow = condenseFlow;
        this.implicitTypes = this.schema.compiledImplicit;
        this.explicitTypes = this.schema.compiledExplicit;
    }
}
//# sourceMappingURL=data:application/json;base64,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