// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/**
 * Calls the given reducer on each element of the given collection, passing it's
 * result as the accumulator to the next respective call, starting with the given
 * initialValue. Returns all intermediate accumulator results.
 *
 * Example:
 *
 * ```ts
 * import { runningReduce } from "https://deno.land/std@$STD_VERSION/collections/running_reduce.ts";
 * import { assertEquals } from "https://deno.land/std@$STD_VERSION/testing/asserts.ts";
 *
 * const numbers = [1, 2, 3, 4, 5];
 * const sumSteps = runningReduce(numbers, (sum, current) => sum + current, 0);
 *
 * assertEquals(sumSteps, [1, 3, 6, 10, 15]);
 * ```
 */ export function runningReduce(array, reducer, initialValue) {
    let currentResult = initialValue;
    return array.map((el, currentIndex)=>currentResult = reducer(currentResult, el, currentIndex));
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjE2Ni4wL2NvbGxlY3Rpb25zL3J1bm5pbmdfcmVkdWNlLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAyMDE4LTIwMjIgdGhlIERlbm8gYXV0aG9ycy4gQWxsIHJpZ2h0cyByZXNlcnZlZC4gTUlUIGxpY2Vuc2UuXG4vLyBUaGlzIG1vZHVsZSBpcyBicm93c2VyIGNvbXBhdGlibGUuXG5cbi8qKlxuICogQ2FsbHMgdGhlIGdpdmVuIHJlZHVjZXIgb24gZWFjaCBlbGVtZW50IG9mIHRoZSBnaXZlbiBjb2xsZWN0aW9uLCBwYXNzaW5nIGl0J3NcbiAqIHJlc3VsdCBhcyB0aGUgYWNjdW11bGF0b3IgdG8gdGhlIG5leHQgcmVzcGVjdGl2ZSBjYWxsLCBzdGFydGluZyB3aXRoIHRoZSBnaXZlblxuICogaW5pdGlhbFZhbHVlLiBSZXR1cm5zIGFsbCBpbnRlcm1lZGlhdGUgYWNjdW11bGF0b3IgcmVzdWx0cy5cbiAqXG4gKiBFeGFtcGxlOlxuICpcbiAqIGBgYHRzXG4gKiBpbXBvcnQgeyBydW5uaW5nUmVkdWNlIH0gZnJvbSBcImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAkU1REX1ZFUlNJT04vY29sbGVjdGlvbnMvcnVubmluZ19yZWR1Y2UudHNcIjtcbiAqIGltcG9ydCB7IGFzc2VydEVxdWFscyB9IGZyb20gXCJodHRwczovL2Rlbm8ubGFuZC9zdGRAJFNURF9WRVJTSU9OL3Rlc3RpbmcvYXNzZXJ0cy50c1wiO1xuICpcbiAqIGNvbnN0IG51bWJlcnMgPSBbMSwgMiwgMywgNCwgNV07XG4gKiBjb25zdCBzdW1TdGVwcyA9IHJ1bm5pbmdSZWR1Y2UobnVtYmVycywgKHN1bSwgY3VycmVudCkgPT4gc3VtICsgY3VycmVudCwgMCk7XG4gKlxuICogYXNzZXJ0RXF1YWxzKHN1bVN0ZXBzLCBbMSwgMywgNiwgMTAsIDE1XSk7XG4gKiBgYGBcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHJ1bm5pbmdSZWR1Y2U8VCwgTz4oXG4gIGFycmF5OiByZWFkb25seSBUW10sXG4gIHJlZHVjZXI6IChhY2N1bXVsYXRvcjogTywgY3VycmVudDogVCwgY3VycmVudEluZGV4OiBudW1iZXIpID0+IE8sXG4gIGluaXRpYWxWYWx1ZTogTyxcbik6IE9bXSB7XG4gIGxldCBjdXJyZW50UmVzdWx0ID0gaW5pdGlhbFZhbHVlO1xuICByZXR1cm4gYXJyYXkubWFwKChlbCwgY3VycmVudEluZGV4KSA9PlxuICAgIGN1cnJlbnRSZXN1bHQgPSByZWR1Y2VyKGN1cnJlbnRSZXN1bHQsIGVsLCBjdXJyZW50SW5kZXgpXG4gICk7XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsMEVBQTBFO0FBQzFFLHFDQUFxQztBQUVyQzs7Ozs7Ozs7Ozs7Ozs7OztDQWdCQyxHQUNELE9BQU8sU0FBUyxjQUNkLEtBQW1CLEVBQ25CLE9BQWdFLEVBQ2hFLFlBQWUsRUFDVjtJQUNMLElBQUksZ0JBQWdCO0lBQ3BCLE9BQU8sTUFBTSxHQUFHLENBQUMsQ0FBQyxJQUFJLGVBQ3BCLGdCQUFnQixRQUFRLGVBQWUsSUFBSTtBQUUvQyxDQUFDIn0=