// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
const UUID_RE = /^[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i;
/**
 * Validate that the passed UUID is an RFC4122 v4 UUID.
 *
 * ```ts
 * import { validate } from "https://deno.land/std@$STD_VERSION/uuid/v4.ts";
 * import { generate as generateV1 } from "https://deno.land/std@$STD_VERSION/uuid/v1.ts";
 *
 * validate(crypto.randomUUID()); // true
 * validate(generateV1() as string); // false
 * validate("this-is-not-a-uuid"); // false
 * ```
 */ export function validate(id) {
    return UUID_RE.test(id);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjE2Ni4wL3V1aWQvdjQudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IDIwMTgtMjAyMiB0aGUgRGVubyBhdXRob3JzLiBBbGwgcmlnaHRzIHJlc2VydmVkLiBNSVQgbGljZW5zZS5cbi8vIFRoaXMgbW9kdWxlIGlzIGJyb3dzZXIgY29tcGF0aWJsZS5cblxuY29uc3QgVVVJRF9SRSA9XG4gIC9eWzAtOWEtZl17OH0tWzAtOWEtZl17NH0tNFswLTlhLWZdezN9LVs4OWFiXVswLTlhLWZdezN9LVswLTlhLWZdezEyfSQvaTtcblxuLyoqXG4gKiBWYWxpZGF0ZSB0aGF0IHRoZSBwYXNzZWQgVVVJRCBpcyBhbiBSRkM0MTIyIHY0IFVVSUQuXG4gKlxuICogYGBgdHNcbiAqIGltcG9ydCB7IHZhbGlkYXRlIH0gZnJvbSBcImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAkU1REX1ZFUlNJT04vdXVpZC92NC50c1wiO1xuICogaW1wb3J0IHsgZ2VuZXJhdGUgYXMgZ2VuZXJhdGVWMSB9IGZyb20gXCJodHRwczovL2Rlbm8ubGFuZC9zdGRAJFNURF9WRVJTSU9OL3V1aWQvdjEudHNcIjtcbiAqXG4gKiB2YWxpZGF0ZShjcnlwdG8ucmFuZG9tVVVJRCgpKTsgLy8gdHJ1ZVxuICogdmFsaWRhdGUoZ2VuZXJhdGVWMSgpIGFzIHN0cmluZyk7IC8vIGZhbHNlXG4gKiB2YWxpZGF0ZShcInRoaXMtaXMtbm90LWEtdXVpZFwiKTsgLy8gZmFsc2VcbiAqIGBgYFxuICovXG5leHBvcnQgZnVuY3Rpb24gdmFsaWRhdGUoaWQ6IHN0cmluZyk6IGJvb2xlYW4ge1xuICByZXR1cm4gVVVJRF9SRS50ZXN0KGlkKTtcbn1cbiJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSwwRUFBMEU7QUFDMUUscUNBQXFDO0FBRXJDLE1BQU0sVUFDSjtBQUVGOzs7Ozs7Ozs7OztDQVdDLEdBQ0QsT0FBTyxTQUFTLFNBQVMsRUFBVSxFQUFXO0lBQzVDLE9BQU8sUUFBUSxJQUFJLENBQUM7QUFDdEIsQ0FBQyJ9