// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/** Get log level numeric values through enum constants */ export var LogLevels;
(function(LogLevels) {
    LogLevels[LogLevels["NOTSET"] = 0] = "NOTSET";
    LogLevels[LogLevels["DEBUG"] = 10] = "DEBUG";
    LogLevels[LogLevels["INFO"] = 20] = "INFO";
    LogLevels[LogLevels["WARNING"] = 30] = "WARNING";
    LogLevels[LogLevels["ERROR"] = 40] = "ERROR";
    LogLevels[LogLevels["CRITICAL"] = 50] = "CRITICAL";
})(LogLevels || (LogLevels = {}));
/** Permitted log level names */ export const LogLevelNames = Object.keys(LogLevels).filter((key)=>isNaN(Number(key)));
const byLevel = {
    [String(LogLevels.NOTSET)]: "NOTSET",
    [String(LogLevels.DEBUG)]: "DEBUG",
    [String(LogLevels.INFO)]: "INFO",
    [String(LogLevels.WARNING)]: "WARNING",
    [String(LogLevels.ERROR)]: "ERROR",
    [String(LogLevels.CRITICAL)]: "CRITICAL"
};
/** Returns the numeric log level associated with the passed,
 * stringy log level name.
 */ export function getLevelByName(name) {
    switch(name){
        case "NOTSET":
            return LogLevels.NOTSET;
        case "DEBUG":
            return LogLevels.DEBUG;
        case "INFO":
            return LogLevels.INFO;
        case "WARNING":
            return LogLevels.WARNING;
        case "ERROR":
            return LogLevels.ERROR;
        case "CRITICAL":
            return LogLevels.CRITICAL;
        default:
            throw new Error(`no log level found for "${name}"`);
    }
}
/** Returns the stringy log level name provided the numeric log level */ export function getLevelName(level) {
    const levelName = byLevel[level];
    if (levelName) {
        return levelName;
    }
    throw new Error(`no level name found for level: ${level}`);
}
//# sourceMappingURL=data:application/json;base64,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