// Copyright 2014-2021 Sindre Sorhus. All rights reserved. MIT license.
// Copyright 2021 Yoshiya Hinosawa. All rights reserved. MIT license.
// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
/** Pretty print bytes.
 *
 * Based on [pretty-bytes](https://github.com/sindresorhus/pretty-bytes).
 *
 * This module is browser compatible.
 *
 * @module
 */ /**
 * @deprecated (will be removed after 0.170.0) use `format` instead
 */ export function prettyBytes(num, options = {}) {
    return format(num, options);
}
/**
 * Convert bytes to a human readable string: 1337 → 1.34 kB
 *
 * @param num The number to format
 * @param options The options
 */ export function format(num, options = {}) {
    if (!Number.isFinite(num)) {
        throw new TypeError(`Expected a finite number, got ${typeof num}: ${num}`);
    }
    const UNITS_FIRSTLETTER = (options.bits ? "b" : "B") + "kMGTPEZY";
    if (options.signed && num === 0) {
        return ` 0 ${UNITS_FIRSTLETTER[0]}`;
    }
    const prefix = num < 0 ? "-" : options.signed ? "+" : "";
    num = Math.abs(num);
    const localeOptions = getLocaleOptions(options);
    if (num < 1) {
        const numberString = toLocaleString(num, options.locale, localeOptions);
        return prefix + numberString + " " + UNITS_FIRSTLETTER[0];
    }
    const exponent = Math.min(Math.floor(options.binary ? Math.log(num) / Math.log(1024) : Math.log10(num) / 3), UNITS_FIRSTLETTER.length - 1);
    num /= Math.pow(options.binary ? 1024 : 1000, exponent);
    if (!localeOptions) {
        num = Number(num.toPrecision(3));
    }
    const numberString1 = toLocaleString(num, options.locale, localeOptions);
    let unit = UNITS_FIRSTLETTER[exponent];
    if (exponent > 0) {
        unit += options.binary ? "i" : "";
        unit += options.bits ? "bit" : "B";
    }
    return prefix + numberString1 + " " + unit;
}
function getLocaleOptions({ maximumFractionDigits , minimumFractionDigits  }) {
    if (maximumFractionDigits || minimumFractionDigits) {
        return {
            maximumFractionDigits,
            minimumFractionDigits
        };
    }
}
/**
 * Formats the given number using `Number#toLocaleString`.
 * - If locale is a string, the value is expected to be a locale-key (for example: `de`).
 * - If locale is true, the system default locale is used for translation.
 * - If no value for locale is specified, the number is returned unmodified.
 */ function toLocaleString(num, locale, options) {
    if (typeof locale === "string" || Array.isArray(locale)) {
        return num.toLocaleString(locale, options);
    } else if (locale === true || options !== undefined) {
        return num.toLocaleString(undefined, options);
    }
    return num.toString();
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjE2Ni4wL2ZtdC9ieXRlcy50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgMjAxNC0yMDIxIFNpbmRyZSBTb3JodXMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuLy8gQ29weXJpZ2h0IDIwMjEgWW9zaGl5YSBIaW5vc2F3YS4gQWxsIHJpZ2h0cyByZXNlcnZlZC4gTUlUIGxpY2Vuc2UuXG4vLyBDb3B5cmlnaHQgMjAxOC0yMDIyIHRoZSBEZW5vIGF1dGhvcnMuIEFsbCByaWdodHMgcmVzZXJ2ZWQuIE1JVCBsaWNlbnNlLlxuXG4vKiogUHJldHR5IHByaW50IGJ5dGVzLlxuICpcbiAqIEJhc2VkIG9uIFtwcmV0dHktYnl0ZXNdKGh0dHBzOi8vZ2l0aHViLmNvbS9zaW5kcmVzb3JodXMvcHJldHR5LWJ5dGVzKS5cbiAqXG4gKiBUaGlzIG1vZHVsZSBpcyBicm93c2VyIGNvbXBhdGlibGUuXG4gKlxuICogQG1vZHVsZVxuICovXG5cbnR5cGUgTG9jYWxlT3B0aW9ucyA9IHtcbiAgbWluaW11bUZyYWN0aW9uRGlnaXRzPzogbnVtYmVyO1xuICBtYXhpbXVtRnJhY3Rpb25EaWdpdHM/OiBudW1iZXI7XG59O1xuXG4vKipcbiAqIEBkZXByZWNhdGVkICh3aWxsIGJlIHJlbW92ZWQgYWZ0ZXIgMC4xNzAuMCkgdXNlIGBGb3JtYXRPcHRpb25zYCBpbnN0ZWFkXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUHJldHR5Qnl0ZXNPcHRpb25zIHtcbiAgLyoqIFVzZXMgYml0cyByZXByZXNlbnRhdGlvbi4gRGVmYXVsdCBpcyBmYWxzZS4gKi9cbiAgYml0cz86IGJvb2xlYW47XG4gIC8qKiBVc2VzIGJpbmFyeSBieXRlcyAoZS5nLiBraWJpYnl0ZSkuIERlZmF1bHQgaXMgZmFsc2UuICovXG4gIGJpbmFyeT86IGJvb2xlYW47XG4gIC8qKiBJbmNsdWRlIHBsdXMgc2lnbiBmb3IgcG9zaXRpdmUgbnVtYmVycy4gKi9cbiAgc2lnbmVkPzogYm9vbGVhbjtcbiAgLyoqIFVzZXMgbG9jYWxpemVkIG51bWJlciBmb3JtYXR0aW5nLiBJZiBpdCBpcyBzZXQgdG8gdHJ1ZSwgdXNlcyBkZWZhdWx0IGxvY2FsZSBvbiB0aGUgc3lzdGVtLiBJZiBpdCdzIHNldCB0byBzdHJpbmcsIHVzZXMgdGhhdCBsb2NhbGUuIFRoZSBnaXZlbiBzdHJpbmcgc2hvdWxkIGJlIEJDUCA0NyBsYW5ndWFnZSB0YWcgKHJlZjogaHR0cHM6Ly9lbi53aWtpcGVkaWEub3JnL3dpa2kvSUVURl9sYW5ndWFnZV90YWcpLiBZb3UgY2FuIGFsc28gZ2l2ZSB0aGUgbGlzdCBvZiBsYW5ndWFnZSB0YWdzLiAqL1xuICBsb2NhbGU/OiBib29sZWFuIHwgc3RyaW5nIHwgc3RyaW5nW107XG4gIC8qKiBUaGUgbWluaW11bSBudW1iZXIgb2YgZnJhY3Rpb24gZGlnaXRzIHRvIGRpc3BsYXkuIElmIG5laXRoZXIgbWluaW11bUZyYWN0aW9uRGlnaXRzIG9yIG1heGltdW1GcmFjdGlvbkRpZ2l0cyBhcmUgc2V0LCB0aGUgZGVmYXVsdCBiZWhhdmlvciBpcyB0byByb3VuZCB0byAzIHNpZ25pZmljYW50IGRpZ2l0cy4gKi9cbiAgbWluaW11bUZyYWN0aW9uRGlnaXRzPzogbnVtYmVyO1xuICAvKiogVGhlIG1heGltdW0gbnVtYmVyIG9mIGZyYWN0aW9uIGRpZ2l0cyB0byBkaXNwbGF5LiBJZiBuZWl0aGVyIG1pbmltdW1GcmFjdGlvbkRpZ2l0cyBvciBtYXhpbXVtRnJhY3Rpb25EaWdpdHMgYXJlIHNldCwgdGhlIGRlZmF1bHQgYmVoYXZpb3IgaXMgdG8gcm91bmQgdG8gMyBzaWduaWZpY2FudCBkaWdpdHMuICovXG4gIG1heGltdW1GcmFjdGlvbkRpZ2l0cz86IG51bWJlcjtcbn1cbi8qKlxuICogVGhlIG9wdGlvbnMgZm9yIHByZXR0eSBwcmludGluZyB0aGUgYnl0ZSBudW1iZXJzLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIEZvcm1hdE9wdGlvbnMge1xuICAvKiogVXNlcyBiaXRzIHJlcHJlc2VudGF0aW9uLiBEZWZhdWx0IGlzIGZhbHNlLiAqL1xuICBiaXRzPzogYm9vbGVhbjtcbiAgLyoqIFVzZXMgYmluYXJ5IGJ5dGVzIChlLmcuIGtpYmlieXRlKS4gRGVmYXVsdCBpcyBmYWxzZS4gKi9cbiAgYmluYXJ5PzogYm9vbGVhbjtcbiAgLyoqIEluY2x1ZGUgcGx1cyBzaWduIGZvciBwb3NpdGl2ZSBudW1iZXJzLiAqL1xuICBzaWduZWQ/OiBib29sZWFuO1xuICAvKiogVXNlcyBsb2NhbGl6ZWQgbnVtYmVyIGZvcm1hdHRpbmcuIElmIGl0IGlzIHNldCB0byB0cnVlLCB1c2VzIGRlZmF1bHQgbG9jYWxlIG9uIHRoZSBzeXN0ZW0uIElmIGl0J3Mgc2V0IHRvIHN0cmluZywgdXNlcyB0aGF0IGxvY2FsZS4gVGhlIGdpdmVuIHN0cmluZyBzaG91bGQgYmUgQkNQIDQ3IGxhbmd1YWdlIHRhZyAocmVmOiBodHRwczovL2VuLndpa2lwZWRpYS5vcmcvd2lraS9JRVRGX2xhbmd1YWdlX3RhZykuIFlvdSBjYW4gYWxzbyBnaXZlIHRoZSBsaXN0IG9mIGxhbmd1YWdlIHRhZ3MuICovXG4gIGxvY2FsZT86IGJvb2xlYW4gfCBzdHJpbmcgfCBzdHJpbmdbXTtcbiAgLyoqIFRoZSBtaW5pbXVtIG51bWJlciBvZiBmcmFjdGlvbiBkaWdpdHMgdG8gZGlzcGxheS4gSWYgbmVpdGhlciBtaW5pbXVtRnJhY3Rpb25EaWdpdHMgb3IgbWF4aW11bUZyYWN0aW9uRGlnaXRzIGFyZSBzZXQsIHRoZSBkZWZhdWx0IGJlaGF2aW9yIGlzIHRvIHJvdW5kIHRvIDMgc2lnbmlmaWNhbnQgZGlnaXRzLiAqL1xuICBtaW5pbXVtRnJhY3Rpb25EaWdpdHM/OiBudW1iZXI7XG4gIC8qKiBUaGUgbWF4aW11bSBudW1iZXIgb2YgZnJhY3Rpb24gZGlnaXRzIHRvIGRpc3BsYXkuIElmIG5laXRoZXIgbWluaW11bUZyYWN0aW9uRGlnaXRzIG9yIG1heGltdW1GcmFjdGlvbkRpZ2l0cyBhcmUgc2V0LCB0aGUgZGVmYXVsdCBiZWhhdmlvciBpcyB0byByb3VuZCB0byAzIHNpZ25pZmljYW50IGRpZ2l0cy4gKi9cbiAgbWF4aW11bUZyYWN0aW9uRGlnaXRzPzogbnVtYmVyO1xufVxuXG4vKipcbiAqIEBkZXByZWNhdGVkICh3aWxsIGJlIHJlbW92ZWQgYWZ0ZXIgMC4xNzAuMCkgdXNlIGBmb3JtYXRgIGluc3RlYWRcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHByZXR0eUJ5dGVzKG51bTogbnVtYmVyLCBvcHRpb25zOiBGb3JtYXRPcHRpb25zID0ge30pIHtcbiAgcmV0dXJuIGZvcm1hdChudW0sIG9wdGlvbnMpO1xufVxuXG4vKipcbiAqIENvbnZlcnQgYnl0ZXMgdG8gYSBodW1hbiByZWFkYWJsZSBzdHJpbmc6IDEzMzcg4oaSIDEuMzQga0JcbiAqXG4gKiBAcGFyYW0gbnVtIFRoZSBudW1iZXIgdG8gZm9ybWF0XG4gKiBAcGFyYW0gb3B0aW9ucyBUaGUgb3B0aW9uc1xuICovXG5leHBvcnQgZnVuY3Rpb24gZm9ybWF0KFxuICBudW06IG51bWJlcixcbiAgb3B0aW9uczogRm9ybWF0T3B0aW9ucyA9IHt9LFxuKTogc3RyaW5nIHtcbiAgaWYgKCFOdW1iZXIuaXNGaW5pdGUobnVtKSkge1xuICAgIHRocm93IG5ldyBUeXBlRXJyb3IoYEV4cGVjdGVkIGEgZmluaXRlIG51bWJlciwgZ290ICR7dHlwZW9mIG51bX06ICR7bnVtfWApO1xuICB9XG5cbiAgY29uc3QgVU5JVFNfRklSU1RMRVRURVIgPSAob3B0aW9ucy5iaXRzID8gXCJiXCIgOiBcIkJcIikgKyBcImtNR1RQRVpZXCI7XG5cbiAgaWYgKG9wdGlvbnMuc2lnbmVkICYmIG51bSA9PT0gMCkge1xuICAgIHJldHVybiBgIDAgJHtVTklUU19GSVJTVExFVFRFUlswXX1gO1xuICB9XG5cbiAgY29uc3QgcHJlZml4ID0gbnVtIDwgMCA/IFwiLVwiIDogKG9wdGlvbnMuc2lnbmVkID8gXCIrXCIgOiBcIlwiKTtcbiAgbnVtID0gTWF0aC5hYnMobnVtKTtcblxuICBjb25zdCBsb2NhbGVPcHRpb25zID0gZ2V0TG9jYWxlT3B0aW9ucyhvcHRpb25zKTtcblxuICBpZiAobnVtIDwgMSkge1xuICAgIGNvbnN0IG51bWJlclN0cmluZyA9IHRvTG9jYWxlU3RyaW5nKG51bSwgb3B0aW9ucy5sb2NhbGUsIGxvY2FsZU9wdGlvbnMpO1xuICAgIHJldHVybiBwcmVmaXggKyBudW1iZXJTdHJpbmcgKyBcIiBcIiArIFVOSVRTX0ZJUlNUTEVUVEVSWzBdO1xuICB9XG5cbiAgY29uc3QgZXhwb25lbnQgPSBNYXRoLm1pbihcbiAgICBNYXRoLmZsb29yKFxuICAgICAgb3B0aW9ucy5iaW5hcnkgPyBNYXRoLmxvZyhudW0pIC8gTWF0aC5sb2coMTAyNCkgOiBNYXRoLmxvZzEwKG51bSkgLyAzLFxuICAgICksXG4gICAgVU5JVFNfRklSU1RMRVRURVIubGVuZ3RoIC0gMSxcbiAgKTtcbiAgbnVtIC89IE1hdGgucG93KG9wdGlvbnMuYmluYXJ5ID8gMTAyNCA6IDEwMDAsIGV4cG9uZW50KTtcblxuICBpZiAoIWxvY2FsZU9wdGlvbnMpIHtcbiAgICBudW0gPSBOdW1iZXIobnVtLnRvUHJlY2lzaW9uKDMpKTtcbiAgfVxuXG4gIGNvbnN0IG51bWJlclN0cmluZyA9IHRvTG9jYWxlU3RyaW5nKFxuICAgIG51bSxcbiAgICBvcHRpb25zLmxvY2FsZSxcbiAgICBsb2NhbGVPcHRpb25zLFxuICApO1xuXG4gIGxldCB1bml0ID0gVU5JVFNfRklSU1RMRVRURVJbZXhwb25lbnRdO1xuICBpZiAoZXhwb25lbnQgPiAwKSB7XG4gICAgdW5pdCArPSBvcHRpb25zLmJpbmFyeSA/IFwiaVwiIDogXCJcIjtcbiAgICB1bml0ICs9IG9wdGlvbnMuYml0cyA/IFwiYml0XCIgOiBcIkJcIjtcbiAgfVxuXG4gIHJldHVybiBwcmVmaXggKyBudW1iZXJTdHJpbmcgKyBcIiBcIiArIHVuaXQ7XG59XG5cbmZ1bmN0aW9uIGdldExvY2FsZU9wdGlvbnMoXG4gIHsgbWF4aW11bUZyYWN0aW9uRGlnaXRzLCBtaW5pbXVtRnJhY3Rpb25EaWdpdHMgfTogRm9ybWF0T3B0aW9ucyxcbik6IExvY2FsZU9wdGlvbnMgfCB1bmRlZmluZWQge1xuICBpZiAobWF4aW11bUZyYWN0aW9uRGlnaXRzIHx8IG1pbmltdW1GcmFjdGlvbkRpZ2l0cykge1xuICAgIHJldHVybiB7XG4gICAgICBtYXhpbXVtRnJhY3Rpb25EaWdpdHMsXG4gICAgICBtaW5pbXVtRnJhY3Rpb25EaWdpdHMsXG4gICAgfTtcbiAgfVxufVxuXG4vKipcbiAqIEZvcm1hdHMgdGhlIGdpdmVuIG51bWJlciB1c2luZyBgTnVtYmVyI3RvTG9jYWxlU3RyaW5nYC5cbiAqIC0gSWYgbG9jYWxlIGlzIGEgc3RyaW5nLCB0aGUgdmFsdWUgaXMgZXhwZWN0ZWQgdG8gYmUgYSBsb2NhbGUta2V5IChmb3IgZXhhbXBsZTogYGRlYCkuXG4gKiAtIElmIGxvY2FsZSBpcyB0cnVlLCB0aGUgc3lzdGVtIGRlZmF1bHQgbG9jYWxlIGlzIHVzZWQgZm9yIHRyYW5zbGF0aW9uLlxuICogLSBJZiBubyB2YWx1ZSBmb3IgbG9jYWxlIGlzIHNwZWNpZmllZCwgdGhlIG51bWJlciBpcyByZXR1cm5lZCB1bm1vZGlmaWVkLlxuICovXG5mdW5jdGlvbiB0b0xvY2FsZVN0cmluZyhcbiAgbnVtOiBudW1iZXIsXG4gIGxvY2FsZTogYm9vbGVhbiB8IHN0cmluZyB8IHN0cmluZ1tdIHwgdW5kZWZpbmVkLFxuICBvcHRpb25zOiBMb2NhbGVPcHRpb25zIHwgdW5kZWZpbmVkLFxuKTogc3RyaW5nIHtcbiAgaWYgKHR5cGVvZiBsb2NhbGUgPT09IFwic3RyaW5nXCIgfHwgQXJyYXkuaXNBcnJheShsb2NhbGUpKSB7XG4gICAgcmV0dXJuIG51bS50b0xvY2FsZVN0cmluZyhsb2NhbGUsIG9wdGlvbnMpO1xuICB9IGVsc2UgaWYgKGxvY2FsZSA9PT0gdHJ1ZSB8fCBvcHRpb25zICE9PSB1bmRlZmluZWQpIHtcbiAgICByZXR1cm4gbnVtLnRvTG9jYWxlU3RyaW5nKHVuZGVmaW5lZCwgb3B0aW9ucyk7XG4gIH1cblxuICByZXR1cm4gbnVtLnRvU3RyaW5nKCk7XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsdUVBQXVFO0FBQ3ZFLHFFQUFxRTtBQUNyRSwwRUFBMEU7QUFFMUU7Ozs7Ozs7Q0FPQyxHQUVELEFBd0NBOztDQUVDLEdBQ0QsT0FBTyxTQUFTLFlBQVksR0FBVyxFQUFFLFVBQXlCLENBQUMsQ0FBQyxFQUFFO0lBQ3BFLE9BQU8sT0FBTyxLQUFLO0FBQ3JCLENBQUM7QUFFRDs7Ozs7Q0FLQyxHQUNELE9BQU8sU0FBUyxPQUNkLEdBQVcsRUFDWCxVQUF5QixDQUFDLENBQUMsRUFDbkI7SUFDUixJQUFJLENBQUMsT0FBTyxRQUFRLENBQUMsTUFBTTtRQUN6QixNQUFNLElBQUksVUFBVSxDQUFDLDhCQUE4QixFQUFFLE9BQU8sSUFBSSxFQUFFLEVBQUUsSUFBSSxDQUFDLEVBQUU7SUFDN0UsQ0FBQztJQUVELE1BQU0sb0JBQW9CLENBQUMsUUFBUSxJQUFJLEdBQUcsTUFBTSxHQUFHLElBQUk7SUFFdkQsSUFBSSxRQUFRLE1BQU0sSUFBSSxRQUFRLEdBQUc7UUFDL0IsT0FBTyxDQUFDLEdBQUcsRUFBRSxpQkFBaUIsQ0FBQyxFQUFFLENBQUMsQ0FBQztJQUNyQyxDQUFDO0lBRUQsTUFBTSxTQUFTLE1BQU0sSUFBSSxNQUFPLFFBQVEsTUFBTSxHQUFHLE1BQU0sRUFBRSxBQUFDO0lBQzFELE1BQU0sS0FBSyxHQUFHLENBQUM7SUFFZixNQUFNLGdCQUFnQixpQkFBaUI7SUFFdkMsSUFBSSxNQUFNLEdBQUc7UUFDWCxNQUFNLGVBQWUsZUFBZSxLQUFLLFFBQVEsTUFBTSxFQUFFO1FBQ3pELE9BQU8sU0FBUyxlQUFlLE1BQU0saUJBQWlCLENBQUMsRUFBRTtJQUMzRCxDQUFDO0lBRUQsTUFBTSxXQUFXLEtBQUssR0FBRyxDQUN2QixLQUFLLEtBQUssQ0FDUixRQUFRLE1BQU0sR0FBRyxLQUFLLEdBQUcsQ0FBQyxPQUFPLEtBQUssR0FBRyxDQUFDLFFBQVEsS0FBSyxLQUFLLENBQUMsT0FBTyxDQUFDLEdBRXZFLGtCQUFrQixNQUFNLEdBQUc7SUFFN0IsT0FBTyxLQUFLLEdBQUcsQ0FBQyxRQUFRLE1BQU0sR0FBRyxPQUFPLElBQUksRUFBRTtJQUU5QyxJQUFJLENBQUMsZUFBZTtRQUNsQixNQUFNLE9BQU8sSUFBSSxXQUFXLENBQUM7SUFDL0IsQ0FBQztJQUVELE1BQU0sZ0JBQWUsZUFDbkIsS0FDQSxRQUFRLE1BQU0sRUFDZDtJQUdGLElBQUksT0FBTyxpQkFBaUIsQ0FBQyxTQUFTO0lBQ3RDLElBQUksV0FBVyxHQUFHO1FBQ2hCLFFBQVEsUUFBUSxNQUFNLEdBQUcsTUFBTSxFQUFFO1FBQ2pDLFFBQVEsUUFBUSxJQUFJLEdBQUcsUUFBUSxHQUFHO0lBQ3BDLENBQUM7SUFFRCxPQUFPLFNBQVMsZ0JBQWUsTUFBTTtBQUN2QyxDQUFDO0FBRUQsU0FBUyxpQkFDUCxFQUFFLHNCQUFxQixFQUFFLHNCQUFxQixFQUFpQixFQUNwQztJQUMzQixJQUFJLHlCQUF5Qix1QkFBdUI7UUFDbEQsT0FBTztZQUNMO1lBQ0E7UUFDRjtJQUNGLENBQUM7QUFDSDtBQUVBOzs7OztDQUtDLEdBQ0QsU0FBUyxlQUNQLEdBQVcsRUFDWCxNQUErQyxFQUMvQyxPQUFrQyxFQUMxQjtJQUNSLElBQUksT0FBTyxXQUFXLFlBQVksTUFBTSxPQUFPLENBQUMsU0FBUztRQUN2RCxPQUFPLElBQUksY0FBYyxDQUFDLFFBQVE7SUFDcEMsT0FBTyxJQUFJLFdBQVcsSUFBSSxJQUFJLFlBQVksV0FBVztRQUNuRCxPQUFPLElBQUksY0FBYyxDQUFDLFdBQVc7SUFDdkMsQ0FBQztJQUVELE9BQU8sSUFBSSxRQUFRO0FBQ3JCIn0=