/* ***** BEGIN LICENSE BLOCK *****
 * Distributed under the BSD license:
 *
 * Copyright (c) 2010, Ajax.org B.V.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Ajax.org B.V. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL AJAX.ORG B.V. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * Define a module along with a payload
 * @param module a name for the payload
 * @param payload a function to call with (require, exports, module) params
 */

(function() {

var ACE_NAMESPACE = "";

var global = (function() { return this; })();
if (!global && typeof window != "undefined") global = window; // strict mode


if (!ACE_NAMESPACE && typeof requirejs !== "undefined")
    return;


var define = function(module, deps, payload) {
    if (typeof module !== "string") {
        if (define.original)
            define.original.apply(this, arguments);
        else {
            console.error("dropping module because define wasn\'t a string.");
            console.trace();
        }
        return;
    }
    if (arguments.length == 2)
        payload = deps;
    if (!define.modules[module]) {
        define.payloads[module] = payload;
        define.modules[module] = null;
    }
};

define.modules = {};
define.payloads = {};

/**
 * Get at functionality define()ed using the function above
 */
var _require = function(parentId, module, callback) {
    if (typeof module === "string") {
        var payload = lookup(parentId, module);
        if (payload != undefined) {
            callback && callback();
            return payload;
        }
    } else if (Object.prototype.toString.call(module) === "[object Array]") {
        var params = [];
        for (var i = 0, l = module.length; i < l; ++i) {
            var dep = lookup(parentId, module[i]);
            if (dep == undefined && require.original)
                return;
            params.push(dep);
        }
        return callback && callback.apply(null, params) || true;
    }
};

var require = function(module, callback) {
    var packagedModule = _require("", module, callback);
    if (packagedModule == undefined && require.original)
        return require.original.apply(this, arguments);
    return packagedModule;
};

var normalizeModule = function(parentId, moduleName) {
    // normalize plugin requires
    if (moduleName.indexOf("!") !== -1) {
        var chunks = moduleName.split("!");
        return normalizeModule(parentId, chunks[0]) + "!" + normalizeModule(parentId, chunks[1]);
    }
    // normalize relative requires
    if (moduleName.charAt(0) == ".") {
        var base = parentId.split("/").slice(0, -1).join("/");
        moduleName = base + "/" + moduleName;

        while(moduleName.indexOf(".") !== -1 && previous != moduleName) {
            var previous = moduleName;
            moduleName = moduleName.replace(/\/\.\//, "/").replace(/[^\/]+\/\.\.\//, "");
        }
    }
    return moduleName;
};

/**
 * Internal function to lookup moduleNames and resolve them by calling the
 * definition function if needed.
 */
var lookup = function(parentId, moduleName) {
    moduleName = normalizeModule(parentId, moduleName);

    var module = define.modules[moduleName];
    if (!module) {
        module = define.payloads[moduleName];
        if (typeof module === 'function') {
            var exports = {};
            var mod = {
                id: moduleName,
                uri: '',
                exports: exports,
                packaged: true
            };

            var req = function(module, callback) {
                return _require(moduleName, module, callback);
            };

            var returnValue = module(req, exports, mod);
            exports = returnValue || mod.exports;
            define.modules[moduleName] = exports;
            delete define.payloads[moduleName];
        }
        module = define.modules[moduleName] = exports || module;
    }
    return module;
};

function exportAce(ns) {
    var root = global;
    if (ns) {
        if (!global[ns])
            global[ns] = {};
        root = global[ns];
    }

    if (!root.define || !root.define.packaged) {
        define.original = root.define;
        root.define = define;
        root.define.packaged = true;
    }

    if (!root.require || !root.require.packaged) {
        require.original = root.require;
        root.require = require;
        root.require.packaged = true;
    }
}

exportAce(ACE_NAMESPACE);

})();

define("ace/lib/es6-shim",["require","exports","module"], function(require, exports, module){function defineProp(obj, name, val) {
    Object.defineProperty(obj, name, {
        value: val,
        enumerable: false,
        writable: true,
        configurable: true
    });
}
if (!String.prototype.startsWith) {
    defineProp(String.prototype, "startsWith", function (searchString, position) {
        position = position || 0;
        return this.lastIndexOf(searchString, position) === position;
    });
}
if (!String.prototype.endsWith) {
    defineProp(String.prototype, "endsWith", function (searchString, position) {
        var subjectString = this;
        if (position === undefined || position > subjectString.length) {
            position = subjectString.length;
        }
        position -= searchString.length;
        var lastIndex = subjectString.indexOf(searchString, position);
        return lastIndex !== -1 && lastIndex === position;
    });
}
if (!String.prototype.repeat) {
    defineProp(String.prototype, "repeat", function (count) {
        var result = "";
        var string = this;
        while (count > 0) {
            if (count & 1)
                result += string;
            if ((count >>= 1))
                string += string;
        }
        return result;
    });
}
if (!String.prototype.includes) {
    defineProp(String.prototype, "includes", function (str, position) {
        return this.indexOf(str, position) != -1;
    });
}
if (!Object.assign) {
    Object.assign = function (target) {
        if (target === undefined || target === null) {
            throw new TypeError("Cannot convert undefined or null to object");
        }
        var output = Object(target);
        for (var index = 1; index < arguments.length; index++) {
            var source = arguments[index];
            if (source !== undefined && source !== null) {
                Object.keys(source).forEach(function (key) {
                    output[key] = source[key];
                });
            }
        }
        return output;
    };
}
if (!Object.values) {
    Object.values = function (o) {
        return Object.keys(o).map(function (k) {
            return o[k];
        });
    };
}
if (!Array.prototype.find) {
    defineProp(Array.prototype, "find", function (predicate) {
        var len = this.length;
        var thisArg = arguments[1];
        for (var k = 0; k < len; k++) {
            var kValue = this[k];
            if (predicate.call(thisArg, kValue, k, this)) {
                return kValue;
            }
        }
    });
}
if (!Array.prototype.findIndex) {
    defineProp(Array.prototype, "findIndex", function (predicate) {
        var len = this.length;
        var thisArg = arguments[1];
        for (var k = 0; k < len; k++) {
            var kValue = this[k];
            if (predicate.call(thisArg, kValue, k, this)) {
                return k;
            }
        }
    });
}
if (!Array.prototype.includes) {
    defineProp(Array.prototype, "includes", function (item, position) {
        return this.indexOf(item, position) != -1;
    });
}
if (!Array.prototype.fill) {
    defineProp(Array.prototype, "fill", function (value) {
        var O = this;
        var len = O.length >>> 0;
        var start = arguments[1];
        var relativeStart = start >> 0;
        var k = relativeStart < 0
            ? Math.max(len + relativeStart, 0)
            : Math.min(relativeStart, len);
        var end = arguments[2];
        var relativeEnd = end === undefined ? len : end >> 0;
        var final = relativeEnd < 0
            ? Math.max(len + relativeEnd, 0)
            : Math.min(relativeEnd, len);
        while (k < final) {
            O[k] = value;
            k++;
        }
        return O;
    });
}
if (!Array.of) {
    defineProp(Array, "of", function () {
        return Array.prototype.slice.call(arguments);
    });
}

});

define("ace/lib/fixoldbrowsers",["require","exports","module","ace/lib/es6-shim"], function(require, exports, module){// vim:set ts=4 sts=4 sw=4 st:
"use strict";
require("./es6-shim");

});

define("ace/lib/deep_copy",["require","exports","module"], function(require, exports, module){exports.deepCopy = function deepCopy(obj) {
    if (typeof obj !== "object" || !obj)
        return obj;
    var copy;
    if (Array.isArray(obj)) {
        copy = [];
        for (var key = 0; key < obj.length; key++) {
            copy[key] = deepCopy(obj[key]);
        }
        return copy;
    }
    if (Object.prototype.toString.call(obj) !== "[object Object]")
        return obj;
    copy = {};
    for (var key in obj)
        copy[key] = deepCopy(obj[key]);
    return copy;
};

});

define("ace/lib/lang",["require","exports","module","ace/lib/deep_copy"], function(require, exports, module){"use strict";
exports.last = function (a) {
    return a[a.length - 1];
};
exports.stringReverse = function (string) {
    return string.split("").reverse().join("");
};
exports.stringRepeat = function (string, count) {
    var result = '';
    while (count > 0) {
        if (count & 1)
            result += string;
        if (count >>= 1)
            string += string;
    }
    return result;
};
var trimBeginRegexp = /^\s\s*/;
var trimEndRegexp = /\s\s*$/;
exports.stringTrimLeft = function (string) {
    return string.replace(trimBeginRegexp, '');
};
exports.stringTrimRight = function (string) {
    return string.replace(trimEndRegexp, '');
};
exports.copyObject = function (obj) {
    var copy = {};
    for (var key in obj) {
        copy[key] = obj[key];
    }
    return copy;
};
exports.copyArray = function (array) {
    var copy = [];
    for (var i = 0, l = array.length; i < l; i++) {
        if (array[i] && typeof array[i] == "object")
            copy[i] = this.copyObject(array[i]);
        else
            copy[i] = array[i];
    }
    return copy;
};
exports.deepCopy = require("./deep_copy").deepCopy;
exports.arrayToMap = function (arr) {
    var map = {};
    for (var i = 0; i < arr.length; i++) {
        map[arr[i]] = 1;
    }
    return map;
};
exports.createMap = function (props) {
    var map = Object.create(null);
    for (var i in props) {
        map[i] = props[i];
    }
    return map;
};
exports.arrayRemove = function (array, value) {
    for (var i = 0; i <= array.length; i++) {
        if (value === array[i]) {
            array.splice(i, 1);
        }
    }
};
exports.escapeRegExp = function (str) {
    return str.replace(/([.*+?^${}()|[\]\/\\])/g, '\\$1');
};
exports.escapeHTML = function (str) {
    return ("" + str).replace(/&/g, "&#38;").replace(/"/g, "&#34;").replace(/'/g, "&#39;").replace(/</g, "&#60;");
};
exports.getMatchOffsets = function (string, regExp) {
    var matches = [];
    string.replace(regExp, function (str) {
        matches.push({
            offset: arguments[arguments.length - 2],
            length: str.length
        });
    });
    return matches;
};
exports.deferredCall = function (fcn) {
    var timer = null;
    var callback = function () {
        timer = null;
        fcn();
    };
    var deferred = function (timeout) {
        deferred.cancel();
        timer = setTimeout(callback, timeout || 0);
        return deferred;
    };
    deferred.schedule = deferred;
    deferred.call = function () {
        this.cancel();
        fcn();
        return deferred;
    };
    deferred.cancel = function () {
        clearTimeout(timer);
        timer = null;
        return deferred;
    };
    deferred.isPending = function () {
        return timer;
    };
    return deferred;
};
exports.delayedCall = function (fcn, defaultTimeout) {
    var timer = null;
    var callback = function () {
        timer = null;
        fcn();
    };
    var _self = function (timeout) {
        if (timer == null)
            timer = setTimeout(callback, timeout || defaultTimeout);
    };
    _self.delay = function (timeout) {
        timer && clearTimeout(timer);
        timer = setTimeout(callback, timeout || defaultTimeout);
    };
    _self.schedule = _self;
    _self.call = function () {
        this.cancel();
        fcn();
    };
    _self.cancel = function () {
        timer && clearTimeout(timer);
        timer = null;
    };
    _self.isPending = function () {
        return timer;
    };
    return _self;
};
exports.supportsLookbehind = function () {
    try {
        new RegExp('(?<=.)');
    }
    catch (e) {
        return false;
    }
    return true;
};
exports.supportsUnicodeFlag = function () {
    try {
        new RegExp('^.$', 'u');
    }
    catch (error) {
        return false;
    }
    return true;
};

});

define("ace/lib/useragent",["require","exports","module"], function(require, exports, module){"use strict";
exports.OS = {
    LINUX: "LINUX",
    MAC: "MAC",
    WINDOWS: "WINDOWS"
};
exports.getOS = function () {
    if (exports.isMac) {
        return exports.OS.MAC;
    }
    else if (exports.isLinux) {
        return exports.OS.LINUX;
    }
    else {
        return exports.OS.WINDOWS;
    }
};
var _navigator = typeof navigator == "object" ? navigator : {};
var os = (/mac|win|linux/i.exec(_navigator.platform) || ["other"])[0].toLowerCase();
var ua = _navigator.userAgent || "";
var appName = _navigator.appName || "";
exports.isWin = (os == "win");
exports.isMac = (os == "mac");
exports.isLinux = (os == "linux");
exports.isIE =
    (appName == "Microsoft Internet Explorer" || appName.indexOf("MSAppHost") >= 0)
        ? parseFloat((ua.match(/(?:MSIE |Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/) || [])[1])
        : parseFloat((ua.match(/(?:Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/) || [])[1]); // for ie
exports.isOldIE = exports.isIE && exports.isIE < 9;
exports.isGecko = exports.isMozilla = ua.match(/ Gecko\/\d+/);
exports.isOpera = typeof opera == "object" && Object.prototype.toString.call(window.opera) == "[object Opera]";
exports.isWebKit = parseFloat(ua.split("WebKit/")[1]) || undefined;
exports.isChrome = parseFloat(ua.split(" Chrome/")[1]) || undefined;
exports.isEdge = parseFloat(ua.split(" Edge/")[1]) || undefined;
exports.isAIR = ua.indexOf("AdobeAIR") >= 0;
exports.isAndroid = ua.indexOf("Android") >= 0;
exports.isChromeOS = ua.indexOf(" CrOS ") >= 0;
exports.isIOS = /iPad|iPhone|iPod/.test(ua) && !window.MSStream;
if (exports.isIOS)
    exports.isMac = true;
exports.isMobile = exports.isIOS || exports.isAndroid;

});

define("ace/lib/dom",["require","exports","module","ace/lib/useragent"], function(require, exports, module){"use strict";
var useragent = require("./useragent");
var XHTML_NS = "http://www.w3.org/1999/xhtml";
exports.buildDom = function buildDom(arr, parent, refs) {
    if (typeof arr == "string" && arr) {
        var txt = document.createTextNode(arr);
        if (parent)
            parent.appendChild(txt);
        return txt;
    }
    if (!Array.isArray(arr)) {
        if (arr && arr.appendChild && parent)
            parent.appendChild(arr);
        return arr;
    }
    if (typeof arr[0] != "string" || !arr[0]) {
        var els = [];
        for (var i = 0; i < arr.length; i++) {
            var ch = buildDom(arr[i], parent, refs);
            ch && els.push(ch);
        }
        return els;
    }
    var el = document.createElement(arr[0]);
    var options = arr[1];
    var childIndex = 1;
    if (options && typeof options == "object" && !Array.isArray(options))
        childIndex = 2;
    for (var i = childIndex; i < arr.length; i++)
        buildDom(arr[i], el, refs);
    if (childIndex == 2) {
        Object.keys(options).forEach(function (n) {
            var val = options[n];
            if (n === "class") {
                el.className = Array.isArray(val) ? val.join(" ") : val;
            }
            else if (typeof val == "function" || n == "value" || n[0] == "$") {
                el[n] = val;
            }
            else if (n === "ref") {
                if (refs)
                    refs[val] = el;
            }
            else if (n === "style") {
                if (typeof val == "string")
                    el.style.cssText = val;
            }
            else if (val != null) {
                el.setAttribute(n, val);
            }
        });
    }
    if (parent)
        parent.appendChild(el);
    return el;
};
exports.getDocumentHead = function (doc) {
    if (!doc)
        doc = document;
    return doc.head || doc.getElementsByTagName("head")[0] || doc.documentElement;
};
exports.createElement = function (tag, ns) {
    return document.createElementNS ?
        document.createElementNS(ns || XHTML_NS, tag) :
        document.createElement(tag);
};
exports.removeChildren = function (element) {
    element.innerHTML = "";
};
exports.createTextNode = function (textContent, element) {
    var doc = element ? element.ownerDocument : document;
    return doc.createTextNode(textContent);
};
exports.createFragment = function (element) {
    var doc = element ? element.ownerDocument : document;
    return doc.createDocumentFragment();
};
exports.hasCssClass = function (el, name) {
    var classes = (el.className + "").split(/\s+/g);
    return classes.indexOf(name) !== -1;
};
exports.addCssClass = function (el, name) {
    if (!exports.hasCssClass(el, name)) {
        el.className += " " + name;
    }
};
exports.removeCssClass = function (el, name) {
    var classes = el.className.split(/\s+/g);
    while (true) {
        var index = classes.indexOf(name);
        if (index == -1) {
            break;
        }
        classes.splice(index, 1);
    }
    el.className = classes.join(" ");
};
exports.toggleCssClass = function (el, name) {
    var classes = el.className.split(/\s+/g), add = true;
    while (true) {
        var index = classes.indexOf(name);
        if (index == -1) {
            break;
        }
        add = false;
        classes.splice(index, 1);
    }
    if (add)
        classes.push(name);
    el.className = classes.join(" ");
    return add;
};
exports.setCssClass = function (node, className, include) {
    if (include) {
        exports.addCssClass(node, className);
    }
    else {
        exports.removeCssClass(node, className);
    }
};
exports.hasCssString = function (id, doc) {
    var index = 0, sheets;
    doc = doc || document;
    if ((sheets = doc.querySelectorAll("style"))) {
        while (index < sheets.length) {
            if (sheets[index++].id === id) {
                return true;
            }
        }
    }
};
exports.removeElementById = function (id, doc) {
    doc = doc || document;
    if (doc.getElementById(id)) {
        doc.getElementById(id).remove();
    }
};
var strictCSP;
var cssCache = [];
exports.useStrictCSP = function (value) {
    strictCSP = value;
    if (value == false)
        insertPendingStyles();
    else if (!cssCache)
        cssCache = [];
};
function insertPendingStyles() {
    var cache = cssCache;
    cssCache = null;
    cache && cache.forEach(function (item) {
        importCssString(item[0], item[1]);
    });
}
function importCssString(cssText, id, target) {
    if (typeof document == "undefined")
        return;
    if (cssCache) {
        if (target) {
            insertPendingStyles();
        }
        else if (target === false) {
            return cssCache.push([cssText, id]);
        }
    }
    if (strictCSP)
        return;
    var container = target;
    if (!target || !target.getRootNode) {
        container = document;
    }
    else {
        container = target.getRootNode();
        if (!container || container == target)
            container = document;
    }
    var doc = container.ownerDocument || container;
    if (id && exports.hasCssString(id, container))
        return null;
    if (id)
        cssText += "\n/*# sourceURL=ace/css/" + id + " */";
    var style = exports.createElement("style");
    style.appendChild(doc.createTextNode(cssText));
    if (id)
        style.id = id;
    if (container == doc)
        container = exports.getDocumentHead(doc);
    container.insertBefore(style, container.firstChild);
}
exports.importCssString = importCssString;
exports.importCssStylsheet = function (uri, doc) {
    exports.buildDom(["link", { rel: "stylesheet", href: uri }], exports.getDocumentHead(doc));
};
exports.scrollbarWidth = function (doc) {
    var inner = exports.createElement("ace_inner");
    inner.style.width = "100%";
    inner.style.minWidth = "0px";
    inner.style.height = "200px";
    inner.style.display = "block";
    var outer = exports.createElement("ace_outer");
    var style = outer.style;
    style.position = "absolute";
    style.left = "-10000px";
    style.overflow = "hidden";
    style.width = "200px";
    style.minWidth = "0px";
    style.height = "150px";
    style.display = "block";
    outer.appendChild(inner);
    var body = (doc && doc.documentElement) || (document && document.documentElement);
    if (!body)
        return 0;
    body.appendChild(outer);
    var noScrollbar = inner.offsetWidth;
    style.overflow = "scroll";
    var withScrollbar = inner.offsetWidth;
    if (noScrollbar === withScrollbar) {
        withScrollbar = outer.clientWidth;
    }
    body.removeChild(outer);
    return noScrollbar - withScrollbar;
};
exports.computedStyle = function (element, style) {
    return window.getComputedStyle(element, "") || {};
};
exports.setStyle = function (styles, property, value) {
    if (styles[property] !== value) {
        styles[property] = value;
    }
};
exports.HAS_CSS_ANIMATION = false;
exports.HAS_CSS_TRANSFORMS = false;
exports.HI_DPI = useragent.isWin
    ? typeof window !== "undefined" && window.devicePixelRatio >= 1.5
    : true;
if (useragent.isChromeOS)
    exports.HI_DPI = false;
if (typeof document !== "undefined") {
    var div = document.createElement("div");
    if (exports.HI_DPI && div.style.transform !== undefined)
        exports.HAS_CSS_TRANSFORMS = true;
    if (!useragent.isEdge && typeof div.style.animationName !== "undefined")
        exports.HAS_CSS_ANIMATION = true;
    div = null;
}
if (exports.HAS_CSS_TRANSFORMS) {
    exports.translate = function (element, tx, ty) {
        element.style.transform = "translate(" + Math.round(tx) + "px, " + Math.round(ty) + "px)";
    };
}
else {
    exports.translate = function (element, tx, ty) {
        element.style.top = Math.round(ty) + "px";
        element.style.left = Math.round(tx) + "px";
    };
}

});

define("ace/lib/net",["require","exports","module","ace/lib/dom"], function(require, exports, module){/*
 * based on code from:
 *
 * @license RequireJS text 0.25.0 Copyright (c) 2010-2011, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/jrburke/requirejs for details
 */
"use strict";
var dom = require("./dom");
exports.get = function (url, callback) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, true);
    xhr.onreadystatechange = function () {
        if (xhr.readyState === 4) {
            callback(xhr.responseText);
        }
    };
    xhr.send(null);
};
exports.loadScript = function (path, callback) {
    var head = dom.getDocumentHead();
    var s = document.createElement('script');
    s.src = path;
    head.appendChild(s);
    s.onload = s.onreadystatechange = function (_, isAbort) {
        if (isAbort || !s.readyState || s.readyState == "loaded" || s.readyState == "complete") {
            s = s.onload = s.onreadystatechange = null;
            if (!isAbort)
                callback();
        }
    };
};
exports.qualifyURL = function (url) {
    var a = document.createElement('a');
    a.href = url;
    return a.href;
};

});

define("ace/lib/oop",["require","exports","module"], function(require, exports, module){"use strict";
exports.inherits = function (ctor, superCtor) {
    ctor.super_ = superCtor;
    ctor.prototype = Object.create(superCtor.prototype, {
        constructor: {
            value: ctor,
            enumerable: false,
            writable: true,
            configurable: true
        }
    });
};
exports.mixin = function (obj, mixin) {
    for (var key in mixin) {
        obj[key] = mixin[key];
    }
    return obj;
};
exports.implement = function (proto, mixin) {
    exports.mixin(proto, mixin);
};

});

define("ace/lib/event_emitter",["require","exports","module"], function(require, exports, module){"use strict";
var EventEmitter = {};
var stopPropagation = function () { this.propagationStopped = true; };
var preventDefault = function () { this.defaultPrevented = true; };
EventEmitter._emit =
    EventEmitter._dispatchEvent = function (eventName, e) {
        this._eventRegistry || (this._eventRegistry = {});
        this._defaultHandlers || (this._defaultHandlers = {});
        var listeners = this._eventRegistry[eventName] || [];
        var defaultHandler = this._defaultHandlers[eventName];
        if (!listeners.length && !defaultHandler)
            return;
        if (typeof e != "object" || !e)
            e = {};
        if (!e.type)
            e.type = eventName;
        if (!e.stopPropagation)
            e.stopPropagation = stopPropagation;
        if (!e.preventDefault)
            e.preventDefault = preventDefault;
        listeners = listeners.slice();
        for (var i = 0; i < listeners.length; i++) {
            listeners[i](e, this);
            if (e.propagationStopped)
                break;
        }
        if (defaultHandler && !e.defaultPrevented)
            return defaultHandler(e, this);
    };
EventEmitter._signal = function (eventName, e) {
    var listeners = (this._eventRegistry || {})[eventName];
    if (!listeners)
        return;
    listeners = listeners.slice();
    for (var i = 0; i < listeners.length; i++)
        listeners[i](e, this);
};
EventEmitter.once = function (eventName, callback) {
    var _self = this;
    this.on(eventName, function newCallback() {
        _self.off(eventName, newCallback);
        callback.apply(null, arguments);
    });
    if (!callback) {
        return new Promise(function (resolve) {
            callback = resolve;
        });
    }
};
EventEmitter.setDefaultHandler = function (eventName, callback) {
    var handlers = this._defaultHandlers;
    if (!handlers)
        handlers = this._defaultHandlers = { _disabled_: {} };
    if (handlers[eventName]) {
        var old = handlers[eventName];
        var disabled = handlers._disabled_[eventName];
        if (!disabled)
            handlers._disabled_[eventName] = disabled = [];
        disabled.push(old);
        var i = disabled.indexOf(callback);
        if (i != -1)
            disabled.splice(i, 1);
    }
    handlers[eventName] = callback;
};
EventEmitter.removeDefaultHandler = function (eventName, callback) {
    var handlers = this._defaultHandlers;
    if (!handlers)
        return;
    var disabled = handlers._disabled_[eventName];
    if (handlers[eventName] == callback) {
        if (disabled)
            this.setDefaultHandler(eventName, disabled.pop());
    }
    else if (disabled) {
        var i = disabled.indexOf(callback);
        if (i != -1)
            disabled.splice(i, 1);
    }
};
EventEmitter.on =
    EventEmitter.addEventListener = function (eventName, callback, capturing) {
        this._eventRegistry = this._eventRegistry || {};
        var listeners = this._eventRegistry[eventName];
        if (!listeners)
            listeners = this._eventRegistry[eventName] = [];
        if (listeners.indexOf(callback) == -1)
            listeners[capturing ? "unshift" : "push"](callback);
        return callback;
    };
EventEmitter.off =
    EventEmitter.removeListener =
        EventEmitter.removeEventListener = function (eventName, callback) {
            this._eventRegistry = this._eventRegistry || {};
            var listeners = this._eventRegistry[eventName];
            if (!listeners)
                return;
            var index = listeners.indexOf(callback);
            if (index !== -1)
                listeners.splice(index, 1);
        };
EventEmitter.removeAllListeners = function (eventName) {
    if (!eventName)
        this._eventRegistry = this._defaultHandlers = undefined;
    if (this._eventRegistry)
        this._eventRegistry[eventName] = undefined;
    if (this._defaultHandlers)
        this._defaultHandlers[eventName] = undefined;
};
exports.EventEmitter = EventEmitter;

});

define("ace/lib/report_error",["require","exports","module"], function(require, exports, module){exports.reportError = function reportError(msg, data) {
    var e = new Error(msg);
    e.data = data;
    if (typeof console == "object" && console.error)
        console.error(e);
    setTimeout(function () { throw e; });
};

});

define("ace/lib/app_config",["require","exports","module","ace/lib/oop","ace/lib/event_emitter","ace/lib/report_error"], function(require, exports, module){"no use strict";
var oop = require("./oop");
var EventEmitter = require("./event_emitter").EventEmitter;
var reportError = require("./report_error").reportError;
var optionsProvider = {
    setOptions: function (optList) {
        Object.keys(optList).forEach(function (key) {
            this.setOption(key, optList[key]);
        }, this);
    },
    getOptions: function (optionNames) {
        var result = {};
        if (!optionNames) {
            var options = this.$options;
            optionNames = Object.keys(options).filter(function (key) {
                return !options[key].hidden;
            });
        }
        else if (!Array.isArray(optionNames)) {
            result = optionNames;
            optionNames = Object.keys(result);
        }
        optionNames.forEach(function (key) {
            result[key] = this.getOption(key);
        }, this);
        return result;
    },
    setOption: function (name, value) {
        if (this["$" + name] === value)
            return;
        var opt = this.$options[name];
        if (!opt) {
            return warn('misspelled option "' + name + '"');
        }
        if (opt.forwardTo)
            return this[opt.forwardTo] && this[opt.forwardTo].setOption(name, value);
        if (!opt.handlesSet)
            this["$" + name] = value;
        if (opt && opt.set)
            opt.set.call(this, value);
    },
    getOption: function (name) {
        var opt = this.$options[name];
        if (!opt) {
            return warn('misspelled option "' + name + '"');
        }
        if (opt.forwardTo)
            return this[opt.forwardTo] && this[opt.forwardTo].getOption(name);
        return opt && opt.get ? opt.get.call(this) : this["$" + name];
    }
};
function warn(message) {
    if (typeof console != "undefined" && console.warn)
        console.warn.apply(console, arguments);
}
var messages;
var AppConfig = /** @class */ (function () {
    function AppConfig() {
        this.$defaultOptions = {};
    }
    AppConfig.prototype.defineOptions = function (obj, path, options) {
        if (!obj.$options)
            this.$defaultOptions[path] = obj.$options = {};
        Object.keys(options).forEach(function (key) {
            var opt = options[key];
            if (typeof opt == "string")
                opt = { forwardTo: opt };
            opt.name || (opt.name = key);
            obj.$options[opt.name] = opt;
            if ("initialValue" in opt)
                obj["$" + opt.name] = opt.initialValue;
        });
        oop.implement(obj, optionsProvider);
        return this;
    };
    AppConfig.prototype.resetOptions = function (obj) {
        Object.keys(obj.$options).forEach(function (key) {
            var opt = obj.$options[key];
            if ("value" in opt)
                obj.setOption(key, opt.value);
        });
    };
    AppConfig.prototype.setDefaultValue = function (path, name, value) {
        if (!path) {
            for (path in this.$defaultOptions)
                if (this.$defaultOptions[path][name])
                    break;
            if (!this.$defaultOptions[path][name])
                return false;
        }
        var opts = this.$defaultOptions[path] || (this.$defaultOptions[path] = {});
        if (opts[name]) {
            if (opts.forwardTo)
                this.setDefaultValue(opts.forwardTo, name, value);
            else
                opts[name].value = value;
        }
    };
    AppConfig.prototype.setDefaultValues = function (path, optionHash) {
        Object.keys(optionHash).forEach(function (key) {
            this.setDefaultValue(path, key, optionHash[key]);
        }, this);
    };
    AppConfig.prototype.setMessages = function (value) {
        messages = value;
    };
    AppConfig.prototype.nls = function (string, params) {
        if (messages && !messages[string]) {
            warn("No message found for '" + string + "' in the provided messages, falling back to default English message.");
        }
        var translated = messages && messages[string] || string;
        if (params) {
            translated = translated.replace(/\$(\$|[\d]+)/g, function (_, name) {
                if (name == "$")
                    return "$";
                return params[name];
            });
        }
        return translated;
    };
    return AppConfig;
}());
AppConfig.prototype.warn = warn;
AppConfig.prototype.reportError = reportError;
oop.implement(AppConfig.prototype, EventEmitter);
exports.AppConfig = AppConfig;

});

define("ace/theme/textmate-css",["require","exports","module"], function(require, exports, module){module.exports = ".ace-tm .ace_gutter {\n  background: #f0f0f0;\n  color: #333;\n}\n\n.ace-tm .ace_print-margin {\n  width: 1px;\n  background: #e8e8e8;\n}\n\n.ace-tm .ace_fold {\n    background-color: #6B72E6;\n}\n\n.ace-tm {\n  background-color: #FFFFFF;\n  color: black;\n}\n\n.ace-tm .ace_cursor {\n  color: black;\n}\n        \n.ace-tm .ace_invisible {\n  color: rgb(191, 191, 191);\n}\n\n.ace-tm .ace_storage,\n.ace-tm .ace_keyword {\n  color: blue;\n}\n\n.ace-tm .ace_constant {\n  color: rgb(197, 6, 11);\n}\n\n.ace-tm .ace_constant.ace_buildin {\n  color: rgb(88, 72, 246);\n}\n\n.ace-tm .ace_constant.ace_language {\n  color: rgb(88, 92, 246);\n}\n\n.ace-tm .ace_constant.ace_library {\n  color: rgb(6, 150, 14);\n}\n\n.ace-tm .ace_invalid {\n  background-color: rgba(255, 0, 0, 0.1);\n  color: red;\n}\n\n.ace-tm .ace_support.ace_function {\n  color: rgb(60, 76, 114);\n}\n\n.ace-tm .ace_support.ace_constant {\n  color: rgb(6, 150, 14);\n}\n\n.ace-tm .ace_support.ace_type,\n.ace-tm .ace_support.ace_class {\n  color: rgb(109, 121, 222);\n}\n\n.ace-tm .ace_keyword.ace_operator {\n  color: rgb(104, 118, 135);\n}\n\n.ace-tm .ace_string {\n  color: rgb(3, 106, 7);\n}\n\n.ace-tm .ace_comment {\n  color: rgb(76, 136, 107);\n}\n\n.ace-tm .ace_comment.ace_doc {\n  color: rgb(0, 102, 255);\n}\n\n.ace-tm .ace_comment.ace_doc.ace_tag {\n  color: rgb(128, 159, 191);\n}\n\n.ace-tm .ace_constant.ace_numeric {\n  color: rgb(0, 0, 205);\n}\n\n.ace-tm .ace_variable {\n  color: rgb(49, 132, 149);\n}\n\n.ace-tm .ace_xml-pe {\n  color: rgb(104, 104, 91);\n}\n\n.ace-tm .ace_entity.ace_name.ace_function {\n  color: #0000A2;\n}\n\n\n.ace-tm .ace_heading {\n  color: rgb(12, 7, 255);\n}\n\n.ace-tm .ace_list {\n  color:rgb(185, 6, 144);\n}\n\n.ace-tm .ace_meta.ace_tag {\n  color:rgb(0, 22, 142);\n}\n\n.ace-tm .ace_string.ace_regex {\n  color: rgb(255, 0, 0)\n}\n\n.ace-tm .ace_marker-layer .ace_selection {\n  background: rgb(181, 213, 255);\n}\n.ace-tm.ace_multiselect .ace_selection.ace_start {\n  box-shadow: 0 0 3px 0px white;\n}\n.ace-tm .ace_marker-layer .ace_step {\n  background: rgb(252, 255, 0);\n}\n\n.ace-tm .ace_marker-layer .ace_stack {\n  background: rgb(164, 229, 101);\n}\n\n.ace-tm .ace_marker-layer .ace_bracket {\n  margin: -1px 0 0 -1px;\n  border: 1px solid rgb(192, 192, 192);\n}\n\n.ace-tm .ace_marker-layer .ace_active-line {\n  background: rgba(0, 0, 0, 0.07);\n}\n\n.ace-tm .ace_gutter-active-line {\n    background-color : #dcdcdc;\n}\n\n.ace-tm .ace_marker-layer .ace_selected-word {\n  background: rgb(250, 250, 255);\n  border: 1px solid rgb(200, 200, 250);\n}\n\n.ace-tm .ace_indent-guide {\n  background: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==\") right repeat-y;\n}\n\n.ace-tm .ace_indent-guide-active {\n  background: url(\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAIGNIUk0AAHolAACAgwAA+f8AAIDpAAB1MAAA6mAAADqYAAAXb5JfxUYAAAAZSURBVHjaYvj///9/hivKyv8BAAAA//8DACLqBhbvk+/eAAAAAElFTkSuQmCC\") right repeat-y;\n}\n";

});

define("ace/theme/textmate",["require","exports","module","ace/theme/textmate-css","ace/lib/dom"], function(require, exports, module){"use strict";
exports.isDark = false;
exports.cssClass = "ace-tm";
exports.cssText = require("./textmate-css");
exports.$id = "ace/theme/textmate";
var dom = require("../lib/dom");
dom.importCssString(exports.cssText, exports.cssClass, false);

});

define("ace/config",["require","exports","module","ace/lib/lang","ace/lib/net","ace/lib/dom","ace/lib/app_config","ace/theme/textmate"], function(require, exports, module){"no use strict";
var lang = require("./lib/lang");
var net = require("./lib/net");
var dom = require("./lib/dom");
var AppConfig = require("./lib/app_config").AppConfig;
module.exports = exports = new AppConfig();
var options = {
    packaged: false,
    workerPath: null,
    modePath: null,
    themePath: null,
    basePath: "",
    suffix: ".js",
    $moduleUrls: {},
    loadWorkerFromBlob: true,
    sharedPopups: false,
    useStrictCSP: null
};
exports.get = function (key) {
    if (!options.hasOwnProperty(key))
        throw new Error("Unknown config key: " + key);
    return options[key];
};
exports.set = function (key, value) {
    if (options.hasOwnProperty(key))
        options[key] = value;
    else if (this.setDefaultValue("", key, value) == false)
        throw new Error("Unknown config key: " + key);
    if (key == "useStrictCSP")
        dom.useStrictCSP(value);
};
exports.all = function () {
    return lang.copyObject(options);
};
exports.$modes = {};
exports.moduleUrl = function (name, component) {
    if (options.$moduleUrls[name])
        return options.$moduleUrls[name];
    var parts = name.split("/");
    component = component || parts[parts.length - 2] || "";
    var sep = component == "snippets" ? "/" : "-";
    var base = parts[parts.length - 1];
    if (component == "worker" && sep == "-") {
        var re = new RegExp("^" + component + "[\\-_]|[\\-_]" + component + "$", "g");
        base = base.replace(re, "");
    }
    if ((!base || base == component) && parts.length > 1)
        base = parts[parts.length - 2];
    var path = options[component + "Path"];
    if (path == null) {
        path = options.basePath;
    }
    else if (sep == "/") {
        component = sep = "";
    }
    if (path && path.slice(-1) != "/")
        path += "/";
    return path + component + sep + base + this.get("suffix");
};
exports.setModuleUrl = function (name, subst) {
    return options.$moduleUrls[name] = subst;
};
var loader = function (moduleName, cb) {
    if (moduleName === "ace/theme/textmate" || moduleName === "./theme/textmate")
        return cb(null, require("./theme/textmate"));
    if (customLoader)
        return customLoader(moduleName, cb);
    console.error("loader is not configured");
};
var customLoader;
exports.setLoader = function (cb) {
    customLoader = cb;
};
exports.dynamicModules = Object.create(null);
exports.$loading = {};
exports.$loaded = {};
exports.loadModule = function (moduleName, onLoad) {
    var loadedModule, moduleType;
    if (Array.isArray(moduleName)) {
        moduleType = moduleName[0];
        moduleName = moduleName[1];
    }
    var load = function (module) {
        if (module && !exports.$loading[moduleName])
            return onLoad && onLoad(module);
        if (!exports.$loading[moduleName])
            exports.$loading[moduleName] = [];
        exports.$loading[moduleName].push(onLoad);
        if (exports.$loading[moduleName].length > 1)
            return;
        var afterLoad = function () {
            loader(moduleName, function (err, module) {
                if (module)
                    exports.$loaded[moduleName] = module;
                exports._emit("load.module", { name: moduleName, module: module });
                var listeners = exports.$loading[moduleName];
                exports.$loading[moduleName] = null;
                listeners.forEach(function (onLoad) {
                    onLoad && onLoad(module);
                });
            });
        };
        if (!exports.get("packaged"))
            return afterLoad();
        net.loadScript(exports.moduleUrl(moduleName, moduleType), afterLoad);
        reportErrorIfPathIsNotConfigured();
    };
    if (exports.dynamicModules[moduleName]) {
        exports.dynamicModules[moduleName]().then(function (module) {
            if (module.default) {
                load(module.default);
            }
            else {
                load(module);
            }
        });
    }
    else {
        try {
            loadedModule = this.$require(moduleName);
        }
        catch (e) { }
        load(loadedModule || exports.$loaded[moduleName]);
    }
};
exports.$require = function (moduleName) {
    if (typeof module.require == "function") {
        var req = "require";
        return module[req](moduleName);
    }
};
exports.setModuleLoader = function (moduleName, onLoad) {
    exports.dynamicModules[moduleName] = onLoad;
};
var reportErrorIfPathIsNotConfigured = function () {
    if (!options.basePath && !options.workerPath
        && !options.modePath && !options.themePath
        && !Object.keys(options.$moduleUrls).length) {
        console.error("Unable to infer path to ace from script src,", "use ace.config.set('basePath', 'path') to enable dynamic loading of modes and themes", "or with webpack use ace/webpack-resolver");
        reportErrorIfPathIsNotConfigured = function () { };
    }
};
exports.version = "1.28.0";

});

define("ace/loader_build",["require","exports","module","ace/lib/fixoldbrowsers","ace/config"], function(require, exports, module) {
"use strict";

require("./lib/fixoldbrowsers");
var config = require("./config");
config.setLoader(function(moduleName, cb) {
    require([moduleName], function(module) {
        cb(null, module);
    });
});

var global = (function() {
    return this || typeof window != "undefined" && window;
})();

module.exports = function(ace) {
    config.init = init;
    config.$require = require;
    ace.require = require;

    if (typeof define === "function")
        ace.define = define;
};
init(true);function init(packaged) {

    if (!global || !global.document)
        return;
    
    config.set("packaged", packaged || require.packaged || module.packaged || (global.define && define.packaged));

    var scriptOptions = {};
    var scriptUrl = "";
    var currentScript = (document.currentScript || document._currentScript ); // native or polyfill
    var currentDocument = currentScript && currentScript.ownerDocument || document;
    
    if (currentScript && currentScript.src) {
        scriptUrl = currentScript.src.split(/[?#]/)[0].split("/").slice(0, -1).join("/") || "";
    }
    
    var scripts = currentDocument.getElementsByTagName("script");
    for (var i=0; i<scripts.length; i++) {
        var script = scripts[i];

        var src = script.src || script.getAttribute("src");
        if (!src)
            continue;

        var attributes = script.attributes;
        for (var j=0, l=attributes.length; j < l; j++) {
            var attr = attributes[j];
            if (attr.name.indexOf("data-ace-") === 0) {
                scriptOptions[deHyphenate(attr.name.replace(/^data-ace-/, ""))] = attr.value;
            }
        }

        var m = src.match(/^(.*)\/ace([\-.]\w+)?\.js(\?|$)/);
        if (m)
            scriptUrl = m[1];
    }

    if (scriptUrl) {
        scriptOptions.base = scriptOptions.base || scriptUrl;
        scriptOptions.packaged = true;
    }

    scriptOptions.basePath = scriptOptions.base;
    scriptOptions.workerPath = scriptOptions.workerPath || scriptOptions.base;
    scriptOptions.modePath = scriptOptions.modePath || scriptOptions.base;
    scriptOptions.themePath = scriptOptions.themePath || scriptOptions.base;
    delete scriptOptions.base;

    for (var key in scriptOptions)
        if (typeof scriptOptions[key] !== "undefined")
            config.set(key, scriptOptions[key]);
}

function deHyphenate(str) {
    return str.replace(/-(.)/g, function(m, m1) { return m1.toUpperCase(); });
}
});

define("ace/snippets/abc.snippets",["require","exports","module"], function(require, exports, module){module.exports = "\nsnippet zupfnoter.print\n\t%%%%hn.print {\"startpos\": ${1:pos_y}, \"t\":\"${2:title}\", \"v\":[${3:voices}], \"s\":[[${4:syncvoices}1,2]], \"f\":[${5:flowlines}],  \"sf\":[${6:subflowlines}], \"j\":[${7:jumplines}]}\n\nsnippet zupfnoter.note\n\t%%%%hn.note {\"pos\": [${1:pos_x},${2:pos_y}], \"text\": \"${3:text}\", \"style\": \"${4:style}\"}\n\nsnippet zupfnoter.annotation\n\t%%%%hn.annotation {\"id\": \"${1:id}\", \"pos\": [${2:pos}], \"text\": \"${3:text}\"}\n\nsnippet zupfnoter.lyrics\n\t%%%%hn.lyrics {\"pos\": [${1:x_pos},${2:y_pos}]}\n\nsnippet zupfnoter.legend\n\t%%%%hn.legend {\"pos\": [${1:x_pos},${2:y_pos}]}\n\n\n\nsnippet zupfnoter.target\n\t\"^:${1:target}\"\n\nsnippet zupfnoter.goto\n\t\"^@${1:target}@${2:distance}\"\n\nsnippet zupfnoter.annotationref\n\t\"^#${1:target}\"\n\nsnippet zupfnoter.annotation\n\t\"^!${1:text}@${2:x_offset},${3:y_offset}\"\n\n\n";

});

define("ace/snippets/abc",["require","exports","module","ace/snippets/abc.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./abc.snippets");
exports.scope = "abc";

});

define("ace/snippets/actionscript.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet main\n\tpackage {\n\t\timport flash.display.*;\n\t\timport flash.Events.*;\n\t\n\t\tpublic class Main extends Sprite {\n\t\t\tpublic function Main (\t) {\n\t\t\t\ttrace(\"start\");\n\t\t\t\tstage.scaleMode = StageScaleMode.NO_SCALE;\n\t\t\t\tstage.addEventListener(Event.RESIZE, resizeListener);\n\t\t\t}\n\t\n\t\t\tprivate function resizeListener (e:Event):void {\n\t\t\t\ttrace(\"The application window changed size!\");\n\t\t\t\ttrace(\"New width:  \" + stage.stageWidth);\n\t\t\t\ttrace(\"New height: \" + stage.stageHeight);\n\t\t\t}\n\t\n\t\t}\n\t\n\t}\nsnippet class\n\t${1:public|internal} class ${2:name} ${3:extends } {\n\t\tpublic function $2 (\t) {\n\t\t\t(\"start\");\n\t\t}\n\t}\nsnippet all\n\tpackage name {\n\n\t\t${1:public|internal|final} class ${2:name} ${3:extends } {\n\t\t\tprivate|public| static const FOO = \"abc\";\n\t\t\tprivate|public| static var BAR = \"abc\";\n\n\t\t\t// class initializer - no JIT !! one time setup\n\t\t\tif Cababilities.os == \"Linux|MacOS\" {\n\t\t\t\tFOO = \"other\";\n\t\t\t}\n\n\t\t\t// constructor:\n\t\t\tpublic function $2 (\t){\n\t\t\t\tsuper2();\n\t\t\t\ttrace(\"start\");\n\t\t\t}\n\t\t\tpublic function name (a, b...){\n\t\t\t\tsuper.name(..);\n\t\t\t\tlable:break\n\t\t\t}\n\t\t}\n\t}\n\n\tfunction A(){\n\t\t// A can only be accessed within this file\n\t}\nsnippet switch\n\tswitch(${1}){\n\t\tcase ${2}:\n\t\t\t${3}\n\t\tbreak;\n\t\tdefault:\n\t}\nsnippet case\n\t\tcase ${1}:\n\t\t\t${2}\n\t\tbreak;\nsnippet package\n\tpackage ${1:package}{\n\t\t${2}\n\t}\nsnippet wh\n\twhile ${1:cond}{\n\t\t${2}\n\t}\nsnippet do\n\tdo {\n\t\t${2}\n\t} while (${1:cond})\nsnippet while\n\twhile ${1:cond}{\n\t\t${2}\n\t}\nsnippet for enumerate names\n\tfor (${1:var} in ${2:object}){\n\t\t${3}\n\t}\nsnippet for enumerate values\n\tfor each (${1:var} in ${2:object}){\n\t\t${3}\n\t}\nsnippet get_set\n\tfunction get ${1:name} {\n\t\treturn ${2}\n\t}\n\tfunction set $1 (newValue) {\n\t\t${3}\n\t}\nsnippet interface\n\tinterface name {\n\t\tfunction method(${1}):${2:returntype};\n\t}\nsnippet try\n\ttry {\n\t\t${1}\n\t} catch (error:ErrorType) {\n\t\t${2}\n\t} finally {\n\t\t${3}\n\t}\n# For Loop (same as c.snippet)\nsnippet for for (..) {..}\n\tfor (${2:i} = 0; $2 < ${1:count}; $2${3:++}) {\n\t\t${4:/* code */}\n\t}\n# Custom For Loop\nsnippet forr\n\tfor (${1:i} = ${2:0}; ${3:$1 < 10}; $1${4:++}) {\n\t\t${5:/* code */}\n\t}\n# If Condition\nsnippet if\n\tif (${1:/* condition */}) {\n\t\t${2:/* code */}\n\t}\nsnippet el\n\telse {\n\t\t${1}\n\t}\n# Ternary conditional\nsnippet t\n\t${1:/* condition */} ? ${2:a} : ${3:b}\nsnippet fun\n\tfunction ${1:function_name}(${2})${3}\n\t{\n\t\t${4:/* code */}\n\t}\n# FlxSprite (usefull when using the flixel library)\nsnippet FlxSprite\n\tpackage\n\t{\n\t\timport org.flixel.*\n\n\t\tpublic class ${1:ClassName} extends ${2:FlxSprite}\n\t\t{\n\t\t\tpublic function $1(${3: X:Number, Y:Number}):void\n\t\t\t{\n\t\t\t\tsuper(X,Y);\n\t\t\t\t${4: //code...}\n\t\t\t}\n\n\t\t\toverride public function update():void\n\t\t\t{\n\t\t\t\tsuper.update();\n\t\t\t\t${5: //code...}\n\t\t\t}\n\t\t}\n\t}\n\n";

});

define("ace/snippets/actionscript",["require","exports","module","ace/snippets/actionscript.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./actionscript.snippets");
exports.scope = "actionscript";

});

define("ace/snippets/c_cpp.snippets",["require","exports","module"], function(require, exports, module){module.exports = "## STL Collections\n# std::array\nsnippet array\n\tstd::array<${1:T}, ${2:N}> ${3};${4}\n# std::vector\nsnippet vector\n\tstd::vector<${1:T}> ${2};${3}\n# std::deque\nsnippet deque\n\tstd::deque<${1:T}> ${2};${3}\n# std::forward_list\nsnippet flist\n\tstd::forward_list<${1:T}> ${2};${3}\n# std::list\nsnippet list\n\tstd::list<${1:T}> ${2};${3}\n# std::set\nsnippet set\n\tstd::set<${1:T}> ${2};${3}\n# std::map\nsnippet map\n\tstd::map<${1:Key}, ${2:T}> ${3};${4}\n# std::multiset\nsnippet mset\n\tstd::multiset<${1:T}> ${2};${3}\n# std::multimap\nsnippet mmap\n\tstd::multimap<${1:Key}, ${2:T}> ${3};${4}\n# std::unordered_set\nsnippet uset\n\tstd::unordered_set<${1:T}> ${2};${3}\n# std::unordered_map\nsnippet umap\n\tstd::unordered_map<${1:Key}, ${2:T}> ${3};${4}\n# std::unordered_multiset\nsnippet umset\n\tstd::unordered_multiset<${1:T}> ${2};${3}\n# std::unordered_multimap\nsnippet ummap\n\tstd::unordered_multimap<${1:Key}, ${2:T}> ${3};${4}\n# std::stack\nsnippet stack\n\tstd::stack<${1:T}> ${2};${3}\n# std::queue\nsnippet queue\n\tstd::queue<${1:T}> ${2};${3}\n# std::priority_queue\nsnippet pqueue\n\tstd::priority_queue<${1:T}> ${2};${3}\n##\n## Access Modifiers\n# private\nsnippet pri\n\tprivate\n# protected\nsnippet pro\n\tprotected\n# public\nsnippet pub\n\tpublic\n# friend\nsnippet fr\n\tfriend\n# mutable\nsnippet mu\n\tmutable\n## \n## Class\n# class\nsnippet cl\n\tclass ${1:`Filename('$1', 'name')`} \n\t{\n\tpublic:\n\t\t$1(${2});\n\t\t~$1();\n\n\tprivate:\n\t\t${3:/* data */}\n\t};\n# member function implementation\nsnippet mfun\n\t${4:void} ${1:`Filename('$1', 'ClassName')`}::${2:memberFunction}(${3}) {\n\t\t${5:/* code */}\n\t}\n# namespace\nsnippet ns\n\tnamespace ${1:`Filename('', 'my')`} {\n\t\t${2}\n\t} /* namespace $1 */\n##\n## Input/Output\n# std::cout\nsnippet cout\n\tstd::cout << ${1} << std::endl;${2}\n# std::cin\nsnippet cin\n\tstd::cin >> ${1};${2}\n##\n## Iteration\n# for i \nsnippet fori\n\tfor (int ${2:i} = 0; $2 < ${1:count}; $2${3:++}) {\n\t\t${4:/* code */}\n\t}${5}\n\n# foreach\nsnippet fore\n\tfor (${1:auto} ${2:i} : ${3:container}) {\n\t\t${4:/* code */}\n\t}${5}\n# iterator\nsnippet iter\n\tfor (${1:std::vector}<${2:type}>::${3:const_iterator} ${4:i} = ${5:container}.begin(); $4 != $5.end(); ++$4) {\n\t\t${6}\n\t}${7}\n\n# auto iterator\nsnippet itera\n\tfor (auto ${1:i} = $1.begin(); $1 != $1.end(); ++$1) {\n\t\t${2:std::cout << *$1 << std::endl;}\n\t}${3}\n##\n## Lambdas\n# lamda (one line)\nsnippet ld\n\t[${1}](${2}){${3:/* code */}}${4}\n# lambda (multi-line)\nsnippet lld\n\t[${1}](${2}){\n\t\t${3:/* code */}\n\t}${4}\n";

});

define("ace/snippets/c_cpp",["require","exports","module","ace/snippets/c_cpp.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./c_cpp.snippets");
exports.scope = "c_cpp";

});

define("ace/snippets/clojure.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet comm\n\t(comment\n\t  ${1}\n\t  )\nsnippet condp\n\t(condp ${1:pred} ${2:expr}\n\t  ${3})\nsnippet def\n\t(def ${1})\nsnippet defm\n\t(defmethod ${1:multifn} \"${2:doc-string}\" ${3:dispatch-val} [${4:args}]\n\t  ${5})\nsnippet defmm\n\t(defmulti ${1:name} \"${2:doc-string}\" ${3:dispatch-fn})\nsnippet defma\n\t(defmacro ${1:name} \"${2:doc-string}\" ${3:dispatch-fn})\nsnippet defn\n\t(defn ${1:name} \"${2:doc-string}\" [${3:arg-list}]\n\t  ${4})\nsnippet defp\n\t(defprotocol ${1:name}\n\t  ${2})\nsnippet defr\n\t(defrecord ${1:name} [${2:fields}]\n\t  ${3:protocol}\n\t  ${4})\nsnippet deft\n\t(deftest ${1:name}\n\t    (is (= ${2:assertion})))\n\t  ${3})\nsnippet is\n\t(is (= ${1} ${2}))\nsnippet defty\n\t(deftype ${1:Name} [${2:fields}]\n\t  ${3:Protocol}\n\t  ${4})\nsnippet doseq\n\t(doseq [${1:elem} ${2:coll}]\n\t  ${3})\nsnippet fn\n\t(fn [${1:arg-list}] ${2})\nsnippet if\n\t(if ${1:test-expr}\n\t  ${2:then-expr}\n\t  ${3:else-expr})\nsnippet if-let \n\t(if-let [${1:result} ${2:test-expr}]\n\t\t(${3:then-expr} $1)\n\t\t(${4:else-expr}))\nsnippet imp\n\t(:import [${1:package}])\n\t& {:keys [${1:keys}] :or {${2:defaults}}}\nsnippet let\n\t(let [${1:name} ${2:expr}]\n\t\t${3})\nsnippet letfn\n\t(letfn [(${1:name) [${2:args}]\n\t          ${3})])\nsnippet map\n\t(map ${1:func} ${2:coll})\nsnippet mapl\n\t(map #(${1:lambda}) ${2:coll})\nsnippet met\n\t(${1:name} [${2:this} ${3:args}]\n\t  ${4})\nsnippet ns\n\t(ns ${1:name}\n\t  ${2})\nsnippet dotimes\n\t(dotimes [_ 10]\n\t  (time\n\t    (dotimes [_ ${1:times}]\n\t      ${2})))\nsnippet pmethod\n\t(${1:name} [${2:this} ${3:args}])\nsnippet refer\n\t(:refer-clojure :exclude [${1}])\nsnippet require\n\t(:require [${1:namespace} :as [${2}]])\nsnippet use\n\t(:use [${1:namespace} :only [${2}]])\nsnippet print\n\t(println ${1})\nsnippet reduce\n\t(reduce ${1:(fn [p n] ${3})} ${2})\nsnippet when\n\t(when ${1:test} ${2:body})\nsnippet when-let\n\t(when-let [${1:result} ${2:test}]\n\t\t${3:body})\n";

});

define("ace/snippets/clojure",["require","exports","module","ace/snippets/clojure.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./clojure.snippets");
exports.scope = "clojure";

});

define("ace/snippets/coffee.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# Closure loop\nsnippet forindo\n\tfor ${1:name} in ${2:array}\n\t\tdo ($1) ->\n\t\t\t${3:// body}\n# Array comprehension\nsnippet fora\n\tfor ${1:name} in ${2:array}\n\t\t${3:// body...}\n# Object comprehension\nsnippet foro\n\tfor ${1:key}, ${2:value} of ${3:object}\n\t\t${4:// body...}\n# Range comprehension (inclusive)\nsnippet forr\n\tfor ${1:name} in [${2:start}..${3:finish}]\n\t\t${4:// body...}\nsnippet forrb\n\tfor ${1:name} in [${2:start}..${3:finish}] by ${4:step}\n\t\t${5:// body...}\n# Range comprehension (exclusive)\nsnippet forrex\n\tfor ${1:name} in [${2:start}...${3:finish}]\n\t\t${4:// body...}\nsnippet forrexb\n\tfor ${1:name} in [${2:start}...${3:finish}] by ${4:step}\n\t\t${5:// body...}\n# Function\nsnippet fun\n\t(${1:args}) ->\n\t\t${2:// body...}\n# Function (bound)\nsnippet bfun\n\t(${1:args}) =>\n\t\t${2:// body...}\n# Class\nsnippet cla class ..\n\tclass ${1:`substitute(Filename(), '\\(_\\|^\\)\\(.\\)', '\\u\\2', 'g')`}\n\t\t${2}\nsnippet cla class .. constructor: ..\n\tclass ${1:`substitute(Filename(), '\\(_\\|^\\)\\(.\\)', '\\u\\2', 'g')`}\n\t\tconstructor: (${2:args}) ->\n\t\t\t${3}\n\n\t\t${4}\nsnippet cla class .. extends ..\n\tclass ${1:`substitute(Filename(), '\\(_\\|^\\)\\(.\\)', '\\u\\2', 'g')`} extends ${2:ParentClass}\n\t\t${3}\nsnippet cla class .. extends .. constructor: ..\n\tclass ${1:`substitute(Filename(), '\\(_\\|^\\)\\(.\\)', '\\u\\2', 'g')`} extends ${2:ParentClass}\n\t\tconstructor: (${3:args}) ->\n\t\t\t${4}\n\n\t\t${5}\n# If\nsnippet if\n\tif ${1:condition}\n\t\t${2:// body...}\n# If __ Else\nsnippet ife\n\tif ${1:condition}\n\t\t${2:// body...}\n\telse\n\t\t${3:// body...}\n# Else if\nsnippet elif\n\telse if ${1:condition}\n\t\t${2:// body...}\n# Ternary If\nsnippet ifte\n\tif ${1:condition} then ${2:value} else ${3:other}\n# Unless\nsnippet unl\n\t${1:action} unless ${2:condition}\n# Switch\nsnippet swi\n\tswitch ${1:object}\n\t\twhen ${2:value}\n\t\t\t${3:// body...}\n\n# Log\nsnippet log\n\tconsole.log ${1}\n# Try __ Catch\nsnippet try\n\ttry\n\t\t${1}\n\tcatch ${2:error}\n\t\t${3}\n# Require\nsnippet req\n\t${2:$1} = require '${1:sys}'${3}\n# Export\nsnippet exp\n\t${1:root} = exports ? this\n";

});

define("ace/snippets/coffee",["require","exports","module","ace/snippets/coffee.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./coffee.snippets");
exports.scope = "coffee";

});

define("ace/snippets/csound_document.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# <CsoundSynthesizer>\nsnippet synth\n\t<CsoundSynthesizer>\n\t<CsInstruments>\n\t${1}\n\t</CsInstruments>\n\t<CsScore>\n\te\n\t</CsScore>\n\t</CsoundSynthesizer>\n";

});

define("ace/snippets/csound_document",["require","exports","module","ace/snippets/csound_document.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./csound_document.snippets");
exports.scope = "csound_document";

});

define("ace/snippets/csound_orchestra.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# else\nsnippet else\n\telse\n\t\t${1:/* statements */}\n# elseif\nsnippet elseif\n\telseif ${1:/* condition */} then\n\t\t${2:/* statements */}\n# if\nsnippet if\n\tif ${1:/* condition */} then\n\t\t${2:/* statements */}\n\tendif\n# instrument block\nsnippet instr\n\tinstr ${1:name}\n\t\t${2:/* statements */}\n\tendin\n# i-time while loop\nsnippet iwhile\n\ti${1:Index} = ${2:0}\n\twhile i${1:Index} < ${3:/* count */} do\n\t\t${4:/* statements */}\n\t\ti${1:Index} += 1\n\tod\n# k-rate while loop\nsnippet kwhile\n\tk${1:Index} = ${2:0}\n\twhile k${1:Index} < ${3:/* count */} do\n\t\t${4:/* statements */}\n\t\tk${1:Index} += 1\n\tod\n# opcode\nsnippet opcode\n\topcode ${1:name}, ${2:/* output types */ 0}, ${3:/* input types */ 0}\n\t\t${4:/* statements */}\n\tendop\n# until loop\nsnippet until\n\tuntil ${1:/* condition */} do\n\t\t${2:/* statements */}\n\tod\n# while loop\nsnippet while\n\twhile ${1:/* condition */} do\n\t\t${2:/* statements */}\n\tod\n";

});

define("ace/snippets/csound_orchestra",["require","exports","module","ace/snippets/csound_orchestra.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./csound_orchestra.snippets");
exports.scope = "csound_orchestra";

});

define("ace/snippets/css.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet .\n\t${1} {\n\t\t${2}\n\t}\nsnippet !\n\t !important\nsnippet bdi:m+\n\t-moz-border-image: url(${1}) ${2:0} ${3:0} ${4:0} ${5:0} ${6:stretch} ${7:stretch};\nsnippet bdi:m\n\t-moz-border-image: ${1};\nsnippet bdrz:m\n\t-moz-border-radius: ${1};\nsnippet bxsh:m+\n\t-moz-box-shadow: ${1:0} ${2:0} ${3:0} #${4:000};\nsnippet bxsh:m\n\t-moz-box-shadow: ${1};\nsnippet bdi:w+\n\t-webkit-border-image: url(${1}) ${2:0} ${3:0} ${4:0} ${5:0} ${6:stretch} ${7:stretch};\nsnippet bdi:w\n\t-webkit-border-image: ${1};\nsnippet bdrz:w\n\t-webkit-border-radius: ${1};\nsnippet bxsh:w+\n\t-webkit-box-shadow: ${1:0} ${2:0} ${3:0} #${4:000};\nsnippet bxsh:w\n\t-webkit-box-shadow: ${1};\nsnippet @f\n\t@font-face {\n\t\tfont-family: ${1};\n\t\tsrc: url(${2});\n\t}\nsnippet @i\n\t@import url(${1});\nsnippet @m\n\t@media ${1:print} {\n\t\t${2}\n\t}\nsnippet bg+\n\tbackground: #${1:FFF} url(${2}) ${3:0} ${4:0} ${5:no-repeat};\nsnippet bga\n\tbackground-attachment: ${1};\nsnippet bga:f\n\tbackground-attachment: fixed;\nsnippet bga:s\n\tbackground-attachment: scroll;\nsnippet bgbk\n\tbackground-break: ${1};\nsnippet bgbk:bb\n\tbackground-break: bounding-box;\nsnippet bgbk:c\n\tbackground-break: continuous;\nsnippet bgbk:eb\n\tbackground-break: each-box;\nsnippet bgcp\n\tbackground-clip: ${1};\nsnippet bgcp:bb\n\tbackground-clip: border-box;\nsnippet bgcp:cb\n\tbackground-clip: content-box;\nsnippet bgcp:nc\n\tbackground-clip: no-clip;\nsnippet bgcp:pb\n\tbackground-clip: padding-box;\nsnippet bgc\n\tbackground-color: #${1:FFF};\nsnippet bgc:t\n\tbackground-color: transparent;\nsnippet bgi\n\tbackground-image: url(${1});\nsnippet bgi:n\n\tbackground-image: none;\nsnippet bgo\n\tbackground-origin: ${1};\nsnippet bgo:bb\n\tbackground-origin: border-box;\nsnippet bgo:cb\n\tbackground-origin: content-box;\nsnippet bgo:pb\n\tbackground-origin: padding-box;\nsnippet bgpx\n\tbackground-position-x: ${1};\nsnippet bgpy\n\tbackground-position-y: ${1};\nsnippet bgp\n\tbackground-position: ${1:0} ${2:0};\nsnippet bgr\n\tbackground-repeat: ${1};\nsnippet bgr:n\n\tbackground-repeat: no-repeat;\nsnippet bgr:x\n\tbackground-repeat: repeat-x;\nsnippet bgr:y\n\tbackground-repeat: repeat-y;\nsnippet bgr:r\n\tbackground-repeat: repeat;\nsnippet bgz\n\tbackground-size: ${1};\nsnippet bgz:a\n\tbackground-size: auto;\nsnippet bgz:ct\n\tbackground-size: contain;\nsnippet bgz:cv\n\tbackground-size: cover;\nsnippet bg\n\tbackground: ${1};\nsnippet bg:ie\n\tfilter: progid:DXImageTransform.Microsoft.AlphaImageLoader(src='${1}',sizingMethod='${2:crop}');\nsnippet bg:n\n\tbackground: none;\nsnippet bd+\n\tborder: ${1:1px} ${2:solid} #${3:000};\nsnippet bdb+\n\tborder-bottom: ${1:1px} ${2:solid} #${3:000};\nsnippet bdbc\n\tborder-bottom-color: #${1:000};\nsnippet bdbi\n\tborder-bottom-image: url(${1});\nsnippet bdbi:n\n\tborder-bottom-image: none;\nsnippet bdbli\n\tborder-bottom-left-image: url(${1});\nsnippet bdbli:c\n\tborder-bottom-left-image: continue;\nsnippet bdbli:n\n\tborder-bottom-left-image: none;\nsnippet bdblrz\n\tborder-bottom-left-radius: ${1};\nsnippet bdbri\n\tborder-bottom-right-image: url(${1});\nsnippet bdbri:c\n\tborder-bottom-right-image: continue;\nsnippet bdbri:n\n\tborder-bottom-right-image: none;\nsnippet bdbrrz\n\tborder-bottom-right-radius: ${1};\nsnippet bdbs\n\tborder-bottom-style: ${1};\nsnippet bdbs:n\n\tborder-bottom-style: none;\nsnippet bdbw\n\tborder-bottom-width: ${1};\nsnippet bdb\n\tborder-bottom: ${1};\nsnippet bdb:n\n\tborder-bottom: none;\nsnippet bdbk\n\tborder-break: ${1};\nsnippet bdbk:c\n\tborder-break: close;\nsnippet bdcl\n\tborder-collapse: ${1};\nsnippet bdcl:c\n\tborder-collapse: collapse;\nsnippet bdcl:s\n\tborder-collapse: separate;\nsnippet bdc\n\tborder-color: #${1:000};\nsnippet bdci\n\tborder-corner-image: url(${1});\nsnippet bdci:c\n\tborder-corner-image: continue;\nsnippet bdci:n\n\tborder-corner-image: none;\nsnippet bdf\n\tborder-fit: ${1};\nsnippet bdf:c\n\tborder-fit: clip;\nsnippet bdf:of\n\tborder-fit: overwrite;\nsnippet bdf:ow\n\tborder-fit: overwrite;\nsnippet bdf:r\n\tborder-fit: repeat;\nsnippet bdf:sc\n\tborder-fit: scale;\nsnippet bdf:sp\n\tborder-fit: space;\nsnippet bdf:st\n\tborder-fit: stretch;\nsnippet bdi\n\tborder-image: url(${1}) ${2:0} ${3:0} ${4:0} ${5:0} ${6:stretch} ${7:stretch};\nsnippet bdi:n\n\tborder-image: none;\nsnippet bdl+\n\tborder-left: ${1:1px} ${2:solid} #${3:000};\nsnippet bdlc\n\tborder-left-color: #${1:000};\nsnippet bdli\n\tborder-left-image: url(${1});\nsnippet bdli:n\n\tborder-left-image: none;\nsnippet bdls\n\tborder-left-style: ${1};\nsnippet bdls:n\n\tborder-left-style: none;\nsnippet bdlw\n\tborder-left-width: ${1};\nsnippet bdl\n\tborder-left: ${1};\nsnippet bdl:n\n\tborder-left: none;\nsnippet bdlt\n\tborder-length: ${1};\nsnippet bdlt:a\n\tborder-length: auto;\nsnippet bdrz\n\tborder-radius: ${1};\nsnippet bdr+\n\tborder-right: ${1:1px} ${2:solid} #${3:000};\nsnippet bdrc\n\tborder-right-color: #${1:000};\nsnippet bdri\n\tborder-right-image: url(${1});\nsnippet bdri:n\n\tborder-right-image: none;\nsnippet bdrs\n\tborder-right-style: ${1};\nsnippet bdrs:n\n\tborder-right-style: none;\nsnippet bdrw\n\tborder-right-width: ${1};\nsnippet bdr\n\tborder-right: ${1};\nsnippet bdr:n\n\tborder-right: none;\nsnippet bdsp\n\tborder-spacing: ${1};\nsnippet bds\n\tborder-style: ${1};\nsnippet bds:ds\n\tborder-style: dashed;\nsnippet bds:dtds\n\tborder-style: dot-dash;\nsnippet bds:dtdtds\n\tborder-style: dot-dot-dash;\nsnippet bds:dt\n\tborder-style: dotted;\nsnippet bds:db\n\tborder-style: double;\nsnippet bds:g\n\tborder-style: groove;\nsnippet bds:h\n\tborder-style: hidden;\nsnippet bds:i\n\tborder-style: inset;\nsnippet bds:n\n\tborder-style: none;\nsnippet bds:o\n\tborder-style: outset;\nsnippet bds:r\n\tborder-style: ridge;\nsnippet bds:s\n\tborder-style: solid;\nsnippet bds:w\n\tborder-style: wave;\nsnippet bdt+\n\tborder-top: ${1:1px} ${2:solid} #${3:000};\nsnippet bdtc\n\tborder-top-color: #${1:000};\nsnippet bdti\n\tborder-top-image: url(${1});\nsnippet bdti:n\n\tborder-top-image: none;\nsnippet bdtli\n\tborder-top-left-image: url(${1});\nsnippet bdtli:c\n\tborder-corner-image: continue;\nsnippet bdtli:n\n\tborder-corner-image: none;\nsnippet bdtlrz\n\tborder-top-left-radius: ${1};\nsnippet bdtri\n\tborder-top-right-image: url(${1});\nsnippet bdtri:c\n\tborder-top-right-image: continue;\nsnippet bdtri:n\n\tborder-top-right-image: none;\nsnippet bdtrrz\n\tborder-top-right-radius: ${1};\nsnippet bdts\n\tborder-top-style: ${1};\nsnippet bdts:n\n\tborder-top-style: none;\nsnippet bdtw\n\tborder-top-width: ${1};\nsnippet bdt\n\tborder-top: ${1};\nsnippet bdt:n\n\tborder-top: none;\nsnippet bdw\n\tborder-width: ${1};\nsnippet bd\n\tborder: ${1};\nsnippet bd:n\n\tborder: none;\nsnippet b\n\tbottom: ${1};\nsnippet b:a\n\tbottom: auto;\nsnippet bxsh+\n\tbox-shadow: ${1:0} ${2:0} ${3:0} #${4:000};\nsnippet bxsh\n\tbox-shadow: ${1};\nsnippet bxsh:n\n\tbox-shadow: none;\nsnippet bxz\n\tbox-sizing: ${1};\nsnippet bxz:bb\n\tbox-sizing: border-box;\nsnippet bxz:cb\n\tbox-sizing: content-box;\nsnippet cps\n\tcaption-side: ${1};\nsnippet cps:b\n\tcaption-side: bottom;\nsnippet cps:t\n\tcaption-side: top;\nsnippet cl\n\tclear: ${1};\nsnippet cl:b\n\tclear: both;\nsnippet cl:l\n\tclear: left;\nsnippet cl:n\n\tclear: none;\nsnippet cl:r\n\tclear: right;\nsnippet cp\n\tclip: ${1};\nsnippet cp:a\n\tclip: auto;\nsnippet cp:r\n\tclip: rect(${1:0} ${2:0} ${3:0} ${4:0});\nsnippet c\n\tcolor: #${1:000};\nsnippet ct\n\tcontent: ${1};\nsnippet ct:a\n\tcontent: attr(${1});\nsnippet ct:cq\n\tcontent: close-quote;\nsnippet ct:c\n\tcontent: counter(${1});\nsnippet ct:cs\n\tcontent: counters(${1});\nsnippet ct:ncq\n\tcontent: no-close-quote;\nsnippet ct:noq\n\tcontent: no-open-quote;\nsnippet ct:n\n\tcontent: normal;\nsnippet ct:oq\n\tcontent: open-quote;\nsnippet coi\n\tcounter-increment: ${1};\nsnippet cor\n\tcounter-reset: ${1};\nsnippet cur\n\tcursor: ${1};\nsnippet cur:a\n\tcursor: auto;\nsnippet cur:c\n\tcursor: crosshair;\nsnippet cur:d\n\tcursor: default;\nsnippet cur:ha\n\tcursor: hand;\nsnippet cur:he\n\tcursor: help;\nsnippet cur:m\n\tcursor: move;\nsnippet cur:p\n\tcursor: pointer;\nsnippet cur:t\n\tcursor: text;\nsnippet d\n\tdisplay: ${1};\nsnippet d:mib\n\tdisplay: -moz-inline-box;\nsnippet d:mis\n\tdisplay: -moz-inline-stack;\nsnippet d:b\n\tdisplay: block;\nsnippet d:cp\n\tdisplay: compact;\nsnippet d:ib\n\tdisplay: inline-block;\nsnippet d:itb\n\tdisplay: inline-table;\nsnippet d:i\n\tdisplay: inline;\nsnippet d:li\n\tdisplay: list-item;\nsnippet d:n\n\tdisplay: none;\nsnippet d:ri\n\tdisplay: run-in;\nsnippet d:tbcp\n\tdisplay: table-caption;\nsnippet d:tbc\n\tdisplay: table-cell;\nsnippet d:tbclg\n\tdisplay: table-column-group;\nsnippet d:tbcl\n\tdisplay: table-column;\nsnippet d:tbfg\n\tdisplay: table-footer-group;\nsnippet d:tbhg\n\tdisplay: table-header-group;\nsnippet d:tbrg\n\tdisplay: table-row-group;\nsnippet d:tbr\n\tdisplay: table-row;\nsnippet d:tb\n\tdisplay: table;\nsnippet ec\n\tempty-cells: ${1};\nsnippet ec:h\n\tempty-cells: hide;\nsnippet ec:s\n\tempty-cells: show;\nsnippet exp\n\texpression()\nsnippet fl\n\tfloat: ${1};\nsnippet fl:l\n\tfloat: left;\nsnippet fl:n\n\tfloat: none;\nsnippet fl:r\n\tfloat: right;\nsnippet f+\n\tfont: ${1:1em} ${2:Arial},${3:sans-serif};\nsnippet fef\n\tfont-effect: ${1};\nsnippet fef:eb\n\tfont-effect: emboss;\nsnippet fef:eg\n\tfont-effect: engrave;\nsnippet fef:n\n\tfont-effect: none;\nsnippet fef:o\n\tfont-effect: outline;\nsnippet femp\n\tfont-emphasize-position: ${1};\nsnippet femp:a\n\tfont-emphasize-position: after;\nsnippet femp:b\n\tfont-emphasize-position: before;\nsnippet fems\n\tfont-emphasize-style: ${1};\nsnippet fems:ac\n\tfont-emphasize-style: accent;\nsnippet fems:c\n\tfont-emphasize-style: circle;\nsnippet fems:ds\n\tfont-emphasize-style: disc;\nsnippet fems:dt\n\tfont-emphasize-style: dot;\nsnippet fems:n\n\tfont-emphasize-style: none;\nsnippet fem\n\tfont-emphasize: ${1};\nsnippet ff\n\tfont-family: ${1};\nsnippet ff:c\n\tfont-family: ${1:'Monotype Corsiva','Comic Sans MS'},cursive;\nsnippet ff:f\n\tfont-family: ${1:Capitals,Impact},fantasy;\nsnippet ff:m\n\tfont-family: ${1:Monaco,'Courier New'},monospace;\nsnippet ff:ss\n\tfont-family: ${1:Helvetica,Arial},sans-serif;\nsnippet ff:s\n\tfont-family: ${1:Georgia,'Times New Roman'},serif;\nsnippet fza\n\tfont-size-adjust: ${1};\nsnippet fza:n\n\tfont-size-adjust: none;\nsnippet fz\n\tfont-size: ${1};\nsnippet fsm\n\tfont-smooth: ${1};\nsnippet fsm:aw\n\tfont-smooth: always;\nsnippet fsm:a\n\tfont-smooth: auto;\nsnippet fsm:n\n\tfont-smooth: never;\nsnippet fst\n\tfont-stretch: ${1};\nsnippet fst:c\n\tfont-stretch: condensed;\nsnippet fst:e\n\tfont-stretch: expanded;\nsnippet fst:ec\n\tfont-stretch: extra-condensed;\nsnippet fst:ee\n\tfont-stretch: extra-expanded;\nsnippet fst:n\n\tfont-stretch: normal;\nsnippet fst:sc\n\tfont-stretch: semi-condensed;\nsnippet fst:se\n\tfont-stretch: semi-expanded;\nsnippet fst:uc\n\tfont-stretch: ultra-condensed;\nsnippet fst:ue\n\tfont-stretch: ultra-expanded;\nsnippet fs\n\tfont-style: ${1};\nsnippet fs:i\n\tfont-style: italic;\nsnippet fs:n\n\tfont-style: normal;\nsnippet fs:o\n\tfont-style: oblique;\nsnippet fv\n\tfont-variant: ${1};\nsnippet fv:n\n\tfont-variant: normal;\nsnippet fv:sc\n\tfont-variant: small-caps;\nsnippet fw\n\tfont-weight: ${1};\nsnippet fw:b\n\tfont-weight: bold;\nsnippet fw:br\n\tfont-weight: bolder;\nsnippet fw:lr\n\tfont-weight: lighter;\nsnippet fw:n\n\tfont-weight: normal;\nsnippet f\n\tfont: ${1};\nsnippet h\n\theight: ${1};\nsnippet h:a\n\theight: auto;\nsnippet l\n\tleft: ${1};\nsnippet l:a\n\tleft: auto;\nsnippet lts\n\tletter-spacing: ${1};\nsnippet lh\n\tline-height: ${1};\nsnippet lisi\n\tlist-style-image: url(${1});\nsnippet lisi:n\n\tlist-style-image: none;\nsnippet lisp\n\tlist-style-position: ${1};\nsnippet lisp:i\n\tlist-style-position: inside;\nsnippet lisp:o\n\tlist-style-position: outside;\nsnippet list\n\tlist-style-type: ${1};\nsnippet list:c\n\tlist-style-type: circle;\nsnippet list:dclz\n\tlist-style-type: decimal-leading-zero;\nsnippet list:dc\n\tlist-style-type: decimal;\nsnippet list:d\n\tlist-style-type: disc;\nsnippet list:lr\n\tlist-style-type: lower-roman;\nsnippet list:n\n\tlist-style-type: none;\nsnippet list:s\n\tlist-style-type: square;\nsnippet list:ur\n\tlist-style-type: upper-roman;\nsnippet lis\n\tlist-style: ${1};\nsnippet lis:n\n\tlist-style: none;\nsnippet mb\n\tmargin-bottom: ${1};\nsnippet mb:a\n\tmargin-bottom: auto;\nsnippet ml\n\tmargin-left: ${1};\nsnippet ml:a\n\tmargin-left: auto;\nsnippet mr\n\tmargin-right: ${1};\nsnippet mr:a\n\tmargin-right: auto;\nsnippet mt\n\tmargin-top: ${1};\nsnippet mt:a\n\tmargin-top: auto;\nsnippet m\n\tmargin: ${1};\nsnippet m:4\n\tmargin: ${1:0} ${2:0} ${3:0} ${4:0};\nsnippet m:3\n\tmargin: ${1:0} ${2:0} ${3:0};\nsnippet m:2\n\tmargin: ${1:0} ${2:0};\nsnippet m:0\n\tmargin: 0;\nsnippet m:a\n\tmargin: auto;\nsnippet mah\n\tmax-height: ${1};\nsnippet mah:n\n\tmax-height: none;\nsnippet maw\n\tmax-width: ${1};\nsnippet maw:n\n\tmax-width: none;\nsnippet mih\n\tmin-height: ${1};\nsnippet miw\n\tmin-width: ${1};\nsnippet op\n\topacity: ${1};\nsnippet op:ie\n\tfilter: progid:DXImageTransform.Microsoft.Alpha(Opacity=${1:100});\nsnippet op:ms\n\t-ms-filter: 'progid:DXImageTransform.Microsoft.Alpha(Opacity=${1:100})';\nsnippet orp\n\torphans: ${1};\nsnippet o+\n\toutline: ${1:1px} ${2:solid} #${3:000};\nsnippet oc\n\toutline-color: ${1:#000};\nsnippet oc:i\n\toutline-color: invert;\nsnippet oo\n\toutline-offset: ${1};\nsnippet os\n\toutline-style: ${1};\nsnippet ow\n\toutline-width: ${1};\nsnippet o\n\toutline: ${1};\nsnippet o:n\n\toutline: none;\nsnippet ovs\n\toverflow-style: ${1};\nsnippet ovs:a\n\toverflow-style: auto;\nsnippet ovs:mq\n\toverflow-style: marquee;\nsnippet ovs:mv\n\toverflow-style: move;\nsnippet ovs:p\n\toverflow-style: panner;\nsnippet ovs:s\n\toverflow-style: scrollbar;\nsnippet ovx\n\toverflow-x: ${1};\nsnippet ovx:a\n\toverflow-x: auto;\nsnippet ovx:h\n\toverflow-x: hidden;\nsnippet ovx:s\n\toverflow-x: scroll;\nsnippet ovx:v\n\toverflow-x: visible;\nsnippet ovy\n\toverflow-y: ${1};\nsnippet ovy:a\n\toverflow-y: auto;\nsnippet ovy:h\n\toverflow-y: hidden;\nsnippet ovy:s\n\toverflow-y: scroll;\nsnippet ovy:v\n\toverflow-y: visible;\nsnippet ov\n\toverflow: ${1};\nsnippet ov:a\n\toverflow: auto;\nsnippet ov:h\n\toverflow: hidden;\nsnippet ov:s\n\toverflow: scroll;\nsnippet ov:v\n\toverflow: visible;\nsnippet pb\n\tpadding-bottom: ${1};\nsnippet pl\n\tpadding-left: ${1};\nsnippet pr\n\tpadding-right: ${1};\nsnippet pt\n\tpadding-top: ${1};\nsnippet p\n\tpadding: ${1};\nsnippet p:4\n\tpadding: ${1:0} ${2:0} ${3:0} ${4:0};\nsnippet p:3\n\tpadding: ${1:0} ${2:0} ${3:0};\nsnippet p:2\n\tpadding: ${1:0} ${2:0};\nsnippet p:0\n\tpadding: 0;\nsnippet pgba\n\tpage-break-after: ${1};\nsnippet pgba:aw\n\tpage-break-after: always;\nsnippet pgba:a\n\tpage-break-after: auto;\nsnippet pgba:l\n\tpage-break-after: left;\nsnippet pgba:r\n\tpage-break-after: right;\nsnippet pgbb\n\tpage-break-before: ${1};\nsnippet pgbb:aw\n\tpage-break-before: always;\nsnippet pgbb:a\n\tpage-break-before: auto;\nsnippet pgbb:l\n\tpage-break-before: left;\nsnippet pgbb:r\n\tpage-break-before: right;\nsnippet pgbi\n\tpage-break-inside: ${1};\nsnippet pgbi:a\n\tpage-break-inside: auto;\nsnippet pgbi:av\n\tpage-break-inside: avoid;\nsnippet pos\n\tposition: ${1};\nsnippet pos:a\n\tposition: absolute;\nsnippet pos:f\n\tposition: fixed;\nsnippet pos:r\n\tposition: relative;\nsnippet pos:s\n\tposition: static;\nsnippet q\n\tquotes: ${1};\nsnippet q:en\n\tquotes: '\\201C' '\\201D' '\\2018' '\\2019';\nsnippet q:n\n\tquotes: none;\nsnippet q:ru\n\tquotes: '\\00AB' '\\00BB' '\\201E' '\\201C';\nsnippet rz\n\tresize: ${1};\nsnippet rz:b\n\tresize: both;\nsnippet rz:h\n\tresize: horizontal;\nsnippet rz:n\n\tresize: none;\nsnippet rz:v\n\tresize: vertical;\nsnippet r\n\tright: ${1};\nsnippet r:a\n\tright: auto;\nsnippet tbl\n\ttable-layout: ${1};\nsnippet tbl:a\n\ttable-layout: auto;\nsnippet tbl:f\n\ttable-layout: fixed;\nsnippet tal\n\ttext-align-last: ${1};\nsnippet tal:a\n\ttext-align-last: auto;\nsnippet tal:c\n\ttext-align-last: center;\nsnippet tal:l\n\ttext-align-last: left;\nsnippet tal:r\n\ttext-align-last: right;\nsnippet ta\n\ttext-align: ${1};\nsnippet ta:c\n\ttext-align: center;\nsnippet ta:l\n\ttext-align: left;\nsnippet ta:r\n\ttext-align: right;\nsnippet td\n\ttext-decoration: ${1};\nsnippet td:l\n\ttext-decoration: line-through;\nsnippet td:n\n\ttext-decoration: none;\nsnippet td:o\n\ttext-decoration: overline;\nsnippet td:u\n\ttext-decoration: underline;\nsnippet te\n\ttext-emphasis: ${1};\nsnippet te:ac\n\ttext-emphasis: accent;\nsnippet te:a\n\ttext-emphasis: after;\nsnippet te:b\n\ttext-emphasis: before;\nsnippet te:c\n\ttext-emphasis: circle;\nsnippet te:ds\n\ttext-emphasis: disc;\nsnippet te:dt\n\ttext-emphasis: dot;\nsnippet te:n\n\ttext-emphasis: none;\nsnippet th\n\ttext-height: ${1};\nsnippet th:a\n\ttext-height: auto;\nsnippet th:f\n\ttext-height: font-size;\nsnippet th:m\n\ttext-height: max-size;\nsnippet th:t\n\ttext-height: text-size;\nsnippet ti\n\ttext-indent: ${1};\nsnippet ti:-\n\ttext-indent: -9999px;\nsnippet tj\n\ttext-justify: ${1};\nsnippet tj:a\n\ttext-justify: auto;\nsnippet tj:d\n\ttext-justify: distribute;\nsnippet tj:ic\n\ttext-justify: inter-cluster;\nsnippet tj:ii\n\ttext-justify: inter-ideograph;\nsnippet tj:iw\n\ttext-justify: inter-word;\nsnippet tj:k\n\ttext-justify: kashida;\nsnippet tj:t\n\ttext-justify: tibetan;\nsnippet to+\n\ttext-outline: ${1:0} ${2:0} #${3:000};\nsnippet to\n\ttext-outline: ${1};\nsnippet to:n\n\ttext-outline: none;\nsnippet tr\n\ttext-replace: ${1};\nsnippet tr:n\n\ttext-replace: none;\nsnippet tsh+\n\ttext-shadow: ${1:0} ${2:0} ${3:0} #${4:000};\nsnippet tsh\n\ttext-shadow: ${1};\nsnippet tsh:n\n\ttext-shadow: none;\nsnippet tt\n\ttext-transform: ${1};\nsnippet tt:c\n\ttext-transform: capitalize;\nsnippet tt:l\n\ttext-transform: lowercase;\nsnippet tt:n\n\ttext-transform: none;\nsnippet tt:u\n\ttext-transform: uppercase;\nsnippet tw\n\ttext-wrap: ${1};\nsnippet tw:no\n\ttext-wrap: none;\nsnippet tw:n\n\ttext-wrap: normal;\nsnippet tw:s\n\ttext-wrap: suppress;\nsnippet tw:u\n\ttext-wrap: unrestricted;\nsnippet t\n\ttop: ${1};\nsnippet t:a\n\ttop: auto;\nsnippet va\n\tvertical-align: ${1};\nsnippet va:bl\n\tvertical-align: baseline;\nsnippet va:b\n\tvertical-align: bottom;\nsnippet va:m\n\tvertical-align: middle;\nsnippet va:sub\n\tvertical-align: sub;\nsnippet va:sup\n\tvertical-align: super;\nsnippet va:tb\n\tvertical-align: text-bottom;\nsnippet va:tt\n\tvertical-align: text-top;\nsnippet va:t\n\tvertical-align: top;\nsnippet v\n\tvisibility: ${1};\nsnippet v:c\n\tvisibility: collapse;\nsnippet v:h\n\tvisibility: hidden;\nsnippet v:v\n\tvisibility: visible;\nsnippet whsc\n\twhite-space-collapse: ${1};\nsnippet whsc:ba\n\twhite-space-collapse: break-all;\nsnippet whsc:bs\n\twhite-space-collapse: break-strict;\nsnippet whsc:k\n\twhite-space-collapse: keep-all;\nsnippet whsc:l\n\twhite-space-collapse: loose;\nsnippet whsc:n\n\twhite-space-collapse: normal;\nsnippet whs\n\twhite-space: ${1};\nsnippet whs:n\n\twhite-space: normal;\nsnippet whs:nw\n\twhite-space: nowrap;\nsnippet whs:pl\n\twhite-space: pre-line;\nsnippet whs:pw\n\twhite-space: pre-wrap;\nsnippet whs:p\n\twhite-space: pre;\nsnippet wid\n\twidows: ${1};\nsnippet w\n\twidth: ${1};\nsnippet w:a\n\twidth: auto;\nsnippet wob\n\tword-break: ${1};\nsnippet wob:ba\n\tword-break: break-all;\nsnippet wob:bs\n\tword-break: break-strict;\nsnippet wob:k\n\tword-break: keep-all;\nsnippet wob:l\n\tword-break: loose;\nsnippet wob:n\n\tword-break: normal;\nsnippet wos\n\tword-spacing: ${1};\nsnippet wow\n\tword-wrap: ${1};\nsnippet wow:no\n\tword-wrap: none;\nsnippet wow:n\n\tword-wrap: normal;\nsnippet wow:s\n\tword-wrap: suppress;\nsnippet wow:u\n\tword-wrap: unrestricted;\nsnippet z\n\tz-index: ${1};\nsnippet z:a\n\tz-index: auto;\nsnippet zoo\n\tzoom: 1;\n";

});

define("ace/snippets/css",["require","exports","module","ace/snippets/css.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./css.snippets");
exports.scope = "css";

});

define("ace/snippets/dart.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet lib\n\tlibrary ${1};\n\t${2}\nsnippet im\n\timport '${1}';\n\t${2}\nsnippet pa\n\tpart '${1}';\n\t${2}\nsnippet pao\n\tpart of ${1};\n\t${2}\nsnippet main\n\tvoid main() {\n\t  ${1:/* code */}\n\t}\nsnippet st\n\tstatic ${1}\nsnippet fi\n\tfinal ${1}\nsnippet re\n\treturn ${1}\nsnippet br\n\tbreak;\nsnippet th\n\tthrow ${1}\nsnippet cl\n\tclass ${1:`Filename(\"\", \"untitled\")`} ${2}\nsnippet imp\n\timplements ${1}\nsnippet ext\n\textends ${1}\nsnippet if\n\tif (${1:true}) {\n\t  ${2}\n\t}\nsnippet ife\n\tif (${1:true}) {\n\t  ${2}\n\t} else {\n\t  ${3}\n\t}\nsnippet el\n\telse\nsnippet sw\n\tswitch (${1}) {\n\t  ${2}\n\t}\nsnippet cs\n\tcase ${1}:\n\t  ${2}\nsnippet de\n\tdefault:\n\t  ${1}\nsnippet for\n\tfor (var ${2:i} = 0, len = ${1:things}.length; $2 < len; ${3:++}$2) {\n\t  ${4:$1[$2]}\n\t}\nsnippet fore\n\tfor (final ${2:item} in ${1:itemList}) {\n\t  ${3:/* code */}\n\t}\nsnippet wh\n\twhile (${1:/* condition */}) {\n\t  ${2:/* code */}\n\t}\nsnippet dowh\n\tdo {\n\t  ${2:/* code */}\n\t} while (${1:/* condition */});\nsnippet as\n\tassert(${1:/* condition */});\nsnippet try\n\ttry {\n\t  ${2}\n\t} catch (${1:Exception e}) {\n\t}\nsnippet tryf\n\ttry {\n\t  ${2}\n\t} catch (${1:Exception e}) {\n\t} finally {\n\t}\n";

});

define("ace/snippets/dart",["require","exports","module","ace/snippets/dart.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./dart.snippets");
exports.scope = "dart";

});

define("ace/snippets/diff.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# DEP-3 (http://dep.debian.net/deps/dep3/) style patch header\nsnippet header DEP-3 style header\n\tDescription: ${1}\n\tOrigin: ${2:vendor|upstream|other}, ${3:url of the original patch}\n\tBug: ${4:url in upstream bugtracker}\n\tForwarded: ${5:no|not-needed|url}\n\tAuthor: ${6:`g:snips_author`}\n\tReviewed-by: ${7:name and email}\n\tLast-Update: ${8:`strftime(\"%Y-%m-%d\")`}\n\tApplied-Upstream: ${9:upstream version|url|commit}\n\n";

});

define("ace/snippets/diff",["require","exports","module","ace/snippets/diff.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./diff.snippets");
exports.scope = "diff";

});

define("ace/snippets/django.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# Model Fields\n\n# Note: Optional arguments are using defaults that match what Django will use\n# as a default, e.g. with max_length fields.  Doing this as a form of self\n# documentation and to make it easy to know whether you should override the\n# default or not.\n\n# Note: Optional arguments that are booleans will use the opposite since you\n# can either not specify them, or override them, e.g. auto_now_add=False.\n\nsnippet auto\n\t${1:FIELDNAME} = models.AutoField(${2})\nsnippet bool\n\t${1:FIELDNAME} = models.BooleanField(${2:default=True})\nsnippet char\n\t${1:FIELDNAME} = models.CharField(max_length=${2}${3:, blank=True})\nsnippet comma\n\t${1:FIELDNAME} = models.CommaSeparatedIntegerField(max_length=${2}${3:, blank=True})\nsnippet date\n\t${1:FIELDNAME} = models.DateField(${2:auto_now_add=True, auto_now=True}${3:, blank=True, null=True})\nsnippet datetime\n\t${1:FIELDNAME} = models.DateTimeField(${2:auto_now_add=True, auto_now=True}${3:, blank=True, null=True})\nsnippet decimal\n\t${1:FIELDNAME} = models.DecimalField(max_digits=${2}, decimal_places=${3})\nsnippet email\n\t${1:FIELDNAME} = models.EmailField(max_length=${2:75}${3:, blank=True})\nsnippet file\n\t${1:FIELDNAME} = models.FileField(upload_to=${2:path/for/upload}${3:, max_length=100})\nsnippet filepath\n\t${1:FIELDNAME} = models.FilePathField(path=${2:\"/abs/path/to/dir\"}${3:, max_length=100}${4:, match=\"*.ext\"}${5:, recursive=True}${6:, blank=True, })\nsnippet float\n\t${1:FIELDNAME} = models.FloatField(${2})\nsnippet image\n\t${1:FIELDNAME} = models.ImageField(upload_to=${2:path/for/upload}${3:, height_field=height, width_field=width}${4:, max_length=100})\nsnippet int\n\t${1:FIELDNAME} = models.IntegerField(${2})\nsnippet ip\n\t${1:FIELDNAME} = models.IPAddressField(${2})\nsnippet nullbool\n\t${1:FIELDNAME} = models.NullBooleanField(${2})\nsnippet posint\n\t${1:FIELDNAME} = models.PositiveIntegerField(${2})\nsnippet possmallint\n\t${1:FIELDNAME} = models.PositiveSmallIntegerField(${2})\nsnippet slug\n\t${1:FIELDNAME} = models.SlugField(max_length=${2:50}${3:, blank=True})\nsnippet smallint\n\t${1:FIELDNAME} = models.SmallIntegerField(${2})\nsnippet text\n\t${1:FIELDNAME} = models.TextField(${2:blank=True})\nsnippet time\n\t${1:FIELDNAME} = models.TimeField(${2:auto_now_add=True, auto_now=True}${3:, blank=True, null=True})\nsnippet url\n\t${1:FIELDNAME} = models.URLField(${2:verify_exists=False}${3:, max_length=200}${4:, blank=True})\nsnippet xml\n\t${1:FIELDNAME} = models.XMLField(schema_path=${2:None}${3:, blank=True})\n# Relational Fields\nsnippet fk\n\t${1:FIELDNAME} = models.ForeignKey(${2:OtherModel}${3:, related_name=''}${4:, limit_choices_to=}${5:, to_field=''})\nsnippet m2m\n\t${1:FIELDNAME} = models.ManyToManyField(${2:OtherModel}${3:, related_name=''}${4:, limit_choices_to=}${5:, symmetrical=False}${6:, through=''}${7:, db_table=''})\nsnippet o2o\n\t${1:FIELDNAME} = models.OneToOneField(${2:OtherModel}${3:, parent_link=True}${4:, related_name=''}${5:, limit_choices_to=}${6:, to_field=''})\n\n# Code Skeletons\n\nsnippet form\n\tclass ${1:FormName}(forms.Form):\n\t\t\"\"\"${2:docstring}\"\"\"\n\t\t${3}\n\nsnippet model\n\tclass ${1:ModelName}(models.Model):\n\t\t\"\"\"${2:docstring}\"\"\"\n\t\t${3}\n\t\t\n\t\tclass Meta:\n\t\t\t${4}\n\t\t\n\t\tdef __unicode__(self):\n\t\t\t${5}\n\t\t\n\t\tdef save(self, force_insert=False, force_update=False):\n\t\t\t${6}\n\t\t\n\t\t@models.permalink\n\t\tdef get_absolute_url(self):\n\t\t\treturn ('${7:view_or_url_name}' ${8})\n\nsnippet modeladmin\n\tclass ${1:ModelName}Admin(admin.ModelAdmin):\n\t\t${2}\n\t\n\tadmin.site.register($1, $1Admin)\n\t\nsnippet tabularinline\n\tclass ${1:ModelName}Inline(admin.TabularInline):\n\t\tmodel = $1\n\nsnippet stackedinline\n\tclass ${1:ModelName}Inline(admin.StackedInline):\n\t\tmodel = $1\n\nsnippet r2r\n\treturn render_to_response('${1:template.html}', {\n\t\t\t${2}\n\t\t}${3:, context_instance=RequestContext(request)}\n\t)\n";

});

define("ace/snippets/django",["require","exports","module","ace/snippets/django.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./django.snippets");
exports.scope = "django";

});

define("ace/snippets/drools.snippets",["require","exports","module"], function(require, exports, module){module.exports = "\nsnippet rule\n\trule \"${1?:rule_name}\"\n\twhen\n\t\t${2:// when...} \n\tthen\n\t\t${3:// then...}\n\tend\n\nsnippet query\n\tquery ${1?:query_name}\n\t\t${2:// find} \n\tend\n\t\nsnippet declare\n\tdeclare ${1?:type_name}\n\t\t${2:// attributes} \n\tend\n\n";

});

define("ace/snippets/drools",["require","exports","module","ace/snippets/drools.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./drools.snippets");
exports.scope = "drools";

});

define("ace/snippets/edifact.snippets",["require","exports","module"], function(require, exports, module){module.exports = "## Access Modifiers\nsnippet u\n\tUN\nsnippet un\n\tUNB\nsnippet pr\n\tprivate\n##\n## Annotations\nsnippet before\n\t@Before\n\tstatic void ${1:intercept}(${2:args}) { ${3} }\nsnippet mm\n\t@ManyToMany\n\t${1}\nsnippet mo\n\t@ManyToOne\n\t${1}\nsnippet om\n\t@OneToMany${1:(cascade=CascadeType.ALL)}\n\t${2}\nsnippet oo\n\t@OneToOne\n\t${1}\n##\n## Basic Java packages and import\nsnippet im\n\timport\nsnippet j.b\n\tjava.beans.\nsnippet j.i\n\tjava.io.\nsnippet j.m\n\tjava.math.\nsnippet j.n\n\tjava.net.\nsnippet j.u\n\tjava.util.\n##\n## Class\nsnippet cl\n\tclass ${1:`Filename(\"\", \"untitled\")`} ${2}\nsnippet in\n\tinterface ${1:`Filename(\"\", \"untitled\")`} ${2:extends Parent}${3}\nsnippet tc\n\tpublic class ${1:`Filename()`} extends ${2:TestCase}\n##\n## Class Enhancements\nsnippet ext\n\textends \nsnippet imp\n\timplements\n##\n## Comments\nsnippet /*\n\t/*\n\t * ${1}\n\t */\n##\n## Constants\nsnippet co\n\tstatic public final ${1:String} ${2:var} = ${3};${4}\nsnippet cos\n\tstatic public final String ${1:var} = \"${2}\";${3}\n##\n## Control Statements\nsnippet case\n\tcase ${1}:\n\t\t${2}\nsnippet def\n\tdefault:\n\t\t${2}\nsnippet el\n\telse\nsnippet elif\n\telse if (${1}) ${2}\nsnippet if\n\tif (${1}) ${2}\nsnippet sw\n\tswitch (${1}) {\n\t\t${2}\n\t}\n##\n## Create a Method\nsnippet m\n\t${1:void} ${2:method}(${3}) ${4:throws }${5}\n##\n## Create a Variable\nsnippet v\n\t${1:String} ${2:var}${3: = null}${4};${5}\n##\n## Enhancements to Methods, variables, classes, etc.\nsnippet ab\n\tabstract\nsnippet fi\n\tfinal\nsnippet st\n\tstatic\nsnippet sy\n\tsynchronized\n##\n## Error Methods\nsnippet err\n\tSystem.err.print(\"${1:Message}\");\nsnippet errf\n\tSystem.err.printf(\"${1:Message}\", ${2:exception});\nsnippet errln\n\tSystem.err.println(\"${1:Message}\");\n##\n## Exception Handling\nsnippet as\n\tassert ${1:test} : \"${2:Failure message}\";${3}\nsnippet ca\n\tcatch(${1:Exception} ${2:e}) ${3}\nsnippet thr\n\tthrow\nsnippet ths\n\tthrows\nsnippet try\n\ttry {\n\t\t${3}\n\t} catch(${1:Exception} ${2:e}) {\n\t}\nsnippet tryf\n\ttry {\n\t\t${3}\n\t} catch(${1:Exception} ${2:e}) {\n\t} finally {\n\t}\n##\n## Find Methods\nsnippet findall\n\tList<${1:listName}> ${2:items} = ${1}.findAll();${3}\nsnippet findbyid\n\t${1:var} ${2:item} = ${1}.findById(${3});${4}\n##\n## Javadocs\nsnippet /**\n\t/**\n\t * ${1}\n\t */\nsnippet @au\n\t@author `system(\"grep \\`id -un\\` /etc/passwd | cut -d \\\":\\\" -f5 | cut -d \\\",\\\" -f1\")`\nsnippet @br\n\t@brief ${1:Description}\nsnippet @fi\n\t@file ${1:`Filename()`}.java\nsnippet @pa\n\t@param ${1:param}\nsnippet @re\n\t@return ${1:param}\n##\n## Logger Methods\nsnippet debug\n\tLogger.debug(${1:param});${2}\nsnippet error\n\tLogger.error(${1:param});${2}\nsnippet info\n\tLogger.info(${1:param});${2}\nsnippet warn\n\tLogger.warn(${1:param});${2}\n##\n## Loops\nsnippet enfor\n\tfor (${1} : ${2}) ${3}\nsnippet for\n\tfor (${1}; ${2}; ${3}) ${4}\nsnippet wh\n\twhile (${1}) ${2}\n##\n## Main method\nsnippet main\n\tpublic static void main (String[] args) {\n\t\t${1:/* code */}\n\t}\n##\n## Print Methods\nsnippet print\n\tSystem.out.print(\"${1:Message}\");\nsnippet printf\n\tSystem.out.printf(\"${1:Message}\", ${2:args});\nsnippet println\n\tSystem.out.println(${1});\n##\n## Render Methods\nsnippet ren\n\trender(${1:param});${2}\nsnippet rena\n\trenderArgs.put(\"${1}\", ${2});${3}\nsnippet renb\n\trenderBinary(${1:param});${2}\nsnippet renj\n\trenderJSON(${1:param});${2}\nsnippet renx\n\trenderXml(${1:param});${2}\n##\n## Setter and Getter Methods\nsnippet set\n\t${1:public} void set${3:}(${2:String} ${4:}){\n\t\tthis.$4 = $4;\n\t}\nsnippet get\n\t${1:public} ${2:String} get${3:}(){\n\t\treturn this.${4:};\n\t}\n##\n## Terminate Methods or Loops\nsnippet re\n\treturn\nsnippet br\n\tbreak;\n##\n## Test Methods\nsnippet t\n\tpublic void test${1:Name}() throws Exception {\n\t\t${2}\n\t}\nsnippet test\n\t@Test\n\tpublic void test${1:Name}() throws Exception {\n\t\t${2}\n\t}\n##\n## Utils\nsnippet Sc\n\tScanner\n##\n## Miscellaneous\nsnippet action\n\tpublic static void ${1:index}(${2:args}) { ${3} }\nsnippet rnf\n\tnotFound(${1:param});${2}\nsnippet rnfin\n\tnotFoundIfNull(${1:param});${2}\nsnippet rr\n\tredirect(${1:param});${2}\nsnippet ru\n\tunauthorized(${1:param});${2}\nsnippet unless\n\t(unless=${1:param});${2}\n";

});

define("ace/snippets/edifact",["require","exports","module","ace/snippets/edifact.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./edifact.snippets");
exports.scope = "edifact";

});

define("ace/snippets/erlang.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# module and export all\nsnippet mod\n\t-module(${1:`Filename('', 'my')`}).\n\t\n\t-compile([export_all]).\n\t\n\tstart() ->\n\t    ${2}\n\t\n\tstop() ->\n\t    ok.\n# define directive\nsnippet def\n\t-define(${1:macro}, ${2:body}).${3}\n# export directive\nsnippet exp\n\t-export([${1:function}/${2:arity}]).\n# include directive\nsnippet inc\n\t-include(\"${1:file}\").${2}\n# behavior directive\nsnippet beh\n\t-behaviour(${1:behaviour}).${2}\n# if expression\nsnippet if\n\tif\n\t    ${1:guard} ->\n\t        ${2:body}\n\tend\n# case expression\nsnippet case\n\tcase ${1:expression} of\n\t    ${2:pattern} ->\n\t        ${3:body};\n\tend\n# anonymous function\nsnippet fun\n\tfun (${1:Parameters}) -> ${2:body} end${3}\n# try...catch\nsnippet try\n\ttry\n\t    ${1}\n\tcatch\n\t    ${2:_:_} -> ${3:got_some_exception}\n\tend\n# record directive\nsnippet rec\n\t-record(${1:record}, {\n\t    ${2:field}=${3:value}}).${4}\n# todo comment\nsnippet todo\n\t%% TODO: ${1}\n## Snippets below (starting with '%') are in EDoc format.\n## See http://www.erlang.org/doc/apps/edoc/chapter.html#id56887 for more details\n# doc comment\nsnippet %d\n\t%% @doc ${1}\n# end of doc comment\nsnippet %e\n\t%% @end\n# specification comment\nsnippet %s\n\t%% @spec ${1}\n# private function marker\nsnippet %p\n\t%% @private\n# OTP application\nsnippet application\n\t-module(${1:`Filename('', 'my')`}).\n\n\t-behaviour(application).\n\n\t-export([start/2, stop/1]).\n\n\tstart(_Type, _StartArgs) ->\n\t    case ${2:root_supervisor}:start_link() of\n\t        {ok, Pid} ->\n\t            {ok, Pid};\n\t        Other ->\n\t\t          {error, Other}\n\t    end.\n\n\tstop(_State) ->\n\t    ok.\t\n# OTP supervisor\nsnippet supervisor\n\t-module(${1:`Filename('', 'my')`}).\n\n\t-behaviour(supervisor).\n\n\t%% API\n\t-export([start_link/0]).\n\n\t%% Supervisor callbacks\n\t-export([init/1]).\n\n\t-define(SERVER, ?MODULE).\n\n\tstart_link() ->\n\t    supervisor:start_link({local, ?SERVER}, ?MODULE, []).\n\n\tinit([]) ->\n\t    Server = {${2:my_server}, {$2, start_link, []},\n\t      permanent, 2000, worker, [$2]},\n\t    Children = [Server],\n\t    RestartStrategy = {one_for_one, 0, 1},\n\t    {ok, {RestartStrategy, Children}}.\n# OTP gen_server\nsnippet gen_server\n\t-module(${1:`Filename('', 'my')`}).\n\n\t-behaviour(gen_server).\n\n\t%% API\n\t-export([\n\t         start_link/0\n\t        ]).\n\n\t%% gen_server callbacks\n\t-export([init/1, handle_call/3, handle_cast/2, handle_info/2,\n\t         terminate/2, code_change/3]).\n\n\t-define(SERVER, ?MODULE).\n\n\t-record(state, {}).\n\n\t%%%===================================================================\n\t%%% API\n\t%%%===================================================================\n\n\tstart_link() ->\n\t    gen_server:start_link({local, ?SERVER}, ?MODULE, [], []).\n\n\t%%%===================================================================\n\t%%% gen_server callbacks\n\t%%%===================================================================\n\n\tinit([]) ->\n\t    {ok, #state{}}.\n\n\thandle_call(_Request, _From, State) ->\n\t    Reply = ok,\n\t    {reply, Reply, State}.\n\n\thandle_cast(_Msg, State) ->\n\t    {noreply, State}.\n\n\thandle_info(_Info, State) ->\n\t    {noreply, State}.\n\n\tterminate(_Reason, _State) ->\n\t    ok.\n\n\tcode_change(_OldVsn, State, _Extra) ->\n\t    {ok, State}.\n\n\t%%%===================================================================\n\t%%% Internal functions\n\t%%%===================================================================\n\n";

});

define("ace/snippets/erlang",["require","exports","module","ace/snippets/erlang.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./erlang.snippets");
exports.scope = "erlang";

});

define("ace/snippets/fsl.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet header\n\tmachine_name     : \"\";\n\tmachine_author   : \"\";\n\tmachine_license  : MIT;\n\tmachine_comment  : \"\";\n\tmachine_language : en;\n\tmachine_version  : 1.0.0;\n\tfsl_version      : 1.0.0;\n\tstart_states     : [];\n";

});

define("ace/snippets/fsl",["require","exports","module","ace/snippets/fsl.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./fsl.snippets");
exports.scope = "fsl";

});

define("ace/snippets/gobstones.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# scope: gobstones\n\n# program\nsnippet program\n\tprogram {\n\t\t${1:// cuerpo...}\n\t}\n\n# interactive program\nsnippet interactive program\n\tinteractive program {\n\t\t${1:INIT} -> { ${2:// cuerpo...} }\n\t\t${3:TIMEOUT(${4:5000}) -> { ${5:// cuerpo...} }\n\t\t${6:K_ENTER} -> { ${7:// cuerpo...} }\n\t\t_ -> {}\n\t}\n\n# procedure\nsnippet procedure\n\tprocedure ${1:Nombre}(${2:parametros}) {\n\t\t${3:// cuerpo...}\n\t}\n\n# function\nsnippet function\n\tfunction ${1:nombre}(${2:parametros}) {\n\t\treturn (${3:expresi\u00F3n..})\n\t}\n\n# return\nsnippet return\n\treturn (${1:expresi\u00F3n...})\n\n# type\nsnippet type\n\ttype ${1:Nombre}\n\n# is variant\nsnippet is variant\n\tis variant {\n\t\tcase ${1:NombreDelValor1} {}\n\t\tcase ${2:NombreDelValor2} {}\n\t\tcase ${3:NombreDelValor3} {}\n\t\tcase ${4:NombreDelValor4} {}\n\t}\n\n# is record\nsnippet is record\n\tis record {\n\t\tfield ${1:campo1} // ${2:Tipo}\n\t\tfield ${3:campo2} // ${4:Tipo}\n\t\tfield ${5:campo3} // ${6:Tipo}\n\t\tfield ${7:campo4} // ${8:Tipo}\n\t}\n\n# type _ is variant\nsnippet type _ is variant\n\ttype ${1:Nombre} is variant {\n\t\tcase ${2:NombreDelValor1} {}\n\t\tcase ${3:NombreDelValor2} {}\n\t\tcase ${4:NombreDelValor3} {}\n\t\tcase ${5:NombreDelValor4} {}\n\t}\n\n# type _ is record\nsnippet type _ is record\n\ttype ${1:Nombre} is record {\n\t\tfield ${2:campo1} // ${3:Tipo}\n\t\tfield ${4:campo2} // ${5:Tipo}\n\t\tfield ${6:campo3} // ${7:Tipo}\n\t\tfield ${8:campo4} // ${9:Tipo}\n\t}\n\n# repeat\nsnippet repeat\n\trepeat ${1:cantidad} {\n\t\t${2:// cuerpo...}\n\t}\n\n# foreach\nsnippet foreach\n\tforeach ${1:\u00EDndice} in ${2:lista} {\n\t\t${3:// cuerpo...}\n\t}\n\n# while\nsnippet while\n\twhile (${1?:condici\u00F3n}) {\n\t\t${2:// cuerpo...}\n\t}\n\n# if\nsnippet if\n\tif (${1?:condici\u00F3n}) {\n\t\t${2:// cuerpo...}\n\t}\n\n# elseif\nsnippet elseif\n\telseif (${1?:condici\u00F3n}) {\n\t\t${2:// cuerpo...}\n\t}\n\n# else\nsnippet else\n\telse {\n\t\t${1:// cuerpo...}\n\t}\n\n# if (con else)\nsnippet if (con else)\n\tif (${1:condici\u00F3n}) {\n\t\t${2:// cuerpo...}\n\t} else {\n\t\t${3:// cuerpo....}\n\t}\n\n# if (con elseif)\nsnippet if (con elseif)\n\tif (${1:condici\u00F3n}) {\n\t\t${2:// cuerpo...}\n\t} elseif (${3:condici\u00F3n}) {\n\t\t${4:// cuerpo...}\n\t}\n\n# if (con elseif y else)\nsnippet if (con elseif y else)\n\tif (${1:condici\u00F3n}) {\n\t\t${2:// cuerpo...}\n\t} elseif (${3:condici\u00F3n}) {\n\t\t${4:// cuerpo...}\n\t} else {\n\t\t${5:// cuerpo....}\n\t}\n\n# if (con 3 elseif)\nsnippet if (con 3 elseif)\n\tif (${1:condici\u00F3n}) {\n\t\t${2:// cuerpo...}\n\t} elseif (${3:condici\u00F3n}) {\n\t\t${4:// cuerpo...}\n\t} elseif (${5:condici\u00F3n}) {\n\t\t${6:// cuerpo...}\n\t} elseif (${7:condici\u00F3n}) {\n\t\t${8:// cuerpo...}\n\t}\n\n# choose (2 valores)\nsnippet choose (2 valores)\n\tchoose\n\t\t${1:Valor1} when (${2:condici\u00F3n})\n\t\t${3:Valor2} otherwise\n\n# choose (2 valores y boom)\nsnippet choose (2 valores y boom)\n\tchoose\n\t\t${1:Valor1} when (${2:condici\u00F3n})\n\t\t${3:Valor2} when (${4:condici\u00F3n})\n\t\t${5:Valor3} when (${6:condici\u00F3n})\n\t\t${7:Valor4} when (${8:condici\u00F3n})\n\t\tboom(\"${9:No es un valor v\u00E1lido}\") otherwise\n\n# matching (4 valores)\nsnippet matching (4 valores)\n\tmatching (${1:variable}) select\n\t\t${2:Valor1} on ${3:opci\u00F3n1}\n\t\t${4:Valor2} on ${5:opci\u00F3n2}\n\t\t${6:Valor3} on ${7:opci\u00F3n3}\n\t\t${8:Valor4} on ${9:opci\u00F3n4}\n\t\tboom(\"${10:No es un valor v\u00E1lido}\") otherwise\n\n# select (4 casos)\nsnippet select (4 casos)\n\tselect\n\t\t${1:Valor1} on (${2:opci\u00F3n1})\n\t\t${3:Valor2} on (${4:opci\u00F3n2})\n\t\t${5:Valor3} on (${6:opci\u00F3n3})\n\t\t${7:Valor4} on (${8:opci\u00F3n4})\n\t\tboom(\"${9:No es un valor v\u00E1lido}\") otherwise\n\n# switch\nsnippet switch\n\tswitch (${1:variable}) {\n\t\t${2:Valor1} -> {${3:// cuerpo...}}\n\t\t${4:Valor2} -> {${5:// cuerpo...}}\n\t\t${6:Valor3} -> {${7:// cuerpo...}}\n\t\t${8:Valor4} -> {${9:// cuerpo...}}\n\t\t_ -> {${10:// cuerpo...}}\n\t}\n\n# Poner\nsnippet Poner\n\tPoner(${1:color})\n\n# Sacar\nsnippet Sacar\n\tSacar(${1:color})\n\n# Mover\nsnippet Mover\n\tMover(${1:direcci\u00F3n})\n\n# IrAlBorde\nsnippet IrAlBorde\n\tIrAlBorde(${1:direcci\u00F3n})\n\n# VaciarTablero\nsnippet VaciarTablero\n\tVaciarTablero()\n\n# BOOM\nsnippet BOOM\n\tBOOM(\"${1:Mensaje de error}\")\n\n# hayBolitas\nsnippet hayBolitas\n\thayBolitas(${1:color})\n\n# nroBolitas\nsnippet nroBolitas\n\tnroBolitas(${1:color})\n\n# puedeMover\nsnippet puedeMover\n\tpuedeMover(${1:direcci\u00F3n})\n\n# siguiente\nsnippet siguiente\n\tsiguiente(${1:color|direcci\u00F3n})\n\n# previo\nsnippet previo\n\tprevio(${1:color|direcci\u00F3n})\n\n# opuesto\nsnippet opuesto\n\topuesto(${1:direcci\u00F3n})\n\n# minDir\nsnippet minDir\n\tminDir()\n\n# maxDir\nsnippet maxDir\n\tmaxDir()\n\n# minColor\nsnippet minColor\n\tminDir()\n\n# maxColor\nsnippet maxColor\n\tmaxDir()\n\n# minBool\nsnippet minBool\n\tminBool()\n\n# maxBool\nsnippet maxBool\n\tmaxBool()\n\n# primero\nsnippet primero\n\tprimero(${1:lista})\n\n# sinElPrimero\nsnippet sinElPrimero\n\tsinElPrimero(${1:lista})\n\n# esVac\u00EDa\nsnippet esVac\u00EDa\n\tesVac\u00EDa(${1:lista})\n\n# boom\nsnippet boom\n\tboom(\"${1:Mensaje de error}\")\n\n# Azul\nsnippet Azul\n\tAzul\n\n# Negro\nsnippet Negro\n\tNegro\n\n# Rojo\nsnippet Rojo\n\tRojo\n\n# Verde\nsnippet Verde\n\tVerde\n\n# Norte\nsnippet Norte\n\tNorte\n\n# Este\nsnippet Este\n\tEste\n\n# Sur\nsnippet Sur\n\tSur\n\n# Oeste\nsnippet Oeste\n\tOeste\n\n# True\nsnippet True\n\tTrue\n\n# False\nsnippet False\n\tFalse\n\n# INIT\nsnippet INIT\n\tINIT -> {$1:// cuerpo...}\n\n# TIMEOUT\nsnippet TIMEOUT\n\tTIMEOUT(${1:5000}) -> {$2:// cuerpo...}\n\n# K_A\nsnippet K_A\n\tK_A -> { ${1://cuerpo...} }\n# K_CTRL_A\nsnippet K_CTRL_A\n\tK_CTRL_A -> { ${1://cuerpo...} }\n# K_ALT_A\nsnippet K_ALT_A\n\tK_ALT_A -> { ${1://cuerpo...} }\n# K_SHIFT_A\nsnippet K_SHIFT_A\n\tK_SHIFT_A -> { ${1://cuerpo...} }\n# K_CTRL_ALT_A\nsnippet K_CTRL_ALT_A\n\tK_CTRL_ALT_A -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_A\nsnippet K_CTRL_SHIFT_A\n\tK_CTRL_SHIFT_A -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_A\nsnippet K_CTRL_ALT_SHIFT_A\n\tK_CTRL_ALT_SHIFT_A -> { ${1://cuerpo...} }\n\n# K_B\nsnippet K_B\n\tK_B -> { ${1://cuerpo...} }\n# K_CTRL_B\nsnippet K_CTRL_B\n\tK_CTRL_B -> { ${1://cuerpo...} }\n# K_ALT_B\nsnippet K_ALT_B\n\tK_ALT_B -> { ${1://cuerpo...} }\n# K_SHIFT_B\nsnippet K_SHIFT_B\n\tK_SHIFT_B -> { ${1://cuerpo...} }\n# K_CTRL_ALT_B\nsnippet K_CTRL_ALT_B\n\tK_CTRL_ALT_B -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_B\nsnippet K_CTRL_SHIFT_B\n\tK_CTRL_SHIFT_B -> { ${1://cuerpo...} }\n# K_ALT_SHIFT_C\nsnippet K_ALT_SHIFT_C\n\tK_ALT_SHIFT_C -> { ${1://cuerpo...} }\n# K_CTRL_BLT_SHIFT_B\nsnippet K_CTRL_BLT_SHIFT_B\n\tK_CTRL_ALT_SHIFT_B -> { ${1://cuerpo...} }\n\n# K_C\nsnippet K_C\n\tK_C -> { ${1://cuerpo...} }\n# K_CTRL_C\nsnippet K_CTRL_C\n\tK_CTRL_C -> { ${1://cuerpo...} }\n# K_ALT_C\nsnippet K_ALT_C\n\tK_ALT_C -> { ${1://cuerpo...} }\n# K_SHIFT_C\nsnippet K_SHIFT_C\n\tK_SHIFT_C -> { ${1://cuerpo...} }\n# K_CTRL_ALT_C\nsnippet K_CTRL_ALT_C\n\tK_CTRL_ALT_C -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_C\nsnippet K_CTRL_SHIFT_C\n\tK_CTRL_SHIFT_C -> { ${1://cuerpo...} }\n# K_ALT_SHIFT_C\nsnippet K_ALT_SHIFT_C\n\tK_ALT_SHIFT_C -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_C\nsnippet K_CTRL_ALT_SHIFT_C\n\tK_CTRL_ALT_SHIFT_C -> { ${1://cuerpo...} }\n\n# K_D\nsnippet K_D\n\tK_D -> { ${1://cuerpo...} }\n# K_CTRL_D\nsnippet K_CTRL_D\n\tK_CTRL_D -> { ${1://cuerpo...} }\n# K_ALT_D\nsnippet K_ALT_D\n\tK_DLT_D -> { ${1://cuerpo...} }\n# K_SHIFT_D\nsnippet K_SHIFT_D\n\tK_SHIFT_D -> { ${1://cuerpo...} }\n# K_CTRL_ALT_D\nsnippet K_CTRL_ALT_D\n\tK_CTRL_DLT_D -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_D\nsnippet K_CTRL_SHIFT_D\n\tK_CTRL_SHIFT_D -> { ${1://cuerpo...} }\n# K_ALT_SHIFT_D\nsnippet K_ALT_SHIFT_D\n\tK_ALT_SHIFT_D -> { ${1://cuerpo...} }\n# K_CTRL_DLT_SHIFT_D\nsnippet K_CTRL_DLT_SHIFT_D\n\tK_CTRL_ALT_SHIFT_D -> { ${1://cuerpo...} }\n\n# K_E\nsnippet K_E\n\tK_E -> { ${1://cuerpo...} }\n# K_CTRL_E\nsnippet K_CTRL_E\n\tK_CTRL_E -> { ${1://cuerpo...} }\n# K_ALT_E\nsnippet K_ALT_E\n\tK_ALT_E -> { ${1://cuerpo...} }\n# K_SHIFT_E\nsnippet K_SHIFT_E\n\tK_SHIFT_E -> { ${1://cuerpo...} }\n# K_CTRL_ALT_E\nsnippet K_CTRL_ALT_E\n\tK_CTRL_ALT_E -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_E\nsnippet K_CTRL_SHIFT_E\n\tK_CTRL_SHIFT_E -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_E\nsnippet K_CTRL_ALT_SHIFT_E\n\tK_CTRL_ALT_SHIFT_E -> { ${1://cuerpo...} }\n\n# K_F\nsnippet K_F\n\tK_F -> { ${1://cuerpo...} }\n# K_CTRL_F\nsnippet K_CTRL_F\n\tK_CTRL_F -> { ${1://cuerpo...} }\n# K_ALT_F\nsnippet K_ALT_F\n\tK_ALT_F -> { ${1://cuerpo...} }\n# K_SHIFT_F\nsnippet K_SHIFT_F\n\tK_SHIFT_F -> { ${1://cuerpo...} }\n# K_CTRL_ALT_F\nsnippet K_CTRL_ALT_F\n\tK_CTRL_ALT_F -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_F\nsnippet K_CTRL_SHIFT_F\n\tK_CTRL_SHIFT_F -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_F\nsnippet K_CTRL_ALT_SHIFT_F\n\tK_CTRL_ALT_SHIFT_F -> { ${1://cuerpo...} }\n\n# K_G\nsnippet K_G\n\tK_G -> { ${1://cuerpo...} }\n# K_CTRL_G\nsnippet K_CTRL_G\n\tK_CTRL_G -> { ${1://cuerpo...} }\n# K_ALT_G\nsnippet K_ALT_G\n\tK_ALT_G -> { ${1://cuerpo...} }\n# K_SHIFT_G\nsnippet K_SHIFT_G\n\tK_SHIFT_G -> { ${1://cuerpo...} }\n# K_CTRL_ALT_G\nsnippet K_CTRL_ALT_G\n\tK_CTRL_ALT_G -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_G\nsnippet K_CTRL_SHIFT_G\n\tK_CTRL_SHIFT_G -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_G\nsnippet K_CTRL_ALT_SHIFT_G\n\tK_CTRL_ALT_SHIFT_G -> { ${1://cuerpo...} }\n\n# K_H\nsnippet K_H\n\tK_H -> { ${1://cuerpo...} }\n# K_CTRL_H\nsnippet K_CTRL_H\n\tK_CTRL_H -> { ${1://cuerpo...} }\n# K_ALT_H\nsnippet K_ALT_H\n\tK_ALT_H -> { ${1://cuerpo...} }\n# K_SHIFT_H\nsnippet K_SHIFT_H\n\tK_SHIFT_H -> { ${1://cuerpo...} }\n# K_CTRL_ALT_H\nsnippet K_CTRL_ALT_H\n\tK_CTRL_ALT_H -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_H\nsnippet K_CTRL_SHIFT_H\n\tK_CTRL_SHIFT_H -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_H\nsnippet K_CTRL_ALT_SHIFT_H\n\tK_CTRL_ALT_SHIFT_H -> { ${1://cuerpo...} }\n\n# K_I\nsnippet K_I\n\tK_I -> { ${1://cuerpo...} }\n# K_CTRL_I\nsnippet K_CTRL_I\n\tK_CTRL_I -> { ${1://cuerpo...} }\n# K_ALT_I\nsnippet K_ALT_I\n\tK_ALT_I -> { ${1://cuerpo...} }\n# K_SHIFT_I\nsnippet K_SHIFT_I\n\tK_SHIFT_I -> { ${1://cuerpo...} }\n# K_CTRL_ALT_I\nsnippet K_CTRL_ALT_I\n\tK_CTRL_ALT_I -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_I\nsnippet K_CTRL_SHIFT_I\n\tK_CTRL_SHIFT_I -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_I\nsnippet K_CTRL_ALT_SHIFT_I\n\tK_CTRL_ALT_SHIFT_I -> { ${1://cuerpo...} }\n\n# K_J\nsnippet K_J\n\tK_J -> { ${1://cuerpo...} }\n# K_CTRL_J\nsnippet K_CTRL_J\n\tK_CTRL_J -> { ${1://cuerpo...} }\n# K_ALT_J\nsnippet K_ALT_J\n\tK_ALT_J -> { ${1://cuerpo...} }\n# K_SHIFT_J\nsnippet K_SHIFT_J\n\tK_SHIFT_J -> { ${1://cuerpo...} }\n# K_CTRL_ALT_J\nsnippet K_CTRL_ALT_J\n\tK_CTRL_ALT_J -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_J\nsnippet K_CTRL_SHIFT_J\n\tK_CTRL_SHIFT_J -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_J\nsnippet K_CTRL_ALT_SHIFT_J\n\tK_CTRL_ALT_SHIFT_J -> { ${1://cuerpo...} }\n\n# K_K\nsnippet K_K\n\tK_K -> { ${1://cuerpo...} }\n# K_CTRL_K\nsnippet K_CTRL_K\n\tK_CTRL_K -> { ${1://cuerpo...} }\n# K_ALT_K\nsnippet K_ALT_K\n\tK_ALT_K -> { ${1://cuerpo...} }\n# K_SHIFT_K\nsnippet K_SHIFT_K\n\tK_SHIFT_K -> { ${1://cuerpo...} }\n# K_CTRL_ALT_K\nsnippet K_CTRL_ALT_K\n\tK_CTRL_ALT_K -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_K\nsnippet K_CTRL_SHIFT_K\n\tK_CTRL_SHIFT_K -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_K\nsnippet K_CTRL_ALT_SHIFT_K\n\tK_CTRL_ALT_SHIFT_K -> { ${1://cuerpo...} }\n\n# K_L\nsnippet K_L\n\tK_L -> { ${1://cuerpo...} }\n# K_CTRL_L\nsnippet K_CTRL_L\n\tK_CTRL_L -> { ${1://cuerpo...} }\n# K_ALT_L\nsnippet K_ALT_L\n\tK_ALT_L -> { ${1://cuerpo...} }\n# K_SHIFT_L\nsnippet K_SHIFT_L\n\tK_SHIFT_L -> { ${1://cuerpo...} }\n# K_CTRL_ALT_L\nsnippet K_CTRL_ALT_L\n\tK_CTRL_ALT_L -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_L\nsnippet K_CTRL_SHIFT_L\n\tK_CTRL_SHIFT_L -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_L\nsnippet K_CTRL_ALT_SHIFT_L\n\tK_CTRL_ALT_SHIFT_L -> { ${1://cuerpo...} }\n\n# K_M\nsnippet K_M\n\tK_M -> { ${1://cuerpo...} }\n# K_CTRL_M\nsnippet K_CTRL_M\n\tK_CTRL_M -> { ${1://cuerpo...} }\n# K_ALT_M\nsnippet K_ALT_M\n\tK_ALT_M -> { ${1://cuerpo...} }\n# K_SHIFT_M\nsnippet K_SHIFT_M\n\tK_SHIFT_M -> { ${1://cuerpo...} }\n# K_CTRL_ALT_M\nsnippet K_CTRL_ALT_M\n\tK_CTRL_ALT_M -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_M\nsnippet K_CTRL_SHIFT_M\n\tK_CTRL_SHIFT_M -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_M\nsnippet K_CTRL_ALT_SHIFT_M\n\tK_CTRL_ALT_SHIFT_M -> { ${1://cuerpo...} }\n\n# K_N\nsnippet K_N\n\tK_N -> { ${1://cuerpo...} }\n# K_CTRL_N\nsnippet K_CTRL_N\n\tK_CTRL_N -> { ${1://cuerpo...} }\n# K_ALT_N\nsnippet K_ALT_N\n\tK_ALT_N -> { ${1://cuerpo...} }\n# K_SHIFT_N\nsnippet K_SHIFT_N\n\tK_SHIFT_N -> { ${1://cuerpo...} }\n# K_CTRL_ALT_N\nsnippet K_CTRL_ALT_N\n\tK_CTRL_ALT_N -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_N\nsnippet K_CTRL_SHIFT_N\n\tK_CTRL_SHIFT_N -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_N\nsnippet K_CTRL_ALT_SHIFT_N\n\tK_CTRL_ALT_SHIFT_N -> { ${1://cuerpo...} }\n\n# K_\u00D1\nsnippet K_\u00D1\n\tK_\u00D1 -> { ${1://cuerpo...} }\n# K_CTRL_\u00D1\nsnippet K_CTRL_\u00D1\n\tK_CTRL_\u00D1 -> { ${1://cuerpo...} }\n# K_ALT_\u00D1\nsnippet K_ALT_\u00D1\n\tK_ALT_\u00D1 -> { ${1://cuerpo...} }\n# K_SHIFT_\u00D1\nsnippet K_SHIFT_\u00D1\n\tK_SHIFT_\u00D1 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_\u00D1\nsnippet K_CTRL_ALT_\u00D1\n\tK_CTRL_ALT_\u00D1 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_\u00D1\nsnippet K_CTRL_SHIFT_\u00D1\n\tK_CTRL_SHIFT_\u00D1 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_\u00D1\nsnippet K_CTRL_ALT_SHIFT_\u00D1\n\tK_CTRL_ALT_SHIFT_\u00D1 -> { ${1://cuerpo...} }\n\n# K_O\nsnippet K_O\n\tK_O -> { ${1://cuerpo...} }\n# K_CTRL_O\nsnippet K_CTRL_O\n\tK_CTRL_O -> { ${1://cuerpo...} }\n# K_ALT_O\nsnippet K_ALT_O\n\tK_ALT_O -> { ${1://cuerpo...} }\n# K_SHIFT_O\nsnippet K_SHIFT_O\n\tK_SHIFT_O -> { ${1://cuerpo...} }\n# K_CTRL_ALT_O\nsnippet K_CTRL_ALT_O\n\tK_CTRL_ALT_O -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_O\nsnippet K_CTRL_SHIFT_O\n\tK_CTRL_SHIFT_O -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_O\nsnippet K_CTRL_ALT_SHIFT_O\n\tK_CTRL_ALT_SHIFT_O -> { ${1://cuerpo...} }\n\n# K_P\nsnippet K_P\n\tK_P -> { ${1://cuerpo...} }\n# K_CTRL_P\nsnippet K_CTRL_P\n\tK_CTRL_P -> { ${1://cuerpo...} }\n# K_ALT_P\nsnippet K_ALT_P\n\tK_ALT_P -> { ${1://cuerpo...} }\n# K_SHIFT_P\nsnippet K_SHIFT_P\n\tK_SHIFT_P -> { ${1://cuerpo...} }\n# K_CTRL_ALT_P\nsnippet K_CTRL_ALT_P\n\tK_CTRL_ALT_P -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_P\nsnippet K_CTRL_SHIFT_P\n\tK_CTRL_SHIFT_P -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_P\nsnippet K_CTRL_ALT_SHIFT_P\n\tK_CTRL_ALT_SHIFT_P -> { ${1://cuerpo...} }\n\n# K_Q\nsnippet K_Q\n\tK_Q -> { ${1://cuerpo...} }\n# K_CTRL_Q\nsnippet K_CTRL_Q\n\tK_CTRL_Q -> { ${1://cuerpo...} }\n# K_ALT_Q\nsnippet K_ALT_Q\n\tK_ALT_Q -> { ${1://cuerpo...} }\n# K_SHIFT_Q\nsnippet K_SHIFT_Q\n\tK_SHIFT_Q -> { ${1://cuerpo...} }\n# K_CTRL_ALT_Q\nsnippet K_CTRL_ALT_Q\n\tK_CTRL_ALT_Q -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_Q\nsnippet K_CTRL_SHIFT_Q\n\tK_CTRL_SHIFT_Q -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_Q\nsnippet K_CTRL_ALT_SHIFT_Q\n\tK_CTRL_ALT_SHIFT_Q -> { ${1://cuerpo...} }\n\n# K_R\nsnippet K_R\n\tK_R -> { ${1://cuerpo...} }\n# K_CTRL_R\nsnippet K_CTRL_R\n\tK_CTRL_R -> { ${1://cuerpo...} }\n# K_ALT_R\nsnippet K_ALT_R\n\tK_ALT_R -> { ${1://cuerpo...} }\n# K_SHIFT_R\nsnippet K_SHIFT_R\n\tK_SHIFT_R -> { ${1://cuerpo...} }\n# K_CTRL_ALT_R\nsnippet K_CTRL_ALT_R\n\tK_CTRL_ALT_R -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_R\nsnippet K_CTRL_SHIFT_R\n\tK_CTRL_SHIFT_R -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_R\nsnippet K_CTRL_ALT_SHIFT_R\n\tK_CTRL_ALT_SHIFT_R -> { ${1://cuerpo...} }\n\n# K_S\nsnippet K_S\n\tK_S -> { ${1://cuerpo...} }\n# K_CTRL_S\nsnippet K_CTRL_S\n\tK_CTRL_S -> { ${1://cuerpo...} }\n# K_ALT_S\nsnippet K_ALT_S\n\tK_ALT_S -> { ${1://cuerpo...} }\n# K_SHIFT_S\nsnippet K_SHIFT_S\n\tK_SHIFT_S -> { ${1://cuerpo...} }\n# K_CTRL_ALT_S\nsnippet K_CTRL_ALT_S\n\tK_CTRL_ALT_S -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_S\nsnippet K_CTRL_SHIFT_S\n\tK_CTRL_SHIFT_S -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_S\nsnippet K_CTRL_ALT_SHIFT_S\n\tK_CTRL_ALT_SHIFT_S -> { ${1://cuerpo...} }\n\n# K_T\nsnippet K_T\n\tK_T -> { ${1://cuerpo...} }\n# K_CTRL_T\nsnippet K_CTRL_T\n\tK_CTRL_T -> { ${1://cuerpo...} }\n# K_ALT_T\nsnippet K_ALT_T\n\tK_ALT_T -> { ${1://cuerpo...} }\n# K_SHIFT_T\nsnippet K_SHIFT_T\n\tK_SHIFT_T -> { ${1://cuerpo...} }\n# K_CTRL_ALT_T\nsnippet K_CTRL_ALT_T\n\tK_CTRL_ALT_T -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_T\nsnippet K_CTRL_SHIFT_T\n\tK_CTRL_SHIFT_T -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_T\nsnippet K_CTRL_ALT_SHIFT_T\n\tK_CTRL_ALT_SHIFT_T -> { ${1://cuerpo...} }\n\n# K_U\nsnippet K_U\n\tK_U -> { ${1://cuerpo...} }\n# K_CTRL_U\nsnippet K_CTRL_U\n\tK_CTRL_U -> { ${1://cuerpo...} }\n# K_ALT_U\nsnippet K_ALT_U\n\tK_ALT_U -> { ${1://cuerpo...} }\n# K_SHIFT_U\nsnippet K_SHIFT_U\n\tK_SHIFT_U -> { ${1://cuerpo...} }\n# K_CTRL_ALT_U\nsnippet K_CTRL_ALT_U\n\tK_CTRL_ALT_U -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_U\nsnippet K_CTRL_SHIFT_U\n\tK_CTRL_SHIFT_U -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_U\nsnippet K_CTRL_ALT_SHIFT_U\n\tK_CTRL_ALT_SHIFT_U -> { ${1://cuerpo...} }\n\n# K_V\nsnippet K_V\n\tK_V -> { ${1://cuerpo...} }\n# K_CTRL_V\nsnippet K_CTRL_V\n\tK_CTRL_V -> { ${1://cuerpo...} }\n# K_ALT_V\nsnippet K_ALT_V\n\tK_ALT_V -> { ${1://cuerpo...} }\n# K_SHIFT_V\nsnippet K_SHIFT_V\n\tK_SHIFT_V -> { ${1://cuerpo...} }\n# K_CTRL_ALT_V\nsnippet K_CTRL_ALT_V\n\tK_CTRL_ALT_V -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_V\nsnippet K_CTRL_SHIFT_V\n\tK_CTRL_SHIFT_V -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_V\nsnippet K_CTRL_ALT_SHIFT_V\n\tK_CTRL_ALT_SHIFT_V -> { ${1://cuerpo...} }\n\n# K_W\nsnippet K_W\n\tK_W -> { ${1://cuerpo...} }\n# K_CTRL_W\nsnippet K_CTRL_W\n\tK_CTRL_W -> { ${1://cuerpo...} }\n# K_ALT_W\nsnippet K_ALT_W\n\tK_ALT_W -> { ${1://cuerpo...} }\n# K_SHIFT_W\nsnippet K_SHIFT_W\n\tK_SHIFT_W -> { ${1://cuerpo...} }\n# K_CTRL_ALT_W\nsnippet K_CTRL_ALT_W\n\tK_CTRL_ALT_W -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_W\nsnippet K_CTRL_SHIFT_W\n\tK_CTRL_SHIFT_W -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_W\nsnippet K_CTRL_ALT_SHIFT_W\n\tK_CTRL_ALT_SHIFT_W -> { ${1://cuerpo...} }\n\n# K_X\nsnippet K_X\n\tK_X -> { ${1://cuerpo...} }\n# K_CTRL_X\nsnippet K_CTRL_X\n\tK_CTRL_X -> { ${1://cuerpo...} }\n# K_ALT_X\nsnippet K_ALT_X\n\tK_ALT_X -> { ${1://cuerpo...} }\n# K_SHIFT_X\nsnippet K_SHIFT_X\n\tK_SHIFT_X -> { ${1://cuerpo...} }\n# K_CTRL_ALT_X\nsnippet K_CTRL_ALT_X\n\tK_CTRL_ALT_X -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_X\nsnippet K_CTRL_SHIFT_X\n\tK_CTRL_SHIFT_X -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_X\nsnippet K_CTRL_ALT_SHIFT_X\n\tK_CTRL_ALT_SHIFT_X -> { ${1://cuerpo...} }\n\n# K_Y\nsnippet K_Y\n\tK_Y -> { ${1://cuerpo...} }\n# K_CTRL_Y\nsnippet K_CTRL_Y\n\tK_CTRL_Y -> { ${1://cuerpo...} }\n# K_ALT_Y\nsnippet K_ALT_Y\n\tK_ALT_Y -> { ${1://cuerpo...} }\n# K_SHIFT_Y\nsnippet K_SHIFT_Y\n\tK_SHIFT_Y -> { ${1://cuerpo...} }\n# K_CTRL_ALT_Y\nsnippet K_CTRL_ALT_Y\n\tK_CTRL_ALT_Y -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_Y\nsnippet K_CTRL_SHIFT_Y\n\tK_CTRL_SHIFT_Y -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_Y\nsnippet K_CTRL_ALT_SHIFT_Y\n\tK_CTRL_ALT_SHIFT_Y -> { ${1://cuerpo...} }\n\n# K_Z\nsnippet K_Z\n\tK_Z -> { ${1://cuerpo...} }\n# K_CTRL_Z\nsnippet K_CTRL_Z\n\tK_CTRL_Z -> { ${1://cuerpo...} }\n# K_ALT_Z\nsnippet K_ALT_Z\n\tK_ALT_Z -> { ${1://cuerpo...} }\n# K_SHIFT_Z\nsnippet K_SHIFT_Z\n\tK_SHIFT_Z -> { ${1://cuerpo...} }\n# K_CTRL_ALT_Z\nsnippet K_CTRL_ALT_Z\n\tK_CTRL_ALT_Z -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_Z\nsnippet K_CTRL_SHIFT_Z\n\tK_CTRL_SHIFT_Z -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_Z\nsnippet K_CTRL_ALT_SHIFT_Z\n\tK_CTRL_ALT_SHIFT_Z -> { ${1://cuerpo...} }\n\n# K_0\nsnippet K_0\n\tK_0 -> { ${1://cuerpo...} }\n# K_CTRL_0\nsnippet K_CTRL_0\n\tK_CTRL_0 -> { ${1://cuerpo...} }\n# K_ALT_0\nsnippet K_ALT_0\n\tK_ALT_0 -> { ${1://cuerpo...} }\n# K_SHIFT_0\nsnippet K_SHIFT_0\n\tK_SHIFT_0 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_0\nsnippet K_CTRL_ALT_0\n\tK_CTRL_ALT_0 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_0\nsnippet K_CTRL_SHIFT_0\n\tK_CTRL_SHIFT_0 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_0\nsnippet K_CTRL_ALT_SHIFT_0\n\tK_CTRL_ALT_SHIFT_0 -> { ${1://cuerpo...} }\n\n# K_1\nsnippet K_1\n\tK_1 -> { ${1://cuerpo...} }\n# K_CTRL_1\nsnippet K_CTRL_1\n\tK_CTRL_1 -> { ${1://cuerpo...} }\n# K_ALT_1\nsnippet K_ALT_1\n\tK_ALT_1 -> { ${1://cuerpo...} }\n# K_SHIFT_1\nsnippet K_SHIFT_1\n\tK_SHIFT_1 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_1\nsnippet K_CTRL_ALT_1\n\tK_CTRL_ALT_1 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_1\nsnippet K_CTRL_SHIFT_1\n\tK_CTRL_SHIFT_1 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_1\nsnippet K_CTRL_ALT_SHIFT_1\n\tK_CTRL_ALT_SHIFT_1 -> { ${1://cuerpo...} }\n\n# K_2\nsnippet K_2\n\tK_2 -> { ${1://cuerpo...} }\n# K_CTRL_2\nsnippet K_CTRL_2\n\tK_CTRL_2 -> { ${1://cuerpo...} }\n# K_ALT_2\nsnippet K_ALT_2\n\tK_ALT_2 -> { ${1://cuerpo...} }\n# K_SHIFT_2\nsnippet K_SHIFT_2\n\tK_SHIFT_2 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_2\nsnippet K_CTRL_ALT_2\n\tK_CTRL_ALT_2 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_2\nsnippet K_CTRL_SHIFT_2\n\tK_CTRL_SHIFT_2 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_2\nsnippet K_CTRL_ALT_SHIFT_2\n\tK_CTRL_ALT_SHIFT_2 -> { ${1://cuerpo...} }\n\n# K_3\nsnippet K_3\n\tK_3 -> { ${1://cuerpo...} }\n# K_CTRL_3\nsnippet K_CTRL_3\n\tK_CTRL_3 -> { ${1://cuerpo...} }\n# K_ALT_3\nsnippet K_ALT_3\n\tK_ALT_3 -> { ${1://cuerpo...} }\n# K_SHIFT_3\nsnippet K_SHIFT_3\n\tK_SHIFT_3 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_3\nsnippet K_CTRL_ALT_3\n\tK_CTRL_ALT_3 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_3\nsnippet K_CTRL_SHIFT_3\n\tK_CTRL_SHIFT_3 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_3\nsnippet K_CTRL_ALT_SHIFT_3\n\tK_CTRL_ALT_SHIFT_3 -> { ${1://cuerpo...} }\n\n# K_4\nsnippet K_4\n\tK_4 -> { ${1://cuerpo...} }\n# K_CTRL_4\nsnippet K_CTRL_4\n\tK_CTRL_4 -> { ${1://cuerpo...} }\n# K_ALT_4\nsnippet K_ALT_4\n\tK_ALT_4 -> { ${1://cuerpo...} }\n# K_SHIFT_4\nsnippet K_SHIFT_4\n\tK_SHIFT_4 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_4\nsnippet K_CTRL_ALT_4\n\tK_CTRL_ALT_4 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_4\nsnippet K_CTRL_SHIFT_4\n\tK_CTRL_SHIFT_4 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_4\nsnippet K_CTRL_ALT_SHIFT_4\n\tK_CTRL_ALT_SHIFT_4 -> { ${1://cuerpo...} }\n\n# K_5\nsnippet K_5\n\tK_5 -> { ${1://cuerpo...} }\n# K_CTRL_5\nsnippet K_CTRL_5\n\tK_CTRL_5 -> { ${1://cuerpo...} }\n# K_ALT_5\nsnippet K_ALT_5\n\tK_ALT_5 -> { ${1://cuerpo...} }\n# K_SHIFT_5\nsnippet K_SHIFT_5\n\tK_SHIFT_5 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_5\nsnippet K_CTRL_ALT_5\n\tK_CTRL_ALT_5 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_5\nsnippet K_CTRL_SHIFT_5\n\tK_CTRL_SHIFT_5 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_5\nsnippet K_CTRL_ALT_SHIFT_5\n\tK_CTRL_ALT_SHIFT_5 -> { ${1://cuerpo...} }\n\n# K_6\nsnippet K_6\n\tK_6 -> { ${1://cuerpo...} }\n# K_CTRL_6\nsnippet K_CTRL_6\n\tK_CTRL_6 -> { ${1://cuerpo...} }\n# K_ALT_6\nsnippet K_ALT_6\n\tK_ALT_6 -> { ${1://cuerpo...} }\n# K_SHIFT_6\nsnippet K_SHIFT_6\n\tK_SHIFT_6 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_6\nsnippet K_CTRL_ALT_6\n\tK_CTRL_ALT_6 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_6\nsnippet K_CTRL_SHIFT_6\n\tK_CTRL_SHIFT_6 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_6\nsnippet K_CTRL_ALT_SHIFT_6\n\tK_CTRL_ALT_SHIFT_6 -> { ${1://cuerpo...} }\n\n# K_7\nsnippet K_7\n\tK_7 -> { ${1://cuerpo...} }\n# K_CTRL_7\nsnippet K_CTRL_7\n\tK_CTRL_7 -> { ${1://cuerpo...} }\n# K_ALT_7\nsnippet K_ALT_7\n\tK_ALT_7 -> { ${1://cuerpo...} }\n# K_SHIFT_7\nsnippet K_SHIFT_7\n\tK_SHIFT_7 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_7\nsnippet K_CTRL_ALT_7\n\tK_CTRL_ALT_7 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_7\nsnippet K_CTRL_SHIFT_7\n\tK_CTRL_SHIFT_7 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_7\nsnippet K_CTRL_ALT_SHIFT_7\n\tK_CTRL_ALT_SHIFT_7 -> { ${1://cuerpo...} }\n\n# K_8\nsnippet K_8\n\tK_8 -> { ${1://cuerpo...} }\n# K_CTRL_8\nsnippet K_CTRL_8\n\tK_CTRL_8 -> { ${1://cuerpo...} }\n# K_ALT_8\nsnippet K_ALT_8\n\tK_ALT_8 -> { ${1://cuerpo...} }\n# K_SHIFT_8\nsnippet K_SHIFT_8\n\tK_SHIFT_8 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_8\nsnippet K_CTRL_ALT_8\n\tK_CTRL_ALT_8 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_8\nsnippet K_CTRL_SHIFT_8\n\tK_CTRL_SHIFT_8 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_8\nsnippet K_CTRL_ALT_SHIFT_8\n\tK_CTRL_ALT_SHIFT_8 -> { ${1://cuerpo...} }\n\n# K_9\nsnippet K_9\n\tK_9 -> { ${1://cuerpo...} }\n# K_CTRL_9\nsnippet K_CTRL_9\n\tK_CTRL_9 -> { ${1://cuerpo...} }\n# K_ALT_9\nsnippet K_ALT_9\n\tK_ALT_9 -> { ${1://cuerpo...} }\n# K_SHIFT_9\nsnippet K_SHIFT_9\n\tK_SHIFT_9 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_9\nsnippet K_CTRL_ALT_9\n\tK_CTRL_ALT_9 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_9\nsnippet K_CTRL_SHIFT_9\n\tK_CTRL_SHIFT_9 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_9\nsnippet K_CTRL_ALT_SHIFT_9\n\tK_CTRL_ALT_SHIFT_9 -> { ${1://cuerpo...} }\n\n# K_F1\nsnippet K_F1\n\tK_F1 -> { ${1://cuerpo...} }\n# K_CTRL_F1\nsnippet K_CTRL_F1\n\tK_CTRL_F1 -> { ${1://cuerpo...} }\n# K_ALT_F1\nsnippet K_ALT_F1\n\tK_ALT_F1 -> { ${1://cuerpo...} }\n# K_SHIFT_F1\nsnippet K_SHIFT_F1\n\tK_SHIFT_F1 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_F1\nsnippet K_CTRL_ALT_F1\n\tK_CTRL_ALT_F1 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_F1\nsnippet K_CTRL_SHIFT_F1\n\tK_CTRL_SHIFT_F1 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_F1\nsnippet K_CTRL_ALT_SHIFT_F1\n\tK_CTRL_ALT_SHIFT_F1 -> { ${1://cuerpo...} }\n\n# K_F2\nsnippet K_F2\n\tK_F2 -> { ${1://cuerpo...} }\n# K_CTRL_F2\nsnippet K_CTRL_F2\n\tK_CTRL_F2 -> { ${1://cuerpo...} }\n# K_ALT_F2\nsnippet K_ALT_F2\n\tK_ALT_F2 -> { ${1://cuerpo...} }\n# K_SHIFT_F2\nsnippet K_SHIFT_F2\n\tK_SHIFT_F2 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_F2\nsnippet K_CTRL_ALT_F2\n\tK_CTRL_ALT_F2 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_F2\nsnippet K_CTRL_SHIFT_F2\n\tK_CTRL_SHIFT_F2 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_F2\nsnippet K_CTRL_ALT_SHIFT_F2\n\tK_CTRL_ALT_SHIFT_F2 -> { ${1://cuerpo...} }\n\n# K_F3\nsnippet K_F3\n\tK_F3 -> { ${1://cuerpo...} }\n# K_CTRL_F3\nsnippet K_CTRL_F3\n\tK_CTRL_F3 -> { ${1://cuerpo...} }\n# K_ALT_F3\nsnippet K_ALT_F3\n\tK_ALT_F3 -> { ${1://cuerpo...} }\n# K_SHIFT_F3\nsnippet K_SHIFT_F3\n\tK_SHIFT_F3 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_F3\nsnippet K_CTRL_ALT_F3\n\tK_CTRL_ALT_F3 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_F3\nsnippet K_CTRL_SHIFT_F3\n\tK_CTRL_SHIFT_F3 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_F3\nsnippet K_CTRL_ALT_SHIFT_F3\n\tK_CTRL_ALT_SHIFT_F3 -> { ${1://cuerpo...} }\n\n# K_A\nsnippet K_A\n\tK_A -> { ${1://cuerpo...} }\n# K_CTRL_A\nsnippet K_CTRL_A\n\tK_CTRL_A -> { ${1://cuerpo...} }\n# K_ALT_A\nsnippet K_ALT_A\n\tK_ALT_A -> { ${1://cuerpo...} }\n# K_SHIFT_A\nsnippet K_SHIFT_A\n\tK_SHIFT_A -> { ${1://cuerpo...} }\n# K_CTRL_ALT_A\nsnippet K_CTRL_ALT_A\n\tK_CTRL_ALT_A -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_A\nsnippet K_CTRL_SHIFT_A\n\tK_CTRL_SHIFT_A -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_A\nsnippet K_CTRL_ALT_SHIFT_A\n\tK_CTRL_ALT_SHIFT_A -> { ${1://cuerpo...} }\n\n# K_F5\nsnippet K_F5\n\tK_F5 -> { ${1://cuerpo...} }\n# K_CTRL_F5\nsnippet K_CTRL_F5\n\tK_CTRL_F5 -> { ${1://cuerpo...} }\n# K_ALT_F5\nsnippet K_ALT_F5\n\tK_ALT_F5 -> { ${1://cuerpo...} }\n# K_SHIFT_F5\nsnippet K_SHIFT_F5\n\tK_SHIFT_F5 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_F5\nsnippet K_CTRL_ALT_F5\n\tK_CTRL_ALT_F5 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_F5\nsnippet K_CTRL_SHIFT_F5\n\tK_CTRL_SHIFT_F5 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_F5\nsnippet K_CTRL_ALT_SHIFT_F5\n\tK_CTRL_ALT_SHIFT_F5 -> { ${1://cuerpo...} }\n\n# K_F6\nsnippet K_F6\n\tK_F6 -> { ${1://cuerpo...} }\n# K_CTRL_F6\nsnippet K_CTRL_F6\n\tK_CTRL_F6 -> { ${1://cuerpo...} }\n# K_ALT_F6\nsnippet K_ALT_F6\n\tK_ALT_F6 -> { ${1://cuerpo...} }\n# K_SHIFT_F6\nsnippet K_SHIFT_F6\n\tK_SHIFT_F6 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_F6\nsnippet K_CTRL_ALT_F6\n\tK_CTRL_ALT_F6 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_F6\nsnippet K_CTRL_SHIFT_F6\n\tK_CTRL_SHIFT_F6 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_F6\nsnippet K_CTRL_ALT_SHIFT_F6\n\tK_CTRL_ALT_SHIFT_F6 -> { ${1://cuerpo...} }\n\n# K_F7\nsnippet K_F7\n\tK_F7 -> { ${1://cuerpo...} }\n# K_CTRL_F7\nsnippet K_CTRL_F7\n\tK_CTRL_F7 -> { ${1://cuerpo...} }\n# K_ALT_F7\nsnippet K_ALT_F7\n\tK_ALT_F7 -> { ${1://cuerpo...} }\n# K_SHIFT_F7\nsnippet K_SHIFT_F7\n\tK_SHIFT_F7 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_F7\nsnippet K_CTRL_ALT_F7\n\tK_CTRL_ALT_F7 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_F7\nsnippet K_CTRL_SHIFT_F7\n\tK_CTRL_SHIFT_F7 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_F7\nsnippet K_CTRL_ALT_SHIFT_F7\n\tK_CTRL_ALT_SHIFT_F7 -> { ${1://cuerpo...} }\n\n# K_F8\nsnippet K_F8\n\tK_F8 -> { ${1://cuerpo...} }\n# K_CTRL_F8\nsnippet K_CTRL_F8\n\tK_CTRL_F8 -> { ${1://cuerpo...} }\n# K_ALT_F8\nsnippet K_ALT_F8\n\tK_ALT_F8 -> { ${1://cuerpo...} }\n# K_SHIFT_F8\nsnippet K_SHIFT_F8\n\tK_SHIFT_F8 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_F8\nsnippet K_CTRL_ALT_F8\n\tK_CTRL_ALT_F8 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_F8\nsnippet K_CTRL_SHIFT_F8\n\tK_CTRL_SHIFT_F8 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_F8\nsnippet K_CTRL_ALT_SHIFT_F8\n\tK_CTRL_ALT_SHIFT_F8 -> { ${1://cuerpo...} }\n\n# K_F9\nsnippet K_F9\n\tK_F9 -> { ${1://cuerpo...} }\n# K_CTRL_F9\nsnippet K_CTRL_F9\n\tK_CTRL_F9 -> { ${1://cuerpo...} }\n# K_ALT_F9\nsnippet K_ALT_F9\n\tK_ALT_F9 -> { ${1://cuerpo...} }\n# K_SHIFT_F9\nsnippet K_SHIFT_F9\n\tK_SHIFT_F9 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_F9\nsnippet K_CTRL_ALT_F9\n\tK_CTRL_ALT_F9 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_F9\nsnippet K_CTRL_SHIFT_F9\n\tK_CTRL_SHIFT_F9 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_F9\nsnippet K_CTRL_ALT_SHIFT_F9\n\tK_CTRL_ALT_SHIFT_F9 -> { ${1://cuerpo...} }\n\n# K_F10\nsnippet K_F10\n\tK_F10 -> { ${1://cuerpo...} }\n# K_CTRL_F10\nsnippet K_CTRL_F10\n\tK_CTRL_F10 -> { ${1://cuerpo...} }\n# K_ALT_F10\nsnippet K_ALT_F10\n\tK_ALT_F10 -> { ${1://cuerpo...} }\n# K_SHIFT_F10\nsnippet K_SHIFT_F10\n\tK_SHIFT_F10 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_F10\nsnippet K_CTRL_ALT_F10\n\tK_CTRL_ALT_F10 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_F10\nsnippet K_CTRL_SHIFT_F10\n\tK_CTRL_SHIFT_F10 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_F10\nsnippet K_CTRL_ALT_SHIFT_F10\n\tK_CTRL_ALT_SHIFT_F10 -> { ${1://cuerpo...} }\n\n# K_F11\nsnippet K_F11\n\tK_F11 -> { ${1://cuerpo...} }\n# K_CTRL_F11\nsnippet K_CTRL_F11\n\tK_CTRL_F11 -> { ${1://cuerpo...} }\n# K_ALT_F11\nsnippet K_ALT_F11\n\tK_ALT_F11 -> { ${1://cuerpo...} }\n# K_SHIFT_F11\nsnippet K_SHIFT_F11\n\tK_SHIFT_F11 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_F11\nsnippet K_CTRL_ALT_F11\n\tK_CTRL_ALT_F11 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_F11\nsnippet K_CTRL_SHIFT_F11\n\tK_CTRL_SHIFT_F11 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_F11\nsnippet K_CTRL_ALT_SHIFT_F11\n\tK_CTRL_ALT_SHIFT_F11 -> { ${1://cuerpo...} }\n\n# K_F12\nsnippet K_F12\n\tK_F12 -> { ${1://cuerpo...} }\n# K_CTRL_F12\nsnippet K_CTRL_F12\n\tK_CTRL_F12 -> { ${1://cuerpo...} }\n# K_ALT_F12\nsnippet K_ALT_F12\n\tK_ALT_F12 -> { ${1://cuerpo...} }\n# K_SHIFT_F12\nsnippet K_SHIFT_F12\n\tK_SHIFT_F12 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_F12\nsnippet K_CTRL_ALT_F12\n\tK_CTRL_ALT_F12 -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_F12\nsnippet K_CTRL_SHIFT_F12\n\tK_CTRL_SHIFT_F12 -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_F12\nsnippet K_CTRL_ALT_SHIFT_F12\n\tK_CTRL_ALT_SHIFT_F12 -> { ${1://cuerpo...} }\n\n# K_RETURN\nsnippet K_RETURN\n\tK_RETURN -> { ${1://cuerpo...} }\n# K_CTRL_RETURN\nsnippet K_CTRL_RETURN\n\tK_CTRL_RETURN -> { ${1://cuerpo...} }\n# K_ALT_RETURN\nsnippet K_ALT_RETURN\n\tK_ALT_RETURN -> { ${1://cuerpo...} }\n# K_SHIFT_RETURN\nsnippet K_SHIFT_RETURN\n\tK_SHIFT_RETURN -> { ${1://cuerpo...} }\n# K_CTRL_ALT_RETURN\nsnippet K_CTRL_ALT_RETURN\n\tK_CTRL_ALT_RETURN -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_RETURN\nsnippet K_CTRL_SHIFT_RETURN\n\tK_CTRL_SHIFT_RETURN -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_RETURN\nsnippet K_CTRL_ALT_SHIFT_RETURN\n\tK_CTRL_ALT_SHIFT_RETURN -> { ${1://cuerpo...} }\n\n# K_SPACE\nsnippet K_SPACE\n\tK_SPACE -> { ${1://cuerpo...} }\n# K_CTRL_SPACE\nsnippet K_CTRL_SPACE\n\tK_CTRL_SPACE -> { ${1://cuerpo...} }\n# K_ALT_SPACE\nsnippet K_ALT_SPACE\n\tK_ALT_SPACE -> { ${1://cuerpo...} }\n# K_SHIFT_SPACE\nsnippet K_SHIFT_SPACE\n\tK_SHIFT_SPACE -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SPACE\nsnippet K_CTRL_ALT_SPACE\n\tK_CTRL_ALT_SPACE -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_SPACE\nsnippet K_CTRL_SHIFT_SPACE\n\tK_CTRL_SHIFT_SPACE -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_SPACE\nsnippet K_CTRL_ALT_SHIFT_SPACE\n\tK_CTRL_ALT_SHIFT_SPACE -> { ${1://cuerpo...} }\n\n# K_ESCAPE\nsnippet K_ESCAPE\n\tK_ESCAPE -> { ${1://cuerpo...} }\n# K_CTRL_ESCAPE\nsnippet K_CTRL_ESCAPE\n\tK_CTRL_ESCAPE -> { ${1://cuerpo...} }\n# K_ALT_ESCAPE\nsnippet K_ALT_ESCAPE\n\tK_ALT_ESCAPE -> { ${1://cuerpo...} }\n# K_SHIFT_ESCAPE\nsnippet K_SHIFT_ESCAPE\n\tK_SHIFT_ESCAPE -> { ${1://cuerpo...} }\n# K_CTRL_ALT_ESCAPE\nsnippet K_CTRL_ALT_ESCAPE\n\tK_CTRL_ALT_ESCAPE -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_ESCAPE\nsnippet K_CTRL_SHIFT_ESCAPE\n\tK_CTRL_SHIFT_ESCAPE -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_ESCAPE\nsnippet K_CTRL_ALT_SHIFT_ESCAPE\n\tK_CTRL_ALT_SHIFT_ESCAPE -> { ${1://cuerpo...} }\n\n# K_BACKSPACE\nsnippet K_BACKSPACE\n\tK_BACKSPACE -> { ${1://cuerpo...} }\n# K_CTRL_BACKSPACE\nsnippet K_CTRL_BACKSPACE\n\tK_CTRL_BACKSPACE -> { ${1://cuerpo...} }\n# K_ALT_BACKSPACE\nsnippet K_ALT_BACKSPACE\n\tK_ALT_BACKSPACE -> { ${1://cuerpo...} }\n# K_SHIFT_BACKSPACE\nsnippet K_SHIFT_BACKSPACE\n\tK_SHIFT_BACKSPACE -> { ${1://cuerpo...} }\n# K_CTRL_ALT_BACKSPACE\nsnippet K_CTRL_ALT_BACKSPACE\n\tK_CTRL_ALT_BACKSPACE -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_BACKSPACE\nsnippet K_CTRL_SHIFT_BACKSPACE\n\tK_CTRL_SHIFT_BACKSPACE -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_BACKSPACE\nsnippet K_CTRL_ALT_SHIFT_BACKSPACE\n\tK_CTRL_ALT_SHIFT_BACKSPACE -> { ${1://cuerpo...} }\n\n# K_TAB\nsnippet K_TAB\n\tK_TAB -> { ${1://cuerpo...} }\n# K_CTRL_TAB\nsnippet K_CTRL_TAB\n\tK_CTRL_TAB -> { ${1://cuerpo...} }\n# K_ALT_TAB\nsnippet K_ALT_TAB\n\tK_ALT_TAB -> { ${1://cuerpo...} }\n# K_SHIFT_TAB\nsnippet K_SHIFT_TAB\n\tK_SHIFT_TAB -> { ${1://cuerpo...} }\n# K_CTRL_ALT_TAB\nsnippet K_CTRL_ALT_TAB\n\tK_CTRL_ALT_TAB -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_TAB\nsnippet K_CTRL_SHIFT_TAB\n\tK_CTRL_SHIFT_TAB -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_TAB\nsnippet K_CTRL_ALT_SHIFT_TAB\n\tK_CTRL_ALT_SHIFT_TAB -> { ${1://cuerpo...} }\n\n# K_UP\nsnippet K_UP\n\tK_UP -> { ${1://cuerpo...} }\n# K_CTRL_UP\nsnippet K_CTRL_UP\n\tK_CTRL_UP -> { ${1://cuerpo...} }\n# K_ALT_UP\nsnippet K_ALT_UP\n\tK_ALT_UP -> { ${1://cuerpo...} }\n# K_SHIFT_UP\nsnippet K_SHIFT_UP\n\tK_SHIFT_UP -> { ${1://cuerpo...} }\n# K_CTRL_ALT_UP\nsnippet K_CTRL_ALT_UP\n\tK_CTRL_ALT_UP -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_UP\nsnippet K_CTRL_SHIFT_UP\n\tK_CTRL_SHIFT_UP -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_UP\nsnippet K_CTRL_ALT_SHIFT_UP\n\tK_CTRL_ALT_SHIFT_UP -> { ${1://cuerpo...} }\n\n# K_DOWN\nsnippet K_DOWN\n\tK_DOWN -> { ${1://cuerpo...} }\n# K_CTRL_DOWN\nsnippet K_CTRL_DOWN\n\tK_CTRL_DOWN -> { ${1://cuerpo...} }\n# K_ALT_DOWN\nsnippet K_ALT_DOWN\n\tK_ALT_DOWN -> { ${1://cuerpo...} }\n# K_SHIFT_DOWN\nsnippet K_SHIFT_DOWN\n\tK_SHIFT_DOWN -> { ${1://cuerpo...} }\n# K_CTRL_ALT_DOWN\nsnippet K_CTRL_ALT_DOWN\n\tK_CTRL_ALT_DOWN -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_DOWN\nsnippet K_CTRL_SHIFT_DOWN\n\tK_CTRL_SHIFT_DOWN -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_DOWN\nsnippet K_CTRL_ALT_SHIFT_DOWN\n\tK_CTRL_ALT_SHIFT_DOWN -> { ${1://cuerpo...} }\n\n# K_LEFT\nsnippet K_LEFT\n\tK_LEFT -> { ${1://cuerpo...} }\n# K_CTRL_LEFT\nsnippet K_CTRL_LEFT\n\tK_CTRL_LEFT -> { ${1://cuerpo...} }\n# K_ALT_LEFT\nsnippet K_ALT_LEFT\n\tK_ALT_LEFT -> { ${1://cuerpo...} }\n# K_SHIFT_LEFT\nsnippet K_SHIFT_LEFT\n\tK_SHIFT_LEFT -> { ${1://cuerpo...} }\n# K_CTRL_ALT_LEFT\nsnippet K_CTRL_ALT_LEFT\n\tK_CTRL_ALT_LEFT -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_LEFT\nsnippet K_CTRL_SHIFT_LEFT\n\tK_CTRL_SHIFT_LEFT -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_LEFT\nsnippet K_CTRL_ALT_SHIFT_LEFT\n\tK_CTRL_ALT_SHIFT_LEFT -> { ${1://cuerpo...} }\n\n# K_RIGHT\nsnippet K_RIGHT\n\tK_RIGHT -> { ${1://cuerpo...} }\n# K_CTRL_RIGHT\nsnippet K_CTRL_RIGHT\n\tK_CTRL_RIGHT -> { ${1://cuerpo...} }\n# K_ALT_RIGHT\nsnippet K_ALT_RIGHT\n\tK_ALT_RIGHT -> { ${1://cuerpo...} }\n# K_SHIFT_RIGHT\nsnippet K_SHIFT_RIGHT\n\tK_SHIFT_RIGHT -> { ${1://cuerpo...} }\n# K_CTRL_ALT_RIGHT\nsnippet K_CTRL_ALT_RIGHT\n\tK_CTRL_ALT_RIGHT -> { ${1://cuerpo...} }\n# K_CTRL_SHIFT_RIGHT\nsnippet K_CTRL_SHIFT_RIGHT\n\tK_CTRL_SHIFT_RIGHT -> { ${1://cuerpo...} }\n# K_CTRL_ALT_SHIFT_RIGHT\nsnippet K_CTRL_ALT_SHIFT_RIGHT\n\tK_CTRL_ALT_SHIFT_RIGHT -> { ${1://cuerpo...} }\n\n# recorrido (simple)\nsnippet recorrido (simple)\n\t${1:// Ir al inicio}\n\twhile (not ${2:// es \u00FAltimo elemento}) {\n\t\t${3:// Procesar el elemento}\n\t\t${4:// Ir al pr\u00F3ximo elemento}\n\t}\n\t${5:// Finalizar}\n\n# recorrido (de acumulaci\u00F3n)\nsnippet recorrido (de acumulaci\u00F3n)\n\t${1:// Ir al inicio}\n\t${2:cantidadVistos} := ${3:// contar elementos en lugar actual}\n\twhile (not ${4:// es \u00FAltimo elemento}) {\n\t\t${4:// Ir al pr\u00F3ximo elemento}\n\t\t${2:cantidadVistos} := ${2:cantidadVistos} + ${3:// contar elementos en lugar actual}\n\t}\n\treturn (${2:cantidadVistos})\n\n# recorrido (de b\u00FAsqueda)\nsnippet recorrido (de b\u00FAsqueda)\n\t${1:// Ir al inicio}\n\twhile (not ${2:// encontr\u00E9 lo que buscaba}) {\n\t\t${3:// Ir al pr\u00F3ximo elemento}\n\t}\n\treturn (${2:// encontr\u00E9 lo que buscaba })\n\n# recorrido (de b\u00FAsqueda con borde)\nsnippet recorrido (de b\u00FAsqueda con borde)\n\t${1:// Ir al inicio}\n\twhile (not ${2:// encontr\u00E9 lo que buscaba} && not ${3:// es \u00FAltimo elemento}) {\n\t\t${4:// Ir al pr\u00F3ximo elemento}\n\t}\n\treturn (${2:// encontr\u00E9 lo que buscaba })\n\n# recorrido (de tipos enumerativos)\nsnippet recorrido (de tipos enumerativos)\n\t${1:elementoActual} := ${2:minElemento()}\n\twhile (${1:elementoActual} /= ${3:maxElemento()}) {\n\t\t${4:// Procesar con elemento actual}\n\t\t${1:elementoActual} := siguiente(${1:elementoActual})\n\t}\n\t${4:// Procesar con elemento actual}\n\n# recorrido (de b\u00FAsqueda sobre lista)\nsnippet recorrido (de b\u00FAsqueda sobre lista)\n\t${1:listaRecorrida} := ${2:lista}\n\twhile (primero(${1:listaRecorrida}) /= ${3://elemento buscado}) {\n\t\t${1:elementoActual} := sinElPrimero(${1:elementoActual})\n\t}\n\treturn (primero(${1:listaRecorrida}))\n\n# recorrido (de b\u00FAsqueda sobre lista con borde)\nsnippet recorrido (de b\u00FAsqueda sobre lista con borde)\n\t${1:listaRecorrida} := ${2:lista}\n\twhile (not esVac\u00EDa(${1:listaRecorrida}) && primero(${1:listaRecorrida}) /= ${3://elemento buscado}) {\n\t\t${1:elementoActual} := sinElPrimero(${1:elementoActual})\n\t}\n\treturn (not esVac\u00EDa(${1:listaRecorrida}))\n\n# docs (procedimiento)\nsnippet docs (procedimiento)\n\t/*\n\t\t@PROP\u00D3SITO: ${1:...}\n\t\t@PRECONDICI\u00D3N: ${2:...}\n\t*/\n\n# docs (procedimiento con par\u00E1metros)\nsnippet docs (procedimiento con par\u00E1metros)\n\t/*\n\t\t@PROP\u00D3SITO: ${1:...}\n\t\t@PRECONDICI\u00D3N: ${2:...}\n\t\t@PAR\u00C1METROS:\n\t\t\t\t* ${3:nombreDelPar\u00E1metro} : ${4:Tipo} - ${5:descripci\u00F3n}\n\t*/\n\n# docs (funci\u00F3n)\nsnippet docs (funci\u00F3n)\n\t/*\n\t\t@PROP\u00D3SITO: ${1:...}\n\t\t@PRECONDICI\u00D3N: ${2:...}\n\t\t@TIPO: ${3:...}\n\t*/\n\n# docs (funci\u00F3n con par\u00E1metros)\nsnippet docs (funci\u00F3n con par\u00E1metros)\n\t/*\n\t\t@PROP\u00D3SITO: ${1:...}\n\t\t@PRECONDICI\u00D3N: ${2:...}\n\t\t@PAR\u00C1METROS:\n\t\t\t\t* ${3:nombreDelPar\u00E1metro} : ${4:Tipo} - ${5:descripci\u00F3n}\n\t\t@TIPO: ${6:...}\n\t*/\n";

});

define("ace/snippets/gobstones",["require","exports","module","ace/snippets/gobstones.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./gobstones.snippets");
exports.scope = "gobstones";

});

define("ace/snippets/graphqlschema.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# Type Snippet\ntrigger type\nsnippet type\n\ttype ${1:type_name} {\n\t\t${2:type_siblings}\n\t}\n\n# Input Snippet\ntrigger input\nsnippet input\n\tinput ${1:input_name} {\n\t\t${2:input_siblings}\n\t}\n\n# Interface Snippet\ntrigger interface\nsnippet interface\n\tinterface ${1:interface_name} {\n\t\t${2:interface_siblings}\n\t}\n\n# Interface Snippet\ntrigger union\nsnippet union\n\tunion ${1:union_name} = ${2:type} | ${3: type}\n\n# Enum Snippet\ntrigger enum\nsnippet enum\n\tenum ${1:enum_name} {\n\t\t${2:enum_siblings}\n\t}\n";

});

define("ace/snippets/graphqlschema",["require","exports","module","ace/snippets/graphqlschema.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./graphqlschema.snippets");
exports.scope = "graphqlschema";

});

define("ace/snippets/haml.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet t\n\t%table\n\t\t%tr\n\t\t\t%th\n\t\t\t\t${1:headers}\n\t\t%tr\n\t\t\t%td\n\t\t\t\t${2:headers}\nsnippet ul\n\t%ul\n\t\t%li\n\t\t\t${1:item}\n\t\t%li\nsnippet =rp\n\t= render :partial => '${1:partial}'\nsnippet =rpl\n\t= render :partial => '${1:partial}', :locals => {}\nsnippet =rpc\n\t= render :partial => '${1:partial}', :collection => @$1\n\n";

});

define("ace/snippets/haml",["require","exports","module","ace/snippets/haml.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./haml.snippets");
exports.scope = "haml";

});

define("ace/snippets/haskell.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet lang\n\t{-# LANGUAGE ${1:OverloadedStrings} #-}\nsnippet info\n\t-- |\n\t-- Module      :  ${1:Module.Namespace}\n\t-- Copyright   :  ${2:Author} ${3:2011-2012}\n\t-- License     :  ${4:BSD3}\n\t--\n\t-- Maintainer  :  ${5:email@something.com}\n\t-- Stability   :  ${6:experimental}\n\t-- Portability :  ${7:unknown}\n\t--\n\t-- ${8:Description}\n\t--\nsnippet import\n\timport           ${1:Data.Text}\nsnippet import2\n\timport           ${1:Data.Text} (${2:head})\nsnippet importq\n\timport qualified ${1:Data.Text} as ${2:T}\nsnippet inst\n\tinstance ${1:Monoid} ${2:Type} where\n\t\t${3}\nsnippet type\n\ttype ${1:Type} = ${2:Type}\nsnippet data\n\tdata ${1:Type} = ${2:$1} ${3:Int}\nsnippet newtype\n\tnewtype ${1:Type} = ${2:$1} ${3:Int}\nsnippet class\n\tclass ${1:Class} a where\n\t\t${2}\nsnippet module\n\tmodule `substitute(substitute(expand('%:r'), '[/\\\\]','.','g'),'^\\%(\\l*\\.\\)\\?','','')` (\n\t)\twhere\n\t`expand('%') =~ 'Main' ? \"\\n\\nmain = do\\n  print \\\"hello world\\\"\" : \"\"`\n\nsnippet const\n\t${1:name} :: ${2:a}\n\t$1 = ${3:undefined}\nsnippet fn\n\t${1:fn} :: ${2:a} -> ${3:a}\n\t$1 ${4} = ${5:undefined}\nsnippet fn2\n\t${1:fn} :: ${2:a} -> ${3:a} -> ${4:a}\n\t$1 ${5} = ${6:undefined}\nsnippet ap\n\t${1:map} ${2:fn} ${3:list}\nsnippet do\n\tdo\n\t\t\nsnippet \u03BB\n\t\\${1:x} -> ${2}\nsnippet \\\n\t\\${1:x} -> ${2}\nsnippet <-\n\t${1:a} <- ${2:m a}\nsnippet \u2190\n\t${1:a} <- ${2:m a}\nsnippet ->\n\t${1:m a} -> ${2:a}\nsnippet \u2192\n\t${1:m a} -> ${2:a}\nsnippet tup\n\t(${1:a}, ${2:b})\nsnippet tup2\n\t(${1:a}, ${2:b}, ${3:c})\nsnippet tup3\n\t(${1:a}, ${2:b}, ${3:c}, ${4:d})\nsnippet rec\n\t${1:Record} { ${2:recFieldA} = ${3:undefined}\n\t\t\t\t, ${4:recFieldB} = ${5:undefined}\n\t\t\t\t}\nsnippet case\n\tcase ${1:something} of\n\t\t${2} -> ${3}\nsnippet let\n\tlet ${1} = ${2}\n\tin ${3}\nsnippet where\n\twhere\n\t\t${1:fn} = ${2:undefined}\n";

});

define("ace/snippets/haskell",["require","exports","module","ace/snippets/haskell.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./haskell.snippets");
exports.scope = "haskell";

});

define("ace/snippets/html.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# Some useful Unicode entities\n# Non-Breaking Space\nsnippet nbs\n\t&nbsp;\n# \u2190\nsnippet left\n\t&#x2190;\n# \u2192\nsnippet right\n\t&#x2192;\n# \u2191\nsnippet up\n\t&#x2191;\n# \u2193\nsnippet down\n\t&#x2193;\n# \u21A9\nsnippet return\n\t&#x21A9;\n# \u21E4\nsnippet backtab\n\t&#x21E4;\n# \u21E5\nsnippet tab\n\t&#x21E5;\n# \u21E7\nsnippet shift\n\t&#x21E7;\n# \u2303\nsnippet ctrl\n\t&#x2303;\n# \u2305\nsnippet enter\n\t&#x2305;\n# \u2318\nsnippet cmd\n\t&#x2318;\n# \u2325\nsnippet option\n\t&#x2325;\n# \u2326\nsnippet delete\n\t&#x2326;\n# \u232B\nsnippet backspace\n\t&#x232B;\n# \u238B\nsnippet esc\n\t&#x238B;\n# Generic Doctype\nsnippet doctype HTML 4.01 Strict\n\t<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\n\t\"http://www.w3.org/TR/html4/strict.dtd\">\nsnippet doctype HTML 4.01 Transitional\n\t<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n\t\"http://www.w3.org/TR/html4/loose.dtd\">\nsnippet doctype HTML 5\n\t<!DOCTYPE HTML>\nsnippet doctype XHTML 1.0 Frameset\n\t<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\nsnippet doctype XHTML 1.0 Strict\n\t<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\nsnippet doctype XHTML 1.0 Transitional\n\t<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\nsnippet doctype XHTML 1.1\n\t<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\n\t\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n# HTML Doctype 4.01 Strict\nsnippet docts\n\t<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\n\t\"http://www.w3.org/TR/html4/strict.dtd\">\n# HTML Doctype 4.01 Transitional\nsnippet doct\n\t<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n\t\"http://www.w3.org/TR/html4/loose.dtd\">\n# HTML Doctype 5\nsnippet doct5\n\t<!DOCTYPE html>\n# XHTML Doctype 1.0 Frameset\nsnippet docxf\n\t<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\"\n\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">\n# XHTML Doctype 1.0 Strict\nsnippet docxs\n\t<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n# XHTML Doctype 1.0 Transitional\nsnippet docxt\n\t<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n# XHTML Doctype 1.1\nsnippet docx\n\t<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\n\t\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n# html5shiv\nsnippet html5shiv\n\t<!--[if lte IE 8]>\n\t\t<script src=\"https://cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.3/html5shiv.min.js\"></script>\n\t<![endif]-->\nsnippet html5printshiv\n\t<!--[if lte IE 8]>\n\t\t<script src=\"https://cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.3/html5shiv-printshiv.min.js\"></script>\n\t<![endif]-->\n# Attributes\nsnippet attr\n\t${1:attribute}=\"${2:property}\"\nsnippet attr+\n\t${1:attribute}=\"${2:property}\" attr+${3}\nsnippet .\n\tclass=\"${1}\"${2}\nsnippet #\n\tid=\"${1}\"${2}\nsnippet alt\n\talt=\"${1}\"${2}\nsnippet charset\n\tcharset=\"${1:utf-8}\"${2}\nsnippet data\n\tdata-${1}=\"${2:$1}\"${3}\nsnippet for\n\tfor=\"${1}\"${2}\nsnippet height\n\theight=\"${1}\"${2}\nsnippet href\n\thref=\"${1:#}\"${2}\nsnippet lang\n\tlang=\"${1:en}\"${2}\nsnippet media\n\tmedia=\"${1}\"${2}\nsnippet name\n\tname=\"${1}\"${2}\nsnippet rel\n\trel=\"${1}\"${2}\nsnippet scope\n\tscope=\"${1:row}\"${2}\nsnippet src\n\tsrc=\"${1}\"${2}\nsnippet title=\n\ttitle=\"${1}\"${2}\nsnippet type\n\ttype=\"${1}\"${2}\nsnippet value\n\tvalue=\"${1}\"${2}\nsnippet width\n\twidth=\"${1}\"${2}\n# Elements\nsnippet a\n\t<a href=\"${1:#}\">${2:$1}</a>\nsnippet a.\n\t<a class=\"${1}\" href=\"${2:#}\">${3:$1}</a>\nsnippet a#\n\t<a id=\"${1}\" href=\"${2:#}\">${3:$1}</a>\nsnippet a:ext\n\t<a href=\"http://${1:example.com}\">${2:$1}</a>\nsnippet a:mail\n\t<a href=\"mailto:${1:joe@example.com}?subject=${2:feedback}\">${3:email me}</a>\nsnippet abbr\n\t<abbr title=\"${1}\">${2}</abbr>\nsnippet address\n\t<address>\n\t\t${1}\n\t</address>\nsnippet area\n\t<area shape=\"${1:rect}\" coords=\"${2}\" href=\"${3}\" alt=\"${4}\" />\nsnippet area+\n\t<area shape=\"${1:rect}\" coords=\"${2}\" href=\"${3}\" alt=\"${4}\" />\n\tarea+${5}\nsnippet area:c\n\t<area shape=\"circle\" coords=\"${1}\" href=\"${2}\" alt=\"${3}\" />\nsnippet area:d\n\t<area shape=\"default\" coords=\"${1}\" href=\"${2}\" alt=\"${3}\" />\nsnippet area:p\n\t<area shape=\"poly\" coords=\"${1}\" href=\"${2}\" alt=\"${3}\" />\nsnippet area:r\n\t<area shape=\"rect\" coords=\"${1}\" href=\"${2}\" alt=\"${3}\" />\nsnippet article\n\t<article>\n\t\t${1}\n\t</article>\nsnippet article.\n\t<article class=\"${1}\">\n\t\t${2}\n\t</article>\nsnippet article#\n\t<article id=\"${1}\">\n\t\t${2}\n\t</article>\nsnippet aside\n\t<aside>\n\t\t${1}\n\t</aside>\nsnippet aside.\n\t<aside class=\"${1}\">\n\t\t${2}\n\t</aside>\nsnippet aside#\n\t<aside id=\"${1}\">\n\t\t${2}\n\t</aside>\nsnippet audio\n\t<audio src=\"${1}>${2}</audio>\nsnippet b\n\t<b>${1}</b>\nsnippet base\n\t<base href=\"${1}\" target=\"${2}\" />\nsnippet bdi\n\t<bdi>${1}</bdo>\nsnippet bdo\n\t<bdo dir=\"${1}\">${2}</bdo>\nsnippet bdo:l\n\t<bdo dir=\"ltr\">${1}</bdo>\nsnippet bdo:r\n\t<bdo dir=\"rtl\">${1}</bdo>\nsnippet blockquote\n\t<blockquote>\n\t\t${1}\n\t</blockquote>\nsnippet body\n\t<body>\n\t\t${1}\n\t</body>\nsnippet br\n\t<br />${1}\nsnippet button\n\t<button type=\"${1:submit}\">${2}</button>\nsnippet button.\n\t<button class=\"${1:button}\" type=\"${2:submit}\">${3}</button>\nsnippet button#\n\t<button id=\"${1}\" type=\"${2:submit}\">${3}</button>\nsnippet button:s\n\t<button type=\"submit\">${1}</button>\nsnippet button:r\n\t<button type=\"reset\">${1}</button>\nsnippet canvas\n\t<canvas id=\"${1:canvas}\"></canvas>\nsnippet caption\n\t<caption>${1}</caption>\nsnippet cite\n\t<cite>${1}</cite>\nsnippet code\n\t<code>${1}</code>\nsnippet col\n\t<col />${1}\nsnippet col+\n\t<col />\n\tcol+${1}\nsnippet colgroup\n\t<colgroup>\n\t\t${1}\n\t</colgroup>\nsnippet colgroup+\n\t<colgroup>\n\t\t<col />\n\t\tcol+${1}\n\t</colgroup>\nsnippet command\n\t<command type=\"command\" label=\"${1}\" icon=\"${2}\" />\nsnippet command:c\n\t<command type=\"checkbox\" label=\"${1}\" icon=\"${2}\" />\nsnippet command:r\n\t<command type=\"radio\" radiogroup=\"${1}\" label=\"${2}\" icon=\"${3}\" />\nsnippet datagrid\n\t<datagrid>\n\t\t${1}\n\t</datagrid>\nsnippet datalist\n\t<datalist>\n\t\t${1}\n\t</datalist>\nsnippet datatemplate\n\t<datatemplate>\n\t\t${1}\n\t</datatemplate>\nsnippet dd\n\t<dd>${1}</dd>\nsnippet dd.\n\t<dd class=\"${1}\">${2}</dd>\nsnippet dd#\n\t<dd id=\"${1}\">${2}</dd>\nsnippet del\n\t<del>${1}</del>\nsnippet details\n\t<details>${1}</details>\nsnippet dfn\n\t<dfn>${1}</dfn>\nsnippet dialog\n\t<dialog>\n\t\t${1}\n\t</dialog>\nsnippet div\n\t<div>\n\t\t${1}\n\t</div>\nsnippet div.\n\t<div class=\"${1}\">\n\t\t${2}\n\t</div>\nsnippet div#\n\t<div id=\"${1}\">\n\t\t${2}\n\t</div>\nsnippet dl\n\t<dl>\n\t\t${1}\n\t</dl>\nsnippet dl.\n\t<dl class=\"${1}\">\n\t\t${2}\n\t</dl>\nsnippet dl#\n\t<dl id=\"${1}\">\n\t\t${2}\n\t</dl>\nsnippet dl+\n\t<dl>\n\t\t<dt>${1}</dt>\n\t\t<dd>${2}</dd>\n\t\tdt+${3}\n\t</dl>\nsnippet dt\n\t<dt>${1}</dt>\nsnippet dt.\n\t<dt class=\"${1}\">${2}</dt>\nsnippet dt#\n\t<dt id=\"${1}\">${2}</dt>\nsnippet dt+\n\t<dt>${1}</dt>\n\t<dd>${2}</dd>\n\tdt+${3}\nsnippet em\n\t<em>${1}</em>\nsnippet embed\n\t<embed src=${1} type=\"${2} />\nsnippet fieldset\n\t<fieldset>\n\t\t${1}\n\t</fieldset>\nsnippet fieldset.\n\t<fieldset class=\"${1}\">\n\t\t${2}\n\t</fieldset>\nsnippet fieldset#\n\t<fieldset id=\"${1}\">\n\t\t${2}\n\t</fieldset>\nsnippet fieldset+\n\t<fieldset>\n\t\t<legend><span>${1}</span></legend>\n\t\t${2}\n\t</fieldset>\n\tfieldset+${3}\nsnippet figcaption\n\t<figcaption>${1}</figcaption>\nsnippet figure\n\t<figure>${1}</figure>\nsnippet footer\n\t<footer>\n\t\t${1}\n\t</footer>\nsnippet footer.\n\t<footer class=\"${1}\">\n\t\t${2}\n\t</footer>\nsnippet footer#\n\t<footer id=\"${1}\">\n\t\t${2}\n\t</footer>\nsnippet form\n\t<form action=\"${1}\" method=\"${2:get}\" accept-charset=\"utf-8\">\n\t\t${3}\n\t</form>\nsnippet form.\n\t<form class=\"${1}\" action=\"${2}\" method=\"${3:get}\" accept-charset=\"utf-8\">\n\t\t${4}\n\t</form>\nsnippet form#\n\t<form id=\"${1}\" action=\"${2}\" method=\"${3:get}\" accept-charset=\"utf-8\">\n\t\t${4}\n\t</form>\nsnippet h1\n\t<h1>${1}</h1>\nsnippet h1.\n\t<h1 class=\"${1}\">${2}</h1>\nsnippet h1#\n\t<h1 id=\"${1}\">${2}</h1>\nsnippet h2\n\t<h2>${1}</h2>\nsnippet h2.\n\t<h2 class=\"${1}\">${2}</h2>\nsnippet h2#\n\t<h2 id=\"${1}\">${2}</h2>\nsnippet h3\n\t<h3>${1}</h3>\nsnippet h3.\n\t<h3 class=\"${1}\">${2}</h3>\nsnippet h3#\n\t<h3 id=\"${1}\">${2}</h3>\nsnippet h4\n\t<h4>${1}</h4>\nsnippet h4.\n\t<h4 class=\"${1}\">${2}</h4>\nsnippet h4#\n\t<h4 id=\"${1}\">${2}</h4>\nsnippet h5\n\t<h5>${1}</h5>\nsnippet h5.\n\t<h5 class=\"${1}\">${2}</h5>\nsnippet h5#\n\t<h5 id=\"${1}\">${2}</h5>\nsnippet h6\n\t<h6>${1}</h6>\nsnippet h6.\n\t<h6 class=\"${1}\">${2}</h6>\nsnippet h6#\n\t<h6 id=\"${1}\">${2}</h6>\nsnippet head\n\t<head>\n\t\t<meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />\n\n\t\t<title>${1:`substitute(Filename('', 'Page Title'), '^.', '\\u&', '')`}</title>\n\t\t${2}\n\t</head>\nsnippet header\n\t<header>\n\t\t${1}\n\t</header>\nsnippet header.\n\t<header class=\"${1}\">\n\t\t${2}\n\t</header>\nsnippet header#\n\t<header id=\"${1}\">\n\t\t${2}\n\t</header>\nsnippet hgroup\n\t<hgroup>\n\t\t${1}\n\t</hgroup>\nsnippet hgroup.\n\t<hgroup class=\"${1}>\n\t\t${2}\n\t</hgroup>\nsnippet hr\n\t<hr />${1}\nsnippet html\n\t<html>\n\t${1}\n\t</html>\nsnippet xhtml\n\t<html xmlns=\"http://www.w3.org/1999/xhtml\">\n\t${1}\n\t</html>\nsnippet html5\n\t<!DOCTYPE html>\n\t<html>\n\t\t<head>\n\t\t\t<meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />\n\t\t\t<title>${1:`substitute(Filename('', 'Page Title'), '^.', '\\u&', '')`}</title>\n\t\t\t${2:meta}\n\t\t</head>\n\t\t<body>\n\t\t\t${3:body}\n\t\t</body>\n\t</html>\nsnippet xhtml5\n\t<!DOCTYPE html>\n\t<html xmlns=\"http://www.w3.org/1999/xhtml\">\n\t\t<head>\n\t\t\t<meta http-equiv=\"content-type\" content=\"application/xhtml+xml; charset=utf-8\" />\n\t\t\t<title>${1:`substitute(Filename('', 'Page Title'), '^.', '\\u&', '')`}</title>\n\t\t\t${2:meta}\n\t\t</head>\n\t\t<body>\n\t\t\t${3:body}\n\t\t</body>\n\t</html>\nsnippet i\n\t<i>${1}</i>\nsnippet iframe\n\t<iframe src=\"${1}\" frameborder=\"0\"></iframe>${2}\nsnippet iframe.\n\t<iframe class=\"${1}\" src=\"${2}\" frameborder=\"0\"></iframe>${3}\nsnippet iframe#\n\t<iframe id=\"${1}\" src=\"${2}\" frameborder=\"0\"></iframe>${3}\nsnippet img\n\t<img src=\"${1}\" alt=\"${2}\" />${3}\nsnippet img.\n\t<img class=\"${1}\" src=\"${2}\" alt=\"${3}\" />${4}\nsnippet img#\n\t<img id=\"${1}\" src=\"${2}\" alt=\"${3}\" />${4}\nsnippet input\n\t<input type=\"${1:text/submit/hidden/button/image}\" name=\"${2}\" id=\"${3:$2}\" value=\"${4}\" />${5}\nsnippet input.\n\t<input class=\"${1}\" type=\"${2:text/submit/hidden/button/image}\" name=\"${3}\" id=\"${4:$3}\" value=\"${5}\" />${6}\nsnippet input:text\n\t<input type=\"text\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:submit\n\t<input type=\"submit\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:hidden\n\t<input type=\"hidden\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:button\n\t<input type=\"button\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:image\n\t<input type=\"image\" name=\"${1}\" id=\"${2:$1}\" src=\"${3}\" alt=\"${4}\" />${5}\nsnippet input:checkbox\n\t<input type=\"checkbox\" name=\"${1}\" id=\"${2:$1}\" />${3}\nsnippet input:radio\n\t<input type=\"radio\" name=\"${1}\" id=\"${2:$1}\" />${3}\nsnippet input:color\n\t<input type=\"color\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:date\n\t<input type=\"date\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:datetime\n\t<input type=\"datetime\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:datetime-local\n\t<input type=\"datetime-local\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:email\n\t<input type=\"email\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:file\n\t<input type=\"file\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:month\n\t<input type=\"month\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:number\n\t<input type=\"number\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:password\n\t<input type=\"password\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:range\n\t<input type=\"range\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:reset\n\t<input type=\"reset\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:search\n\t<input type=\"search\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:time\n\t<input type=\"time\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:url\n\t<input type=\"url\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:week\n\t<input type=\"week\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet ins\n\t<ins>${1}</ins>\nsnippet kbd\n\t<kbd>${1}</kbd>\nsnippet keygen\n\t<keygen>${1}</keygen>\nsnippet label\n\t<label for=\"${2:$1}\">${1}</label>\nsnippet label:i\n\t<label for=\"${2:$1}\">${1}</label>\n\t<input type=\"${3:text/submit/hidden/button}\" name=\"${4:$2}\" id=\"${5:$2}\" value=\"${6}\" />${7}\nsnippet label:s\n\t<label for=\"${2:$1}\">${1}</label>\n\t<select name=\"${3:$2}\" id=\"${4:$2}\">\n\t\t<option value=\"${5}\">${6:$5}</option>\n\t</select>\nsnippet legend\n\t<legend>${1}</legend>\nsnippet legend+\n\t<legend><span>${1}</span></legend>\nsnippet li\n\t<li>${1}</li>\nsnippet li.\n\t<li class=\"${1}\">${2}</li>\nsnippet li+\n\t<li>${1}</li>\n\tli+${2}\nsnippet lia\n\t<li><a href=\"${2:#}\">${1}</a></li>\nsnippet lia+\n\t<li><a href=\"${2:#}\">${1}</a></li>\n\tlia+${3}\nsnippet link\n\t<link rel=\"${1}\" href=\"${2}\" title=\"${3}\" type=\"${4}\" />${5}\nsnippet link:atom\n\t<link rel=\"alternate\" href=\"${1:atom.xml}\" title=\"Atom\" type=\"application/atom+xml\" />${2}\nsnippet link:css\n\t<link rel=\"stylesheet\" href=\"${2:style.css}\" type=\"text/css\" media=\"${3:all}\" />${4}\nsnippet link:favicon\n\t<link rel=\"shortcut icon\" href=\"${1:favicon.ico}\" type=\"image/x-icon\" />${2}\nsnippet link:rss\n\t<link rel=\"alternate\" href=\"${1:rss.xml}\" title=\"RSS\" type=\"application/atom+xml\" />${2}\nsnippet link:touch\n\t<link rel=\"apple-touch-icon\" href=\"${1:favicon.png}\" />${2}\nsnippet map\n\t<map name=\"${1}\">\n\t\t${2}\n\t</map>\nsnippet map.\n\t<map class=\"${1}\" name=\"${2}\">\n\t\t${3}\n\t</map>\nsnippet map#\n\t<map name=\"${1}\" id=\"${2:$1}>\n\t\t${3}\n\t</map>\nsnippet map+\n\t<map name=\"${1}\">\n\t\t<area shape=\"${2}\" coords=\"${3}\" href=\"${4}\" alt=\"${5}\" />${6}\n\t</map>${7}\nsnippet mark\n\t<mark>${1}</mark>\nsnippet menu\n\t<menu>\n\t\t${1}\n\t</menu>\nsnippet menu:c\n\t<menu type=\"context\">\n\t\t${1}\n\t</menu>\nsnippet menu:t\n\t<menu type=\"toolbar\">\n\t\t${1}\n\t</menu>\nsnippet meta\n\t<meta http-equiv=\"${1}\" content=\"${2}\" />${3}\nsnippet meta:compat\n\t<meta http-equiv=\"X-UA-Compatible\" content=\"IE=${1:7,8,edge}\" />${3}\nsnippet meta:refresh\n\t<meta http-equiv=\"refresh\" content=\"text/html;charset=UTF-8\" />${3}\nsnippet meta:utf\n\t<meta http-equiv=\"content-type\" content=\"text/html;charset=UTF-8\" />${3}\nsnippet meter\n\t<meter>${1}</meter>\nsnippet nav\n\t<nav>\n\t\t${1}\n\t</nav>\nsnippet nav.\n\t<nav class=\"${1}\">\n\t\t${2}\n\t</nav>\nsnippet nav#\n\t<nav id=\"${1}\">\n\t\t${2}\n\t</nav>\nsnippet noscript\n\t<noscript>\n\t\t${1}\n\t</noscript>\nsnippet object\n\t<object data=\"${1}\" type=\"${2}\">\n\t\t${3}\n\t</object>${4}\n# Embed QT Movie\nsnippet movie\n\t<object width=\"$2\" height=\"$3\" classid=\"clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B\"\n\t codebase=\"http://www.apple.com/qtactivex/qtplugin.cab\">\n\t\t<param name=\"src\" value=\"$1\" />\n\t\t<param name=\"controller\" value=\"$4\" />\n\t\t<param name=\"autoplay\" value=\"$5\" />\n\t\t<embed src=\"${1:movie.mov}\"\n\t\t\twidth=\"${2:320}\" height=\"${3:240}\"\n\t\t\tcontroller=\"${4:true}\" autoplay=\"${5:true}\"\n\t\t\tscale=\"tofit\" cache=\"true\"\n\t\t\tpluginspage=\"http://www.apple.com/quicktime/download/\" />\n\t</object>${6}\nsnippet ol\n\t<ol>\n\t\t${1}\n\t</ol>\nsnippet ol.\n\t<ol class=\"${1}>\n\t\t${2}\n\t</ol>\nsnippet ol#\n\t<ol id=\"${1}>\n\t\t${2}\n\t</ol>\nsnippet ol+\n\t<ol>\n\t\t<li>${1}</li>\n\t\tli+${2}\n\t</ol>\nsnippet opt\n\t<option value=\"${1}\">${2:$1}</option>\nsnippet opt+\n\t<option value=\"${1}\">${2:$1}</option>\n\topt+${3}\nsnippet optt\n\t<option>${1}</option>\nsnippet optgroup\n\t<optgroup>\n\t\t<option value=\"${1}\">${2:$1}</option>\n\t\topt+${3}\n\t</optgroup>\nsnippet output\n\t<output>${1}</output>\nsnippet p\n\t<p>${1}</p>\nsnippet param\n\t<param name=\"${1}\" value=\"${2}\" />${3}\nsnippet pre\n\t<pre>\n\t\t${1}\n\t</pre>\nsnippet progress\n\t<progress>${1}</progress>\nsnippet q\n\t<q>${1}</q>\nsnippet rp\n\t<rp>${1}</rp>\nsnippet rt\n\t<rt>${1}</rt>\nsnippet ruby\n\t<ruby>\n\t\t<rp><rt>${1}</rt></rp>\n\t</ruby>\nsnippet s\n\t<s>${1}</s>\nsnippet samp\n\t<samp>\n\t\t${1}\n\t</samp>\nsnippet script\n\t<script type=\"text/javascript\" charset=\"utf-8\">\n\t\t${1}\n\t</script>\nsnippet scriptsrc\n\t<script src=\"${1}.js\" type=\"text/javascript\" charset=\"utf-8\"></script>\nsnippet newscript\n\t<script type=\"application/javascript\" charset=\"utf-8\">\n\t\t${1}\n\t</script>\nsnippet newscriptsrc\n\t<script src=\"${1}.js\" type=\"application/javascript\" charset=\"utf-8\"></script>\nsnippet section\n\t<section>\n\t\t${1}\n\t</section>\nsnippet section.\n\t<section class=\"${1}\">\n\t\t${2}\n\t</section>\nsnippet section#\n\t<section id=\"${1}\">\n\t\t${2}\n\t</section>\nsnippet select\n\t<select name=\"${1}\" id=\"${2:$1}\">\n\t\t${3}\n\t</select>\nsnippet select.\n\t<select name=\"${1}\" id=\"${2:$1}\" class=\"${3}>\n\t\t${4}\n\t</select>\nsnippet select+\n\t<select name=\"${1}\" id=\"${2:$1}\">\n\t\t<option value=\"${3}\">${4:$3}</option>\n\t\topt+${5}\n\t</select>\nsnippet small\n\t<small>${1}</small>\nsnippet source\n\t<source src=\"${1}\" type=\"${2}\" media=\"${3}\" />\nsnippet span\n\t<span>${1}</span>\nsnippet strong\n\t<strong>${1}</strong>\nsnippet style\n\t<style type=\"text/css\" media=\"${1:all}\">\n\t\t${2}\n\t</style>\nsnippet sub\n\t<sub>${1}</sub>\nsnippet summary\n\t<summary>\n\t\t${1}\n\t</summary>\nsnippet sup\n\t<sup>${1}</sup>\nsnippet table\n\t<table border=\"${1:0}\">\n\t\t${2}\n\t</table>\nsnippet table.\n\t<table class=\"${1}\" border=\"${2:0}\">\n\t\t${3}\n\t</table>\nsnippet table#\n\t<table id=\"${1}\" border=\"${2:0}\">\n\t\t${3}\n\t</table>\nsnippet tbody\n\t<tbody>\n\t\t${1}\n\t</tbody>\nsnippet td\n\t<td>${1}</td>\nsnippet td.\n\t<td class=\"${1}\">${2}</td>\nsnippet td#\n\t<td id=\"${1}\">${2}</td>\nsnippet td+\n\t<td>${1}</td>\n\ttd+${2}\nsnippet textarea\n\t<textarea name=\"${1}\" id=${2:$1} rows=\"${3:8}\" cols=\"${4:40}\">${5}</textarea>${6}\nsnippet tfoot\n\t<tfoot>\n\t\t${1}\n\t</tfoot>\nsnippet th\n\t<th>${1}</th>\nsnippet th.\n\t<th class=\"${1}\">${2}</th>\nsnippet th#\n\t<th id=\"${1}\">${2}</th>\nsnippet th+\n\t<th>${1}</th>\n\tth+${2}\nsnippet thead\n\t<thead>\n\t\t${1}\n\t</thead>\nsnippet time\n\t<time datetime=\"${1}\" pubdate=\"${2:$1}>${3:$1}</time>\nsnippet title\n\t<title>${1:`substitute(Filename('', 'Page Title'), '^.', '\\u&', '')`}</title>\nsnippet tr\n\t<tr>\n\t\t${1}\n\t</tr>\nsnippet tr+\n\t<tr>\n\t\t<td>${1}</td>\n\t\ttd+${2}\n\t</tr>\nsnippet track\n\t<track src=\"${1}\" srclang=\"${2}\" label=\"${3}\" default=\"${4:default}>${5}</track>${6}\nsnippet ul\n\t<ul>\n\t\t${1}\n\t</ul>\nsnippet ul.\n\t<ul class=\"${1}\">\n\t\t${2}\n\t</ul>\nsnippet ul#\n\t<ul id=\"${1}\">\n\t\t${2}\n\t</ul>\nsnippet ul+\n\t<ul>\n\t\t<li>${1}</li>\n\t\tli+${2}\n\t</ul>\nsnippet var\n\t<var>${1}</var>\nsnippet video\n\t<video src=\"${1}\" height=\"${2}\" width=\"${3}\" preload=\"${5:none}\" autoplay=\"${6:autoplay}\">${7}</video>${8}\nsnippet wbr\n\t<wbr />${1}\n";

});

define("ace/snippets/html",["require","exports","module","ace/snippets/html.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./html.snippets");
exports.scope = "html";

});

define("ace/snippets/java.snippets",["require","exports","module"], function(require, exports, module){module.exports = "## Access Modifiers\nsnippet po\n\tprotected\nsnippet pu\n\tpublic\nsnippet pr\n\tprivate\n##\n## Annotations\nsnippet before\n\t@Before\n\tstatic void ${1:intercept}(${2:args}) { ${3} }\nsnippet mm\n\t@ManyToMany\n\t${1}\nsnippet mo\n\t@ManyToOne\n\t${1}\nsnippet om\n\t@OneToMany${1:(cascade=CascadeType.ALL)}\n\t${2}\nsnippet oo\n\t@OneToOne\n\t${1}\n##\n## Basic Java packages and import\nsnippet im\n\timport\nsnippet j.b\n\tjava.beans.\nsnippet j.i\n\tjava.io.\nsnippet j.m\n\tjava.math.\nsnippet j.n\n\tjava.net.\nsnippet j.u\n\tjava.util.\n##\n## Class\nsnippet cl\n\tclass ${1:`Filename(\"\", \"untitled\")`} ${2}\nsnippet in\n\tinterface ${1:`Filename(\"\", \"untitled\")`} ${2:extends Parent}${3}\nsnippet tc\n\tpublic class ${1:`Filename()`} extends ${2:TestCase}\n##\n## Class Enhancements\nsnippet ext\n\textends \nsnippet imp\n\timplements\n##\n## Comments\nsnippet /*\n\t/*\n\t * ${1}\n\t */\n##\n## Constants\nsnippet co\n\tstatic public final ${1:String} ${2:var} = ${3};${4}\nsnippet cos\n\tstatic public final String ${1:var} = \"${2}\";${3}\n##\n## Control Statements\nsnippet case\n\tcase ${1}:\n\t\t${2}\nsnippet def\n\tdefault:\n\t\t${2}\nsnippet el\n\telse\nsnippet elif\n\telse if (${1}) ${2}\nsnippet if\n\tif (${1}) ${2}\nsnippet sw\n\tswitch (${1}) {\n\t\t${2}\n\t}\n##\n## Create a Method\nsnippet m\n\t${1:void} ${2:method}(${3}) ${4:throws }${5}\n##\n## Create a Variable\nsnippet v\n\t${1:String} ${2:var}${3: = null}${4};${5}\n##\n## Enhancements to Methods, variables, classes, etc.\nsnippet ab\n\tabstract\nsnippet fi\n\tfinal\nsnippet st\n\tstatic\nsnippet sy\n\tsynchronized\n##\n## Error Methods\nsnippet err\n\tSystem.err.print(\"${1:Message}\");\nsnippet errf\n\tSystem.err.printf(\"${1:Message}\", ${2:exception});\nsnippet errln\n\tSystem.err.println(\"${1:Message}\");\n##\n## Exception Handling\nsnippet as\n\tassert ${1:test} : \"${2:Failure message}\";${3}\nsnippet ca\n\tcatch(${1:Exception} ${2:e}) ${3}\nsnippet thr\n\tthrow\nsnippet ths\n\tthrows\nsnippet try\n\ttry {\n\t\t${3}\n\t} catch(${1:Exception} ${2:e}) {\n\t}\nsnippet tryf\n\ttry {\n\t\t${3}\n\t} catch(${1:Exception} ${2:e}) {\n\t} finally {\n\t}\n##\n## Find Methods\nsnippet findall\n\tList<${1:listName}> ${2:items} = ${1}.findAll();${3}\nsnippet findbyid\n\t${1:var} ${2:item} = ${1}.findById(${3});${4}\n##\n## Javadocs\nsnippet /**\n\t/**\n\t * ${1}\n\t */\nsnippet @au\n\t@author `system(\"grep \\`id -un\\` /etc/passwd | cut -d \\\":\\\" -f5 | cut -d \\\",\\\" -f1\")`\nsnippet @br\n\t@brief ${1:Description}\nsnippet @fi\n\t@file ${1:`Filename()`}.java\nsnippet @pa\n\t@param ${1:param}\nsnippet @re\n\t@return ${1:param}\n##\n## Logger Methods\nsnippet debug\n\tLogger.debug(${1:param});${2}\nsnippet error\n\tLogger.error(${1:param});${2}\nsnippet info\n\tLogger.info(${1:param});${2}\nsnippet warn\n\tLogger.warn(${1:param});${2}\n##\n## Loops\nsnippet enfor\n\tfor (${1} : ${2}) ${3}\nsnippet for\n\tfor (${1}; ${2}; ${3}) ${4}\nsnippet wh\n\twhile (${1}) ${2}\n##\n## Main method\nsnippet main\n\tpublic static void main (String[] args) {\n\t\t${1:/* code */}\n\t}\n##\n## Print Methods\nsnippet print\n\tSystem.out.print(\"${1:Message}\");\nsnippet printf\n\tSystem.out.printf(\"${1:Message}\", ${2:args});\nsnippet println\n\tSystem.out.println(${1});\n##\n## Render Methods\nsnippet ren\n\trender(${1:param});${2}\nsnippet rena\n\trenderArgs.put(\"${1}\", ${2});${3}\nsnippet renb\n\trenderBinary(${1:param});${2}\nsnippet renj\n\trenderJSON(${1:param});${2}\nsnippet renx\n\trenderXml(${1:param});${2}\n##\n## Setter and Getter Methods\nsnippet set\n\t${1:public} void set${3:}(${2:String} ${4:}){\n\t\tthis.$4 = $4;\n\t}\nsnippet get\n\t${1:public} ${2:String} get${3:}(){\n\t\treturn this.${4:};\n\t}\n##\n## Terminate Methods or Loops\nsnippet re\n\treturn\nsnippet br\n\tbreak;\n##\n## Test Methods\nsnippet t\n\tpublic void test${1:Name}() throws Exception {\n\t\t${2}\n\t}\nsnippet test\n\t@Test\n\tpublic void test${1:Name}() throws Exception {\n\t\t${2}\n\t}\n##\n## Utils\nsnippet Sc\n\tScanner\n##\n## Miscellaneous\nsnippet action\n\tpublic static void ${1:index}(${2:args}) { ${3} }\nsnippet rnf\n\tnotFound(${1:param});${2}\nsnippet rnfin\n\tnotFoundIfNull(${1:param});${2}\nsnippet rr\n\tredirect(${1:param});${2}\nsnippet ru\n\tunauthorized(${1:param});${2}\nsnippet unless\n\t(unless=${1:param});${2}\n";

});

define("ace/snippets/java",["require","exports","module","ace/snippets/java.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./java.snippets");
exports.scope = "java";

});

define("ace/snippets/javascript.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# Prototype\nsnippet proto\n\t${1:class_name}.prototype.${2:method_name} = function(${3:first_argument}) {\n\t\t${4:// body...}\n\t};\n# Function\nsnippet fun\n\tfunction ${1?:function_name}(${2:argument}) {\n\t\t${3:// body...}\n\t}\n# Anonymous Function\nregex /((=)\\s*|(:)\\s*|(\\()|\\b)/f/(\\))?/\nsnippet f\n\tfunction${M1?: ${1:functionName}}($2) {\n\t\t${0:$TM_SELECTED_TEXT}\n\t}${M2?;}${M3?,}${M4?)}\n# Immediate function\ntrigger \\(?f\\(\nendTrigger \\)?\nsnippet f(\n\t(function(${1}) {\n\t\t${0:${TM_SELECTED_TEXT:/* code */}}\n\t}(${1}));\n# if\nsnippet if\n\tif (${1:true}) {\n\t\t${0}\n\t}\n# if ... else\nsnippet ife\n\tif (${1:true}) {\n\t\t${2}\n\t} else {\n\t\t${0}\n\t}\n# tertiary conditional\nsnippet ter\n\t${1:/* condition */} ? ${2:a} : ${3:b}\n# switch\nsnippet switch\n\tswitch (${1:expression}) {\n\t\tcase '${3:case}':\n\t\t\t${4:// code}\n\t\t\tbreak;\n\t\t${5}\n\t\tdefault:\n\t\t\t${2:// code}\n\t}\n# case\nsnippet case\n\tcase '${1:case}':\n\t\t${2:// code}\n\t\tbreak;\n\t${3}\n\n# while (...) {...}\nsnippet wh\n\twhile (${1:/* condition */}) {\n\t\t${0:/* code */}\n\t}\n# try\nsnippet try\n\ttry {\n\t\t${0:/* code */}\n\t} catch (e) {}\n# do...while\nsnippet do\n\tdo {\n\t\t${2:/* code */}\n\t} while (${1:/* condition */});\n# Object Method\nsnippet :f\nregex /([,{[])|^\\s*/:f/\n\t${1:method_name}: function(${2:attribute}) {\n\t\t${0}\n\t}${3:,}\n# setTimeout function\nsnippet setTimeout\nregex /\\b/st|timeout|setTimeo?u?t?/\n\tsetTimeout(function() {${3:$TM_SELECTED_TEXT}}, ${1:10});\n# Get Elements\nsnippet gett\n\tgetElementsBy${1:TagName}('${2}')${3}\n# Get Element\nsnippet get\n\tgetElementBy${1:Id}('${2}')${3}\n# console.log (Firebug)\nsnippet cl\n\tconsole.log(${1});\n# return\nsnippet ret\n\treturn ${1:result}\n# for (property in object ) { ... }\nsnippet fori\n\tfor (var ${1:prop} in ${2:Things}) {\n\t\t${0:$2[$1]}\n\t}\n# hasOwnProperty\nsnippet has\n\thasOwnProperty(${1})\n# docstring\nsnippet /**\n\t/**\n\t * ${1:description}\n\t *\n\t */\nsnippet @par\nregex /^\\s*\\*\\s*/@(para?m?)?/\n\t@param {${1:type}} ${2:name} ${3:description}\nsnippet @ret\n\t@return {${1:type}} ${2:description}\n# JSON.parse\nsnippet jsonp\n\tJSON.parse(${1:jstr});\n# JSON.stringify\nsnippet jsons\n\tJSON.stringify(${1:object});\n# self-defining function\nsnippet sdf\n\tvar ${1:function_name} = function(${2:argument}) {\n\t\t${3:// initial code ...}\n\n\t\t$1 = function($2) {\n\t\t\t${4:// main code}\n\t\t};\n\t}\n# singleton\nsnippet sing\n\tfunction ${1:Singleton} (${2:argument}) {\n\t\t// the cached instance\n\t\tvar instance;\n\n\t\t// rewrite the constructor\n\t\t$1 = function $1($2) {\n\t\t\treturn instance;\n\t\t};\n\t\t\n\t\t// carry over the prototype properties\n\t\t$1.prototype = this;\n\n\t\t// the instance\n\t\tinstance = new $1();\n\n\t\t// reset the constructor pointer\n\t\tinstance.constructor = $1;\n\n\t\t${3:// code ...}\n\n\t\treturn instance;\n\t}\n# class\nsnippet class\nregex /^\\s*/clas{0,2}/\n\tvar ${1:class} = function(${20}) {\n\t\t$40$0\n\t};\n\t\n\t(function() {\n\t\t${60:this.prop = \"\"}\n\t}).call(${1:class}.prototype);\n\t\n\texports.${1:class} = ${1:class};\n# \nsnippet for-\n\tfor (var ${1:i} = ${2:Things}.length; ${1:i}--; ) {\n\t\t${0:${2:Things}[${1:i}];}\n\t}\n# for (...) {...}\nsnippet for\n\tfor (var ${1:i} = 0; $1 < ${2:Things}.length; $1++) {\n\t\t${3:$2[$1]}$0\n\t}\n# for (...) {...} (Improved Native For-Loop)\nsnippet forr\n\tfor (var ${1:i} = ${2:Things}.length - 1; $1 >= 0; $1--) {\n\t\t${3:$2[$1]}$0\n\t}\n\n\n#modules\nsnippet def\n\tdefine(function(require, exports, module) {\n\t\"use strict\";\n\tvar ${1/.*\\///} = require(\"${1}\");\n\t\n\t$TM_SELECTED_TEXT\n\t});\nsnippet req\nguard ^\\s*\n\tvar ${1/.*\\///} = require(\"${1}\");\n\t$0\nsnippet requ\nguard ^\\s*\n\tvar ${1/.*\\/(.)/\\u$1/} = require(\"${1}\").${1/.*\\/(.)/\\u$1/};\n\t$0\n";

});

define("ace/snippets/javascript",["require","exports","module","ace/snippets/javascript.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./javascript.snippets");
exports.scope = "javascript";

});

define("ace/snippets/jsp.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet @page\n\t<%@page contentType=\"text/html\" pageEncoding=\"UTF-8\"%>\nsnippet jstl\n\t<%@ taglib uri=\"http://java.sun.com/jsp/jstl/core\" prefix=\"c\" %>\n\t<%@ taglib uri=\"http://java.sun.com/jsp/jstl/functions\" prefix=\"fn\" %>\nsnippet jstl:c\n\t<%@ taglib uri=\"http://java.sun.com/jsp/jstl/core\" prefix=\"c\" %>\nsnippet jstl:fn\n\t<%@ taglib uri=\"http://java.sun.com/jsp/jstl/functions\" prefix=\"fn\" %>\nsnippet cpath\n\t${pageContext.request.contextPath}\nsnippet cout\n\t<c:out value=\"${1}\" default=\"${2}\" />\nsnippet cset\n\t<c:set var=\"${1}\" value=\"${2}\" />\nsnippet cremove\n\t<c:remove var=\"${1}\" scope=\"${2:page}\" />\nsnippet ccatch\n\t<c:catch var=\"${1}\" />\nsnippet cif\n\t<c:if test=\"${${1}}\">\n\t\t${2}\n\t</c:if>\nsnippet cchoose\n\t<c:choose>\n\t\t${1}\n\t</c:choose>\nsnippet cwhen\n\t<c:when test=\"${${1}}\">\n\t\t${2}\n\t</c:when>\nsnippet cother\n\t<c:otherwise>\n\t\t${1}\n\t</c:otherwise>\nsnippet cfore\n\t<c:forEach items=\"${${1}}\" var=\"${2}\" varStatus=\"${3}\">\n\t\t${4:<c:out value=\"$2\" />}\n\t</c:forEach>\nsnippet cfort\n\t<c:set var=\"${1}\">${2:item1,item2,item3}</c:set>\n\t<c:forTokens var=\"${3}\" items=\"${$1}\" delims=\"${4:,}\">\n\t\t${5:<c:out value=\"$3\" />}\n\t</c:forTokens>\nsnippet cparam\n\t<c:param name=\"${1}\" value=\"${2}\" />\nsnippet cparam+\n\t<c:param name=\"${1}\" value=\"${2}\" />\n\tcparam+${3}\nsnippet cimport\n\t<c:import url=\"${1}\" />\nsnippet cimport+\n\t<c:import url=\"${1}\">\n\t\t<c:param name=\"${2}\" value=\"${3}\" />\n\t\tcparam+${4}\n\t</c:import>\nsnippet curl\n\t<c:url value=\"${1}\" var=\"${2}\" />\n\t<a href=\"${$2}\">${3}</a>\nsnippet curl+\n\t<c:url value=\"${1}\" var=\"${2}\">\n\t\t<c:param name=\"${4}\" value=\"${5}\" />\n\t\tcparam+${6}\n\t</c:url>\n\t<a href=\"${$2}\">${3}</a>\nsnippet credirect\n\t<c:redirect url=\"${1}\" />\nsnippet contains\n\t${fn:contains(${1:string}, ${2:substr})}\nsnippet contains:i\n\t${fn:containsIgnoreCase(${1:string}, ${2:substr})}\nsnippet endswith\n\t${fn:endsWith(${1:string}, ${2:suffix})}\nsnippet escape\n\t${fn:escapeXml(${1:string})}\nsnippet indexof\n\t${fn:indexOf(${1:string}, ${2:substr})}\nsnippet join\n\t${fn:join(${1:collection}, ${2:delims})}\nsnippet length\n\t${fn:length(${1:collection_or_string})}\nsnippet replace\n\t${fn:replace(${1:string}, ${2:substr}, ${3:replace})}\nsnippet split\n\t${fn:split(${1:string}, ${2:delims})}\nsnippet startswith\n\t${fn:startsWith(${1:string}, ${2:prefix})}\nsnippet substr\n\t${fn:substring(${1:string}, ${2:begin}, ${3:end})}\nsnippet substr:a\n\t${fn:substringAfter(${1:string}, ${2:substr})}\nsnippet substr:b\n\t${fn:substringBefore(${1:string}, ${2:substr})}\nsnippet lc\n\t${fn:toLowerCase(${1:string})}\nsnippet uc\n\t${fn:toUpperCase(${1:string})}\nsnippet trim\n\t${fn:trim(${1:string})}\n";

});

define("ace/snippets/jsp",["require","exports","module","ace/snippets/jsp.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./jsp.snippets");
exports.scope = "jsp";

});

define("ace/snippets/liquid.snippets",["require","exports","module"], function(require, exports, module){module.exports = "\n# liquid specific snippets\nsnippet ife\n\t{% if ${1:condition} %}\n\n\t{% else %}\n\n\t{% endif %}\nsnippet if\n\t{% if ${1:condition} %}\n\t\t\n\t{% endif %}\nsnippet for\n\t{% for in ${1:iterator} %}\n\n\t{% endfor %}\nsnippet capture\n\t{% capture ${1} %}\n\n\t{% endcapture %}\nsnippet comment\n\t{% comment %}\n\t  ${1:comment}\n\t{% endcomment %}\n\n# Include html.snippets\n# Some useful Unicode entities\n# Non-Breaking Space\nsnippet nbs\n\t&nbsp;\n# \u2190\nsnippet left\n\t&#x2190;\n# \u2192\nsnippet right\n\t&#x2192;\n# \u2191\nsnippet up\n\t&#x2191;\n# \u2193\nsnippet down\n\t&#x2193;\n# \u21A9\nsnippet return\n\t&#x21A9;\n# \u21E4\nsnippet backtab\n\t&#x21E4;\n# \u21E5\nsnippet tab\n\t&#x21E5;\n# \u21E7\nsnippet shift\n\t&#x21E7;\n# \u2303\nsnippet ctrl\n\t&#x2303;\n# \u2305\nsnippet enter\n\t&#x2305;\n# \u2318\nsnippet cmd\n\t&#x2318;\n# \u2325\nsnippet option\n\t&#x2325;\n# \u2326\nsnippet delete\n\t&#x2326;\n# \u232B\nsnippet backspace\n\t&#x232B;\n# \u238B\nsnippet esc\n\t&#x238B;\n# Generic Doctype\nsnippet doctype HTML 4.01 Strict\n\t<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\n\t\"http://www.w3.org/TR/html4/strict.dtd\">\nsnippet doctype HTML 4.01 Transitional\n\t<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n\t\"http://www.w3.org/TR/html4/loose.dtd\">\nsnippet doctype HTML 5\n\t<!DOCTYPE HTML>\nsnippet doctype XHTML 1.0 Frameset\n\t<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\nsnippet doctype XHTML 1.0 Strict\n\t<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\nsnippet doctype XHTML 1.0 Transitional\n\t<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\nsnippet doctype XHTML 1.1\n\t<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\n\t\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n# HTML Doctype 4.01 Strict\nsnippet docts\n\t<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\n\t\"http://www.w3.org/TR/html4/strict.dtd\">\n# HTML Doctype 4.01 Transitional\nsnippet doct\n\t<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n\t\"http://www.w3.org/TR/html4/loose.dtd\">\n# HTML Doctype 5\nsnippet doct5\n\t<!DOCTYPE html>\n# XHTML Doctype 1.0 Frameset\nsnippet docxf\n\t<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\"\n\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">\n# XHTML Doctype 1.0 Strict\nsnippet docxs\n\t<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n# XHTML Doctype 1.0 Transitional\nsnippet docxt\n\t<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n# XHTML Doctype 1.1\nsnippet docx\n\t<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\n\t\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n# html5shiv\nsnippet html5shiv\n\t<!--[if lte IE 8]>\n\t\t<script src=\"https://cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.3/html5shiv.min.js\"></script>\n\t<![endif]-->\nsnippet html5printshiv\n\t<!--[if lte IE 8]>\n\t\t<script src=\"https://cdnjs.cloudflare.com/ajax/libs/html5shiv/3.7.3/html5shiv-printshiv.min.js\"></script>\n\t<![endif]-->\n# Attributes\nsnippet attr\n\t${1:attribute}=\"${2:property}\"\nsnippet attr+\n\t${1:attribute}=\"${2:property}\" attr+${3}\nsnippet .\n\tclass=\"${1}\"${2}\nsnippet #\n\tid=\"${1}\"${2}\nsnippet alt\n\talt=\"${1}\"${2}\nsnippet charset\n\tcharset=\"${1:utf-8}\"${2}\nsnippet data\n\tdata-${1}=\"${2:$1}\"${3}\nsnippet for\n\tfor=\"${1}\"${2}\nsnippet height\n\theight=\"${1}\"${2}\nsnippet href\n\thref=\"${1:#}\"${2}\nsnippet lang\n\tlang=\"${1:en}\"${2}\nsnippet media\n\tmedia=\"${1}\"${2}\nsnippet name\n\tname=\"${1}\"${2}\nsnippet rel\n\trel=\"${1}\"${2}\nsnippet scope\n\tscope=\"${1:row}\"${2}\nsnippet src\n\tsrc=\"${1}\"${2}\nsnippet title=\n\ttitle=\"${1}\"${2}\nsnippet type\n\ttype=\"${1}\"${2}\nsnippet value\n\tvalue=\"${1}\"${2}\nsnippet width\n\twidth=\"${1}\"${2}\n# Elements\nsnippet a\n\t<a href=\"${1:#}\">${2:$1}</a>\nsnippet a.\n\t<a class=\"${1}\" href=\"${2:#}\">${3:$1}</a>\nsnippet a#\n\t<a id=\"${1}\" href=\"${2:#}\">${3:$1}</a>\nsnippet a:ext\n\t<a href=\"http://${1:example.com}\">${2:$1}</a>\nsnippet a:mail\n\t<a href=\"mailto:${1:joe@example.com}?subject=${2:feedback}\">${3:email me}</a>\nsnippet abbr\n\t<abbr title=\"${1}\">${2}</abbr>\nsnippet address\n\t<address>\n\t\t${1}\n\t</address>\nsnippet area\n\t<area shape=\"${1:rect}\" coords=\"${2}\" href=\"${3}\" alt=\"${4}\" />\nsnippet area+\n\t<area shape=\"${1:rect}\" coords=\"${2}\" href=\"${3}\" alt=\"${4}\" />\n\tarea+${5}\nsnippet area:c\n\t<area shape=\"circle\" coords=\"${1}\" href=\"${2}\" alt=\"${3}\" />\nsnippet area:d\n\t<area shape=\"default\" coords=\"${1}\" href=\"${2}\" alt=\"${3}\" />\nsnippet area:p\n\t<area shape=\"poly\" coords=\"${1}\" href=\"${2}\" alt=\"${3}\" />\nsnippet area:r\n\t<area shape=\"rect\" coords=\"${1}\" href=\"${2}\" alt=\"${3}\" />\nsnippet article\n\t<article>\n\t\t${1}\n\t</article>\nsnippet article.\n\t<article class=\"${1}\">\n\t\t${2}\n\t</article>\nsnippet article#\n\t<article id=\"${1}\">\n\t\t${2}\n\t</article>\nsnippet aside\n\t<aside>\n\t\t${1}\n\t</aside>\nsnippet aside.\n\t<aside class=\"${1}\">\n\t\t${2}\n\t</aside>\nsnippet aside#\n\t<aside id=\"${1}\">\n\t\t${2}\n\t</aside>\nsnippet audio\n\t<audio src=\"${1}>${2}</audio>\nsnippet b\n\t<b>${1}</b>\nsnippet base\n\t<base href=\"${1}\" target=\"${2}\" />\nsnippet bdi\n\t<bdi>${1}</bdo>\nsnippet bdo\n\t<bdo dir=\"${1}\">${2}</bdo>\nsnippet bdo:l\n\t<bdo dir=\"ltr\">${1}</bdo>\nsnippet bdo:r\n\t<bdo dir=\"rtl\">${1}</bdo>\nsnippet blockquote\n\t<blockquote>\n\t\t${1}\n\t</blockquote>\nsnippet body\n\t<body>\n\t\t${1}\n\t</body>\nsnippet br\n\t<br />${1}\nsnippet button\n\t<button type=\"${1:submit}\">${2}</button>\nsnippet button.\n\t<button class=\"${1:button}\" type=\"${2:submit}\">${3}</button>\nsnippet button#\n\t<button id=\"${1}\" type=\"${2:submit}\">${3}</button>\nsnippet button:s\n\t<button type=\"submit\">${1}</button>\nsnippet button:r\n\t<button type=\"reset\">${1}</button>\nsnippet canvas\n\t<canvas>\n\t\t${1}\n\t</canvas>\nsnippet caption\n\t<caption>${1}</caption>\nsnippet cite\n\t<cite>${1}</cite>\nsnippet code\n\t<code>${1}</code>\nsnippet col\n\t<col />${1}\nsnippet col+\n\t<col />\n\tcol+${1}\nsnippet colgroup\n\t<colgroup>\n\t\t${1}\n\t</colgroup>\nsnippet colgroup+\n\t<colgroup>\n\t\t<col />\n\t\tcol+${1}\n\t</colgroup>\nsnippet command\n\t<command type=\"command\" label=\"${1}\" icon=\"${2}\" />\nsnippet command:c\n\t<command type=\"checkbox\" label=\"${1}\" icon=\"${2}\" />\nsnippet command:r\n\t<command type=\"radio\" radiogroup=\"${1}\" label=\"${2}\" icon=\"${3}\" />\nsnippet datagrid\n\t<datagrid>\n\t\t${1}\n\t</datagrid>\nsnippet datalist\n\t<datalist>\n\t\t${1}\n\t</datalist>\nsnippet datatemplate\n\t<datatemplate>\n\t\t${1}\n\t</datatemplate>\nsnippet dd\n\t<dd>${1}</dd>\nsnippet dd.\n\t<dd class=\"${1}\">${2}</dd>\nsnippet dd#\n\t<dd id=\"${1}\">${2}</dd>\nsnippet del\n\t<del>${1}</del>\nsnippet details\n\t<details>${1}</details>\nsnippet dfn\n\t<dfn>${1}</dfn>\nsnippet dialog\n\t<dialog>\n\t\t${1}\n\t</dialog>\nsnippet div\n\t<div>\n\t\t${1}\n\t</div>\nsnippet div.\n\t<div class=\"${1}\">\n\t\t${2}\n\t</div>\nsnippet div#\n\t<div id=\"${1}\">\n\t\t${2}\n\t</div>\nsnippet dl\n\t<dl>\n\t\t${1}\n\t</dl>\nsnippet dl.\n\t<dl class=\"${1}\">\n\t\t${2}\n\t</dl>\nsnippet dl#\n\t<dl id=\"${1}\">\n\t\t${2}\n\t</dl>\nsnippet dl+\n\t<dl>\n\t\t<dt>${1}</dt>\n\t\t<dd>${2}</dd>\n\t\tdt+${3}\n\t</dl>\nsnippet dt\n\t<dt>${1}</dt>\nsnippet dt.\n\t<dt class=\"${1}\">${2}</dt>\nsnippet dt#\n\t<dt id=\"${1}\">${2}</dt>\nsnippet dt+\n\t<dt>${1}</dt>\n\t<dd>${2}</dd>\n\tdt+${3}\nsnippet em\n\t<em>${1}</em>\nsnippet embed\n\t<embed src=${1} type=\"${2} />\nsnippet fieldset\n\t<fieldset>\n\t\t${1}\n\t</fieldset>\nsnippet fieldset.\n\t<fieldset class=\"${1}\">\n\t\t${2}\n\t</fieldset>\nsnippet fieldset#\n\t<fieldset id=\"${1}\">\n\t\t${2}\n\t</fieldset>\nsnippet fieldset+\n\t<fieldset>\n\t\t<legend><span>${1}</span></legend>\n\t\t${2}\n\t</fieldset>\n\tfieldset+${3}\nsnippet figcaption\n\t<figcaption>${1}</figcaption>\nsnippet figure\n\t<figure>${1}</figure>\nsnippet footer\n\t<footer>\n\t\t${1}\n\t</footer>\nsnippet footer.\n\t<footer class=\"${1}\">\n\t\t${2}\n\t</footer>\nsnippet footer#\n\t<footer id=\"${1}\">\n\t\t${2}\n\t</footer>\nsnippet form\n\t<form action=\"${1}\" method=\"${2:get}\" accept-charset=\"utf-8\">\n\t\t${3}\n\t</form>\nsnippet form.\n\t<form class=\"${1}\" action=\"${2}\" method=\"${3:get}\" accept-charset=\"utf-8\">\n\t\t${4}\n\t</form>\nsnippet form#\n\t<form id=\"${1}\" action=\"${2}\" method=\"${3:get}\" accept-charset=\"utf-8\">\n\t\t${4}\n\t</form>\nsnippet h1\n\t<h1>${1}</h1>\nsnippet h1.\n\t<h1 class=\"${1}\">${2}</h1>\nsnippet h1#\n\t<h1 id=\"${1}\">${2}</h1>\nsnippet h2\n\t<h2>${1}</h2>\nsnippet h2.\n\t<h2 class=\"${1}\">${2}</h2>\nsnippet h2#\n\t<h2 id=\"${1}\">${2}</h2>\nsnippet h3\n\t<h3>${1}</h3>\nsnippet h3.\n\t<h3 class=\"${1}\">${2}</h3>\nsnippet h3#\n\t<h3 id=\"${1}\">${2}</h3>\nsnippet h4\n\t<h4>${1}</h4>\nsnippet h4.\n\t<h4 class=\"${1}\">${2}</h4>\nsnippet h4#\n\t<h4 id=\"${1}\">${2}</h4>\nsnippet h5\n\t<h5>${1}</h5>\nsnippet h5.\n\t<h5 class=\"${1}\">${2}</h5>\nsnippet h5#\n\t<h5 id=\"${1}\">${2}</h5>\nsnippet h6\n\t<h6>${1}</h6>\nsnippet h6.\n\t<h6 class=\"${1}\">${2}</h6>\nsnippet h6#\n\t<h6 id=\"${1}\">${2}</h6>\nsnippet head\n\t<head>\n\t\t<meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />\n\n\t\t<title>${1:`substitute(Filename('', 'Page Title'), '^.', '\\u&', '')`}</title>\n\t\t${2}\n\t</head>\nsnippet header\n\t<header>\n\t\t${1}\n\t</header>\nsnippet header.\n\t<header class=\"${1}\">\n\t\t${2}\n\t</header>\nsnippet header#\n\t<header id=\"${1}\">\n\t\t${2}\n\t</header>\nsnippet hgroup\n\t<hgroup>\n\t\t${1}\n\t</hgroup>\nsnippet hgroup.\n\t<hgroup class=\"${1}>\n\t\t${2}\n\t</hgroup>\nsnippet hr\n\t<hr />${1}\nsnippet html\n\t<html>\n\t${1}\n\t</html>\nsnippet xhtml\n\t<html xmlns=\"http://www.w3.org/1999/xhtml\">\n\t${1}\n\t</html>\nsnippet html5\n\t<!DOCTYPE html>\n\t<html>\n\t\t<head>\n\t\t\t<meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />\n\t\t\t<title>${1:`substitute(Filename('', 'Page Title'), '^.', '\\u&', '')`}</title>\n\t\t\t${2:meta}\n\t\t</head>\n\t\t<body>\n\t\t\t${3:body}\n\t\t</body>\n\t</html>\nsnippet xhtml5\n\t<!DOCTYPE html>\n\t<html xmlns=\"http://www.w3.org/1999/xhtml\">\n\t\t<head>\n\t\t\t<meta http-equiv=\"content-type\" content=\"application/xhtml+xml; charset=utf-8\" />\n\t\t\t<title>${1:`substitute(Filename('', 'Page Title'), '^.', '\\u&', '')`}</title>\n\t\t\t${2:meta}\n\t\t</head>\n\t\t<body>\n\t\t\t${3:body}\n\t\t</body>\n\t</html>\nsnippet i\n\t<i>${1}</i>\nsnippet iframe\n\t<iframe src=\"${1}\" frameborder=\"0\"></iframe>${2}\nsnippet iframe.\n\t<iframe class=\"${1}\" src=\"${2}\" frameborder=\"0\"></iframe>${3}\nsnippet iframe#\n\t<iframe id=\"${1}\" src=\"${2}\" frameborder=\"0\"></iframe>${3}\nsnippet img\n\t<img src=\"${1}\" alt=\"${2}\" />${3}\nsnippet img.\n\t<img class=\"${1}\" src=\"${2}\" alt=\"${3}\" />${4}\nsnippet img#\n\t<img id=\"${1}\" src=\"${2}\" alt=\"${3}\" />${4}\nsnippet input\n\t<input type=\"${1:text/submit/hidden/button/image}\" name=\"${2}\" id=\"${3:$2}\" value=\"${4}\" />${5}\nsnippet input.\n\t<input class=\"${1}\" type=\"${2:text/submit/hidden/button/image}\" name=\"${3}\" id=\"${4:$3}\" value=\"${5}\" />${6}\nsnippet input:text\n\t<input type=\"text\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:submit\n\t<input type=\"submit\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:hidden\n\t<input type=\"hidden\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:button\n\t<input type=\"button\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:image\n\t<input type=\"image\" name=\"${1}\" id=\"${2:$1}\" src=\"${3}\" alt=\"${4}\" />${5}\nsnippet input:checkbox\n\t<input type=\"checkbox\" name=\"${1}\" id=\"${2:$1}\" />${3}\nsnippet input:radio\n\t<input type=\"radio\" name=\"${1}\" id=\"${2:$1}\" />${3}\nsnippet input:color\n\t<input type=\"color\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:date\n\t<input type=\"date\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:datetime\n\t<input type=\"datetime\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:datetime-local\n\t<input type=\"datetime-local\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:email\n\t<input type=\"email\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:file\n\t<input type=\"file\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:month\n\t<input type=\"month\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:number\n\t<input type=\"number\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:password\n\t<input type=\"password\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:range\n\t<input type=\"range\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:reset\n\t<input type=\"reset\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:search\n\t<input type=\"search\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:time\n\t<input type=\"time\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:url\n\t<input type=\"url\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet input:week\n\t<input type=\"week\" name=\"${1}\" id=\"${2:$1}\" value=\"${3}\" />${4}\nsnippet ins\n\t<ins>${1}</ins>\nsnippet kbd\n\t<kbd>${1}</kbd>\nsnippet keygen\n\t<keygen>${1}</keygen>\nsnippet label\n\t<label for=\"${2:$1}\">${1}</label>\nsnippet label:i\n\t<label for=\"${2:$1}\">${1}</label>\n\t<input type=\"${3:text/submit/hidden/button}\" name=\"${4:$2}\" id=\"${5:$2}\" value=\"${6}\" />${7}\nsnippet label:s\n\t<label for=\"${2:$1}\">${1}</label>\n\t<select name=\"${3:$2}\" id=\"${4:$2}\">\n\t\t<option value=\"${5}\">${6:$5}</option>\n\t</select>\nsnippet legend\n\t<legend>${1}</legend>\nsnippet legend+\n\t<legend><span>${1}</span></legend>\nsnippet li\n\t<li>${1}</li>\nsnippet li.\n\t<li class=\"${1}\">${2}</li>\nsnippet li+\n\t<li>${1}</li>\n\tli+${2}\nsnippet lia\n\t<li><a href=\"${2:#}\">${1}</a></li>\nsnippet lia+\n\t<li><a href=\"${2:#}\">${1}</a></li>\n\tlia+${3}\nsnippet link\n\t<link rel=\"${1}\" href=\"${2}\" title=\"${3}\" type=\"${4}\" />${5}\nsnippet link:atom\n\t<link rel=\"alternate\" href=\"${1:atom.xml}\" title=\"Atom\" type=\"application/atom+xml\" />${2}\nsnippet link:css\n\t<link rel=\"stylesheet\" href=\"${2:style.css}\" type=\"text/css\" media=\"${3:all}\" />${4}\nsnippet link:favicon\n\t<link rel=\"shortcut icon\" href=\"${1:favicon.ico}\" type=\"image/x-icon\" />${2}\nsnippet link:rss\n\t<link rel=\"alternate\" href=\"${1:rss.xml}\" title=\"RSS\" type=\"application/atom+xml\" />${2}\nsnippet link:touch\n\t<link rel=\"apple-touch-icon\" href=\"${1:favicon.png}\" />${2}\nsnippet map\n\t<map name=\"${1}\">\n\t\t${2}\n\t</map>\nsnippet map.\n\t<map class=\"${1}\" name=\"${2}\">\n\t\t${3}\n\t</map>\nsnippet map#\n\t<map name=\"${1}\" id=\"${2:$1}>\n\t\t${3}\n\t</map>\nsnippet map+\n\t<map name=\"${1}\">\n\t\t<area shape=\"${2}\" coords=\"${3}\" href=\"${4}\" alt=\"${5}\" />${6}\n\t</map>${7}\nsnippet mark\n\t<mark>${1}</mark>\nsnippet menu\n\t<menu>\n\t\t${1}\n\t</menu>\nsnippet menu:c\n\t<menu type=\"context\">\n\t\t${1}\n\t</menu>\nsnippet menu:t\n\t<menu type=\"toolbar\">\n\t\t${1}\n\t</menu>\nsnippet meta\n\t<meta http-equiv=\"${1}\" content=\"${2}\" />${3}\nsnippet meta:compat\n\t<meta http-equiv=\"X-UA-Compatible\" content=\"IE=${1:7,8,edge}\" />${3}\nsnippet meta:refresh\n\t<meta http-equiv=\"refresh\" content=\"text/html;charset=UTF-8\" />${3}\nsnippet meta:utf\n\t<meta http-equiv=\"content-type\" content=\"text/html;charset=UTF-8\" />${3}\nsnippet meter\n\t<meter>${1}</meter>\nsnippet nav\n\t<nav>\n\t\t${1}\n\t</nav>\nsnippet nav.\n\t<nav class=\"${1}\">\n\t\t${2}\n\t</nav>\nsnippet nav#\n\t<nav id=\"${1}\">\n\t\t${2}\n\t</nav>\nsnippet noscript\n\t<noscript>\n\t\t${1}\n\t</noscript>\nsnippet object\n\t<object data=\"${1}\" type=\"${2}\">\n\t\t${3}\n\t</object>${4}\n# Embed QT Movie\nsnippet movie\n\t<object width=\"$2\" height=\"$3\" classid=\"clsid:02BF25D5-8C17-4B23-BC80-D3488ABDDC6B\"\n\t codebase=\"http://www.apple.com/qtactivex/qtplugin.cab\">\n\t\t<param name=\"src\" value=\"$1\" />\n\t\t<param name=\"controller\" value=\"$4\" />\n\t\t<param name=\"autoplay\" value=\"$5\" />\n\t\t<embed src=\"${1:movie.mov}\"\n\t\t\twidth=\"${2:320}\" height=\"${3:240}\"\n\t\t\tcontroller=\"${4:true}\" autoplay=\"${5:true}\"\n\t\t\tscale=\"tofit\" cache=\"true\"\n\t\t\tpluginspage=\"http://www.apple.com/quicktime/download/\" />\n\t</object>${6}\nsnippet ol\n\t<ol>\n\t\t${1}\n\t</ol>\nsnippet ol.\n\t<ol class=\"${1}>\n\t\t${2}\n\t</ol>\nsnippet ol#\n\t<ol id=\"${1}>\n\t\t${2}\n\t</ol>\nsnippet ol+\n\t<ol>\n\t\t<li>${1}</li>\n\t\tli+${2}\n\t</ol>\nsnippet opt\n\t<option value=\"${1}\">${2:$1}</option>\nsnippet opt+\n\t<option value=\"${1}\">${2:$1}</option>\n\topt+${3}\nsnippet optt\n\t<option>${1}</option>\nsnippet optgroup\n\t<optgroup>\n\t\t<option value=\"${1}\">${2:$1}</option>\n\t\topt+${3}\n\t</optgroup>\nsnippet output\n\t<output>${1}</output>\nsnippet p\n\t<p>${1}</p>\nsnippet param\n\t<param name=\"${1}\" value=\"${2}\" />${3}\nsnippet pre\n\t<pre>\n\t\t${1}\n\t</pre>\nsnippet progress\n\t<progress>${1}</progress>\nsnippet q\n\t<q>${1}</q>\nsnippet rp\n\t<rp>${1}</rp>\nsnippet rt\n\t<rt>${1}</rt>\nsnippet ruby\n\t<ruby>\n\t\t<rp><rt>${1}</rt></rp>\n\t</ruby>\nsnippet s\n\t<s>${1}</s>\nsnippet samp\n\t<samp>\n\t\t${1}\n\t</samp>\nsnippet script\n\t<script type=\"text/javascript\" charset=\"utf-8\">\n\t\t${1}\n\t</script>\nsnippet scriptsrc\n\t<script src=\"${1}.js\" type=\"text/javascript\" charset=\"utf-8\"></script>\nsnippet newscript\n\t<script type=\"application/javascript\" charset=\"utf-8\">\n\t\t${1}\n\t</script>\nsnippet newscriptsrc\n\t<script src=\"${1}.js\" type=\"application/javascript\" charset=\"utf-8\"></script>\nsnippet section\n\t<section>\n\t\t${1}\n\t</section>\nsnippet section.\n\t<section class=\"${1}\">\n\t\t${2}\n\t</section>\nsnippet section#\n\t<section id=\"${1}\">\n\t\t${2}\n\t</section>\nsnippet select\n\t<select name=\"${1}\" id=\"${2:$1}\">\n\t\t${3}\n\t</select>\nsnippet select.\n\t<select name=\"${1}\" id=\"${2:$1}\" class=\"${3}>\n\t\t${4}\n\t</select>\nsnippet select+\n\t<select name=\"${1}\" id=\"${2:$1}\">\n\t\t<option value=\"${3}\">${4:$3}</option>\n\t\topt+${5}\n\t</select>\nsnippet small\n\t<small>${1}</small>\nsnippet source\n\t<source src=\"${1}\" type=\"${2}\" media=\"${3}\" />\nsnippet span\n\t<span>${1}</span>\nsnippet strong\n\t<strong>${1}</strong>\nsnippet style\n\t<style type=\"text/css\" media=\"${1:all}\">\n\t\t${2}\n\t</style>\nsnippet sub\n\t<sub>${1}</sub>\nsnippet summary\n\t<summary>\n\t\t${1}\n\t</summary>\nsnippet sup\n\t<sup>${1}</sup>\nsnippet table\n\t<table border=\"${1:0}\">\n\t\t${2}\n\t</table>\nsnippet table.\n\t<table class=\"${1}\" border=\"${2:0}\">\n\t\t${3}\n\t</table>\nsnippet table#\n\t<table id=\"${1}\" border=\"${2:0}\">\n\t\t${3}\n\t</table>\nsnippet tbody\n\t<tbody>\n\t\t${1}\n\t</tbody>\nsnippet td\n\t<td>${1}</td>\nsnippet td.\n\t<td class=\"${1}\">${2}</td>\nsnippet td#\n\t<td id=\"${1}\">${2}</td>\nsnippet td+\n\t<td>${1}</td>\n\ttd+${2}\nsnippet textarea\n\t<textarea name=\"${1}\" id=${2:$1} rows=\"${3:8}\" cols=\"${4:40}\">${5}</textarea>${6}\nsnippet tfoot\n\t<tfoot>\n\t\t${1}\n\t</tfoot>\nsnippet th\n\t<th>${1}</th>\nsnippet th.\n\t<th class=\"${1}\">${2}</th>\nsnippet th#\n\t<th id=\"${1}\">${2}</th>\nsnippet th+\n\t<th>${1}</th>\n\tth+${2}\nsnippet thead\n\t<thead>\n\t\t${1}\n\t</thead>\nsnippet time\n\t<time datetime=\"${1}\" pubdate=\"${2:$1}>${3:$1}</time>\nsnippet title\n\t<title>${1:`substitute(Filename('', 'Page Title'), '^.', '\\u&', '')`}</title>\nsnippet tr\n\t<tr>\n\t\t${1}\n\t</tr>\nsnippet tr+\n\t<tr>\n\t\t<td>${1}</td>\n\t\ttd+${2}\n\t</tr>\nsnippet track\n\t<track src=\"${1}\" srclang=\"${2}\" label=\"${3}\" default=\"${4:default}>${5}</track>${6}\nsnippet ul\n\t<ul>\n\t\t${1}\n\t</ul>\nsnippet ul.\n\t<ul class=\"${1}\">\n\t\t${2}\n\t</ul>\nsnippet ul#\n\t<ul id=\"${1}\">\n\t\t${2}\n\t</ul>\nsnippet ul+\n\t<ul>\n\t\t<li>${1}</li>\n\t\tli+${2}\n\t</ul>\nsnippet var\n\t<var>${1}</var>\nsnippet video\n\t<video src=\"${1} height=\"${2}\" width=\"${3}\" preload=\"${5:none}\" autoplay=\"${6:autoplay}>${7}</video>${8}\nsnippet wbr\n\t<wbr />${1}\n";

});

define("ace/snippets/liquid",["require","exports","module","ace/snippets/liquid.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./liquid.snippets");
exports.scope = "liquid";

});

define("ace/snippets/lsl.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet @\n\t@${1:label};\nsnippet CAMERA_ACTIVE\n\tCAMERA_ACTIVE, ${1:integer isActive}, $0\nsnippet CAMERA_BEHINDNESS_ANGLE\n\tCAMERA_BEHINDNESS_ANGLE, ${1:float degrees}, $0\nsnippet CAMERA_BEHINDNESS_LAG\n\tCAMERA_BEHINDNESS_LAG, ${1:float seconds}, $0\nsnippet CAMERA_DISTANCE\n\tCAMERA_DISTANCE, ${1:float meters}, $0\nsnippet CAMERA_FOCUS\n\tCAMERA_FOCUS, ${1:vector position}, $0\nsnippet CAMERA_FOCUS_LAG\n\tCAMERA_FOCUS_LAG, ${1:float seconds}, $0\nsnippet CAMERA_FOCUS_LOCKED\n\tCAMERA_FOCUS_LOCKED, ${1:integer isLocked}, $0\nsnippet CAMERA_FOCUS_OFFSET\n\tCAMERA_FOCUS_OFFSET, ${1:vector meters}, $0\nsnippet CAMERA_FOCUS_THRESHOLD\n\tCAMERA_FOCUS_THRESHOLD, ${1:float meters}, $0\nsnippet CAMERA_PITCH\n\tCAMERA_PITCH, ${1:float degrees}, $0\nsnippet CAMERA_POSITION\n\tCAMERA_POSITION, ${1:vector position}, $0\nsnippet CAMERA_POSITION_LAG\n\tCAMERA_POSITION_LAG, ${1:float seconds}, $0\nsnippet CAMERA_POSITION_LOCKED\n\tCAMERA_POSITION_LOCKED, ${1:integer isLocked}, $0\nsnippet CAMERA_POSITION_THRESHOLD\n\tCAMERA_POSITION_THRESHOLD, ${1:float meters}, $0\nsnippet CHARACTER_AVOIDANCE_MODE\n\tCHARACTER_AVOIDANCE_MODE, ${1:integer flags}, $0\nsnippet CHARACTER_DESIRED_SPEED\n\tCHARACTER_DESIRED_SPEED, ${1:float speed}, $0\nsnippet CHARACTER_DESIRED_TURN_SPEED\n\tCHARACTER_DESIRED_TURN_SPEED, ${1:float speed}, $0\nsnippet CHARACTER_LENGTH\n\tCHARACTER_LENGTH, ${1:float length}, $0\nsnippet CHARACTER_MAX_TURN_RADIUS\n\tCHARACTER_MAX_TURN_RADIUS, ${1:float radius}, $0\nsnippet CHARACTER_ORIENTATION\n\tCHARACTER_ORIENTATION, ${1:integer orientation}, $0\nsnippet CHARACTER_RADIUS\n\tCHARACTER_RADIUS, ${1:float radius}, $0\nsnippet CHARACTER_STAY_WITHIN_PARCEL\n\tCHARACTER_STAY_WITHIN_PARCEL, ${1:boolean stay}, $0\nsnippet CHARACTER_TYPE\n\tCHARACTER_TYPE, ${1:integer type}, $0\nsnippet HTTP_BODY_MAXLENGTH\n\tHTTP_BODY_MAXLENGTH, ${1:integer length}, $0\nsnippet HTTP_CUSTOM_HEADER\n\tHTTP_CUSTOM_HEADER, ${1:string name}, ${2:string value}, $0\nsnippet HTTP_METHOD\n\tHTTP_METHOD, ${1:string method}, $0\nsnippet HTTP_MIMETYPE\n\tHTTP_MIMETYPE, ${1:string mimeType}, $0\nsnippet HTTP_PRAGMA_NO_CACHE\n\tHTTP_PRAGMA_NO_CACHE, ${1:integer send_header}, $0\nsnippet HTTP_VERBOSE_THROTTLE\n\tHTTP_VERBOSE_THROTTLE, ${1:integer noisy}, $0\nsnippet HTTP_VERIFY_CERT\n\tHTTP_VERIFY_CERT, ${1:integer verify}, $0\nsnippet RC_DATA_FLAGS\n\tRC_DATA_FLAGS, ${1:integer flags}, $0\nsnippet RC_DETECT_PHANTOM\n\tRC_DETECT_PHANTOM, ${1:integer dectedPhantom}, $0\nsnippet RC_MAX_HITS\n\tRC_MAX_HITS, ${1:integer maxHits}, $0\nsnippet RC_REJECT_TYPES\n\tRC_REJECT_TYPES, ${1:integer filterMask}, $0\nsnippet at_rot_target\n\tat_rot_target(${1:integer handle}, ${2:rotation targetrot}, ${3:rotation ourrot})\n\t{\n\t\t$0\n\t}\nsnippet at_target\n\tat_target(${1:integer tnum}, ${2:vector targetpos}, ${3:vector ourpos})\n\t{\n\t\t$0\n\t}\nsnippet attach\n\tattach(${1:key id})\n\t{\n\t\t$0\n\t}\nsnippet changed\n\tchanged(${1:integer change})\n\t{\n\t\t$0\n\t}\nsnippet collision\n\tcollision(${1:integer index})\n\t{\n\t\t$0\n\t}\nsnippet collision_end\n\tcollision_end(${1:integer index})\n\t{\n\t\t$0\n\t}\nsnippet collision_start\n\tcollision_start(${1:integer index})\n\t{\n\t\t$0\n\t}\nsnippet control\n\tcontrol(${1:key id}, ${2:integer level}, ${3:integer edge})\n\t{\n\t\t$0\n\t}\nsnippet dataserver\n\tdataserver(${1:key query_id}, ${2:string data})\n\t{\n\t\t$0\n\t}\nsnippet do\n\tdo\n\t{\n\t\t$0\n\t}\n\twhile (${1:condition});\nsnippet else\n\telse\n\t{\n\t\t$0\n\t}\nsnippet email\n\temail(${1:string time}, ${2:string address}, ${3:string subject}, ${4:string message}, ${5:integer num_left})\n\t{\n\t\t$0\n\t}\nsnippet experience_permissions\n\texperience_permissions(${1:key agent_id})\n\t{\n\t\t$0\n\t}\nsnippet experience_permissions_denied\n\texperience_permissions_denied(${1:key agent_id}, ${2:integer reason})\n\t{\n\t\t$0\n\t}\nsnippet for\n\tfor (${1:start}; ${3:condition}; ${3:step})\n\t{\n\t\t$0\n\t}\nsnippet http_request\n\thttp_request(${1:key request_id}, ${2:string method}, ${3:string body})\n\t{\n\t\t$0\n\t}\nsnippet http_response\n\thttp_response(${1:key request_id}, ${2:integer status}, ${3:list metadata}, ${4:string body})\n\t{\n\t\t$0\n\t}\nsnippet if\n\tif (${1:condition})\n\t{\n\t\t$0\n\t}\nsnippet jump\n\tjump ${1:label};\nsnippet land_collision\n\tland_collision(${1:vector pos})\n\t{\n\t\t$0\n\t}\nsnippet land_collision_end\n\tland_collision_end(${1:vector pos})\n\t{\n\t\t$0\n\t}\nsnippet land_collision_start\n\tland_collision_start(${1:vector pos})\n\t{\n\t\t$0\n\t}\nsnippet link_message\n\tlink_message(${1:integer sender_num}, ${2:integer num}, ${3:string str}, ${4:key id})\n\t{\n\t\t$0\n\t}\nsnippet listen\n\tlisten(${1:integer channel}, ${2:string name}, ${3:key id}, ${4:string message})\n\t{\n\t\t$0\n\t}\nsnippet llAbs\n\tllAbs(${1:integer val})\nsnippet llAcos\n\tllAcos(${1:float val})\nsnippet llAddToLandBanList\n\tllAddToLandBanList(${1:key agent}, ${2:float hours});\n\t$0\nsnippet llAddToLandPassList\n\tllAddToLandPassList(${1:key agent}, ${2:float hours});\n\t$0\nsnippet llAdjustSoundVolume\n\tllAdjustSoundVolume(${1:float volume});\n\t$0\nsnippet llAgentInExperience\n\tllAgentInExperience(${1:key agent})\nsnippet llAllowInventoryDrop\n\tllAllowInventoryDrop(${1:integer add});\n\t$0\nsnippet llAngleBetween\n\tllAngleBetween(${1:rotation a}, ${2:rotation b})\nsnippet llApplyImpulse\n\tllApplyImpulse(${1:vector force}, ${2:integer local});\n\t$0\nsnippet llApplyRotationalImpulse\n\tllApplyRotationalImpulse(${1:vector force}, ${2:integer local});\n\t$0\nsnippet llAsin\n\tllAsin(${1:float val})\nsnippet llAtan2\n\tllAtan2(${1:float y}, ${2:float x})\nsnippet llAttachToAvatar\n\tllAttachToAvatar(${1:integer attach_point});\n\t$0\nsnippet llAttachToAvatarTemp\n\tllAttachToAvatarTemp(${1:integer attach_point});\n\t$0\nsnippet llAvatarOnLinkSitTarget\n\tllAvatarOnLinkSitTarget(${1:integer link})\nsnippet llAvatarOnSitTarget\n\tllAvatarOnSitTarget()\nsnippet llAxes2Rot\n\tllAxes2Rot(${1:vector fwd}, ${2:vector left}, ${3:vector up})\nsnippet llAxisAngle2Rot\n\tllAxisAngle2Rot(${1:vector axis}, ${2:float angle})\nsnippet llBase64ToInteger\n\tllBase64ToInteger(${1:string str})\nsnippet llBase64ToString\n\tllBase64ToString(${1:string str})\nsnippet llBreakAllLinks\n\tllBreakAllLinks();\n\t$0\nsnippet llBreakLink\n\tllBreakLink(${1:integer link});\n\t$0\nsnippet llCastRay\n\tllCastRay(${1:vector start}, ${2:vector end}, ${3:list options});\n\t$0\nsnippet llCeil\n\tllCeil(${1:float val})\nsnippet llClearCameraParams\n\tllClearCameraParams();\n\t$0\nsnippet llClearLinkMedia\n\tllClearLinkMedia(${1:integer link}, ${2:integer face});\n\t$0\nsnippet llClearPrimMedia\n\tllClearPrimMedia(${1:integer face});\n\t$0\nsnippet llCloseRemoteDataChannel\n\tllCloseRemoteDataChannel(${1:key channel});\n\t$0\nsnippet llCollisionFilter\n\tllCollisionFilter(${1:string name}, ${2:key id}, ${3:integer accept});\n\t$0\nsnippet llCollisionSound\n\tllCollisionSound(${1:string impact_sound}, ${2:float impact_volume});\n\t$0\nsnippet llCos\n\tllCos(${1:float theta})\nsnippet llCreateCharacter\n\tllCreateCharacter(${1:list options});\n\t$0\nsnippet llCreateKeyValue\n\tllCreateKeyValue(${1:string k})\nsnippet llCreateLink\n\tllCreateLink(${1:key target}, ${2:integer parent});\n\t$0\nsnippet llCSV2List\n\tllCSV2List(${1:string src})\nsnippet llDataSizeKeyValue\n\tllDataSizeKeyValue()\nsnippet llDeleteCharacter\n\tllDeleteCharacter();\n\t$0\nsnippet llDeleteKeyValue\n\tllDeleteKeyValue(${1:string k})\nsnippet llDeleteSubList\n\tllDeleteSubList(${1:list src}, ${2:integer start}, ${3:integer end})\nsnippet llDeleteSubString\n\tllDeleteSubString(${1:string src}, ${2:integer start}, ${3:integer end})\nsnippet llDetachFromAvatar\n\tllDetachFromAvatar();\n\t$0\nsnippet llDetectedGrab\n\tllDetectedGrab(${1:integer number})\nsnippet llDetectedGroup\n\tllDetectedGroup(${1:integer number})\nsnippet llDetectedKey\n\tllDetectedKey(${1:integer number})\nsnippet llDetectedLinkNumber\n\tllDetectedLinkNumber(${1:integer number})\nsnippet llDetectedName\n\tllDetectedName(${1:integer number})\nsnippet llDetectedOwner\n\tllDetectedOwner(${1:integer number})\nsnippet llDetectedPos\n\tllDetectedPosl(${1:integer number})\nsnippet llDetectedRot\n\tllDetectedRot(${1:integer number})\nsnippet llDetectedTouchBinormal\n\tllDetectedTouchBinormal(${1:integer number})\nsnippet llDetectedTouchFace\n\tllDetectedTouchFace(${1:integer number})\nsnippet llDetectedTouchNormal\n\tllDetectedTouchNormal(${1:integer number})\nsnippet llDetectedTouchPos\n\tllDetectedTouchPos(${1:integer number})\nsnippet llDetectedTouchST\n\tllDetectedTouchST(${1:integer number})\nsnippet llDetectedTouchUV\n\tllDetectedTouchUV(${1:integer number})\nsnippet llDetectedType\n\tllDetectedType(${1:integer number})\nsnippet llDetectedVel\n\tllDetectedVel(${1:integer number})\nsnippet llDialog\n\tllDialog(${1:key agent}, ${2:string message}, ${3:list buttons}, ${4:integer channel});\n\t$0\nsnippet llDie\n\tllDie();\n\t$0\nsnippet llDumpList2String\n\tllDumpList2String(${1:list src}, ${2:string separator})\nsnippet llEdgeOfWorld\n\tllEdgeOfWorld(${1:vector pos}, ${2:vector dir})\nsnippet llEjectFromLand\n\tllEjectFromLand(${1:key agent});\n\t$0\nsnippet llEmail\n\tllEmail(${1:string address}, ${2:string subject}, ${3:string message});\n\t$0\nsnippet llEscapeURL\n\tllEscapeURL(${1:string url})\nsnippet llEuler2Rot\n\tllEuler2Rot(${1:vector v})\nsnippet llExecCharacterCmd\n\tllExecCharacterCmd(${1:integer command}, ${2:list options});\n\t$0\nsnippet llEvade\n\tllEvade(${1:key target}, ${2:list options});\n\t$0\nsnippet llFabs\n\tllFabs(${1:float val})\nsnippet llFleeFrom\n\tllFleeFrom(${1:vector position}, ${2:float distance}, ${3:list options});\n\t$0\nsnippet llFloor\n\tllFloor(${1:float val})\nsnippet llForceMouselook\n\tllForceMouselook(${1:integer mouselook});\n\t$0\nsnippet llFrand\n\tllFrand(${1:float mag})\nsnippet llGenerateKey\n\tllGenerateKey()\nsnippet llGetAccel\n\tllGetAccel()\nsnippet llGetAgentInfo\n\tllGetAgentInfo(${1:key id})\nsnippet llGetAgentLanguage\n\tllGetAgentLanguage(${1:key agent})\nsnippet llGetAgentList\n\tllGetAgentList(${1:integer scope}, ${2:list options})\nsnippet llGetAgentSize\n\tllGetAgentSize(${1:key agent})\nsnippet llGetAlpha\n\tllGetAlpha(${1:integer face})\nsnippet llGetAndResetTime\n\tllGetAndResetTime()\nsnippet llGetAnimation\n\tllGetAnimation(${1:key id})\nsnippet llGetAnimationList\n\tllGetAnimationList(${1:key agent})\nsnippet llGetAnimationOverride\n\tllGetAnimationOverride(${1:string anim_state})\nsnippet llGetAttached\n\tllGetAttached()\nsnippet llGetAttachedList\n\tllGetAttachedList(${1:key id})\nsnippet llGetBoundingBox\n\tllGetBoundingBox(${1:key object})\nsnippet llGetCameraPos\n\tllGetCameraPos()\nsnippet llGetCameraRot\n\tllGetCameraRot()\nsnippet llGetCenterOfMass\n\tllGetCenterOfMass()\nsnippet llGetClosestNavPoint\n\tllGetClosestNavPoint(${1:vector point}, ${2:list options})\nsnippet llGetColor\n\tllGetColor(${1:integer face})\nsnippet llGetCreator\n\tllGetCreator()\nsnippet llGetDate\n\tllGetDate()\nsnippet llGetDisplayName\n\tllGetDisplayName(${1:key id})\nsnippet llGetEnergy\n\tllGetEnergy()\nsnippet llGetEnv\n\tllGetEnv(${1:string name})\nsnippet llGetExperienceDetails\n\tllGetExperienceDetails(${1:key experience_id})\nsnippet llGetExperienceErrorMessage\n\tllGetExperienceErrorMessage(${1:integer error})\nsnippet llGetForce\n\tllGetForce()\nsnippet llGetFreeMemory\n\tllGetFreeMemory()\nsnippet llGetFreeURLs\n\tllGetFreeURLs()\nsnippet llGetGeometricCenter\n\tllGetGeometricCenter()\nsnippet llGetGMTclock\n\tllGetGMTclock()\nsnippet llGetHTTPHeader\n\tllGetHTTPHeader(${1:key request_id}, ${2:string header})\nsnippet llGetInventoryCreator\n\tllGetInventoryCreator(${1:string item})\nsnippet llGetInventoryKey\n\tllGetInventoryKey(${1:string name})\nsnippet llGetInventoryName\n\tllGetInventoryName(${1:integer type}, ${2:integer number})\nsnippet llGetInventoryNumber\n\tllGetInventoryNumber(${1:integer type})\nsnippet llGetInventoryPermMask\n\tllGetInventoryPermMask(${1:string item}, ${2:integer mask})\nsnippet llGetInventoryType\n\tllGetInventoryType(${1:string name})\nsnippet llGetKey\n\tllGetKey()\nsnippet llGetLandOwnerAt\n\tllGetLandOwnerAt(${1:vector pos})\nsnippet llGetLinkKey\n\tllGetLinkKey(${1:integer link})\nsnippet llGetLinkMedia\n\tllGetLinkMedia(${1:integer link}, ${2:integer face}, ${3:list params})\nsnippet llGetLinkName\n\tllGetLinkName(${1:integer link})\nsnippet llGetLinkNumber\n\tllGetLinkNumber()\nsnippet llGetLinkNumberOfSides\n\tllGetLinkNumberOfSides(${1:integer link})\nsnippet llGetLinkPrimitiveParams\n\tllGetLinkPrimitiveParams(${1:integer link}, ${2:list params})\nsnippet llGetListEntryType\n\tllGetListEntryType(${1:list src}, ${2:integer index})\nsnippet llGetListLength\n\tllGetListLength(${1:list src})\nsnippet llGetLocalPos\n\tllGetLocalPos()\nsnippet llGetLocalRot\n\tllGetLocalRot()\nsnippet llGetMass\n\tllGetMass()\nsnippet llGetMassMKS\n\tllGetMassMKS()\nsnippet llGetMaxScaleFactor\n\tllGetMaxScaleFactor()\nsnippet llGetMemoryLimit\n\tllGetMemoryLimit()\nsnippet llGetMinScaleFactor\n\tllGetMinScaleFactor()\nsnippet llGetNextEmail\n\tllGetNextEmail(${1:string address}, ${2:string subject});\n\t$0\nsnippet llGetNotecardLine\n\tllGetNotecardLine(${1:string name}, ${2:integer line})\nsnippet llGetNumberOfNotecardLines\n\tllGetNumberOfNotecardLines(${1:string name})\nsnippet llGetNumberOfPrims\n\tllGetNumberOfPrims()\nsnippet llGetNumberOfSides\n\tllGetNumberOfSides()\nsnippet llGetObjectDesc\n\tllGetObjectDesc()\nsnippet llGetObjectDetails\n\tllGetObjectDetails(${1:key id}, ${2:list params})\nsnippet llGetObjectMass\n\tllGetObjectMass(${1:key id})\nsnippet llGetObjectName\n\tllGetObjectName()\nsnippet llGetObjectPermMask\n\tllGetObjectPermMask(${1:integer mask})\nsnippet llGetObjectPrimCount\n\tllGetObjectPrimCount(${1:key prim})\nsnippet llGetOmega\n\tllGetOmega()\nsnippet llGetOwner\n\tllGetOwner()\nsnippet llGetOwnerKey\n\tllGetOwnerKey(${1:key id})\nsnippet llGetParcelDetails\n\tllGetParcelDetails(${1:vector pos}, ${2:list params})\nsnippet llGetParcelFlags\n\tllGetParcelFlags(${1:vector pos})\nsnippet llGetParcelMaxPrims\n\tllGetParcelMaxPrims(${1:vector pos}, ${2:integer sim_wide})\nsnippet llGetParcelMusicURL\n\tllGetParcelMusicURL()\nsnippet llGetParcelPrimCount\n\tllGetParcelPrimCount(${1:vector pos}, ${2:integer category}, ${3:integer sim_wide})\nsnippet llGetParcelPrimOwners\n\tllGetParcelPrimOwners(${1:vector pos})\nsnippet llGetPermissions\n\tllGetPermissions()\nsnippet llGetPermissionsKey\n\tllGetPermissionsKey()\nsnippet llGetPhysicsMaterial\n\tllGetPhysicsMaterial()\nsnippet llGetPos\n\tllGetPos()\nsnippet llGetPrimitiveParams\n\tllGetPrimitiveParams(${1:list params})\nsnippet llGetPrimMediaParams\n\tllGetPrimMediaParams(${1:integer face}, ${2:list params})\nsnippet llGetRegionAgentCount\n\tllGetRegionAgentCount()\nsnippet llGetRegionCorner\n\tllGetRegionCorner()\nsnippet llGetRegionFlags\n\tllGetRegionFlags()\nsnippet llGetRegionFPS\n\tllGetRegionFPS()\nsnippet llGetRegionName\n\tllGetRegionName()\nsnippet llGetRegionTimeDilation\n\tllGetRegionTimeDilation()\nsnippet llGetRootPosition\n\tllGetRootPosition()\nsnippet llGetRootRotation\n\tllGetRootRotation()\nsnippet llGetRot\n\tllGetRot()\nsnippet llGetScale\n\tllGetScale()\nsnippet llGetScriptName\n\tllGetScriptName()\nsnippet llGetScriptState\n\tllGetScriptState(${1:string script})\nsnippet llGetSimStats\n\tllGetSimStats(${1:integer stat_type})\nsnippet llGetSimulatorHostname\n\tllGetSimulatorHostname()\nsnippet llGetSPMaxMemory\n\tllGetSPMaxMemory()\nsnippet llGetStartParameter\n\tllGetStartParameter()\nsnippet llGetStaticPath\n\tllGetStaticPath(${1:vector start}, ${2:vector end}, ${3:float radius}, ${4:list params})\nsnippet llGetStatus\n\tllGetStatus(${1:integer status})\nsnippet llGetSubString\n\tllGetSubString(${1:string src}, ${2:integer start}, ${3:integer end})\nsnippet llGetSunDirection\n\tllGetSunDirection()\nsnippet llGetTexture\n\tllGetTexture(${1:integer face})\nsnippet llGetTextureOffset\n\tllGetTextureOffset(${1:integer face})\nsnippet llGetTextureRot\n\tllGetTextureRot(${1:integer face})\nsnippet llGetTextureScale\n\tllGetTextureScale(${1:integer face})\nsnippet llGetTime\n\tllGetTime()\nsnippet llGetTimeOfDay\n\tllGetTimeOfDay()\nsnippet llGetTimestamp\n\tllGetTimestamp()\nsnippet llGetTorque\n\tllGetTorque()\nsnippet llGetUnixTime\n\tllGetUnixTime()\nsnippet llGetUsedMemory\n\tllGetUsedMemory()\nsnippet llGetUsername\n\tllGetUsername(${1:key id})\nsnippet llGetVel\n\tllGetVel()\nsnippet llGetWallclock\n\tllGetWallclock()\nsnippet llGiveInventory\n\tllGiveInventory(${1:key destination}, ${2:string inventory});\n\t$0\nsnippet llGiveInventoryList\n\tllGiveInventoryList(${1:key target}, ${2:string folder}, ${3:list inventory});\n\t$0\nsnippet llGiveMoney\n\tllGiveMoney(${1:key destination}, ${2:integer amount})\nsnippet llGround\n\tllGround(${1:vector offset})\nsnippet llGroundContour\n\tllGroundContour(${1:vector offset})\nsnippet llGroundNormal\n\tllGroundNormal(${1:vector offset})\nsnippet llGroundRepel\n\tllGroundRepel(${1:float height}, ${2:integer water}, ${3:float tau});\n\t$0\nsnippet llGroundSlope\n\tllGroundSlope(${1:vector offset})\nsnippet llHTTPRequest\n\tllHTTPRequest(${1:string url}, ${2:list parameters}, ${3:string body})\nsnippet llHTTPResponse\n\tllHTTPResponse(${1:key request_id}, ${2:integer status}, ${3:string body});\n\t$0\nsnippet llInsertString\n\tllInsertString(${1:string dst}, ${2:integer pos}, ${3:string src})\nsnippet llInstantMessage\n\tllInstantMessage(${1:key user}, ${2:string message});\n\t$0\nsnippet llIntegerToBase64\n\tllIntegerToBase64(${1:integer number})\nsnippet llJson2List\n\tllJson2List(${1:string json})\nsnippet llJsonGetValue\n\tllJsonGetValue(${1:string json}, ${2:list specifiers})\nsnippet llJsonSetValue\n\tllJsonSetValue(${1:string json}, ${2:list specifiers}, ${3:string newValue})\nsnippet llJsonValueType\n\tllJsonValueType(${1:string json}, ${2:list specifiers})\nsnippet llKey2Name\n\tllKey2Name(${1:key id})\nsnippet llKeyCountKeyValue\n\tllKeyCountKeyValue()\nsnippet llKeysKeyValue\n\tllKeysKeyValue(${1:integer first}, ${2:integer count})\nsnippet llLinkParticleSystem\n\tllLinkParticleSystem(${1:integer link}, ${2:list rules});\n\t$0\nsnippet llLinkSitTarget\n\tllLinkSitTarget(${1:integer link}, ${2:vector offset}, ${3:rotation rot});\n\t$0\nsnippet llList2CSV\n\tllList2CSV(${1:list src})\nsnippet llList2Float\n\tllList2Float(${1:list src}, ${2:integer index})\nsnippet llList2Integer\n\tllList2Integer(${1:list src}, ${2:integer index})\nsnippet llList2Json\n\tllList2Json(${1:string type}, ${2:list values})\nsnippet llList2Key\n\tllList2Key(${1:list src}, ${2:integer index})\nsnippet llList2List\n\tllList2List(${1:list src}, ${2:integer start}, ${3:integer end})\nsnippet llList2ListStrided\n\tllList2ListStrided(${1:list src}, ${2:integer start}, ${3:integer end}, ${4:integer stride})\nsnippet llList2Rot\n\tllList2Rot(${1:list src}, ${2:integer index})\nsnippet llList2String\n\tllList2String(${1:list src}, ${2:integer index})\nsnippet llList2Vector\n\tllList2Vector(${1:list src}, ${2:integer index})\nsnippet llListen\n\tllListen(${1:integer channel}, ${2:string name}, ${3:key id}, ${4:string msg})\nsnippet llListenControl\n\tllListenControl(${1:integer handle}, ${2:integer active});\n\t$0\nsnippet llListenRemove\n\tllListenRemove(${1:integer handle});\n\t$0\nsnippet llListFindList\n\tllListFindList(${1:list src}, ${2:list test})\nsnippet llListInsertList\n\tllListInsertList(${1:list dest}, ${2:list src}, ${3:integer start})\nsnippet llListRandomize\n\tllListRandomize(${1:list src}, ${2:integer stride})\nsnippet llListReplaceList\n\tllListReplaceList(${1:list dest}, ${2:list src}, ${3:integer start}, ${4:integer end})\nsnippet llListSort\n\tllListSort(${1:list src}, ${2:integer stride}, ${3:integer ascending})\nsnippet llListStatistics\n\tllListStatistics(${1:integer operation}, ${2:list src})\nsnippet llLoadURL\n\tllLoadURL(${1:key agent}, ${2:string message}, ${3:string url});\n\t$0\nsnippet llLog\n\tllLog(${1:float val})\nsnippet llLog10\n\tllLog10(${1:float val})\nsnippet llLookAt\n\tllLookAt(${1:vector target}, ${2:float strength}, ${3:float damping});\n\t$0\nsnippet llLoopSound\n\tllLoopSound(${1:string sound}, ${2:float volume});\n\t$0\nsnippet llLoopSoundMaster\n\tllLoopSoundMaster(${1:string sound}, ${2:float volume});\n\t$0\nsnippet llLoopSoundSlave\n\tllLoopSoundSlave(${1:string sound}, ${2:float volume});\n\t$0\nsnippet llManageEstateAccess\n\tllManageEstateAccess(${1:integer action}, ${2:key agent})\nsnippet llMapDestination\n\tllMapDestination(${1:string simname}, ${2:vector pos}, ${3:vector look_at});\n\t$0\nsnippet llMD5String\n\tllMD5String(${1:string src}, ${2:integer nonce})\nsnippet llMessageLinked\n\tllMessageLinked(${1:integer link}, ${2:integer num}, ${3:string str}, ${4:key id});\n\t$0\nsnippet llMinEventDelay\n\tllMinEventDelay(${1:float delay});\n\t$0\nsnippet llModifyLand\n\tllModifyLand(${1:integer action}, ${2:integer brush});\n\t$0\nsnippet llModPow\n\tllModPow(${1:integer a}, ${2:integer b}, ${3:integer c})\nsnippet llMoveToTarget\n\tllMoveToTarget(${1:vector target}, ${2:float tau});\n\t$0\nsnippet llNavigateTo\n\tllNavigateTo(${1:vector pos}, ${2:list options});\n\t$0\nsnippet llOffsetTexture\n\tllOffsetTexture(${1:float u}, ${2:float v}, ${3:integer face});\n\t$0\nsnippet llOpenRemoteDataChannel\n\tllOpenRemoteDataChannel();\n\t$0\nsnippet llOverMyLand\n\tllOverMyLand(${1:key id})\nsnippet llOwnerSay\n\tllOwnerSay(${1:string msg});\n\t$0\nsnippet llParcelMediaCommandList\n\tllParcelMediaCommandList(${1:list commandList});\n\t$0\nsnippet llParcelMediaQuery\n\tllParcelMediaQuery(${1:list query})\nsnippet llParseString2List\n\tllParseString2List(${1:string src}, ${2:list separators}, ${3:list spacers})\nsnippet llParseStringKeepNulls\n\tllParseStringKeepNulls(${1:string src}, ${2:list separators}, ${3:list spacers})\nsnippet llParticleSystem\n\tllParticleSystem(${1:list rules});\n\t$0\nsnippet llPassCollisions\n\tllPassCollisions(${1:integer pass});\n\t$0\nsnippet llPassTouches\n\tllPassTouches(${1:integer pass});\n\t$0\nsnippet llPatrolPoints\n\tllPatrolPoints(${1:list patrolPoints}, ${2:list options});\n\t$0\nsnippet llPlaySound\n\tllPlaySound(${1:string sound}, ${2:float volume});\n\t$0\nsnippet llPlaySoundSlave\n\tllPlaySoundSlave(${1:string sound}, ${2:float volume});\n\t$0\nsnippet llPow\n\tllPow(${1:float base}, ${2:float exponent})\nsnippet llPreloadSound\n\tllPreloadSound(${1:string sound});\n\t$0\nsnippet llPursue\n\tllPursue(${1:key target}, ${2:list options});\n\t$0\nsnippet llPushObject\n\tllPushObject(${1:key target}, ${2:vector impulse}, ${3:vector ang_impulse}, ${4:integer local});\n\t$0\nsnippet llReadKeyValue\n\tllReadKeyValue(${1:string k})\nsnippet llRegionSay\n\tllRegionSay(${1:integer channel}, ${2:string msg});\n\t$0\nsnippet llRegionSayTo\n\tllRegionSayTo(${1:key target}, ${2:integer channel}, ${3:string msg});\n\t$0\nsnippet llReleaseControls\n\tllReleaseControls();\n\t$0\nsnippet llReleaseURL\n\tllReleaseURL(${1:string url});\n\t$0\nsnippet llRemoteDataReply\n\tllRemoteDataReply(${1:key channel}, ${2:key message_id}, ${3:string sdata}, ${4:integer idata});\n\t$0\nsnippet llRemoteLoadScriptPin\n\tllRemoteLoadScriptPin(${1:key target}, ${2:string name}, ${3:integer pin}, ${4:integer running}, ${5:integer start_param});\n\t$0\nsnippet llRemoveFromLandBanList\n\tllRemoveFromLandBanList(${1:key agent});\n\t$0\nsnippet llRemoveFromLandPassList\n\tllRemoveFromLandPassList(${1:key agent});\n\t$0\nsnippet llRemoveInventory\n\tllRemoveInventory(${1:string item});\n\t$0\nsnippet llRemoveVehicleFlags\n\tllRemoveVehicleFlags(${1:integer flags});\n\t$0\nsnippet llRequestAgentData\n\tllRequestAgentData(${1:key id}, ${2:integer data})\nsnippet llRequestDisplayName\n\tllRequestDisplayName(${1:key id})\nsnippet llRequestExperiencePermissions\n\tllRequestExperiencePermissions(${1:key agent}, ${2:string name})\nsnippet llRequestInventoryData\n\tllRequestInventoryData(${1:string name})\nsnippet llRequestPermissions\n\tllRequestPermissions(${1:key agent}, ${2:integer permissions})\nsnippet llRequestSecureURL\n\tllRequestSecureURL()\nsnippet llRequestSimulatorData\n\tllRequestSimulatorData(${1:string region}, ${2:integer data})\nsnippet llRequestURL\n\tllRequestURL()\nsnippet llRequestUsername\n\tllRequestUsername(${1:key id})\nsnippet llResetAnimationOverride\n\tllResetAnimationOverride(${1:string anim_state});\n\t$0\nsnippet llResetLandBanList\n\tllResetLandBanList();\n\t$0\nsnippet llResetLandPassList\n\tllResetLandPassList();\n\t$0\nsnippet llResetOtherScript\n\tllResetOtherScript(${1:string name});\n\t$0\nsnippet llResetScript\n\tllResetScript();\n\t$0\nsnippet llResetTime\n\tllResetTime();\n\t$0\nsnippet llReturnObjectsByID\n\tllReturnObjectsByID(${1:list objects})\nsnippet llReturnObjectsByOwner\n\tllReturnObjectsByOwner(${1:key owner}, ${2:integer scope})\nsnippet llRezAtRoot\n\tllRezAtRoot(${1:string inventory}, ${2:vector position}, ${3:vector velocity}, ${4:rotation rot}, ${5:integer param});\n\t$0\nsnippet llRezObject\n\tllRezObject(${1:string inventory}, ${2:vector pos}, ${3:vector vel}, ${4:rotation rot}, ${5:integer param});\n\t$0\nsnippet llRot2Angle\n\tllRot2Angle(${1:rotation rot})\nsnippet llRot2Axis\n\tllRot2Axis(${1:rotation rot})\nsnippet llRot2Euler\n\tllRot2Euler(${1:rotation quat})\nsnippet llRot2Fwd\n\tllRot2Fwd(${1:rotation q})\nsnippet llRot2Left\n\tllRot2Left(${1:rotation q})\nsnippet llRot2Up\n\tllRot2Up(${1:rotation q})\nsnippet llRotateTexture\n\tllRotateTexture(${1:float angle}, ${2:integer face});\n\t$0\nsnippet llRotBetween\n\tllRotBetween(${1:vector start}, ${2:vector end})\nsnippet llRotLookAt\n\tllRotLookAt(${1:rotation target_direction}, ${2:float strength}, ${3:float damping});\n\t$0\nsnippet llRotTarget\n\tllRotTarget(${1:rotation rot}, ${2:float error})\nsnippet llRotTargetRemove\n\tllRotTargetRemove(${1:integer handle});\n\t$0\nsnippet llRound\n\tllRound(${1:float val})\nsnippet llSameGroup\n\tllSameGroup(${1:key group})\nsnippet llSay\n\tllSay(${1:integer channel}, ${2:string msg});\n\t$0\nsnippet llScaleByFactor\n\tllScaleByFactor(${1:float scaling_factor})\nsnippet llScaleTexture\n\tllScaleTexture(${1:float u}, ${2:float v}, ${3:integer face});\n\t$0\nsnippet llScriptDanger\n\tllScriptDanger(${1:vector pos})\nsnippet llScriptProfiler\n\tllScriptProfiler(${1:integer flags});\n\t$0\nsnippet llSendRemoteData\n\tllSendRemoteData(${1:key channel}, ${2:string dest}, ${3:integer idata}, ${4:string sdata})\nsnippet llSensor\n\tllSensor(${1:string name}, ${2:key id}, ${3:integer type}, ${4:float range}, ${5:float arc});\n\t$0\nsnippet llSensorRepeat\n\tllSensorRepeat(${1:string name}, ${2:key id}, ${3:integer type}, ${4:float range}, ${5:float arc}, ${6:float rate});\n\t$0\nsnippet llSetAlpha\n\tllSetAlpha(${1:float alpha}, ${2:integer face});\n\t$0\nsnippet llSetAngularVelocity\n\tllSetAngularVelocity(${1:vector force}, ${2:integer local});\n\t$0\nsnippet llSetAnimationOverride\n\tllSetAnimationOverride(${1:string anim_state}, ${2:string anim})\nsnippet llSetBuoyancy\n\tllSetBuoyancy(${1:float buoyancy});\n\t$0\nsnippet llSetCameraAtOffset\n\tllSetCameraAtOffset(${1:vector offset});\n\t$0\nsnippet llSetCameraEyeOffset\n\tllSetCameraEyeOffset(${1:vector offset});\n\t$0\nsnippet llSetCameraParams\n\tllSetCameraParams(${1:list rules});\n\t$0\nsnippet llSetClickAction\n\tllSetClickAction(${1:integer action});\n\t$0\nsnippet llSetColor\n\tllSetColor(${1:vector color}, ${2:integer face});\n\t$0\nsnippet llSetContentType\n\tllSetContentType(${1:key request_id}, ${2:integer content_type});\n\t$0\nsnippet llSetDamage\n\tllSetDamage(${1:float damage});\n\t$0\nsnippet llSetForce\n\tllSetForce(${1:vector force}, ${2:integer local});\n\t$0\nsnippet llSetForceAndTorque\n\tllSetForceAndTorque(${1:vector force}, ${2:vector torque}, ${3:integer local});\n\t$0\nsnippet llSetHoverHeight\n\tllSetHoverHeight(${1:float height}, ${2:integer water}, ${3:float tau});\n\t$0\nsnippet llSetKeyframedMotion\n\tllSetKeyframedMotion(${1:list keyframes}, ${2:list options});\n\t$0\nsnippet llSetLinkAlpha\n\tllSetLinkAlpha(${1:integer link}, ${2:float alpha}, ${3:integer face});\n\t$0\nsnippet llSetLinkCamera\n\tllSetLinkCamera(${1:integer link}, ${2:vector eye}, ${3:vector at});\n\t$0\nsnippet llSetLinkColor\n\tllSetLinkColor(${1:integer link}, ${2:vector color}, ${3:integer face});\n\t$0\nsnippet llSetLinkMedia\n\tllSetLinkMedia(${1:integer link}, ${2:integer face}, ${3:list params});\n\t$0\nsnippet llSetLinkPrimitiveParams\n\tllSetLinkPrimitiveParams(${1:integer link}, ${2:list rules});\n\t$0\nsnippet llSetLinkPrimitiveParamsFast\n\tllSetLinkPrimitiveParamsFast(${1:integer link}, ${2:list rules});\n\t$0\nsnippet llSetLinkTexture\n\tllSetLinkTexture(${1:integer link}, ${2:string texture}, ${3:integer face});\n\t$0\nsnippet llSetLinkTextureAnim\n\tllSetLinkTextureAnim(${1:integer link}, ${2:integer mode}, ${3:integer face}, ${4:integer sizex}, ${5:integer sizey}, ${6:float start}, ${7:float length}, ${8:float rate});\n\t$0\nsnippet llSetLocalRot\n\tllSetLocalRot(${1:rotation rot});\n\t$0\nsnippet llSetMemoryLimit\n\tllSetMemoryLimit(${1:integer limit})\nsnippet llSetObjectDesc\n\tllSetObjectDesc(${1:string description});\n\t$0\nsnippet llSetObjectName\n\tllSetObjectName(${1:string name});\n\t$0\nsnippet llSetParcelMusicURL\n\tllSetParcelMusicURL(${1:string url});\n\t$0\nsnippet llSetPayPrice\n\tllSetPayPrice(${1:integer price}, [${2:integer price_button_a}, ${3:integer price_button_b}, ${4:integer price_button_c}, ${5:integer price_button_d}]);\n\t$0\nsnippet llSetPhysicsMaterial\n\tllSetPhysicsMaterial(${1:integer mask}, ${2:float gravity_multiplier}, ${3:float restitution}, ${4:float friction}, ${5:float density});\n\t$0\nsnippet llSetPos\n\tllSetPos(${1:vector pos});\n\t$0\nsnippet llSetPrimitiveParams\n\tllSetPrimitiveParams(${1:list rules});\n\t$0\nsnippet llSetPrimMediaParams\n\tllSetPrimMediaParams(${1:integer face}, ${2:list params});\n\t$0\nsnippet llSetRegionPos\n\tllSetRegionPos(${1:vector position})\nsnippet llSetRemoteScriptAccessPin\n\tllSetRemoteScriptAccessPin(${1:integer pin});\n\t$0\nsnippet llSetRot\n\tllSetRot(${1:rotation rot});\n\t$0\nsnippet llSetScale\n\tllSetScale(${1:vector size});\n\t$0\nsnippet llSetScriptState\n\tllSetScriptState(${1:string name}, ${2:integer run});\n\t$0\nsnippet llSetSitText\n\tllSetSitText(${1:string text});\n\t$0\nsnippet llSetSoundQueueing\n\tllSetSoundQueueing(${1:integer queue});\n\t$0\nsnippet llSetSoundRadius\n\tllSetSoundRadius(${1:float radius});\n\t$0\nsnippet llSetStatus\n\tllSetStatus(${1:integer status}, ${2:integer value});\n\t$0\nsnippet llSetText\n\tllSetText(${1:string text}, ${2:vector color}, ${3:float alpha});\n\t$0\nsnippet llSetTexture\n\tllSetTexture(${1:string texture}, ${2:integer face});\n\t$0\nsnippet llSetTextureAnim\n\tllSetTextureAnim(${1:integer mode}, ${2:integer face}, ${3:integer sizex}, ${4:integer sizey}, ${5:float start}, ${6:float length}, ${7:float rate});\n\t$0\nsnippet llSetTimerEvent\n\tllSetTimerEvent(${1:float sec});\n\t$0\nsnippet llSetTorque\n\tllSetTorque(${1:vector torque}, ${2:integer local});\n\t$0\nsnippet llSetTouchText\n\tllSetTouchText(${1:string text});\n\t$0\nsnippet llSetVehicleFlags\n\tllSetVehicleFlags(${1:integer flags});\n\t$0\nsnippet llSetVehicleFloatParam\n\tllSetVehicleFloatParam(${1:integer param}, ${2:float value});\n\t$0\nsnippet llSetVehicleRotationParam\n\tllSetVehicleRotationParam(${1:integer param}, ${2:rotation rot});\n\t$0\nsnippet llSetVehicleType\n\tllSetVehicleType(${1:integer type});\n\t$0\nsnippet llSetVehicleVectorParam\n\tllSetVehicleVectorParam(${1:integer param}, ${2:vector vec});\n\t$0\nsnippet llSetVelocity\n\tllSetVelocity(${1:vector force}, ${2:integer local});\n\t$0\nsnippet llSHA1String\n\tllSHA1String(${1:string src})\nsnippet llShout\n\tllShout(${1:integer channel}, ${2:string msg});\n\t$0\nsnippet llSin\n\tllSin(${1:float theta})\nsnippet llSitTarget\n\tllSitTarget(${1:vector offset}, ${2:rotation rot});\n\t$0\nsnippet llSleep\n\tllSleep(${1:float sec});\n\t$0\nsnippet llSqrt\n\tllSqrt(${1:float val})\nsnippet llStartAnimation\n\tllStartAnimation(${1:string anim});\n\t$0\nsnippet llStopAnimation\n\tllStopAnimation(${1:string anim});\n\t$0\nsnippet llStopHover\n\tllStopHover();\n\t$0\nsnippet llStopLookAt\n\tllStopLookAt();\n\t$0\nsnippet llStopMoveToTarget\n\tllStopMoveToTarget();\n\t$0\nsnippet llStopSound\n\tllStopSound();\n\t$0\nsnippet llStringLength\n\tllStringLength(${1:string str})\nsnippet llStringToBase64\n\tllStringToBase64(${1:string str})\nsnippet llStringTrim\n\tllStringTrim(${1:string src}, ${2:integer type})\nsnippet llSubStringIndex\n\tllSubStringIndex(${1:string source}, ${2:string pattern})\nsnippet llTakeControls\n\tllTakeControls(${1:integer controls}, ${2:integer accept}, ${3:integer pass_on});\n\t$0\nsnippet llTan\n\tllTan(${1:float theta})\nsnippet llTarget\n\tllTarget(${1:vector position}, ${2:float range})\nsnippet llTargetOmega\n\tllTargetOmega(${1:vector axis}, ${2:float spinrate}, ${3:float gain});\n\t$0\nsnippet llTargetRemove\n\tllTargetRemove(${1:integer handle});\n\t$0\nsnippet llTeleportAgent\n\tllTeleportAgent(${1:key agent}, ${2:string landmark}, ${3:vector position}, ${4:vector look_at});\n\t$0\nsnippet llTeleportAgentGlobalCoords\n\tllTeleportAgentGlobalCoords(${1:key agent}, ${2:vector global_coordinates}, ${3:vector region_coordinates}, ${4:vector look_at});\n\t$0\nsnippet llTeleportAgentHome\n\tllTeleportAgentHome(${1:key agent});\n\t$0\nsnippet llTextBox\n\tllTextBox(${1:key agent}, ${2:string message}, ${3:integer channel});\n\t$0\nsnippet llToLower\n\tllToLower(${1:string src})\nsnippet llToUpper\n\tllToUpper(${1:string src})\nsnippet llTransferLindenDollars\n\tllTransferLindenDollars(${1:key destination}, ${2:integer amount})\nsnippet llTriggerSound\n\tllTriggerSound(${1:string sound}, ${2:float volume});\n\t$0\nsnippet llTriggerSoundLimited\n\tllTriggerSoundLimited(${1:string sound}, ${2:float volume}, ${3:vector top_north_east}, ${4:vector bottom_south_west});\n\t$0\nsnippet llUnescapeURL\n\tllUnescapeURL(${1:string url})\nsnippet llUnSit\n\tllUnSit(${1:key id});\n\t$0\nsnippet llUpdateCharacter\n\tllUpdateCharacter(${1:list options})\nsnippet llUpdateKeyValue\n\tllUpdateKeyValue(${1:string k}, ${2:string v}, ${3:integer checked}, ${4:string ov})\nsnippet llVecDist\n\tllVecDist(${1:vector vec_a}, ${2:vector vec_b})\nsnippet llVecMag\n\tllVecMag(${1:vector vec})\nsnippet llVecNorm\n\tllVecNorm(${1:vector vec})\nsnippet llVolumeDetect\n\tllVolumeDetect(${1:integer detect});\n\t$0\nsnippet llWanderWithin\n\tllWanderWithin(${1:vector origin}, ${2:vector dist}, ${3:list options});\n\t$0\nsnippet llWater\n\tllWater(${1:vector offset});\n\t$0\nsnippet llWhisper\n\tllWhisper(${1:integer channel}, ${2:string msg});\n\t$0\nsnippet llWind\n\tllWind(${1:vector offset});\n\t$0\nsnippet llXorBase64\n\tllXorBase64(${1:string str1}, ${2:string str2})\nsnippet money\n\tmoney(${1:key id}, ${2:integer amount})\n\t{\n\t\t$0\n\t}\nsnippet object_rez\n\tobject_rez(${1:key id})\n\t{\n\t\t$0\n\t}\nsnippet on_rez\n\ton_rez(${1:integer start_param})\n\t{\n\t\t$0\n\t}\nsnippet path_update\n\tpath_update(${1:integer type}, ${2:list reserved})\n\t{\n\t\t$0\n\t}\nsnippet remote_data\n\tremote_data(${1:integer event_type}, ${2:key channel}, ${3:key message_id}, ${4:string sender}, ${5:integer idata}, ${6:string sdata})\n\t{\n\t\t$0\n\t}\nsnippet run_time_permissions\n\trun_time_permissions(${1:integer perm})\n\t{\n\t\t$0\n\t}\nsnippet sensor\n\tsensor(${1:integer index})\n\t{\n\t\t$0\n\t}\nsnippet state\n\tstate ${1:name}\nsnippet touch\n\ttouch(${1:integer index})\n\t{\n\t\t$0\n\t}\nsnippet touch_end\n\ttouch_end(${1:integer index})\n\t{\n\t\t$0\n\t}\nsnippet touch_start\n\ttouch_start(${1:integer index})\n\t{\n\t\t$0\n\t}\nsnippet transaction_result\n\ttransaction_result(${1:key id}, ${2:integer success}, ${3:string data})\n\t{\n\t\t$0\n\t}\nsnippet while\n\twhile (${1:condition})\n\t{\n\t\t$0\n\t}\n";

});

define("ace/snippets/lsl",["require","exports","module","ace/snippets/lsl.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./lsl.snippets");
exports.scope = "lsl";

});

define("ace/snippets/lua.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet #!\n\t#!/usr/bin/env lua\n\t$1\nsnippet local\n\tlocal ${1:x} = ${2:1}\nsnippet fun\n\tfunction ${1:fname}(${2:...})\n\t\t${3:-- body}\n\tend\nsnippet for\n\tfor ${1:i}=${2:1},${3:10} do\n\t\t${4:print(i)}\n\tend\nsnippet forp\n\tfor ${1:i},${2:v} in pairs(${3:table_name}) do\n\t   ${4:-- body}\n\tend\nsnippet fori\n\tfor ${1:i},${2:v} in ipairs(${3:table_name}) do\n\t   ${4:-- body}\n\tend\n";

});

define("ace/snippets/lua",["require","exports","module","ace/snippets/lua.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./lua.snippets");
exports.scope = "lua";

});

define("ace/snippets/makefile.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet ifeq\n\tifeq (${1:cond0},${2:cond1})\n\t\t${3:code}\n\tendif\n";

});

define("ace/snippets/makefile",["require","exports","module","ace/snippets/makefile.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./makefile.snippets");
exports.scope = "makefile";

});

define("ace/snippets/markdown.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# Markdown\n\n# Includes octopress (http://octopress.org/) snippets\n\nsnippet [\n\t[${1:text}](http://${2:address} \"${3:title}\")\nsnippet [*\n\t[${1:link}](${2:`@*`} \"${3:title}\")${4}\n\nsnippet [:\n\t[${1:id}]: http://${2:url} \"${3:title}\"\nsnippet [:*\n\t[${1:id}]: ${2:`@*`} \"${3:title}\"\n\nsnippet ![\n\t![${1:alttext}](${2:/images/image.jpg} \"${3:title}\")\nsnippet ![*\n\t![${1:alt}](${2:`@*`} \"${3:title}\")${4}\n\nsnippet ![:\n\t![${1:id}]: ${2:url} \"${3:title}\"\nsnippet ![:*\n\t![${1:id}]: ${2:`@*`} \"${3:title}\"\n\nsnippet ===\nregex /^/=+/=*//\n\t${PREV_LINE/./=/g}\n\t\n\t${0}\nsnippet ---\nregex /^/-+/-*//\n\t${PREV_LINE/./-/g}\n\t\n\t${0}\nsnippet blockquote\n\t{% blockquote %}\n\t${1:quote}\n\t{% endblockquote %}\n\nsnippet blockquote-author\n\t{% blockquote ${1:author}, ${2:title} %}\n\t${3:quote}\n\t{% endblockquote %}\n\nsnippet blockquote-link\n\t{% blockquote ${1:author} ${2:URL} ${3:link_text} %}\n\t${4:quote}\n\t{% endblockquote %}\n\nsnippet bt-codeblock-short\n\t```\n\t${1:code_snippet}\n\t```\n\nsnippet bt-codeblock-full\n\t``` ${1:language} ${2:title} ${3:URL} ${4:link_text}\n\t${5:code_snippet}\n\t```\n\nsnippet codeblock-short\n\t{% codeblock %}\n\t${1:code_snippet}\n\t{% endcodeblock %}\n\nsnippet codeblock-full\n\t{% codeblock ${1:title} lang:${2:language} ${3:URL} ${4:link_text} %}\n\t${5:code_snippet}\n\t{% endcodeblock %}\n\nsnippet gist-full\n\t{% gist ${1:gist_id} ${2:filename} %}\n\nsnippet gist-short\n\t{% gist ${1:gist_id} %}\n\nsnippet img\n\t{% img ${1:class} ${2:URL} ${3:width} ${4:height} ${5:title_text} ${6:alt_text} %}\n\nsnippet youtube\n\t{% youtube ${1:video_id} %}\n\n# The quote should appear only once in the text. It is inherently part of it.\n# See http://octopress.org/docs/plugins/pullquote/ for more info.\n\nsnippet pullquote\n\t{% pullquote %}\n\t${1:text} {\" ${2:quote} \"} ${3:text}\n\t{% endpullquote %}\n";

});

define("ace/snippets/markdown",["require","exports","module","ace/snippets/markdown.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./markdown.snippets");
exports.scope = "markdown";

});

define("ace/snippets/maze.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet >\ndescription assignment\nscope maze\n\t-> ${1}= ${2}\n\nsnippet >\ndescription if\nscope maze\n\t-> IF ${2:**} THEN %${3:L} ELSE %${4:R}\n";

});

define("ace/snippets/maze",["require","exports","module","ace/snippets/maze.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./maze.snippets");
exports.scope = "maze";

});

define("ace/snippets/perl.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# #!/usr/bin/perl\nsnippet #!\n\t#!/usr/bin/env perl\n\n# Hash Pointer\nsnippet .\n\t =>\n# Function\nsnippet sub\n\tsub ${1:function_name} {\n\t\t${2:#body ...}\n\t}\n# Conditional\nsnippet if\n\tif (${1}) {\n\t\t${2:# body...}\n\t}\n# Conditional if..else\nsnippet ife\n\tif (${1}) {\n\t\t${2:# body...}\n\t}\n\telse {\n\t\t${3:# else...}\n\t}\n# Conditional if..elsif..else\nsnippet ifee\n\tif (${1}) {\n\t\t${2:# body...}\n\t}\n\telsif (${3}) {\n\t\t${4:# elsif...}\n\t}\n\telse {\n\t\t${5:# else...}\n\t}\n# Conditional One-line\nsnippet xif\n\t${1:expression} if ${2:condition};${3}\n# Unless conditional\nsnippet unless\n\tunless (${1}) {\n\t\t${2:# body...}\n\t}\n# Unless conditional One-line\nsnippet xunless\n\t${1:expression} unless ${2:condition};${3}\n# Try/Except\nsnippet eval\n\tlocal $@;\n\teval {\n\t\t${1:# do something risky...}\n\t};\n\tif (my $e = $@) {\n\t\t${2:# handle failure...}\n\t}\n# While Loop\nsnippet wh\n\twhile (${1}) {\n\t\t${2:# body...}\n\t}\n# While Loop One-line\nsnippet xwh\n\t${1:expression} while ${2:condition};${3}\n# C-style For Loop\nsnippet cfor\n\tfor (my $${2:var} = 0; $$2 < ${1:count}; $$2${3:++}) {\n\t\t${4:# body...}\n\t}\n# For loop one-line\nsnippet xfor\n\t${1:expression} for @${2:array};${3}\n# Foreach Loop\nsnippet for\n\tforeach my $${1:x} (@${2:array}) {\n\t\t${3:# body...}\n\t}\n# Foreach Loop One-line\nsnippet fore\n\t${1:expression} foreach @${2:array};${3}\n# Package\nsnippet package\n\tpackage ${1:`substitute(Filename('', 'Page Title'), '^.', '\\u&', '')`};\n\n\t${2}\n\n\t1;\n\n\t__END__\n# Package syntax perl >= 5.14\nsnippet packagev514\n\tpackage ${1:`substitute(Filename('', 'Page Title'), '^.', '\\u&', '')`} ${2:0.99};\n\n\t${3}\n\n\t1;\n\n\t__END__\n#moose\nsnippet moose\n\tuse Moose;\n\tuse namespace::autoclean;\n\t${1:#}BEGIN {extends '${2:ParentClass}'};\n\n\t${3}\n# parent\nsnippet parent\n\tuse parent qw(${1:Parent Class});\n# Read File\nsnippet slurp\n\tmy $${1:var} = do { local $/; open my $file, '<', \"${2:file}\"; <$file> };\n\t${3}\n# strict warnings\nsnippet strwar\n\tuse strict;\n\tuse warnings;\n# older versioning with perlcritic bypass\nsnippet vers\n\t## no critic\n\tour $VERSION = '${1:version}';\n\teval $VERSION;\n\t## use critic\n# new 'switch' like feature\nsnippet switch\n\tuse feature 'switch';\n\n# Anonymous subroutine\nsnippet asub\n\tsub {\n\t \t${1:# body }\n\t}\n\n\n\n# Begin block\nsnippet begin\n\tBEGIN {\n\t\t${1:# begin body}\n\t}\n\n# call package function with some parameter\nsnippet pkgmv\n\t__PACKAGE__->${1:package_method}(${2:var})\n\n# call package function without a parameter\nsnippet pkgm\n\t__PACKAGE__->${1:package_method}()\n\n# call package \"get_\" function without a parameter\nsnippet pkget\n\t__PACKAGE__->get_${1:package_method}()\n\n# call package function with a parameter\nsnippet pkgetv\n\t__PACKAGE__->get_${1:package_method}(${2:var})\n\n# complex regex\nsnippet qrx\n\tqr/\n\t     ${1:regex}\n\t/xms\n\n#simpler regex\nsnippet qr/\n\tqr/${1:regex}/x\n\n#given\nsnippet given\n\tgiven ($${1:var}) {\n\t\t${2:# cases}\n\t\t${3:# default}\n\t}\n\n# switch-like case\nsnippet when\n\twhen (${1:case}) {\n\t\t${2:# body}\n\t}\n\n# hash slice\nsnippet hslice\n\t@{ ${1:hash}  }{ ${2:array} }\n\n\n# map\nsnippet map\n\tmap {  ${2: body }    }  ${1: @array } ;\n\n\n\n# Pod stub\nsnippet ppod\n\t=head1 NAME\n\n\t${1:ClassName} - ${2:ShortDesc}\n\n\t=head1 SYNOPSIS\n\n\t  use $1;\n\n\t  ${3:# synopsis...}\n\n\t=head1 DESCRIPTION\n\n\t${4:# longer description...}\n\n\n\t=head1 INTERFACE\n\n\n\t=head1 DEPENDENCIES\n\n\n\t=head1 SEE ALSO\n\n\n# Heading for a subroutine stub\nsnippet psub\n\t=head2 ${1:MethodName}\n\n\t${2:Summary....}\n\n# Heading for inline subroutine pod\nsnippet psubi\n\t=head2 ${1:MethodName}\n\n\t${2:Summary...}\n\n\n\t=cut\n# inline documented subroutine\nsnippet subpod\n\t=head2 $1\n\n\tSummary of $1\n\n\t=cut\n\n\tsub ${1:subroutine_name} {\n\t\t${2:# body...}\n\t}\n# Subroutine signature\nsnippet parg\n\t=over 2\n\n\t=item\n\tArguments\n\n\n\t=over 3\n\n\t=item\n\tC<${1:DataStructure}>\n\n\t  ${2:Sample}\n\n\n\t=back\n\n\n\t=item\n\tReturn\n\n\t=over 3\n\n\n\t=item\n\tC<${3:...return data}>\n\n\n\t=back\n\n\n\t=back\n\n\n\n# Moose has\nsnippet has\n\thas ${1:attribute} => (\n\t\tis\t    => '${2:ro|rw}',\n\t\tisa \t=> '${3:Str|Int|HashRef|ArrayRef|etc}',\n\t\tdefault => sub {\n\t\t\t${4:defaultvalue}\n\t\t},\n\t\t${5:# other attributes}\n\t);\n\n\n# override\nsnippet override\n\toverride ${1:attribute} => sub {\n\t\t${2:# my $self = shift;};\n\t\t${3:# my ($self, $args) = @_;};\n\t};\n\n\n# use test classes\nsnippet tuse\n\tuse Test::More;\n\tuse Test::Deep; # (); # uncomment to stop prototype errors\n\tuse Test::Exception;\n\n# local test lib\nsnippet tlib\n\tuse lib qw{ ./t/lib };\n\n#test methods\nsnippet tmeths\n\t$ENV{TEST_METHOD} = '${1:regex}';\n\n# runtestclass\nsnippet trunner\n\tuse ${1:test_class};\n\t$1->runtests();\n\n# Test::Class-style test\nsnippet tsub\n\tsub t${1:number}_${2:test_case} :Test(${3:num_of_tests}) {\n\t\tmy $self = shift;\n\t\t${4:#  body}\n\n\t}\n\n# Test::Routine-style test\nsnippet trsub\n\ttest ${1:test_name} => { description => '${2:Description of test.}'} => sub {\n\t\tmy ($self) = @_;\n\t\t${3:# test code}\n\t};\n\n#prep test method\nsnippet tprep\n\tsub prep${1:number}_${2:test_case} :Test(startup) {\n\t\tmy $self = shift;\n\t\t${4:#  body}\n\t}\n\n# cause failures to print stack trace\nsnippet debug_trace\n\tuse Carp; # 'verbose';\n\t# cloak \"die\"\n\t# warn \"warning\"\n\t$SIG{'__DIE__'} = sub {\n\t\trequire Carp; Carp::confess\n\t};\n\n";

});

define("ace/snippets/perl",["require","exports","module","ace/snippets/perl.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./perl.snippets");
exports.scope = "perl";

});

define("ace/snippets/php.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet ec\n\techo ${1};\nsnippet ns\n\tnamespace ${1:Foo\\Bar\\Baz};\n\t${2}\nsnippet use\n\tuse ${1:Foo\\Bar\\Baz};\n\t${2}\nsnippet c\n\t${1:abstract }class ${2:$FILENAME}\n\t{\n\t\t${3}\n\t}\nsnippet i\n\tinterface ${1:$FILENAME}\n\t{\n\t\t${2}\n\t}\nsnippet t.\n\t$this->${1}\nsnippet f\n\tfunction ${1:foo}(${2:array }${3:$bar})\n\t{\n\t\t${4}\n\t}\n# method\nsnippet m\n\t${1:abstract }${2:protected}${3: static} function ${4:foo}(${5:array }${6:$bar})\n\t{\n\t\t${7}\n\t}\n# setter method\nsnippet sm\n\t/**\n\t * Sets the value of ${1:foo}\n\t *\n\t * @param ${2:$1} $$1 ${3:description}\n\t *\n\t * @return ${4:$FILENAME}\n\t */\n\t${5:public} function set${6:$2}(${7:$2 }$$1)\n\t{\n\t\t$this->${8:$1} = $$1;\n\t\treturn $this;\n\t}${9}\n# getter method\nsnippet gm\n\t/**\n\t * Gets the value of ${1:foo}\n\t *\n\t * @return ${2:$1}\n\t */\n\t${3:public} function get${4:$2}()\n\t{\n\t\treturn $this->${5:$1};\n\t}${6}\n#setter\nsnippet $s\n\t${1:$foo}->set${2:Bar}(${3});\n#getter\nsnippet $g\n\t${1:$foo}->get${2:Bar}();\n\n# Tertiary conditional\nsnippet =?:\n\t$${1:foo} = ${2:true} ? ${3:a} : ${4};\nsnippet ?:\n\t${1:true} ? ${2:a} : ${3}\n\nsnippet C\n\t$_COOKIE['${1:variable}']${2}\nsnippet E\n\t$_ENV['${1:variable}']${2}\nsnippet F\n\t$_FILES['${1:variable}']${2}\nsnippet G\n\t$_GET['${1:variable}']${2}\nsnippet P\n\t$_POST['${1:variable}']${2}\nsnippet R\n\t$_REQUEST['${1:variable}']${2}\nsnippet S\n\t$_SERVER['${1:variable}']${2}\nsnippet SS\n\t$_SESSION['${1:variable}']${2}\n\n# the following are old ones\nsnippet inc\n\tinclude '${1:file}';${2}\nsnippet inc1\n\tinclude_once '${1:file}';${2}\nsnippet req\n\trequire '${1:file}';${2}\nsnippet req1\n\trequire_once '${1:file}';${2}\n# Start Docblock\nsnippet /*\n\t/**\n\t * ${1}\n\t */\n# Class - post doc\nsnippet doc_cp\n\t/**\n\t * ${1:undocumented class}\n\t *\n\t * @package ${2:default}\n\t * @subpackage ${3:default}\n\t * @author ${4:`g:snips_author`}\n\t */${5}\n# Class Variable - post doc\nsnippet doc_vp\n\t/**\n\t * ${1:undocumented class variable}\n\t *\n\t * @var ${2:string}\n\t */${3}\n# Class Variable\nsnippet doc_v\n\t/**\n\t * ${3:undocumented class variable}\n\t *\n\t * @var ${4:string}\n\t */\n\t${1:var} $${2};${5}\n# Class\nsnippet doc_c\n\t/**\n\t * ${3:undocumented class}\n\t *\n\t * @package ${4:default}\n\t * @subpackage ${5:default}\n\t * @author ${6:`g:snips_author`}\n\t */\n\t${1:}class ${2:}\n\t{\n\t\t${7}\n\t} // END $1class $2\n# Constant Definition - post doc\nsnippet doc_dp\n\t/**\n\t * ${1:undocumented constant}\n\t */${2}\n# Constant Definition\nsnippet doc_d\n\t/**\n\t * ${3:undocumented constant}\n\t */\n\tdefine(${1}, ${2});${4}\n# Function - post doc\nsnippet doc_fp\n\t/**\n\t * ${1:undocumented function}\n\t *\n\t * @return ${2:void}\n\t * @author ${3:`g:snips_author`}\n\t */${4}\n# Function signature\nsnippet doc_s\n\t/**\n\t * ${4:undocumented function}\n\t *\n\t * @return ${5:void}\n\t * @author ${6:`g:snips_author`}\n\t */\n\t${1}function ${2}(${3});${7}\n# Function\nsnippet doc_f\n\t/**\n\t * ${4:undocumented function}\n\t *\n\t * @return ${5:void}\n\t * @author ${6:`g:snips_author`}\n\t */\n\t${1}function ${2}(${3})\n\t{${7}\n\t}\n# Header\nsnippet doc_h\n\t/**\n\t * ${1}\n\t *\n\t * @author ${2:`g:snips_author`}\n\t * @version ${3:$Id$}\n\t * @copyright ${4:$2}, `strftime('%d %B, %Y')`\n\t * @package ${5:default}\n\t */\n\n# Interface\nsnippet interface\n\t/**\n\t * ${2:undocumented class}\n\t *\n\t * @package ${3:default}\n\t * @author ${4:`g:snips_author`}\n\t */\n\tinterface ${1:$FILENAME}\n\t{\n\t\t${5}\n\t}\n# class ...\nsnippet class\n\t/**\n\t * ${1}\n\t */\n\tclass ${2:$FILENAME}\n\t{\n\t\t${3}\n\t\t/**\n\t\t * ${4}\n\t\t */\n\t\t${5:public} function ${6:__construct}(${7:argument})\n\t\t{\n\t\t\t${8:// code...}\n\t\t}\n\t}\n# define(...)\nsnippet def\n\tdefine('${1}'${2});${3}\n# defined(...)\nsnippet def?\n\t${1}defined('${2}')${3}\nsnippet wh\n\twhile (${1:/* condition */}) {\n\t\t${2:// code...}\n\t}\n# do ... while\nsnippet do\n\tdo {\n\t\t${2:// code... }\n\t} while (${1:/* condition */});\nsnippet if\n\tif (${1:/* condition */}) {\n\t\t${2:// code...}\n\t}\nsnippet ife\n\tif (${1:/* condition */}) {\n\t\t${2:// code...}\n\t} else {\n\t\t${3:// code...}\n\t}\n\t${4}\nsnippet else\n\telse {\n\t\t${1:// code...}\n\t}\nsnippet elseif\n\telseif (${1:/* condition */}) {\n\t\t${2:// code...}\n\t}\nsnippet switch\n\tswitch ($${1:variable}) {\n\t\tcase '${2:value}':\n\t\t\t${3:// code...}\n\t\t\tbreak;\n\t\t${5}\n\t\tdefault:\n\t\t\t${4:// code...}\n\t\t\tbreak;\n\t}\nsnippet case\n\tcase '${1:value}':\n\t\t${2:// code...}\n\t\tbreak;${3}\nsnippet for\n\tfor ($${2:i} = 0; $$2 < ${1:count}; $$2${3:++}) {\n\t\t${4: // code...}\n\t}\nsnippet foreach\n\tforeach ($${1:variable} as $${2:value}) {\n\t\t${3:// code...}\n\t}\nsnippet foreachk\n\tforeach ($${1:variable} as $${2:key} => $${3:value}) {\n\t\t${4:// code...}\n\t}\n# $... = array (...)\nsnippet array\n\t$${1:arrayName} = array('${2}' => ${3});${4}\nsnippet try\n\ttry {\n\t\t${2}\n\t} catch (${1:Exception} $e) {\n\t}\n# lambda with closure\nsnippet lambda\n\t${1:static }function (${2:args}) use (${3:&$x, $y /*put vars in scope (closure) */}) {\n\t\t${4}\n\t};\n# pre_dump();\nsnippet pd\n\techo '<pre>'; var_dump(${1}); echo '</pre>';\n# pre_dump(); die();\nsnippet pdd\n\techo '<pre>'; var_dump(${1}); echo '</pre>'; die(${2:});\nsnippet vd\n\tvar_dump(${1});\nsnippet vdd\n\tvar_dump(${1}); die(${2:});\nsnippet http_redirect\n\theader (\"HTTP/1.1 301 Moved Permanently\");\n\theader (\"Location: \".URL);\n\texit();\n# Getters & Setters\nsnippet gs\n\t/**\n\t * Gets the value of ${1:foo}\n\t *\n\t * @return ${2:$1}\n\t */\n\tpublic function get${3:$2}()\n\t{\n\t\treturn $this->${4:$1};\n\t}\n\n\t/**\n\t * Sets the value of $1\n\t *\n\t * @param $2 $$1 ${5:description}\n\t *\n\t * @return ${6:$FILENAME}\n\t */\n\tpublic function set$3(${7:$2 }$$1)\n\t{\n\t\t$this->$4 = $$1;\n\t\treturn $this;\n\t}${8}\n# anotation, get, and set, useful for doctrine\nsnippet ags\n\t/**\n\t * ${1:description}\n\t *\n\t * @${7}\n\t */\n\t${2:protected} $${3:foo};\n\n\tpublic function get${4:$3}()\n\t{\n\t\treturn $this->$3;\n\t}\n\n\tpublic function set$4(${5:$4 }$${6:$3})\n\t{\n\t\t$this->$3 = $$6;\n\t\treturn $this;\n\t}\nsnippet rett\n\treturn true;\nsnippet retf\n\treturn false;\nscope html\nsnippet <?\n\t<?php\n\n\t${1}\nsnippet <?e\n\t<?php echo ${1} ?>\n# this one is for php5.4\nsnippet <?=\n\t<?=${1}?>\nsnippet ifil\n\t<?php if (${1:/* condition */}): ?>\n\t\t${2:<!-- code... -->}\n\t<?php endif; ?>\nsnippet ifeil\n\t<?php if (${1:/* condition */}): ?>\n\t\t${2:<!-- html... -->}\n\t<?php else: ?>\n\t\t${3:<!-- html... -->}\n\t<?php endif; ?>\n\t${4}\nsnippet foreachil\n\t<?php foreach ($${1:variable} as $${2:value}): ?>\n\t\t${3:<!-- html... -->}\n\t<?php endforeach; ?>\nsnippet foreachkil\n\t<?php foreach ($${1:variable} as $${2:key} => $${3:value}): ?>\n\t\t${4:<!-- html... -->}\n\t<?php endforeach; ?>\nscope html-tag\nsnippet ifil\\n\\\n\t<?php if (${1:true}): ?>${2:code}<?php endif; ?>\nsnippet ifeil\\n\\\n\t<?php if (${1:true}): ?>${2:code}<?php else: ?>${3:code}<?php endif; ?>${4}\n";

});

define("ace/snippets/php",["require","exports","module","ace/snippets/php.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./php.snippets");
exports.scope = "php";

});

define("ace/snippets/python.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet #!\n\t#!/usr/bin/env python\nsnippet imp\n\timport ${1:module}\nsnippet from\n\tfrom ${1:package} import ${2:module}\n# Module Docstring\nsnippet docs\n\t'''\n\tFile: ${1:FILENAME:file_name}\n\tAuthor: ${2:author}\n\tDescription: ${3}\n\t'''\nsnippet wh\n\twhile ${1:condition}:\n\t\t${2:# TODO: write code...}\n# dowh - does the same as do...while in other languages\nsnippet dowh\n\twhile True:\n\t\t${1:# TODO: write code...}\n\t\tif ${2:condition}:\n\t\t\tbreak\nsnippet with\n\twith ${1:expr} as ${2:var}:\n\t\t${3:# TODO: write code...}\n# New Class\nsnippet cl\n\tclass ${1:ClassName}(${2:object}):\n\t\t\"\"\"${3:docstring for $1}\"\"\"\n\t\tdef __init__(self, ${4:arg}):\n\t\t\t${5:super($1, self).__init__()}\n\t\t\tself.$4 = $4\n\t\t\t${6}\n# New Function\nsnippet def\n\tdef ${1:fname}(${2:`indent('.') ? 'self' : ''`}):\n\t\t\"\"\"${3:docstring for $1}\"\"\"\n\t\t${4:# TODO: write code...}\nsnippet deff\n\tdef ${1:fname}(${2:`indent('.') ? 'self' : ''`}):\n\t\t${3:# TODO: write code...}\n# New Method\nsnippet defs\n\tdef ${1:mname}(self, ${2:arg}):\n\t\t${3:# TODO: write code...}\n# New Property\nsnippet property\n\tdef ${1:foo}():\n\t\tdoc = \"${2:The $1 property.}\"\n\t\tdef fget(self):\n\t\t\t${3:return self._$1}\n\t\tdef fset(self, value):\n\t\t\t${4:self._$1 = value}\n# Ifs\nsnippet if\n\tif ${1:condition}:\n\t\t${2:# TODO: write code...}\nsnippet el\n\telse:\n\t\t${1:# TODO: write code...}\nsnippet ei\n\telif ${1:condition}:\n\t\t${2:# TODO: write code...}\n# For\nsnippet for\n\tfor ${1:item} in ${2:items}:\n\t\t${3:# TODO: write code...}\n# Encodes\nsnippet cutf8\n\t# -*- coding: utf-8 -*-\nsnippet clatin1\n\t# -*- coding: latin-1 -*-\nsnippet cascii\n\t# -*- coding: ascii -*-\n# Lambda\nsnippet ld\n\t${1:var} = lambda ${2:vars} : ${3:action}\nsnippet .\n\tself.\nsnippet try Try/Except\n\ttry:\n\t\t${1:# TODO: write code...}\n\texcept ${2:Exception}, ${3:e}:\n\t\t${4:raise $3}\nsnippet try Try/Except/Else\n\ttry:\n\t\t${1:# TODO: write code...}\n\texcept ${2:Exception}, ${3:e}:\n\t\t${4:raise $3}\n\telse:\n\t\t${5:# TODO: write code...}\nsnippet try Try/Except/Finally\n\ttry:\n\t\t${1:# TODO: write code...}\n\texcept ${2:Exception}, ${3:e}:\n\t\t${4:raise $3}\n\tfinally:\n\t\t${5:# TODO: write code...}\nsnippet try Try/Except/Else/Finally\n\ttry:\n\t\t${1:# TODO: write code...}\n\texcept ${2:Exception}, ${3:e}:\n\t\t${4:raise $3}\n\telse:\n\t\t${5:# TODO: write code...}\n\tfinally:\n\t\t${6:# TODO: write code...}\n# if __name__ == '__main__':\nsnippet ifmain\n\tif __name__ == '__main__':\n\t\t${1:main()}\n# __magic__\nsnippet _\n\t__${1:init}__${2}\n# python debugger (pdb)\nsnippet pdb\n\timport pdb; pdb.set_trace()\n# ipython debugger (ipdb)\nsnippet ipdb\n\timport ipdb; ipdb.set_trace()\n# ipython debugger (pdbbb)\nsnippet pdbbb\n\timport pdbpp; pdbpp.set_trace()\nsnippet pprint\n\timport pprint; pprint.pprint(${1})${2}\nsnippet \"\n\t\"\"\"\n\t${1:doc}\n\t\"\"\"\n# test function/method\nsnippet test\n\tdef test_${1:description}(${2:self}):\n\t\t${3:# TODO: write code...}\n# test case\nsnippet testcase\n\tclass ${1:ExampleCase}(unittest.TestCase):\n\t\t\n\t\tdef test_${2:description}(self):\n\t\t\t${3:# TODO: write code...}\nsnippet fut\n\tfrom __future__ import ${1}\n#getopt\nsnippet getopt\n\ttry:\n\t\t# Short option syntax: \"hv:\"\n\t\t# Long option syntax: \"help\" or \"verbose=\"\n\t\topts, args = getopt.getopt(sys.argv[1:], \"${1:short_options}\", [${2:long_options}])\n\t\n\texcept getopt.GetoptError, err:\n\t\t# Print debug info\n\t\tprint str(err)\n\t\t${3:error_action}\n\n\tfor option, argument in opts:\n\t\tif option in (\"-h\", \"--help\"):\n\t\t\t${4}\n\t\telif option in (\"-v\", \"--verbose\"):\n\t\t\tverbose = argument\n";

});

define("ace/snippets/python",["require","exports","module","ace/snippets/python.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./python.snippets");
exports.scope = "python";

});

define("ace/snippets/r.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet #!\n\t#!/usr/bin/env Rscript\n\n# includes\nsnippet lib\n\tlibrary(${1:package})\nsnippet req\n\trequire(${1:package})\nsnippet source\n\tsource('${1:file}')\n\n# conditionals\nsnippet if\n\tif (${1:condition}) {\n\t\t${2:code}\n\t}\nsnippet el\n\telse {\n\t\t${1:code}\n\t}\nsnippet ei\n\telse if (${1:condition}) {\n\t\t${2:code}\n\t}\n\n# functions\nsnippet fun\n\t${1:name} = function (${2:variables}) {\n\t\t${3:code}\n\t}\nsnippet ret\n\treturn(${1:code})\n\n# dataframes, lists, etc\nsnippet df\n\t${1:name}[${2:rows}, ${3:cols}]\nsnippet c\n\tc(${1:items})\nsnippet li\n\tlist(${1:items})\nsnippet mat\n\tmatrix(${1:data}, nrow=${2:rows}, ncol=${3:cols})\n\n# apply functions\nsnippet apply\n\tapply(${1:array}, ${2:margin}, ${3:function})\nsnippet lapply\n\tlapply(${1:list}, ${2:function})\nsnippet sapply\n\tsapply(${1:list}, ${2:function})\nsnippet vapply\n\tvapply(${1:list}, ${2:function}, ${3:type})\nsnippet mapply\n\tmapply(${1:function}, ${2:...})\nsnippet tapply\n\ttapply(${1:vector}, ${2:index}, ${3:function})\nsnippet rapply\n\trapply(${1:list}, ${2:function})\n\n# plyr functions\nsnippet dd\n\tddply(${1:frame}, ${2:variables}, ${3:function})\nsnippet dl\n\tdlply(${1:frame}, ${2:variables}, ${3:function})\nsnippet da\n\tdaply(${1:frame}, ${2:variables}, ${3:function})\nsnippet d_\n\td_ply(${1:frame}, ${2:variables}, ${3:function})\n\nsnippet ad\n\tadply(${1:array}, ${2:margin}, ${3:function})\nsnippet al\n\talply(${1:array}, ${2:margin}, ${3:function})\nsnippet aa\n\taaply(${1:array}, ${2:margin}, ${3:function})\nsnippet a_\n\ta_ply(${1:array}, ${2:margin}, ${3:function})\n\nsnippet ld\n\tldply(${1:list}, ${2:function})\nsnippet ll\n\tllply(${1:list}, ${2:function})\nsnippet la\n\tlaply(${1:list}, ${2:function})\nsnippet l_\n\tl_ply(${1:list}, ${2:function})\n\nsnippet md\n\tmdply(${1:matrix}, ${2:function})\nsnippet ml\n\tmlply(${1:matrix}, ${2:function})\nsnippet ma\n\tmaply(${1:matrix}, ${2:function})\nsnippet m_\n\tm_ply(${1:matrix}, ${2:function})\n\n# plot functions\nsnippet pl\n\tplot(${1:x}, ${2:y})\nsnippet ggp\n\tggplot(${1:data}, aes(${2:aesthetics}))\nsnippet img\n\t${1:(jpeg,bmp,png,tiff)}(filename=\"${2:filename}\", width=${3}, height=${4}, unit=\"${5}\")\n\t${6:plot}\n\tdev.off()\n\n# statistical test functions\nsnippet fis\n\tfisher.test(${1:x}, ${2:y})\nsnippet chi\n\tchisq.test(${1:x}, ${2:y})\nsnippet tt\n\tt.test(${1:x}, ${2:y})\nsnippet wil\n\twilcox.test(${1:x}, ${2:y})\nsnippet cor\n\tcor.test(${1:x}, ${2:y})\nsnippet fte\n\tvar.test(${1:x}, ${2:y})\nsnippet kvt \n\tkv.test(${1:x}, ${2:y})\n";

});

define("ace/snippets/r",["require","exports","module","ace/snippets/r.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./r.snippets");
exports.scope = "r";

});

define("ace/snippets/razor.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet if\n(${1} == ${2}) {\n\t${3}\n}";

});

define("ace/snippets/razor",["require","exports","module","ace/snippets/razor.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./razor.snippets");
exports.scope = "razor";

});

define("ace/snippets/robot.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# scope: robot\n### Sections\nsnippet settingssection\ndescription *** Settings *** section\n\t*** Settings ***\n\tLibrary    ${1}\n\nsnippet keywordssection\ndescription *** Keywords *** section\n\t*** Keywords ***\n\t${1:Keyword Name}\n\t    [Arguments]    \\${${2:Example Arg 1}}\n\t\nsnippet testcasessection\ndescription *** Test Cases *** section\n\t*** Test Cases ***\n\t${1:First Test Case}\n\t    ${2:Log    Example Arg}\n\nsnippet variablessection\ndescription *** Variables *** section\n\t*** Variables ***\n\t\\${${1:Variable Name}}=    ${2:Variable Value}\n\n### Helpful keywords\nsnippet testcase\ndescription A test case\n\t${1:Test Case Name}\n\t    ${2:Log    Example log message}\n\t\nsnippet keyword\ndescription A keyword\n\t${1:Example Keyword}\n\t    [Arguments]    \\${${2:Example Arg 1}}\n\n### Built Ins\nsnippet forinr\ndescription For In Range Loop\n\tFOR    \\${${1:Index}}    IN RANGE     \\${${2:10}}\n\t    Log     \\${${1:Index}}\n\tEND\n\nsnippet forin\ndescription For In Loop\n\tFOR    \\${${1:Item}}    IN     @{${2:List Variable}}\n\t    Log     \\${${1:Item}}\n\tEND\n\nsnippet if\ndescription If Statement\n\tIF    ${1:condition}\n\t    ${2:Do something}\n\tEND\n\nsnippet else\ndescription If Statement\n\tIF    ${1:Condition}\n\t    ${2:Do something}\n\tELSE\n\t    ${3:Otherwise do this}\n\tEND\n\nsnippet elif\ndescription Else-If Statement\n\tIF    ${1:Condition 1}\n\t    ${2:Do something}\n\tELSE IF    ${3:Condition 2}\n\t    ${4:Do something else}\n\tEND\n";

});

define("ace/snippets/robot",["require","exports","module","ace/snippets/robot.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./robot.snippets");
exports.scope = "robot";

});

define("ace/snippets/rst.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# rst\n\nsnippet :\n\t:${1:field name}: ${2:field body}\nsnippet *\n\t*${1:Emphasis}*\nsnippet **\n\t**${1:Strong emphasis}**\nsnippet _\n\t\\`${1:hyperlink-name}\\`_\n\t.. _\\`$1\\`: ${2:link-block}\nsnippet =\n\t${1:Title}\n\t=====${2:=}\n\t${3}\nsnippet -\n\t${1:Title}\n\t-----${2:-}\n\t${3}\nsnippet cont:\n\t.. contents::\n\t\n";

});

define("ace/snippets/rst",["require","exports","module","ace/snippets/rst.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./rst.snippets");
exports.scope = "rst";

});

define("ace/snippets/ruby.snippets",["require","exports","module"], function(require, exports, module){module.exports = "########################################\n# Ruby snippets - for Rails, see below #\n########################################\n\n# encoding for Ruby 1.9\nsnippet enc\n\t# encoding: utf-8\n\n# #!/usr/bin/env ruby\nsnippet #!\n\t#!/usr/bin/env ruby\n\t# encoding: utf-8\n\n# New Block\nsnippet =b\n\t=begin rdoc\n\t\t${1}\n\t=end\nsnippet y\n\t:yields: ${1:arguments}\nsnippet rb\n\t#!/usr/bin/env ruby -wKU\nsnippet beg\n\tbegin\n\t\t${3}\n\trescue ${1:Exception} => ${2:e}\n\tend\n\nsnippet req require\n\trequire \"${1}\"${2}\nsnippet #\n\t# =>\nsnippet end\n\t__END__\nsnippet case\n\tcase ${1:object}\n\twhen ${2:condition}\n\t\t${3}\n\tend\nsnippet when\n\twhen ${1:condition}\n\t\t${2}\nsnippet def\n\tdef ${1:method_name}\n\t\t${2}\n\tend\nsnippet deft\n\tdef test_${1:case_name}\n\t\t${2}\n\tend\nsnippet if\n\tif ${1:condition}\n\t\t${2}\n\tend\nsnippet ife\n\tif ${1:condition}\n\t\t${2}\n\telse\n\t\t${3}\n\tend\nsnippet elsif\n\telsif ${1:condition}\n\t\t${2}\nsnippet unless\n\tunless ${1:condition}\n\t\t${2}\n\tend\nsnippet while\n\twhile ${1:condition}\n\t\t${2}\n\tend\nsnippet for\n\tfor ${1:e} in ${2:c}\n\t\t${3}\n\tend\nsnippet until\n\tuntil ${1:condition}\n\t\t${2}\n\tend\nsnippet cla class .. end\n\tclass ${1:`substitute(Filename(), '\\(_\\|^\\)\\(.\\)', '\\u\\2', 'g')`}\n\t\t${2}\n\tend\nsnippet cla class .. initialize .. end\n\tclass ${1:`substitute(Filename(), '\\(_\\|^\\)\\(.\\)', '\\u\\2', 'g')`}\n\t\tdef initialize(${2:args})\n\t\t\t${3}\n\t\tend\n\tend\nsnippet cla class .. < ParentClass .. initialize .. end\n\tclass ${1:`substitute(Filename(), '\\(_\\|^\\)\\(.\\)', '\\u\\2', 'g')`} < ${2:ParentClass}\n\t\tdef initialize(${3:args})\n\t\t\t${4}\n\t\tend\n\tend\nsnippet cla ClassName = Struct .. do .. end\n\t${1:`substitute(Filename(), '\\(_\\|^\\)\\(.\\)', '\\u\\2', 'g')`} = Struct.new(:${2:attr_names}) do\n\t\tdef ${3:method_name}\n\t\t\t${4}\n\t\tend\n\tend\nsnippet cla class BlankSlate .. initialize .. end\n\tclass ${1:BlankSlate}\n\t\tinstance_methods.each { |meth| undef_method(meth) unless meth =~ /\\A__/ }\n\tend\nsnippet cla class << self .. end\n\tclass << ${1:self}\n\t\t${2}\n\tend\n# class .. < DelegateClass .. initialize .. end\nsnippet cla-\n\tclass ${1:`substitute(Filename(), '\\(_\\|^\\)\\(.\\)', '\\u\\2', 'g')`} < DelegateClass(${2:ParentClass})\n\t\tdef initialize(${3:args})\n\t\t\tsuper(${4:del_obj})\n\n\t\t\t${5}\n\t\tend\n\tend\nsnippet mod module .. end\n\tmodule ${1:`substitute(Filename(), '\\(_\\|^\\)\\(.\\)', '\\u\\2', 'g')`}\n\t\t${2}\n\tend\nsnippet mod module .. module_function .. end\n\tmodule ${1:`substitute(Filename(), '\\(_\\|^\\)\\(.\\)', '\\u\\2', 'g')`}\n\t\tmodule_function\n\n\t\t${2}\n\tend\nsnippet mod module .. ClassMethods .. end\n\tmodule ${1:`substitute(Filename(), '\\(_\\|^\\)\\(.\\)', '\\u\\2', 'g')`}\n\t\tmodule ClassMethods\n\t\t\t${2}\n\t\tend\n\n\t\tmodule InstanceMethods\n\n\t\tend\n\n\t\tdef self.included(receiver)\n\t\t\treceiver.extend         ClassMethods\n\t\t\treceiver.send :include, InstanceMethods\n\t\tend\n\tend\n# attr_reader\nsnippet r\n\tattr_reader :${1:attr_names}\n# attr_writer\nsnippet w\n\tattr_writer :${1:attr_names}\n# attr_accessor\nsnippet rw\n\tattr_accessor :${1:attr_names}\nsnippet atp\n\tattr_protected :${1:attr_names}\nsnippet ata\n\tattr_accessible :${1:attr_names}\n# include Enumerable\nsnippet Enum\n\tinclude Enumerable\n\n\tdef each(&block)\n\t\t${1}\n\tend\n# include Comparable\nsnippet Comp\n\tinclude Comparable\n\n\tdef <=>(other)\n\t\t${1}\n\tend\n# extend Forwardable\nsnippet Forw-\n\textend Forwardable\n# def self\nsnippet defs\n\tdef self.${1:class_method_name}\n\t\t${2}\n\tend\n# def method_missing\nsnippet defmm\n\tdef method_missing(meth, *args, &blk)\n\t\t${1}\n\tend\nsnippet defd\n\tdef_delegator :${1:@del_obj}, :${2:del_meth}, :${3:new_name}\nsnippet defds\n\tdef_delegators :${1:@del_obj}, :${2:del_methods}\nsnippet am\n\talias_method :${1:new_name}, :${2:old_name}\nsnippet app\n\tif __FILE__ == $PROGRAM_NAME\n\t\t${1}\n\tend\n# usage_if()\nsnippet usai\n\tif ARGV.${1}\n\t\tabort \"Usage: #{$PROGRAM_NAME} ${2:ARGS_GO_HERE}\"${3}\n\tend\n# usage_unless()\nsnippet usau\n\tunless ARGV.${1}\n\t\tabort \"Usage: #{$PROGRAM_NAME} ${2:ARGS_GO_HERE}\"${3}\n\tend\nsnippet array\n\tArray.new(${1:10}) { |${2:i}| ${3} }\nsnippet hash\n\tHash.new { |${1:hash}, ${2:key}| $1[$2] = ${3} }\nsnippet file File.foreach() { |line| .. }\n\tFile.foreach(${1:\"path/to/file\"}) { |${2:line}| ${3} }\nsnippet file File.read()\n\tFile.read(${1:\"path/to/file\"})${2}\nsnippet Dir Dir.global() { |file| .. }\n\tDir.glob(${1:\"dir/glob/*\"}) { |${2:file}| ${3} }\nsnippet Dir Dir[\"..\"]\n\tDir[${1:\"glob/**/*.rb\"}]${2}\nsnippet dir\n\tFilename.dirname(__FILE__)\nsnippet deli\n\tdelete_if { |${1:e}| ${2} }\nsnippet fil\n\tfill(${1:range}) { |${2:i}| ${3} }\n# flatten_once()\nsnippet flao\n\tinject(Array.new) { |${1:arr}, ${2:a}| $1.push(*$2)}${3}\nsnippet zip\n\tzip(${1:enums}) { |${2:row}| ${3} }\n# downto(0) { |n| .. }\nsnippet dow\n\tdownto(${1:0}) { |${2:n}| ${3} }\nsnippet ste\n\tstep(${1:2}) { |${2:n}| ${3} }\nsnippet tim\n\ttimes { |${1:n}| ${2} }\nsnippet upt\n\tupto(${1:1.0/0.0}) { |${2:n}| ${3} }\nsnippet loo\n\tloop { ${1} }\nsnippet ea\n\teach { |${1:e}| ${2} }\nsnippet ead\n\teach do |${1:e}|\n\t\t${2}\n\tend\nsnippet eab\n\teach_byte { |${1:byte}| ${2} }\nsnippet eac- each_char { |chr| .. }\n\teach_char { |${1:chr}| ${2} }\nsnippet eac- each_cons(..) { |group| .. }\n\teach_cons(${1:2}) { |${2:group}| ${3} }\nsnippet eai\n\teach_index { |${1:i}| ${2} }\nsnippet eaid\n\teach_index do |${1:i}|\n\t\t${2}\n\tend\nsnippet eak\n\teach_key { |${1:key}| ${2} }\nsnippet eakd\n\teach_key do |${1:key}|\n\t\t${2}\n\tend\nsnippet eal\n\teach_line { |${1:line}| ${2} }\nsnippet eald\n\teach_line do |${1:line}|\n\t\t${2}\n\tend\nsnippet eap\n\teach_pair { |${1:name}, ${2:val}| ${3} }\nsnippet eapd\n\teach_pair do |${1:name}, ${2:val}|\n\t\t${3}\n\tend\nsnippet eas-\n\teach_slice(${1:2}) { |${2:group}| ${3} }\nsnippet easd-\n\teach_slice(${1:2}) do |${2:group}|\n\t\t${3}\n\tend\nsnippet eav\n\teach_value { |${1:val}| ${2} }\nsnippet eavd\n\teach_value do |${1:val}|\n\t\t${2}\n\tend\nsnippet eawi\n\teach_with_index { |${1:e}, ${2:i}| ${3} }\nsnippet eawid\n\teach_with_index do |${1:e},${2:i}|\n\t\t${3}\n\tend\nsnippet reve\n\treverse_each { |${1:e}| ${2} }\nsnippet reved\n\treverse_each do |${1:e}|\n\t\t${2}\n\tend\nsnippet inj\n\tinject(${1:init}) { |${2:mem}, ${3:var}| ${4} }\nsnippet injd\n\tinject(${1:init}) do |${2:mem}, ${3:var}|\n\t\t${4}\n\tend\nsnippet map\n\tmap { |${1:e}| ${2} }\nsnippet mapd\n\tmap do |${1:e}|\n\t\t${2}\n\tend\nsnippet mapwi-\n\tenum_with_index.map { |${1:e}, ${2:i}| ${3} }\nsnippet sor\n\tsort { |a, b| ${1} }\nsnippet sorb\n\tsort_by { |${1:e}| ${2} }\nsnippet ran\n\tsort_by { rand }\nsnippet all\n\tall? { |${1:e}| ${2} }\nsnippet any\n\tany? { |${1:e}| ${2} }\nsnippet cl\n\tclassify { |${1:e}| ${2} }\nsnippet col\n\tcollect { |${1:e}| ${2} }\nsnippet cold\n\tcollect do |${1:e}|\n\t\t${2}\n\tend\nsnippet det\n\tdetect { |${1:e}| ${2} }\nsnippet detd\n\tdetect do |${1:e}|\n\t\t${2}\n\tend\nsnippet fet\n\tfetch(${1:name}) { |${2:key}| ${3} }\nsnippet fin\n\tfind { |${1:e}| ${2} }\nsnippet find\n\tfind do |${1:e}|\n\t\t${2}\n\tend\nsnippet fina\n\tfind_all { |${1:e}| ${2} }\nsnippet finad\n\tfind_all do |${1:e}|\n\t\t${2}\n\tend\nsnippet gre\n\tgrep(${1:/pattern/}) { |${2:match}| ${3} }\nsnippet sub\n\t${1:g}sub(${2:/pattern/}) { |${3:match}| ${4} }\nsnippet sca\n\tscan(${1:/pattern/}) { |${2:match}| ${3} }\nsnippet scad\n\tscan(${1:/pattern/}) do |${2:match}|\n\t\t${3}\n\tend\nsnippet max\n\tmax { |a, b| ${1} }\nsnippet min\n\tmin { |a, b| ${1} }\nsnippet par\n\tpartition { |${1:e}| ${2} }\nsnippet pard\n\tpartition do |${1:e}|\n\t\t${2}\n\tend\nsnippet rej\n\treject { |${1:e}| ${2} }\nsnippet rejd\n\treject do |${1:e}|\n\t\t${2}\n\tend\nsnippet sel\n\tselect { |${1:e}| ${2} }\nsnippet seld\n\tselect do |${1:e}|\n\t\t${2}\n\tend\nsnippet lam\n\tlambda { |${1:args}| ${2} }\nsnippet doo\n\tdo\n\t\t${1}\n\tend\nsnippet dov\n\tdo |${1:variable}|\n\t\t${2}\n\tend\nsnippet :\n\t:${1:key} => ${2:\"value\"}${3}\nsnippet ope\n\topen(${1:\"path/or/url/or/pipe\"}, \"${2:w}\") { |${3:io}| ${4} }\n# path_from_here()\nsnippet fpath\n\tFile.join(File.dirname(__FILE__), *%2[${1:rel path here}])${2}\n# unix_filter {}\nsnippet unif\n\tARGF.each_line${1} do |${2:line}|\n\t\t${3}\n\tend\n# option_parse {}\nsnippet optp\n\trequire \"optparse\"\n\n\toptions = {${1:default => \"args\"}}\n\n\tARGV.options do |opts|\n\t\topts.banner = \"Usage: #{File.basename($PROGRAM_NAME)}\nsnippet opt\n\topts.on( \"-${1:o}\", \"--${2:long-option-name}\", ${3:String},\n\t         \"${4:Option description.}\") do |${5:opt}|\n\t\t${6}\n\tend\nsnippet tc\n\trequire \"test/unit\"\n\n\trequire \"${1:library_file_name}\"\n\n\tclass Test${2:$1} < Test::Unit::TestCase\n\t\tdef test_${3:case_name}\n\t\t\t${4}\n\t\tend\n\tend\nsnippet ts\n\trequire \"test/unit\"\n\n\trequire \"tc_${1:test_case_file}\"\n\trequire \"tc_${2:test_case_file}\"${3}\nsnippet as\n\tassert ${1:test}, \"${2:Failure message.}\"${3}\nsnippet ase\n\tassert_equal ${1:expected}, ${2:actual}${3}\nsnippet asne\n\tassert_not_equal ${1:unexpected}, ${2:actual}${3}\nsnippet asid\n\tassert_in_delta ${1:expected_float}, ${2:actual_float}, ${3:2 ** -20}${4}\nsnippet asio\n\tassert_instance_of ${1:ExpectedClass}, ${2:actual_instance}${3}\nsnippet asko\n\tassert_kind_of ${1:ExpectedKind}, ${2:actual_instance}${3}\nsnippet asn\n\tassert_nil ${1:instance}${2}\nsnippet asnn\n\tassert_not_nil ${1:instance}${2}\nsnippet asm\n\tassert_match /${1:expected_pattern}/, ${2:actual_string}${3}\nsnippet asnm\n\tassert_no_match /${1:unexpected_pattern}/, ${2:actual_string}${3}\nsnippet aso\n\tassert_operator ${1:left}, :${2:operator}, ${3:right}${4}\nsnippet asr\n\tassert_raise ${1:Exception} { ${2} }\nsnippet asrd\n\tassert_raise ${1:Exception} do\n\t\t${2}\n\tend\nsnippet asnr\n\tassert_nothing_raised ${1:Exception} { ${2} }\nsnippet asnrd\n\tassert_nothing_raised ${1:Exception} do\n\t\t${2}\n\tend\nsnippet asrt\n\tassert_respond_to ${1:object}, :${2:method}${3}\nsnippet ass assert_same(..)\n\tassert_same ${1:expected}, ${2:actual}${3}\nsnippet ass assert_send(..)\n\tassert_send [${1:object}, :${2:message}, ${3:args}]${4}\nsnippet asns\n\tassert_not_same ${1:unexpected}, ${2:actual}${3}\nsnippet ast\n\tassert_throws :${1:expected} { ${2} }\nsnippet astd\n\tassert_throws :${1:expected} do\n\t\t${2}\n\tend\nsnippet asnt\n\tassert_nothing_thrown { ${1} }\nsnippet asntd\n\tassert_nothing_thrown do\n\t\t${1}\n\tend\nsnippet fl\n\tflunk \"${1:Failure message.}\"${2}\n# Benchmark.bmbm do .. end\nsnippet bm-\n\tTESTS = ${1:10_000}\n\tBenchmark.bmbm do |results|\n\t\t${2}\n\tend\nsnippet rep\n\tresults.report(\"${1:name}:\") { TESTS.times { ${2} }}\n# Marshal.dump(.., file)\nsnippet Md\n\tFile.open(${1:\"path/to/file.dump\"}, \"wb\") { |${2:file}| Marshal.dump(${3:obj}, $2) }${4}\n# Mashal.load(obj)\nsnippet Ml\n\tFile.open(${1:\"path/to/file.dump\"}, \"rb\") { |${2:file}| Marshal.load($2) }${3}\n# deep_copy(..)\nsnippet deec\n\tMarshal.load(Marshal.dump(${1:obj_to_copy}))${2}\nsnippet Pn-\n\tPStore.new(${1:\"file_name.pstore\"})${2}\nsnippet tra\n\ttransaction(${1:true}) { ${2} }\n# xmlread(..)\nsnippet xml-\n\tREXML::Document.new(File.read(${1:\"path/to/file\"}))${2}\n# xpath(..) { .. }\nsnippet xpa\n\telements.each(${1:\"//Xpath\"}) do |${2:node}|\n\t\t${3}\n\tend\n# class_from_name()\nsnippet clafn\n\tsplit(\"::\").inject(Object) { |par, const| par.const_get(const) }\n# singleton_class()\nsnippet sinc\n\tclass << self; self end\nsnippet nam\n\tnamespace :${1:`Filename()`} do\n\t\t${2}\n\tend\nsnippet tas\n\tdesc \"${1:Task description}\"\n\ttask :${2:task_name => [:dependent, :tasks]} do\n\t\t${3}\n\tend\n# block\nsnippet b\n\t{ |${1:var}| ${2} }\nsnippet begin\n\tbegin\n\t\traise 'A test exception.'\n\trescue Exception => e\n\t\tputs e.message\n\t\tputs e.backtrace.inspect\n\telse\n\t\t# other exception\n\tensure\n\t\t# always executed\n\tend\n\n#debugging\nsnippet debug\n\trequire 'ruby-debug'; debugger; true;\nsnippet pry\n\trequire 'pry'; binding.pry\n\n#############################################\n# Rails snippets - for pure Ruby, see above #\n#############################################\nsnippet art\n\tassert_redirected_to ${1::action => \"${2:index}\"}\nsnippet artnp\n\tassert_redirected_to ${1:parent}_${2:child}_path(${3:@$1}, ${4:@$2})\nsnippet artnpp\n\tassert_redirected_to ${1:parent}_${2:child}_path(${3:@$1})\nsnippet artp\n\tassert_redirected_to ${1:model}_path(${2:@$1})\nsnippet artpp\n\tassert_redirected_to ${1:model}s_path\nsnippet asd\n\tassert_difference \"${1:Model}.${2:count}\", $1 do\n\t\t${3}\n\tend\nsnippet asnd\n\tassert_no_difference \"${1:Model}.${2:count}\" do\n\t\t${3}\n\tend\nsnippet asre\n\tassert_response :${1:success}, @response.body${2}\nsnippet asrj\n\tassert_rjs :${1:replace}, \"${2:dom id}\"\nsnippet ass assert_select(..)\n\tassert_select '${1:path}', :${2:text} => '${3:inner_html' ${4:do}\nsnippet bf\n\tbefore_filter :${1:method}\nsnippet bt\n\tbelongs_to :${1:association}\nsnippet crw\n\tcattr_accessor :${1:attr_names}\nsnippet defcreate\n\tdef create\n\t\t@${1:model_class_name} = ${2:ModelClassName}.new(params[:$1])\n\n\t\trespond_to do |wants|\n\t\t\tif @$1.save\n\t\t\t\tflash[:notice] = '$2 was successfully created.'\n\t\t\t\twants.html { redirect_to(@$1) }\n\t\t\t\twants.xml  { render :xml => @$1, :status => :created, :location => @$1 }\n\t\t\telse\n\t\t\t\twants.html { render :action => \"new\" }\n\t\t\t\twants.xml  { render :xml => @$1.errors, :status => :unprocessable_entity }\n\t\t\tend\n\t\tend\n\tend${3}\nsnippet defdestroy\n\tdef destroy\n\t\t@${1:model_class_name} = ${2:ModelClassName}.find(params[:id])\n\t\t@$1.destroy\n\n\t\trespond_to do |wants|\n\t\t\twants.html { redirect_to($1s_url) }\n\t\t\twants.xml  { head :ok }\n\t\tend\n\tend${3}\nsnippet defedit\n\tdef edit\n\t\t@${1:model_class_name} = ${2:ModelClassName}.find(params[:id])\n\tend\nsnippet defindex\n\tdef index\n\t\t@${1:model_class_name} = ${2:ModelClassName}.all\n\n\t\trespond_to do |wants|\n\t\t\twants.html # index.html.erb\n\t\t\twants.xml  { render :xml => @$1s }\n\t\tend\n\tend${3}\nsnippet defnew\n\tdef new\n\t\t@${1:model_class_name} = ${2:ModelClassName}.new\n\n\t\trespond_to do |wants|\n\t\t\twants.html # new.html.erb\n\t\t\twants.xml  { render :xml => @$1 }\n\t\tend\n\tend${3}\nsnippet defshow\n\tdef show\n\t\t@${1:model_class_name} = ${2:ModelClassName}.find(params[:id])\n\n\t\trespond_to do |wants|\n\t\t\twants.html # show.html.erb\n\t\t\twants.xml  { render :xml => @$1 }\n\t\tend\n\tend${3}\nsnippet defupdate\n\tdef update\n\t\t@${1:model_class_name} = ${2:ModelClassName}.find(params[:id])\n\n\t\trespond_to do |wants|\n\t\t\tif @$1.update_attributes(params[:$1])\n\t\t\t\tflash[:notice] = '$2 was successfully updated.'\n\t\t\t\twants.html { redirect_to(@$1) }\n\t\t\t\twants.xml  { head :ok }\n\t\t\telse\n\t\t\t\twants.html { render :action => \"edit\" }\n\t\t\t\twants.xml  { render :xml => @$1.errors, :status => :unprocessable_entity }\n\t\t\tend\n\t\tend\n\tend${3}\nsnippet flash\n\tflash[:${1:notice}] = \"${2}\"\nsnippet habtm\n\thas_and_belongs_to_many :${1:object}, :join_table => \"${2:table_name}\", :foreign_key => \"${3}_id\"${4}\nsnippet hm\n\thas_many :${1:object}\nsnippet hmd\n\thas_many :${1:other}s, :class_name => \"${2:$1}\", :foreign_key => \"${3:$1}_id\", :dependent => :destroy${4}\nsnippet hmt\n\thas_many :${1:object}, :through => :${2:object}\nsnippet ho\n\thas_one :${1:object}\nsnippet i18\n\tI18n.t('${1:type.key}')${2}\nsnippet ist\n\t<%= image_submit_tag(\"${1:agree.png}\", :id => \"${2:id}\"${3} %>\nsnippet log\n\tRails.logger.${1:debug} ${2}\nsnippet log2\n\tRAILS_DEFAULT_LOGGER.${1:debug} ${2}\nsnippet logd\n\tlogger.debug { \"${1:message}\" }${2}\nsnippet loge\n\tlogger.error { \"${1:message}\" }${2}\nsnippet logf\n\tlogger.fatal { \"${1:message}\" }${2}\nsnippet logi\n\tlogger.info { \"${1:message}\" }${2}\nsnippet logw\n\tlogger.warn { \"${1:message}\" }${2}\nsnippet mapc\n\t${1:map}.${2:connect} '${3:controller/:action/:id}'\nsnippet mapca\n\t${1:map}.catch_all \"*${2:anything}\", :controller => \"${3:default}\", :action => \"${4:error}\"${5}\nsnippet mapr\n\t${1:map}.resource :${2:resource}\nsnippet maprs\n\t${1:map}.resources :${2:resource}\nsnippet mapwo\n\t${1:map}.with_options :${2:controller} => '${3:thing}' do |$3|\n\t\t${4}\n\tend\nsnippet mbs\n\tbefore_save :${1:method}\nsnippet mcht\n\tchange_table :${1:table_name} do |t|\n\t\t${2}\n\tend\nsnippet mp\n\tmap(&:${1:id})\nsnippet mrw\n\tmattr_accessor :${1:attr_names}\nsnippet oa\n\torder(\"${1:field}\")\nsnippet od\n\torder(\"${1:field} DESC\")\nsnippet pa\n\tparams[:${1:id}]${2}\nsnippet ra\n\trender :action => \"${1:action}\"\nsnippet ral\n\trender :action => \"${1:action}\", :layout => \"${2:layoutname}\"\nsnippet rest\n\trespond_to do |wants|\n\t\twants.${1:html} { ${2} }\n\tend\nsnippet rf\n\trender :file => \"${1:filepath}\"\nsnippet rfu\n\trender :file => \"${1:filepath}\", :use_full_path => ${2:false}\nsnippet ri\n\trender :inline => \"${1:<%= 'hello' %>}\"\nsnippet ril\n\trender :inline => \"${1:<%= 'hello' %>}\", :locals => { ${2::name} => \"${3:value}\"${4} }\nsnippet rit\n\trender :inline => \"${1:<%= 'hello' %>}\", :type => ${2::rxml}\nsnippet rjson\n\trender :json => ${1:text to render}\nsnippet rl\n\trender :layout => \"${1:layoutname}\"\nsnippet rn\n\trender :nothing => ${1:true}\nsnippet rns\n\trender :nothing => ${1:true}, :status => ${2:401}\nsnippet rp\n\trender :partial => \"${1:item}\"\nsnippet rpc\n\trender :partial => \"${1:item}\", :collection => ${2:@$1s}\nsnippet rpl\n\trender :partial => \"${1:item}\", :locals => { :${2:$1} => ${3:@$1}\nsnippet rpo\n\trender :partial => \"${1:item}\", :object => ${2:@$1}\nsnippet rps\n\trender :partial => \"${1:item}\", :status => ${2:500}\nsnippet rt\n\trender :text => \"${1:text to render}\"\nsnippet rtl\n\trender :text => \"${1:text to render}\", :layout => \"${2:layoutname}\"\nsnippet rtlt\n\trender :text => \"${1:text to render}\", :layout => ${2:true}\nsnippet rts\n\trender :text => \"${1:text to render}\", :status => ${2:401}\nsnippet ru\n\trender :update do |${1:page}|\n\t\t$1.${2}\n\tend\nsnippet rxml\n\trender :xml => ${1:text to render}\nsnippet sc\n\tscope :${1:name}, :where(:@${2:field} => ${3:value})\nsnippet sl\n\tscope :${1:name}, lambda do |${2:value}|\n\t\twhere(\"${3:field = ?}\", ${4:bind var})\n\tend\nsnippet sha1\n\tDigest::SHA1.hexdigest(${1:string})\nsnippet sweeper\n\tclass ${1:ModelClassName}Sweeper < ActionController::Caching::Sweeper\n\t\tobserve $1\n\n\t\tdef after_save(${2:model_class_name})\n\t\t\texpire_cache($2)\n\t\tend\n\n\t\tdef after_destroy($2)\n\t\t\texpire_cache($2)\n\t\tend\n\n\t\tdef expire_cache($2)\n\t\t\texpire_page\n\t\tend\n\tend\nsnippet tcb\n\tt.boolean :${1:title}\n\t${2}\nsnippet tcbi\n\tt.binary :${1:title}, :limit => ${2:2}.megabytes\n\t${3}\nsnippet tcd\n\tt.decimal :${1:title}, :precision => ${2:10}, :scale => ${3:2}\n\t${4}\nsnippet tcda\n\tt.date :${1:title}\n\t${2}\nsnippet tcdt\n\tt.datetime :${1:title}\n\t${2}\nsnippet tcf\n\tt.float :${1:title}\n\t${2}\nsnippet tch\n\tt.change :${1:name}, :${2:string}, :${3:limit} => ${4:80}\n\t${5}\nsnippet tci\n\tt.integer :${1:title}\n\t${2}\nsnippet tcl\n\tt.integer :lock_version, :null => false, :default => 0\n\t${1}\nsnippet tcr\n\tt.references :${1:taggable}, :polymorphic => { :default => '${2:Photo}' }\n\t${3}\nsnippet tcs\n\tt.string :${1:title}\n\t${2}\nsnippet tct\n\tt.text :${1:title}\n\t${2}\nsnippet tcti\n\tt.time :${1:title}\n\t${2}\nsnippet tcts\n\tt.timestamp :${1:title}\n\t${2}\nsnippet tctss\n\tt.timestamps\n\t${1}\nsnippet va\n\tvalidates_associated :${1:attribute}\nsnippet vao\n\tvalidates_acceptance_of :${1:terms}\nsnippet vc\n\tvalidates_confirmation_of :${1:attribute}\nsnippet ve\n\tvalidates_exclusion_of :${1:attribute}, :in => ${2:%w( mov avi )}\nsnippet vf\n\tvalidates_format_of :${1:attribute}, :with => /${2:regex}/\nsnippet vi\n\tvalidates_inclusion_of :${1:attribute}, :in => %w(${2: mov avi })\nsnippet vl\n\tvalidates_length_of :${1:attribute}, :within => ${2:3}..${3:20}\nsnippet vn\n\tvalidates_numericality_of :${1:attribute}\nsnippet vpo\n\tvalidates_presence_of :${1:attribute}\nsnippet vu\n\tvalidates_uniqueness_of :${1:attribute}\nsnippet wants\n\twants.${1:js|xml|html} { ${2} }\nsnippet wc\n\twhere(${1:\"conditions\"}${2:, bind_var})\nsnippet wh\n\twhere(${1:field} => ${2:value})\nsnippet xdelete\n\txhr :delete, :${1:destroy}, :id => ${2:1}${3}\nsnippet xget\n\txhr :get, :${1:show}, :id => ${2:1}${3}\nsnippet xpost\n\txhr :post, :${1:create}, :${2:object} => { ${3} }\nsnippet xput\n\txhr :put, :${1:update}, :id => ${2:1}, :${3:object} => { ${4} }${5}\nsnippet test\n\ttest \"should ${1:do something}\" do\n\t\t${2}\n\tend\n#migrations\nsnippet mac\n\tadd_column :${1:table_name}, :${2:column_name}, :${3:data_type}\nsnippet mrc\n\tremove_column :${1:table_name}, :${2:column_name}\nsnippet mrnc\n\trename_column :${1:table_name}, :${2:old_column_name}, :${3:new_column_name}\nsnippet mcc\n\tchange_column :${1:table}, :${2:column}, :${3:type}\nsnippet mccc\n\tt.column :${1:title}, :${2:string}\nsnippet mct\n\tcreate_table :${1:table_name} do |t|\n\t\tt.column :${2:name}, :${3:type}\n\tend\nsnippet migration\n\tclass ${1:class_name} < ActiveRecord::Migration\n\t\tdef self.up\n\t\t\t${2}\n\t\tend\n\n\t\tdef self.down\n\t\tend\n\tend\n\nsnippet trc\n\tt.remove :${1:column}\nsnippet tre\n\tt.rename :${1:old_column_name}, :${2:new_column_name}\n\t${3}\nsnippet tref\n\tt.references :${1:model}\n\n#rspec\nsnippet it\n\tit \"${1:spec_name}\" do\n\t\t${2}\n\tend\nsnippet itp\n\tit \"${1:spec_name}\"\n\t${2}\nsnippet desc\n\tdescribe ${1:class_name} do\n\t\t${2}\n\tend\nsnippet cont\n\tcontext \"${1:message}\" do\n\t\t${2}\n\tend\nsnippet bef\n\tbefore :${1:each} do\n\t\t${2}\n\tend\nsnippet aft\n\tafter :${1:each} do\n\t\t${2}\n\tend\n";

});

define("ace/snippets/ruby",["require","exports","module","ace/snippets/ruby.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./ruby.snippets");
exports.scope = "ruby";

});

define("ace/snippets/sh.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# Shebang. Executing bash via /usr/bin/env makes scripts more portable.\nsnippet #!\n\t#!/usr/bin/env bash\n\t\nsnippet if\n\tif [[ ${1:condition} ]]; then\n\t\t${2:#statements}\n\tfi\nsnippet elif\n\telif [[ ${1:condition} ]]; then\n\t\t${2:#statements}\nsnippet for\n\tfor (( ${2:i} = 0; $2 < ${1:count}; $2++ )); do\n\t\t${3:#statements}\n\tdone\nsnippet fori\n\tfor ${1:needle} in ${2:haystack} ; do\n\t\t${3:#statements}\n\tdone\nsnippet wh\n\twhile [[ ${1:condition} ]]; do\n\t\t${2:#statements}\n\tdone\nsnippet until\n\tuntil [[ ${1:condition} ]]; do\n\t\t${2:#statements}\n\tdone\nsnippet case\n\tcase ${1:word} in\n\t\t${2:pattern})\n\t\t\t${3};;\n\tesac\nsnippet go \n\twhile getopts '${1:o}' ${2:opts} \n\tdo \n\t\tcase $$2 in\n\t\t${3:o0})\n\t\t\t${4:#staments};;\n\t\tesac\n\tdone\n# Set SCRIPT_DIR variable to directory script is located.\nsnippet sdir\n\tSCRIPT_DIR=\"$( cd \"$( dirname \"${BASH_SOURCE[0]}\" )\" && pwd )\"\n# getopt\nsnippet getopt\n\t__ScriptVersion=\"${1:version}\"\n\n\t#===  FUNCTION  ================================================================\n\t#         NAME:  usage\n\t#  DESCRIPTION:  Display usage information.\n\t#===============================================================================\n\tfunction usage ()\n\t{\n\t\t\tcat <<- EOT\n\n\t  Usage :  $${0:0} [options] [--] \n\n\t  Options: \n\t  -h|help       Display this message\n\t  -v|version    Display script version\n\n\tEOT\n\t}    # ----------  end of function usage  ----------\n\n\t#-----------------------------------------------------------------------\n\t#  Handle command line arguments\n\t#-----------------------------------------------------------------------\n\n\twhile getopts \":hv\" opt\n\tdo\n\t  case $opt in\n\n\t\th|help     )  usage; exit 0   ;;\n\n\t\tv|version  )  echo \"$${0:0} -- Version $__ScriptVersion\"; exit 0   ;;\n\n\t\t\\? )  echo -e \"\\n  Option does not exist : $OPTARG\\n\"\n\t\t\t  usage; exit 1   ;;\n\n\t  esac    # --- end of case ---\n\tdone\n\tshift $(($OPTIND-1))\n\n";

});

define("ace/snippets/sh",["require","exports","module","ace/snippets/sh.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./sh.snippets");
exports.scope = "sh";

});

define("ace/snippets/sql.snippets",["require","exports","module"], function(require, exports, module){module.exports = "snippet tbl\n\tcreate table ${1:table} (\n\t\t${2:columns}\n\t);\nsnippet col\n\t${1:name}\t${2:type}\t${3:default ''}\t${4:not null}\nsnippet ccol\n\t${1:name}\tvarchar2(${2:size})\t${3:default ''}\t${4:not null}\nsnippet ncol\n\t${1:name}\tnumber\t${3:default 0}\t${4:not null}\nsnippet dcol\n\t${1:name}\tdate\t${3:default sysdate}\t${4:not null}\nsnippet ind\n\tcreate index ${3:$1_$2} on ${1:table}(${2:column});\nsnippet uind\n\tcreate unique index ${1:name} on ${2:table}(${3:column});\nsnippet tblcom\n\tcomment on table ${1:table} is '${2:comment}';\nsnippet colcom\n\tcomment on column ${1:table}.${2:column} is '${3:comment}';\nsnippet addcol\n\talter table ${1:table} add (${2:column} ${3:type});\nsnippet seq\n\tcreate sequence ${1:name} start with ${2:1} increment by ${3:1} minvalue ${4:1};\nsnippet s*\n\tselect * from ${1:table}\n";

});

define("ace/snippets/sql",["require","exports","module","ace/snippets/sql.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./sql.snippets");
exports.scope = "sql";

});

define("ace/snippets/sqlserver.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# ISNULL\nsnippet isnull\n\tISNULL(${1:check_expression}, ${2:replacement_value})\n# FORMAT\nsnippet format\n\tFORMAT(${1:value}, ${2:format})\n# CAST\nsnippet cast\n\tCAST(${1:expression} AS ${2:data_type})\n# CONVERT\nsnippet convert\n\tCONVERT(${1:data_type}, ${2:expression})\n# DATEPART\nsnippet datepart\n\tDATEPART(${1:datepart}, ${2:date})\n# DATEDIFF\nsnippet datediff\n\tDATEDIFF(${1:datepart}, ${2:startdate}, ${3:enddate})\n# DATEADD\nsnippet dateadd\n\tDATEADD(${1:datepart}, ${2:number}, ${3:date})\n# DATEFROMPARTS \nsnippet datefromparts\n\tDATEFROMPARTS(${1:year}, ${2:month}, ${3:day})\n# OBJECT_DEFINITION\nsnippet objectdef\n\tSELECT OBJECT_DEFINITION(OBJECT_ID('${1:sys.server_permissions /*object name*/}'))\n# STUFF XML\nsnippet stuffxml\n\tSTUFF((SELECT ', ' + ${1:ColumnName}\n\t\tFROM ${2:TableName}\n\t\tWHERE ${3:WhereClause}\n\t\tFOR XML PATH('')), 1, 1, '') AS ${4:Alias}\n\t${5:/*https://msdn.microsoft.com/en-us/library/ms188043.aspx*/}\n# Create Procedure\nsnippet createproc\n\t-- =============================================\n\t-- Author:\t\t${1:Author}\n\t-- Create date: ${2:Date}\n\t-- Description:\t${3:Description}\n\t-- =============================================\n\tCREATE PROCEDURE ${4:Procedure_Name}\n\t\t${5:/*Add the parameters for the stored procedure here*/}\n\tAS\n\tBEGIN\n\t\t-- SET NOCOUNT ON added to prevent extra result sets from interfering with SELECT statements.\n\t\tSET NOCOUNT ON;\n\t\t\n\t\t${6:/*Add the T-SQL statements to compute the return value here*/}\n\t\t\n\tEND\n\tGO\n# Create Scalar Function\nsnippet createfn\n\t-- =============================================\n\t-- Author:\t\t${1:Author}\n\t-- Create date: ${2:Date}\n\t-- Description:\t${3:Description}\n\t-- =============================================\n\tCREATE FUNCTION ${4:Scalar_Function_Name}\n\t\t-- Add the parameters for the function here\n\tRETURNS ${5:Function_Data_Type}\n\tAS\n\tBEGIN\n\t\tDECLARE @Result ${5:Function_Data_Type}\n\t\t\n\t\t${6:/*Add the T-SQL statements to compute the return value here*/}\n\t\t\n\tEND\n\tGO";

});

define("ace/snippets/sqlserver",["require","exports","module","ace/snippets/sqlserver.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./sqlserver.snippets");
exports.scope = "sqlserver";

});

define("ace/snippets/tcl.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# #!/usr/bin/env tclsh\nsnippet #!\n\t#!/usr/bin/env tclsh\n\t\n# Process\nsnippet pro\n\tproc ${1:function_name} {${2:args}} {\n\t\t${3:#body ...}\n\t}\n#xif\nsnippet xif\n\t${1:expr}? ${2:true} : ${3:false}\n# Conditional\nsnippet if\n\tif {${1}} {\n\t\t${2:# body...}\n\t}\n# Conditional if..else\nsnippet ife\n\tif {${1}} {\n\t\t${2:# body...}\n\t} else {\n\t\t${3:# else...}\n\t}\n# Conditional if..elsif..else\nsnippet ifee\n\tif {${1}} {\n\t\t${2:# body...}\n\t} elseif {${3}} {\n\t\t${4:# elsif...}\n\t} else {\n\t\t${5:# else...}\n\t}\n# If catch then\nsnippet ifc\n\tif { [catch {${1:#do something...}} ${2:err}] } {\n\t\t${3:# handle failure...}\n\t}\n# Catch\nsnippet catch\n\tcatch {${1}} ${2:err} ${3:options}\n# While Loop\nsnippet wh\n\twhile {${1}} {\n\t\t${2:# body...}\n\t}\n# For Loop\nsnippet for\n\tfor {set ${2:var} 0} {$$2 < ${1:count}} {${3:incr} $2} {\n\t\t${4:# body...}\n\t}\n# Foreach Loop\nsnippet fore\n\tforeach ${1:x} {${2:#list}} {\n\t\t${3:# body...}\n\t}\n# after ms script...\nsnippet af\n\tafter ${1:ms} ${2:#do something}\n# after cancel id\nsnippet afc\n\tafter cancel ${1:id or script}\n# after idle\nsnippet afi\n\tafter idle ${1:script}\n# after info id\nsnippet afin\n\tafter info ${1:id}\n# Expr\nsnippet exp\n\texpr {${1:#expression here}}\n# Switch\nsnippet sw\n\tswitch ${1:var} {\n\t\t${3:pattern 1} {\n\t\t\t${4:#do something}\n\t\t}\n\t\tdefault {\n\t\t\t${2:#do something}\n\t\t}\n\t}\n# Case\nsnippet ca\n\t${1:pattern} {\n\t\t${2:#do something}\n\t}${3}\n# Namespace eval\nsnippet ns\n\tnamespace eval ${1:path} {${2:#script...}}\n# Namespace current\nsnippet nsc\n\tnamespace current\n";

});

define("ace/snippets/tcl",["require","exports","module","ace/snippets/tcl.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./tcl.snippets");
exports.scope = "tcl";

});

define("ace/snippets/tex.snippets",["require","exports","module"], function(require, exports, module){module.exports = "#PREAMBLE\n#newcommand\nsnippet nc\n\t\\newcommand{\\${1:cmd}}[${2:opt}]{${3:realcmd}}${4}\n#usepackage\nsnippet up\n\t\\usepackage[${1:[options}]{${2:package}}\n#newunicodechar\nsnippet nuc\n\t\\newunicodechar{${1}}{${2:\\ensuremath}${3:tex-substitute}}}\n#DeclareMathOperator\nsnippet dmo\n\t\\DeclareMathOperator{${1}}{${2}}\n\n#DOCUMENT\n# \\begin{}...\\end{}\nsnippet begin\n\t\\begin{${1:env}}\n\t\t${2}\n\t\\end{$1}\n# Tabular\nsnippet tab\n\t\\begin{${1:tabular}}{${2:c}}\n\t${3}\n\t\\end{$1}\nsnippet thm\n\t\\begin[${1:author}]{${2:thm}}\n\t${3}\n\t\\end{$1}\nsnippet center\n\t\\begin{center}\n\t\t${1}\n\t\\end{center}\n# Align(ed)\nsnippet ali\n\t\\begin{align${1:ed}}\n\t\t${2}\n\t\\end{align$1}\n# Gather(ed)\nsnippet gat\n\t\\begin{gather${1:ed}}\n\t\t${2}\n\t\\end{gather$1}\n# Equation\nsnippet eq\n\t\\begin{equation}\n\t\t${1}\n\t\\end{equation}\n# Equation\nsnippet eq*\n\t\\begin{equation*}\n\t\t${1}\n\t\\end{equation*}\n# Unnumbered Equation\nsnippet \\\n\t\\[\n\t\t${1}\n\t\\]\n# Enumerate\nsnippet enum\n\t\\begin{enumerate}\n\t\t\\item ${1}\n\t\\end{enumerate}\n# Itemize\nsnippet itemize\n\t\\begin{itemize}\n\t\t\\item ${1}\n\t\\end{itemize}\n# Description\nsnippet desc\n\t\\begin{description}\n\t\t\\item[${1}] ${2}\n\t\\end{description}\n# Matrix\nsnippet mat\n\t\\begin{${1:p/b/v/V/B/small}matrix}\n\t\t${2}\n\t\\end{$1matrix}\n# Cases\nsnippet cas\n\t\\begin{cases}\n\t\t${1:equation}, &\\text{ if }${2:case}\\\\\n\t\t${3}\n\t\\end{cases}\n# Split\nsnippet spl\n\t\\begin{split}\n\t\t${1}\n\t\\end{split}\n# Part\nsnippet part\n\t\\part{${1:part name}} % (fold)\n\t\\label{prt:${2:$1}}\n\t${3}\n\t% part $2 (end)\n# Chapter\nsnippet cha\n\t\\chapter{${1:chapter name}}\n\t\\label{cha:${2:$1}}\n\t${3}\n# Section\nsnippet sec\n\t\\section{${1:section name}}\n\t\\label{sec:${2:$1}}\n\t${3}\n# Sub Section\nsnippet sub\n\t\\subsection{${1:subsection name}}\n\t\\label{sub:${2:$1}}\n\t${3}\n# Sub Sub Section\nsnippet subs\n\t\\subsubsection{${1:subsubsection name}}\n\t\\label{ssub:${2:$1}}\n\t${3}\n# Paragraph\nsnippet par\n\t\\paragraph{${1:paragraph name}}\n\t\\label{par:${2:$1}}\n\t${3}\n# Sub Paragraph\nsnippet subp\n\t\\subparagraph{${1:subparagraph name}}\n\t\\label{subp:${2:$1}}\n\t${3}\n#References\nsnippet itd\n\t\\item[${1:description}] ${2:item}\nsnippet figure\n\t${1:Figure}~\\ref{${2:fig:}}${3}\nsnippet table\n\t${1:Table}~\\ref{${2:tab:}}${3}\nsnippet listing\n\t${1:Listing}~\\ref{${2:list}}${3}\nsnippet section\n\t${1:Section}~\\ref{${2:sec:}}${3}\nsnippet page\n\t${1:page}~\\pageref{${2}}${3}\nsnippet index\n\t\\index{${1:index}}${2}\n#Citations\nsnippet cite\n\t\\cite[${1}]{${2}}${3}\nsnippet fcite\n\t\\footcite[${1}]{${2}}${3}\n#Formating text: italic, bold, underline, small capital, emphase ..\nsnippet it\n\t\\textit{${1:text}}\nsnippet bf\n\t\\textbf{${1:text}}\nsnippet under\n\t\\underline{${1:text}}\nsnippet emp\n\t\\emph{${1:text}}\nsnippet sc\n\t\\textsc{${1:text}}\n#Choosing font\nsnippet sf\n\t\\textsf{${1:text}}\nsnippet rm\n\t\\textrm{${1:text}}\nsnippet tt\n\t\\texttt{${1:text}}\n#misc\nsnippet ft\n\t\\footnote{${1:text}}\nsnippet fig\n\t\\begin{figure}\n\t\\begin{center}\n\t    \\includegraphics[scale=${1}]{Figures/${2}}\n\t\\end{center}\n\t\\caption{${3}}\n\t\\label{fig:${4}}\n\t\\end{figure}\nsnippet tikz\n\t\\begin{figure}\n\t\\begin{center}\n\t\\begin{tikzpicture}[scale=${1:1}]\n\t\t${2}\n\t\\end{tikzpicture}\n\t\\end{center}\n\t\\caption{${3}}\n\t\\label{fig:${4}}\n\t\\end{figure}\n#math\nsnippet stackrel\n\t\\stackrel{${1:above}}{${2:below}} ${3}\nsnippet frac\n\t\\frac{${1:num}}{${2:denom}}\nsnippet sum\n\t\\sum^{${1:n}}_{${2:i=1}}{${3}}";

});

define("ace/snippets/tex",["require","exports","module","ace/snippets/tex.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./tex.snippets");
exports.scope = "tex";

});

define("ace/snippets/textile.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# Jekyll post header\nsnippet header\n\t---\n\ttitle: ${1:title}\n\tlayout: post\n\tdate: ${2:date} ${3:hour:minute:second} -05:00\n\t---\n\n# Image\nsnippet img\n\t!${1:url}(${2:title}):${3:link}!\n\n# Table\nsnippet |\n\t|${1}|${2}\n\n# Link\nsnippet link\n\t\"${1:link text}\":${2:url}\n\n# Acronym\nsnippet (\n\t(${1:Expand acronym})${2}\n\n# Footnote\nsnippet fn\n\t[${1:ref number}] ${3}\n\n\tfn$1. ${2:footnote}\n\t\n";

});

define("ace/snippets/textile",["require","exports","module","ace/snippets/textile.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./textile.snippets");
exports.scope = "textile";

});

define("ace/snippets/velocity.snippets",["require","exports","module"], function(require, exports, module){module.exports = "# macro\nsnippet #macro\n\t#macro ( ${1:macroName} ${2:\\$var1, [\\$var2, ...]} )\n\t\t${3:## macro code}\n\t#end\n# foreach\nsnippet #foreach\n\t#foreach ( ${1:\\$item} in ${2:\\$collection} )\n\t\t${3:## foreach code}\n\t#end\n# if\nsnippet #if\n\t#if ( ${1:true} )\n\t\t${0}\n\t#end\n# if ... else\nsnippet #ife\n\t#if ( ${1:true} )\n\t\t${2}\n\t#else\n\t\t${0}\n\t#end\n#import\nsnippet #import\n\t#import ( \"${1:path/to/velocity/format}\" )\n# set\nsnippet #set\n\t#set ( $${1:var} = ${0} )\n";

});

define("ace/snippets/velocity",["require","exports","module","ace/snippets/velocity.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./velocity.snippets");
exports.scope = "velocity";
exports.includeScopes = ["html", "javascript", "css"];

});

define("ace/snippets/wollok.snippets",["require","exports","module"], function(require, exports, module){module.exports = "##\n## Basic Java packages and import\nsnippet im\n\timport\nsnippet w.l\n\twollok.lang\nsnippet w.i\n\twollok.lib\n\n## Class and object\nsnippet cl\n\tclass ${1:`Filename(\"\", \"untitled\")`} ${2}\nsnippet obj\n\tobject ${1:`Filename(\"\", \"untitled\")`} ${2:inherits Parent}${3}\nsnippet te\n\ttest ${1:`Filename(\"\", \"untitled\")`}\n\n##\n## Enhancements\nsnippet inh\n\tinherits\n\n##\n## Comments\nsnippet /*\n\t/*\n\t * ${1}\n\t */\n\n##\n## Control Statements\nsnippet el\n\telse\nsnippet if\n\tif (${1}) ${2}\n\n##\n## Create a Method\nsnippet m\n\tmethod ${1:method}(${2}) ${5}\n\n##  \n## Tests\nsnippet as\n\tassert.equals(${1:expected}, ${2:actual})\n\n##\n## Exceptions\nsnippet ca\n\tcatch ${1:e} : (${2:Exception} ) ${3}\nsnippet thr\n\tthrow\nsnippet try\n\ttry {\n\t\t${3}\n\t} catch ${1:e} : ${2:Exception} {\n\t}\n\n##\n## Javadocs\nsnippet /**\n\t/**\n\t * ${1}\n\t */\n\n##\n## Print Methods\nsnippet print\n\tconsole.println(\"${1:Message}\")\n\n##\n## Setter and Getter Methods\nsnippet set\n\tmethod set${1:}(${2:}) {\n\t\t$1 = $2\n\t}\nsnippet get\n\tmethod get${1:}() {\n\t\treturn ${1:};\n\t}\n\n##\n## Terminate Methods or Loops\nsnippet re\n\treturn";

});

define("ace/snippets/wollok",["require","exports","module","ace/snippets/wollok.snippets"], function(require, exports, module){"use strict";
exports.snippetText = require("./wollok.snippets");
exports.scope = "wollok";

});

define("ace/range",["require","exports","module"], function(require, exports, module){"use strict";
var comparePoints = function (p1, p2) {
    return p1.row - p2.row || p1.column - p2.column;
};
var Range = /** @class */ (function () {
    function Range(startRow, startColumn, endRow, endColumn) {
        this.start = {
            row: startRow,
            column: startColumn
        };
        this.end = {
            row: endRow,
            column: endColumn
        };
    }
    Range.prototype.isEqual = function (range) {
        return this.start.row === range.start.row &&
            this.end.row === range.end.row &&
            this.start.column === range.start.column &&
            this.end.column === range.end.column;
    };
    Range.prototype.toString = function () {
        return ("Range: [" + this.start.row + "/" + this.start.column +
            "] -> [" + this.end.row + "/" + this.end.column + "]");
    };
    Range.prototype.contains = function (row, column) {
        return this.compare(row, column) == 0;
    };
    Range.prototype.compareRange = function (range) {
        var cmp, end = range.end, start = range.start;
        cmp = this.compare(end.row, end.column);
        if (cmp == 1) {
            cmp = this.compare(start.row, start.column);
            if (cmp == 1) {
                return 2;
            }
            else if (cmp == 0) {
                return 1;
            }
            else {
                return 0;
            }
        }
        else if (cmp == -1) {
            return -2;
        }
        else {
            cmp = this.compare(start.row, start.column);
            if (cmp == -1) {
                return -1;
            }
            else if (cmp == 1) {
                return 42;
            }
            else {
                return 0;
            }
        }
    };
    Range.prototype.comparePoint = function (p) {
        return this.compare(p.row, p.column);
    };
    Range.prototype.containsRange = function (range) {
        return this.comparePoint(range.start) == 0 && this.comparePoint(range.end) == 0;
    };
    Range.prototype.intersects = function (range) {
        var cmp = this.compareRange(range);
        return (cmp == -1 || cmp == 0 || cmp == 1);
    };
    Range.prototype.isEnd = function (row, column) {
        return this.end.row == row && this.end.column == column;
    };
    Range.prototype.isStart = function (row, column) {
        return this.start.row == row && this.start.column == column;
    };
    Range.prototype.setStart = function (row, column) {
        if (typeof row == "object") {
            this.start.column = row.column;
            this.start.row = row.row;
        }
        else {
            this.start.row = row;
            this.start.column = column;
        }
    };
    Range.prototype.setEnd = function (row, column) {
        if (typeof row == "object") {
            this.end.column = row.column;
            this.end.row = row.row;
        }
        else {
            this.end.row = row;
            this.end.column = column;
        }
    };
    Range.prototype.inside = function (row, column) {
        if (this.compare(row, column) == 0) {
            if (this.isEnd(row, column) || this.isStart(row, column)) {
                return false;
            }
            else {
                return true;
            }
        }
        return false;
    };
    Range.prototype.insideStart = function (row, column) {
        if (this.compare(row, column) == 0) {
            if (this.isEnd(row, column)) {
                return false;
            }
            else {
                return true;
            }
        }
        return false;
    };
    Range.prototype.insideEnd = function (row, column) {
        if (this.compare(row, column) == 0) {
            if (this.isStart(row, column)) {
                return false;
            }
            else {
                return true;
            }
        }
        return false;
    };
    Range.prototype.compare = function (row, column) {
        if (!this.isMultiLine()) {
            if (row === this.start.row) {
                return column < this.start.column ? -1 : (column > this.end.column ? 1 : 0);
            }
        }
        if (row < this.start.row)
            return -1;
        if (row > this.end.row)
            return 1;
        if (this.start.row === row)
            return column >= this.start.column ? 0 : -1;
        if (this.end.row === row)
            return column <= this.end.column ? 0 : 1;
        return 0;
    };
    Range.prototype.compareStart = function (row, column) {
        if (this.start.row == row && this.start.column == column) {
            return -1;
        }
        else {
            return this.compare(row, column);
        }
    };
    Range.prototype.compareEnd = function (row, column) {
        if (this.end.row == row && this.end.column == column) {
            return 1;
        }
        else {
            return this.compare(row, column);
        }
    };
    Range.prototype.compareInside = function (row, column) {
        if (this.end.row == row && this.end.column == column) {
            return 1;
        }
        else if (this.start.row == row && this.start.column == column) {
            return -1;
        }
        else {
            return this.compare(row, column);
        }
    };
    Range.prototype.clipRows = function (firstRow, lastRow) {
        if (this.end.row > lastRow)
            var end = { row: lastRow + 1, column: 0 };
        else if (this.end.row < firstRow)
            var end = { row: firstRow, column: 0 };
        if (this.start.row > lastRow)
            var start = { row: lastRow + 1, column: 0 };
        else if (this.start.row < firstRow)
            var start = { row: firstRow, column: 0 };
        return Range.fromPoints(start || this.start, end || this.end);
    };
    Range.prototype.extend = function (row, column) {
        var cmp = this.compare(row, column);
        if (cmp == 0)
            return this;
        else if (cmp == -1)
            var start = { row: row, column: column };
        else
            var end = { row: row, column: column };
        return Range.fromPoints(start || this.start, end || this.end);
    };
    Range.prototype.isEmpty = function () {
        return (this.start.row === this.end.row && this.start.column === this.end.column);
    };
    Range.prototype.isMultiLine = function () {
        return (this.start.row !== this.end.row);
    };
    Range.prototype.clone = function () {
        return Range.fromPoints(this.start, this.end);
    };
    Range.prototype.collapseRows = function () {
        if (this.end.column == 0)
            return new Range(this.start.row, 0, Math.max(this.start.row, this.end.row - 1), 0);
        else
            return new Range(this.start.row, 0, this.end.row, 0);
    };
    Range.prototype.toScreenRange = function (session) {
        var screenPosStart = session.documentToScreenPosition(this.start);
        var screenPosEnd = session.documentToScreenPosition(this.end);
        return new Range(screenPosStart.row, screenPosStart.column, screenPosEnd.row, screenPosEnd.column);
    };
    Range.prototype.moveBy = function (row, column) {
        this.start.row += row;
        this.start.column += column;
        this.end.row += row;
        this.end.column += column;
    };
    return Range;
}());
Range.fromPoints = function (start, end) {
    return new Range(start.row, start.column, end.row, end.column);
};
Range.comparePoints = comparePoints;
Range.comparePoints = function (p1, p2) {
    return p1.row - p2.row || p1.column - p2.column;
};
exports.Range = Range;

});

define("ace/mode/text_highlight_rules",["require","exports","module","ace/lib/deep_copy"], function(require, exports, module){"use strict";
var deepCopy = require("../lib/deep_copy").deepCopy;
var TextHighlightRules = function () {
    this.$rules = {
        "start": [{
                token: "empty_line",
                regex: '^$'
            }, {
                defaultToken: "text"
            }]
    };
};
(function () {
    this.addRules = function (rules, prefix) {
        if (!prefix) {
            for (var key in rules)
                this.$rules[key] = rules[key];
            return;
        }
        for (var key in rules) {
            var state = rules[key];
            for (var i = 0; i < state.length; i++) {
                var rule = state[i];
                if (rule.next || rule.onMatch) {
                    if (typeof rule.next == "string") {
                        if (rule.next.indexOf(prefix) !== 0)
                            rule.next = prefix + rule.next;
                    }
                    if (rule.nextState && rule.nextState.indexOf(prefix) !== 0)
                        rule.nextState = prefix + rule.nextState;
                }
            }
            this.$rules[prefix + key] = state;
        }
    };
    this.getRules = function () {
        return this.$rules;
    };
    this.embedRules = function (HighlightRules, prefix, escapeRules, states, append) {
        var embedRules = typeof HighlightRules == "function"
            ? new HighlightRules().getRules()
            : HighlightRules;
        if (states) {
            for (var i = 0; i < states.length; i++)
                states[i] = prefix + states[i];
        }
        else {
            states = [];
            for (var key in embedRules)
                states.push(prefix + key);
        }
        this.addRules(embedRules, prefix);
        if (escapeRules) {
            var addRules = Array.prototype[append ? "push" : "unshift"];
            for (var i = 0; i < states.length; i++)
                addRules.apply(this.$rules[states[i]], deepCopy(escapeRules));
        }
        if (!this.$embeds)
            this.$embeds = [];
        this.$embeds.push(prefix);
    };
    this.getEmbeds = function () {
        return this.$embeds;
    };
    var pushState = function (currentState, stack) {
        if (currentState != "start" || stack.length)
            stack.unshift(this.nextState, currentState);
        return this.nextState;
    };
    var popState = function (currentState, stack) {
        stack.shift();
        return stack.shift() || "start";
    };
    this.normalizeRules = function () {
        var id = 0;
        var rules = this.$rules;
        function processState(key) {
            var state = rules[key];
            state.processed = true;
            for (var i = 0; i < state.length; i++) {
                var rule = state[i];
                var toInsert = null;
                if (Array.isArray(rule)) {
                    toInsert = rule;
                    rule = {};
                }
                if (!rule.regex && rule.start) {
                    rule.regex = rule.start;
                    if (!rule.next)
                        rule.next = [];
                    rule.next.push({
                        defaultToken: rule.token
                    }, {
                        token: rule.token + ".end",
                        regex: rule.end || rule.start,
                        next: "pop"
                    });
                    rule.token = rule.token + ".start";
                    rule.push = true;
                }
                var next = rule.next || rule.push;
                if (next && Array.isArray(next)) {
                    var stateName = rule.stateName;
                    if (!stateName) {
                        stateName = rule.token;
                        if (typeof stateName != "string")
                            stateName = stateName[0] || "";
                        if (rules[stateName])
                            stateName += id++;
                    }
                    rules[stateName] = next;
                    rule.next = stateName;
                    processState(stateName);
                }
                else if (next == "pop") {
                    rule.next = popState;
                }
                if (rule.push) {
                    rule.nextState = rule.next || rule.push;
                    rule.next = pushState;
                    delete rule.push;
                }
                if (rule.rules) {
                    for (var r in rule.rules) {
                        if (rules[r]) {
                            if (rules[r].push)
                                rules[r].push.apply(rules[r], rule.rules[r]);
                        }
                        else {
                            rules[r] = rule.rules[r];
                        }
                    }
                }
                var includeName = typeof rule == "string" ? rule : rule.include;
                if (includeName) {
                    if (includeName === "$self")
                        includeName = "start";
                    if (Array.isArray(includeName))
                        toInsert = includeName.map(function (x) { return rules[x]; });
                    else
                        toInsert = rules[includeName];
                }
                if (toInsert) {
                    var args = [i, 1].concat(toInsert);
                    if (rule.noEscape)
                        args = args.filter(function (x) { return !x.next; });
                    state.splice.apply(state, args);
                    i--;
                }
                if (rule.keywordMap) {
                    rule.token = this.createKeywordMapper(rule.keywordMap, rule.defaultToken || "text", rule.caseInsensitive);
                    delete rule.defaultToken;
                }
            }
        }
        Object.keys(rules).forEach(processState, this);
    };
    this.createKeywordMapper = function (map, defaultToken, ignoreCase, splitChar) {
        var keywords = Object.create(null);
        this.$keywordList = [];
        Object.keys(map).forEach(function (className) {
            var a = map[className];
            var list = a.split(splitChar || "|");
            for (var i = list.length; i--;) {
                var word = list[i];
                this.$keywordList.push(word);
                if (ignoreCase)
                    word = word.toLowerCase();
                keywords[word] = className;
            }
        }, this);
        map = null;
        return ignoreCase
            ? function (value) { return keywords[value.toLowerCase()] || defaultToken; }
            : function (value) { return keywords[value] || defaultToken; };
    };
    this.getKeywords = function () {
        return this.$keywords;
    };
}).call(TextHighlightRules.prototype);
exports.TextHighlightRules = TextHighlightRules;

});

define("ace/mode/abap_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){/*
 * based on
 * " Vim ABAP syntax file
 * "    Language: SAP - ABAP/R4
 * "    Revision: 2.1
 * "  Maintainer: Marius Piedallu van Wyk <lailoken@gmail.com>
 * " Last Change: 2012 Oct 23
 */
"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var AbapHighlightRules = function () {
    var keywordMapper = this.createKeywordMapper({
        "variable.language": "this",
        "keyword": "ADD ALIAS ALIASES ASCENDING ASSERT ASSIGN ASSIGNING AT BACK" +
            " CALL CASE CATCH CHECK CLASS CLEAR CLOSE CNT COLLECT COMMIT COMMUNICATION COMPUTE CONCATENATE CONDENSE CONSTANTS CONTINUE CONTROLS CONVERT CREATE CURRENCY" +
            " DATA DEFINE DEFINITION DEFERRED DELETE DESCENDING DESCRIBE DETAIL DIVIDE DO" +
            " ELSE ELSEIF ENDAT ENDCASE ENDCLASS ENDDO ENDEXEC ENDFORM ENDFUNCTION ENDIF ENDIFEND ENDINTERFACE ENDLOOP ENDMETHOD ENDMODULE ENDON ENDPROVIDE ENDSELECT ENDTRY ENDWHILE EVENT EVENTS EXEC EXIT EXPORT EXPORTING EXTRACT" +
            " FETCH FIELDS FORM FORMAT FREE FROM FUNCTION" +
            " GENERATE GET" +
            " HIDE" +
            " IF IMPORT IMPORTING INDEX INFOTYPES INITIALIZATION INTERFACE INTERFACES INPUT INSERT IMPLEMENTATION" +
            " LEAVE LIKE LINE LOAD LOCAL LOOP" +
            " MESSAGE METHOD METHODS MODIFY MODULE MOVE MULTIPLY" +
            " ON OVERLAY OPTIONAL OTHERS" +
            " PACK PARAMETERS PERFORM POSITION PROGRAM PROVIDE PUT" +
            " RAISE RANGES READ RECEIVE RECEIVING REDEFINITION REFERENCE REFRESH REJECT REPLACE REPORT RESERVE RESTORE RETURN RETURNING ROLLBACK" +
            " SCAN SCROLL SEARCH SELECT SET SHIFT SKIP SORT SORTED SPLIT STANDARD STATICS STEP STOP SUBMIT SUBTRACT SUM SUMMARY SUPPRESS" +
            " TABLES TIMES TRANSFER TRANSLATE TRY TYPE TYPES" +
            " UNASSIGN ULINE UNPACK UPDATE" +
            " WHEN WHILE WINDOW WRITE" +
            " OCCURS STRUCTURE OBJECT PROPERTY" +
            " CASTING APPEND RAISING VALUE COLOR" +
            " CHANGING EXCEPTION EXCEPTIONS DEFAULT CHECKBOX COMMENT" +
            " ID NUMBER FOR TITLE OUTPUT" +
            " WITH EXIT USING" +
            " INTO WHERE GROUP BY HAVING ORDER BY SINGLE" +
            " APPENDING CORRESPONDING FIELDS OF TABLE" +
            " LEFT RIGHT OUTER INNER JOIN AS CLIENT SPECIFIED BYPASSING BUFFER UP TO ROWS CONNECTING" +
            " EQ NE LT LE GT GE NOT AND OR XOR IN LIKE BETWEEN",
        "constant.language": "TRUE FALSE NULL SPACE",
        "support.type": "c n i p f d t x string xstring decfloat16 decfloat34",
        "keyword.operator": "abs sign ceil floor trunc frac acos asin atan cos sin tan" +
            " abapOperator cosh sinh tanh exp log log10 sqrt" +
            " strlen xstrlen charlen numofchar dbmaxlen lines"
    }, "text", true, " ");
    var compoundKeywords = "WITH\\W+(?:HEADER\\W+LINE|FRAME|KEY)|NO\\W+STANDARD\\W+PAGE\\W+HEADING|" +
        "EXIT\\W+FROM\\W+STEP\\W+LOOP|BEGIN\\W+OF\\W+(?:BLOCK|LINE)|BEGIN\\W+OF|" +
        "END\\W+OF\\W+(?:BLOCK|LINE)|END\\W+OF|NO\\W+INTERVALS|" +
        "RESPECTING\\W+BLANKS|SEPARATED\\W+BY|USING\\W+(?:EDIT\\W+MASK)|" +
        "WHERE\\W+(?:LINE)|RADIOBUTTON\\W+GROUP|REF\\W+TO|" +
        "(?:PUBLIC|PRIVATE|PROTECTED)(?:\\W+SECTION)?|DELETING\\W+(?:TRAILING|LEADING)" +
        "(?:ALL\\W+OCCURRENCES)|(?:FIRST|LAST)\\W+OCCURRENCE|INHERITING\\W+FROM|" +
        "LINE-COUNT|ADD-CORRESPONDING|AUTHORITY-CHECK|BREAK-POINT|CLASS-DATA|CLASS-METHODS|" +
        "CLASS-METHOD|DIVIDE-CORRESPONDING|EDITOR-CALL|END-OF-DEFINITION|END-OF-PAGE|END-OF-SELECTION|" +
        "FIELD-GROUPS|FIELD-SYMBOLS|FUNCTION-POOL|MOVE-CORRESPONDING|MULTIPLY-CORRESPONDING|NEW-LINE|" +
        "NEW-PAGE|NEW-SECTION|PRINT-CONTROL|RP-PROVIDE-FROM-LAST|SELECT-OPTIONS|SELECTION-SCREEN|" +
        "START-OF-SELECTION|SUBTRACT-CORRESPONDING|SYNTAX-CHECK|SYNTAX-TRACE|TOP-OF-PAGE|TYPE-POOL|" +
        "TYPE-POOLS|LINE-SIZE|LINE-COUNT|MESSAGE-ID|DISPLAY-MODE|READ(?:-ONLY)?|" +
        "IS\\W+(?:NOT\\W+)?(?:ASSIGNED|BOUND|INITIAL|SUPPLIED)";
    this.$rules = {
        "start": [
            { token: "string", regex: "`", next: "string" },
            { token: "string", regex: "'", next: "qstring" },
            { token: "doc.comment", regex: /^\*.+/ },
            { token: "comment", regex: /".+$/ },
            { token: "invalid", regex: "\\.{2,}" },
            { token: "keyword.operator", regex: /\W[\-+%=<>*]\W|\*\*|[~:,\.&$]|->*?|=>/ },
            { token: "paren.lparen", regex: "[\\[({]" },
            { token: "paren.rparen", regex: "[\\])}]" },
            { token: "constant.numeric", regex: "[+-]?\\d+\\b" },
            { token: "variable.parameter", regex: /sy|pa?\d\d\d\d\|t\d\d\d\.|innnn/ },
            { token: "keyword", regex: compoundKeywords },
            { token: "variable.parameter", regex: /\w+-\w[\-\w]*/ },
            { token: keywordMapper, regex: "\\b\\w+\\b" },
            { caseInsensitive: true }
        ],
        "qstring": [
            { token: "constant.language.escape", regex: "''" },
            { token: "string", regex: "'", next: "start" },
            { defaultToken: "string" }
        ],
        "string": [
            { token: "constant.language.escape", regex: "``" },
            { token: "string", regex: "`", next: "start" },
            { defaultToken: "string" }
        ]
    };
};
oop.inherits(AbapHighlightRules, TextHighlightRules);
exports.AbapHighlightRules = AbapHighlightRules;

});

define("ace/mode/folding/fold_mode",["require","exports","module","ace/range"], function(require, exports, module){"use strict";
var Range = require("../../range").Range;
var FoldMode = exports.FoldMode = function () { };
(function () {
    this.foldingStartMarker = null;
    this.foldingStopMarker = null;
    this.getFoldWidget = function (session, foldStyle, row) {
        var line = session.getLine(row);
        if (this.foldingStartMarker.test(line))
            return "start";
        if (foldStyle == "markbeginend"
            && this.foldingStopMarker
            && this.foldingStopMarker.test(line))
            return "end";
        return "";
    };
    this.getFoldWidgetRange = function (session, foldStyle, row) {
        return null;
    };
    this.indentationBlock = function (session, row, column) {
        var re = /\S/;
        var line = session.getLine(row);
        var startLevel = line.search(re);
        if (startLevel == -1)
            return;
        var startColumn = column || line.length;
        var maxRow = session.getLength();
        var startRow = row;
        var endRow = row;
        while (++row < maxRow) {
            var level = session.getLine(row).search(re);
            if (level == -1)
                continue;
            if (level <= startLevel) {
                var token = session.getTokenAt(row, 0);
                if (!token || token.type !== "string")
                    break;
            }
            endRow = row;
        }
        if (endRow > startRow) {
            var endColumn = session.getLine(endRow).length;
            return new Range(startRow, startColumn, endRow, endColumn);
        }
    };
    this.openingBracketBlock = function (session, bracket, row, column, typeRe) {
        var start = { row: row, column: column + 1 };
        var end = session.$findClosingBracket(bracket, start, typeRe);
        if (!end)
            return;
        var fw = session.foldWidgets[end.row];
        if (fw == null)
            fw = session.getFoldWidget(end.row);
        if (fw == "start" && end.row > start.row) {
            end.row--;
            end.column = session.getLine(end.row).length;
        }
        return Range.fromPoints(start, end);
    };
    this.closingBracketBlock = function (session, bracket, row, column, typeRe) {
        var end = { row: row, column: column };
        var start = session.$findOpeningBracket(bracket, end);
        if (!start)
            return;
        start.column++;
        end.column--;
        return Range.fromPoints(start, end);
    };
}).call(FoldMode.prototype);

});

define("ace/mode/folding/coffee",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range"], function(require, exports, module){"use strict";
var oop = require("../../lib/oop");
var BaseFoldMode = require("./fold_mode").FoldMode;
var Range = require("../../range").Range;
var FoldMode = exports.FoldMode = function () { };
oop.inherits(FoldMode, BaseFoldMode);
(function () {
    this.getFoldWidgetRange = function (session, foldStyle, row) {
        var range = this.indentationBlock(session, row);
        if (range)
            return range;
        var re = /\S/;
        var line = session.getLine(row);
        var startLevel = line.search(re);
        if (startLevel == -1 || line[startLevel] != "#")
            return;
        var startColumn = line.length;
        var maxRow = session.getLength();
        var startRow = row;
        var endRow = row;
        while (++row < maxRow) {
            line = session.getLine(row);
            var level = line.search(re);
            if (level == -1)
                continue;
            if (line[level] != "#")
                break;
            endRow = row;
        }
        if (endRow > startRow) {
            var endColumn = session.getLine(endRow).length;
            return new Range(startRow, startColumn, endRow, endColumn);
        }
    };
    this.getFoldWidget = function (session, foldStyle, row) {
        var line = session.getLine(row);
        var indent = line.search(/\S/);
        var next = session.getLine(row + 1);
        var prev = session.getLine(row - 1);
        var prevIndent = prev.search(/\S/);
        var nextIndent = next.search(/\S/);
        if (indent == -1) {
            session.foldWidgets[row - 1] = prevIndent != -1 && prevIndent < nextIndent ? "start" : "";
            return "";
        }
        if (prevIndent == -1) {
            if (indent == nextIndent && line[indent] == "#" && next[indent] == "#") {
                session.foldWidgets[row - 1] = "";
                session.foldWidgets[row + 1] = "";
                return "start";
            }
        }
        else if (prevIndent == indent && line[indent] == "#" && prev[indent] == "#") {
            if (session.getLine(row - 2).search(/\S/) == -1) {
                session.foldWidgets[row - 1] = "start";
                session.foldWidgets[row + 1] = "";
                return "";
            }
        }
        if (prevIndent != -1 && prevIndent < indent)
            session.foldWidgets[row - 1] = "start";
        else
            session.foldWidgets[row - 1] = "";
        if (indent < nextIndent)
            return "start";
        else
            return "";
    };
}).call(FoldMode.prototype);

});

define("ace/tokenizer",["require","exports","module","ace/lib/report_error"], function(require, exports, module){"use strict";
var reportError = require("./lib/report_error").reportError;
var MAX_TOKEN_COUNT = 2000;
var Tokenizer = /** @class */ (function () {
    function Tokenizer(rules) {
        this.states = rules;
        this.regExps = {};
        this.matchMappings = {};
        for (var key in this.states) {
            var state = this.states[key];
            var ruleRegExps = [];
            var matchTotal = 0;
            var mapping = this.matchMappings[key] = { defaultToken: "text" };
            var flag = "g";
            var splitterRurles = [];
            for (var i = 0; i < state.length; i++) {
                var rule = state[i];
                if (rule.defaultToken)
                    mapping.defaultToken = rule.defaultToken;
                if (rule.caseInsensitive && flag.indexOf("i") === -1)
                    flag += "i";
                if (rule.unicode && flag.indexOf("u") === -1)
                    flag += "u";
                if (rule.regex == null)
                    continue;
                if (rule.regex instanceof RegExp)
                    rule.regex = rule.regex.toString().slice(1, -1);
                var adjustedregex = rule.regex;
                var matchcount = new RegExp("(?:(" + adjustedregex + ")|(.))").exec("a").length - 2;
                if (Array.isArray(rule.token)) {
                    if (rule.token.length == 1 || matchcount == 1) {
                        rule.token = rule.token[0];
                    }
                    else if (matchcount - 1 != rule.token.length) {
                        this.reportError("number of classes and regexp groups doesn't match", {
                            rule: rule,
                            groupCount: matchcount - 1
                        });
                        rule.token = rule.token[0];
                    }
                    else {
                        rule.tokenArray = rule.token;
                        rule.token = null;
                        rule.onMatch = this.$arrayTokens;
                    }
                }
                else if (typeof rule.token == "function" && !rule.onMatch) {
                    if (matchcount > 1)
                        rule.onMatch = this.$applyToken;
                    else
                        rule.onMatch = rule.token;
                }
                if (matchcount > 1) {
                    if (/\\\d/.test(rule.regex)) {
                        adjustedregex = rule.regex.replace(/\\([0-9]+)/g, function (match, digit) {
                            return "\\" + (parseInt(digit, 10) + matchTotal + 1);
                        });
                    }
                    else {
                        matchcount = 1;
                        adjustedregex = this.removeCapturingGroups(rule.regex);
                    }
                    if (!rule.splitRegex && typeof rule.token != "string")
                        splitterRurles.push(rule); // flag will be known only at the very end
                }
                mapping[matchTotal] = i;
                matchTotal += matchcount;
                ruleRegExps.push(adjustedregex);
                if (!rule.onMatch)
                    rule.onMatch = null;
            }
            if (!ruleRegExps.length) {
                mapping[0] = 0;
                ruleRegExps.push("$");
            }
            splitterRurles.forEach(function (rule) {
                rule.splitRegex = this.createSplitterRegexp(rule.regex, flag);
            }, this);
            this.regExps[key] = new RegExp("(" + ruleRegExps.join(")|(") + ")|($)", flag);
        }
    }
    Tokenizer.prototype.$setMaxTokenCount = function (m) {
        MAX_TOKEN_COUNT = m | 0;
    };
    Tokenizer.prototype.$applyToken = function (str) {
        var values = this.splitRegex.exec(str).slice(1);
        var types = this.token.apply(this, values);
        if (typeof types === "string")
            return [{ type: types, value: str }];
        var tokens = [];
        for (var i = 0, l = types.length; i < l; i++) {
            if (values[i])
                tokens[tokens.length] = {
                    type: types[i],
                    value: values[i]
                };
        }
        return tokens;
    };
    Tokenizer.prototype.$arrayTokens = function (str) {
        if (!str)
            return [];
        var values = this.splitRegex.exec(str);
        if (!values)
            return "text";
        var tokens = [];
        var types = this.tokenArray;
        for (var i = 0, l = types.length; i < l; i++) {
            if (values[i + 1])
                tokens[tokens.length] = {
                    type: types[i],
                    value: values[i + 1]
                };
        }
        return tokens;
    };
    Tokenizer.prototype.removeCapturingGroups = function (src) {
        var r = src.replace(/\\.|\[(?:\\.|[^\\\]])*|\(\?[:=!<]|(\()/g, function (x, y) { return y ? "(?:" : x; });
        return r;
    };
    Tokenizer.prototype.createSplitterRegexp = function (src, flag) {
        if (src.indexOf("(?=") != -1) {
            var stack = 0;
            var inChClass = false;
            var lastCapture = {};
            src.replace(/(\\.)|(\((?:\?[=!])?)|(\))|([\[\]])/g, function (m, esc, parenOpen, parenClose, square, index) {
                if (inChClass) {
                    inChClass = square != "]";
                }
                else if (square) {
                    inChClass = true;
                }
                else if (parenClose) {
                    if (stack == lastCapture.stack) {
                        lastCapture.end = index + 1;
                        lastCapture.stack = -1;
                    }
                    stack--;
                }
                else if (parenOpen) {
                    stack++;
                    if (parenOpen.length != 1) {
                        lastCapture.stack = stack;
                        lastCapture.start = index;
                    }
                }
                return m;
            });
            if (lastCapture.end != null && /^\)*$/.test(src.substr(lastCapture.end)))
                src = src.substring(0, lastCapture.start) + src.substr(lastCapture.end);
        }
        if (src.charAt(0) != "^")
            src = "^" + src;
        if (src.charAt(src.length - 1) != "$")
            src += "$";
        return new RegExp(src, (flag || "").replace("g", ""));
    };
    Tokenizer.prototype.getLineTokens = function (line, startState) {
        if (startState && typeof startState != "string") {
            var stack = startState.slice(0);
            startState = stack[0];
            if (startState === "#tmp") {
                stack.shift();
                startState = stack.shift();
            }
        }
        else
            var stack = [];
        var currentState = startState || "start";
        var state = this.states[currentState];
        if (!state) {
            currentState = "start";
            state = this.states[currentState];
        }
        var mapping = this.matchMappings[currentState];
        var re = this.regExps[currentState];
        re.lastIndex = 0;
        var match, tokens = [];
        var lastIndex = 0;
        var matchAttempts = 0;
        var token = { type: null, value: "" };
        while (match = re.exec(line)) {
            var type = mapping.defaultToken;
            var rule = null;
            var value = match[0];
            var index = re.lastIndex;
            if (index - value.length > lastIndex) {
                var skipped = line.substring(lastIndex, index - value.length);
                if (token.type == type) {
                    token.value += skipped;
                }
                else {
                    if (token.type)
                        tokens.push(token);
                    token = { type: type, value: skipped, column: match.index };
                }
            }
            for (var i = 0; i < match.length - 2; i++) {
                if (match[i + 1] === undefined)
                    continue;
                rule = state[mapping[i]];
                if (rule.onMatch)
                    type = rule.onMatch(value, currentState, stack, line);
                else
                    type = rule.token;
                if (rule.next) {
                    if (typeof rule.next == "string") {
                        currentState = rule.next;
                    }
                    else {
                        currentState = rule.next(currentState, stack);
                    }
                    state = this.states[currentState];
                    if (!state) {
                        this.reportError("state doesn't exist", currentState);
                        currentState = "start";
                        state = this.states[currentState];
                    }
                    mapping = this.matchMappings[currentState];
                    lastIndex = index;
                    re = this.regExps[currentState];
                    re.lastIndex = index;
                }
                if (rule.consumeLineEnd)
                    lastIndex = index;
                break;
            }
            if (value) {
                if (typeof type === "string") {
                    if ((!rule || rule.merge !== false) && token.type === type) {
                        token.value += value;
                    }
                    else {
                        if (token.type)
                            tokens.push(token);
                        token = { type: type, value: value, column: match.index };
                    }
                }
                else if (type) {
                    if (token.type)
                        tokens.push(token);
                    var matchIndex = match.index;
                    token = { type: null, value: "" };
                    for (var i = 0; i < type.length; i++) {
                        if (type[i].type) {
                            if (type[i].column === undefined) {
                                type[i].column = matchIndex;
                            }
                            matchIndex = matchIndex + type[i].value.length;
                        }
                        tokens.push(type[i]);
                    }
                }
            }
            if (lastIndex == line.length)
                break;
            lastIndex = index;
            if (matchAttempts++ > MAX_TOKEN_COUNT) {
                if (matchAttempts > 2 * line.length) {
                    this.reportError("infinite loop with in ace tokenizer", {
                        startState: startState,
                        line: line
                    });
                }
                while (lastIndex < line.length) {
                    if (token.type)
                        tokens.push(token);
                    token = {
                        value: line.substring(lastIndex, lastIndex += 500),
                        type: "overflow"
                    };
                }
                currentState = "start";
                stack = [];
                break;
            }
        }
        token.column = lastIndex - token.value.length;
        if (token.type)
            tokens.push(token);
        if (stack.length > 1) {
            if (stack[0] !== currentState)
                stack.unshift("#tmp", currentState);
        }
        return {
            tokens: tokens,
            state: stack.length ? stack : currentState
        };
    };
    return Tokenizer;
}());
Tokenizer.prototype.reportError = reportError;
exports.Tokenizer = Tokenizer;

});

define("ace/mode/behaviour",["require","exports","module"], function(require, exports, module){"use strict";
var Behaviour = function () {
    this.$behaviours = {};
};
(function () {
    this.add = function (name, action, callback) {
        switch (undefined) {
            case this.$behaviours:
                this.$behaviours = {};
            case this.$behaviours[name]:
                this.$behaviours[name] = {};
        }
        this.$behaviours[name][action] = callback;
    };
    this.addBehaviours = function (behaviours) {
        for (var key in behaviours) {
            for (var action in behaviours[key]) {
                this.add(key, action, behaviours[key][action]);
            }
        }
    };
    this.remove = function (name) {
        if (this.$behaviours && this.$behaviours[name]) {
            delete this.$behaviours[name];
        }
    };
    this.inherit = function (mode, filter) {
        if (typeof mode === "function") {
            var behaviours = new mode().getBehaviours(filter);
        }
        else {
            var behaviours = mode.getBehaviours(filter);
        }
        this.addBehaviours(behaviours);
    };
    this.getBehaviours = function (filter) {
        if (!filter) {
            return this.$behaviours;
        }
        else {
            var ret = {};
            for (var i = 0; i < filter.length; i++) {
                if (this.$behaviours[filter[i]]) {
                    ret[filter[i]] = this.$behaviours[filter[i]];
                }
            }
            return ret;
        }
    };
}).call(Behaviour.prototype);
exports.Behaviour = Behaviour;

});

define("ace/token_iterator",["require","exports","module","ace/range"], function(require, exports, module){"use strict";
var Range = require("./range").Range;
var TokenIterator = /** @class */ (function () {
    function TokenIterator(session, initialRow, initialColumn) {
        this.$session = session;
        this.$row = initialRow;
        this.$rowTokens = session.getTokens(initialRow);
        var token = session.getTokenAt(initialRow, initialColumn);
        this.$tokenIndex = token ? token.index : -1;
    }
    TokenIterator.prototype.stepBackward = function () {
        this.$tokenIndex -= 1;
        while (this.$tokenIndex < 0) {
            this.$row -= 1;
            if (this.$row < 0) {
                this.$row = 0;
                return null;
            }
            this.$rowTokens = this.$session.getTokens(this.$row);
            this.$tokenIndex = this.$rowTokens.length - 1;
        }
        return this.$rowTokens[this.$tokenIndex];
    };
    TokenIterator.prototype.stepForward = function () {
        this.$tokenIndex += 1;
        var rowCount;
        while (this.$tokenIndex >= this.$rowTokens.length) {
            this.$row += 1;
            if (!rowCount)
                rowCount = this.$session.getLength();
            if (this.$row >= rowCount) {
                this.$row = rowCount - 1;
                return null;
            }
            this.$rowTokens = this.$session.getTokens(this.$row);
            this.$tokenIndex = 0;
        }
        return this.$rowTokens[this.$tokenIndex];
    };
    TokenIterator.prototype.getCurrentToken = function () {
        return this.$rowTokens[this.$tokenIndex];
    };
    TokenIterator.prototype.getCurrentTokenRow = function () {
        return this.$row;
    };
    TokenIterator.prototype.getCurrentTokenColumn = function () {
        var rowTokens = this.$rowTokens;
        var tokenIndex = this.$tokenIndex;
        var column = rowTokens[tokenIndex].start;
        if (column !== undefined)
            return column;
        column = 0;
        while (tokenIndex > 0) {
            tokenIndex -= 1;
            column += rowTokens[tokenIndex].value.length;
        }
        return column;
    };
    TokenIterator.prototype.getCurrentTokenPosition = function () {
        return { row: this.$row, column: this.getCurrentTokenColumn() };
    };
    TokenIterator.prototype.getCurrentTokenRange = function () {
        var token = this.$rowTokens[this.$tokenIndex];
        var column = this.getCurrentTokenColumn();
        return new Range(this.$row, column, this.$row, column + token.value.length);
    };
    return TokenIterator;
}());
exports.TokenIterator = TokenIterator;

});

define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"], function(require, exports, module){"use strict";
var oop = require("../../lib/oop");
var Behaviour = require("../behaviour").Behaviour;
var TokenIterator = require("../../token_iterator").TokenIterator;
var lang = require("../../lib/lang");
var SAFE_INSERT_IN_TOKENS = ["text", "paren.rparen", "rparen", "paren", "punctuation.operator"];
var SAFE_INSERT_BEFORE_TOKENS = ["text", "paren.rparen", "rparen", "paren", "punctuation.operator", "comment"];
var context;
var contextCache = {};
var defaultQuotes = { '"': '"', "'": "'" };
var initContext = function (editor) {
    var id = -1;
    if (editor.multiSelect) {
        id = editor.selection.index;
        if (contextCache.rangeCount != editor.multiSelect.rangeCount)
            contextCache = { rangeCount: editor.multiSelect.rangeCount };
    }
    if (contextCache[id])
        return context = contextCache[id];
    context = contextCache[id] = {
        autoInsertedBrackets: 0,
        autoInsertedRow: -1,
        autoInsertedLineEnd: "",
        maybeInsertedBrackets: 0,
        maybeInsertedRow: -1,
        maybeInsertedLineStart: "",
        maybeInsertedLineEnd: ""
    };
};
var getWrapped = function (selection, selected, opening, closing) {
    var rowDiff = selection.end.row - selection.start.row;
    return {
        text: opening + selected + closing,
        selection: [
            0,
            selection.start.column + 1,
            rowDiff,
            selection.end.column + (rowDiff ? 0 : 1)
        ]
    };
};
var CstyleBehaviour = function (options) {
    options = options || {};
    this.add("braces", "insertion", function (state, action, editor, session, text) {
        var cursor = editor.getCursorPosition();
        var line = session.doc.getLine(cursor.row);
        if (text == '{') {
            initContext(editor);
            var selection = editor.getSelectionRange();
            var selected = session.doc.getTextRange(selection);
            if (selected !== "" && selected !== "{" && editor.getWrapBehavioursEnabled()) {
                return getWrapped(selection, selected, '{', '}');
            }
            else if (CstyleBehaviour.isSaneInsertion(editor, session)) {
                if (/[\]\}\)]/.test(line[cursor.column]) || editor.inMultiSelectMode || options.braces) {
                    CstyleBehaviour.recordAutoInsert(editor, session, "}");
                    return {
                        text: '{}',
                        selection: [1, 1]
                    };
                }
                else {
                    CstyleBehaviour.recordMaybeInsert(editor, session, "{");
                    return {
                        text: '{',
                        selection: [1, 1]
                    };
                }
            }
        }
        else if (text == '}') {
            initContext(editor);
            var rightChar = line.substring(cursor.column, cursor.column + 1);
            if (rightChar == '}') {
                var matching = session.$findOpeningBracket('}', { column: cursor.column + 1, row: cursor.row });
                if (matching !== null && CstyleBehaviour.isAutoInsertedClosing(cursor, line, text)) {
                    CstyleBehaviour.popAutoInsertedClosing();
                    return {
                        text: '',
                        selection: [1, 1]
                    };
                }
            }
        }
        else if (text == "\n" || text == "\r\n") {
            initContext(editor);
            var closing = "";
            if (CstyleBehaviour.isMaybeInsertedClosing(cursor, line)) {
                closing = lang.stringRepeat("}", context.maybeInsertedBrackets);
                CstyleBehaviour.clearMaybeInsertedClosing();
            }
            var rightChar = line.substring(cursor.column, cursor.column + 1);
            if (rightChar === '}') {
                var openBracePos = session.findMatchingBracket({ row: cursor.row, column: cursor.column + 1 }, '}');
                if (!openBracePos)
                    return null;
                var next_indent = this.$getIndent(session.getLine(openBracePos.row));
            }
            else if (closing) {
                var next_indent = this.$getIndent(line);
            }
            else {
                CstyleBehaviour.clearMaybeInsertedClosing();
                return;
            }
            var indent = next_indent + session.getTabString();
            return {
                text: '\n' + indent + '\n' + next_indent + closing,
                selection: [1, indent.length, 1, indent.length]
            };
        }
        else {
            CstyleBehaviour.clearMaybeInsertedClosing();
        }
    });
    this.add("braces", "deletion", function (state, action, editor, session, range) {
        var selected = session.doc.getTextRange(range);
        if (!range.isMultiLine() && selected == '{') {
            initContext(editor);
            var line = session.doc.getLine(range.start.row);
            var rightChar = line.substring(range.end.column, range.end.column + 1);
            if (rightChar == '}') {
                range.end.column++;
                return range;
            }
            else {
                context.maybeInsertedBrackets--;
            }
        }
    });
    this.add("parens", "insertion", function (state, action, editor, session, text) {
        if (text == '(') {
            initContext(editor);
            var selection = editor.getSelectionRange();
            var selected = session.doc.getTextRange(selection);
            if (selected !== "" && editor.getWrapBehavioursEnabled()) {
                return getWrapped(selection, selected, '(', ')');
            }
            else if (CstyleBehaviour.isSaneInsertion(editor, session)) {
                CstyleBehaviour.recordAutoInsert(editor, session, ")");
                return {
                    text: '()',
                    selection: [1, 1]
                };
            }
        }
        else if (text == ')') {
            initContext(editor);
            var cursor = editor.getCursorPosition();
            var line = session.doc.getLine(cursor.row);
            var rightChar = line.substring(cursor.column, cursor.column + 1);
            if (rightChar == ')') {
                var matching = session.$findOpeningBracket(')', { column: cursor.column + 1, row: cursor.row });
                if (matching !== null && CstyleBehaviour.isAutoInsertedClosing(cursor, line, text)) {
                    CstyleBehaviour.popAutoInsertedClosing();
                    return {
                        text: '',
                        selection: [1, 1]
                    };
                }
            }
        }
    });
    this.add("parens", "deletion", function (state, action, editor, session, range) {
        var selected = session.doc.getTextRange(range);
        if (!range.isMultiLine() && selected == '(') {
            initContext(editor);
            var line = session.doc.getLine(range.start.row);
            var rightChar = line.substring(range.start.column + 1, range.start.column + 2);
            if (rightChar == ')') {
                range.end.column++;
                return range;
            }
        }
    });
    this.add("brackets", "insertion", function (state, action, editor, session, text) {
        if (text == '[') {
            initContext(editor);
            var selection = editor.getSelectionRange();
            var selected = session.doc.getTextRange(selection);
            if (selected !== "" && editor.getWrapBehavioursEnabled()) {
                return getWrapped(selection, selected, '[', ']');
            }
            else if (CstyleBehaviour.isSaneInsertion(editor, session)) {
                CstyleBehaviour.recordAutoInsert(editor, session, "]");
                return {
                    text: '[]',
                    selection: [1, 1]
                };
            }
        }
        else if (text == ']') {
            initContext(editor);
            var cursor = editor.getCursorPosition();
            var line = session.doc.getLine(cursor.row);
            var rightChar = line.substring(cursor.column, cursor.column + 1);
            if (rightChar == ']') {
                var matching = session.$findOpeningBracket(']', { column: cursor.column + 1, row: cursor.row });
                if (matching !== null && CstyleBehaviour.isAutoInsertedClosing(cursor, line, text)) {
                    CstyleBehaviour.popAutoInsertedClosing();
                    return {
                        text: '',
                        selection: [1, 1]
                    };
                }
            }
        }
    });
    this.add("brackets", "deletion", function (state, action, editor, session, range) {
        var selected = session.doc.getTextRange(range);
        if (!range.isMultiLine() && selected == '[') {
            initContext(editor);
            var line = session.doc.getLine(range.start.row);
            var rightChar = line.substring(range.start.column + 1, range.start.column + 2);
            if (rightChar == ']') {
                range.end.column++;
                return range;
            }
        }
    });
    this.add("string_dquotes", "insertion", function (state, action, editor, session, text) {
        var quotes = session.$mode.$quotes || defaultQuotes;
        if (text.length == 1 && quotes[text]) {
            if (this.lineCommentStart && this.lineCommentStart.indexOf(text) != -1)
                return;
            initContext(editor);
            var quote = text;
            var selection = editor.getSelectionRange();
            var selected = session.doc.getTextRange(selection);
            if (selected !== "" && (selected.length != 1 || !quotes[selected]) && editor.getWrapBehavioursEnabled()) {
                return getWrapped(selection, selected, quote, quote);
            }
            else if (!selected) {
                var cursor = editor.getCursorPosition();
                var line = session.doc.getLine(cursor.row);
                var leftChar = line.substring(cursor.column - 1, cursor.column);
                var rightChar = line.substring(cursor.column, cursor.column + 1);
                var token = session.getTokenAt(cursor.row, cursor.column);
                var rightToken = session.getTokenAt(cursor.row, cursor.column + 1);
                if (leftChar == "\\" && token && /escape/.test(token.type))
                    return null;
                var stringBefore = token && /string|escape/.test(token.type);
                var stringAfter = !rightToken || /string|escape/.test(rightToken.type);
                var pair;
                if (rightChar == quote) {
                    pair = stringBefore !== stringAfter;
                    if (pair && /string\.end/.test(rightToken.type))
                        pair = false;
                }
                else {
                    if (stringBefore && !stringAfter)
                        return null; // wrap string with different quote
                    if (stringBefore && stringAfter)
                        return null; // do not pair quotes inside strings
                    var wordRe = session.$mode.tokenRe;
                    wordRe.lastIndex = 0;
                    var isWordBefore = wordRe.test(leftChar);
                    wordRe.lastIndex = 0;
                    var isWordAfter = wordRe.test(rightChar);
                    var pairQuotesAfter = session.$mode.$pairQuotesAfter;
                    var shouldPairQuotes = pairQuotesAfter && pairQuotesAfter[quote] && pairQuotesAfter[quote].test(leftChar);
                    if ((!shouldPairQuotes && isWordBefore) || isWordAfter)
                        return null; // before or after alphanumeric
                    if (rightChar && !/[\s;,.})\]\\]/.test(rightChar))
                        return null; // there is rightChar and it isn't closing
                    var charBefore = line[cursor.column - 2];
                    if (leftChar == quote && (charBefore == quote || wordRe.test(charBefore)))
                        return null;
                    pair = true;
                }
                return {
                    text: pair ? quote + quote : "",
                    selection: [1, 1]
                };
            }
        }
    });
    this.add("string_dquotes", "deletion", function (state, action, editor, session, range) {
        var quotes = session.$mode.$quotes || defaultQuotes;
        var selected = session.doc.getTextRange(range);
        if (!range.isMultiLine() && quotes.hasOwnProperty(selected)) {
            initContext(editor);
            var line = session.doc.getLine(range.start.row);
            var rightChar = line.substring(range.start.column + 1, range.start.column + 2);
            if (rightChar == selected) {
                range.end.column++;
                return range;
            }
        }
    });
    if (options.closeDocComment !== false) {
        this.add("doc comment end", "insertion", function (state, action, editor, session, text) {
            if (state === "doc-start" && (text === "\n" || text === "\r\n") && editor.selection.isEmpty()) {
                var cursor = editor.getCursorPosition();
                var line = session.doc.getLine(cursor.row);
                var nextLine = session.doc.getLine(cursor.row + 1);
                var indent = this.$getIndent(line);
                if (/\s*\*/.test(nextLine)) {
                    if (/^\s*\*/.test(line)) {
                        return {
                            text: text + indent + "* ",
                            selection: [1, 3 + indent.length, 1, 3 + indent.length]
                        };
                    }
                    else {
                        return {
                            text: text + indent + " * ",
                            selection: [1, 3 + indent.length, 1, 3 + indent.length]
                        };
                    }
                }
                if (/\/\*\*/.test(line.substring(0, cursor.column))) {
                    return {
                        text: text + indent + " * " + text + " " + indent + "*/",
                        selection: [1, 4 + indent.length, 1, 4 + indent.length]
                    };
                }
            }
        });
    }
};
CstyleBehaviour.isSaneInsertion = function (editor, session) {
    var cursor = editor.getCursorPosition();
    var iterator = new TokenIterator(session, cursor.row, cursor.column);
    if (!this.$matchTokenType(iterator.getCurrentToken() || "text", SAFE_INSERT_IN_TOKENS)) {
        if (/[)}\]]/.test(editor.session.getLine(cursor.row)[cursor.column]))
            return true;
        var iterator2 = new TokenIterator(session, cursor.row, cursor.column + 1);
        if (!this.$matchTokenType(iterator2.getCurrentToken() || "text", SAFE_INSERT_IN_TOKENS))
            return false;
    }
    iterator.stepForward();
    return iterator.getCurrentTokenRow() !== cursor.row ||
        this.$matchTokenType(iterator.getCurrentToken() || "text", SAFE_INSERT_BEFORE_TOKENS);
};
CstyleBehaviour.$matchTokenType = function (token, types) {
    return types.indexOf(token.type || token) > -1;
};
CstyleBehaviour.recordAutoInsert = function (editor, session, bracket) {
    var cursor = editor.getCursorPosition();
    var line = session.doc.getLine(cursor.row);
    if (!this.isAutoInsertedClosing(cursor, line, context.autoInsertedLineEnd[0]))
        context.autoInsertedBrackets = 0;
    context.autoInsertedRow = cursor.row;
    context.autoInsertedLineEnd = bracket + line.substr(cursor.column);
    context.autoInsertedBrackets++;
};
CstyleBehaviour.recordMaybeInsert = function (editor, session, bracket) {
    var cursor = editor.getCursorPosition();
    var line = session.doc.getLine(cursor.row);
    if (!this.isMaybeInsertedClosing(cursor, line))
        context.maybeInsertedBrackets = 0;
    context.maybeInsertedRow = cursor.row;
    context.maybeInsertedLineStart = line.substr(0, cursor.column) + bracket;
    context.maybeInsertedLineEnd = line.substr(cursor.column);
    context.maybeInsertedBrackets++;
};
CstyleBehaviour.isAutoInsertedClosing = function (cursor, line, bracket) {
    return context.autoInsertedBrackets > 0 &&
        cursor.row === context.autoInsertedRow &&
        bracket === context.autoInsertedLineEnd[0] &&
        line.substr(cursor.column) === context.autoInsertedLineEnd;
};
CstyleBehaviour.isMaybeInsertedClosing = function (cursor, line) {
    return context.maybeInsertedBrackets > 0 &&
        cursor.row === context.maybeInsertedRow &&
        line.substr(cursor.column) === context.maybeInsertedLineEnd &&
        line.substr(0, cursor.column) == context.maybeInsertedLineStart;
};
CstyleBehaviour.popAutoInsertedClosing = function () {
    context.autoInsertedLineEnd = context.autoInsertedLineEnd.substr(1);
    context.autoInsertedBrackets--;
};
CstyleBehaviour.clearMaybeInsertedClosing = function () {
    if (context) {
        context.maybeInsertedBrackets = 0;
        context.maybeInsertedRow = -1;
    }
};
oop.inherits(CstyleBehaviour, Behaviour);
exports.CstyleBehaviour = CstyleBehaviour;

});

define("ace/unicode",["require","exports","module"], function(require, exports, module){"use strict";
var wordChars = [48, 9, 8, 25, 5, 0, 2, 25, 48, 0, 11, 0, 5, 0, 6, 22, 2, 30, 2, 457, 5, 11, 15, 4, 8, 0, 2, 0, 18, 116, 2, 1, 3, 3, 9, 0, 2, 2, 2, 0, 2, 19, 2, 82, 2, 138, 2, 4, 3, 155, 12, 37, 3, 0, 8, 38, 10, 44, 2, 0, 2, 1, 2, 1, 2, 0, 9, 26, 6, 2, 30, 10, 7, 61, 2, 9, 5, 101, 2, 7, 3, 9, 2, 18, 3, 0, 17, 58, 3, 100, 15, 53, 5, 0, 6, 45, 211, 57, 3, 18, 2, 5, 3, 11, 3, 9, 2, 1, 7, 6, 2, 2, 2, 7, 3, 1, 3, 21, 2, 6, 2, 0, 4, 3, 3, 8, 3, 1, 3, 3, 9, 0, 5, 1, 2, 4, 3, 11, 16, 2, 2, 5, 5, 1, 3, 21, 2, 6, 2, 1, 2, 1, 2, 1, 3, 0, 2, 4, 5, 1, 3, 2, 4, 0, 8, 3, 2, 0, 8, 15, 12, 2, 2, 8, 2, 2, 2, 21, 2, 6, 2, 1, 2, 4, 3, 9, 2, 2, 2, 2, 3, 0, 16, 3, 3, 9, 18, 2, 2, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 3, 8, 3, 1, 3, 2, 9, 1, 5, 1, 2, 4, 3, 9, 2, 0, 17, 1, 2, 5, 4, 2, 2, 3, 4, 1, 2, 0, 2, 1, 4, 1, 4, 2, 4, 11, 5, 4, 4, 2, 2, 3, 3, 0, 7, 0, 15, 9, 18, 2, 2, 7, 2, 2, 2, 22, 2, 9, 2, 4, 4, 7, 2, 2, 2, 3, 8, 1, 2, 1, 7, 3, 3, 9, 19, 1, 2, 7, 2, 2, 2, 22, 2, 9, 2, 4, 3, 8, 2, 2, 2, 3, 8, 1, 8, 0, 2, 3, 3, 9, 19, 1, 2, 7, 2, 2, 2, 22, 2, 15, 4, 7, 2, 2, 2, 3, 10, 0, 9, 3, 3, 9, 11, 5, 3, 1, 2, 17, 4, 23, 2, 8, 2, 0, 3, 6, 4, 0, 5, 5, 2, 0, 2, 7, 19, 1, 14, 57, 6, 14, 2, 9, 40, 1, 2, 0, 3, 1, 2, 0, 3, 0, 7, 3, 2, 6, 2, 2, 2, 0, 2, 0, 3, 1, 2, 12, 2, 2, 3, 4, 2, 0, 2, 5, 3, 9, 3, 1, 35, 0, 24, 1, 7, 9, 12, 0, 2, 0, 2, 0, 5, 9, 2, 35, 5, 19, 2, 5, 5, 7, 2, 35, 10, 0, 58, 73, 7, 77, 3, 37, 11, 42, 2, 0, 4, 328, 2, 3, 3, 6, 2, 0, 2, 3, 3, 40, 2, 3, 3, 32, 2, 3, 3, 6, 2, 0, 2, 3, 3, 14, 2, 56, 2, 3, 3, 66, 5, 0, 33, 15, 17, 84, 13, 619, 3, 16, 2, 25, 6, 74, 22, 12, 2, 6, 12, 20, 12, 19, 13, 12, 2, 2, 2, 1, 13, 51, 3, 29, 4, 0, 5, 1, 3, 9, 34, 2, 3, 9, 7, 87, 9, 42, 6, 69, 11, 28, 4, 11, 5, 11, 11, 39, 3, 4, 12, 43, 5, 25, 7, 10, 38, 27, 5, 62, 2, 28, 3, 10, 7, 9, 14, 0, 89, 75, 5, 9, 18, 8, 13, 42, 4, 11, 71, 55, 9, 9, 4, 48, 83, 2, 2, 30, 14, 230, 23, 280, 3, 5, 3, 37, 3, 5, 3, 7, 2, 0, 2, 0, 2, 0, 2, 30, 3, 52, 2, 6, 2, 0, 4, 2, 2, 6, 4, 3, 3, 5, 5, 12, 6, 2, 2, 6, 67, 1, 20, 0, 29, 0, 14, 0, 17, 4, 60, 12, 5, 0, 4, 11, 18, 0, 5, 0, 3, 9, 2, 0, 4, 4, 7, 0, 2, 0, 2, 0, 2, 3, 2, 10, 3, 3, 6, 4, 5, 0, 53, 1, 2684, 46, 2, 46, 2, 132, 7, 6, 15, 37, 11, 53, 10, 0, 17, 22, 10, 6, 2, 6, 2, 6, 2, 6, 2, 6, 2, 6, 2, 6, 2, 6, 2, 31, 48, 0, 470, 1, 36, 5, 2, 4, 6, 1, 5, 85, 3, 1, 3, 2, 2, 89, 2, 3, 6, 40, 4, 93, 18, 23, 57, 15, 513, 6581, 75, 20939, 53, 1164, 68, 45, 3, 268, 4, 27, 21, 31, 3, 13, 13, 1, 2, 24, 9, 69, 11, 1, 38, 8, 3, 102, 3, 1, 111, 44, 25, 51, 13, 68, 12, 9, 7, 23, 4, 0, 5, 45, 3, 35, 13, 28, 4, 64, 15, 10, 39, 54, 10, 13, 3, 9, 7, 22, 4, 1, 5, 66, 25, 2, 227, 42, 2, 1, 3, 9, 7, 11171, 13, 22, 5, 48, 8453, 301, 3, 61, 3, 105, 39, 6, 13, 4, 6, 11, 2, 12, 2, 4, 2, 0, 2, 1, 2, 1, 2, 107, 34, 362, 19, 63, 3, 53, 41, 11, 5, 15, 17, 6, 13, 1, 25, 2, 33, 4, 2, 134, 20, 9, 8, 25, 5, 0, 2, 25, 12, 88, 4, 5, 3, 5, 3, 5, 3, 2];
var code = 0;
var str = [];
for (var i = 0; i < wordChars.length; i += 2) {
    str.push(code += wordChars[i]);
    if (wordChars[i + 1])
        str.push(45, code += wordChars[i + 1]);
}
exports.wordChars = String.fromCharCode.apply(null, str);

});

define("ace/mode/text",["require","exports","module","ace/config","ace/tokenizer","ace/mode/text_highlight_rules","ace/mode/behaviour/cstyle","ace/unicode","ace/lib/lang","ace/token_iterator","ace/range"], function(require, exports, module){"use strict";
var config = require("../config");
var Tokenizer = require("../tokenizer").Tokenizer;
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var CstyleBehaviour = require("./behaviour/cstyle").CstyleBehaviour;
var unicode = require("../unicode");
var lang = require("../lib/lang");
var TokenIterator = require("../token_iterator").TokenIterator;
var Range = require("../range").Range;
var Mode = function () {
    this.HighlightRules = TextHighlightRules;
};
(function () {
    this.$defaultBehaviour = new CstyleBehaviour();
    this.tokenRe = new RegExp("^[" + unicode.wordChars + "\\$_]+", "g");
    this.nonTokenRe = new RegExp("^(?:[^" + unicode.wordChars + "\\$_]|\\s])+", "g");
    this.getTokenizer = function () {
        if (!this.$tokenizer) {
            this.$highlightRules = this.$highlightRules || new this.HighlightRules(this.$highlightRuleConfig);
            this.$tokenizer = new Tokenizer(this.$highlightRules.getRules());
        }
        return this.$tokenizer;
    };
    this.lineCommentStart = "";
    this.blockComment = "";
    this.toggleCommentLines = function (state, session, startRow, endRow) {
        var doc = session.doc;
        var ignoreBlankLines = true;
        var shouldRemove = true;
        var minIndent = Infinity;
        var tabSize = session.getTabSize();
        var insertAtTabStop = false;
        if (!this.lineCommentStart) {
            if (!this.blockComment)
                return false;
            var lineCommentStart = this.blockComment.start;
            var lineCommentEnd = this.blockComment.end;
            var regexpStart = new RegExp("^(\\s*)(?:" + lang.escapeRegExp(lineCommentStart) + ")");
            var regexpEnd = new RegExp("(?:" + lang.escapeRegExp(lineCommentEnd) + ")\\s*$");
            var comment = function (line, i) {
                if (testRemove(line, i))
                    return;
                if (!ignoreBlankLines || /\S/.test(line)) {
                    doc.insertInLine({ row: i, column: line.length }, lineCommentEnd);
                    doc.insertInLine({ row: i, column: minIndent }, lineCommentStart);
                }
            };
            var uncomment = function (line, i) {
                var m;
                if (m = line.match(regexpEnd))
                    doc.removeInLine(i, line.length - m[0].length, line.length);
                if (m = line.match(regexpStart))
                    doc.removeInLine(i, m[1].length, m[0].length);
            };
            var testRemove = function (line, row) {
                if (regexpStart.test(line))
                    return true;
                var tokens = session.getTokens(row);
                for (var i = 0; i < tokens.length; i++) {
                    if (tokens[i].type === "comment")
                        return true;
                }
            };
        }
        else {
            if (Array.isArray(this.lineCommentStart)) {
                var regexpStart = this.lineCommentStart.map(lang.escapeRegExp).join("|");
                var lineCommentStart = this.lineCommentStart[0];
            }
            else {
                var regexpStart = lang.escapeRegExp(this.lineCommentStart);
                var lineCommentStart = this.lineCommentStart;
            }
            regexpStart = new RegExp("^(\\s*)(?:" + regexpStart + ") ?");
            insertAtTabStop = session.getUseSoftTabs();
            var uncomment = function (line, i) {
                var m = line.match(regexpStart);
                if (!m)
                    return;
                var start = m[1].length, end = m[0].length;
                if (!shouldInsertSpace(line, start, end) && m[0][end - 1] == " ")
                    end--;
                doc.removeInLine(i, start, end);
            };
            var commentWithSpace = lineCommentStart + " ";
            var comment = function (line, i) {
                if (!ignoreBlankLines || /\S/.test(line)) {
                    if (shouldInsertSpace(line, minIndent, minIndent))
                        doc.insertInLine({ row: i, column: minIndent }, commentWithSpace);
                    else
                        doc.insertInLine({ row: i, column: minIndent }, lineCommentStart);
                }
            };
            var testRemove = function (line, i) {
                return regexpStart.test(line);
            };
            var shouldInsertSpace = function (line, before, after) {
                var spaces = 0;
                while (before-- && line.charAt(before) == " ")
                    spaces++;
                if (spaces % tabSize != 0)
                    return false;
                var spaces = 0;
                while (line.charAt(after++) == " ")
                    spaces++;
                if (tabSize > 2)
                    return spaces % tabSize != tabSize - 1;
                else
                    return spaces % tabSize == 0;
            };
        }
        function iter(fun) {
            for (var i = startRow; i <= endRow; i++)
                fun(doc.getLine(i), i);
        }
        var minEmptyLength = Infinity;
        iter(function (line, i) {
            var indent = line.search(/\S/);
            if (indent !== -1) {
                if (indent < minIndent)
                    minIndent = indent;
                if (shouldRemove && !testRemove(line, i))
                    shouldRemove = false;
            }
            else if (minEmptyLength > line.length) {
                minEmptyLength = line.length;
            }
        });
        if (minIndent == Infinity) {
            minIndent = minEmptyLength;
            ignoreBlankLines = false;
            shouldRemove = false;
        }
        if (insertAtTabStop && minIndent % tabSize != 0)
            minIndent = Math.floor(minIndent / tabSize) * tabSize;
        iter(shouldRemove ? uncomment : comment);
    };
    this.toggleBlockComment = function (state, session, range, cursor) {
        var comment = this.blockComment;
        if (!comment)
            return;
        if (!comment.start && comment[0])
            comment = comment[0];
        var iterator = new TokenIterator(session, cursor.row, cursor.column);
        var token = iterator.getCurrentToken();
        var sel = session.selection;
        var initialRange = session.selection.toOrientedRange();
        var startRow, colDiff;
        if (token && /comment/.test(token.type)) {
            var startRange, endRange;
            while (token && /comment/.test(token.type)) {
                var i = token.value.indexOf(comment.start);
                if (i != -1) {
                    var row = iterator.getCurrentTokenRow();
                    var column = iterator.getCurrentTokenColumn() + i;
                    startRange = new Range(row, column, row, column + comment.start.length);
                    break;
                }
                token = iterator.stepBackward();
            }
            var iterator = new TokenIterator(session, cursor.row, cursor.column);
            var token = iterator.getCurrentToken();
            while (token && /comment/.test(token.type)) {
                var i = token.value.indexOf(comment.end);
                if (i != -1) {
                    var row = iterator.getCurrentTokenRow();
                    var column = iterator.getCurrentTokenColumn() + i;
                    endRange = new Range(row, column, row, column + comment.end.length);
                    break;
                }
                token = iterator.stepForward();
            }
            if (endRange)
                session.remove(endRange);
            if (startRange) {
                session.remove(startRange);
                startRow = startRange.start.row;
                colDiff = -comment.start.length;
            }
        }
        else {
            colDiff = comment.start.length;
            startRow = range.start.row;
            session.insert(range.end, comment.end);
            session.insert(range.start, comment.start);
        }
        if (initialRange.start.row == startRow)
            initialRange.start.column += colDiff;
        if (initialRange.end.row == startRow)
            initialRange.end.column += colDiff;
        session.selection.fromOrientedRange(initialRange);
    };
    this.getNextLineIndent = function (state, line, tab) {
        return this.$getIndent(line);
    };
    this.checkOutdent = function (state, line, input) {
        return false;
    };
    this.autoOutdent = function (state, doc, row) {
    };
    this.$getIndent = function (line) {
        return line.match(/^\s*/)[0];
    };
    this.createWorker = function (session) {
        return null;
    };
    this.createModeDelegates = function (mapping) {
        this.$embeds = [];
        this.$modes = {};
        for (var i in mapping) {
            if (mapping[i]) {
                var Mode = mapping[i];
                var id = Mode.prototype.$id;
                var mode = config.$modes[id];
                if (!mode)
                    config.$modes[id] = mode = new Mode();
                if (!config.$modes[i])
                    config.$modes[i] = mode;
                this.$embeds.push(i);
                this.$modes[i] = mode;
            }
        }
        var delegations = ["toggleBlockComment", "toggleCommentLines", "getNextLineIndent",
            "checkOutdent", "autoOutdent", "transformAction", "getCompletions"];
        for (var i = 0; i < delegations.length; i++) {
            (function (scope) {
                var functionName = delegations[i];
                var defaultHandler = scope[functionName];
                scope[delegations[i]] = function () {
                    return this.$delegator(functionName, arguments, defaultHandler);
                };
            }(this));
        }
    };
    this.$delegator = function (method, args, defaultHandler) {
        var state = args[0] || "start";
        if (typeof state != "string") {
            if (Array.isArray(state[2])) {
                var language = state[2][state[2].length - 1];
                var mode = this.$modes[language];
                if (mode)
                    return mode[method].apply(mode, [state[1]].concat([].slice.call(args, 1)));
            }
            state = state[0] || "start";
        }
        for (var i = 0; i < this.$embeds.length; i++) {
            if (!this.$modes[this.$embeds[i]])
                continue;
            var split = state.split(this.$embeds[i]);
            if (!split[0] && split[1]) {
                args[0] = split[1];
                var mode = this.$modes[this.$embeds[i]];
                return mode[method].apply(mode, args);
            }
        }
        var ret = defaultHandler.apply(this, args);
        return defaultHandler ? ret : undefined;
    };
    this.transformAction = function (state, action, editor, session, param) {
        if (this.$behaviour) {
            var behaviours = this.$behaviour.getBehaviours();
            for (var key in behaviours) {
                if (behaviours[key][action]) {
                    var ret = behaviours[key][action].apply(this, arguments);
                    if (ret) {
                        return ret;
                    }
                }
            }
        }
    };
    this.getKeywords = function (append) {
        if (!this.completionKeywords) {
            var rules = this.$tokenizer.rules;
            var completionKeywords = [];
            for (var rule in rules) {
                var ruleItr = rules[rule];
                for (var r = 0, l = ruleItr.length; r < l; r++) {
                    if (typeof ruleItr[r].token === "string") {
                        if (/keyword|support|storage/.test(ruleItr[r].token))
                            completionKeywords.push(ruleItr[r].regex);
                    }
                    else if (typeof ruleItr[r].token === "object") {
                        for (var a = 0, aLength = ruleItr[r].token.length; a < aLength; a++) {
                            if (/keyword|support|storage/.test(ruleItr[r].token[a])) {
                                var rule = ruleItr[r].regex.match(/\(.+?\)/g)[a];
                                completionKeywords.push(rule.substr(1, rule.length - 2));
                            }
                        }
                    }
                }
            }
            this.completionKeywords = completionKeywords;
        }
        if (!append)
            return this.$keywordList;
        return completionKeywords.concat(this.$keywordList || []);
    };
    this.$createKeywordList = function () {
        if (!this.$highlightRules)
            this.getTokenizer();
        return this.$keywordList = this.$highlightRules.$keywordList || [];
    };
    this.getCompletions = function (state, session, pos, prefix) {
        var keywords = this.$keywordList || this.$createKeywordList();
        return keywords.map(function (word) {
            return {
                name: word,
                value: word,
                score: 0,
                meta: "keyword"
            };
        });
    };
    this.$id = "ace/mode/text";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/abap",["require","exports","module","ace/mode/abap_highlight_rules","ace/mode/folding/coffee","ace/range","ace/mode/text","ace/lib/oop"], function(require, exports, module){"use strict";
var Rules = require("./abap_highlight_rules").AbapHighlightRules;
var FoldMode = require("./folding/coffee").FoldMode;
var Range = require("../range").Range;
var TextMode = require("./text").Mode;
var oop = require("../lib/oop");
function Mode() {
    this.HighlightRules = Rules;
    this.foldingRules = new FoldMode();
}
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = '"';
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        return indent;
    };
    this.$id = "ace/mode/abap";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/actionscript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){/* This file was autogenerated from tm bundles\actionscript.tmbundle\Syntaxes\ActionScript.plist (uuid: ) */
"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var ActionScriptHighlightRules = function () {
    this.$rules = { start: [{ token: 'support.class.actionscript.2',
                regex: '\\b(?:R(?:ecordset|DBMSResolver|adioButton(?:Group)?)|X(?:ML(?:Socket|Node|Connector)?|UpdateResolverDataHolder)|M(?:M(?:Save|Execute)|icrophoneMicrophone|o(?:use|vieClip(?:Loader)?)|e(?:nu(?:Bar)?|dia(?:Controller|Display|Playback))|ath)|B(?:yName|inding|utton)|S(?:haredObject|ystem|crollPane|t(?:yleSheet|age|ream)|ound|e(?:ndEvent|rviceObject)|OAPCall|lide)|N(?:umericStepper|et(?:stream|S(?:tream|ervices)|Connection|Debug(?:Config)?))|C(?:heckBox|o(?:ntextMenu(?:Item)?|okie|lor|m(?:ponentMixins|boBox))|ustomActions|lient|amera)|T(?:ypedValue|ext(?:Snapshot|Input|F(?:ield|ormat)|Area)|ree|AB)|Object|D(?:ownload|elta(?:Item|Packet)?|at(?:e(?:Chooser|Field)?|a(?:G(?:lue|rid)|Set|Type)))|U(?:RL|TC|IScrollBar)|P(?:opUpManager|endingCall|r(?:intJob|o(?:duct|gressBar)))|E(?:ndPoint|rror)|Video|Key|F(?:RadioButton|GridColumn|MessageBox|BarChart|S(?:croll(?:Bar|Pane)|tyleFormat|plitView)|orm|C(?:heckbox|omboBox|alendar)|unction|T(?:icker|ooltip(?:Lite)?|ree(?:Node)?)|IconButton|D(?:ataGrid|raggablePane)|P(?:ieChart|ushButton|ro(?:gressBar|mptBox))|L(?:i(?:stBox|neChart)|oadingBox)|AdvancedMessageBox)|W(?:indow|SDLURL|ebService(?:Connector)?)|L(?:ist|o(?:calConnection|ad(?:er|Vars)|g)|a(?:unch|bel))|A(?:sBroadcaster|cc(?:ordion|essibility)|S(?:Set(?:Native|PropFlags)|N(?:ew|ative)|C(?:onstructor|lamp(?:2)?)|InstanceOf)|pplication|lert|rray))\\b' },
            { token: 'support.function.actionscript.2',
                regex: '\\b(?:s(?:h(?:ift|ow(?:GridLines|Menu|Border|Settings|Headers|ColumnHeaders|Today|Preferences)?|ad(?:ow|ePane))|c(?:hema|ale(?:X|Mode|Y|Content)|r(?:oll(?:Track|Drag)?|een(?:Resolution|Color|DPI)))|t(?:yleSheet|op(?:Drag|A(?:nimation|llSounds|gent))?|epSize|a(?:tus|rt(?:Drag|A(?:nimation|gent))?))|i(?:n|ze|lence(?:TimeOut|Level))|o(?:ngname|urce|rt(?:Items(?:By)?|On(?:HeaderRelease)?|able(?:Columns)?)?)|u(?:ppressInvalidCalls|bstr(?:ing)?)|p(?:li(?:ce|t)|aceCol(?:umnsEqually|lumnsEqually))|e(?:nd(?:DefaultPushButtonEvent|AndLoad)?|curity|t(?:R(?:GB|o(?:otNode|w(?:Height|Count))|esizable(?:Columns)?|a(?:nge|te))|G(?:ain|roupName)|X(?:AxisTitle)?|M(?:i(?:n(?:imum|utes)|lliseconds)|o(?:nth(?:Names)?|tionLevel|de)|ultilineMode|e(?:ssage|nu(?:ItemEnabled(?:At)?|EnabledAt)|dia)|a(?:sk|ximum))|B(?:u(?:tton(?:s|Width)|fferTime)|a(?:seTabIndex|ndwidthLimit|ckground))|S(?:howAsDisabled|croll(?:ing|Speed|Content|Target|P(?:osition|roperties)|barState|Location)|t(?:yle(?:Property)?|opOnFocus|at(?:us|e))|i(?:ze|lenceLevel)|ort(?:able(?:Columns)?|Function)|p(?:litterBarPosition|acing)|e(?:conds|lect(?:Multiple|ion(?:Required|Type)?|Style|Color|ed(?:Node(?:s)?|Cell|I(?:nd(?:ices|ex)|tem(?:s)?))?|able))|kin|m(?:oothness|allScroll))|H(?:ighlight(?:s|Color)|Scroll|o(?:urs|rizontal)|eader(?:Symbol|Height|Text|Property|Format|Width|Location)?|as(?:Shader|CloseBox))|Y(?:ear|AxisTitle)?|N(?:ode(?:Properties|ExpansionHandler)|ewTextFormat)|C(?:h(?:ildNodes|a(?:ngeHandler|rt(?:Title|EventHandler)))|o(?:ntent(?:Size)?|okie|lumns)|ell(?:Symbol|Data)|l(?:i(?:ckHandler|pboard)|oseHandler)|redentials)|T(?:ype(?:dVaule)?|i(?:tle(?:barHeight)?|p(?:Target|Offset)?|me(?:out(?:Handler)?)?)|oggle|extFormat|ransform)|I(?:s(?:Branch|Open)|n(?:terval|putProperty)|con(?:SymbolName)?|te(?:rator|m(?:ByKey|Symbol)))|Orientation|D(?:i(?:splay(?:Range|Graphics|Mode|Clip|Text|edMonth)|rection)|uration|e(?:pth(?:Below|To|Above)|fault(?:GatewayURL|Mappings|NodeIconSymbolName)|l(?:iveryMode|ay)|bug(?:ID)?)|a(?:yOfWeekNames|t(?:e(?:Filter)?|a(?:Mapping(?:s)?|Item(?:Text|Property|Format)|Provider|All(?:Height|Property|Format|Width))?))|ra(?:wConnectors|gContent))|U(?:se(?:Shadow|HandCursor|EchoSuppression|rInput|Fade)|TC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear))|P(?:osition|ercentComplete|an(?:e(?:M(?:inimumSize|aximumSize)|Size|Title))?|ro(?:pert(?:y(?:Data)?|iesAt)|gress))|E(?:nabled|dit(?:Handler|able)|xpand(?:NodeTrigger|erSymbolName))|V(?:Scroll|olume|alue(?:Source)?)|KeyFrameInterval|Quality|F(?:i(?:eld|rst(?:DayOfWeek|VisibleNode))|ocus|ullYear|ps|ade(?:InLength|OutLength)|rame(?:Color|Width))|Width|L(?:ine(?:Color|Weight)|o(?:opback|adTarget)|a(?:rgeScroll|bel(?:Source|Placement)?))|A(?:s(?:Boolean|String|Number)|n(?:yTypedValue|imation)|ctiv(?:e(?:State(?:Handler)?|Handler)|ateHandler)|utoH(?:ideScrollBar|eight)))?|paratorBefore|ek|lect(?:ion(?:Disabled|Unfocused)?|ed(?:Node(?:s)?|Child|I(?:nd(?:ices|ex)|tem(?:s)?)|Dat(?:e|a))?|able(?:Ranges)?)|rver(?:String)?)|kip|qrt|wapDepths|lice|aveToSharedObj|moothing)|h(?:scroll(?:Policy)?|tml(?:Text)?|i(?:t(?:Test(?:TextNearPos)?|Area)|de(?:BuiltInItems|Child)?|ghlight(?:2D|3D)?)|orizontal|e(?:ight|ader(?:Re(?:nderer|lease)|Height|Text))|P(?:osition|ageScrollSize)|a(?:s(?:childNodes|MP3|S(?:creen(?:Broadcast|Playback)|treaming(?:Video|Audio)|ort)|Next|OwnProperty|Pr(?:inting|evious)|EmbeddedVideo|VideoEncoder|A(?:ccesibility|udio(?:Encoder)?))|ndlerName)|LineScrollSize)|ye(?:sLabel|ar)|n(?:o(?:t|de(?:Name|Close|Type|Open|Value)|Label)|u(?:llValue|mChild(?:S(?:creens|lides)|ren|Forms))|e(?:w(?:Item|line|Value|LocationDialog)|xt(?:S(?:cene|ibling|lide)|TabIndex|Value|Frame)?)?|ame(?:s)?)|c(?:h(?:ildNodes|eck|a(?:nge(?:sPending)?|r(?:CodeAt|At))|r)|o(?:s|n(?:st(?:ant|ructor)|nect|c(?:urrency|at)|t(?:ent(?:Type|Path)?|ains|rol(?:Placement|lerPolicy))|denseWhite|version)|py|l(?:or|umn(?:Stretch|Name(?:s)?|Count))|m(?:p(?:onent|lete)|ment))|u(?:stomItems|ePoint(?:s)?|r(?:veTo|Value|rent(?:Slide|ChildSlide|Item|F(?:ocused(?:S(?:creen|lide)|Form)|ps))))|e(?:il|ll(?:Renderer|Press|Edit|Focus(?:In|Out)))|l(?:i(?:ck|ents)|o(?:se(?:Button|Pane)?|ne(?:Node)?)|ear(?:S(?:haredObjects|treams)|Timeout|Interval)?)|a(?:ncelLabel|tch|p(?:tion|abilities)|l(?:cFields|l(?:e(?:e|r))?))|reate(?:GatewayConnection|Menu|Se(?:rver|gment)|C(?:hild(?:AtDepth)?|l(?:ient|ass(?:ChildAtDepth|Object(?:AtDepth)?))|all)|Text(?:Node|Field)|Item|Object(?:AtDepth)?|PopUp|E(?:lement|mptyMovieClip)))|t(?:h(?:is|row)|ype(?:of|Name)?|i(?:tle(?:StyleDeclaration)?|me(?:out)?)|o(?:talTime|String|olTipText|p|UpperCase|ggle(?:HighQuality)?|Lo(?:caleString|werCase))|e(?:st|llTarget|xt(?:RightMargin|Bold|S(?:ize|elected)|Height|Color|I(?:ndent|talic)|Disabled|Underline|F(?:ield|ont)|Width|LeftMargin|Align)?)|a(?:n|rget(?:Path)?|b(?:Stops|Children|Index|Enabled|leName))|r(?:y|igger|ac(?:e|k(?:AsMenu)?)))|i(?:s(?:Running|Branch|NaN|Con(?:soleOpen|nected)|Toggled|Installed|Open|D(?:own|ebugger)|P(?:urchased|ro(?:totypeOf|pertyEnumerable))|Empty|F(?:inite|ullyPopulated)|Local|Active)|n(?:s(?:tall|ertBefore)|cludeDeltaPacketInfo|t|it(?:ialize|Component|Pod|A(?:pplication|gent))?|de(?:nt|terminate|x(?:InParent(?:Slide|Form)?|Of)?)|put|validate|finity|LocalInternetCache)?|con(?:F(?:ield|unction))?|t(?:e(?:ratorScrolled|m(?:s|RollO(?:ut|ver)|ClassName))|alic)|d3|p|fFrameLoaded|gnore(?:Case|White))|o(?:s|n(?:R(?:ollO(?:ut|ver)|e(?:s(?:ize|ult)|l(?:ease(?:Outside)?|aseOutside)))|XML|Mouse(?:Move|Down|Up|Wheel)|S(?:ync|croller|tatus|oundComplete|e(?:tFocus|lect(?:edItem)?))|N(?:oticeEvent|etworkChange)|C(?:hanged|onnect|l(?:ipEvent|ose))|ID3|D(?:isconnect|eactivate|ata|ragO(?:ut|ver))|Un(?:install|load)|P(?:aymentResult|ress)|EnterFrame|K(?:illFocus|ey(?:Down|Up))|Fault|Lo(?:ad|g)|A(?:ctiv(?:ity|ate)|ppSt(?:op|art)))?|pe(?:n|ration)|verLayChildren|kLabel|ldValue|r(?:d)?)|d(?:i(?:s(?:connect|play(?:Normal|ed(?:Month|Year)|Full)|able(?:Shader|d(?:Ranges|Days)|CloseBox|Events))|rection)|o(?:cTypeDecl|tall|Decoding|main|LazyDecoding)|u(?:plicateMovieClip|ration)|e(?:stroy(?:ChildAt|Object)|code|fault(?:PushButton(?:Enabled)?|KeydownHandler)?|l(?:ta(?:Packet(?:Changed)?)?|ete(?:PopUp|All)?)|blocking)|a(?:shBoardSave|yNames|ta(?:Provider)?|rkshadow)|r(?:opdown(?:Width)?|a(?:w|gO(?:ut|ver))))|u(?:se(?:Sort|HandCursor|Codepage|EchoSuppression)|n(?:shift|install|derline|escape|format|watch|lo(?:ck|ad(?:Movie(?:Num)?)?))|pdate(?:Results|Mode|I(?:nputProperties|tem(?:ByIndex)?)|P(?:acket|roperties)|View|AfterEvent)|rl)|join|p(?:ixelAspectRatio|o(?:sition|p|w)|u(?:sh|rge|blish)|ercen(?:tComplete|Loaded)|lay(?:head(?:Change|Time)|ing|Hidden|erType)?|a(?:ssword|use|r(?:se(?:XML|CSS|Int|Float)|ent(?:Node|Is(?:S(?:creen|lide)|Form))|ams))|r(?:int(?:Num|AsBitmap(?:Num)?)?|o(?:to(?:type)?|pert(?:y|ies)|gress)|e(?:ss|v(?:ious(?:S(?:ibling|lide)|Value)?|Scene|Frame)|ferred(?:Height|Width))))|e(?:scape|n(?:code(?:r)?|ter(?:Frame)?|dFill|able(?:Shader|d|CloseBox|Events))|dit(?:able|Field|LocationDialog)|v(?:ent|al(?:uate)?)|q|x(?:tended|p|ec(?:ute)?|actSettings)|m(?:phasized(?:StyleDeclaration)?|bedFonts))|v(?:i(?:sible|ewPod)|ScrollPolicy|o(?:id|lume)|ersion|P(?:osition|ageScrollSize)|a(?:l(?:idat(?:ionError|e(?:Property|ActivationKey)?)|ue(?:Of)?)|riable)|LineScrollSize)|k(?:ind|ey(?:Down|Up|Press|FrameInterval))|q(?:sort|uality)|f(?:scommand|i(?:n(?:d(?:Text|First|Last)?|ally)|eldInfo|lter(?:ed|Func)?|rst(?:Slide|Child|DayOfWeek|VisibleNode)?)|o(?:nt|cus(?:In|edCell|Out|Enabled)|r(?:egroundDisabled|mat(?:ter)?))|unctionName|ps|l(?:oor|ush)|ace|romCharCode)|w(?:i(?:th|dth)|ordWrap|atch|riteAccess)|l(?:t|i(?:st(?:Owner)?|ne(?:Style|To))|o(?:c(?:k|a(?:t(?:ion|eByld)|l(?:ToGlobal|FileReadDisable)))|opback|ad(?:Movie(?:Num)?|S(?:crollContent|ound)|ed|Variables(?:Num)?|Application)?|g(?:Changes)?)|e(?:ngth|ft(?:Margin)?|ading)?|a(?:st(?:Slide|Child|Index(?:Of)?)?|nguage|b(?:el(?:Placement|F(?:ield|unction))?|leField)))|a(?:s(?:scociate(?:Controller|Display)|in|pectRatio|function)|nd|c(?:ceptConnection|tiv(?:ityLevel|ePlayControl)|os)|t(?:t(?:ach(?:Movie|Sound|Video|Audio)|ributes)|an(?:2)?)|dd(?:header|RequestHeader|Menu(?:Item(?:At)?|At)?|Sort|Header|No(?:tice|de(?:At)?)|C(?:olumn(?:At)?|uePoint)|T(?:oLocalInternetCache|reeNode(?:At)?)|I(?:con|tem(?:s(?:At)?|At)?)|DeltaItem|P(?:od|age|roperty)|EventListener|View|FieldInfo|Listener|Animation)?|uto(?:Size|Play|KeyNav|Load)|pp(?:endChild|ly(?:Changes|Updates)?)|vHardwareDisable|fterLoaded|l(?:ternateRowColors|ign|l(?:ow(?:InsecureDomain|Domain)|Transitions(?:InDone|OutDone))|bum)|r(?:tist|row|g(?:uments|List))|gent|bs)|r(?:ight(?:Margin)?|o(?:ot(?:S(?:creen|lide)|Form)|und|w(?:Height|Count)|llO(?:ut|ver))|e(?:s(?:yncDepth|t(?:orePane|artAnimation|rict)|iz(?:e|able(?:Columns)?)|olveDelta|ult(?:s)?|ponse)|c(?:o(?:ncile(?:Results|Updates)|rd)|eive(?:Video|Audio))|draw|jectConnection|place(?:Sel|ItemAt|AllItems)?|ve(?:al(?:Child)?|rse)|quest(?:SizeChange|Payment)?|f(?:errer|resh(?:ScrollContent|Destinations|Pane|FromSources)?)|lease(?:Outside)?|ad(?:Only|Access)|gister(?:SkinElement|C(?:olor(?:Style|Name)|lass)|InheritingStyle|Proxy)|move(?:Range|M(?:ovieClip|enu(?:Item(?:At)?|At))|Background|Sort|No(?:tice|de(?:sAt|At)?)|C(?:olum(?:nAt|At)|uePoints)|T(?:extField|reeNode(?:At)?)|Item(?:At)?|Pod|EventListener|FromLocalInternetCache|Listener|All(?:C(?:olumns|uePoints)|Items)?))|a(?:ndom|te|dioDot))|g(?:t|oto(?:Slide|NextSlide|PreviousSlide|FirstSlide|LastSlide|And(?:Stop|Play))|e(?:nre|t(?:R(?:GB|o(?:otNode|wCount)|e(?:sizable|mote))|X(?:AxisTitle)?|M(?:i(?:n(?:imum(?:Size)?|utes)|lliseconds)|onth(?:Names)?|ultilineMode|e(?:ssage|nu(?:ItemAt|EnabledAt|At))|aximum(?:Size)?)|B(?:ytes(?:Total|Loaded)|ounds|utton(?:s|Width)|eginIndex|a(?:ndwidthLimit|ckground))|S(?:howAsDisabled|croll(?:ing|Speed|Content|Position|barState|Location)|t(?:yle(?:Names)?|opOnFocus|ate)|ize|o(?:urce|rtState)|p(?:litterBarPosition|acing)|e(?:conds|lect(?:Multiple|ion(?:Required|Type)|Style|ed(?:Node(?:s)?|Cell|Text|I(?:nd(?:ices|ex)|tem(?:s)?))?)|rvice)|moothness|WFVersion)|H(?:ighlight(?:s|Color)|ours|e(?:ight|ader(?:Height|Text|Property|Format|Width|Location)?)|as(?:Shader|CloseBox))|Y(?:ear|AxisTitle)?|N(?:o(?:tices|de(?:DisplayedAt|At))|um(?:Children|berAvailable)|e(?:wTextFormat|xtHighestDepth))|C(?:h(?:ild(?:S(?:creen|lide)|Nodes|Form|At)|artTitle)|o(?:n(?:tent|figInfo)|okie|de|unt|lumn(?:Names|Count|Index|At))|uePoint|ellIndex|loseHandler|a(?:ll|retIndex))|T(?:ypedValue|i(?:tle(?:barHeight)?|p(?:Target|Offset)?|me(?:stamp|zoneOffset|out(?:State|Handler)|r)?)|oggle|ext(?:Extent|Format)?|r(?:ee(?:NodeAt|Length)|ans(?:form|actionId)))|I(?:s(?:Branch|Open)|n(?:stanceAtDepth|d(?:icesByKey|exByKey))|con(?:SymbolName)?|te(?:rator|m(?:sByKey|By(?:Name|Key)|id|ID|At))|d)|O(?:utput(?:Parameter(?:s|ByName)?|Value(?:s)?)|peration|ri(?:entation|ginalCellData))|D(?:i(?:s(?:play(?:Range|Mode|Clip|Index|edMonth)|kUsage)|rection)|uration|e(?:pth|faultNodeIconSymbolName|l(?:taPacket|ay)|bug(?:Config|ID)?)|a(?:y(?:OfWeekNames)?|t(?:e|a(?:Mapping(?:s)?|Item(?:Text|Property|Format)|Label|All(?:Height|Property|Format|Width))?))|rawConnectors)|U(?:se(?:Shadow|HandCursor|rInput|Fade)|RL|TC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear))|P(?:o(?:sition|ds)|ercentComplete|a(?:n(?:e(?:M(?:inimums|aximums)|Height|Title|Width))?|rentNode)|r(?:operty(?:Name|Data)?|efer(?:ences|red(?:Height|Width))))|E(?:n(?:dIndex|abled)|ditingData|x(?:panderSymbolName|andNodeTrigger))|V(?:iewed(?:Pods|Applications)|olume|ersion|alue(?:Source)?)|F(?:i(?:eld|rst(?:DayOfWeek|VisibleNode))|o(?:ntList|cus)|ullYear|ade(?:InLength|OutLength)|rame(?:Color|Width))|Width|L(?:ine(?:Color|Weight)|o(?:cal|adTarget)|ength|a(?:stTabIndex|bel(?:Source)?))|A(?:s(?:cii|Boolean|String|Number)|n(?:yTypedValue|imation)|ctiv(?:eState(?:Handler)?|ateHandler)|utoH(?:ideScrollBar|eight)|llItems|gent))?)?|lobal(?:StyleFormat|ToLocal)?|ain|roupName)|x(?:updatePackety|mlDecl)?|m(?:y(?:MethodName|Call)|in(?:imum)?|o(?:nthNames|tion(?:TimeOut|Level)|de(?:lChanged)?|use(?:Move|O(?:ut|ver)|Down(?:Somewhere|Outside)?|Up(?:Somewhere)?|WheelEnabled)|ve(?:To)?)|u(?:ted|lti(?:pleS(?:imultaneousAllowed|elections)|line))|e(?:ssage|nu(?:Show|Hide)?|th(?:od)?|diaType)|a(?:nufacturer|tch|x(?:scroll|hscroll|imum|HPosition|Chars|VPosition)?)|b(?:substring|chr|ord|length))|b(?:ytes(?:Total|Loaded)|indFormat(?:Strings|Function)|o(?:ttom(?:Scroll)?|ld|rder(?:Color)?)|u(?:tton(?:Height|Width)|iltInItems|ffer(?:Time|Length)|llet)|e(?:foreApplyUpdates|gin(?:GradientFill|Fill))|lockIndent|a(?:ndwidth|ckground(?:Style|Color|Disabled)?)|roadcastMessage)|onHTTPStatus)\\b' },
            { token: 'support.constant.actionscript.2',
                regex: '\\b(?:__proto__|__resolve|_accProps|_alpha|_changed|_currentframe|_droptarget|_flash|_focusrect|_framesloaded|_global|_height|_highquality|_level|_listeners|_lockroot|_name|_parent|_quality|_root|_rotation|_soundbuftime|_target|_totalframes|_url|_visible|_width|_x|_xmouse|_xscale|_y|_ymouse|_yscale)\\b' },
            { token: 'keyword.control.actionscript.2',
                regex: '\\b(?:dynamic|extends|import|implements|interface|public|private|new|static|super|var|for|in|break|continue|while|do|return|if|else|case|switch)\\b' },
            { token: 'storage.type.actionscript.2',
                regex: '\\b(?:Boolean|Number|String|Void)\\b' },
            { token: 'constant.language.actionscript.2',
                regex: '\\b(?:null|undefined|true|false)\\b' },
            { token: 'constant.numeric.actionscript.2',
                regex: '\\b(?:0(?:x|X)[0-9a-fA-F]*|(?:[0-9]+\\.?[0-9]*|\\.[0-9]+)(?:(?:e|E)(?:\\+|-)?[0-9]+)?)(?:L|l|UL|ul|u|U|F|f)?\\b' },
            { token: 'punctuation.definition.string.begin.actionscript.2',
                regex: '"',
                push: [{ token: 'punctuation.definition.string.end.actionscript.2',
                        regex: '"',
                        next: 'pop' },
                    { token: 'constant.character.escape.actionscript.2',
                        regex: '\\\\.' },
                    { defaultToken: 'string.quoted.double.actionscript.2' }] },
            { token: 'punctuation.definition.string.begin.actionscript.2',
                regex: '\'',
                push: [{ token: 'punctuation.definition.string.end.actionscript.2',
                        regex: '\'',
                        next: 'pop' },
                    { token: 'constant.character.escape.actionscript.2',
                        regex: '\\\\.' },
                    { defaultToken: 'string.quoted.single.actionscript.2' }] },
            { token: 'support.constant.actionscript.2',
                regex: '\\b(?:BACKSPACE|CAPSLOCK|CONTROL|DELETEKEY|DOWN|END|ENTER|HOME|INSERT|LEFT|LN10|LN2|LOG10E|LOG2E|MAX_VALUE|MIN_VALUE|NEGATIVE_INFINITY|NaN|PGDN|PGUP|PI|POSITIVE_INFINITY|RIGHT|SPACE|SQRT1_2|SQRT2|UP)\\b' },
            { token: 'punctuation.definition.comment.actionscript.2',
                regex: '/\\*',
                push: [{ token: 'punctuation.definition.comment.actionscript.2',
                        regex: '\\*/',
                        next: 'pop' },
                    { defaultToken: 'comment.block.actionscript.2' }] },
            { token: 'punctuation.definition.comment.actionscript.2',
                regex: '//.*$',
                push_: [{ token: 'comment.line.double-slash.actionscript.2',
                        regex: '$',
                        next: 'pop' },
                    { defaultToken: 'comment.line.double-slash.actionscript.2' }] },
            { token: 'keyword.operator.actionscript.2',
                regex: '\\binstanceof\\b' },
            { token: 'keyword.operator.symbolic.actionscript.2',
                regex: '[-!%&*+=/?:]' },
            { token: ['meta.preprocessor.actionscript.2',
                    'punctuation.definition.preprocessor.actionscript.2',
                    'meta.preprocessor.actionscript.2'],
                regex: '^([ \\t]*)(#)([a-zA-Z]+)' },
            { token: ['storage.type.function.actionscript.2',
                    'meta.function.actionscript.2',
                    'entity.name.function.actionscript.2',
                    'meta.function.actionscript.2',
                    'punctuation.definition.parameters.begin.actionscript.2'],
                regex: '\\b(function)(\\s+)([a-zA-Z_]\\w*)(\\s*)(\\()',
                push: [{ token: 'punctuation.definition.parameters.end.actionscript.2',
                        regex: '\\)',
                        next: 'pop' },
                    { token: 'variable.parameter.function.actionscript.2',
                        regex: '[^,)$]+' },
                    { defaultToken: 'meta.function.actionscript.2' }] },
            { token: ['storage.type.class.actionscript.2',
                    'meta.class.actionscript.2',
                    'entity.name.type.class.actionscript.2',
                    'meta.class.actionscript.2',
                    'storage.modifier.extends.actionscript.2',
                    'meta.class.actionscript.2',
                    'entity.other.inherited-class.actionscript.2'],
                regex: '\\b(class)(\\s+)([a-zA-Z_](?:\\w|\\.)*)(?:(\\s+)(extends)(\\s+)([a-zA-Z_](?:\\w|\\.)*))?' }] };
    this.normalizeRules();
};
ActionScriptHighlightRules.metaData = { fileTypes: ['as'],
    keyEquivalent: '^~A',
    name: 'ActionScript',
    scopeName: 'source.actionscript.2' };
oop.inherits(ActionScriptHighlightRules, TextHighlightRules);
exports.ActionScriptHighlightRules = ActionScriptHighlightRules;

});

define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"], function(require, exports, module){"use strict";
var oop = require("../../lib/oop");
var Range = require("../../range").Range;
var BaseFoldMode = require("./fold_mode").FoldMode;
var FoldMode = exports.FoldMode = function (commentRegex) {
    if (commentRegex) {
        this.foldingStartMarker = new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/, "|" + commentRegex.start));
        this.foldingStopMarker = new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/, "|" + commentRegex.end));
    }
};
oop.inherits(FoldMode, BaseFoldMode);
(function () {
    this.foldingStartMarker = /([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/;
    this.foldingStopMarker = /^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/;
    this.singleLineBlockCommentRe = /^\s*(\/\*).*\*\/\s*$/;
    this.tripleStarBlockCommentRe = /^\s*(\/\*\*\*).*\*\/\s*$/;
    this.startRegionRe = /^\s*(\/\*|\/\/)#?region\b/;
    this._getFoldWidgetBase = this.getFoldWidget;
    this.getFoldWidget = function (session, foldStyle, row) {
        var line = session.getLine(row);
        if (this.singleLineBlockCommentRe.test(line)) {
            if (!this.startRegionRe.test(line) && !this.tripleStarBlockCommentRe.test(line))
                return "";
        }
        var fw = this._getFoldWidgetBase(session, foldStyle, row);
        if (!fw && this.startRegionRe.test(line))
            return "start"; // lineCommentRegionStart
        return fw;
    };
    this.getFoldWidgetRange = function (session, foldStyle, row, forceMultiline) {
        var line = session.getLine(row);
        if (this.startRegionRe.test(line))
            return this.getCommentRegionBlock(session, line, row);
        var match = line.match(this.foldingStartMarker);
        if (match) {
            var i = match.index;
            if (match[1])
                return this.openingBracketBlock(session, match[1], row, i);
            var range = session.getCommentFoldRange(row, i + match[0].length, 1);
            if (range && !range.isMultiLine()) {
                if (forceMultiline) {
                    range = this.getSectionRange(session, row);
                }
                else if (foldStyle != "all")
                    range = null;
            }
            return range;
        }
        if (foldStyle === "markbegin")
            return;
        var match = line.match(this.foldingStopMarker);
        if (match) {
            var i = match.index + match[0].length;
            if (match[1])
                return this.closingBracketBlock(session, match[1], row, i);
            return session.getCommentFoldRange(row, i, -1);
        }
    };
    this.getSectionRange = function (session, row) {
        var line = session.getLine(row);
        var startIndent = line.search(/\S/);
        var startRow = row;
        var startColumn = line.length;
        row = row + 1;
        var endRow = row;
        var maxRow = session.getLength();
        while (++row < maxRow) {
            line = session.getLine(row);
            var indent = line.search(/\S/);
            if (indent === -1)
                continue;
            if (startIndent > indent)
                break;
            var subRange = this.getFoldWidgetRange(session, "all", row);
            if (subRange) {
                if (subRange.start.row <= startRow) {
                    break;
                }
                else if (subRange.isMultiLine()) {
                    row = subRange.end.row;
                }
                else if (startIndent == indent) {
                    break;
                }
            }
            endRow = row;
        }
        return new Range(startRow, startColumn, endRow, session.getLine(endRow).length);
    };
    this.getCommentRegionBlock = function (session, line, row) {
        var startColumn = line.search(/\s*$/);
        var maxRow = session.getLength();
        var startRow = row;
        var re = /^\s*(?:\/\*|\/\/|--)#?(end)?region\b/;
        var depth = 1;
        while (++row < maxRow) {
            line = session.getLine(row);
            var m = re.exec(line);
            if (!m)
                continue;
            if (m[1])
                depth--;
            else
                depth++;
            if (!depth)
                break;
        }
        var endRow = row;
        if (endRow > startRow) {
            return new Range(startRow, startColumn, endRow, line.length);
        }
    };
}).call(FoldMode.prototype);

});

define("ace/mode/actionscript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/actionscript_highlight_rules","ace/mode/folding/cstyle"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY mode.tmpl.js
*/
"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var ActionScriptHighlightRules = require("./actionscript_highlight_rules").ActionScriptHighlightRules;
var FoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = ActionScriptHighlightRules;
    this.foldingRules = new FoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "//";
    this.blockComment = { start: "/*", end: "*/" };
    this.$id = "ace/mode/actionscript";
    this.snippetFileId = "ace/snippets/actionscript";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/ada_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var AdaHighlightRules = function () {
    var keywords = "abort|else|new|return|abs|elsif|not|reverse|abstract|end|null|accept|entry|select|" +
        "access|exception|of|separate|aliased|exit|or|some|all|others|subtype|and|for|out|synchronized|" +
        "array|function|overriding|at|tagged|generic|package|task|begin|goto|pragma|terminate|" +
        "body|private|then|if|procedure|type|case|in|protected|constant|interface|until|" +
        "|is|raise|use|declare|range|delay|limited|record|when|delta|loop|rem|while|digits|renames|with|do|mod|requeue|xor";
    var builtinConstants = ("true|false|null");
    var builtinFunctions = ("count|min|max|avg|sum|rank|now|coalesce|main");
    var keywordMapper = this.createKeywordMapper({
        "support.function": builtinFunctions,
        "keyword": keywords,
        "constant.language": builtinConstants
    }, "identifier", true);
    this.$rules = {
        "start": [{
                token: "comment",
                regex: "--.*$"
            }, {
                token: "string",
                regex: '".*?"'
            }, {
                token: "string",
                regex: "'.'"
            }, {
                token: "constant.numeric",
                regex: "[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"
            }, {
                token: keywordMapper,
                regex: "[a-zA-Z_$][a-zA-Z0-9_$]*\\b"
            }, {
                token: "keyword.operator",
                regex: "\\+|\\-|\\/|\\/\\/|%|<@>|@>|<@|&|\\^|~|<|>|<=|=>|==|!=|<>|="
            }, {
                token: "paren.lparen",
                regex: "[\\(]"
            }, {
                token: "paren.rparen",
                regex: "[\\)]"
            }, {
                token: "text",
                regex: "\\s+"
            }]
    };
};
oop.inherits(AdaHighlightRules, TextHighlightRules);
exports.AdaHighlightRules = AdaHighlightRules;

});

define("ace/mode/ada",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/ada_highlight_rules","ace/range"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var AdaHighlightRules = require("./ada_highlight_rules").AdaHighlightRules;
var Range = require("../range").Range;
var Mode = function () {
    this.HighlightRules = AdaHighlightRules;
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "--";
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        var tokenizedLine = this.getTokenizer().getLineTokens(line, state);
        var tokens = tokenizedLine.tokens;
        if (tokens.length && tokens[tokens.length - 1].type == "comment") {
            return indent;
        }
        if (state == "start") {
            var match = line.match(/^.*(begin|loop|then|is|do)\s*$/);
            if (match) {
                indent += tab;
            }
        }
        return indent;
    };
    this.checkOutdent = function (state, line, input) {
        var complete_line = line + input;
        if (complete_line.match(/^\s*(begin|end)$/)) {
            return true;
        }
        return false;
    };
    this.autoOutdent = function (state, session, row) {
        var line = session.getLine(row);
        var prevLine = session.getLine(row - 1);
        var prevIndent = this.$getIndent(prevLine).length;
        var indent = this.$getIndent(line).length;
        if (indent <= prevIndent) {
            return;
        }
        session.outdentRows(new Range(row, 0, row + 2, 0));
    };
    this.$id = "ace/mode/ada";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/applescript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var AppleScriptHighlightRules = function () {
    var keywords = ("about|above|after|against|and|around|as|at|back|before|beginning|" +
        "behind|below|beneath|beside|between|but|by|considering|" +
        "contain|contains|continue|copy|div|does|eighth|else|end|equal|" +
        "equals|error|every|exit|fifth|first|for|fourth|from|front|" +
        "get|given|global|if|ignoring|in|into|is|it|its|last|local|me|" +
        "middle|mod|my|ninth|not|of|on|onto|or|over|prop|property|put|ref|" +
        "reference|repeat|returning|script|second|set|seventh|since|" +
        "sixth|some|tell|tenth|that|the|then|third|through|thru|" +
        "timeout|times|to|transaction|try|until|where|while|whose|with|without");
    var builtinConstants = ("AppleScript|false|linefeed|return|pi|quote|result|space|tab|true");
    var builtinFunctions = ("activate|beep|count|delay|launch|log|offset|read|round|run|say|" +
        "summarize|write");
    var builtinTypes = ("alias|application|boolean|class|constant|date|file|integer|list|" +
        "number|real|record|string|text|character|characters|contents|day|" +
        "frontmost|id|item|length|month|name|paragraph|paragraphs|rest|" +
        "reverse|running|time|version|weekday|word|words|year");
    var keywordMapper = this.createKeywordMapper({
        "support.function": builtinFunctions,
        "constant.language": builtinConstants,
        "support.type": builtinTypes,
        "keyword": keywords
    }, "identifier");
    this.$rules = {
        "start": [
            {
                token: "comment",
                regex: "--.*$"
            },
            {
                token: "comment",
                regex: "\\(\\*",
                next: "comment"
            },
            {
                token: "string",
                regex: '".*?"'
            },
            {
                token: "support.type",
                regex: '\\b(POSIX file|POSIX path|(date|time) string|quoted form)\\b'
            },
            {
                token: "support.function",
                regex: '\\b(clipboard info|the clipboard|info for|list (disks|folder)|' +
                    'mount volume|path to|(close|open for) access|(get|set) eof|' +
                    'current date|do shell script|get volume settings|random number|' +
                    'set volume|system attribute|system info|time to GMT|' +
                    '(load|run|store) script|scripting components|' +
                    'ASCII (character|number)|localized string|' +
                    'choose (application|color|file|file name|' +
                    'folder|from list|remote application|URL)|' +
                    'display (alert|dialog))\\b|^\\s*return\\b'
            },
            {
                token: "constant.language",
                regex: '\\b(text item delimiters|current application|missing value)\\b'
            },
            {
                token: "keyword",
                regex: '\\b(apart from|aside from|instead of|out of|greater than|' +
                    "isn't|(doesn't|does not) (equal|come before|come after|contain)|" +
                    '(greater|less) than( or equal)?|(starts?|ends|begins?) with|' +
                    'contained by|comes (before|after)|a (ref|reference))\\b'
            },
            {
                token: keywordMapper,
                regex: "[a-zA-Z][a-zA-Z0-9_]*\\b"
            }
        ],
        "comment": [
            {
                token: "comment",
                regex: "\\*\\)",
                next: "start"
            }, {
                defaultToken: "comment"
            }
        ]
    };
    this.normalizeRules();
};
oop.inherits(AppleScriptHighlightRules, TextHighlightRules);
exports.AppleScriptHighlightRules = AppleScriptHighlightRules;

});

define("ace/mode/applescript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/applescript_highlight_rules","ace/mode/folding/cstyle"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var AppleScriptHighlightRules = require("./applescript_highlight_rules").AppleScriptHighlightRules;
var FoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = AppleScriptHighlightRules;
    this.foldingRules = new FoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "--";
    this.blockComment = { start: "(*", end: "*)" };
    this.$id = "ace/mode/applescript";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/asciidoc_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var AsciidocHighlightRules = function () {
    var identifierRe = "[a-zA-Z\u00a1-\uffff]+\\b";
    this.$rules = {
        "start": [
            { token: "empty", regex: /$/ },
            { token: "literal", regex: /^\.{4,}\s*$/, next: "listingBlock" },
            { token: "literal", regex: /^-{4,}\s*$/, next: "literalBlock" },
            { token: "string", regex: /^\+{4,}\s*$/, next: "passthroughBlock" },
            { token: "keyword", regex: /^={4,}\s*$/ },
            { token: "text", regex: /^\s*$/ },
            { token: "empty", regex: "", next: "dissallowDelimitedBlock" }
        ],
        "dissallowDelimitedBlock": [
            { include: "paragraphEnd" },
            { token: "comment", regex: '^//.+$' },
            { token: "keyword", regex: "^(?:NOTE|TIP|IMPORTANT|WARNING|CAUTION):" },
            { include: "listStart" },
            { token: "literal", regex: /^\s+.+$/, next: "indentedBlock" },
            { token: "empty", regex: "", next: "text" }
        ],
        "paragraphEnd": [
            { token: "doc.comment", regex: /^\/{4,}\s*$/, next: "commentBlock" },
            { token: "tableBlock", regex: /^\s*[|!]=+\s*$/, next: "tableBlock" },
            { token: "keyword", regex: /^(?:--|''')\s*$/, next: "start" },
            { token: "option", regex: /^\[.*\]\s*$/, next: "start" },
            { token: "pageBreak", regex: /^>{3,}$/, next: "start" },
            { token: "literal", regex: /^\.{4,}\s*$/, next: "listingBlock" },
            { token: "titleUnderline", regex: /^(?:={2,}|-{2,}|~{2,}|\^{2,}|\+{2,})\s*$/, next: "start" },
            { token: "singleLineTitle", regex: /^={1,5}\s+\S.*$/, next: "start" },
            { token: "otherBlock", regex: /^(?:\*{2,}|_{2,})\s*$/, next: "start" },
            { token: "optionalTitle", regex: /^\.[^.\s].+$/, next: "start" }
        ],
        "listStart": [
            { token: "keyword", regex: /^\s*(?:\d+\.|[a-zA-Z]\.|[ixvmIXVM]+\)|\*{1,5}|-|\.{1,5})\s/, next: "listText" },
            { token: "meta.tag", regex: /^.+(?::{2,4}|;;)(?: |$)/, next: "listText" },
            { token: "support.function.list.callout", regex: /^(?:<\d+>|\d+>|>) /, next: "text" },
            { token: "keyword", regex: /^\+\s*$/, next: "start" }
        ],
        "text": [
            { token: ["link", "variable.language"], regex: /((?:https?:\/\/|ftp:\/\/|file:\/\/|mailto:|callto:)[^\s\[]+)(\[.*?\])/ },
            { token: "link", regex: /(?:https?:\/\/|ftp:\/\/|file:\/\/|mailto:|callto:)[^\s\[]+/ },
            { token: "link", regex: /\b[\w\.\/\-]+@[\w\.\/\-]+\b/ },
            { include: "macros" },
            { include: "paragraphEnd" },
            { token: "literal", regex: /\+{3,}/, next: "smallPassthrough" },
            { token: "escape", regex: /\((?:C|TM|R)\)|\.{3}|->|<-|=>|<=|&#(?:\d+|x[a-fA-F\d]+);|(?: |^)--(?=\s+\S)/ },
            { token: "escape", regex: /\\[_*'`+#]|\\{2}[_*'`+#]{2}/ },
            { token: "keyword", regex: /\s\+$/ },
            { token: "text", regex: identifierRe },
            { token: ["keyword", "string", "keyword"],
                regex: /(<<[\w\d\-$]+,)(.*?)(>>|$)/ },
            { token: "keyword", regex: /<<[\w\d\-$]+,?|>>/ },
            { token: "constant.character", regex: /\({2,3}.*?\){2,3}/ },
            { token: "keyword", regex: /\[\[.+?\]\]/ },
            { token: "support", regex: /^\[{3}[\w\d =\-]+\]{3}/ },
            { include: "quotes" },
            { token: "empty", regex: /^\s*$/, next: "start" }
        ],
        "listText": [
            { include: "listStart" },
            { include: "text" }
        ],
        "indentedBlock": [
            { token: "literal", regex: /^[\s\w].+$/, next: "indentedBlock" },
            { token: "literal", regex: "", next: "start" }
        ],
        "listingBlock": [
            { token: "literal", regex: /^\.{4,}\s*$/, next: "dissallowDelimitedBlock" },
            { token: "constant.numeric", regex: '<\\d+>' },
            { token: "literal", regex: '[^<]+' },
            { token: "literal", regex: '<' }
        ],
        "literalBlock": [
            { token: "literal", regex: /^-{4,}\s*$/, next: "dissallowDelimitedBlock" },
            { token: "constant.numeric", regex: '<\\d+>' },
            { token: "literal", regex: '[^<]+' },
            { token: "literal", regex: '<' }
        ],
        "passthroughBlock": [
            { token: "literal", regex: /^\+{4,}\s*$/, next: "dissallowDelimitedBlock" },
            { token: "literal", regex: identifierRe + "|\\d+" },
            { include: "macros" },
            { token: "literal", regex: "." }
        ],
        "smallPassthrough": [
            { token: "literal", regex: /[+]{3,}/, next: "dissallowDelimitedBlock" },
            { token: "literal", regex: /^\s*$/, next: "dissallowDelimitedBlock" },
            { token: "literal", regex: identifierRe + "|\\d+" },
            { include: "macros" }
        ],
        "commentBlock": [
            { token: "doc.comment", regex: /^\/{4,}\s*$/, next: "dissallowDelimitedBlock" },
            { token: "doc.comment", regex: '^.*$' }
        ],
        "tableBlock": [
            { token: "tableBlock", regex: /^\s*\|={3,}\s*$/, next: "dissallowDelimitedBlock" },
            { token: "tableBlock", regex: /^\s*!={3,}\s*$/, next: "innerTableBlock" },
            { token: "tableBlock", regex: /\|/ },
            { include: "text", noEscape: true }
        ],
        "innerTableBlock": [
            { token: "tableBlock", regex: /^\s*!={3,}\s*$/, next: "tableBlock" },
            { token: "tableBlock", regex: /^\s*|={3,}\s*$/, next: "dissallowDelimitedBlock" },
            { token: "tableBlock", regex: /!/ }
        ],
        "macros": [
            { token: "macro", regex: /{[\w\-$]+}/ },
            { token: ["text", "string", "text", "constant.character", "text"], regex: /({)([\w\-$]+)(:)?(.+)?(})/ },
            { token: ["text", "markup.list.macro", "keyword", "string"], regex: /(\w+)(footnote(?:ref)?::?)([^\s\[]+)?(\[.*?\])?/ },
            { token: ["markup.list.macro", "keyword", "string"], regex: /([a-zA-Z\-][\w\.\/\-]*::?)([^\s\[]+)(\[.*?\])?/ },
            { token: ["markup.list.macro", "keyword"], regex: /([a-zA-Z\-][\w\.\/\-]+::?)(\[.*?\])/ },
            { token: "keyword", regex: /^:.+?:(?= |$)/ }
        ],
        "quotes": [
            { token: "string.italic", regex: /__[^_\s].*?__/ },
            { token: "string.italic", regex: quoteRule("_") },
            { token: "keyword.bold", regex: /\*\*[^*\s].*?\*\*/ },
            { token: "keyword.bold", regex: quoteRule("\\*") },
            { token: "literal", regex: quoteRule("\\+") },
            { token: "literal", regex: /\+\+[^+\s].*?\+\+/ },
            { token: "literal", regex: /\$\$.+?\$\$/ },
            { token: "literal", regex: quoteRule("`") },
            { token: "keyword", regex: quoteRule("^") },
            { token: "keyword", regex: quoteRule("~") },
            { token: "keyword", regex: /##?/ },
            { token: "keyword", regex: /(?:\B|^)``|\b''/ }
        ]
    };
    function quoteRule(ch) {
        var prefix = /\w/.test(ch) ? "\\b" : "(?:\\B|^)";
        return prefix + ch + "[^" + ch + "].*?" + ch + "(?![\\w*])";
    }
    var tokenMap = {
        macro: "constant.character",
        tableBlock: "doc.comment",
        titleUnderline: "markup.heading",
        singleLineTitle: "markup.heading",
        pageBreak: "string",
        option: "string.regexp",
        otherBlock: "markup.list",
        literal: "support.function",
        optionalTitle: "constant.numeric",
        escape: "constant.language.escape",
        link: "markup.underline.list"
    };
    for (var state in this.$rules) {
        var stateRules = this.$rules[state];
        for (var i = stateRules.length; i--;) {
            var rule = stateRules[i];
            if (rule.include || typeof rule == "string") {
                var args = [i, 1].concat(this.$rules[rule.include || rule]);
                if (rule.noEscape) {
                    args = args.filter(function (x) {
                        return !x.next;
                    });
                }
                stateRules.splice.apply(stateRules, args);
            }
            else if (rule.token in tokenMap) {
                rule.token = tokenMap[rule.token];
            }
        }
    }
};
oop.inherits(AsciidocHighlightRules, TextHighlightRules);
exports.AsciidocHighlightRules = AsciidocHighlightRules;

});

define("ace/mode/folding/asciidoc",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range"], function(require, exports, module){"use strict";
var oop = require("../../lib/oop");
var BaseFoldMode = require("./fold_mode").FoldMode;
var Range = require("../../range").Range;
var FoldMode = exports.FoldMode = function () { };
oop.inherits(FoldMode, BaseFoldMode);
(function () {
    this.foldingStartMarker = /^(?:\|={10,}|[\.\/=\-~^+]{4,}\s*$|={1,5} )/;
    this.singleLineHeadingRe = /^={1,5}(?=\s+\S)/;
    this.getFoldWidget = function (session, foldStyle, row) {
        var line = session.getLine(row);
        if (!this.foldingStartMarker.test(line))
            return "";
        if (line[0] == "=") {
            if (this.singleLineHeadingRe.test(line))
                return "start";
            if (session.getLine(row - 1).length != session.getLine(row).length)
                return "";
            return "start";
        }
        if (session.bgTokenizer.getState(row) == "dissallowDelimitedBlock")
            return "end";
        return "start";
    };
    this.getFoldWidgetRange = function (session, foldStyle, row) {
        var line = session.getLine(row);
        var startColumn = line.length;
        var maxRow = session.getLength();
        var startRow = row;
        var endRow = row;
        if (!line.match(this.foldingStartMarker))
            return;
        var token;
        function getTokenType(row) {
            token = session.getTokens(row)[0];
            return token && token.type;
        }
        var levels = ["=", "-", "~", "^", "+"];
        var heading = "markup.heading";
        var singleLineHeadingRe = this.singleLineHeadingRe;
        function getLevel() {
            var match = token.value.match(singleLineHeadingRe);
            if (match)
                return match[0].length;
            var level = levels.indexOf(token.value[0]) + 1;
            if (level == 1) {
                if (session.getLine(row - 1).length != session.getLine(row).length)
                    return Infinity;
            }
            return level;
        }
        if (getTokenType(row) == heading) {
            var startHeadingLevel = getLevel();
            while (++row < maxRow) {
                if (getTokenType(row) != heading)
                    continue;
                var level = getLevel();
                if (level <= startHeadingLevel)
                    break;
            }
            var isSingleLineHeading = token && token.value.match(this.singleLineHeadingRe);
            endRow = isSingleLineHeading ? row - 1 : row - 2;
            if (endRow > startRow) {
                while (endRow > startRow && (!getTokenType(endRow) || token.value[0] == "["))
                    endRow--;
            }
            if (endRow > startRow) {
                var endColumn = session.getLine(endRow).length;
                return new Range(startRow, startColumn, endRow, endColumn);
            }
        }
        else {
            var state = session.bgTokenizer.getState(row);
            if (state == "dissallowDelimitedBlock") {
                while (row-- > 0) {
                    if (session.bgTokenizer.getState(row).lastIndexOf("Block") == -1)
                        break;
                }
                endRow = row + 1;
                if (endRow < startRow) {
                    var endColumn = session.getLine(row).length;
                    return new Range(endRow, 5, startRow, startColumn - 5);
                }
            }
            else {
                while (++row < maxRow) {
                    if (session.bgTokenizer.getState(row) == "dissallowDelimitedBlock")
                        break;
                }
                endRow = row;
                if (endRow > startRow) {
                    var endColumn = session.getLine(row).length;
                    return new Range(startRow, 5, endRow, endColumn - 5);
                }
            }
        }
    };
}).call(FoldMode.prototype);

});

define("ace/mode/asciidoc",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/asciidoc_highlight_rules","ace/mode/folding/asciidoc"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var AsciidocHighlightRules = require("./asciidoc_highlight_rules").AsciidocHighlightRules;
var AsciidocFoldMode = require("./folding/asciidoc").FoldMode;
var Mode = function () {
    this.HighlightRules = AsciidocHighlightRules;
    this.foldingRules = new AsciidocFoldMode();
};
oop.inherits(Mode, TextMode);
(function () {
    this.type = "text";
    this.getNextLineIndent = function (state, line, tab) {
        if (state == "listblock") {
            var match = /^((?:.+)?)([-+*][ ]+)/.exec(line);
            if (match) {
                return new Array(match[1].length + 1).join(" ") + match[2];
            }
            else {
                return "";
            }
        }
        else {
            return this.$getIndent(line);
        }
    };
    this.$id = "ace/mode/asciidoc";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/autohotkey_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){/* This file was autogenerated from C:\Users\LED\Desktop\AutoHotKey.tmLanguage (uuid: ) */
"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var AutoHotKeyHighlightRules = function () {
    var autoItKeywords = 'And|ByRef|Case|Const|ContinueCase|ContinueLoop|Default|Dim|Do|Else|ElseIf|EndFunc|EndIf|EndSelect|EndSwitch|EndWith|Enum|Exit|ExitLoop|False|For|Func|Global|If|In|Local|Next|Not|Or|ReDim|Return|Select|Step|Switch|Then|To|True|Until|WEnd|While|With|' +
        'Abs|ACos|AdlibDisable|AdlibEnable|Asc|AscW|ASin|Assign|ATan|AutoItSetOption|AutoItWinGetTitle|AutoItWinSetTitle|Beep|Binary|BinaryLen|BinaryMid|BinaryToString|BitAND|BitNOT|BitOR|BitRotate|BitShift|BitXOR|BlockInput|Break|Call|CDTray|Ceiling|Chr|ChrW|ClipGet|ClipPut|ConsoleRead|ConsoleWrite|ConsoleWriteError|ControlClick|ControlCommand|ControlDisable|ControlEnable|ControlFocus|ControlGetFocus|ControlGetHandle|ControlGetPos|ControlGetText|ControlHide|ControlListView|ControlMove|ControlSend|ControlSetText|ControlShow|ControlTreeView|Cos|Dec|DirCopy|DirCreate|DirGetSize|DirMove|DirRemove|DllCall|DllCallbackFree|DllCallbackGetPtr|DllCallbackRegister|DllClose|DllOpen|DllStructCreate|DllStructGetData|DllStructGetPtr|DllStructGetSize|DllStructSetData|DriveGetDrive|DriveGetFileSystem|DriveGetLabel|DriveGetSerial|DriveGetType|DriveMapAdd|DriveMapDel|DriveMapGet|DriveSetLabel|DriveSpaceFree|DriveSpaceTotal|DriveStatus|EnvGet|EnvSet|EnvUpdate|Eval|Execute|Exp|FileChangeDir|FileClose|FileCopy|FileCreateNTFSLink|FileCreateShortcut|FileDelete|FileExists|FileFindFirstFile|FileFindNextFile|FileGetAttrib|FileGetLongName|FileGetShortcut|FileGetShortName|FileGetSize|FileGetTime|FileGetVersion|FileInstall|FileMove|FileOpen|FileOpenDialog|FileRead|FileReadLine|FileRecycle|FileRecycleEmpty|FileSaveDialog|FileSelectFolder|FileSetAttrib|FileSetTime|FileWrite|FileWriteLine|Floor|FtpSetProxy|GUICreate|GUICtrlCreateAvi|GUICtrlCreateButton|GUICtrlCreateCheckbox|GUICtrlCreateCombo|GUICtrlCreateContextMenu|GUICtrlCreateDate|GUICtrlCreateDummy|GUICtrlCreateEdit|GUICtrlCreateGraphic|GUICtrlCreateGroup|GUICtrlCreateIcon|GUICtrlCreateInput|GUICtrlCreateLabel|GUICtrlCreateList|GUICtrlCreateListView|GUICtrlCreateListViewItem|GUICtrlCreateMenu|GUICtrlCreateMenuItem|GUICtrlCreateMonthCal|GUICtrlCreateObj|GUICtrlCreatePic|GUICtrlCreateProgress|GUICtrlCreateRadio|GUICtrlCreateSlider|GUICtrlCreateTab|GUICtrlCreateTabItem|GUICtrlCreateTreeView|GUICtrlCreateTreeViewItem|GUICtrlCreateUpdown|GUICtrlDelete|GUICtrlGetHandle|GUICtrlGetState|GUICtrlRead|GUICtrlRecvMsg|GUICtrlRegisterListViewSort|GUICtrlSendMsg|GUICtrlSendToDummy|GUICtrlSetBkColor|GUICtrlSetColor|GUICtrlSetCursor|GUICtrlSetData|GUICtrlSetFont|GUICtrlSetDefColor|GUICtrlSetDefBkColor|GUICtrlSetGraphic|GUICtrlSetImage|GUICtrlSetLimit|GUICtrlSetOnEvent|GUICtrlSetPos|GUICtrlSetResizing|GUICtrlSetState|GUICtrlSetStyle|GUICtrlSetTip|GUIDelete|GUIGetCursorInfo|GUIGetMsg|GUIGetStyle|GUIRegisterMsg|GUISetAccelerators()|GUISetBkColor|GUISetCoord|GUISetCursor|GUISetFont|GUISetHelp|GUISetIcon|GUISetOnEvent|GUISetState|GUISetStyle|GUIStartGroup|GUISwitch|Hex|HotKeySet|HttpSetProxy|HWnd|InetGet|InetGetSize|IniDelete|IniRead|IniReadSection|IniReadSectionNames|IniRenameSection|IniWrite|IniWriteSection|InputBox|Int|IsAdmin|IsArray|IsBinary|IsBool|IsDeclared|IsDllStruct|IsFloat|IsHWnd|IsInt|IsKeyword|IsNumber|IsObj|IsPtr|IsString|Log|MemGetStats|Mod|MouseClick|MouseClickDrag|MouseDown|MouseGetCursor|MouseGetPos|MouseMove|MouseUp|MouseWheel|MsgBox|Number|ObjCreate|ObjEvent|ObjGet|ObjName|Opt|Ping|PixelChecksum|PixelGetColor|PixelSearch|PluginClose|PluginOpen|ProcessClose|ProcessExists|ProcessGetStats|ProcessList|ProcessSetPriority|ProcessWait|ProcessWaitClose|ProgressOff|ProgressOn|ProgressSet|Ptr|Random|RegDelete|RegEnumKey|RegEnumVal|RegRead|RegWrite|Round|Run|RunAs|RunAsWait|RunWait|Send|SendKeepActive|SetError|SetExtended|ShellExecute|ShellExecuteWait|Shutdown|Sin|Sleep|SoundPlay|SoundSetWaveVolume|SplashImageOn|SplashOff|SplashTextOn|Sqrt|SRandom|StatusbarGetText|StderrRead|StdinWrite|StdioClose|StdoutRead|String|StringAddCR|StringCompare|StringFormat|StringInStr|StringIsAlNum|StringIsAlpha|StringIsASCII|StringIsDigit|StringIsFloat|StringIsInt|StringIsLower|StringIsSpace|StringIsUpper|StringIsXDigit|StringLeft|StringLen|StringLower|StringMid|StringRegExp|StringRegExpReplace|StringReplace|StringRight|StringSplit|StringStripCR|StringStripWS|StringToBinary|StringTrimLeft|StringTrimRight|StringUpper|Tan|TCPAccept|TCPCloseSocket|TCPConnect|TCPListen|TCPNameToIP|TCPRecv|TCPSend|TCPShutdown|TCPStartup|TimerDiff|TimerInit|ToolTip|TrayCreateItem|TrayCreateMenu|TrayGetMsg|TrayItemDelete|TrayItemGetHandle|TrayItemGetState|TrayItemGetText|TrayItemSetOnEvent|TrayItemSetState|TrayItemSetText|TraySetClick|TraySetIcon|TraySetOnEvent|TraySetPauseIcon|TraySetState|TraySetToolTip|TrayTip|UBound|UDPBind|UDPCloseSocket|UDPOpen|UDPRecv|UDPSend|UDPShutdown|UDPStartup|VarGetType|WinActivate|WinActive|WinClose|WinExists|WinFlash|WinGetCaretPos|WinGetClassList|WinGetClientSize|WinGetHandle|WinGetPos|WinGetProcess|WinGetState|WinGetText|WinGetTitle|WinKill|WinList|WinMenuSelectItem|WinMinimizeAll|WinMinimizeAllUndo|WinMove|WinSetOnTop|WinSetState|WinSetTitle|WinSetTrans|WinWait|WinWaitActive|WinWaitClose|WinWaitNotActive|' +
        'ArrayAdd|ArrayBinarySearch|ArrayConcatenate|ArrayDelete|ArrayDisplay|ArrayFindAll|ArrayInsert|ArrayMax|ArrayMaxIndex|ArrayMin|ArrayMinIndex|ArrayPop|ArrayPush|ArrayReverse|ArraySearch|ArraySort|ArraySwap|ArrayToClip|ArrayToString|ArrayTrim|ChooseColor|ChooseFont|ClipBoard_ChangeChain|ClipBoard_Close|ClipBoard_CountFormats|ClipBoard_Empty|ClipBoard_EnumFormats|ClipBoard_FormatStr|ClipBoard_GetData|ClipBoard_GetDataEx|ClipBoard_GetFormatName|ClipBoard_GetOpenWindow|ClipBoard_GetOwner|ClipBoard_GetPriorityFormat|ClipBoard_GetSequenceNumber|ClipBoard_GetViewer|ClipBoard_IsFormatAvailable|ClipBoard_Open|ClipBoard_RegisterFormat|ClipBoard_SetData|ClipBoard_SetDataEx|ClipBoard_SetViewer|ClipPutFile|ColorConvertHSLtoRGB|ColorConvertRGBtoHSL|ColorGetBlue|ColorGetGreen|ColorGetRed|Date_Time_CompareFileTime|Date_Time_DOSDateTimeToArray|Date_Time_DOSDateTimeToFileTime|Date_Time_DOSDateTimeToStr|Date_Time_DOSDateToArray|Date_Time_DOSDateToStr|Date_Time_DOSTimeToArray|Date_Time_DOSTimeToStr|Date_Time_EncodeFileTime|Date_Time_EncodeSystemTime|Date_Time_FileTimeToArray|Date_Time_FileTimeToDOSDateTime|Date_Time_FileTimeToLocalFileTime|Date_Time_FileTimeToStr|Date_Time_FileTimeToSystemTime|Date_Time_GetFileTime|Date_Time_GetLocalTime|Date_Time_GetSystemTime|Date_Time_GetSystemTimeAdjustment|Date_Time_GetSystemTimeAsFileTime|Date_Time_GetSystemTimes|Date_Time_GetTickCount|Date_Time_GetTimeZoneInformation|Date_Time_LocalFileTimeToFileTime|Date_Time_SetFileTime|Date_Time_SetLocalTime|Date_Time_SetSystemTime|Date_Time_SetSystemTimeAdjustment|Date_Time_SetTimeZoneInformation|Date_Time_SystemTimeToArray|Date_Time_SystemTimeToDateStr|Date_Time_SystemTimeToDateTimeStr|Date_Time_SystemTimeToFileTime|Date_Time_SystemTimeToTimeStr|Date_Time_SystemTimeToTzSpecificLocalTime|Date_Time_TzSpecificLocalTimeToSystemTime|DateAdd|DateDayOfWeek|DateDaysInMonth|DateDiff|DateIsLeapYear|DateIsValid|DateTimeFormat|DateTimeSplit|DateToDayOfWeek|DateToDayOfWeekISO|DateToDayValue|DateToMonth|DayValueToDate|DebugBugReportEnv|DebugOut|DebugSetup|Degree|EventLog__Backup|EventLog__Clear|EventLog__Close|EventLog__Count|EventLog__DeregisterSource|EventLog__Full|EventLog__Notify|EventLog__Oldest|EventLog__Open|EventLog__OpenBackup|EventLog__Read|EventLog__RegisterSource|EventLog__Report|FileCountLines|FileCreate|FileListToArray|FilePrint|FileReadToArray|FileWriteFromArray|FileWriteLog|FileWriteToLine|GDIPlus_ArrowCapCreate|GDIPlus_ArrowCapDispose|GDIPlus_ArrowCapGetFillState|GDIPlus_ArrowCapGetHeight|GDIPlus_ArrowCapGetMiddleInset|GDIPlus_ArrowCapGetWidth|GDIPlus_ArrowCapSetFillState|GDIPlus_ArrowCapSetHeight|GDIPlus_ArrowCapSetMiddleInset|GDIPlus_ArrowCapSetWidth|GDIPlus_BitmapCloneArea|GDIPlus_BitmapCreateFromFile|GDIPlus_BitmapCreateFromGraphics|GDIPlus_BitmapCreateFromHBITMAP|GDIPlus_BitmapCreateHBITMAPFromBitmap|GDIPlus_BitmapDispose|GDIPlus_BitmapLockBits|GDIPlus_BitmapUnlockBits|GDIPlus_BrushClone|GDIPlus_BrushCreateSolid|GDIPlus_BrushDispose|GDIPlus_BrushGetType|GDIPlus_CustomLineCapDispose|GDIPlus_Decoders|GDIPlus_DecodersGetCount|GDIPlus_DecodersGetSize|GDIPlus_Encoders|GDIPlus_EncodersGetCLSID|GDIPlus_EncodersGetCount|GDIPlus_EncodersGetParamList|GDIPlus_EncodersGetParamListSize|GDIPlus_EncodersGetSize|GDIPlus_FontCreate|GDIPlus_FontDispose|GDIPlus_FontFamilyCreate|GDIPlus_FontFamilyDispose|GDIPlus_GraphicsClear|GDIPlus_GraphicsCreateFromHDC|GDIPlus_GraphicsCreateFromHWND|GDIPlus_GraphicsDispose|GDIPlus_GraphicsDrawArc|GDIPlus_GraphicsDrawBezier|GDIPlus_GraphicsDrawClosedCurve|GDIPlus_GraphicsDrawCurve|GDIPlus_GraphicsDrawEllipse|GDIPlus_GraphicsDrawImage|GDIPlus_GraphicsDrawImageRect|GDIPlus_GraphicsDrawImageRectRect|GDIPlus_GraphicsDrawLine|GDIPlus_GraphicsDrawPie|GDIPlus_GraphicsDrawPolygon|GDIPlus_GraphicsDrawRect|GDIPlus_GraphicsDrawString|GDIPlus_GraphicsDrawStringEx|GDIPlus_GraphicsFillClosedCurve|GDIPlus_GraphicsFillEllipse|GDIPlus_GraphicsFillPie|GDIPlus_GraphicsFillRect|GDIPlus_GraphicsGetDC|GDIPlus_GraphicsGetSmoothingMode|GDIPlus_GraphicsMeasureString|GDIPlus_GraphicsReleaseDC|GDIPlus_GraphicsSetSmoothingMode|GDIPlus_GraphicsSetTransform|GDIPlus_ImageDispose|GDIPlus_ImageGetGraphicsContext|GDIPlus_ImageGetHeight|GDIPlus_ImageGetWidth|GDIPlus_ImageLoadFromFile|GDIPlus_ImageSaveToFile|GDIPlus_ImageSaveToFileEx|GDIPlus_MatrixCreate|GDIPlus_MatrixDispose|GDIPlus_MatrixRotate|GDIPlus_ParamAdd|GDIPlus_ParamInit|GDIPlus_PenCreate|GDIPlus_PenDispose|GDIPlus_PenGetAlignment|GDIPlus_PenGetColor|GDIPlus_PenGetCustomEndCap|GDIPlus_PenGetDashCap|GDIPlus_PenGetDashStyle|GDIPlus_PenGetEndCap|GDIPlus_PenGetWidth|GDIPlus_PenSetAlignment|GDIPlus_PenSetColor|GDIPlus_PenSetCustomEndCap|GDIPlus_PenSetDashCap|GDIPlus_PenSetDashStyle|GDIPlus_PenSetEndCap|GDIPlus_PenSetWidth|GDIPlus_RectFCreate|GDIPlus_Shutdown|GDIPlus_Startup|GDIPlus_StringFormatCreate|GDIPlus_StringFormatDispose|GetIP|GUICtrlAVI_Close|GUICtrlAVI_Create|GUICtrlAVI_Destroy|GUICtrlAVI_Open|GUICtrlAVI_OpenEx|GUICtrlAVI_Play|GUICtrlAVI_Seek|GUICtrlAVI_Show|GUICtrlAVI_Stop|GUICtrlButton_Click|GUICtrlButton_Create|GUICtrlButton_Destroy|GUICtrlButton_Enable|GUICtrlButton_GetCheck|GUICtrlButton_GetFocus|GUICtrlButton_GetIdealSize|GUICtrlButton_GetImage|GUICtrlButton_GetImageList|GUICtrlButton_GetState|GUICtrlButton_GetText|GUICtrlButton_GetTextMargin|GUICtrlButton_SetCheck|GUICtrlButton_SetFocus|GUICtrlButton_SetImage|GUICtrlButton_SetImageList|GUICtrlButton_SetSize|GUICtrlButton_SetState|GUICtrlButton_SetStyle|GUICtrlButton_SetText|GUICtrlButton_SetTextMargin|GUICtrlButton_Show|GUICtrlComboBox_AddDir|GUICtrlComboBox_AddString|GUICtrlComboBox_AutoComplete|GUICtrlComboBox_BeginUpdate|GUICtrlComboBox_Create|GUICtrlComboBox_DeleteString|GUICtrlComboBox_Destroy|GUICtrlComboBox_EndUpdate|GUICtrlComboBox_FindString|GUICtrlComboBox_FindStringExact|GUICtrlComboBox_GetComboBoxInfo|GUICtrlComboBox_GetCount|GUICtrlComboBox_GetCurSel|GUICtrlComboBox_GetDroppedControlRect|GUICtrlComboBox_GetDroppedControlRectEx|GUICtrlComboBox_GetDroppedState|GUICtrlComboBox_GetDroppedWidth|GUICtrlComboBox_GetEditSel|GUICtrlComboBox_GetEditText|GUICtrlComboBox_GetExtendedUI|GUICtrlComboBox_GetHorizontalExtent|GUICtrlComboBox_GetItemHeight|GUICtrlComboBox_GetLBText|GUICtrlComboBox_GetLBTextLen|GUICtrlComboBox_GetList|GUICtrlComboBox_GetListArray|GUICtrlComboBox_GetLocale|GUICtrlComboBox_GetLocaleCountry|GUICtrlComboBox_GetLocaleLang|GUICtrlComboBox_GetLocalePrimLang|GUICtrlComboBox_GetLocaleSubLang|GUICtrlComboBox_GetMinVisible|GUICtrlComboBox_GetTopIndex|GUICtrlComboBox_InitStorage|GUICtrlComboBox_InsertString|GUICtrlComboBox_LimitText|GUICtrlComboBox_ReplaceEditSel|GUICtrlComboBox_ResetContent|GUICtrlComboBox_SelectString|GUICtrlComboBox_SetCurSel|GUICtrlComboBox_SetDroppedWidth|GUICtrlComboBox_SetEditSel|GUICtrlComboBox_SetEditText|GUICtrlComboBox_SetExtendedUI|GUICtrlComboBox_SetHorizontalExtent|GUICtrlComboBox_SetItemHeight|GUICtrlComboBox_SetMinVisible|GUICtrlComboBox_SetTopIndex|GUICtrlComboBox_ShowDropDown|GUICtrlComboBoxEx_AddDir|GUICtrlComboBoxEx_AddString|GUICtrlComboBoxEx_BeginUpdate|GUICtrlComboBoxEx_Create|GUICtrlComboBoxEx_CreateSolidBitMap|GUICtrlComboBoxEx_DeleteString|GUICtrlComboBoxEx_Destroy|GUICtrlComboBoxEx_EndUpdate|GUICtrlComboBoxEx_FindStringExact|GUICtrlComboBoxEx_GetComboBoxInfo|GUICtrlComboBoxEx_GetComboControl|GUICtrlComboBoxEx_GetCount|GUICtrlComboBoxEx_GetCurSel|GUICtrlComboBoxEx_GetDroppedControlRect|GUICtrlComboBoxEx_GetDroppedControlRectEx|GUICtrlComboBoxEx_GetDroppedState|GUICtrlComboBoxEx_GetDroppedWidth|GUICtrlComboBoxEx_GetEditControl|GUICtrlComboBoxEx_GetEditSel|GUICtrlComboBoxEx_GetEditText|GUICtrlComboBoxEx_GetExtendedStyle|GUICtrlComboBoxEx_GetExtendedUI|GUICtrlComboBoxEx_GetImageList|GUICtrlComboBoxEx_GetItem|GUICtrlComboBoxEx_GetItemEx|GUICtrlComboBoxEx_GetItemHeight|GUICtrlComboBoxEx_GetItemImage|GUICtrlComboBoxEx_GetItemIndent|GUICtrlComboBoxEx_GetItemOverlayImage|GUICtrlComboBoxEx_GetItemParam|GUICtrlComboBoxEx_GetItemSelectedImage|GUICtrlComboBoxEx_GetItemText|GUICtrlComboBoxEx_GetItemTextLen|GUICtrlComboBoxEx_GetList|GUICtrlComboBoxEx_GetListArray|GUICtrlComboBoxEx_GetLocale|GUICtrlComboBoxEx_GetLocaleCountry|GUICtrlComboBoxEx_GetLocaleLang|GUICtrlComboBoxEx_GetLocalePrimLang|GUICtrlComboBoxEx_GetLocaleSubLang|GUICtrlComboBoxEx_GetMinVisible|GUICtrlComboBoxEx_GetTopIndex|GUICtrlComboBoxEx_InitStorage|GUICtrlComboBoxEx_InsertString|GUICtrlComboBoxEx_LimitText|GUICtrlComboBoxEx_ReplaceEditSel|GUICtrlComboBoxEx_ResetContent|GUICtrlComboBoxEx_SetCurSel|GUICtrlComboBoxEx_SetDroppedWidth|GUICtrlComboBoxEx_SetEditSel|GUICtrlComboBoxEx_SetEditText|GUICtrlComboBoxEx_SetExtendedStyle|GUICtrlComboBoxEx_SetExtendedUI|GUICtrlComboBoxEx_SetImageList|GUICtrlComboBoxEx_SetItem|GUICtrlComboBoxEx_SetItemEx|GUICtrlComboBoxEx_SetItemHeight|GUICtrlComboBoxEx_SetItemImage|GUICtrlComboBoxEx_SetItemIndent|GUICtrlComboBoxEx_SetItemOverlayImage|GUICtrlComboBoxEx_SetItemParam|GUICtrlComboBoxEx_SetItemSelectedImage|GUICtrlComboBoxEx_SetMinVisible|GUICtrlComboBoxEx_SetTopIndex|GUICtrlComboBoxEx_ShowDropDown|GUICtrlDTP_Create|GUICtrlDTP_Destroy|GUICtrlDTP_GetMCColor|GUICtrlDTP_GetMCFont|GUICtrlDTP_GetMonthCal|GUICtrlDTP_GetRange|GUICtrlDTP_GetRangeEx|GUICtrlDTP_GetSystemTime|GUICtrlDTP_GetSystemTimeEx|GUICtrlDTP_SetFormat|GUICtrlDTP_SetMCColor|GUICtrlDTP_SetMCFont|GUICtrlDTP_SetRange|GUICtrlDTP_SetRangeEx|GUICtrlDTP_SetSystemTime|GUICtrlDTP_SetSystemTimeEx|GUICtrlEdit_AppendText|GUICtrlEdit_BeginUpdate|GUICtrlEdit_CanUndo|GUICtrlEdit_CharFromPos|GUICtrlEdit_Create|GUICtrlEdit_Destroy|GUICtrlEdit_EmptyUndoBuffer|GUICtrlEdit_EndUpdate|GUICtrlEdit_Find|GUICtrlEdit_FmtLines|GUICtrlEdit_GetFirstVisibleLine|GUICtrlEdit_GetLimitText|GUICtrlEdit_GetLine|GUICtrlEdit_GetLineCount|GUICtrlEdit_GetMargins|GUICtrlEdit_GetModify|GUICtrlEdit_GetPasswordChar|GUICtrlEdit_GetRECT|GUICtrlEdit_GetRECTEx|GUICtrlEdit_GetSel|GUICtrlEdit_GetText|GUICtrlEdit_GetTextLen|GUICtrlEdit_HideBalloonTip|GUICtrlEdit_InsertText|GUICtrlEdit_LineFromChar|GUICtrlEdit_LineIndex|GUICtrlEdit_LineLength|GUICtrlEdit_LineScroll|GUICtrlEdit_PosFromChar|GUICtrlEdit_ReplaceSel|GUICtrlEdit_Scroll|GUICtrlEdit_SetLimitText|GUICtrlEdit_SetMargins|GUICtrlEdit_SetModify|GUICtrlEdit_SetPasswordChar|GUICtrlEdit_SetReadOnly|GUICtrlEdit_SetRECT|GUICtrlEdit_SetRECTEx|GUICtrlEdit_SetRECTNP|GUICtrlEdit_SetRectNPEx|GUICtrlEdit_SetSel|GUICtrlEdit_SetTabStops|GUICtrlEdit_SetText|GUICtrlEdit_ShowBalloonTip|GUICtrlEdit_Undo|GUICtrlHeader_AddItem|GUICtrlHeader_ClearFilter|GUICtrlHeader_ClearFilterAll|GUICtrlHeader_Create|GUICtrlHeader_CreateDragImage|GUICtrlHeader_DeleteItem|GUICtrlHeader_Destroy|GUICtrlHeader_EditFilter|GUICtrlHeader_GetBitmapMargin|GUICtrlHeader_GetImageList|GUICtrlHeader_GetItem|GUICtrlHeader_GetItemAlign|GUICtrlHeader_GetItemBitmap|GUICtrlHeader_GetItemCount|GUICtrlHeader_GetItemDisplay|GUICtrlHeader_GetItemFlags|GUICtrlHeader_GetItemFormat|GUICtrlHeader_GetItemImage|GUICtrlHeader_GetItemOrder|GUICtrlHeader_GetItemParam|GUICtrlHeader_GetItemRect|GUICtrlHeader_GetItemRectEx|GUICtrlHeader_GetItemText|GUICtrlHeader_GetItemWidth|GUICtrlHeader_GetOrderArray|GUICtrlHeader_GetUnicodeFormat|GUICtrlHeader_HitTest|GUICtrlHeader_InsertItem|GUICtrlHeader_Layout|GUICtrlHeader_OrderToIndex|GUICtrlHeader_SetBitmapMargin|GUICtrlHeader_SetFilterChangeTimeout|GUICtrlHeader_SetHotDivider|GUICtrlHeader_SetImageList|GUICtrlHeader_SetItem|GUICtrlHeader_SetItemAlign|GUICtrlHeader_SetItemBitmap|GUICtrlHeader_SetItemDisplay|GUICtrlHeader_SetItemFlags|GUICtrlHeader_SetItemFormat|GUICtrlHeader_SetItemImage|GUICtrlHeader_SetItemOrder|GUICtrlHeader_SetItemParam|GUICtrlHeader_SetItemText|GUICtrlHeader_SetItemWidth|GUICtrlHeader_SetOrderArray|GUICtrlHeader_SetUnicodeFormat|GUICtrlIpAddress_ClearAddress|GUICtrlIpAddress_Create|GUICtrlIpAddress_Destroy|GUICtrlIpAddress_Get|GUICtrlIpAddress_GetArray|GUICtrlIpAddress_GetEx|GUICtrlIpAddress_IsBlank|GUICtrlIpAddress_Set|GUICtrlIpAddress_SetArray|GUICtrlIpAddress_SetEx|GUICtrlIpAddress_SetFocus|GUICtrlIpAddress_SetFont|GUICtrlIpAddress_SetRange|GUICtrlIpAddress_ShowHide|GUICtrlListBox_AddFile|GUICtrlListBox_AddString|GUICtrlListBox_BeginUpdate|GUICtrlListBox_Create|GUICtrlListBox_DeleteString|GUICtrlListBox_Destroy|GUICtrlListBox_Dir|GUICtrlListBox_EndUpdate|GUICtrlListBox_FindInText|GUICtrlListBox_FindString|GUICtrlListBox_GetAnchorIndex|GUICtrlListBox_GetCaretIndex|GUICtrlListBox_GetCount|GUICtrlListBox_GetCurSel|GUICtrlListBox_GetHorizontalExtent|GUICtrlListBox_GetItemData|GUICtrlListBox_GetItemHeight|GUICtrlListBox_GetItemRect|GUICtrlListBox_GetItemRectEx|GUICtrlListBox_GetListBoxInfo|GUICtrlListBox_GetLocale|GUICtrlListBox_GetLocaleCountry|GUICtrlListBox_GetLocaleLang|GUICtrlListBox_GetLocalePrimLang|GUICtrlListBox_GetLocaleSubLang|GUICtrlListBox_GetSel|GUICtrlListBox_GetSelCount|GUICtrlListBox_GetSelItems|GUICtrlListBox_GetSelItemsText|GUICtrlListBox_GetText|GUICtrlListBox_GetTextLen|GUICtrlListBox_GetTopIndex|GUICtrlListBox_InitStorage|GUICtrlListBox_InsertString|GUICtrlListBox_ItemFromPoint|GUICtrlListBox_ReplaceString|GUICtrlListBox_ResetContent|GUICtrlListBox_SelectString|GUICtrlListBox_SelItemRange|GUICtrlListBox_SelItemRangeEx|GUICtrlListBox_SetAnchorIndex|GUICtrlListBox_SetCaretIndex|GUICtrlListBox_SetColumnWidth|GUICtrlListBox_SetCurSel|GUICtrlListBox_SetHorizontalExtent|GUICtrlListBox_SetItemData|GUICtrlListBox_SetItemHeight|GUICtrlListBox_SetLocale|GUICtrlListBox_SetSel|GUICtrlListBox_SetTabStops|GUICtrlListBox_SetTopIndex|GUICtrlListBox_Sort|GUICtrlListBox_SwapString|GUICtrlListBox_UpdateHScroll|GUICtrlListView_AddArray|GUICtrlListView_AddColumn|GUICtrlListView_AddItem|GUICtrlListView_AddSubItem|GUICtrlListView_ApproximateViewHeight|GUICtrlListView_ApproximateViewRect|GUICtrlListView_ApproximateViewWidth|GUICtrlListView_Arrange|GUICtrlListView_BeginUpdate|GUICtrlListView_CancelEditLabel|GUICtrlListView_ClickItem|GUICtrlListView_CopyItems|GUICtrlListView_Create|GUICtrlListView_CreateDragImage|GUICtrlListView_CreateSolidBitMap|GUICtrlListView_DeleteAllItems|GUICtrlListView_DeleteColumn|GUICtrlListView_DeleteItem|GUICtrlListView_DeleteItemsSelected|GUICtrlListView_Destroy|GUICtrlListView_DrawDragImage|GUICtrlListView_EditLabel|GUICtrlListView_EnableGroupView|GUICtrlListView_EndUpdate|GUICtrlListView_EnsureVisible|GUICtrlListView_FindInText|GUICtrlListView_FindItem|GUICtrlListView_FindNearest|GUICtrlListView_FindParam|GUICtrlListView_FindText|GUICtrlListView_GetBkColor|GUICtrlListView_GetBkImage|GUICtrlListView_GetCallbackMask|GUICtrlListView_GetColumn|GUICtrlListView_GetColumnCount|GUICtrlListView_GetColumnOrder|GUICtrlListView_GetColumnOrderArray|GUICtrlListView_GetColumnWidth|GUICtrlListView_GetCounterPage|GUICtrlListView_GetEditControl|GUICtrlListView_GetExtendedListViewStyle|GUICtrlListView_GetGroupInfo|GUICtrlListView_GetGroupViewEnabled|GUICtrlListView_GetHeader|GUICtrlListView_GetHotCursor|GUICtrlListView_GetHotItem|GUICtrlListView_GetHoverTime|GUICtrlListView_GetImageList|GUICtrlListView_GetISearchString|GUICtrlListView_GetItem|GUICtrlListView_GetItemChecked|GUICtrlListView_GetItemCount|GUICtrlListView_GetItemCut|GUICtrlListView_GetItemDropHilited|GUICtrlListView_GetItemEx|GUICtrlListView_GetItemFocused|GUICtrlListView_GetItemGroupID|GUICtrlListView_GetItemImage|GUICtrlListView_GetItemIndent|GUICtrlListView_GetItemParam|GUICtrlListView_GetItemPosition|GUICtrlListView_GetItemPositionX|GUICtrlListView_GetItemPositionY|GUICtrlListView_GetItemRect|GUICtrlListView_GetItemRectEx|GUICtrlListView_GetItemSelected|GUICtrlListView_GetItemSpacing|GUICtrlListView_GetItemSpacingX|GUICtrlListView_GetItemSpacingY|GUICtrlListView_GetItemState|GUICtrlListView_GetItemStateImage|GUICtrlListView_GetItemText|GUICtrlListView_GetItemTextArray|GUICtrlListView_GetItemTextString|GUICtrlListView_GetNextItem|GUICtrlListView_GetNumberOfWorkAreas|GUICtrlListView_GetOrigin|GUICtrlListView_GetOriginX|GUICtrlListView_GetOriginY|GUICtrlListView_GetOutlineColor|GUICtrlListView_GetSelectedColumn|GUICtrlListView_GetSelectedCount|GUICtrlListView_GetSelectedIndices|GUICtrlListView_GetSelectionMark|GUICtrlListView_GetStringWidth|GUICtrlListView_GetSubItemRect|GUICtrlListView_GetTextBkColor|GUICtrlListView_GetTextColor|GUICtrlListView_GetToolTips|GUICtrlListView_GetTopIndex|GUICtrlListView_GetUnicodeFormat|GUICtrlListView_GetView|GUICtrlListView_GetViewDetails|GUICtrlListView_GetViewLarge|GUICtrlListView_GetViewList|GUICtrlListView_GetViewRect|GUICtrlListView_GetViewSmall|GUICtrlListView_GetViewTile|GUICtrlListView_HideColumn|GUICtrlListView_HitTest|GUICtrlListView_InsertColumn|GUICtrlListView_InsertGroup|GUICtrlListView_InsertItem|GUICtrlListView_JustifyColumn|GUICtrlListView_MapIDToIndex|GUICtrlListView_MapIndexToID|GUICtrlListView_RedrawItems|GUICtrlListView_RegisterSortCallBack|GUICtrlListView_RemoveAllGroups|GUICtrlListView_RemoveGroup|GUICtrlListView_Scroll|GUICtrlListView_SetBkColor|GUICtrlListView_SetBkImage|GUICtrlListView_SetCallBackMask|GUICtrlListView_SetColumn|GUICtrlListView_SetColumnOrder|GUICtrlListView_SetColumnOrderArray|GUICtrlListView_SetColumnWidth|GUICtrlListView_SetExtendedListViewStyle|GUICtrlListView_SetGroupInfo|GUICtrlListView_SetHotItem|GUICtrlListView_SetHoverTime|GUICtrlListView_SetIconSpacing|GUICtrlListView_SetImageList|GUICtrlListView_SetItem|GUICtrlListView_SetItemChecked|GUICtrlListView_SetItemCount|GUICtrlListView_SetItemCut|GUICtrlListView_SetItemDropHilited|GUICtrlListView_SetItemEx|GUICtrlListView_SetItemFocused|GUICtrlListView_SetItemGroupID|GUICtrlListView_SetItemImage|GUICtrlListView_SetItemIndent|GUICtrlListView_SetItemParam|GUICtrlListView_SetItemPosition|GUICtrlListView_SetItemPosition32|GUICtrlListView_SetItemSelected|GUICtrlListView_SetItemState|GUICtrlListView_SetItemStateImage|GUICtrlListView_SetItemText|GUICtrlListView_SetOutlineColor|GUICtrlListView_SetSelectedColumn|GUICtrlListView_SetSelectionMark|GUICtrlListView_SetTextBkColor|GUICtrlListView_SetTextColor|GUICtrlListView_SetToolTips|GUICtrlListView_SetUnicodeFormat|GUICtrlListView_SetView|GUICtrlListView_SetWorkAreas|GUICtrlListView_SimpleSort|GUICtrlListView_SortItems|GUICtrlListView_SubItemHitTest|GUICtrlListView_UnRegisterSortCallBack|GUICtrlMenu_AddMenuItem|GUICtrlMenu_AppendMenu|GUICtrlMenu_CheckMenuItem|GUICtrlMenu_CheckRadioItem|GUICtrlMenu_CreateMenu|GUICtrlMenu_CreatePopup|GUICtrlMenu_DeleteMenu|GUICtrlMenu_DestroyMenu|GUICtrlMenu_DrawMenuBar|GUICtrlMenu_EnableMenuItem|GUICtrlMenu_FindItem|GUICtrlMenu_FindParent|GUICtrlMenu_GetItemBmp|GUICtrlMenu_GetItemBmpChecked|GUICtrlMenu_GetItemBmpUnchecked|GUICtrlMenu_GetItemChecked|GUICtrlMenu_GetItemCount|GUICtrlMenu_GetItemData|GUICtrlMenu_GetItemDefault|GUICtrlMenu_GetItemDisabled|GUICtrlMenu_GetItemEnabled|GUICtrlMenu_GetItemGrayed|GUICtrlMenu_GetItemHighlighted|GUICtrlMenu_GetItemID|GUICtrlMenu_GetItemInfo|GUICtrlMenu_GetItemRect|GUICtrlMenu_GetItemRectEx|GUICtrlMenu_GetItemState|GUICtrlMenu_GetItemStateEx|GUICtrlMenu_GetItemSubMenu|GUICtrlMenu_GetItemText|GUICtrlMenu_GetItemType|GUICtrlMenu_GetMenu|GUICtrlMenu_GetMenuBackground|GUICtrlMenu_GetMenuBarInfo|GUICtrlMenu_GetMenuContextHelpID|GUICtrlMenu_GetMenuData|GUICtrlMenu_GetMenuDefaultItem|GUICtrlMenu_GetMenuHeight|GUICtrlMenu_GetMenuInfo|GUICtrlMenu_GetMenuStyle|GUICtrlMenu_GetSystemMenu|GUICtrlMenu_InsertMenuItem|GUICtrlMenu_InsertMenuItemEx|GUICtrlMenu_IsMenu|GUICtrlMenu_LoadMenu|GUICtrlMenu_MapAccelerator|GUICtrlMenu_MenuItemFromPoint|GUICtrlMenu_RemoveMenu|GUICtrlMenu_SetItemBitmaps|GUICtrlMenu_SetItemBmp|GUICtrlMenu_SetItemBmpChecked|GUICtrlMenu_SetItemBmpUnchecked|GUICtrlMenu_SetItemChecked|GUICtrlMenu_SetItemData|GUICtrlMenu_SetItemDefault|GUICtrlMenu_SetItemDisabled|GUICtrlMenu_SetItemEnabled|GUICtrlMenu_SetItemGrayed|GUICtrlMenu_SetItemHighlighted|GUICtrlMenu_SetItemID|GUICtrlMenu_SetItemInfo|GUICtrlMenu_SetItemState|GUICtrlMenu_SetItemSubMenu|GUICtrlMenu_SetItemText|GUICtrlMenu_SetItemType|GUICtrlMenu_SetMenu|GUICtrlMenu_SetMenuBackground|GUICtrlMenu_SetMenuContextHelpID|GUICtrlMenu_SetMenuData|GUICtrlMenu_SetMenuDefaultItem|GUICtrlMenu_SetMenuHeight|GUICtrlMenu_SetMenuInfo|GUICtrlMenu_SetMenuStyle|GUICtrlMenu_TrackPopupMenu|GUICtrlMonthCal_Create|GUICtrlMonthCal_Destroy|GUICtrlMonthCal_GetColor|GUICtrlMonthCal_GetColorArray|GUICtrlMonthCal_GetCurSel|GUICtrlMonthCal_GetCurSelStr|GUICtrlMonthCal_GetFirstDOW|GUICtrlMonthCal_GetFirstDOWStr|GUICtrlMonthCal_GetMaxSelCount|GUICtrlMonthCal_GetMaxTodayWidth|GUICtrlMonthCal_GetMinReqHeight|GUICtrlMonthCal_GetMinReqRect|GUICtrlMonthCal_GetMinReqRectArray|GUICtrlMonthCal_GetMinReqWidth|GUICtrlMonthCal_GetMonthDelta|GUICtrlMonthCal_GetMonthRange|GUICtrlMonthCal_GetMonthRangeMax|GUICtrlMonthCal_GetMonthRangeMaxStr|GUICtrlMonthCal_GetMonthRangeMin|GUICtrlMonthCal_GetMonthRangeMinStr|GUICtrlMonthCal_GetMonthRangeSpan|GUICtrlMonthCal_GetRange|GUICtrlMonthCal_GetRangeMax|GUICtrlMonthCal_GetRangeMaxStr|GUICtrlMonthCal_GetRangeMin|GUICtrlMonthCal_GetRangeMinStr|GUICtrlMonthCal_GetSelRange|GUICtrlMonthCal_GetSelRangeMax|GUICtrlMonthCal_GetSelRangeMaxStr|GUICtrlMonthCal_GetSelRangeMin|GUICtrlMonthCal_GetSelRangeMinStr|GUICtrlMonthCal_GetToday|GUICtrlMonthCal_GetTodayStr|GUICtrlMonthCal_GetUnicodeFormat|GUICtrlMonthCal_HitTest|GUICtrlMonthCal_SetColor|GUICtrlMonthCal_SetCurSel|GUICtrlMonthCal_SetDayState|GUICtrlMonthCal_SetFirstDOW|GUICtrlMonthCal_SetMaxSelCount|GUICtrlMonthCal_SetMonthDelta|GUICtrlMonthCal_SetRange|GUICtrlMonthCal_SetSelRange|GUICtrlMonthCal_SetToday|GUICtrlMonthCal_SetUnicodeFormat|GUICtrlRebar_AddBand|GUICtrlRebar_AddToolBarBand|GUICtrlRebar_BeginDrag|GUICtrlRebar_Create|GUICtrlRebar_DeleteBand|GUICtrlRebar_Destroy|GUICtrlRebar_DragMove|GUICtrlRebar_EndDrag|GUICtrlRebar_GetBandBackColor|GUICtrlRebar_GetBandBorders|GUICtrlRebar_GetBandBordersEx|GUICtrlRebar_GetBandChildHandle|GUICtrlRebar_GetBandChildSize|GUICtrlRebar_GetBandCount|GUICtrlRebar_GetBandForeColor|GUICtrlRebar_GetBandHeaderSize|GUICtrlRebar_GetBandID|GUICtrlRebar_GetBandIdealSize|GUICtrlRebar_GetBandLength|GUICtrlRebar_GetBandLParam|GUICtrlRebar_GetBandMargins|GUICtrlRebar_GetBandMarginsEx|GUICtrlRebar_GetBandRect|GUICtrlRebar_GetBandRectEx|GUICtrlRebar_GetBandStyle|GUICtrlRebar_GetBandStyleBreak|GUICtrlRebar_GetBandStyleChildEdge|GUICtrlRebar_GetBandStyleFixedBMP|GUICtrlRebar_GetBandStyleFixedSize|GUICtrlRebar_GetBandStyleGripperAlways|GUICtrlRebar_GetBandStyleHidden|GUICtrlRebar_GetBandStyleHideTitle|GUICtrlRebar_GetBandStyleNoGripper|GUICtrlRebar_GetBandStyleTopAlign|GUICtrlRebar_GetBandStyleUseChevron|GUICtrlRebar_GetBandStyleVariableHeight|GUICtrlRebar_GetBandText|GUICtrlRebar_GetBarHeight|GUICtrlRebar_GetBKColor|GUICtrlRebar_GetColorScheme|GUICtrlRebar_GetRowCount|GUICtrlRebar_GetRowHeight|GUICtrlRebar_GetTextColor|GUICtrlRebar_GetToolTips|GUICtrlRebar_GetUnicodeFormat|GUICtrlRebar_HitTest|GUICtrlRebar_IDToIndex|GUICtrlRebar_MaximizeBand|GUICtrlRebar_MinimizeBand|GUICtrlRebar_MoveBand|GUICtrlRebar_SetBandBackColor|GUICtrlRebar_SetBandForeColor|GUICtrlRebar_SetBandHeaderSize|GUICtrlRebar_SetBandID|GUICtrlRebar_SetBandIdealSize|GUICtrlRebar_SetBandLength|GUICtrlRebar_SetBandLParam|GUICtrlRebar_SetBandStyle|GUICtrlRebar_SetBandStyleBreak|GUICtrlRebar_SetBandStyleChildEdge|GUICtrlRebar_SetBandStyleFixedBMP|GUICtrlRebar_SetBandStyleFixedSize|GUICtrlRebar_SetBandStyleGripperAlways|GUICtrlRebar_SetBandStyleHidden|GUICtrlRebar_SetBandStyleHideTitle|GUICtrlRebar_SetBandStyleNoGripper|GUICtrlRebar_SetBandStyleTopAlign|GUICtrlRebar_SetBandStyleUseChevron|GUICtrlRebar_SetBandStyleVariableHeight|GUICtrlRebar_SetBandText|GUICtrlRebar_SetBKColor|GUICtrlRebar_SetColorScheme|GUICtrlRebar_SetTextColor|GUICtrlRebar_SetToolTips|GUICtrlRebar_SetUnicodeFormat|GUICtrlRebar_ShowBand|GUICtrlSlider_ClearSel|GUICtrlSlider_ClearTics|GUICtrlSlider_Create|GUICtrlSlider_Destroy|GUICtrlSlider_GetBuddy|GUICtrlSlider_GetChannelRect|GUICtrlSlider_GetLineSize|GUICtrlSlider_GetNumTics|GUICtrlSlider_GetPageSize|GUICtrlSlider_GetPos|GUICtrlSlider_GetPTics|GUICtrlSlider_GetRange|GUICtrlSlider_GetRangeMax|GUICtrlSlider_GetRangeMin|GUICtrlSlider_GetSel|GUICtrlSlider_GetSelEnd|GUICtrlSlider_GetSelStart|GUICtrlSlider_GetThumbLength|GUICtrlSlider_GetThumbRect|GUICtrlSlider_GetThumbRectEx|GUICtrlSlider_GetTic|GUICtrlSlider_GetTicPos|GUICtrlSlider_GetToolTips|GUICtrlSlider_GetUnicodeFormat|GUICtrlSlider_SetBuddy|GUICtrlSlider_SetLineSize|GUICtrlSlider_SetPageSize|GUICtrlSlider_SetPos|GUICtrlSlider_SetRange|GUICtrlSlider_SetRangeMax|GUICtrlSlider_SetRangeMin|GUICtrlSlider_SetSel|GUICtrlSlider_SetSelEnd|GUICtrlSlider_SetSelStart|GUICtrlSlider_SetThumbLength|GUICtrlSlider_SetTic|GUICtrlSlider_SetTicFreq|GUICtrlSlider_SetTipSide|GUICtrlSlider_SetToolTips|GUICtrlSlider_SetUnicodeFormat|GUICtrlStatusBar_Create|GUICtrlStatusBar_Destroy|GUICtrlStatusBar_EmbedControl|GUICtrlStatusBar_GetBorders|GUICtrlStatusBar_GetBordersHorz|GUICtrlStatusBar_GetBordersRect|GUICtrlStatusBar_GetBordersVert|GUICtrlStatusBar_GetCount|GUICtrlStatusBar_GetHeight|GUICtrlStatusBar_GetIcon|GUICtrlStatusBar_GetParts|GUICtrlStatusBar_GetRect|GUICtrlStatusBar_GetRectEx|GUICtrlStatusBar_GetText|GUICtrlStatusBar_GetTextFlags|GUICtrlStatusBar_GetTextLength|GUICtrlStatusBar_GetTextLengthEx|GUICtrlStatusBar_GetTipText|GUICtrlStatusBar_GetUnicodeFormat|GUICtrlStatusBar_GetWidth|GUICtrlStatusBar_IsSimple|GUICtrlStatusBar_Resize|GUICtrlStatusBar_SetBkColor|GUICtrlStatusBar_SetIcon|GUICtrlStatusBar_SetMinHeight|GUICtrlStatusBar_SetParts|GUICtrlStatusBar_SetSimple|GUICtrlStatusBar_SetText|GUICtrlStatusBar_SetTipText|GUICtrlStatusBar_SetUnicodeFormat|GUICtrlStatusBar_ShowHide|GUICtrlTab_Create|GUICtrlTab_DeleteAllItems|GUICtrlTab_DeleteItem|GUICtrlTab_DeselectAll|GUICtrlTab_Destroy|GUICtrlTab_FindTab|GUICtrlTab_GetCurFocus|GUICtrlTab_GetCurSel|GUICtrlTab_GetDisplayRect|GUICtrlTab_GetDisplayRectEx|GUICtrlTab_GetExtendedStyle|GUICtrlTab_GetImageList|GUICtrlTab_GetItem|GUICtrlTab_GetItemCount|GUICtrlTab_GetItemImage|GUICtrlTab_GetItemParam|GUICtrlTab_GetItemRect|GUICtrlTab_GetItemRectEx|GUICtrlTab_GetItemState|GUICtrlTab_GetItemText|GUICtrlTab_GetRowCount|GUICtrlTab_GetToolTips|GUICtrlTab_GetUnicodeFormat|GUICtrlTab_HighlightItem|GUICtrlTab_HitTest|GUICtrlTab_InsertItem|GUICtrlTab_RemoveImage|GUICtrlTab_SetCurFocus|GUICtrlTab_SetCurSel|GUICtrlTab_SetExtendedStyle|GUICtrlTab_SetImageList|GUICtrlTab_SetItem|GUICtrlTab_SetItemImage|GUICtrlTab_SetItemParam|GUICtrlTab_SetItemSize|GUICtrlTab_SetItemState|GUICtrlTab_SetItemText|GUICtrlTab_SetMinTabWidth|GUICtrlTab_SetPadding|GUICtrlTab_SetToolTips|GUICtrlTab_SetUnicodeFormat|GUICtrlToolbar_AddBitmap|GUICtrlToolbar_AddButton|GUICtrlToolbar_AddButtonSep|GUICtrlToolbar_AddString|GUICtrlToolbar_ButtonCount|GUICtrlToolbar_CheckButton|GUICtrlToolbar_ClickAccel|GUICtrlToolbar_ClickButton|GUICtrlToolbar_ClickIndex|GUICtrlToolbar_CommandToIndex|GUICtrlToolbar_Create|GUICtrlToolbar_Customize|GUICtrlToolbar_DeleteButton|GUICtrlToolbar_Destroy|GUICtrlToolbar_EnableButton|GUICtrlToolbar_FindToolbar|GUICtrlToolbar_GetAnchorHighlight|GUICtrlToolbar_GetBitmapFlags|GUICtrlToolbar_GetButtonBitmap|GUICtrlToolbar_GetButtonInfo|GUICtrlToolbar_GetButtonInfoEx|GUICtrlToolbar_GetButtonParam|GUICtrlToolbar_GetButtonRect|GUICtrlToolbar_GetButtonRectEx|GUICtrlToolbar_GetButtonSize|GUICtrlToolbar_GetButtonState|GUICtrlToolbar_GetButtonStyle|GUICtrlToolbar_GetButtonText|GUICtrlToolbar_GetColorScheme|GUICtrlToolbar_GetDisabledImageList|GUICtrlToolbar_GetExtendedStyle|GUICtrlToolbar_GetHotImageList|GUICtrlToolbar_GetHotItem|GUICtrlToolbar_GetImageList|GUICtrlToolbar_GetInsertMark|GUICtrlToolbar_GetInsertMarkColor|GUICtrlToolbar_GetMaxSize|GUICtrlToolbar_GetMetrics|GUICtrlToolbar_GetPadding|GUICtrlToolbar_GetRows|GUICtrlToolbar_GetString|GUICtrlToolbar_GetStyle|GUICtrlToolbar_GetStyleAltDrag|GUICtrlToolbar_GetStyleCustomErase|GUICtrlToolbar_GetStyleFlat|GUICtrlToolbar_GetStyleList|GUICtrlToolbar_GetStyleRegisterDrop|GUICtrlToolbar_GetStyleToolTips|GUICtrlToolbar_GetStyleTransparent|GUICtrlToolbar_GetStyleWrapable|GUICtrlToolbar_GetTextRows|GUICtrlToolbar_GetToolTips|GUICtrlToolbar_GetUnicodeFormat|GUICtrlToolbar_HideButton|GUICtrlToolbar_HighlightButton|GUICtrlToolbar_HitTest|GUICtrlToolbar_IndexToCommand|GUICtrlToolbar_InsertButton|GUICtrlToolbar_InsertMarkHitTest|GUICtrlToolbar_IsButtonChecked|GUICtrlToolbar_IsButtonEnabled|GUICtrlToolbar_IsButtonHidden|GUICtrlToolbar_IsButtonHighlighted|GUICtrlToolbar_IsButtonIndeterminate|GUICtrlToolbar_IsButtonPressed|GUICtrlToolbar_LoadBitmap|GUICtrlToolbar_LoadImages|GUICtrlToolbar_MapAccelerator|GUICtrlToolbar_MoveButton|GUICtrlToolbar_PressButton|GUICtrlToolbar_SetAnchorHighlight|GUICtrlToolbar_SetBitmapSize|GUICtrlToolbar_SetButtonBitMap|GUICtrlToolbar_SetButtonInfo|GUICtrlToolbar_SetButtonInfoEx|GUICtrlToolbar_SetButtonParam|GUICtrlToolbar_SetButtonSize|GUICtrlToolbar_SetButtonState|GUICtrlToolbar_SetButtonStyle|GUICtrlToolbar_SetButtonText|GUICtrlToolbar_SetButtonWidth|GUICtrlToolbar_SetCmdID|GUICtrlToolbar_SetColorScheme|GUICtrlToolbar_SetDisabledImageList|GUICtrlToolbar_SetDrawTextFlags|GUICtrlToolbar_SetExtendedStyle|GUICtrlToolbar_SetHotImageList|GUICtrlToolbar_SetHotItem|GUICtrlToolbar_SetImageList|GUICtrlToolbar_SetIndent|GUICtrlToolbar_SetIndeterminate|GUICtrlToolbar_SetInsertMark|GUICtrlToolbar_SetInsertMarkColor|GUICtrlToolbar_SetMaxTextRows|GUICtrlToolbar_SetMetrics|GUICtrlToolbar_SetPadding|GUICtrlToolbar_SetParent|GUICtrlToolbar_SetRows|GUICtrlToolbar_SetStyle|GUICtrlToolbar_SetStyleAltDrag|GUICtrlToolbar_SetStyleCustomErase|GUICtrlToolbar_SetStyleFlat|GUICtrlToolbar_SetStyleList|GUICtrlToolbar_SetStyleRegisterDrop|GUICtrlToolbar_SetStyleToolTips|GUICtrlToolbar_SetStyleTransparent|GUICtrlToolbar_SetStyleWrapable|GUICtrlToolbar_SetToolTips|GUICtrlToolbar_SetUnicodeFormat|GUICtrlToolbar_SetWindowTheme|GUICtrlTreeView_Add|GUICtrlTreeView_AddChild|GUICtrlTreeView_AddChildFirst|GUICtrlTreeView_AddFirst|GUICtrlTreeView_BeginUpdate|GUICtrlTreeView_ClickItem|GUICtrlTreeView_Create|GUICtrlTreeView_CreateDragImage|GUICtrlTreeView_CreateSolidBitMap|GUICtrlTreeView_Delete|GUICtrlTreeView_DeleteAll|GUICtrlTreeView_DeleteChildren|GUICtrlTreeView_Destroy|GUICtrlTreeView_DisplayRect|GUICtrlTreeView_DisplayRectEx|GUICtrlTreeView_EditText|GUICtrlTreeView_EndEdit|GUICtrlTreeView_EndUpdate|GUICtrlTreeView_EnsureVisible|GUICtrlTreeView_Expand|GUICtrlTreeView_ExpandedOnce|GUICtrlTreeView_FindItem|GUICtrlTreeView_FindItemEx|GUICtrlTreeView_GetBkColor|GUICtrlTreeView_GetBold|GUICtrlTreeView_GetChecked|GUICtrlTreeView_GetChildCount|GUICtrlTreeView_GetChildren|GUICtrlTreeView_GetCount|GUICtrlTreeView_GetCut|GUICtrlTreeView_GetDropTarget|GUICtrlTreeView_GetEditControl|GUICtrlTreeView_GetExpanded|GUICtrlTreeView_GetFirstChild|GUICtrlTreeView_GetFirstItem|GUICtrlTreeView_GetFirstVisible|GUICtrlTreeView_GetFocused|GUICtrlTreeView_GetHeight|GUICtrlTreeView_GetImageIndex|GUICtrlTreeView_GetImageListIconHandle|GUICtrlTreeView_GetIndent|GUICtrlTreeView_GetInsertMarkColor|GUICtrlTreeView_GetISearchString|GUICtrlTreeView_GetItemByIndex|GUICtrlTreeView_GetItemHandle|GUICtrlTreeView_GetItemParam|GUICtrlTreeView_GetLastChild|GUICtrlTreeView_GetLineColor|GUICtrlTreeView_GetNext|GUICtrlTreeView_GetNextChild|GUICtrlTreeView_GetNextSibling|GUICtrlTreeView_GetNextVisible|GUICtrlTreeView_GetNormalImageList|GUICtrlTreeView_GetParentHandle|GUICtrlTreeView_GetParentParam|GUICtrlTreeView_GetPrev|GUICtrlTreeView_GetPrevChild|GUICtrlTreeView_GetPrevSibling|GUICtrlTreeView_GetPrevVisible|GUICtrlTreeView_GetScrollTime|GUICtrlTreeView_GetSelected|GUICtrlTreeView_GetSelectedImageIndex|GUICtrlTreeView_GetSelection|GUICtrlTreeView_GetSiblingCount|GUICtrlTreeView_GetState|GUICtrlTreeView_GetStateImageIndex|GUICtrlTreeView_GetStateImageList|GUICtrlTreeView_GetText|GUICtrlTreeView_GetTextColor|GUICtrlTreeView_GetToolTips|GUICtrlTreeView_GetTree|GUICtrlTreeView_GetUnicodeFormat|GUICtrlTreeView_GetVisible|GUICtrlTreeView_GetVisibleCount|GUICtrlTreeView_HitTest|GUICtrlTreeView_HitTestEx|GUICtrlTreeView_HitTestItem|GUICtrlTreeView_Index|GUICtrlTreeView_InsertItem|GUICtrlTreeView_IsFirstItem|GUICtrlTreeView_IsParent|GUICtrlTreeView_Level|GUICtrlTreeView_SelectItem|GUICtrlTreeView_SelectItemByIndex|GUICtrlTreeView_SetBkColor|GUICtrlTreeView_SetBold|GUICtrlTreeView_SetChecked|GUICtrlTreeView_SetCheckedByIndex|GUICtrlTreeView_SetChildren|GUICtrlTreeView_SetCut|GUICtrlTreeView_SetDropTarget|GUICtrlTreeView_SetFocused|GUICtrlTreeView_SetHeight|GUICtrlTreeView_SetIcon|GUICtrlTreeView_SetImageIndex|GUICtrlTreeView_SetIndent|GUICtrlTreeView_SetInsertMark|GUICtrlTreeView_SetInsertMarkColor|GUICtrlTreeView_SetItemHeight|GUICtrlTreeView_SetItemParam|GUICtrlTreeView_SetLineColor|GUICtrlTreeView_SetNormalImageList|GUICtrlTreeView_SetScrollTime|GUICtrlTreeView_SetSelected|GUICtrlTreeView_SetSelectedImageIndex|GUICtrlTreeView_SetState|GUICtrlTreeView_SetStateImageIndex|GUICtrlTreeView_SetStateImageList|GUICtrlTreeView_SetText|GUICtrlTreeView_SetTextColor|GUICtrlTreeView_SetToolTips|GUICtrlTreeView_SetUnicodeFormat|GUICtrlTreeView_Sort|GUIImageList_Add|GUIImageList_AddBitmap|GUIImageList_AddIcon|GUIImageList_AddMasked|GUIImageList_BeginDrag|GUIImageList_Copy|GUIImageList_Create|GUIImageList_Destroy|GUIImageList_DestroyIcon|GUIImageList_DragEnter|GUIImageList_DragLeave|GUIImageList_DragMove|GUIImageList_Draw|GUIImageList_DrawEx|GUIImageList_Duplicate|GUIImageList_EndDrag|GUIImageList_GetBkColor|GUIImageList_GetIcon|GUIImageList_GetIconHeight|GUIImageList_GetIconSize|GUIImageList_GetIconSizeEx|GUIImageList_GetIconWidth|GUIImageList_GetImageCount|GUIImageList_GetImageInfoEx|GUIImageList_Remove|GUIImageList_ReplaceIcon|GUIImageList_SetBkColor|GUIImageList_SetIconSize|GUIImageList_SetImageCount|GUIImageList_Swap|GUIScrollBars_EnableScrollBar|GUIScrollBars_GetScrollBarInfoEx|GUIScrollBars_GetScrollBarRect|GUIScrollBars_GetScrollBarRGState|GUIScrollBars_GetScrollBarXYLineButton|GUIScrollBars_GetScrollBarXYThumbBottom|GUIScrollBars_GetScrollBarXYThumbTop|GUIScrollBars_GetScrollInfo|GUIScrollBars_GetScrollInfoEx|GUIScrollBars_GetScrollInfoMax|GUIScrollBars_GetScrollInfoMin|GUIScrollBars_GetScrollInfoPage|GUIScrollBars_GetScrollInfoPos|GUIScrollBars_GetScrollInfoTrackPos|GUIScrollBars_GetScrollPos|GUIScrollBars_GetScrollRange|GUIScrollBars_Init|GUIScrollBars_ScrollWindow|GUIScrollBars_SetScrollInfo|GUIScrollBars_SetScrollInfoMax|GUIScrollBars_SetScrollInfoMin|GUIScrollBars_SetScrollInfoPage|GUIScrollBars_SetScrollInfoPos|GUIScrollBars_SetScrollRange|GUIScrollBars_ShowScrollBar|GUIToolTip_Activate|GUIToolTip_AddTool|GUIToolTip_AdjustRect|GUIToolTip_BitsToTTF|GUIToolTip_Create|GUIToolTip_DelTool|GUIToolTip_Destroy|GUIToolTip_EnumTools|GUIToolTip_GetBubbleHeight|GUIToolTip_GetBubbleSize|GUIToolTip_GetBubbleWidth|GUIToolTip_GetCurrentTool|GUIToolTip_GetDelayTime|GUIToolTip_GetMargin|GUIToolTip_GetMarginEx|GUIToolTip_GetMaxTipWidth|GUIToolTip_GetText|GUIToolTip_GetTipBkColor|GUIToolTip_GetTipTextColor|GUIToolTip_GetTitleBitMap|GUIToolTip_GetTitleText|GUIToolTip_GetToolCount|GUIToolTip_GetToolInfo|GUIToolTip_HitTest|GUIToolTip_NewToolRect|GUIToolTip_Pop|GUIToolTip_PopUp|GUIToolTip_SetDelayTime|GUIToolTip_SetMargin|GUIToolTip_SetMaxTipWidth|GUIToolTip_SetTipBkColor|GUIToolTip_SetTipTextColor|GUIToolTip_SetTitle|GUIToolTip_SetToolInfo|GUIToolTip_SetWindowTheme|GUIToolTip_ToolExists|GUIToolTip_ToolToArray|GUIToolTip_TrackActivate|GUIToolTip_TrackPosition|GUIToolTip_TTFToBits|GUIToolTip_Update|GUIToolTip_UpdateTipText|HexToString|IE_Example|IE_Introduction|IE_VersionInfo|IEAction|IEAttach|IEBodyReadHTML|IEBodyReadText|IEBodyWriteHTML|IECreate|IECreateEmbedded|IEDocGetObj|IEDocInsertHTML|IEDocInsertText|IEDocReadHTML|IEDocWriteHTML|IEErrorHandlerDeRegister|IEErrorHandlerRegister|IEErrorNotify|IEFormElementCheckBoxSelect|IEFormElementGetCollection|IEFormElementGetObjByName|IEFormElementGetValue|IEFormElementOptionSelect|IEFormElementRadioSelect|IEFormElementSetValue|IEFormGetCollection|IEFormGetObjByName|IEFormImageClick|IEFormReset|IEFormSubmit|IEFrameGetCollection|IEFrameGetObjByName|IEGetObjById|IEGetObjByName|IEHeadInsertEventScript|IEImgClick|IEImgGetCollection|IEIsFrameSet|IELinkClickByIndex|IELinkClickByText|IELinkGetCollection|IELoadWait|IELoadWaitTimeout|IENavigate|IEPropertyGet|IEPropertySet|IEQuit|IETableGetCollection|IETableWriteToArray|IETagNameAllGetCollection|IETagNameGetCollection|Iif|INetExplorerCapable|INetGetSource|INetMail|INetSmtpMail|IsPressed|MathCheckDiv|Max|MemGlobalAlloc|MemGlobalFree|MemGlobalLock|MemGlobalSize|MemGlobalUnlock|MemMoveMemory|MemMsgBox|MemShowError|MemVirtualAlloc|MemVirtualAllocEx|MemVirtualFree|MemVirtualFreeEx|Min|MouseTrap|NamedPipes_CallNamedPipe|NamedPipes_ConnectNamedPipe|NamedPipes_CreateNamedPipe|NamedPipes_CreatePipe|NamedPipes_DisconnectNamedPipe|NamedPipes_GetNamedPipeHandleState|NamedPipes_GetNamedPipeInfo|NamedPipes_PeekNamedPipe|NamedPipes_SetNamedPipeHandleState|NamedPipes_TransactNamedPipe|NamedPipes_WaitNamedPipe|Net_Share_ConnectionEnum|Net_Share_FileClose|Net_Share_FileEnum|Net_Share_FileGetInfo|Net_Share_PermStr|Net_Share_ResourceStr|Net_Share_SessionDel|Net_Share_SessionEnum|Net_Share_SessionGetInfo|Net_Share_ShareAdd|Net_Share_ShareCheck|Net_Share_ShareDel|Net_Share_ShareEnum|Net_Share_ShareGetInfo|Net_Share_ShareSetInfo|Net_Share_StatisticsGetSvr|Net_Share_StatisticsGetWrk|Now|NowCalc|NowCalcDate|NowDate|NowTime|PathFull|PathMake|PathSplit|ProcessGetName|ProcessGetPriority|Radian|ReplaceStringInFile|RunDOS|ScreenCapture_Capture|ScreenCapture_CaptureWnd|ScreenCapture_SaveImage|ScreenCapture_SetBMPFormat|ScreenCapture_SetJPGQuality|ScreenCapture_SetTIFColorDepth|ScreenCapture_SetTIFCompression|Security__AdjustTokenPrivileges|Security__GetAccountSid|Security__GetLengthSid|Security__GetTokenInformation|Security__ImpersonateSelf|Security__IsValidSid|Security__LookupAccountName|Security__LookupAccountSid|Security__LookupPrivilegeValue|Security__OpenProcessToken|Security__OpenThreadToken|Security__OpenThreadTokenEx|Security__SetPrivilege|Security__SidToStringSid|Security__SidTypeStr|Security__StringSidToSid|SendMessage|SendMessageA|SetDate|SetTime|Singleton|SoundClose|SoundLength|SoundOpen|SoundPause|SoundPlay|SoundPos|SoundResume|SoundSeek|SoundStatus|SoundStop|SQLite_Changes|SQLite_Close|SQLite_Display2DResult|SQLite_Encode|SQLite_ErrCode|SQLite_ErrMsg|SQLite_Escape|SQLite_Exec|SQLite_FetchData|SQLite_FetchNames|SQLite_GetTable|SQLite_GetTable2d|SQLite_LastInsertRowID|SQLite_LibVersion|SQLite_Open|SQLite_Query|SQLite_QueryFinalize|SQLite_QueryReset|SQLite_QuerySingleRow|SQLite_SaveMode|SQLite_SetTimeout|SQLite_Shutdown|SQLite_SQLiteExe|SQLite_Startup|SQLite_TotalChanges|StringAddComma|StringBetween|StringEncrypt|StringInsert|StringProper|StringRepeat|StringReverse|StringSplit|StringToHex|TCPIpToName|TempFile|TicksToTime|Timer_Diff|Timer_GetTimerID|Timer_Init|Timer_KillAllTimers|Timer_KillTimer|Timer_SetTimer|TimeToTicks|VersionCompare|viClose|viExecCommand|viFindGpib|viGpibBusReset|viGTL|viOpen|viSetAttribute|viSetTimeout|WeekNumberISO|WinAPI_AttachConsole|WinAPI_AttachThreadInput|WinAPI_Beep|WinAPI_BitBlt|WinAPI_CallNextHookEx|WinAPI_Check|WinAPI_ClientToScreen|WinAPI_CloseHandle|WinAPI_CommDlgExtendedError|WinAPI_CopyIcon|WinAPI_CreateBitmap|WinAPI_CreateCompatibleBitmap|WinAPI_CreateCompatibleDC|WinAPI_CreateEvent|WinAPI_CreateFile|WinAPI_CreateFont|WinAPI_CreateFontIndirect|WinAPI_CreateProcess|WinAPI_CreateSolidBitmap|WinAPI_CreateSolidBrush|WinAPI_CreateWindowEx|WinAPI_DefWindowProc|WinAPI_DeleteDC|WinAPI_DeleteObject|WinAPI_DestroyIcon|WinAPI_DestroyWindow|WinAPI_DrawEdge|WinAPI_DrawFrameControl|WinAPI_DrawIcon|WinAPI_DrawIconEx|WinAPI_DrawText|WinAPI_EnableWindow|WinAPI_EnumDisplayDevices|WinAPI_EnumWindows|WinAPI_EnumWindowsPopup|WinAPI_EnumWindowsTop|WinAPI_ExpandEnvironmentStrings|WinAPI_ExtractIconEx|WinAPI_FatalAppExit|WinAPI_FillRect|WinAPI_FindExecutable|WinAPI_FindWindow|WinAPI_FlashWindow|WinAPI_FlashWindowEx|WinAPI_FloatToInt|WinAPI_FlushFileBuffers|WinAPI_FormatMessage|WinAPI_FrameRect|WinAPI_FreeLibrary|WinAPI_GetAncestor|WinAPI_GetAsyncKeyState|WinAPI_GetClassName|WinAPI_GetClientHeight|WinAPI_GetClientRect|WinAPI_GetClientWidth|WinAPI_GetCurrentProcess|WinAPI_GetCurrentProcessID|WinAPI_GetCurrentThread|WinAPI_GetCurrentThreadId|WinAPI_GetCursorInfo|WinAPI_GetDC|WinAPI_GetDesktopWindow|WinAPI_GetDeviceCaps|WinAPI_GetDIBits|WinAPI_GetDlgCtrlID|WinAPI_GetDlgItem|WinAPI_GetFileSizeEx|WinAPI_GetFocus|WinAPI_GetForegroundWindow|WinAPI_GetIconInfo|WinAPI_GetLastError|WinAPI_GetLastErrorMessage|WinAPI_GetModuleHandle|WinAPI_GetMousePos|WinAPI_GetMousePosX|WinAPI_GetMousePosY|WinAPI_GetObject|WinAPI_GetOpenFileName|WinAPI_GetOverlappedResult|WinAPI_GetParent|WinAPI_GetProcessAffinityMask|WinAPI_GetSaveFileName|WinAPI_GetStdHandle|WinAPI_GetStockObject|WinAPI_GetSysColor|WinAPI_GetSysColorBrush|WinAPI_GetSystemMetrics|WinAPI_GetTextExtentPoint32|WinAPI_GetWindow|WinAPI_GetWindowDC|WinAPI_GetWindowHeight|WinAPI_GetWindowLong|WinAPI_GetWindowRect|WinAPI_GetWindowText|WinAPI_GetWindowThreadProcessId|WinAPI_GetWindowWidth|WinAPI_GetXYFromPoint|WinAPI_GlobalMemStatus|WinAPI_GUIDFromString|WinAPI_GUIDFromStringEx|WinAPI_HiWord|WinAPI_InProcess|WinAPI_IntToFloat|WinAPI_InvalidateRect|WinAPI_IsClassName|WinAPI_IsWindow|WinAPI_IsWindowVisible|WinAPI_LoadBitmap|WinAPI_LoadImage|WinAPI_LoadLibrary|WinAPI_LoadLibraryEx|WinAPI_LoadShell32Icon|WinAPI_LoadString|WinAPI_LocalFree|WinAPI_LoWord|WinAPI_MakeDWord|WinAPI_MAKELANGID|WinAPI_MAKELCID|WinAPI_MakeLong|WinAPI_MessageBeep|WinAPI_Mouse_Event|WinAPI_MoveWindow|WinAPI_MsgBox|WinAPI_MulDiv|WinAPI_MultiByteToWideChar|WinAPI_MultiByteToWideCharEx|WinAPI_OpenProcess|WinAPI_PointFromRect|WinAPI_PostMessage|WinAPI_PrimaryLangId|WinAPI_PtInRect|WinAPI_ReadFile|WinAPI_ReadProcessMemory|WinAPI_RectIsEmpty|WinAPI_RedrawWindow|WinAPI_RegisterWindowMessage|WinAPI_ReleaseCapture|WinAPI_ReleaseDC|WinAPI_ScreenToClient|WinAPI_SelectObject|WinAPI_SetBkColor|WinAPI_SetCapture|WinAPI_SetCursor|WinAPI_SetDefaultPrinter|WinAPI_SetDIBits|WinAPI_SetEvent|WinAPI_SetFocus|WinAPI_SetFont|WinAPI_SetHandleInformation|WinAPI_SetLastError|WinAPI_SetParent|WinAPI_SetProcessAffinityMask|WinAPI_SetSysColors|WinAPI_SetTextColor|WinAPI_SetWindowLong|WinAPI_SetWindowPos|WinAPI_SetWindowsHookEx|WinAPI_SetWindowText|WinAPI_ShowCursor|WinAPI_ShowError|WinAPI_ShowMsg|WinAPI_ShowWindow|WinAPI_StringFromGUID|WinAPI_SubLangId|WinAPI_SystemParametersInfo|WinAPI_TwipsPerPixelX|WinAPI_TwipsPerPixelY|WinAPI_UnhookWindowsHookEx|WinAPI_UpdateLayeredWindow|WinAPI_UpdateWindow|WinAPI_ValidateClassName|WinAPI_WaitForInputIdle|WinAPI_WaitForMultipleObjects|WinAPI_WaitForSingleObject|WinAPI_WideCharToMultiByte|WinAPI_WindowFromPoint|WinAPI_WriteConsole|WinAPI_WriteFile|WinAPI_WriteProcessMemory|WinNet_AddConnection|WinNet_AddConnection2|WinNet_AddConnection3|WinNet_CancelConnection|WinNet_CancelConnection2|WinNet_CloseEnum|WinNet_ConnectionDialog|WinNet_ConnectionDialog1|WinNet_DisconnectDialog|WinNet_DisconnectDialog1|WinNet_EnumResource|WinNet_GetConnection|WinNet_GetConnectionPerformance|WinNet_GetLastError|WinNet_GetNetworkInformation|WinNet_GetProviderName|WinNet_GetResourceInformation|WinNet_GetResourceParent|WinNet_GetUniversalName|WinNet_GetUser|WinNet_OpenEnum|WinNet_RestoreConnection|WinNet_UseConnection|Word_VersionInfo|WordAttach|WordCreate|WordDocAdd|WordDocAddLink|WordDocAddPicture|WordDocClose|WordDocFindReplace|WordDocGetCollection|WordDocLinkGetCollection|WordDocOpen|WordDocPrint|WordDocPropertyGet|WordDocPropertySet|WordDocSave|WordDocSaveAs|WordErrorHandlerDeRegister|WordErrorHandlerRegister|WordErrorNotify|WordMacroRun|WordPropertyGet|WordPropertySet|WordQuit|' +
        'ce|comments-end|comments-start|cs|include|include-once|NoTrayIcon|RequireAdmin|' +
        'AutoIt3Wrapper_Au3Check_Parameters|AutoIt3Wrapper_Au3Check_Stop_OnWarning|AutoIt3Wrapper_Change2CUI|AutoIt3Wrapper_Compression|AutoIt3Wrapper_cvsWrapper_Parameters|AutoIt3Wrapper_Icon|AutoIt3Wrapper_Outfile|AutoIt3Wrapper_Outfile_Type|AutoIt3Wrapper_Plugin_Funcs|AutoIt3Wrapper_Res_Comment|AutoIt3Wrapper_Res_Description|AutoIt3Wrapper_Res_Field|AutoIt3Wrapper_Res_File_Add|AutoIt3Wrapper_Res_Fileversion|AutoIt3Wrapper_Res_FileVersion_AutoIncrement|AutoIt3Wrapper_Res_Icon_Add|AutoIt3Wrapper_Res_Language|AutoIt3Wrapper_Res_LegalCopyright|AutoIt3Wrapper_res_requestedExecutionLevel|AutoIt3Wrapper_Res_SaveSource|AutoIt3Wrapper_Run_After|AutoIt3Wrapper_Run_Au3check|AutoIt3Wrapper_Run_Before|AutoIt3Wrapper_Run_cvsWrapper|AutoIt3Wrapper_Run_Debug_Mode|AutoIt3Wrapper_Run_Obfuscator|AutoIt3Wrapper_Run_Tidy|AutoIt3Wrapper_Tidy_Stop_OnError|AutoIt3Wrapper_UseAnsi|AutoIt3Wrapper_UseUpx|AutoIt3Wrapper_UseX64|AutoIt3Wrapper_Version|EndRegion|forceref|Obfuscator_Ignore_Funcs|Obfuscator_Ignore_Variables|Obfuscator_Parameters|Region|Tidy_Parameters';
    var atKeywords = 'AppDataCommonDir|AppDataDir|AutoItExe|AutoItPID|AutoItUnicode|AutoItVersion|AutoItX64|COM_EventObj|CommonFilesDir|Compiled|ComputerName|ComSpec|CR|CRLF|DesktopCommonDir|DesktopDepth|DesktopDir|DesktopHeight|DesktopRefresh|DesktopWidth|DocumentsCommonDir|error|exitCode|exitMethod|extended|FavoritesCommonDir|FavoritesDir|GUI_CtrlHandle|GUI_CtrlId|GUI_DragFile|GUI_DragId|GUI_DropId|GUI_WinHandle|HomeDrive|HomePath|HomeShare|HotKeyPressed|HOUR|InetGetActive|InetGetBytesRead|IPAddress1|IPAddress2|IPAddress3|IPAddress4|KBLayout|LF|LogonDNSDomain|LogonDomain|LogonServer|MDAY|MIN|MON|MyDocumentsDir|NumParams|OSBuild|OSLang|OSServicePack|OSTYPE|OSVersion|ProcessorArch|ProgramFilesDir|ProgramsCommonDir|ProgramsDir|ScriptDir|ScriptFullPath|ScriptLineNumber|ScriptName|SEC|StartMenuCommonDir|StartMenuDir|StartupCommonDir|StartupDir|SW_DISABLE|SW_ENABLE|SW_HIDE|SW_LOCK|SW_MAXIMIZE|SW_MINIMIZE|SW_RESTORE|SW_SHOW|SW_SHOWDEFAULT|SW_SHOWMAXIMIZED|SW_SHOWMINIMIZED|SW_SHOWMINNOACTIVE|SW_SHOWNA|SW_SHOWNOACTIVATE|SW_SHOWNORMAL|SW_UNLOCK|SystemDir|TAB|TempDir|TRAY_ID|TrayIconFlashing|TrayIconVisible|UserName|UserProfileDir|WDAY|WindowsDir|WorkingDir|YDAY|YEAR';
    this.$rules = { start: [{ token: 'comment.line.ahk', regex: '(?:^| );.*$' },
            { token: 'comment.block.ahk',
                regex: '/\\*', push: [{ token: 'comment.block.ahk', regex: '\\*/', next: 'pop' },
                    { defaultToken: 'comment.block.ahk' }] },
            { token: 'doc.comment.ahk',
                regex: '#cs', push: [{ token: 'doc.comment.ahk', regex: '#ce', next: 'pop' },
                    { defaultToken: 'doc.comment.ahk' }] },
            { token: 'keyword.command.ahk',
                regex: '(?:\\b|^)(?:allowsamelinecomments|clipboardtimeout|commentflag|errorstdout|escapechar|hotkeyinterval|hotkeymodifiertimeout|hotstring|include|includeagain|installkeybdhook|installmousehook|keyhistory|ltrim|maxhotkeysperinterval|maxmem|maxthreads|maxthreadsbuffer|maxthreadsperhotkey|noenv|notrayicon|persistent|singleinstance|usehook|winactivateforce|autotrim|blockinput|click|clipwait|continue|control|controlclick|controlfocus|controlget|controlgetfocus|controlgetpos|controlgettext|controlmove|controlsend|controlsendraw|controlsettext|coordmode|critical|detecthiddentext|detecthiddenwindows|drive|driveget|drivespacefree|edit|endrepeat|envadd|envdiv|envget|envmult|envset|envsub|envupdate|exit|exitapp|fileappend|filecopy|filecopydir|filecreatedir|filecreateshortcut|filedelete|filegetattrib|filegetshortcut|filegetsize|filegettime|filegetversion|fileinstall|filemove|filemovedir|fileread|filereadline|filerecycle|filerecycleempty|fileremovedir|fileselectfile|fileselectfolder|filesetattrib|filesettime|formattime|getkeystate|gosub|goto|groupactivate|groupadd|groupclose|groupdeactivate|gui|guicontrol|guicontrolget|hideautoitwin|hotkey|ifequal|ifexist|ifgreater|ifgreaterorequal|ifinstring|ifless|iflessorequal|ifmsgbox|ifnotequal|ifnotexist|ifnotinstring|ifwinactive|ifwinexist|ifwinnotactive|ifwinnotexist|imagesearch|inidelete|iniread|iniwrite|input|inputbox|keyhistory|keywait|listhotkeys|listlines|listvars|menu|mouseclick|mouseclickdrag|mousegetpos|mousemove|msgbox|onexit|outputdebug|pause|pixelgetcolor|pixelsearch|postmessage|process|progress|random|regdelete|regread|regwrite|reload|repeat|run|runas|runwait|send|sendevent|sendinput|sendmode|sendplay|sendmessage|sendraw|setbatchlines|setcapslockstate|setcontroldelay|setdefaultmousespeed|setenv|setformat|setkeydelay|setmousedelay|setnumlockstate|setscrolllockstate|setstorecapslockmode|settimer|settitlematchmode|setwindelay|setworkingdir|shutdown|sleep|sort|soundbeep|soundget|soundgetwavevolume|soundplay|soundset|soundsetwavevolume|splashimage|splashtextoff|splashtexton|splitpath|statusbargettext|statusbarwait|stringcasesense|stringgetpos|stringleft|stringlen|stringlower|stringmid|stringreplace|stringright|stringsplit|stringtrimleft|stringtrimright|stringupper|suspend|sysget|thread|tooltip|transform|traytip|urldownloadtofile|while|winactivate|winactivatebottom|winclose|winget|wingetactivestats|wingetactivetitle|wingetclass|wingetpos|wingettext|wingettitle|winhide|winkill|winmaximize|winmenuselectitem|winminimize|winminimizeall|winminimizeallundo|winmove|winrestore|winset|winsettitle|winshow|winwait|winwaitactive|winwaitclose|winwaitnotactive)\\b',
                caseInsensitive: true },
            { token: 'keyword.control.ahk',
                regex: '(?:\\b|^)(?:if|else|return|loop|break|for|while|global|local|byref)\\b',
                caseInsensitive: true },
            { token: 'support.function.ahk',
                regex: '(?:\\b|^)(?:abs|acos|asc|asin|atan|ceil|chr|cos|dllcall|exp|fileexist|floor|getkeystate|il_add|il_create|il_destroy|instr|substr|isfunc|islabel|ln|log|lv_add|lv_delete|lv_deletecol|lv_getcount|lv_getnext|lv_gettext|lv_insert|lv_insertcol|lv_modify|lv_modifycol|lv_setimagelist|mod|onmessage|numget|numput|registercallback|regexmatch|regexreplace|round|sin|tan|sqrt|strlen|sb_seticon|sb_setparts|sb_settext|tv_add|tv_delete|tv_getchild|tv_getcount|tv_getnext|tv_get|tv_getparent|tv_getprev|tv_getselection|tv_gettext|tv_modify|varsetcapacity|winactive|winexist)\\b',
                caseInsensitive: true },
            { token: 'variable.predefined.ahk',
                regex: '(?:\\b|^)(?:a_ahkpath|a_ahkversion|a_appdata|a_appdatacommon|a_autotrim|a_batchlines|a_caretx|a_carety|a_computername|a_controldelay|a_cursor|a_dd|a_ddd|a_dddd|a_defaultmousespeed|a_desktop|a_desktopcommon|a_detecthiddentext|a_detecthiddenwindows|a_endchar|a_eventinfo|a_exitreason|a_formatfloat|a_formatinteger|a_gui|a_guievent|a_guicontrol|a_guicontrolevent|a_guiheight|a_guiwidth|a_guix|a_guiy|a_hour|a_iconfile|a_iconhidden|a_iconnumber|a_icontip|a_index|a_ipaddress1|a_ipaddress2|a_ipaddress3|a_ipaddress4|a_isadmin|a_iscompiled|a_iscritical|a_ispaused|a_issuspended|a_keydelay|a_language|a_lasterror|a_linefile|a_linenumber|a_loopfield|a_loopfileattrib|a_loopfiledir|a_loopfileext|a_loopfilefullpath|a_loopfilelongpath|a_loopfilename|a_loopfileshortname|a_loopfileshortpath|a_loopfilesize|a_loopfilesizekb|a_loopfilesizemb|a_loopfiletimeaccessed|a_loopfiletimecreated|a_loopfiletimemodified|a_loopreadline|a_loopregkey|a_loopregname|a_loopregsubkey|a_loopregtimemodified|a_loopregtype|a_mday|a_min|a_mm|a_mmm|a_mmmm|a_mon|a_mousedelay|a_msec|a_mydocuments|a_now|a_nowutc|a_numbatchlines|a_ostype|a_osversion|a_priorhotkey|programfiles|a_programfiles|a_programs|a_programscommon|a_screenheight|a_screenwidth|a_scriptdir|a_scriptfullpath|a_scriptname|a_sec|a_space|a_startmenu|a_startmenucommon|a_startup|a_startupcommon|a_stringcasesense|a_tab|a_temp|a_thisfunc|a_thishotkey|a_thislabel|a_thismenu|a_thismenuitem|a_thismenuitempos|a_tickcount|a_timeidle|a_timeidlephysical|a_timesincepriorhotkey|a_timesincethishotkey|a_titlematchmode|a_titlematchmodespeed|a_username|a_wday|a_windelay|a_windir|a_workingdir|a_yday|a_year|a_yweek|a_yyyy|clipboard|clipboardall|comspec|errorlevel)\\b',
                caseInsensitive: true },
            { token: 'support.constant.ahk',
                regex: '(?:\\b|^)(?:shift|lshift|rshift|alt|lalt|ralt|control|lcontrol|rcontrol|ctrl|lctrl|rctrl|lwin|rwin|appskey|altdown|altup|shiftdown|shiftup|ctrldown|ctrlup|lwindown|lwinup|rwindown|rwinup|lbutton|rbutton|mbutton|wheelup|wheelleft|wheelright|wheeldown|xbutton1|xbutton2|joy1|joy2|joy3|joy4|joy5|joy6|joy7|joy8|joy9|joy10|joy11|joy12|joy13|joy14|joy15|joy16|joy17|joy18|joy19|joy20|joy21|joy22|joy23|joy24|joy25|joy26|joy27|joy28|joy29|joy30|joy31|joy32|joyx|joyy|joyz|joyr|joyu|joyv|joypov|joyname|joybuttons|joyaxes|joyinfo|space|tab|enter|escape|esc|backspace|bs|delete|del|insert|ins|pgup|pgdn|home|end|up|down|left|right|printscreen|ctrlbreak|pause|scrolllock|capslock|numlock|numpad0|numpad1|numpad2|numpad3|numpad4|numpad5|numpad6|numpad7|numpad8|numpad9|numpadmult|numpadadd|numpadsub|numpaddiv|numpaddot|numpaddel|numpadins|numpadclear|numpadup|numpaddown|numpadleft|numpadright|numpadhome|numpadend|numpadpgup|numpadpgdn|numpadenter|f1|f2|f3|f4|f5|f6|f7|f8|f9|f10|f11|f12|f13|f14|f15|f16|f17|f18|f19|f20|f21|f22|f23|f24|browser_back|browser_forward|browser_refresh|browser_stop|browser_search|browser_favorites|browser_home|volume_mute|volume_down|volume_up|media_next|media_prev|media_stop|media_play_pause|launch_mail|launch_media|launch_app1|launch_app2)\\b',
                caseInsensitive: true },
            { token: 'variable.parameter',
                regex: '(?:\\b|^)(?:pixel|mouse|screen|relative|rgb|ltrim|rtrim|join|low|belownormal|normal|abovenormal|high|realtime|ahk_id|ahk_pid|ahk_class|ahk_group|between|contains|in|is|integer|float|integerfast|floatfast|number|digit|xdigit|alpha|upper|lower|alnum|time|date|not|or|and|alwaysontop|topmost|top|bottom|transparent|transcolor|redraw|region|id|idlast|processname|minmax|controllist|count|list|capacity|statuscd|eject|lock|unlock|label|filesystem|label|setlabel|serial|type|status|static|seconds|minutes|hours|days|read|parse|logoff|close|error|single|tray|add|rename|check|uncheck|togglecheck|enable|disable|toggleenable|default|nodefault|standard|nostandard|color|delete|deleteall|icon|noicon|tip|click|show|mainwindow|nomainwindow|useerrorlevel|text|picture|pic|groupbox|button|checkbox|radio|dropdownlist|ddl|combobox|listbox|listview|datetime|monthcal|updown|slider|tab|tab2|statusbar|treeview|iconsmall|tile|report|sortdesc|nosort|nosorthdr|grid|hdr|autosize|range|xm|ym|ys|xs|xp|yp|font|resize|owner|submit|nohide|minimize|maximize|restore|noactivate|na|cancel|destroy|center|margin|maxsize|minsize|owndialogs|guiescape|guiclose|guisize|guicontextmenu|guidropfiles|tabstop|section|altsubmit|wrap|hscroll|vscroll|border|top|bottom|buttons|expand|first|imagelist|lines|wantctrla|wantf2|vis|visfirst|number|uppercase|lowercase|limit|password|multi|wantreturn|group|background|bold|italic|strike|underline|norm|backgroundtrans|theme|caption|delimiter|minimizebox|maximizebox|sysmenu|toolwindow|flash|style|exstyle|check3|checked|checkedgray|readonly|password|hidden|left|right|center|notab|section|move|focus|hide|choose|choosestring|text|pos|enabled|disabled|visible|lastfound|lastfoundexist|alttab|shiftalttab|alttabmenu|alttabandmenu|alttabmenudismiss|notimers|interrupt|priority|waitclose|blind|raw|unicode|deref|pow|bitnot|bitand|bitor|bitxor|bitshiftleft|bitshiftright|yes|no|ok|cancel|abort|retry|ignore|tryagain|on|off|all|hkey_local_machine|hkey_users|hkey_current_user|hkey_classes_root|hkey_current_config|hklm|hku|hkcu|hkcr|hkcc|reg_sz|reg_expand_sz|reg_multi_sz|reg_dword|reg_qword|reg_binary|reg_link|reg_resource_list|reg_full_resource_descriptor|reg_resource_requirements_list|reg_dword_big_endian)\\b',
                caseInsensitive: true },
            { keywordMap: { "constant.language": autoItKeywords }, regex: '\\w+\\b' },
            { keywordMap: { "variable.function": atKeywords }, regex: '@\\w+\\b' },
            { token: "constant.numeric", regex: "[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b" },
            { token: 'keyword.operator.ahk',
                regex: '=|==|<>|:=|<|>|\\*|\\/|\\+|:|\\?|\\-' },
            { token: 'punctuation.ahk',
                regex: /#|`|::|,|%/ },
            { token: 'paren',
                regex: /[{}()]/ },
            { token: ['punctuation.quote.double',
                    'string.quoted.ahk',
                    'punctuation.quote.double'],
                regex: '(")((?:[^"]|"")*)(")' },
            { token: ['label.ahk', 'punctuation.definition.label.ahk'],
                regex: '^([^: ]+)(:)(?!:)' }] };
    this.normalizeRules();
};
AutoHotKeyHighlightRules.metaData = { name: 'AutoHotKey',
    scopeName: 'source.ahk',
    fileTypes: ['ahk'],
    foldingStartMarker: '^\\s*/\\*|^(?![^{]*?;|[^{]*?/\\*(?!.*?\\*/.*?\\{)).*?\\{\\s*($|;|/\\*(?!.*?\\*/.*\\S))',
    foldingStopMarker: '^\\s*\\*/|^\\s*\\}' };
oop.inherits(AutoHotKeyHighlightRules, TextHighlightRules);
exports.AutoHotKeyHighlightRules = AutoHotKeyHighlightRules;

});

define("ace/mode/autohotkey",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/autohotkey_highlight_rules","ace/mode/folding/cstyle"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY mode.tmpl.js
*/
"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var AutoHotKeyHighlightRules = require("./autohotkey_highlight_rules").AutoHotKeyHighlightRules;
var FoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = AutoHotKeyHighlightRules;
    this.foldingRules = new FoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = ";";
    this.blockComment = { start: "/*", end: "*/" };
    this.$id = "ace/mode/autohotkey";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/batchfile_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){/* This file was autogenerated from C:\Users\LED\AppData\Roaming\Sublime Text 2\Packages\Batch File\Batch File.tmLanguage (uuid: ) */
"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var BatchFileHighlightRules = function () {
    this.$rules = { start: [{ token: 'keyword.command.dosbatch',
                regex: '\\b(?:append|assoc|at|attrib|break|cacls|cd|chcp|chdir|chkdsk|chkntfs|cls|cmd|color|comp|compact|convert|copy|date|del|dir|diskcomp|diskcopy|doskey|echo|endlocal|erase|fc|find|findstr|format|ftype|graftabl|help|keyb|label|md|mkdir|mode|more|move|path|pause|popd|print|prompt|pushd|rd|recover|ren|rename|replace|restore|rmdir|set|setlocal|shift|sort|start|subst|time|title|tree|type|ver|verify|vol|xcopy)\\b',
                caseInsensitive: true },
            { token: 'keyword.control.statement.dosbatch',
                regex: '\\b(?:goto|call|exit)\\b',
                caseInsensitive: true },
            { token: 'keyword.control.conditional.if.dosbatch',
                regex: '\\bif\\s+not\\s+(?:exist|defined|errorlevel|cmdextversion)\\b',
                caseInsensitive: true },
            { token: 'keyword.control.conditional.dosbatch',
                regex: '\\b(?:if|else)\\b',
                caseInsensitive: true },
            { token: 'keyword.control.repeat.dosbatch',
                regex: '\\bfor\\b',
                caseInsensitive: true },
            { token: 'keyword.operator.dosbatch',
                regex: '\\b(?:EQU|NEQ|LSS|LEQ|GTR|GEQ)\\b' },
            { token: ['doc.comment', 'comment'],
                regex: '(?:^|\\b)(rem)($|\\s.*$)',
                caseInsensitive: true },
            { token: 'comment.line.colons.dosbatch',
                regex: '::.*$' },
            { include: 'variable' },
            { token: 'punctuation.definition.string.begin.shell',
                regex: '"',
                push: [
                    { token: 'punctuation.definition.string.end.shell', regex: '"', next: 'pop' },
                    { include: 'variable' },
                    { defaultToken: 'string.quoted.double.dosbatch' }
                ] },
            { token: 'keyword.operator.pipe.dosbatch', regex: '[|]' },
            { token: 'keyword.operator.redirect.shell',
                regex: '&>|\\d*>&\\d*|\\d*(?:>>|>|<)|\\d*<&|\\d*<>' }],
        variable: [
            { token: 'constant.numeric', regex: '%%\\w+|%[*\\d]|%\\w+%' },
            { token: 'constant.numeric', regex: '%~\\d+' },
            { token: ['markup.list', 'constant.other', 'markup.list'],
                regex: '(%)(\\w+)(%?)' }
        ] };
    this.normalizeRules();
};
BatchFileHighlightRules.metaData = { name: 'Batch File',
    scopeName: 'source.dosbatch',
    fileTypes: ['bat'] };
oop.inherits(BatchFileHighlightRules, TextHighlightRules);
exports.BatchFileHighlightRules = BatchFileHighlightRules;

});

define("ace/mode/batchfile",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/batchfile_highlight_rules","ace/mode/folding/cstyle"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY mode.tmpl.js
*/
"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var BatchFileHighlightRules = require("./batchfile_highlight_rules").BatchFileHighlightRules;
var FoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = BatchFileHighlightRules;
    this.foldingRules = new FoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "::";
    this.blockComment = "";
    this.$id = "ace/mode/batchfile";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/c9search_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var lang = require("../lib/lang");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
function safeCreateRegexp(source, flag) {
    try {
        return new RegExp(source, flag);
    }
    catch (e) { }
}
var C9SearchHighlightRules = function () {
    this.$rules = {
        "start": [
            {
                tokenNames: ["c9searchresults.constant.numeric", "c9searchresults.text", "c9searchresults.text", "c9searchresults.keyword"],
                regex: /(^\s+[0-9]+)(:)(\d*\s?)([^\r\n]+)/,
                onMatch: function (val, state, stack) {
                    var values = this.splitRegex.exec(val);
                    var types = this.tokenNames;
                    var tokens = [{
                            type: types[0],
                            value: values[1]
                        }, {
                            type: types[1],
                            value: values[2]
                        }];
                    if (values[3]) {
                        if (values[3] == " ")
                            tokens[1] = { type: types[1], value: values[2] + " " };
                        else
                            tokens.push({ type: types[1], value: values[3] });
                    }
                    var regex = stack[1];
                    var str = values[4];
                    var m;
                    var last = 0;
                    if (regex && regex.exec) {
                        regex.lastIndex = 0;
                        while (m = regex.exec(str)) {
                            var skipped = str.substring(last, m.index);
                            last = regex.lastIndex;
                            if (skipped)
                                tokens.push({ type: types[2], value: skipped });
                            if (m[0])
                                tokens.push({ type: types[3], value: m[0] });
                            else if (!skipped)
                                break;
                        }
                    }
                    if (last < str.length)
                        tokens.push({ type: types[2], value: str.substr(last) });
                    return tokens;
                }
            },
            {
                regex: "^Searching for [^\\r\\n]*$",
                onMatch: function (val, state, stack) {
                    var parts = val.split("\x01");
                    if (parts.length < 3)
                        return "text";
                    var options, search;
                    var i = 0;
                    var tokens = [{
                            value: parts[i++] + "'",
                            type: "text"
                        }, {
                            value: search = parts[i++],
                            type: "text" // "c9searchresults.keyword"
                        }, {
                            value: "'" + parts[i++],
                            type: "text"
                        }];
                    if (parts[2] !== " in") {
                        tokens.push({
                            value: "'" + parts[i++] + "'",
                            type: "text"
                        }, {
                            value: parts[i++],
                            type: "text"
                        });
                    }
                    tokens.push({
                        value: " " + parts[i++] + " ",
                        type: "text"
                    });
                    if (parts[i + 1]) {
                        options = parts[i + 1];
                        tokens.push({
                            value: "(" + parts[i + 1] + ")",
                            type: "text"
                        });
                        i += 1;
                    }
                    else {
                        i -= 1;
                    }
                    while (i++ < parts.length) {
                        parts[i] && tokens.push({
                            value: parts[i],
                            type: "text"
                        });
                    }
                    if (search) {
                        if (!/regex/.test(options))
                            search = lang.escapeRegExp(search);
                        if (/whole/.test(options))
                            search = "\\b" + search + "\\b";
                    }
                    var regex = search && safeCreateRegexp("(" + search + ")", / sensitive/.test(options) ? "g" : "ig");
                    if (regex) {
                        stack[0] = state;
                        stack[1] = regex;
                    }
                    return tokens;
                }
            },
            {
                regex: "^(?=Found \\d+ matches)",
                token: "text",
                next: "numbers"
            },
            {
                token: "string",
                regex: "^\\S:?[^:]+",
                next: "numbers"
            }
        ],
        numbers: [{
                regex: "\\d+",
                token: "constant.numeric"
            }, {
                regex: "$",
                token: "text",
                next: "start"
            }]
    };
    this.normalizeRules();
};
oop.inherits(C9SearchHighlightRules, TextHighlightRules);
exports.C9SearchHighlightRules = C9SearchHighlightRules;

});

define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"], function(require, exports, module){"use strict";
var Range = require("../range").Range;
var MatchingBraceOutdent = function () { };
(function () {
    this.checkOutdent = function (line, input) {
        if (!/^\s+$/.test(line))
            return false;
        return /^\s*\}/.test(input);
    };
    this.autoOutdent = function (doc, row) {
        var line = doc.getLine(row);
        var match = line.match(/^(\s*\})/);
        if (!match)
            return 0;
        var column = match[1].length;
        var openBracePos = doc.findMatchingBracket({ row: row, column: column });
        if (!openBracePos || openBracePos.row == row)
            return 0;
        var indent = this.$getIndent(doc.getLine(openBracePos.row));
        doc.replace(new Range(row, 0, row, column - 1), indent);
    };
    this.$getIndent = function (line) {
        return line.match(/^\s*/)[0];
    };
}).call(MatchingBraceOutdent.prototype);
exports.MatchingBraceOutdent = MatchingBraceOutdent;

});

define("ace/mode/folding/c9search",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"], function(require, exports, module){"use strict";
var oop = require("../../lib/oop");
var Range = require("../../range").Range;
var BaseFoldMode = require("./fold_mode").FoldMode;
var FoldMode = exports.FoldMode = function () { };
oop.inherits(FoldMode, BaseFoldMode);
(function () {
    this.foldingStartMarker = /^(\S.*:|Searching for.*)$/;
    this.foldingStopMarker = /^(\s+|Found.*)$/;
    this.getFoldWidgetRange = function (session, foldStyle, row) {
        var lines = session.doc.getAllLines(row);
        var line = lines[row];
        var level1 = /^(Found.*|Searching for.*)$/;
        var level2 = /^(\S.*:|\s*)$/;
        var re = level1.test(line) ? level1 : level2;
        var startRow = row;
        var endRow = row;
        if (this.foldingStartMarker.test(line)) {
            for (var i = row + 1, l = session.getLength(); i < l; i++) {
                if (re.test(lines[i]))
                    break;
            }
            endRow = i;
        }
        else if (this.foldingStopMarker.test(line)) {
            for (var i = row - 1; i >= 0; i--) {
                line = lines[i];
                if (re.test(line))
                    break;
            }
            startRow = i;
        }
        if (startRow != endRow) {
            var col = line.length;
            if (re === level1)
                col = line.search(/\(Found[^)]+\)$|$/);
            return new Range(startRow, col, endRow, 0);
        }
    };
}).call(FoldMode.prototype);

});

define("ace/mode/c9search",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/c9search_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/c9search"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var C9SearchHighlightRules = require("./c9search_highlight_rules").C9SearchHighlightRules;
var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var C9StyleFoldMode = require("./folding/c9search").FoldMode;
var Mode = function () {
    this.HighlightRules = C9SearchHighlightRules;
    this.$outdent = new MatchingBraceOutdent();
    this.foldingRules = new C9StyleFoldMode();
};
oop.inherits(Mode, TextMode);
(function () {
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        return indent;
    };
    this.checkOutdent = function (state, line, input) {
        return this.$outdent.checkOutdent(line, input);
    };
    this.autoOutdent = function (state, doc, row) {
        this.$outdent.autoOutdent(doc, row);
    };
    this.$id = "ace/mode/c9search";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/cirru_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var CirruHighlightRules = function () {
    this.$rules = {
        start: [{
                token: 'constant.numeric',
                regex: /[\d\.]+/
            }, {
                token: 'comment.line.double-dash',
                regex: /--/,
                next: 'comment'
            }, {
                token: 'storage.modifier',
                regex: /\(/
            }, {
                token: 'storage.modifier',
                regex: /,/,
                next: 'line'
            }, {
                token: 'support.function',
                regex: /[^\(\)"\s{}\[\]]+/,
                next: 'line'
            }, {
                token: 'string.quoted.double',
                regex: /"/,
                next: 'string'
            }, {
                token: 'storage.modifier',
                regex: /\)/
            }],
        comment: [{
                token: 'comment.line.double-dash',
                regex: / +[^\n]+/,
                next: 'start'
            }],
        string: [{
                token: 'string.quoted.double',
                regex: /"/,
                next: 'line'
            }, {
                token: 'constant.character.escape',
                regex: /\\/,
                next: 'escape'
            }, {
                token: 'string.quoted.double',
                regex: /[^\\"]+/
            }],
        escape: [{
                token: 'constant.character.escape',
                regex: /./,
                next: 'string'
            }],
        line: [{
                token: 'constant.numeric',
                regex: /[\d\.]+/
            }, {
                token: 'markup.raw',
                regex: /^\s*/,
                next: 'start'
            }, {
                token: 'storage.modifier',
                regex: /\$/,
                next: 'start'
            }, {
                token: 'variable.parameter',
                regex: /[^\(\)"\s{}\[\]]+/
            }, {
                token: 'storage.modifier',
                regex: /\(/,
                next: 'start'
            }, {
                token: 'storage.modifier',
                regex: /\)/
            }, {
                token: 'markup.raw',
                regex: /^ */,
                next: 'start'
            }, {
                token: 'string.quoted.double',
                regex: /"/,
                next: 'string'
            }]
    };
};
oop.inherits(CirruHighlightRules, TextHighlightRules);
exports.CirruHighlightRules = CirruHighlightRules;

});

define("ace/mode/cirru",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/cirru_highlight_rules","ace/mode/folding/coffee"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var CirruHighlightRules = require("./cirru_highlight_rules").CirruHighlightRules;
var CoffeeFoldMode = require("./folding/coffee").FoldMode;
var Mode = function () {
    this.HighlightRules = CirruHighlightRules;
    this.foldingRules = new CoffeeFoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "--";
    this.$id = "ace/mode/cirru";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/clojure_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var ClojureHighlightRules = function () {
    var builtinFunctions = ('* *1 *2 *3 *agent* *allow-unresolved-vars* *assert* *clojure-version* ' +
        '*command-line-args* *compile-files* *compile-path* *e *err* *file* ' +
        '*flush-on-newline* *in* *macro-meta* *math-context* *ns* *out* ' +
        '*print-dup* *print-length* *print-level* *print-meta* *print-readably* ' +
        '*read-eval* *source-path* *use-context-classloader* ' +
        '*warn-on-reflection* + - -> ->> .. / < <= = ' +
        '== > &gt; >= &gt;= accessor aclone ' +
        'add-classpath add-watch agent agent-errors aget alength alias all-ns ' +
        'alter alter-meta! alter-var-root amap ancestors and apply areduce ' +
        'array-map aset aset-boolean aset-byte aset-char aset-double aset-float ' +
        'aset-int aset-long aset-short assert assoc assoc! assoc-in associative? ' +
        'atom await await-for await1 bases bean bigdec bigint binding bit-and ' +
        'bit-and-not bit-clear bit-flip bit-not bit-or bit-set bit-shift-left ' +
        'bit-shift-right bit-test bit-xor boolean boolean-array booleans ' +
        'bound-fn bound-fn* butlast byte byte-array bytes cast char char-array ' +
        'char-escape-string char-name-string char? chars chunk chunk-append ' +
        'chunk-buffer chunk-cons chunk-first chunk-next chunk-rest chunked-seq? ' +
        'class class? clear-agent-errors clojure-version coll? comment commute ' +
        'comp comparator compare compare-and-set! compile complement concat cond ' +
        'condp conj conj! cons constantly construct-proxy contains? count ' +
        'counted? create-ns create-struct cycle dec decimal? declare definline ' +
        'defmacro defmethod defmulti defn defn- defonce defstruct delay delay? ' +
        'deliver deref derive descendants destructure disj disj! dissoc dissoc! ' +
        'distinct distinct? doall doc dorun doseq dosync dotimes doto double ' +
        'double-array doubles drop drop-last drop-while empty empty? ensure ' +
        'enumeration-seq eval even? every? false? ffirst file-seq filter find ' +
        'find-doc find-ns find-var first float float-array float? floats flush ' +
        'fn fn? fnext for force format future future-call future-cancel ' +
        'future-cancelled? future-done? future? gen-class gen-interface gensym ' +
        'get get-in get-method get-proxy-class get-thread-bindings get-validator ' +
        'hash hash-map hash-set identical? identity if-let if-not ifn? import ' +
        'in-ns inc init-proxy instance? int int-array integer? interleave intern ' +
        'interpose into into-array ints io! isa? iterate iterator-seq juxt key ' +
        'keys keyword keyword? last lazy-cat lazy-seq let letfn line-seq list ' +
        'list* list? load load-file load-reader load-string loaded-libs locking ' +
        'long long-array longs loop macroexpand macroexpand-1 make-array ' +
        'make-hierarchy map map? mapcat max max-key memfn memoize merge ' +
        'merge-with meta method-sig methods min min-key mod name namespace neg? ' +
        'newline next nfirst nil? nnext not not-any? not-empty not-every? not= ' +
        'ns ns-aliases ns-imports ns-interns ns-map ns-name ns-publics ' +
        'ns-refers ns-resolve ns-unalias ns-unmap nth nthnext num number? odd? ' +
        'or parents partial partition pcalls peek persistent! pmap pop pop! ' +
        'pop-thread-bindings pos? pr pr-str prefer-method prefers ' +
        'primitives-classnames print print-ctor print-doc print-dup print-method ' +
        'print-namespace-doc print-simple print-special-doc print-str printf ' +
        'println println-str prn prn-str promise proxy proxy-call-with-super ' +
        'proxy-mappings proxy-name proxy-super push-thread-bindings pvalues quot ' +
        'rand rand-int range ratio? rational? rationalize re-find re-groups ' +
        're-matcher re-matches re-pattern re-seq read read-line read-string ' +
        'reduce ref ref-history-count ref-max-history ref-min-history ref-set ' +
        'refer refer-clojure release-pending-sends rem remove remove-method ' +
        'remove-ns remove-watch repeat repeatedly replace replicate require ' +
        'reset! reset-meta! resolve rest resultset-seq reverse reversible? rseq ' +
        'rsubseq second select-keys send send-off seq seq? seque sequence ' +
        'sequential? set set-validator! set? short short-array shorts ' +
        'shutdown-agents slurp some sort sort-by sorted-map sorted-map-by ' +
        'sorted-set sorted-set-by sorted? special-form-anchor special-symbol? ' +
        'split-at split-with str stream? string? struct struct-map subs subseq ' +
        'subvec supers swap! symbol symbol? sync syntax-symbol-anchor take ' +
        'take-last take-nth take-while test the-ns time to-array to-array-2d ' +
        'trampoline transient tree-seq true? type unchecked-add unchecked-dec ' +
        'unchecked-divide unchecked-inc unchecked-multiply unchecked-negate ' +
        'unchecked-remainder unchecked-subtract underive unquote ' +
        'unquote-splicing update-in update-proxy use val vals var-get var-set ' +
        'var? vary-meta vec vector vector? when when-first when-let when-not ' +
        'while with-bindings with-bindings* with-in-str with-loading-context ' +
        'with-local-vars with-meta with-open with-out-str with-precision xml-seq ' +
        'zero? zipmap');
    var keywords = ('throw try var ' +
        'def do fn if let loop monitor-enter monitor-exit new quote recur set!');
    var buildinConstants = ("true false nil");
    var keywordMapper = this.createKeywordMapper({
        "keyword": keywords,
        "constant.language": buildinConstants,
        "support.function": builtinFunctions
    }, "identifier", false, " ");
    this.$rules = {
        "start": [
            {
                token: "comment",
                regex: ";.*$"
            }, {
                token: "keyword",
                regex: "[\\(|\\)]"
            }, {
                token: "keyword",
                regex: "[\\'\\(]"
            }, {
                token: "keyword",
                regex: "[\\[|\\]]"
            }, {
                token: "string.regexp",
                regex: '#"',
                next: "regex"
            }, {
                token: "keyword",
                regex: "[\\{|\\}|\\#\\{|\\#\\}]"
            }, {
                token: "keyword",
                regex: '[\\&]'
            }, {
                token: "keyword",
                regex: '[\\#\\^\\{]'
            }, {
                token: "keyword",
                regex: '[\\%]'
            }, {
                token: "keyword",
                regex: '[@]'
            }, {
                token: "constant.numeric",
                regex: "0[xX][0-9a-fA-F]+\\b"
            }, {
                token: "constant.numeric",
                regex: "[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"
            }, {
                token: "constant.language",
                regex: '[!|\\$|%|&|\\*|\\-\\-|\\-|\\+\\+|\\+||=|!=|<=|>=|<>|<|>|!|&&]'
            }, {
                token: keywordMapper,
                regex: "[a-zA-Z_$][a-zA-Z0-9_$\\-]*\\b"
            }, {
                token: "string",
                regex: '"',
                next: "string"
            }, {
                token: "constant",
                regex: /:[^()\[\]{}'"\^%`,;\s]+/
            }
        ],
        "string": [
            {
                token: "constant.language.escape",
                regex: "\\\\.|\\\\$"
            }, {
                token: "string",
                regex: '"',
                next: "start"
            }, {
                defaultToken: "string"
            }
        ],
        "regex": [
            {
                token: "regexp.keyword.operator",
                regex: "\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"
            }, {
                token: "string.regexp",
                regex: '"',
                next: "start"
            }, {
                token: "constant.language.escape",
                regex: /\(\?[:=!]|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/
            }, {
                token: "constant.language.delimiter",
                regex: /\|/
            }, {
                token: "constant.language.escape",
                regex: /\[\^?/,
                next: "regex_character_class"
            }, {
                defaultToken: "string.regexp"
            }
        ],
        "regex_character_class": [
            {
                token: "regexp.charclass.keyword.operator",
                regex: "\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"
            }, {
                token: "constant.language.escape",
                regex: "]",
                next: "regex"
            }, {
                token: "constant.language.escape",
                regex: "-"
            }, {
                defaultToken: "string.regexp.charachterclass"
            }
        ]
    };
};
oop.inherits(ClojureHighlightRules, TextHighlightRules);
exports.ClojureHighlightRules = ClojureHighlightRules;

});

define("ace/mode/matching_parens_outdent",["require","exports","module","ace/range"], function(require, exports, module){"use strict";
var Range = require("../range").Range;
var MatchingParensOutdent = function () { };
(function () {
    this.checkOutdent = function (line, input) {
        if (!/^\s+$/.test(line))
            return false;
        return /^\s*\)/.test(input);
    };
    this.autoOutdent = function (doc, row) {
        var line = doc.getLine(row);
        var match = line.match(/^(\s*\))/);
        if (!match)
            return 0;
        var column = match[1].length;
        var openBracePos = doc.findMatchingBracket({ row: row, column: column });
        if (!openBracePos || openBracePos.row == row)
            return 0;
        var indent = this.$getIndent(doc.getLine(openBracePos.row));
        doc.replace(new Range(row, 0, row, column - 1), indent);
    };
    this.$getIndent = function (line) {
        var match = line.match(/^(\s+)/);
        if (match) {
            return match[1];
        }
        return "";
    };
}).call(MatchingParensOutdent.prototype);
exports.MatchingParensOutdent = MatchingParensOutdent;

});

define("ace/mode/clojure",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/clojure_highlight_rules","ace/mode/matching_parens_outdent"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var ClojureHighlightRules = require("./clojure_highlight_rules").ClojureHighlightRules;
var MatchingParensOutdent = require("./matching_parens_outdent").MatchingParensOutdent;
var Mode = function () {
    this.HighlightRules = ClojureHighlightRules;
    this.$outdent = new MatchingParensOutdent();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = ";";
    this.minorIndentFunctions = ["defn", "defn-", "defmacro", "def", "deftest", "testing"];
    this.$toIndent = function (str) {
        return str.split('').map(function (ch) {
            if (/\s/.exec(ch)) {
                return ch;
            }
            else {
                return ' ';
            }
        }).join('');
    };
    this.$calculateIndent = function (line, tab) {
        var baseIndent = this.$getIndent(line);
        var delta = 0;
        var isParen, ch;
        for (var i = line.length - 1; i >= 0; i--) {
            ch = line[i];
            if (ch === '(') {
                delta--;
                isParen = true;
            }
            else if (ch === '(' || ch === '[' || ch === '{') {
                delta--;
                isParen = false;
            }
            else if (ch === ')' || ch === ']' || ch === '}') {
                delta++;
            }
            if (delta < 0) {
                break;
            }
        }
        if (delta < 0 && isParen) {
            i += 1;
            var iBefore = i;
            var fn = '';
            while (true) {
                ch = line[i];
                if (ch === ' ' || ch === '\t') {
                    if (this.minorIndentFunctions.indexOf(fn) !== -1) {
                        return this.$toIndent(line.substring(0, iBefore - 1) + tab);
                    }
                    else {
                        return this.$toIndent(line.substring(0, i + 1));
                    }
                }
                else if (ch === undefined) {
                    return this.$toIndent(line.substring(0, iBefore - 1) + tab);
                }
                fn += line[i];
                i++;
            }
        }
        else if (delta < 0 && !isParen) {
            return this.$toIndent(line.substring(0, i + 1));
        }
        else if (delta > 0) {
            baseIndent = baseIndent.substring(0, baseIndent.length - tab.length);
            return baseIndent;
        }
        else {
            return baseIndent;
        }
    };
    this.getNextLineIndent = function (state, line, tab) {
        return this.$calculateIndent(line, tab);
    };
    this.checkOutdent = function (state, line, input) {
        return this.$outdent.checkOutdent(line, input);
    };
    this.autoOutdent = function (state, doc, row) {
        this.$outdent.autoOutdent(doc, row);
    };
    this.$id = "ace/mode/clojure";
    this.snippetFileId = "ace/snippets/clojure";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/cobol_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var CobolHighlightRules = function () {
    var keywords = "ACCEPT|MERGE|SUM|ADD||MESSAGE|TABLE|ADVANCING|MODE|TAPE|" +
        "AFTER|MULTIPLY|TEST|ALL|NEGATIVE|TEXT|ALPHABET|NEXT|THAN|" +
        "ALSO|NO|THEN|ALTERNATE|NOT|THROUGH|AND|NUMBER|THRU|ANY|OCCURS|" +
        "TIME|ARE|OF|TO|AREA|OFF|TOP||ASCENDING|OMITTED|TRUE|ASSIGN|ON|TYPE|AT|OPEN|" +
        "UNIT|AUTHOR|OR|UNTIL|BEFORE|OTHER|UP|BLANK|OUTPUT|USE|BLOCK|PAGE|USING|BOTTOM|" +
        "PERFORM|VALUE|BY|PIC|VALUES|CALL|PICTURE|WHEN|CANCEL|PLUS|WITH|CD|POINTER|WRITE|" +
        "CHARACTER|POSITION||ZERO|CLOSE|POSITIVE|ZEROS|COLUMN|PROCEDURE|ZEROES|COMMA|PROGRAM|" +
        "COMMON|PROGRAM-ID|COMMUNICATION|QUOTE|COMP|RANDOM|COMPUTE|READ|CONTAINS|RECEIVE|CONFIGURATION|" +
        "RECORD|CONTINUE|REDEFINES|CONTROL|REFERENCE|COPY|REMAINDER|COUNT|REPLACE|DATA|REPORT|DATE|RESERVE|" +
        "DAY|RESET|DELETE|RETURN|DESTINATION|REWIND|DISABLE|REWRITE|DISPLAY|RIGHT|DIVIDE|RUN|DOWN|SAME|" +
        "ELSE|SEARCH|ENABLE|SECTION|END|SELECT|ENVIRONMENT|SENTENCE|EQUAL|SET|ERROR|SIGN|EXIT|SEQUENTIAL|" +
        "EXTERNAL|SIZE|FLASE|SORT|FILE|SOURCE|LENGTH|SPACE|LESS|STANDARD|LIMIT|START|LINE|STOP|LOCK|STRING|LOW-VALUE|SUBTRACT";
    var builtinConstants = ("true|false|null");
    var builtinFunctions = ("count|min|max|avg|sum|rank|now|coalesce|main");
    var keywordMapper = this.createKeywordMapper({
        "support.function": builtinFunctions,
        "keyword": keywords,
        "constant.language": builtinConstants
    }, "identifier", true);
    this.$rules = {
        "start": [{
                token: "comment",
                regex: "\\*.*$"
            }, {
                token: "string",
                regex: '".*?"'
            }, {
                token: "string",
                regex: "'.*?'"
            }, {
                token: "constant.numeric",
                regex: "[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"
            }, {
                token: keywordMapper,
                regex: "[a-zA-Z_$][a-zA-Z0-9_$]*\\b"
            }, {
                token: "keyword.operator",
                regex: "\\+|\\-|\\/|\\/\\/|%|<@>|@>|<@|&|\\^|~|<|>|<=|=>|==|!=|<>|="
            }, {
                token: "paren.lparen",
                regex: "[\\(]"
            }, {
                token: "paren.rparen",
                regex: "[\\)]"
            }, {
                token: "text",
                regex: "\\s+"
            }]
    };
};
oop.inherits(CobolHighlightRules, TextHighlightRules);
exports.CobolHighlightRules = CobolHighlightRules;

});

define("ace/mode/cobol",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/cobol_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var CobolHighlightRules = require("./cobol_highlight_rules").CobolHighlightRules;
var Mode = function () {
    this.HighlightRules = CobolHighlightRules;
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "*";
    this.$id = "ace/mode/cobol";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/coffee_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
oop.inherits(CoffeeHighlightRules, TextHighlightRules);
function CoffeeHighlightRules() {
    var identifier = "[$A-Za-z_\\x7f-\\uffff][$\\w\\x7f-\\uffff]*";
    var keywords = ("this|throw|then|try|typeof|super|switch|return|break|by|continue|" +
        "catch|class|in|instanceof|is|isnt|if|else|extends|for|own|" +
        "finally|function|while|when|new|no|not|delete|debugger|do|loop|of|off|" +
        "or|on|unless|until|and|yes|yield|export|import|default");
    var langConstant = ("true|false|null|undefined|NaN|Infinity");
    var illegal = ("case|const|function|var|void|with|enum|implements|" +
        "interface|let|package|private|protected|public|static");
    var supportClass = ("Array|Boolean|Date|Function|Number|Object|RegExp|ReferenceError|String|" +
        "Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|" +
        "SyntaxError|TypeError|URIError|" +
        "ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|" +
        "Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray");
    var supportFunction = ("Math|JSON|isNaN|isFinite|parseInt|parseFloat|encodeURI|" +
        "encodeURIComponent|decodeURI|decodeURIComponent|String|");
    var variableLanguage = ("window|arguments|prototype|document");
    var keywordMapper = this.createKeywordMapper({
        "keyword": keywords,
        "constant.language": langConstant,
        "invalid.illegal": illegal,
        "language.support.class": supportClass,
        "language.support.function": supportFunction,
        "variable.language": variableLanguage
    }, "identifier");
    var functionRule = {
        token: ["paren.lparen", "variable.parameter", "paren.rparen", "text", "storage.type"],
        regex: /(?:(\()((?:"[^")]*?"|'[^')]*?'|\/[^\/)]*?\/|[^()"'\/])*?)(\))(\s*))?([\-=]>)/.source
    };
    var stringEscape = /\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|[0-2][0-7]{0,2}|3[0-6][0-7]?|37[0-7]?|[4-7][0-7]?|.)/;
    this.$rules = {
        start: [
            {
                token: "constant.numeric",
                regex: "(?:0x[\\da-fA-F]+|(?:\\d+(?:\\.\\d+)?|\\.\\d+)(?:[eE][+-]?\\d+)?)"
            }, {
                stateName: "qdoc",
                token: "string", regex: "'''", next: [
                    { token: "string", regex: "'''", next: "start" },
                    { token: "constant.language.escape", regex: stringEscape },
                    { defaultToken: "string" }
                ]
            }, {
                stateName: "qqdoc",
                token: "string",
                regex: '"""',
                next: [
                    { token: "string", regex: '"""', next: "start" },
                    { token: "paren.string", regex: '#{', push: "start" },
                    { token: "constant.language.escape", regex: stringEscape },
                    { defaultToken: "string" }
                ]
            }, {
                stateName: "qstring",
                token: "string", regex: "'", next: [
                    { token: "string", regex: "'", next: "start" },
                    { token: "constant.language.escape", regex: stringEscape },
                    { defaultToken: "string" }
                ]
            }, {
                stateName: "qqstring",
                token: "string.start", regex: '"', next: [
                    { token: "string.end", regex: '"', next: "start" },
                    { token: "paren.string", regex: '#{', push: "start" },
                    { token: "constant.language.escape", regex: stringEscape },
                    { defaultToken: "string" }
                ]
            }, {
                stateName: "js",
                token: "string", regex: "`", next: [
                    { token: "string", regex: "`", next: "start" },
                    { token: "constant.language.escape", regex: stringEscape },
                    { defaultToken: "string" }
                ]
            }, {
                regex: "[{}]", onMatch: function (val, state, stack) {
                    this.next = "";
                    if (val == "{" && stack.length) {
                        stack.unshift("start", state);
                        return "paren";
                    }
                    if (val == "}" && stack.length) {
                        stack.shift();
                        this.next = stack.shift() || "";
                        if (this.next.indexOf("string") != -1)
                            return "paren.string";
                    }
                    return "paren";
                }
            }, {
                token: "string.regex",
                regex: "///",
                next: "heregex"
            }, {
                token: "string.regex",
                regex: /(?:\/(?![\s=])[^[\/\n\\]*(?:(?:\\[\s\S]|\[[^\]\n\\]*(?:\\[\s\S][^\]\n\\]*)*])[^[\/\n\\]*)*\/)(?:[imgy]{0,4})(?!\w)/
            }, {
                token: "comment",
                regex: "###(?!#)",
                next: "comment"
            }, {
                token: "comment",
                regex: "#.*"
            }, {
                token: ["punctuation.operator", "text", "identifier"],
                regex: "(\\.)(\\s*)(" + illegal + ")"
            }, {
                token: "punctuation.operator",
                regex: "\\.{1,3}"
            }, {
                token: ["keyword", "text", "language.support.class",
                    "text", "keyword", "text", "language.support.class"],
                regex: "(class)(\\s+)(" + identifier + ")(?:(\\s+)(extends)(\\s+)(" + identifier + "))?"
            }, {
                token: ["entity.name.function", "text", "keyword.operator", "text"].concat(functionRule.token),
                regex: "(" + identifier + ")(\\s*)([=:])(\\s*)" + functionRule.regex
            },
            functionRule,
            {
                token: "variable",
                regex: "@(?:" + identifier + ")?"
            }, {
                token: keywordMapper,
                regex: identifier
            }, {
                token: "punctuation.operator",
                regex: "\\,|\\."
            }, {
                token: "storage.type",
                regex: "[\\-=]>"
            }, {
                token: "keyword.operator",
                regex: "(?:[-+*/%<>&|^!?=]=|>>>=?|\\-\\-|\\+\\+|::|&&=|\\|\\|=|<<=|>>=|\\?\\.|\\.{2,3}|[!*+-=><])"
            }, {
                token: "paren.lparen",
                regex: "[({[]"
            }, {
                token: "paren.rparen",
                regex: "[\\]})]"
            }, {
                token: "text",
                regex: "\\s+"
            }
        ],
        heregex: [{
                token: "string.regex",
                regex: '.*?///[imgy]{0,4}',
                next: "start"
            }, {
                token: "comment.regex",
                regex: "\\s+(?:#.*)?"
            }, {
                token: "string.regex",
                regex: "\\S+"
            }],
        comment: [{
                token: "comment",
                regex: '###',
                next: "start"
            }, {
                defaultToken: "comment"
            }]
    };
    this.normalizeRules();
}
exports.CoffeeHighlightRules = CoffeeHighlightRules;

});

define("ace/worker/worker_client",["require","exports","module","ace/lib/oop","ace/lib/net","ace/lib/event_emitter","ace/config"], function(require, exports, module) {
"use strict";

var oop = require("../lib/oop");
var net = require("../lib/net");
var EventEmitter = require("../lib/event_emitter").EventEmitter;
var config = require("../config");

function $workerBlob(workerUrl) {
    var script = "importScripts('" + net.qualifyURL(workerUrl) + "');";
    try {
        return new Blob([script], {"type": "application/javascript"});
    } catch (e) { // Backwards-compatibility
        var BlobBuilder = window.BlobBuilder || window.WebKitBlobBuilder || window.MozBlobBuilder;
        var blobBuilder = new BlobBuilder();
        blobBuilder.append(script);
        return blobBuilder.getBlob("application/javascript");
    }
}

function createWorker(workerUrl) {
    if (typeof Worker == "undefined")
        return { postMessage: function() {}, terminate: function() {} };
    if (config.get("loadWorkerFromBlob")) {
        var blob = $workerBlob(workerUrl);
        var URL = window.URL || window.webkitURL;
        var blobURL = URL.createObjectURL(blob);
        return new Worker(blobURL);
    }
    return new Worker(workerUrl);
}

var WorkerClient = function(worker) {
    if (!worker.postMessage)
        worker = this.$createWorkerFromOldConfig.apply(this, arguments);

    this.$worker = worker;
    this.$sendDeltaQueue = this.$sendDeltaQueue.bind(this);
    this.changeListener = this.changeListener.bind(this);
    this.onMessage = this.onMessage.bind(this);

    this.callbackId = 1;
    this.callbacks = {};

    this.$worker.onmessage = this.onMessage;
};

(function(){

    oop.implement(this, EventEmitter);

    this.$createWorkerFromOldConfig = function(topLevelNamespaces, mod, classname, workerUrl, importScripts) {
        if (require.nameToUrl && !require.toUrl)
            require.toUrl = require.nameToUrl;

        if (config.get("packaged") || !require.toUrl) {
            workerUrl = workerUrl || config.moduleUrl(mod, "worker");
        } else {
            var normalizePath = this.$normalizePath;
            workerUrl = workerUrl || normalizePath(require.toUrl("ace/worker/worker.js", null, "_"));

            var tlns = {};
            topLevelNamespaces.forEach(function(ns) {
                tlns[ns] = normalizePath(require.toUrl(ns, null, "_").replace(/(\.js)?(\?.*)?$/, ""));
            });
        }

        this.$worker = createWorker(workerUrl);
        if (importScripts) {
            this.send("importScripts", importScripts);
        }
        this.$worker.postMessage({
            init : true,
            tlns : tlns,
            module : mod,
            classname : classname
        });
        return this.$worker;
    };

    this.onMessage = function(e) {
        var msg = e.data;
        switch (msg.type) {
            case "event":
                this._signal(msg.name, {data: msg.data});
                break;
            case "call":
                var callback = this.callbacks[msg.id];
                if (callback) {
                    callback(msg.data);
                    delete this.callbacks[msg.id];
                }
                break;
            case "error":
                this.reportError(msg.data);
                break;
            case "log":
                window.console && console.log && console.log.apply(console, msg.data);
                break;
        }
    };
    
    this.reportError = function(err) {
        window.console && console.error && console.error(err);
    };

    this.$normalizePath = function(path) {
        return net.qualifyURL(path);
    };

    this.terminate = function() {
        this._signal("terminate", {});
        this.deltaQueue = null;
        this.$worker.terminate();
        this.$worker.onerror = function(e) {
            e.preventDefault();
        };
        this.$worker = null;
        if (this.$doc)
            this.$doc.off("change", this.changeListener);
        this.$doc = null;
    };

    this.send = function(cmd, args) {
        this.$worker.postMessage({command: cmd, args: args});
    };

    this.call = function(cmd, args, callback) {
        if (callback) {
            var id = this.callbackId++;
            this.callbacks[id] = callback;
            args.push(id);
        }
        this.send(cmd, args);
    };

    this.emit = function(event, data) {
        try {
            if (data.data && data.data.err)
                data.data.err = {message: data.data.err.message, stack: data.data.err.stack, code: data.data.err.code};
                this.$worker && this.$worker.postMessage({event: event, data: {data: data.data}});
        }
        catch(ex) {
            console.error(ex.stack);
        }
    };

    this.attachToDocument = function(doc) {
        if (this.$doc)
            this.terminate();

        this.$doc = doc;
        this.call("setValue", [doc.getValue()]);
        doc.on("change", this.changeListener, true);
    };

    this.changeListener = function(delta) {
        if (!this.deltaQueue) {
            this.deltaQueue = [];
            setTimeout(this.$sendDeltaQueue, 0);
        }
        if (delta.action == "insert")
            this.deltaQueue.push(delta.start, delta.lines);
        else
            this.deltaQueue.push(delta.start, delta.end);
    };

    this.$sendDeltaQueue = function() {
        var q = this.deltaQueue;
        if (!q) return;
        this.deltaQueue = null;
        if (q.length > 50 && q.length > this.$doc.getLength() >> 1) {
            this.call("setValue", [this.$doc.getValue()]);
        } else
            this.emit("change", {data: q});
    };

}).call(WorkerClient.prototype);


var UIWorkerClient = function(topLevelNamespaces, mod, classname) {
    var main = null;
    var emitSync = false;
    var sender = Object.create(EventEmitter);

    var messageBuffer = [];
    var workerClient = new WorkerClient({
        messageBuffer: messageBuffer,
        terminate: function() {},
        postMessage: function(e) {
            messageBuffer.push(e);
            if (!main) return;
            if (emitSync)
                setTimeout(processNext);
            else
                processNext();
        }
    });

    workerClient.setEmitSync = function(val) { emitSync = val; };

    var processNext = function() {
        var msg = messageBuffer.shift();
        if (msg.command)
            main[msg.command].apply(main, msg.args);
        else if (msg.event)
            sender._signal(msg.event, msg.data);
    };

    sender.postMessage = function(msg) {
        workerClient.onMessage({data: msg});
    };
    sender.callback = function(data, callbackId) {
        this.postMessage({type: "call", id: callbackId, data: data});
    };
    sender.emit = function(name, data) {
        this.postMessage({type: "event", name: name, data: data});
    };

    config.loadModule(["worker", mod], function(Main) {
        main = new Main[classname](sender);
        while (messageBuffer.length)
            processNext();
    });

    return workerClient;
};

exports.UIWorkerClient = UIWorkerClient;
exports.WorkerClient = WorkerClient;
exports.createWorker = createWorker;


});

define("ace/mode/coffee",["require","exports","module","ace/mode/coffee_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/coffee","ace/range","ace/mode/text","ace/worker/worker_client","ace/lib/oop"], function(require, exports, module){"use strict";
var Rules = require("./coffee_highlight_rules").CoffeeHighlightRules;
var Outdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var FoldMode = require("./folding/coffee").FoldMode;
var Range = require("../range").Range;
var TextMode = require("./text").Mode;
var WorkerClient = require("../worker/worker_client").WorkerClient;
var oop = require("../lib/oop");
function Mode() {
    this.HighlightRules = Rules;
    this.$outdent = new Outdent();
    this.foldingRules = new FoldMode();
}
oop.inherits(Mode, TextMode);
(function () {
    var indenter = /(?:[({[=:]|[-=]>|\b(?:else|try|(?:swi|ca)tch(?:\s+[$A-Za-z_\x7f-\uffff][$\w\x7f-\uffff]*)?|finally))\s*$|^\s*(else\b\s*)?(?:if|for|while|loop)\b(?!.*\bthen\b)/;
    this.lineCommentStart = "#";
    this.blockComment = { start: "###", end: "###" };
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        var tokens = this.getTokenizer().getLineTokens(line, state).tokens;
        if (!(tokens.length && tokens[tokens.length - 1].type === 'comment') &&
            state === 'start' && indenter.test(line))
            indent += tab;
        return indent;
    };
    this.checkOutdent = function (state, line, input) {
        return this.$outdent.checkOutdent(line, input);
    };
    this.autoOutdent = function (state, doc, row) {
        this.$outdent.autoOutdent(doc, row);
    };
    this.createWorker = function (session) {
        var worker = new WorkerClient(["ace"], "ace/mode/coffee_worker", "Worker");
        worker.attachToDocument(session.getDocument());
        worker.on("annotate", function (e) {
            session.setAnnotations(e.data);
        });
        worker.on("terminate", function () {
            session.clearAnnotations();
        });
        return worker;
    };
    this.$id = "ace/mode/coffee";
    this.snippetFileId = "ace/snippets/coffee";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/jsdoc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var JsDocCommentHighlightRules = function () {
    this.$rules = {
        "start": [
            {
                token: ["comment.doc.tag", "comment.doc.text", "lparen.doc"],
                regex: "(@(?:param|member|typedef|property|namespace|var|const|callback))(\\s*)({)",
                push: [
                    {
                        token: "lparen.doc",
                        regex: "{",
                        push: [
                            {
                                include: "doc-syntax"
                            }, {
                                token: "rparen.doc",
                                regex: "}|(?=$)",
                                next: "pop"
                            }
                        ]
                    }, {
                        token: ["rparen.doc", "text.doc", "variable.parameter.doc", "lparen.doc", "variable.parameter.doc", "rparen.doc"],
                        regex: /(})(\s*)(?:([\w=:\/\.]+)|(?:(\[)([\w=:\/\.]+)(\])))/,
                        next: "pop"
                    }, {
                        token: "rparen.doc",
                        regex: "}|(?=$)",
                        next: "pop"
                    }, {
                        include: "doc-syntax"
                    }, {
                        defaultToken: "text.doc"
                    }
                ]
            }, {
                token: ["comment.doc.tag", "text.doc", "lparen.doc"],
                regex: "(@(?:returns?|yields|type|this|suppress|public|protected|private|package|modifies|"
                    + "implements|external|exception|throws|enum|define|extends))(\\s*)({)",
                push: [
                    {
                        token: "lparen.doc",
                        regex: "{",
                        push: [
                            {
                                include: "doc-syntax"
                            }, {
                                token: "rparen.doc",
                                regex: "}|(?=$)",
                                next: "pop"
                            }
                        ]
                    }, {
                        token: "rparen.doc",
                        regex: "}|(?=$)",
                        next: "pop"
                    }, {
                        include: "doc-syntax"
                    }, {
                        defaultToken: "text.doc"
                    }
                ]
            }, {
                token: ["comment.doc.tag", "text.doc", "variable.parameter.doc"],
                regex: "(@(?:alias|memberof|instance|module|name|lends|namespace|external|this|template|"
                    + "requires|param|implements|function|extends|typedef|mixes|constructor|var|"
                    + "memberof\\!|event|listens|exports|class|constructs|interface|emits|fires|"
                    + "throws|const|callback|borrows|augments))(\\s+)(\\w[\\w#\.:\/~\"\\-]*)?"
            }, {
                token: ["comment.doc.tag", "text.doc", "variable.parameter.doc"],
                regex: "(@method)(\\s+)(\\w[\\w\.\\(\\)]*)"
            }, {
                token: "comment.doc.tag",
                regex: "@access\\s+(?:private|public|protected)"
            }, {
                token: "comment.doc.tag",
                regex: "@kind\\s+(?:class|constant|event|external|file|function|member|mixin|module|namespace|typedef)"
            }, {
                token: "comment.doc.tag",
                regex: "@\\w+(?=\\s|$)"
            },
            JsDocCommentHighlightRules.getTagRule(),
            {
                defaultToken: "comment.doc",
                caseInsensitive: true
            }
        ],
        "doc-syntax": [{
                token: "operator.doc",
                regex: /[|:]/
            }, {
                token: "paren.doc",
                regex: /[\[\]]/
            }]
    };
    this.normalizeRules();
};
oop.inherits(JsDocCommentHighlightRules, TextHighlightRules);
JsDocCommentHighlightRules.getTagRule = function (start) {
    return {
        token: "comment.doc.tag.storage.type",
        regex: "\\b(?:TODO|FIXME|XXX|HACK)\\b"
    };
};
JsDocCommentHighlightRules.getStartRule = function (start) {
    return {
        token: "comment.doc",
        regex: "\\/\\*(?=\\*)",
        next: start
    };
};
JsDocCommentHighlightRules.getEndRule = function (start) {
    return {
        token: "comment.doc",
        regex: "\\*\\/",
        next: start
    };
};
exports.JsDocCommentHighlightRules = JsDocCommentHighlightRules;

});

define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/jsdoc_comment_highlight_rules","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var DocCommentHighlightRules = require("./jsdoc_comment_highlight_rules").JsDocCommentHighlightRules;
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var identifierRe = "[a-zA-Z\\$_\u00a1-\uffff][a-zA-Z\\d\\$_\u00a1-\uffff]*";
var JavaScriptHighlightRules = function (options) {
    var keywordMapper = this.createKeywordMapper({
        "variable.language": "Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|Symbol|" + // Constructors
            "Namespace|QName|XML|XMLList|" + // E4X
            "ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|" +
            "Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|" +
            "Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|" + // Errors
            "SyntaxError|TypeError|URIError|" +
            "decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|" + // Non-constructor functions
            "isNaN|parseFloat|parseInt|" +
            "JSON|Math|" + // Other
            "this|arguments|prototype|window|document",
        "keyword": "const|yield|import|get|set|async|await|" +
            "break|case|catch|continue|default|delete|do|else|finally|for|function|" +
            "if|in|of|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|debugger|" +
            "__parent__|__count__|escape|unescape|with|__proto__|" +
            "class|enum|extends|super|export|implements|private|public|interface|package|protected|static|constructor",
        "storage.type": "const|let|var|function",
        "constant.language": "null|Infinity|NaN|undefined",
        "support.function": "alert",
        "constant.language.boolean": "true|false"
    }, "identifier");
    var kwBeforeRe = "case|do|else|finally|in|instanceof|return|throw|try|typeof|yield|void";
    var escapedRe = "\\\\(?:x[0-9a-fA-F]{2}|" + // hex
        "u[0-9a-fA-F]{4}|" + // unicode
        "u{[0-9a-fA-F]{1,6}}|" + // es6 unicode
        "[0-2][0-7]{0,2}|" + // oct
        "3[0-7][0-7]?|" + // oct
        "[4-7][0-7]?|" + //oct
        ".)";
    this.$rules = {
        "no_regex": [
            DocCommentHighlightRules.getStartRule("doc-start"),
            comments("no_regex"),
            {
                token: "string",
                regex: "'(?=.)",
                next: "qstring"
            }, {
                token: "string",
                regex: '"(?=.)',
                next: "qqstring"
            }, {
                token: "constant.numeric",
                regex: /0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/
            }, {
                token: "constant.numeric",
                regex: /(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/
            }, {
                token: [
                    "storage.type", "punctuation.operator", "support.function",
                    "punctuation.operator", "entity.name.function", "text", "keyword.operator"
                ],
                regex: "(" + identifierRe + ")(\\.)(prototype)(\\.)(" + identifierRe + ")(\\s*)(=)",
                next: "function_arguments"
            }, {
                token: [
                    "storage.type", "punctuation.operator", "entity.name.function", "text",
                    "keyword.operator", "text", "storage.type", "text", "paren.lparen"
                ],
                regex: "(" + identifierRe + ")(\\.)(" + identifierRe + ")(\\s*)(=)(\\s*)(function\\*?)(\\s*)(\\()",
                next: "function_arguments"
            }, {
                token: [
                    "entity.name.function", "text", "keyword.operator", "text", "storage.type",
                    "text", "paren.lparen"
                ],
                regex: "(" + identifierRe + ")(\\s*)(=)(\\s*)(function\\*?)(\\s*)(\\()",
                next: "function_arguments"
            }, {
                token: [
                    "storage.type", "punctuation.operator", "entity.name.function", "text",
                    "keyword.operator", "text",
                    "storage.type", "text", "entity.name.function", "text", "paren.lparen"
                ],
                regex: "(" + identifierRe + ")(\\.)(" + identifierRe + ")(\\s*)(=)(\\s*)(function\\*?)(\\s+)(\\w+)(\\s*)(\\()",
                next: "function_arguments"
            }, {
                token: [
                    "storage.type", "text", "entity.name.function", "text", "paren.lparen"
                ],
                regex: "(function\\*?)(\\s+)(" + identifierRe + ")(\\s*)(\\()",
                next: "function_arguments"
            }, {
                token: [
                    "entity.name.function", "text", "punctuation.operator",
                    "text", "storage.type", "text", "paren.lparen"
                ],
                regex: "(" + identifierRe + ")(\\s*)(:)(\\s*)(function\\*?)(\\s*)(\\()",
                next: "function_arguments"
            }, {
                token: [
                    "text", "text", "storage.type", "text", "paren.lparen"
                ],
                regex: "(:)(\\s*)(function\\*?)(\\s*)(\\()",
                next: "function_arguments"
            }, {
                token: "keyword",
                regex: "from(?=\\s*('|\"))"
            }, {
                token: "keyword",
                regex: "(?:" + kwBeforeRe + ")\\b",
                next: "start"
            }, {
                token: "support.constant",
                regex: /that\b/
            }, {
                token: ["storage.type", "punctuation.operator", "support.function.firebug"],
                regex: /(console)(\.)(warn|info|log|error|time|trace|timeEnd|assert)\b/
            }, {
                token: keywordMapper,
                regex: identifierRe
            }, {
                token: "punctuation.operator",
                regex: /[.](?![.])/,
                next: "property"
            }, {
                token: "storage.type",
                regex: /=>/,
                next: "start"
            }, {
                token: "keyword.operator",
                regex: /--|\+\+|\.{3}|===|==|=|!=|!==|<+=?|>+=?|!|&&|\|\||\?:|[!$%&*+\-~\/^]=?/,
                next: "start"
            }, {
                token: "punctuation.operator",
                regex: /[?:,;.]/,
                next: "start"
            }, {
                token: "paren.lparen",
                regex: /[\[({]/,
                next: "start"
            }, {
                token: "paren.rparen",
                regex: /[\])}]/
            }, {
                token: "comment",
                regex: /^#!.*$/
            }
        ],
        property: [{
                token: "text",
                regex: "\\s+"
            }, {
                token: [
                    "storage.type", "punctuation.operator", "entity.name.function", "text",
                    "keyword.operator", "text",
                    "storage.type", "text", "entity.name.function", "text", "paren.lparen"
                ],
                regex: "(" + identifierRe + ")(\\.)(" + identifierRe + ")(\\s*)(=)(\\s*)(function\\*?)(?:(\\s+)(\\w+))?(\\s*)(\\()",
                next: "function_arguments"
            }, {
                token: "punctuation.operator",
                regex: /[.](?![.])/
            }, {
                token: "support.function",
                regex: /(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:op|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|lter|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward|rEach)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/
            }, {
                token: "support.function.dom",
                regex: /(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName|ClassName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/
            }, {
                token: "support.constant",
                regex: /(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/
            }, {
                token: "identifier",
                regex: identifierRe
            }, {
                regex: "",
                token: "empty",
                next: "no_regex"
            }
        ],
        "start": [
            DocCommentHighlightRules.getStartRule("doc-start"),
            comments("start"),
            {
                token: "string.regexp",
                regex: "\\/",
                next: "regex"
            }, {
                token: "text",
                regex: "\\s+|^$",
                next: "start"
            }, {
                token: "empty",
                regex: "",
                next: "no_regex"
            }
        ],
        "regex": [
            {
                token: "regexp.keyword.operator",
                regex: "\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"
            }, {
                token: "string.regexp",
                regex: "/[sxngimy]*",
                next: "no_regex"
            }, {
                token: "invalid",
                regex: /\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/
            }, {
                token: "constant.language.escape",
                regex: /\(\?[:=!]|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/
            }, {
                token: "constant.language.delimiter",
                regex: /\|/
            }, {
                token: "constant.language.escape",
                regex: /\[\^?/,
                next: "regex_character_class"
            }, {
                token: "empty",
                regex: "$",
                next: "no_regex"
            }, {
                defaultToken: "string.regexp"
            }
        ],
        "regex_character_class": [
            {
                token: "regexp.charclass.keyword.operator",
                regex: "\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"
            }, {
                token: "constant.language.escape",
                regex: "]",
                next: "regex"
            }, {
                token: "constant.language.escape",
                regex: "-"
            }, {
                token: "empty",
                regex: "$",
                next: "no_regex"
            }, {
                defaultToken: "string.regexp.charachterclass"
            }
        ],
        "default_parameter": [
            {
                token: "string",
                regex: "'(?=.)",
                push: [
                    {
                        token: "string",
                        regex: "'|$",
                        next: "pop"
                    }, {
                        include: "qstring"
                    }
                ]
            }, {
                token: "string",
                regex: '"(?=.)',
                push: [
                    {
                        token: "string",
                        regex: '"|$',
                        next: "pop"
                    }, {
                        include: "qqstring"
                    }
                ]
            }, {
                token: "constant.language",
                regex: "null|Infinity|NaN|undefined"
            }, {
                token: "constant.numeric",
                regex: /0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/
            }, {
                token: "constant.numeric",
                regex: /(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/
            }, {
                token: "punctuation.operator",
                regex: ",",
                next: "function_arguments"
            }, {
                token: "text",
                regex: "\\s+"
            }, {
                token: "punctuation.operator",
                regex: "$"
            }, {
                token: "empty",
                regex: "",
                next: "no_regex"
            }
        ],
        "function_arguments": [
            comments("function_arguments"),
            {
                token: "variable.parameter",
                regex: identifierRe
            }, {
                token: "punctuation.operator",
                regex: ","
            }, {
                token: "text",
                regex: "\\s+"
            }, {
                token: "punctuation.operator",
                regex: "$"
            }, {
                token: "empty",
                regex: "",
                next: "no_regex"
            }
        ],
        "qqstring": [
            {
                token: "constant.language.escape",
                regex: escapedRe
            }, {
                token: "string",
                regex: "\\\\$",
                consumeLineEnd: true
            }, {
                token: "string",
                regex: '"|$',
                next: "no_regex"
            }, {
                defaultToken: "string"
            }
        ],
        "qstring": [
            {
                token: "constant.language.escape",
                regex: escapedRe
            }, {
                token: "string",
                regex: "\\\\$",
                consumeLineEnd: true
            }, {
                token: "string",
                regex: "'|$",
                next: "no_regex"
            }, {
                defaultToken: "string"
            }
        ]
    };
    if (!options || !options.noES6) {
        this.$rules.no_regex.unshift({
            regex: "[{}]", onMatch: function (val, state, stack) {
                this.next = val == "{" ? this.nextState : "";
                if (val == "{" && stack.length) {
                    stack.unshift("start", state);
                }
                else if (val == "}" && stack.length) {
                    stack.shift();
                    this.next = stack.shift();
                    if (this.next.indexOf("string") != -1 || this.next.indexOf("jsx") != -1)
                        return "paren.quasi.end";
                }
                return val == "{" ? "paren.lparen" : "paren.rparen";
            },
            nextState: "start"
        }, {
            token: "string.quasi.start",
            regex: /`/,
            push: [{
                    token: "constant.language.escape",
                    regex: escapedRe
                }, {
                    token: "paren.quasi.start",
                    regex: /\${/,
                    push: "start"
                }, {
                    token: "string.quasi.end",
                    regex: /`/,
                    next: "pop"
                }, {
                    defaultToken: "string.quasi"
                }]
        }, {
            token: ["variable.parameter", "text"],
            regex: "(" + identifierRe + ")(\\s*)(?=\\=>)"
        }, {
            token: "paren.lparen",
            regex: "(\\()(?=.+\\s*=>)",
            next: "function_arguments"
        }, {
            token: "variable.language",
            regex: "(?:(?:(?:Weak)?(?:Set|Map))|Promise)\\b"
        });
        this.$rules["function_arguments"].unshift({
            token: "keyword.operator",
            regex: "=",
            next: "default_parameter"
        }, {
            token: "keyword.operator",
            regex: "\\.{3}"
        });
        this.$rules["property"].unshift({
            token: "support.function",
            regex: "(findIndex|repeat|startsWith|endsWith|includes|isSafeInteger|trunc|cbrt|log2|log10|sign|then|catch|"
                + "finally|resolve|reject|race|any|all|allSettled|keys|entries|isInteger)\\b(?=\\()"
        }, {
            token: "constant.language",
            regex: "(?:MAX_SAFE_INTEGER|MIN_SAFE_INTEGER|EPSILON)\\b"
        });
        if (!options || options.jsx != false)
            JSX.call(this);
    }
    this.embedRules(DocCommentHighlightRules, "doc-", [DocCommentHighlightRules.getEndRule("no_regex")]);
    this.normalizeRules();
};
oop.inherits(JavaScriptHighlightRules, TextHighlightRules);
function JSX() {
    var tagRegex = identifierRe.replace("\\d", "\\d\\-");
    var jsxTag = {
        onMatch: function (val, state, stack) {
            var offset = val.charAt(1) == "/" ? 2 : 1;
            if (offset == 1) {
                if (state != this.nextState)
                    stack.unshift(this.next, this.nextState, 0);
                else
                    stack.unshift(this.next);
                stack[2]++;
            }
            else if (offset == 2) {
                if (state == this.nextState) {
                    stack[1]--;
                    if (!stack[1] || stack[1] < 0) {
                        stack.shift();
                        stack.shift();
                    }
                }
            }
            return [{
                    type: "meta.tag.punctuation." + (offset == 1 ? "" : "end-") + "tag-open.xml",
                    value: val.slice(0, offset)
                }, {
                    type: "meta.tag.tag-name.xml",
                    value: val.substr(offset)
                }];
        },
        regex: "</?" + tagRegex + "",
        next: "jsxAttributes",
        nextState: "jsx"
    };
    this.$rules.start.unshift(jsxTag);
    var jsxJsRule = {
        regex: "{",
        token: "paren.quasi.start",
        push: "start"
    };
    this.$rules.jsx = [
        jsxJsRule,
        jsxTag,
        { include: "reference" },
        { defaultToken: "string" }
    ];
    this.$rules.jsxAttributes = [{
            token: "meta.tag.punctuation.tag-close.xml",
            regex: "/?>",
            onMatch: function (value, currentState, stack) {
                if (currentState == stack[0])
                    stack.shift();
                if (value.length == 2) {
                    if (stack[0] == this.nextState)
                        stack[1]--;
                    if (!stack[1] || stack[1] < 0) {
                        stack.splice(0, 2);
                    }
                }
                this.next = stack[0] || "start";
                return [{ type: this.token, value: value }];
            },
            nextState: "jsx"
        },
        jsxJsRule,
        comments("jsxAttributes"),
        {
            token: "entity.other.attribute-name.xml",
            regex: tagRegex
        }, {
            token: "keyword.operator.attribute-equals.xml",
            regex: "="
        }, {
            token: "text.tag-whitespace.xml",
            regex: "\\s+"
        }, {
            token: "string.attribute-value.xml",
            regex: "'",
            stateName: "jsx_attr_q",
            push: [
                { token: "string.attribute-value.xml", regex: "'", next: "pop" },
                { include: "reference" },
                { defaultToken: "string.attribute-value.xml" }
            ]
        }, {
            token: "string.attribute-value.xml",
            regex: '"',
            stateName: "jsx_attr_qq",
            push: [
                { token: "string.attribute-value.xml", regex: '"', next: "pop" },
                { include: "reference" },
                { defaultToken: "string.attribute-value.xml" }
            ]
        },
        jsxTag
    ];
    this.$rules.reference = [{
            token: "constant.language.escape.reference.xml",
            regex: "(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"
        }];
}
function comments(next) {
    return [
        {
            token: "comment",
            regex: /\/\*/,
            next: [
                DocCommentHighlightRules.getTagRule(),
                { token: "comment", regex: "\\*\\/", next: next || "pop" },
                { defaultToken: "comment", caseInsensitive: true }
            ]
        }, {
            token: "comment",
            regex: "\\/\\/",
            next: [
                DocCommentHighlightRules.getTagRule(),
                { token: "comment", regex: "$|^", next: next || "pop" },
                { defaultToken: "comment", caseInsensitive: true }
            ]
        }
    ];
}
exports.JavaScriptHighlightRules = JavaScriptHighlightRules;

});

define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var JavaScriptHighlightRules = require("./javascript_highlight_rules").JavaScriptHighlightRules;
var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var WorkerClient = require("../worker/worker_client").WorkerClient;
var CstyleBehaviour = require("./behaviour/cstyle").CstyleBehaviour;
var CStyleFoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = JavaScriptHighlightRules;
    this.$outdent = new MatchingBraceOutdent();
    this.$behaviour = new CstyleBehaviour();
    this.foldingRules = new CStyleFoldMode();
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "//";
    this.blockComment = { start: "/*", end: "*/" };
    this.$quotes = { '"': '"', "'": "'", "`": "`" };
    this.$pairQuotesAfter = {
        "`": /\w/
    };
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        var tokenizedLine = this.getTokenizer().getLineTokens(line, state);
        var tokens = tokenizedLine.tokens;
        var endState = tokenizedLine.state;
        if (tokens.length && tokens[tokens.length - 1].type == "comment") {
            return indent;
        }
        if (state == "start" || state == "no_regex") {
            var match = line.match(/^.*(?:\bcase\b.*:|[\{\(\[])\s*$/);
            if (match) {
                indent += tab;
            }
        }
        else if (state == "doc-start") {
            if (endState == "start" || endState == "no_regex") {
                return "";
            }
            var match = line.match(/^\s*(\/?)\*/);
            if (match) {
                if (match[1]) {
                    indent += " ";
                }
                indent += "* ";
            }
        }
        return indent;
    };
    this.checkOutdent = function (state, line, input) {
        return this.$outdent.checkOutdent(line, input);
    };
    this.autoOutdent = function (state, doc, row) {
        this.$outdent.autoOutdent(doc, row);
    };
    this.createWorker = function (session) {
        var worker = new WorkerClient(["ace"], "ace/mode/javascript_worker", "JavaScriptWorker");
        worker.attachToDocument(session.getDocument());
        worker.on("annotate", function (results) {
            session.setAnnotations(results.data);
        });
        worker.on("terminate", function () {
            session.clearAnnotations();
        });
        return worker;
    };
    this.$id = "ace/mode/javascript";
    this.snippetFileId = "ace/snippets/javascript";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var lang = require("../lib/lang");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var supportType = exports.supportType = "align-content|align-items|align-self|all|animation|animation-delay|animation-direction|animation-duration|animation-fill-mode|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|backface-visibility|background|background-attachment|background-blend-mode|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|border|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|bottom|box-shadow|box-sizing|caption-side|clear|clip|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|cursor|direction|display|empty-cells|filter|flex|flex-basis|flex-direction|flex-flow|flex-grow|flex-shrink|flex-wrap|float|font|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|hanging-punctuation|height|justify-content|left|letter-spacing|line-height|list-style|list-style-image|list-style-position|list-style-type|margin|margin-bottom|margin-left|margin-right|margin-top|max-height|max-width|max-zoom|min-height|min-width|min-zoom|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|order|outline|outline-color|outline-offset|outline-style|outline-width|overflow|overflow-x|overflow-y|padding|padding-bottom|padding-left|padding-right|padding-top|page-break-after|page-break-before|page-break-inside|perspective|perspective-origin|position|quotes|resize|right|tab-size|table-layout|text-align|text-align-last|text-decoration|text-decoration-color|text-decoration-line|text-decoration-style|text-indent|text-justify|text-overflow|text-shadow|text-transform|top|transform|transform-origin|transform-style|transition|transition-delay|transition-duration|transition-property|transition-timing-function|unicode-bidi|user-select|user-zoom|vertical-align|visibility|white-space|width|word-break|word-spacing|word-wrap|z-index";
var supportFunction = exports.supportFunction = "rgb|rgba|url|attr|counter|counters";
var supportConstant = exports.supportConstant = "absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|flex-end|flex-start|fill|fixed|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero|zoom";
var supportConstantColor = exports.supportConstantColor = "aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen";
var supportConstantFonts = exports.supportConstantFonts = "arial|century|comic|courier|cursive|fantasy|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace";
var numRe = exports.numRe = "\\-?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))";
var pseudoElements = exports.pseudoElements = "(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b";
var pseudoClasses = exports.pseudoClasses = "(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b";
var rgb256Regex = exports.rgb256Regex = /(rgba?)[(]([0-9]+)\s*,\s*([0-9]+)\s*,\s*([0-9]+)\s*(,\s*)?([0-9.]+)?[)]/;
var numberToHex = exports.numberToHex = function (s) {
    var result = s.toString(16);
    return (result.length == 1) ? "0" + result : result;
};
var rgb256Token = exports.rgb256Token = function (value, state, stack, line) {
    var match = value.match(rgb256Regex);
    var r = parseInt(match[2]);
    var g = parseInt(match[3]);
    var b = parseInt(match[4]);
    var has_alpha = match[6] != null;
    if (r > 255 || g > 255 || b > 255)
        return "constant.color";
    var a = "";
    if (has_alpha) {
        a = parseFloat(match[6]);
        if (a < 0 || a > 1)
            return "constant.color";
        a = numberToHex(parseInt(255 * a));
    }
    var r = numberToHex(r);
    var g = numberToHex(g);
    var b = numberToHex(b);
    return [
        { type: "constant.color", value: value, bg: "#" + r + g + b + a }
    ];
};
var colorToken = exports.colorToken = function (value, state, stack, line) {
    return [
        { type: "constant.color", value: value, bg: value.toLowerCase() }
    ];
};
var CssHighlightRules = function () {
    var keywordMapper = this.createKeywordMapper({
        "support.function": supportFunction,
        "support.constant": supportConstant,
        "support.type": supportType,
        "support.constant.color": supportConstantColor,
        "support.constant.fonts": supportConstantFonts
    }, "text", true);
    this.$rules = {
        "start": [{
                include: ["strings", "url", "comments"]
            }, {
                token: "paren.lparen",
                regex: "\\{",
                next: "ruleset"
            }, {
                token: "paren.rparen",
                regex: "\\}"
            }, {
                token: "string",
                regex: "@(?!viewport)",
                next: "media"
            }, {
                token: "keyword",
                regex: "#[a-z0-9-_]+"
            }, {
                token: "keyword",
                regex: "%"
            }, {
                token: "variable",
                regex: "\\.[a-z0-9-_]+"
            }, {
                token: "string",
                regex: ":[a-z0-9-_]+"
            }, {
                token: "constant.numeric",
                regex: numRe
            }, {
                token: "constant",
                regex: "[a-z0-9-_]+"
            }, {
                caseInsensitive: true
            }],
        "media": [{
                include: ["strings", "url", "comments"]
            }, {
                token: "paren.lparen",
                regex: "\\{",
                next: "start"
            }, {
                token: "paren.rparen",
                regex: "\\}",
                next: "start"
            }, {
                token: "string",
                regex: ";",
                next: "start"
            }, {
                token: "keyword",
                regex: "(?:media|supports|document|charset|import|namespace|media|supports|document"
                    + "|page|font|keyframes|viewport|counter-style|font-feature-values"
                    + "|swash|ornaments|annotation|stylistic|styleset|character-variant)"
            }],
        "comments": [{
                token: "comment",
                regex: "\\/\\*",
                push: [{
                        token: "comment",
                        regex: "\\*\\/",
                        next: "pop"
                    }, {
                        defaultToken: "comment"
                    }]
            }],
        "ruleset": [{
                regex: "-(webkit|ms|moz|o)-",
                token: "text"
            }, {
                token: "punctuation.operator",
                regex: "[:;]"
            }, {
                token: "paren.rparen",
                regex: "\\}",
                next: "start"
            }, {
                include: ["strings", "url", "comments"]
            }, {
                token: ["constant.numeric", "keyword"],
                regex: "(" + numRe + ")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"
            }, {
                token: "constant.numeric",
                regex: numRe
            }, {
                regex: rgb256Regex,
                onMatch: rgb256Token
            }, {
                regex: "#[a-fA-F0-9]{8}",
                onMatch: colorToken
            }, {
                regex: "#[a-fA-F0-9]{6}",
                onMatch: colorToken
            }, {
                regex: "#[A-Fa-f0-9]{3}",
                onMatch: colorToken
            }, {
                token: ["punctuation", "entity.other.attribute-name.pseudo-element.css"],
                regex: pseudoElements
            }, {
                token: ["punctuation", "entity.other.attribute-name.pseudo-class.css"],
                regex: pseudoClasses
            }, {
                include: "url"
            }, {
                regex: "\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*",
                onMatch: function (value, state, stack, line) {
                    var result = keywordMapper(value);
                    if (result == "support.constant.color") {
                        result = colorToken(value, state, stack, line);
                    }
                    return result;
                }
            }, {
                caseInsensitive: true
            }],
        url: [{
                token: "support.function",
                regex: "(?:url(:?-prefix)?|domain|regexp)\\(",
                push: [{
                        token: "support.function",
                        regex: "\\)",
                        next: "pop"
                    }, {
                        defaultToken: "string"
                    }]
            }],
        strings: [{
                token: "string.start",
                regex: "'",
                push: [{
                        token: "string.end",
                        regex: "'|$",
                        next: "pop"
                    }, {
                        include: "escapes"
                    }, {
                        token: "constant.language.escape",
                        regex: /\\$/,
                        consumeLineEnd: true
                    }, {
                        defaultToken: "string"
                    }]
            }, {
                token: "string.start",
                regex: '"',
                push: [{
                        token: "string.end",
                        regex: '"|$',
                        next: "pop"
                    }, {
                        include: "escapes"
                    }, {
                        token: "constant.language.escape",
                        regex: /\\$/,
                        consumeLineEnd: true
                    }, {
                        defaultToken: "string"
                    }]
            }],
        escapes: [{
                token: "constant.language.escape",
                regex: /\\([a-fA-F\d]{1,6}|[^a-fA-F\d])/
            }]
    };
    this.normalizeRules();
};
oop.inherits(CssHighlightRules, TextHighlightRules);
exports.CssHighlightRules = CssHighlightRules;

});

define("ace/mode/css_completions",["require","exports","module"], function(require, exports, module){"use strict";
var propertyMap = {
    "background": { "#$0": 1 },
    "background-color": { "#$0": 1, "transparent": 1, "fixed": 1 },
    "background-image": { "url('/$0')": 1 },
    "background-repeat": { "repeat": 1, "repeat-x": 1, "repeat-y": 1, "no-repeat": 1, "inherit": 1 },
    "background-position": { "bottom": 2, "center": 2, "left": 2, "right": 2, "top": 2, "inherit": 2 },
    "background-attachment": { "scroll": 1, "fixed": 1 },
    "background-size": { "cover": 1, "contain": 1 },
    "background-clip": { "border-box": 1, "padding-box": 1, "content-box": 1 },
    "background-origin": { "border-box": 1, "padding-box": 1, "content-box": 1 },
    "border": { "solid $0": 1, "dashed $0": 1, "dotted $0": 1, "#$0": 1 },
    "border-color": { "#$0": 1 },
    "border-style": { "solid": 2, "dashed": 2, "dotted": 2, "double": 2, "groove": 2, "hidden": 2, "inherit": 2, "inset": 2, "none": 2, "outset": 2, "ridged": 2 },
    "border-collapse": { "collapse": 1, "separate": 1 },
    "bottom": { "px": 1, "em": 1, "%": 1 },
    "clear": { "left": 1, "right": 1, "both": 1, "none": 1 },
    "color": { "#$0": 1, "rgb(#$00,0,0)": 1 },
    "cursor": { "default": 1, "pointer": 1, "move": 1, "text": 1, "wait": 1, "help": 1, "progress": 1, "n-resize": 1, "ne-resize": 1, "e-resize": 1, "se-resize": 1, "s-resize": 1, "sw-resize": 1, "w-resize": 1, "nw-resize": 1 },
    "display": { "none": 1, "block": 1, "inline": 1, "inline-block": 1, "table-cell": 1 },
    "empty-cells": { "show": 1, "hide": 1 },
    "float": { "left": 1, "right": 1, "none": 1 },
    "font-family": { "Arial": 2, "Comic Sans MS": 2, "Consolas": 2, "Courier New": 2, "Courier": 2, "Georgia": 2, "Monospace": 2, "Sans-Serif": 2, "Segoe UI": 2, "Tahoma": 2, "Times New Roman": 2, "Trebuchet MS": 2, "Verdana": 1 },
    "font-size": { "px": 1, "em": 1, "%": 1 },
    "font-weight": { "bold": 1, "normal": 1 },
    "font-style": { "italic": 1, "normal": 1 },
    "font-variant": { "normal": 1, "small-caps": 1 },
    "height": { "px": 1, "em": 1, "%": 1 },
    "left": { "px": 1, "em": 1, "%": 1 },
    "letter-spacing": { "normal": 1 },
    "line-height": { "normal": 1 },
    "list-style-type": { "none": 1, "disc": 1, "circle": 1, "square": 1, "decimal": 1, "decimal-leading-zero": 1, "lower-roman": 1, "upper-roman": 1, "lower-greek": 1, "lower-latin": 1, "upper-latin": 1, "georgian": 1, "lower-alpha": 1, "upper-alpha": 1 },
    "margin": { "px": 1, "em": 1, "%": 1 },
    "margin-right": { "px": 1, "em": 1, "%": 1 },
    "margin-left": { "px": 1, "em": 1, "%": 1 },
    "margin-top": { "px": 1, "em": 1, "%": 1 },
    "margin-bottom": { "px": 1, "em": 1, "%": 1 },
    "max-height": { "px": 1, "em": 1, "%": 1 },
    "max-width": { "px": 1, "em": 1, "%": 1 },
    "min-height": { "px": 1, "em": 1, "%": 1 },
    "min-width": { "px": 1, "em": 1, "%": 1 },
    "overflow": { "hidden": 1, "visible": 1, "auto": 1, "scroll": 1 },
    "overflow-x": { "hidden": 1, "visible": 1, "auto": 1, "scroll": 1 },
    "overflow-y": { "hidden": 1, "visible": 1, "auto": 1, "scroll": 1 },
    "padding": { "px": 1, "em": 1, "%": 1 },
    "padding-top": { "px": 1, "em": 1, "%": 1 },
    "padding-right": { "px": 1, "em": 1, "%": 1 },
    "padding-bottom": { "px": 1, "em": 1, "%": 1 },
    "padding-left": { "px": 1, "em": 1, "%": 1 },
    "page-break-after": { "auto": 1, "always": 1, "avoid": 1, "left": 1, "right": 1 },
    "page-break-before": { "auto": 1, "always": 1, "avoid": 1, "left": 1, "right": 1 },
    "position": { "absolute": 1, "relative": 1, "fixed": 1, "static": 1 },
    "right": { "px": 1, "em": 1, "%": 1 },
    "table-layout": { "fixed": 1, "auto": 1 },
    "text-decoration": { "none": 1, "underline": 1, "line-through": 1, "blink": 1 },
    "text-align": { "left": 1, "right": 1, "center": 1, "justify": 1 },
    "text-transform": { "capitalize": 1, "uppercase": 1, "lowercase": 1, "none": 1 },
    "top": { "px": 1, "em": 1, "%": 1 },
    "vertical-align": { "top": 1, "bottom": 1 },
    "visibility": { "hidden": 1, "visible": 1 },
    "white-space": { "nowrap": 1, "normal": 1, "pre": 1, "pre-line": 1, "pre-wrap": 1 },
    "width": { "px": 1, "em": 1, "%": 1 },
    "word-spacing": { "normal": 1 },
    "filter": { "alpha(opacity=$0100)": 1 },
    "text-shadow": { "$02px 2px 2px #777": 1 },
    "text-overflow": { "ellipsis-word": 1, "clip": 1, "ellipsis": 1 },
    "-moz-border-radius": 1,
    "-moz-border-radius-topright": 1,
    "-moz-border-radius-bottomright": 1,
    "-moz-border-radius-topleft": 1,
    "-moz-border-radius-bottomleft": 1,
    "-webkit-border-radius": 1,
    "-webkit-border-top-right-radius": 1,
    "-webkit-border-top-left-radius": 1,
    "-webkit-border-bottom-right-radius": 1,
    "-webkit-border-bottom-left-radius": 1,
    "-moz-box-shadow": 1,
    "-webkit-box-shadow": 1,
    "transform": { "rotate($00deg)": 1, "skew($00deg)": 1 },
    "-moz-transform": { "rotate($00deg)": 1, "skew($00deg)": 1 },
    "-webkit-transform": { "rotate($00deg)": 1, "skew($00deg)": 1 }
};
var CssCompletions = function () {
};
(function () {
    this.completionsDefined = false;
    this.defineCompletions = function () {
        if (document) {
            var style = document.createElement('c').style;
            for (var i in style) {
                if (typeof style[i] !== 'string')
                    continue;
                var name = i.replace(/[A-Z]/g, function (x) {
                    return '-' + x.toLowerCase();
                });
                if (!propertyMap.hasOwnProperty(name))
                    propertyMap[name] = 1;
            }
        }
        this.completionsDefined = true;
    };
    this.getCompletions = function (state, session, pos, prefix) {
        if (!this.completionsDefined) {
            this.defineCompletions();
        }
        if (state === 'ruleset' || session.$mode.$id == "ace/mode/scss") {
            var line = session.getLine(pos.row).substr(0, pos.column);
            var inParens = /\([^)]*$/.test(line);
            if (inParens) {
                line = line.substr(line.lastIndexOf('(') + 1);
            }
            if (/:[^;]+$/.test(line)) {
                /([\w\-]+):[^:]*$/.test(line);
                return this.getPropertyValueCompletions(state, session, pos, prefix);
            }
            else {
                return this.getPropertyCompletions(state, session, pos, prefix, inParens);
            }
        }
        return [];
    };
    this.getPropertyCompletions = function (state, session, pos, prefix, skipSemicolon) {
        skipSemicolon = skipSemicolon || false;
        var properties = Object.keys(propertyMap);
        return properties.map(function (property) {
            return {
                caption: property,
                snippet: property + ': $0' + (skipSemicolon ? '' : ';'),
                meta: "property",
                score: 1000000
            };
        });
    };
    this.getPropertyValueCompletions = function (state, session, pos, prefix) {
        var line = session.getLine(pos.row).substr(0, pos.column);
        var property = (/([\w\-]+):[^:]*$/.exec(line) || {})[1];
        if (!property)
            return [];
        var values = [];
        if (property in propertyMap && typeof propertyMap[property] === "object") {
            values = Object.keys(propertyMap[property]);
        }
        return values.map(function (value) {
            return {
                caption: value,
                snippet: value,
                meta: "property value",
                score: 1000000
            };
        });
    };
}).call(CssCompletions.prototype);
exports.CssCompletions = CssCompletions;

});

define("ace/mode/behaviour/css",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"], function(require, exports, module){"use strict";
var oop = require("../../lib/oop");
var Behaviour = require("../behaviour").Behaviour;
var CstyleBehaviour = require("./cstyle").CstyleBehaviour;
var TokenIterator = require("../../token_iterator").TokenIterator;
var CssBehaviour = function () {
    this.inherit(CstyleBehaviour);
    this.add("colon", "insertion", function (state, action, editor, session, text) {
        if (text === ':' && editor.selection.isEmpty()) {
            var cursor = editor.getCursorPosition();
            var iterator = new TokenIterator(session, cursor.row, cursor.column);
            var token = iterator.getCurrentToken();
            if (token && token.value.match(/\s+/)) {
                token = iterator.stepBackward();
            }
            if (token && token.type === 'support.type') {
                var line = session.doc.getLine(cursor.row);
                var rightChar = line.substring(cursor.column, cursor.column + 1);
                if (rightChar === ':') {
                    return {
                        text: '',
                        selection: [1, 1]
                    };
                }
                if (/^(\s+[^;]|\s*$)/.test(line.substring(cursor.column))) {
                    return {
                        text: ':;',
                        selection: [1, 1]
                    };
                }
            }
        }
    });
    this.add("colon", "deletion", function (state, action, editor, session, range) {
        var selected = session.doc.getTextRange(range);
        if (!range.isMultiLine() && selected === ':') {
            var cursor = editor.getCursorPosition();
            var iterator = new TokenIterator(session, cursor.row, cursor.column);
            var token = iterator.getCurrentToken();
            if (token && token.value.match(/\s+/)) {
                token = iterator.stepBackward();
            }
            if (token && token.type === 'support.type') {
                var line = session.doc.getLine(range.start.row);
                var rightChar = line.substring(range.end.column, range.end.column + 1);
                if (rightChar === ';') {
                    range.end.column++;
                    return range;
                }
            }
        }
    });
    this.add("semicolon", "insertion", function (state, action, editor, session, text) {
        if (text === ';' && editor.selection.isEmpty()) {
            var cursor = editor.getCursorPosition();
            var line = session.doc.getLine(cursor.row);
            var rightChar = line.substring(cursor.column, cursor.column + 1);
            if (rightChar === ';') {
                return {
                    text: '',
                    selection: [1, 1]
                };
            }
        }
    });
    this.add("!important", "insertion", function (state, action, editor, session, text) {
        if (text === '!' && editor.selection.isEmpty()) {
            var cursor = editor.getCursorPosition();
            var line = session.doc.getLine(cursor.row);
            if (/^\s*(;|}|$)/.test(line.substring(cursor.column))) {
                return {
                    text: '!important',
                    selection: [10, 10]
                };
            }
        }
    });
};
oop.inherits(CssBehaviour, CstyleBehaviour);
exports.CssBehaviour = CssBehaviour;

});

define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/css_completions","ace/mode/behaviour/css","ace/mode/folding/cstyle"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var CssHighlightRules = require("./css_highlight_rules").CssHighlightRules;
var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var WorkerClient = require("../worker/worker_client").WorkerClient;
var CssCompletions = require("./css_completions").CssCompletions;
var CssBehaviour = require("./behaviour/css").CssBehaviour;
var CStyleFoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = CssHighlightRules;
    this.$outdent = new MatchingBraceOutdent();
    this.$behaviour = new CssBehaviour();
    this.$completer = new CssCompletions();
    this.foldingRules = new CStyleFoldMode();
};
oop.inherits(Mode, TextMode);
(function () {
    this.foldingRules = "cStyle";
    this.blockComment = { start: "/*", end: "*/" };
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        var tokens = this.getTokenizer().getLineTokens(line, state).tokens;
        if (tokens.length && tokens[tokens.length - 1].type == "comment") {
            return indent;
        }
        var match = line.match(/^.*\{\s*$/);
        if (match) {
            indent += tab;
        }
        return indent;
    };
    this.checkOutdent = function (state, line, input) {
        return this.$outdent.checkOutdent(line, input);
    };
    this.autoOutdent = function (state, doc, row) {
        this.$outdent.autoOutdent(doc, row);
    };
    this.getCompletions = function (state, session, pos, prefix) {
        return this.$completer.getCompletions(state, session, pos, prefix);
    };
    this.createWorker = function (session) {
        var worker = new WorkerClient(["ace"], "ace/mode/css_worker", "Worker");
        worker.attachToDocument(session.getDocument());
        worker.on("annotate", function (e) {
            session.setAnnotations(e.data);
        });
        worker.on("terminate", function () {
            session.clearAnnotations();
        });
        return worker;
    };
    this.$id = "ace/mode/css";
    this.snippetFileId = "ace/snippets/css";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/xml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var XmlHighlightRules = function (normalize) {
    var tagRegex = "[_:a-zA-Z\xc0-\uffff][-_:.a-zA-Z0-9\xc0-\uffff]*";
    this.$rules = {
        start: [
            { token: "string.cdata.xml", regex: "<\\!\\[CDATA\\[", next: "cdata" },
            {
                token: ["punctuation.instruction.xml", "keyword.instruction.xml"],
                regex: "(<\\?)(" + tagRegex + ")", next: "processing_instruction"
            },
            { token: "comment.start.xml", regex: "<\\!--", next: "comment" },
            {
                token: ["xml-pe.doctype.xml", "xml-pe.doctype.xml"],
                regex: "(<\\!)(DOCTYPE)(?=[\\s])", next: "doctype", caseInsensitive: true
            },
            { include: "tag" },
            { token: "text.end-tag-open.xml", regex: "</" },
            { token: "text.tag-open.xml", regex: "<" },
            { include: "reference" },
            { defaultToken: "text.xml" }
        ],
        processing_instruction: [{
                token: "entity.other.attribute-name.decl-attribute-name.xml",
                regex: tagRegex
            }, {
                token: "keyword.operator.decl-attribute-equals.xml",
                regex: "="
            }, {
                include: "whitespace"
            }, {
                include: "string"
            }, {
                token: "punctuation.xml-decl.xml",
                regex: "\\?>",
                next: "start"
            }],
        doctype: [
            { include: "whitespace" },
            { include: "string" },
            { token: "xml-pe.doctype.xml", regex: ">", next: "start" },
            { token: "xml-pe.xml", regex: "[-_a-zA-Z0-9:]+" },
            { token: "punctuation.int-subset", regex: "\\[", push: "int_subset" }
        ],
        int_subset: [{
                token: "text.xml",
                regex: "\\s+"
            }, {
                token: "punctuation.int-subset.xml",
                regex: "]",
                next: "pop"
            }, {
                token: ["punctuation.markup-decl.xml", "keyword.markup-decl.xml"],
                regex: "(<\\!)(" + tagRegex + ")",
                push: [{
                        token: "text",
                        regex: "\\s+"
                    },
                    {
                        token: "punctuation.markup-decl.xml",
                        regex: ">",
                        next: "pop"
                    },
                    { include: "string" }]
            }],
        cdata: [
            { token: "string.cdata.xml", regex: "\\]\\]>", next: "start" },
            { token: "text.xml", regex: "\\s+" },
            { token: "text.xml", regex: "(?:[^\\]]|\\](?!\\]>))+" }
        ],
        comment: [
            { token: "comment.end.xml", regex: "-->", next: "start" },
            { defaultToken: "comment.xml" }
        ],
        reference: [{
                token: "constant.language.escape.reference.xml",
                regex: "(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"
            }],
        attr_reference: [{
                token: "constant.language.escape.reference.attribute-value.xml",
                regex: "(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"
            }],
        tag: [{
                token: ["meta.tag.punctuation.tag-open.xml", "meta.tag.punctuation.end-tag-open.xml", "meta.tag.tag-name.xml"],
                regex: "(?:(<)|(</))((?:" + tagRegex + ":)?" + tagRegex + ")",
                next: [
                    { include: "attributes" },
                    { token: "meta.tag.punctuation.tag-close.xml", regex: "/?>", next: "start" }
                ]
            }],
        tag_whitespace: [
            { token: "text.tag-whitespace.xml", regex: "\\s+" }
        ],
        whitespace: [
            { token: "text.whitespace.xml", regex: "\\s+" }
        ],
        string: [{
                token: "string.xml",
                regex: "'",
                push: [
                    { token: "string.xml", regex: "'", next: "pop" },
                    { defaultToken: "string.xml" }
                ]
            }, {
                token: "string.xml",
                regex: '"',
                push: [
                    { token: "string.xml", regex: '"', next: "pop" },
                    { defaultToken: "string.xml" }
                ]
            }],
        attributes: [{
                token: "entity.other.attribute-name.xml",
                regex: tagRegex
            }, {
                token: "keyword.operator.attribute-equals.xml",
                regex: "="
            }, {
                include: "tag_whitespace"
            }, {
                include: "attribute_value"
            }],
        attribute_value: [{
                token: "string.attribute-value.xml",
                regex: "'",
                push: [
                    { token: "string.attribute-value.xml", regex: "'", next: "pop" },
                    { include: "attr_reference" },
                    { defaultToken: "string.attribute-value.xml" }
                ]
            }, {
                token: "string.attribute-value.xml",
                regex: '"',
                push: [
                    { token: "string.attribute-value.xml", regex: '"', next: "pop" },
                    { include: "attr_reference" },
                    { defaultToken: "string.attribute-value.xml" }
                ]
            }]
    };
    if (this.constructor === XmlHighlightRules)
        this.normalizeRules();
};
(function () {
    this.embedTagRules = function (HighlightRules, prefix, tag) {
        this.$rules.tag.unshift({
            token: ["meta.tag.punctuation.tag-open.xml", "meta.tag." + tag + ".tag-name.xml"],
            regex: "(<)(" + tag + "(?=\\s|>|$))",
            next: [
                { include: "attributes" },
                { token: "meta.tag.punctuation.tag-close.xml", regex: "/?>", next: prefix + "start" }
            ]
        });
        this.$rules[tag + "-end"] = [
            { include: "attributes" },
            { token: "meta.tag.punctuation.tag-close.xml", regex: "/?>", next: "start",
                onMatch: function (value, currentState, stack) {
                    stack.splice(0);
                    return this.token;
                } }
        ];
        this.embedRules(HighlightRules, prefix, [{
                token: ["meta.tag.punctuation.end-tag-open.xml", "meta.tag." + tag + ".tag-name.xml"],
                regex: "(</)(" + tag + "(?=\\s|>|$))",
                next: tag + "-end"
            }, {
                token: "string.cdata.xml",
                regex: "<\\!\\[CDATA\\["
            }, {
                token: "string.cdata.xml",
                regex: "\\]\\]>"
            }]);
    };
}).call(TextHighlightRules.prototype);
oop.inherits(XmlHighlightRules, TextHighlightRules);
exports.XmlHighlightRules = XmlHighlightRules;

});

define("ace/mode/html_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/xml_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var lang = require("../lib/lang");
var CssHighlightRules = require("./css_highlight_rules").CssHighlightRules;
var JavaScriptHighlightRules = require("./javascript_highlight_rules").JavaScriptHighlightRules;
var XmlHighlightRules = require("./xml_highlight_rules").XmlHighlightRules;
var tagMap = lang.createMap({
    a: 'anchor',
    button: 'form',
    form: 'form',
    img: 'image',
    input: 'form',
    label: 'form',
    option: 'form',
    script: 'script',
    select: 'form',
    textarea: 'form',
    style: 'style',
    table: 'table',
    tbody: 'table',
    td: 'table',
    tfoot: 'table',
    th: 'table',
    tr: 'table'
});
var HtmlHighlightRules = function () {
    XmlHighlightRules.call(this);
    this.addRules({
        attributes: [{
                include: "tag_whitespace"
            }, {
                token: "entity.other.attribute-name.xml",
                regex: "[-_a-zA-Z0-9:.]+"
            }, {
                token: "keyword.operator.attribute-equals.xml",
                regex: "=",
                push: [{
                        include: "tag_whitespace"
                    }, {
                        token: "string.unquoted.attribute-value.html",
                        regex: "[^<>='\"`\\s]+",
                        next: "pop"
                    }, {
                        token: "empty",
                        regex: "",
                        next: "pop"
                    }]
            }, {
                include: "attribute_value"
            }],
        tag: [{
                token: function (start, tag) {
                    var group = tagMap[tag];
                    return ["meta.tag.punctuation." + (start == "<" ? "" : "end-") + "tag-open.xml",
                        "meta.tag" + (group ? "." + group : "") + ".tag-name.xml"];
                },
                regex: "(</?)([-_a-zA-Z0-9:.]+)",
                next: "tag_stuff"
            }],
        tag_stuff: [
            { include: "attributes" },
            { token: "meta.tag.punctuation.tag-close.xml", regex: "/?>", next: "start" }
        ]
    });
    this.embedTagRules(CssHighlightRules, "css-", "style");
    this.embedTagRules(new JavaScriptHighlightRules({ jsx: false }).getRules(), "js-", "script");
    if (this.constructor === HtmlHighlightRules)
        this.normalizeRules();
};
oop.inherits(HtmlHighlightRules, XmlHighlightRules);
exports.HtmlHighlightRules = HtmlHighlightRules;

});

define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"], function(require, exports, module){"use strict";
var oop = require("../../lib/oop");
var Behaviour = require("../behaviour").Behaviour;
var TokenIterator = require("../../token_iterator").TokenIterator;
var lang = require("../../lib/lang");
function is(token, type) {
    return token && token.type.lastIndexOf(type + ".xml") > -1;
}
var XmlBehaviour = function () {
    this.add("string_dquotes", "insertion", function (state, action, editor, session, text) {
        if (text == '"' || text == "'") {
            var quote = text;
            var selected = session.doc.getTextRange(editor.getSelectionRange());
            if (selected !== "" && selected !== "'" && selected != '"' && editor.getWrapBehavioursEnabled()) {
                return {
                    text: quote + selected + quote,
                    selection: false
                };
            }
            var cursor = editor.getCursorPosition();
            var line = session.doc.getLine(cursor.row);
            var rightChar = line.substring(cursor.column, cursor.column + 1);
            var iterator = new TokenIterator(session, cursor.row, cursor.column);
            var token = iterator.getCurrentToken();
            if (rightChar == quote && (is(token, "attribute-value") || is(token, "string"))) {
                return {
                    text: "",
                    selection: [1, 1]
                };
            }
            if (!token)
                token = iterator.stepBackward();
            if (!token)
                return;
            while (is(token, "tag-whitespace") || is(token, "whitespace")) {
                token = iterator.stepBackward();
            }
            var rightSpace = !rightChar || rightChar.match(/\s/);
            if (is(token, "attribute-equals") && (rightSpace || rightChar == '>') || (is(token, "decl-attribute-equals") && (rightSpace || rightChar == '?'))) {
                return {
                    text: quote + quote,
                    selection: [1, 1]
                };
            }
        }
    });
    this.add("string_dquotes", "deletion", function (state, action, editor, session, range) {
        var selected = session.doc.getTextRange(range);
        if (!range.isMultiLine() && (selected == '"' || selected == "'")) {
            var line = session.doc.getLine(range.start.row);
            var rightChar = line.substring(range.start.column + 1, range.start.column + 2);
            if (rightChar == selected) {
                range.end.column++;
                return range;
            }
        }
    });
    this.add("autoclosing", "insertion", function (state, action, editor, session, text) {
        if (text == '>') {
            var position = editor.getSelectionRange().start;
            var iterator = new TokenIterator(session, position.row, position.column);
            var token = iterator.getCurrentToken() || iterator.stepBackward();
            if (!token || !(is(token, "tag-name") || is(token, "tag-whitespace") || is(token, "attribute-name") || is(token, "attribute-equals") || is(token, "attribute-value")))
                return;
            if (is(token, "reference.attribute-value"))
                return;
            if (is(token, "attribute-value")) {
                var tokenEndColumn = iterator.getCurrentTokenColumn() + token.value.length;
                if (position.column < tokenEndColumn)
                    return;
                if (position.column == tokenEndColumn) {
                    var nextToken = iterator.stepForward();
                    if (nextToken && is(nextToken, "attribute-value"))
                        return;
                    iterator.stepBackward();
                }
            }
            if (/^\s*>/.test(session.getLine(position.row).slice(position.column)))
                return;
            while (!is(token, "tag-name")) {
                token = iterator.stepBackward();
                if (token.value == "<") {
                    token = iterator.stepForward();
                    break;
                }
            }
            var tokenRow = iterator.getCurrentTokenRow();
            var tokenColumn = iterator.getCurrentTokenColumn();
            if (is(iterator.stepBackward(), "end-tag-open"))
                return;
            var element = token.value;
            if (tokenRow == position.row)
                element = element.substring(0, position.column - tokenColumn);
            if (this.voidElements.hasOwnProperty(element.toLowerCase()))
                return;
            return {
                text: ">" + "</" + element + ">",
                selection: [1, 1]
            };
        }
    });
    this.add("autoindent", "insertion", function (state, action, editor, session, text) {
        if (text == "\n") {
            var cursor = editor.getCursorPosition();
            var line = session.getLine(cursor.row);
            var iterator = new TokenIterator(session, cursor.row, cursor.column);
            var token = iterator.getCurrentToken();
            if (token && token.type.indexOf("tag-close") !== -1) {
                if (token.value == "/>")
                    return;
                while (token && token.type.indexOf("tag-name") === -1) {
                    token = iterator.stepBackward();
                }
                if (!token) {
                    return;
                }
                var tag = token.value;
                var row = iterator.getCurrentTokenRow();
                token = iterator.stepBackward();
                if (!token || token.type.indexOf("end-tag") !== -1) {
                    return;
                }
                if (this.voidElements && !this.voidElements[tag]) {
                    var nextToken = session.getTokenAt(cursor.row, cursor.column + 1);
                    var line = session.getLine(row);
                    var nextIndent = this.$getIndent(line);
                    var indent = nextIndent + session.getTabString();
                    if (nextToken && nextToken.value === "</") {
                        return {
                            text: "\n" + indent + "\n" + nextIndent,
                            selection: [1, indent.length, 1, indent.length]
                        };
                    }
                    else {
                        return {
                            text: "\n" + indent
                        };
                    }
                }
            }
        }
    });
};
oop.inherits(XmlBehaviour, Behaviour);
exports.XmlBehaviour = XmlBehaviour;

});

define("ace/mode/folding/mixed",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode"], function(require, exports, module){"use strict";
var oop = require("../../lib/oop");
var BaseFoldMode = require("./fold_mode").FoldMode;
var FoldMode = exports.FoldMode = function (defaultMode, subModes) {
    this.defaultMode = defaultMode;
    this.subModes = subModes;
};
oop.inherits(FoldMode, BaseFoldMode);
(function () {
    this.$getMode = function (state) {
        if (typeof state != "string")
            state = state[0];
        for (var key in this.subModes) {
            if (state.indexOf(key) === 0)
                return this.subModes[key];
        }
        return null;
    };
    this.$tryMode = function (state, session, foldStyle, row) {
        var mode = this.$getMode(state);
        return (mode ? mode.getFoldWidget(session, foldStyle, row) : "");
    };
    this.getFoldWidget = function (session, foldStyle, row) {
        return (this.$tryMode(session.getState(row - 1), session, foldStyle, row) ||
            this.$tryMode(session.getState(row), session, foldStyle, row) ||
            this.defaultMode.getFoldWidget(session, foldStyle, row));
    };
    this.getFoldWidgetRange = function (session, foldStyle, row) {
        var mode = this.$getMode(session.getState(row - 1));
        if (!mode || !mode.getFoldWidget(session, foldStyle, row))
            mode = this.$getMode(session.getState(row));
        if (!mode || !mode.getFoldWidget(session, foldStyle, row))
            mode = this.defaultMode;
        return mode.getFoldWidgetRange(session, foldStyle, row);
    };
}).call(FoldMode.prototype);

});

define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"], function(require, exports, module){"use strict";
var oop = require("../../lib/oop");
var Range = require("../../range").Range;
var BaseFoldMode = require("./fold_mode").FoldMode;
var FoldMode = exports.FoldMode = function (voidElements, optionalEndTags) {
    BaseFoldMode.call(this);
    this.voidElements = voidElements || {};
    this.optionalEndTags = oop.mixin({}, this.voidElements);
    if (optionalEndTags)
        oop.mixin(this.optionalEndTags, optionalEndTags);
};
oop.inherits(FoldMode, BaseFoldMode);
var Tag = function () {
    this.tagName = "";
    this.closing = false;
    this.selfClosing = false;
    this.start = { row: 0, column: 0 };
    this.end = { row: 0, column: 0 };
};
function is(token, type) {
    return token.type.lastIndexOf(type + ".xml") > -1;
}
(function () {
    this.getFoldWidget = function (session, foldStyle, row) {
        var tag = this._getFirstTagInLine(session, row);
        if (!tag)
            return this.getCommentFoldWidget(session, row);
        if (tag.closing || (!tag.tagName && tag.selfClosing))
            return foldStyle === "markbeginend" ? "end" : "";
        if (!tag.tagName || tag.selfClosing || this.voidElements.hasOwnProperty(tag.tagName.toLowerCase()))
            return "";
        if (this._findEndTagInLine(session, row, tag.tagName, tag.end.column))
            return "";
        return "start";
    };
    this.getCommentFoldWidget = function (session, row) {
        if (/comment/.test(session.getState(row)) && /<!-/.test(session.getLine(row)))
            return "start";
        return "";
    };
    this._getFirstTagInLine = function (session, row) {
        var tokens = session.getTokens(row);
        var tag = new Tag();
        for (var i = 0; i < tokens.length; i++) {
            var token = tokens[i];
            if (is(token, "tag-open")) {
                tag.end.column = tag.start.column + token.value.length;
                tag.closing = is(token, "end-tag-open");
                token = tokens[++i];
                if (!token)
                    return null;
                tag.tagName = token.value;
                tag.end.column += token.value.length;
                for (i++; i < tokens.length; i++) {
                    token = tokens[i];
                    tag.end.column += token.value.length;
                    if (is(token, "tag-close")) {
                        tag.selfClosing = token.value == '/>';
                        break;
                    }
                }
                return tag;
            }
            else if (is(token, "tag-close")) {
                tag.selfClosing = token.value == '/>';
                return tag;
            }
            tag.start.column += token.value.length;
        }
        return null;
    };
    this._findEndTagInLine = function (session, row, tagName, startColumn) {
        var tokens = session.getTokens(row);
        var column = 0;
        for (var i = 0; i < tokens.length; i++) {
            var token = tokens[i];
            column += token.value.length;
            if (column < startColumn)
                continue;
            if (is(token, "end-tag-open")) {
                token = tokens[i + 1];
                if (token && token.value == tagName)
                    return true;
            }
        }
        return false;
    };
    this.getFoldWidgetRange = function (session, foldStyle, row) {
        var tags = session.getMatchingTags({ row: row, column: 0 });
        if (tags) {
            return new Range(tags.openTag.end.row, tags.openTag.end.column, tags.closeTag.start.row, tags.closeTag.start.column);
        }
        else {
            return this.getCommentFoldWidget(session, row)
                && session.getCommentFoldRange(row, session.getLine(row).length);
        }
    };
}).call(FoldMode.prototype);

});

define("ace/mode/folding/html",["require","exports","module","ace/lib/oop","ace/mode/folding/mixed","ace/mode/folding/xml","ace/mode/folding/cstyle"], function(require, exports, module){"use strict";
var oop = require("../../lib/oop");
var MixedFoldMode = require("./mixed").FoldMode;
var XmlFoldMode = require("./xml").FoldMode;
var CStyleFoldMode = require("./cstyle").FoldMode;
var FoldMode = exports.FoldMode = function (voidElements, optionalTags) {
    MixedFoldMode.call(this, new XmlFoldMode(voidElements, optionalTags), {
        "js-": new CStyleFoldMode(),
        "css-": new CStyleFoldMode()
    });
};
oop.inherits(FoldMode, MixedFoldMode);

});

define("ace/mode/html_completions",["require","exports","module","ace/token_iterator"], function(require, exports, module){"use strict";
var TokenIterator = require("../token_iterator").TokenIterator;
var commonAttributes = [
    "accesskey",
    "class",
    "contenteditable",
    "contextmenu",
    "dir",
    "draggable",
    "dropzone",
    "hidden",
    "id",
    "inert",
    "itemid",
    "itemprop",
    "itemref",
    "itemscope",
    "itemtype",
    "lang",
    "spellcheck",
    "style",
    "tabindex",
    "title",
    "translate"
];
var eventAttributes = [
    "onabort",
    "onblur",
    "oncancel",
    "oncanplay",
    "oncanplaythrough",
    "onchange",
    "onclick",
    "onclose",
    "oncontextmenu",
    "oncuechange",
    "ondblclick",
    "ondrag",
    "ondragend",
    "ondragenter",
    "ondragleave",
    "ondragover",
    "ondragstart",
    "ondrop",
    "ondurationchange",
    "onemptied",
    "onended",
    "onerror",
    "onfocus",
    "oninput",
    "oninvalid",
    "onkeydown",
    "onkeypress",
    "onkeyup",
    "onload",
    "onloadeddata",
    "onloadedmetadata",
    "onloadstart",
    "onmousedown",
    "onmousemove",
    "onmouseout",
    "onmouseover",
    "onmouseup",
    "onmousewheel",
    "onpause",
    "onplay",
    "onplaying",
    "onprogress",
    "onratechange",
    "onreset",
    "onscroll",
    "onseeked",
    "onseeking",
    "onselect",
    "onshow",
    "onstalled",
    "onsubmit",
    "onsuspend",
    "ontimeupdate",
    "onvolumechange",
    "onwaiting"
];
var globalAttributes = commonAttributes.concat(eventAttributes);
var attributeMap = {
    "a": { "href": 1, "target": { "_blank": 1, "top": 1 }, "ping": 1, "rel": { "nofollow": 1, "alternate": 1, "author": 1, "bookmark": 1, "help": 1, "license": 1, "next": 1, "noreferrer": 1, "prefetch": 1, "prev": 1, "search": 1, "tag": 1 }, "media": 1, "hreflang": 1, "type": 1 },
    "abbr": {},
    "address": {},
    "area": { "shape": 1, "coords": 1, "href": 1, "hreflang": 1, "alt": 1, "target": 1, "media": 1, "rel": 1, "ping": 1, "type": 1 },
    "article": { "pubdate": 1 },
    "aside": {},
    "audio": { "src": 1, "autobuffer": 1, "autoplay": { "autoplay": 1 }, "loop": { "loop": 1 }, "controls": { "controls": 1 }, "muted": { "muted": 1 }, "preload": { "auto": 1, "metadata": 1, "none": 1 } },
    "b": {},
    "base": { "href": 1, "target": 1 },
    "bdi": {},
    "bdo": {},
    "blockquote": { "cite": 1 },
    "body": { "onafterprint": 1, "onbeforeprint": 1, "onbeforeunload": 1, "onhashchange": 1, "onmessage": 1, "onoffline": 1, "onpopstate": 1, "onredo": 1, "onresize": 1, "onstorage": 1, "onundo": 1, "onunload": 1 },
    "br": {},
    "button": { "autofocus": 1, "disabled": { "disabled": 1 }, "form": 1, "formaction": 1, "formenctype": 1, "formmethod": 1, "formnovalidate": 1, "formtarget": 1, "name": 1, "value": 1, "type": { "button": 1, "submit": 1 } },
    "canvas": { "width": 1, "height": 1 },
    "caption": {},
    "cite": {},
    "code": {},
    "col": { "span": 1 },
    "colgroup": { "span": 1 },
    "command": { "type": 1, "label": 1, "icon": 1, "disabled": 1, "checked": 1, "radiogroup": 1, "command": 1 },
    "data": {},
    "datalist": {},
    "dd": {},
    "del": { "cite": 1, "datetime": 1 },
    "details": { "open": 1 },
    "dfn": {},
    "dialog": { "open": 1 },
    "div": {},
    "dl": {},
    "dt": {},
    "em": {},
    "embed": { "src": 1, "height": 1, "width": 1, "type": 1 },
    "fieldset": { "disabled": 1, "form": 1, "name": 1 },
    "figcaption": {},
    "figure": {},
    "footer": {},
    "form": { "accept-charset": 1, "action": 1, "autocomplete": 1, "enctype": { "multipart/form-data": 1, "application/x-www-form-urlencoded": 1 }, "method": { "get": 1, "post": 1 }, "name": 1, "novalidate": 1, "target": { "_blank": 1, "top": 1 } },
    "h1": {},
    "h2": {},
    "h3": {},
    "h4": {},
    "h5": {},
    "h6": {},
    "head": {},
    "header": {},
    "hr": {},
    "html": { "manifest": 1 },
    "i": {},
    "iframe": { "name": 1, "src": 1, "height": 1, "width": 1, "sandbox": { "allow-same-origin": 1, "allow-top-navigation": 1, "allow-forms": 1, "allow-scripts": 1 }, "seamless": { "seamless": 1 } },
    "img": { "alt": 1, "src": 1, "height": 1, "width": 1, "usemap": 1, "ismap": 1 },
    "input": {
        "type": { "text": 1, "password": 1, "hidden": 1, "checkbox": 1, "submit": 1, "radio": 1, "file": 1, "button": 1, "reset": 1, "image": 31, "color": 1, "date": 1, "datetime": 1, "datetime-local": 1, "email": 1, "month": 1, "number": 1, "range": 1, "search": 1, "tel": 1, "time": 1, "url": 1, "week": 1 },
        "accept": 1, "alt": 1, "autocomplete": { "on": 1, "off": 1 }, "autofocus": { "autofocus": 1 }, "checked": { "checked": 1 }, "disabled": { "disabled": 1 }, "form": 1, "formaction": 1, "formenctype": { "application/x-www-form-urlencoded": 1, "multipart/form-data": 1, "text/plain": 1 }, "formmethod": { "get": 1, "post": 1 }, "formnovalidate": { "formnovalidate": 1 }, "formtarget": { "_blank": 1, "_self": 1, "_parent": 1, "_top": 1 }, "height": 1, "list": 1, "max": 1, "maxlength": 1, "min": 1, "multiple": { "multiple": 1 }, "name": 1, "pattern": 1, "placeholder": 1, "readonly": { "readonly": 1 }, "required": { "required": 1 }, "size": 1, "src": 1, "step": 1, "width": 1, "files": 1, "value": 1
    },
    "ins": { "cite": 1, "datetime": 1 },
    "kbd": {},
    "keygen": { "autofocus": 1, "challenge": { "challenge": 1 }, "disabled": { "disabled": 1 }, "form": 1, "keytype": { "rsa": 1, "dsa": 1, "ec": 1 }, "name": 1 },
    "label": { "form": 1, "for": 1 },
    "legend": {},
    "li": { "value": 1 },
    "link": { "href": 1, "hreflang": 1, "rel": { "stylesheet": 1, "icon": 1 }, "media": { "all": 1, "screen": 1, "print": 1 }, "type": { "text/css": 1, "image/png": 1, "image/jpeg": 1, "image/gif": 1 }, "sizes": 1 },
    "main": {},
    "map": { "name": 1 },
    "mark": {},
    "math": {},
    "menu": { "type": 1, "label": 1 },
    "meta": { "http-equiv": { "content-type": 1 }, "name": { "description": 1, "keywords": 1 }, "content": { "text/html; charset=UTF-8": 1 }, "charset": 1 },
    "meter": { "value": 1, "min": 1, "max": 1, "low": 1, "high": 1, "optimum": 1 },
    "nav": {},
    "noscript": { "href": 1 },
    "object": { "param": 1, "data": 1, "type": 1, "height": 1, "width": 1, "usemap": 1, "name": 1, "form": 1, "classid": 1 },
    "ol": { "start": 1, "reversed": 1 },
    "optgroup": { "disabled": 1, "label": 1 },
    "option": { "disabled": 1, "selected": 1, "label": 1, "value": 1 },
    "output": { "for": 1, "form": 1, "name": 1 },
    "p": {},
    "param": { "name": 1, "value": 1 },
    "pre": {},
    "progress": { "value": 1, "max": 1 },
    "q": { "cite": 1 },
    "rp": {},
    "rt": {},
    "ruby": {},
    "s": {},
    "samp": {},
    "script": { "charset": 1, "type": { "text/javascript": 1 }, "src": 1, "defer": 1, "async": 1 },
    "select": { "autofocus": 1, "disabled": 1, "form": 1, "multiple": { "multiple": 1 }, "name": 1, "size": 1, "readonly": { "readonly": 1 } },
    "small": {},
    "source": { "src": 1, "type": 1, "media": 1 },
    "span": {},
    "strong": {},
    "style": { "type": 1, "media": { "all": 1, "screen": 1, "print": 1 }, "scoped": 1 },
    "sub": {},
    "sup": {},
    "svg": {},
    "table": { "summary": 1 },
    "tbody": {},
    "td": { "headers": 1, "rowspan": 1, "colspan": 1 },
    "textarea": { "autofocus": { "autofocus": 1 }, "disabled": { "disabled": 1 }, "form": 1, "maxlength": 1, "name": 1, "placeholder": 1, "readonly": { "readonly": 1 }, "required": { "required": 1 }, "rows": 1, "cols": 1, "wrap": { "on": 1, "off": 1, "hard": 1, "soft": 1 } },
    "tfoot": {},
    "th": { "headers": 1, "rowspan": 1, "colspan": 1, "scope": 1 },
    "thead": {},
    "time": { "datetime": 1 },
    "title": {},
    "tr": {},
    "track": { "kind": 1, "src": 1, "srclang": 1, "label": 1, "default": 1 },
    "section": {},
    "summary": {},
    "u": {},
    "ul": {},
    "var": {},
    "video": { "src": 1, "autobuffer": 1, "autoplay": { "autoplay": 1 }, "loop": { "loop": 1 }, "controls": { "controls": 1 }, "width": 1, "height": 1, "poster": 1, "muted": { "muted": 1 }, "preload": { "auto": 1, "metadata": 1, "none": 1 } },
    "wbr": {}
};
var elements = Object.keys(attributeMap);
function is(token, type) {
    return token.type.lastIndexOf(type + ".xml") > -1;
}
function findTagName(session, pos) {
    var iterator = new TokenIterator(session, pos.row, pos.column);
    var token = iterator.getCurrentToken();
    while (token && !is(token, "tag-name")) {
        token = iterator.stepBackward();
    }
    if (token)
        return token.value;
}
function findAttributeName(session, pos) {
    var iterator = new TokenIterator(session, pos.row, pos.column);
    var token = iterator.getCurrentToken();
    while (token && !is(token, "attribute-name")) {
        token = iterator.stepBackward();
    }
    if (token)
        return token.value;
}
var HtmlCompletions = function () {
};
(function () {
    this.getCompletions = function (state, session, pos, prefix) {
        var token = session.getTokenAt(pos.row, pos.column);
        if (!token)
            return [];
        if (is(token, "tag-name") || is(token, "tag-open") || is(token, "end-tag-open"))
            return this.getTagCompletions(state, session, pos, prefix);
        if (is(token, "tag-whitespace") || is(token, "attribute-name"))
            return this.getAttributeCompletions(state, session, pos, prefix);
        if (is(token, "attribute-value"))
            return this.getAttributeValueCompletions(state, session, pos, prefix);
        var line = session.getLine(pos.row).substr(0, pos.column);
        if (/&[a-z]*$/i.test(line))
            return this.getHTMLEntityCompletions(state, session, pos, prefix);
        return [];
    };
    this.getTagCompletions = function (state, session, pos, prefix) {
        return elements.map(function (element) {
            return {
                value: element,
                meta: "tag",
                score: 1000000
            };
        });
    };
    this.getAttributeCompletions = function (state, session, pos, prefix) {
        var tagName = findTagName(session, pos);
        if (!tagName)
            return [];
        var attributes = globalAttributes;
        if (tagName in attributeMap) {
            attributes = attributes.concat(Object.keys(attributeMap[tagName]));
        }
        return attributes.map(function (attribute) {
            return {
                caption: attribute,
                snippet: attribute + '="$0"',
                meta: "attribute",
                score: 1000000
            };
        });
    };
    this.getAttributeValueCompletions = function (state, session, pos, prefix) {
        var tagName = findTagName(session, pos);
        var attributeName = findAttributeName(session, pos);
        if (!tagName)
            return [];
        var values = [];
        if (tagName in attributeMap && attributeName in attributeMap[tagName] && typeof attributeMap[tagName][attributeName] === "object") {
            values = Object.keys(attributeMap[tagName][attributeName]);
        }
        return values.map(function (value) {
            return {
                caption: value,
                snippet: value,
                meta: "attribute value",
                score: 1000000
            };
        });
    };
    this.getHTMLEntityCompletions = function (state, session, pos, prefix) {
        var values = ['Aacute;', 'aacute;', 'Acirc;', 'acirc;', 'acute;', 'AElig;', 'aelig;', 'Agrave;', 'agrave;', 'alefsym;', 'Alpha;', 'alpha;', 'amp;', 'and;', 'ang;', 'Aring;', 'aring;', 'asymp;', 'Atilde;', 'atilde;', 'Auml;', 'auml;', 'bdquo;', 'Beta;', 'beta;', 'brvbar;', 'bull;', 'cap;', 'Ccedil;', 'ccedil;', 'cedil;', 'cent;', 'Chi;', 'chi;', 'circ;', 'clubs;', 'cong;', 'copy;', 'crarr;', 'cup;', 'curren;', 'Dagger;', 'dagger;', 'dArr;', 'darr;', 'deg;', 'Delta;', 'delta;', 'diams;', 'divide;', 'Eacute;', 'eacute;', 'Ecirc;', 'ecirc;', 'Egrave;', 'egrave;', 'empty;', 'emsp;', 'ensp;', 'Epsilon;', 'epsilon;', 'equiv;', 'Eta;', 'eta;', 'ETH;', 'eth;', 'Euml;', 'euml;', 'euro;', 'exist;', 'fnof;', 'forall;', 'frac12;', 'frac14;', 'frac34;', 'frasl;', 'Gamma;', 'gamma;', 'ge;', 'gt;', 'hArr;', 'harr;', 'hearts;', 'hellip;', 'Iacute;', 'iacute;', 'Icirc;', 'icirc;', 'iexcl;', 'Igrave;', 'igrave;', 'image;', 'infin;', 'int;', 'Iota;', 'iota;', 'iquest;', 'isin;', 'Iuml;', 'iuml;', 'Kappa;', 'kappa;', 'Lambda;', 'lambda;', 'lang;', 'laquo;', 'lArr;', 'larr;', 'lceil;', 'ldquo;', 'le;', 'lfloor;', 'lowast;', 'loz;', 'lrm;', 'lsaquo;', 'lsquo;', 'lt;', 'macr;', 'mdash;', 'micro;', 'middot;', 'minus;', 'Mu;', 'mu;', 'nabla;', 'nbsp;', 'ndash;', 'ne;', 'ni;', 'not;', 'notin;', 'nsub;', 'Ntilde;', 'ntilde;', 'Nu;', 'nu;', 'Oacute;', 'oacute;', 'Ocirc;', 'ocirc;', 'OElig;', 'oelig;', 'Ograve;', 'ograve;', 'oline;', 'Omega;', 'omega;', 'Omicron;', 'omicron;', 'oplus;', 'or;', 'ordf;', 'ordm;', 'Oslash;', 'oslash;', 'Otilde;', 'otilde;', 'otimes;', 'Ouml;', 'ouml;', 'para;', 'part;', 'permil;', 'perp;', 'Phi;', 'phi;', 'Pi;', 'pi;', 'piv;', 'plusmn;', 'pound;', 'Prime;', 'prime;', 'prod;', 'prop;', 'Psi;', 'psi;', 'quot;', 'radic;', 'rang;', 'raquo;', 'rArr;', 'rarr;', 'rceil;', 'rdquo;', 'real;', 'reg;', 'rfloor;', 'Rho;', 'rho;', 'rlm;', 'rsaquo;', 'rsquo;', 'sbquo;', 'Scaron;', 'scaron;', 'sdot;', 'sect;', 'shy;', 'Sigma;', 'sigma;', 'sigmaf;', 'sim;', 'spades;', 'sub;', 'sube;', 'sum;', 'sup;', 'sup1;', 'sup2;', 'sup3;', 'supe;', 'szlig;', 'Tau;', 'tau;', 'there4;', 'Theta;', 'theta;', 'thetasym;', 'thinsp;', 'THORN;', 'thorn;', 'tilde;', 'times;', 'trade;', 'Uacute;', 'uacute;', 'uArr;', 'uarr;', 'Ucirc;', 'ucirc;', 'Ugrave;', 'ugrave;', 'uml;', 'upsih;', 'Upsilon;', 'upsilon;', 'Uuml;', 'uuml;', 'weierp;', 'Xi;', 'xi;', 'Yacute;', 'yacute;', 'yen;', 'Yuml;', 'yuml;', 'Zeta;', 'zeta;', 'zwj;', 'zwnj;'];
        return values.map(function (value) {
            return {
                caption: value,
                snippet: value,
                meta: "html entity",
                score: 1000000
            };
        });
    };
}).call(HtmlCompletions.prototype);
exports.HtmlCompletions = HtmlCompletions;

});

define("ace/mode/html",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/javascript","ace/mode/css","ace/mode/html_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/html","ace/mode/html_completions","ace/worker/worker_client"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var lang = require("../lib/lang");
var TextMode = require("./text").Mode;
var JavaScriptMode = require("./javascript").Mode;
var CssMode = require("./css").Mode;
var HtmlHighlightRules = require("./html_highlight_rules").HtmlHighlightRules;
var XmlBehaviour = require("./behaviour/xml").XmlBehaviour;
var HtmlFoldMode = require("./folding/html").FoldMode;
var HtmlCompletions = require("./html_completions").HtmlCompletions;
var WorkerClient = require("../worker/worker_client").WorkerClient;
var voidElements = ["area", "base", "br", "col", "embed", "hr", "img", "input", "keygen", "link", "meta", "menuitem", "param", "source", "track", "wbr"];
var optionalEndTags = ["li", "dt", "dd", "p", "rt", "rp", "optgroup", "option", "colgroup", "td", "th"];
var Mode = function (options) {
    this.fragmentContext = options && options.fragmentContext;
    this.HighlightRules = HtmlHighlightRules;
    this.$behaviour = new XmlBehaviour();
    this.$completer = new HtmlCompletions();
    this.createModeDelegates({
        "js-": JavaScriptMode,
        "css-": CssMode
    });
    this.foldingRules = new HtmlFoldMode(this.voidElements, lang.arrayToMap(optionalEndTags));
};
oop.inherits(Mode, TextMode);
(function () {
    this.blockComment = { start: "<!--", end: "-->" };
    this.voidElements = lang.arrayToMap(voidElements);
    this.getNextLineIndent = function (state, line, tab) {
        return this.$getIndent(line);
    };
    this.checkOutdent = function (state, line, input) {
        return false;
    };
    this.getCompletions = function (state, session, pos, prefix) {
        return this.$completer.getCompletions(state, session, pos, prefix);
    };
    this.createWorker = function (session) {
        if (this.constructor != Mode)
            return;
        var worker = new WorkerClient(["ace"], "ace/mode/html_worker", "Worker");
        worker.attachToDocument(session.getDocument());
        if (this.fragmentContext)
            worker.call("setOptions", [{ context: this.fragmentContext }]);
        worker.on("error", function (e) {
            session.setAnnotations(e.data);
        });
        worker.on("terminate", function () {
            session.clearAnnotations();
        });
        return worker;
    };
    this.$id = "ace/mode/html";
    this.snippetFileId = "ace/snippets/html";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/coldfusion_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/javascript_highlight_rules","ace/mode/html_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var JavaScriptHighlightRules = require("./javascript_highlight_rules").JavaScriptHighlightRules;
var HtmlHighlightRules = require("./html_highlight_rules").HtmlHighlightRules;
var ColdfusionHighlightRules = function () {
    HtmlHighlightRules.call(this);
    this.$rules.tag[2].token = function (start, tag) {
        var group = tag.slice(0, 2) == "cf" ? "keyword" : "meta.tag";
        return ["meta.tag.punctuation." + (start == "<" ? "" : "end-") + "tag-open.xml",
            group + ".tag-name.xml"];
    };
    var jsAndCss = Object.keys(this.$rules).filter(function (x) {
        return /^(js|css)-/.test(x);
    });
    this.embedRules({
        cfmlComment: [
            { regex: "<!---", token: "comment.start", push: "cfmlComment" },
            { regex: "--->", token: "comment.end", next: "pop" },
            { defaultToken: "comment" }
        ]
    }, "", [
        { regex: "<!---", token: "comment.start", push: "cfmlComment" }
    ], [
        "comment", "start", "tag_whitespace", "cdata"
    ].concat(jsAndCss));
    this.$rules.cfTag = [
        { include: "attributes" },
        { token: "meta.tag.punctuation.tag-close.xml", regex: "/?>", next: "pop" }
    ];
    var cfTag = {
        token: function (start, tag) {
            return ["meta.tag.punctuation." + (start == "<" ? "" : "end-") + "tag-open.xml",
                "keyword.tag-name.xml"];
        },
        regex: "(</?)(cf[-_a-zA-Z0-9:.]+)",
        push: "cfTag"
    };
    jsAndCss.forEach(function (s) {
        this.$rules[s].unshift(cfTag);
    }, this);
    this.embedTagRules(new JavaScriptHighlightRules({ jsx: false }).getRules(), "cfjs-", "cfscript");
    this.normalizeRules();
};
oop.inherits(ColdfusionHighlightRules, HtmlHighlightRules);
exports.ColdfusionHighlightRules = ColdfusionHighlightRules;

});

define("ace/mode/coldfusion",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/html","ace/mode/coldfusion_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var lang = require("../lib/lang");
var HtmlMode = require("./html").Mode;
var ColdfusionHighlightRules = require("./coldfusion_highlight_rules").ColdfusionHighlightRules;
var voidElements = "cfabort|cfapplication|cfargument|cfassociate|cfbreak|cfcache|cfcollection|cfcookie|cfdbinfo|cfdirectory|cfdump|cfelse|cfelseif|cferror|cfexchangecalendar|cfexchangeconnection|cfexchangecontact|cfexchangefilter|cfexchangetask|cfexit|cffeed|cffile|cfflush|cfftp|cfheader|cfhtmlhead|cfhttpparam|cfimage|cfimport|cfinclude|cfindex|cfinsert|cfinvokeargument|cflocation|cflog|cfmailparam|cfNTauthenticate|cfobject|cfobjectcache|cfparam|cfpdfformparam|cfprint|cfprocparam|cfprocresult|cfproperty|cfqueryparam|cfregistry|cfreportparam|cfrethrow|cfreturn|cfschedule|cfsearch|cfset|cfsetting|cfthrow|cfzipparam)".split("|");
var Mode = function () {
    HtmlMode.call(this);
    this.HighlightRules = ColdfusionHighlightRules;
};
oop.inherits(Mode, HtmlMode);
(function () {
    this.voidElements = oop.mixin(lang.arrayToMap(voidElements), this.voidElements);
    this.getNextLineIndent = function (state, line, tab) {
        return this.$getIndent(line);
    };
    this.$id = "ace/mode/coldfusion";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/doc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var DocCommentHighlightRules = function () {
    this.$rules = {
        "start": [
            {
                token: "comment.doc.tag",
                regex: "@\\w+(?=\\s|$)"
            }, DocCommentHighlightRules.getTagRule(), {
                defaultToken: "comment.doc",
                caseInsensitive: true
            }
        ]
    };
};
oop.inherits(DocCommentHighlightRules, TextHighlightRules);
DocCommentHighlightRules.getTagRule = function (start) {
    return {
        token: "comment.doc.tag.storage.type",
        regex: "\\b(?:TODO|FIXME|XXX|HACK)\\b"
    };
};
DocCommentHighlightRules.getStartRule = function (start) {
    return {
        token: "comment.doc",
        regex: "\\/\\*(?=\\*)",
        next: start
    };
};
DocCommentHighlightRules.getEndRule = function (start) {
    return {
        token: "comment.doc",
        regex: "\\*\\/",
        next: start
    };
};
exports.DocCommentHighlightRules = DocCommentHighlightRules;

});

define("ace/mode/csharp_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var DocCommentHighlightRules = require("./doc_comment_highlight_rules").DocCommentHighlightRules;
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var CSharpHighlightRules = function () {
    var keywordMapper = this.createKeywordMapper({
        "variable.language": "this",
        "keyword": "abstract|async|await|event|new|struct|as|explicit|null|switch|base|extern|object|this|bool|false|operator|throw|break|finally|out|true|byte|fixed|override|try|case|float|params|typeof|catch|for|private|uint|char|foreach|protected|ulong|checked|goto|public|unchecked|class|if|readonly|unsafe|const|implicit|ref|ushort|continue|in|return|using|decimal|int|sbyte|virtual|default|interface|sealed|volatile|delegate|internal|partial|short|void|do|is|sizeof|while|double|lock|stackalloc|else|long|static|enum|namespace|string|var|dynamic",
        "constant.language": "null|true|false"
    }, "identifier");
    this.$rules = {
        "start": [
            {
                token: "comment",
                regex: "\\/\\/.*$"
            },
            DocCommentHighlightRules.getStartRule("doc-start"),
            {
                token: "comment",
                regex: "\\/\\*",
                next: "comment"
            }, {
                token: "string",
                regex: /'(?:.|\\(:?u[\da-fA-F]+|x[\da-fA-F]+|[tbrf'"n]))?'/
            }, {
                token: "string", start: '"', end: '"|$', next: [
                    { token: "constant.language.escape", regex: /\\(:?u[\da-fA-F]+|x[\da-fA-F]+|[tbrf'"n])/ },
                    { token: "invalid", regex: /\\./ }
                ]
            }, {
                token: "string", start: '@"', end: '"', next: [
                    { token: "constant.language.escape", regex: '""' }
                ]
            }, {
                token: "string", start: /\$"/, end: '"|$', next: [
                    { token: "constant.language.escape", regex: /\\(:?$)|{{/ },
                    { token: "constant.language.escape", regex: /\\(:?u[\da-fA-F]+|x[\da-fA-F]+|[tbrf'"n])/ },
                    { token: "invalid", regex: /\\./ }
                ]
            }, {
                token: "constant.numeric",
                regex: "0[xX][0-9a-fA-F]+\\b"
            }, {
                token: "constant.numeric",
                regex: "[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"
            }, {
                token: "constant.language.boolean",
                regex: "(?:true|false)\\b"
            }, {
                token: keywordMapper,
                regex: "[a-zA-Z_$][a-zA-Z0-9_$]*\\b"
            }, {
                token: "keyword.operator",
                regex: "!|\\$|%|&|\\*|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^=|\\b(?:in|instanceof|new|delete|typeof|void)"
            }, {
                token: "keyword",
                regex: "^\\s*#(if|else|elif|endif|define|undef|warning|error|line|region|endregion|pragma)"
            }, {
                token: "punctuation.operator",
                regex: "\\?|\\:|\\,|\\;|\\."
            }, {
                token: "paren.lparen",
                regex: "[[({]"
            }, {
                token: "paren.rparen",
                regex: "[\\])}]"
            }, {
                token: "text",
                regex: "\\s+"
            }
        ],
        "comment": [
            {
                token: "comment",
                regex: "\\*\\/",
                next: "start"
            }, {
                defaultToken: "comment"
            }
        ]
    };
    this.embedRules(DocCommentHighlightRules, "doc-", [DocCommentHighlightRules.getEndRule("start")]);
    this.normalizeRules();
};
oop.inherits(CSharpHighlightRules, TextHighlightRules);
exports.CSharpHighlightRules = CSharpHighlightRules;

});

define("ace/mode/folding/csharp",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/cstyle"], function(require, exports, module){"use strict";
var oop = require("../../lib/oop");
var Range = require("../../range").Range;
var CFoldMode = require("./cstyle").FoldMode;
var FoldMode = exports.FoldMode = function (commentRegex) {
    if (commentRegex) {
        this.foldingStartMarker = new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/, "|" + commentRegex.start));
        this.foldingStopMarker = new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/, "|" + commentRegex.end));
    }
};
oop.inherits(FoldMode, CFoldMode);
(function () {
    this.usingRe = /^\s*using \S/;
    this.getFoldWidgetRangeBase = this.getFoldWidgetRange;
    this.getFoldWidgetBase = this.getFoldWidget;
    this.getFoldWidget = function (session, foldStyle, row) {
        var fw = this.getFoldWidgetBase(session, foldStyle, row);
        if (!fw) {
            var line = session.getLine(row);
            if (/^\s*#region\b/.test(line))
                return "start";
            var usingRe = this.usingRe;
            if (usingRe.test(line)) {
                var prev = session.getLine(row - 1);
                var next = session.getLine(row + 1);
                if (!usingRe.test(prev) && usingRe.test(next))
                    return "start";
            }
        }
        return fw;
    };
    this.getFoldWidgetRange = function (session, foldStyle, row) {
        var range = this.getFoldWidgetRangeBase(session, foldStyle, row);
        if (range)
            return range;
        var line = session.getLine(row);
        if (this.usingRe.test(line))
            return this.getUsingStatementBlock(session, line, row);
        if (/^\s*#region\b/.test(line))
            return this.getRegionBlock(session, line, row);
    };
    this.getUsingStatementBlock = function (session, line, row) {
        var startColumn = line.match(this.usingRe)[0].length - 1;
        var maxRow = session.getLength();
        var startRow = row;
        var endRow = row;
        while (++row < maxRow) {
            line = session.getLine(row);
            if (/^\s*$/.test(line))
                continue;
            if (!this.usingRe.test(line))
                break;
            endRow = row;
        }
        if (endRow > startRow) {
            var endColumn = session.getLine(endRow).length;
            return new Range(startRow, startColumn, endRow, endColumn);
        }
    };
    this.getRegionBlock = function (session, line, row) {
        var startColumn = line.search(/\s*$/);
        var maxRow = session.getLength();
        var startRow = row;
        var re = /^\s*#(end)?region\b/;
        var depth = 1;
        while (++row < maxRow) {
            line = session.getLine(row);
            var m = re.exec(line);
            if (!m)
                continue;
            if (m[1])
                depth--;
            else
                depth++;
            if (!depth)
                break;
        }
        var endRow = row;
        if (endRow > startRow) {
            return new Range(startRow, startColumn, endRow, line.length);
        }
    };
}).call(FoldMode.prototype);

});

define("ace/mode/csharp",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/csharp_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/csharp"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var CSharpHighlightRules = require("./csharp_highlight_rules").CSharpHighlightRules;
var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var CStyleFoldMode = require("./folding/csharp").FoldMode;
var Mode = function () {
    this.HighlightRules = CSharpHighlightRules;
    this.$outdent = new MatchingBraceOutdent();
    this.$behaviour = this.$defaultBehaviour;
    this.foldingRules = new CStyleFoldMode();
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "//";
    this.blockComment = { start: "/*", end: "*/" };
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        var tokenizedLine = this.getTokenizer().getLineTokens(line, state);
        var tokens = tokenizedLine.tokens;
        if (tokens.length && tokens[tokens.length - 1].type == "comment") {
            return indent;
        }
        if (state == "start") {
            var match = line.match(/^.*[\{\(\[]\s*$/);
            if (match) {
                indent += tab;
            }
        }
        return indent;
    };
    this.checkOutdent = function (state, line, input) {
        return this.$outdent.checkOutdent(line, input);
    };
    this.autoOutdent = function (state, doc, row) {
        this.$outdent.autoOutdent(doc, row);
    };
    this.createWorker = function (session) {
        return null;
    };
    this.$id = "ace/mode/csharp";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/curly_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/html_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var HtmlHighlightRules = require("./html_highlight_rules").HtmlHighlightRules;
var CurlyHighlightRules = function () {
    HtmlHighlightRules.call(this);
    this.$rules["start"].unshift({
        token: "variable",
        regex: "{{",
        push: "curly-start"
    });
    this.$rules["curly-start"] = [{
            token: "variable",
            regex: "}}",
            next: "pop"
        }];
    this.normalizeRules();
};
oop.inherits(CurlyHighlightRules, HtmlHighlightRules);
exports.CurlyHighlightRules = CurlyHighlightRules;

});

define("ace/mode/curly",["require","exports","module","ace/lib/oop","ace/mode/html","ace/mode/matching_brace_outdent","ace/mode/folding/html","ace/mode/curly_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var HtmlMode = require("./html").Mode;
var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var HtmlFoldMode = require("./folding/html").FoldMode;
var CurlyHighlightRules = require("./curly_highlight_rules").CurlyHighlightRules;
var Mode = function () {
    HtmlMode.call(this);
    this.HighlightRules = CurlyHighlightRules;
    this.$outdent = new MatchingBraceOutdent();
    this.foldingRules = new HtmlFoldMode();
};
oop.inherits(Mode, HtmlMode);
(function () {
    this.$id = "ace/mode/curly";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/d_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var DocCommentHighlightRules = require("./doc_comment_highlight_rules").DocCommentHighlightRules;
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var DHighlightRules = function () {
    var keywords = ("this|super|import|module|body|mixin|__traits|invariant|alias|asm|delete|" +
        "typeof|typeid|sizeof|cast|new|in|is|typedef|__vector|__parameters");
    var keywordControls = ("break|case|continue|default|do|else|for|foreach|foreach_reverse|goto|if|" +
        "return|switch|while|catch|try|throw|finally|version|assert|unittest|with");
    var types = ("auto|bool|char|dchar|wchar|byte|ubyte|float|double|real|" +
        "cfloat|creal|cdouble|cent|ifloat|ireal|idouble|" +
        "int|long|short|void|uint|ulong|ushort|ucent|" +
        "function|delegate|string|wstring|dstring|size_t|ptrdiff_t|hash_t|Object");
    var modifiers = ("abstract|align|debug|deprecated|export|extern|const|final|in|inout|out|" +
        "ref|immutable|lazy|nothrow|override|package|pragma|private|protected|" +
        "public|pure|scope|shared|__gshared|synchronized|static|volatile");
    var storages = ("class|struct|union|template|interface|enum|macro");
    var stringEscapesSeq = {
        token: "constant.language.escape",
        regex: "\\\\(?:(?:x[0-9A-F]{2})|(?:[0-7]{1,3})|(?:['\"\\?0abfnrtv\\\\])|" +
            "(?:u[0-9a-fA-F]{4})|(?:U[0-9a-fA-F]{8}))"
    };
    var builtinConstants = ("null|true|false|" +
        "__DATE__|__EOF__|__TIME__|__TIMESTAMP__|__VENDOR__|__VERSION__|" +
        "__FILE__|__MODULE__|__LINE__|__FUNCTION__|__PRETTY_FUNCTION__");
    var operators = ("/|/\\=|&|&\\=|&&|\\|\\|\\=|\\|\\||\\-|\\-\\=|\\-\\-|\\+|" +
        "\\+\\=|\\+\\+|\\<|\\<\\=|\\<\\<|\\<\\<\\=|\\<\\>|\\<\\>\\=|\\>|\\>\\=|\\>\\>\\=|" +
        "\\>\\>\\>\\=|\\>\\>|\\>\\>\\>|\\!|\\!\\=|\\!\\<\\>|\\!\\<\\>\\=|\\!\\<|\\!\\<\\=|" +
        "\\!\\>|\\!\\>\\=|\\?|\\$|\\=|\\=\\=|\\*|\\*\\=|%|%\\=|" +
        "\\^|\\^\\=|\\^\\^|\\^\\^\\=|~|~\\=|\\=\\>|#");
    var keywordMapper = this.$keywords = this.createKeywordMapper({
        "keyword.modifier": modifiers,
        "keyword.control": keywordControls,
        "keyword.type": types,
        "keyword": keywords,
        "keyword.storage": storages,
        "punctation": "\\.|\\,|;|\\.\\.|\\.\\.\\.",
        "keyword.operator": operators,
        "constant.language": builtinConstants
    }, "identifier");
    var identifierRe = "[a-zA-Z_\u00a1-\uffff][a-zA-Z\\d_\u00a1-\uffff]*\\b";
    this.$rules = {
        "start": [
            {
                token: "comment",
                regex: "\\/\\/.*$"
            },
            DocCommentHighlightRules.getStartRule("doc-start"),
            {
                token: "comment",
                regex: "\\/\\*",
                next: "star-comment"
            }, {
                token: "comment.shebang",
                regex: "^\\s*#!.*"
            }, {
                token: "comment",
                regex: "\\/\\+",
                next: "plus-comment"
            }, {
                onMatch: function (value, currentState, state) {
                    state.unshift(this.next, value.substr(2));
                    return "string";
                },
                regex: 'q"(?:[\\[\\(\\{\\<]+)',
                next: 'operator-heredoc-string'
            }, {
                onMatch: function (value, currentState, state) {
                    state.unshift(this.next, value.substr(2));
                    return "string";
                },
                regex: 'q"(?:[a-zA-Z_]+)$',
                next: 'identifier-heredoc-string'
            }, {
                token: "string",
                regex: '[xr]?"',
                next: "quote-string"
            }, {
                token: "string",
                regex: '[xr]?`',
                next: "backtick-string"
            }, {
                token: "string",
                regex: "[xr]?['](?:(?:\\\\.)|(?:[^'\\\\]))*?['][cdw]?"
            }, {
                token: ["keyword", "text", "paren.lparen"],
                regex: /(asm)(\s*)({)/,
                next: "d-asm"
            }, {
                token: ["keyword", "text", "paren.lparen", "constant.language"],
                regex: "(__traits)(\\s*)(\\()(" + identifierRe + ")"
            }, {
                token: ["keyword", "text", "variable.module"],
                regex: "(import|module)(\\s+)((?:" + identifierRe + "\\.?)*)"
            }, {
                token: ["keyword.storage", "text", "entity.name.type"],
                regex: "(" + storages + ")(\\s*)(" + identifierRe + ")"
            }, {
                token: ["keyword", "text", "variable.storage", "text"],
                regex: "(alias|typedef)(\\s*)(" + identifierRe + ")(\\s*)"
            }, {
                token: "constant.numeric",
                regex: "0[xX][0-9a-fA-F_]+(l|ul|u|f|F|L|U|UL)?\\b"
            }, {
                token: "constant.numeric",
                regex: "[+-]?\\d[\\d_]*(?:(?:\\.[\\d_]*)?(?:[eE][+-]?[\\d_]+)?)?(l|ul|u|f|F|L|U|UL)?\\b"
            }, {
                token: "entity.other.attribute-name",
                regex: "@" + identifierRe
            }, {
                token: keywordMapper,
                regex: "[a-zA-Z_][a-zA-Z0-9_]*\\b"
            }, {
                token: "keyword.operator",
                regex: operators
            }, {
                token: "punctuation.operator",
                regex: "\\?|\\:|\\,|\\;|\\.|\\:"
            }, {
                token: "paren.lparen",
                regex: "[[({]"
            }, {
                token: "paren.rparen",
                regex: "[\\])}]"
            }, {
                token: "text",
                regex: "\\s+"
            }
        ],
        "star-comment": [
            {
                token: "comment",
                regex: "\\*\\/",
                next: "start"
            }, {
                defaultToken: 'comment'
            }
        ],
        "plus-comment": [
            {
                token: "comment",
                regex: "\\+\\/",
                next: "start"
            }, {
                defaultToken: 'comment'
            }
        ],
        "quote-string": [
            stringEscapesSeq,
            {
                token: "string",
                regex: '"[cdw]?',
                next: "start"
            }, {
                defaultToken: 'string'
            }
        ],
        "backtick-string": [
            stringEscapesSeq,
            {
                token: "string",
                regex: '`[cdw]?',
                next: "start"
            }, {
                defaultToken: 'string'
            }
        ],
        "operator-heredoc-string": [
            {
                onMatch: function (value, currentState, state) {
                    value = value.substring(value.length - 2, value.length - 1);
                    var map = { '>': '<', ']': '[', ')': '(', '}': '{' };
                    if (Object.keys(map).indexOf(value) != -1)
                        value = map[value];
                    if (value != state[1])
                        return "string";
                    state.shift();
                    state.shift();
                    return "string";
                },
                regex: '(?:[\\]\\)}>]+)"',
                next: 'start'
            }, {
                token: 'string',
                regex: '[^\\]\\)}>]+'
            }
        ],
        "identifier-heredoc-string": [
            {
                onMatch: function (value, currentState, state) {
                    value = value.substring(0, value.length - 1);
                    if (value != state[1])
                        return "string";
                    state.shift();
                    state.shift();
                    return "string";
                },
                regex: '^(?:[A-Za-z_][a-zA-Z0-9]+)"',
                next: 'start'
            }, {
                token: 'string',
                regex: '[^\\]\\)}>]+'
            }
        ],
        "d-asm": [
            {
                token: "paren.rparen",
                regex: "\\}",
                next: "start"
            }, {
                token: 'keyword.instruction',
                regex: '[a-zA-Z]+',
                next: 'd-asm-instruction'
            }, {
                token: "text",
                regex: "\\s+"
            }
        ],
        'd-asm-instruction': [
            {
                token: 'constant.language',
                regex: /AL|AH|AX|EAX|BL|BH|BX|EBX|CL|CH|CX|ECX|DL|DH|DX|EDX|BP|EBP|SP|ESP|DI|EDI|SI|ESI/i
            }, {
                token: 'identifier',
                regex: '[a-zA-Z]+'
            }, {
                token: 'string',
                regex: '"[^"]*"'
            }, {
                token: 'comment',
                regex: '//.*$'
            }, {
                token: 'constant.numeric',
                regex: '[0-9.xA-F]+'
            }, {
                token: 'punctuation.operator',
                regex: '\\,'
            }, {
                token: 'punctuation.operator',
                regex: ';',
                next: 'd-asm'
            }, {
                token: 'text',
                regex: '\\s+'
            }
        ]
    };
    this.embedRules(DocCommentHighlightRules, "doc-", [DocCommentHighlightRules.getEndRule("start")]);
};
DHighlightRules.metaData = {
    comment: 'D language',
    fileTypes: ['d', 'di'],
    firstLineMatch: '^#!.*\\b[glr]?dmd\\b.',
    foldingStartMarker: '(?x)/\\*\\*(?!\\*)|^(?![^{]*?//|[^{]*?/\\*(?!.*?\\*/.*?\\{)).*?\\{\\s*($|//|/\\*(?!.*?\\*/.*\\S))',
    foldingStopMarker: '(?<!\\*)\\*\\*/|^\\s*\\}',
    keyEquivalent: '^~D',
    name: 'D',
    scopeName: 'source.d'
};
oop.inherits(DHighlightRules, TextHighlightRules);
exports.DHighlightRules = DHighlightRules;

});

define("ace/mode/d",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/d_highlight_rules","ace/mode/folding/cstyle"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY mode.tmpl.js
*/
"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var DHighlightRules = require("./d_highlight_rules").DHighlightRules;
var FoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = DHighlightRules;
    this.foldingRules = new FoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "//";
    this.blockComment = { start: "/*", end: "*/" };
    this.$id = "ace/mode/d";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/c_cpp_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var DocCommentHighlightRules = require("./doc_comment_highlight_rules").DocCommentHighlightRules;
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var cFunctions = exports.cFunctions = "hypot|hypotf|hypotl|sscanf|system|snprintf|scanf|scalbn|scalbnf|scalbnl|scalbln|scalblnf|scalblnl|sin|sinh|sinhf|sinhl|sinf|sinl|signal|signbit|strstr|strspn|strncpy|strncat|strncmp|strcspn|strchr|strcoll|strcpy|strcat|strcmp|strtoimax|strtod|strtoul|strtoull|strtoumax|strtok|strtof|strtol|strtold|strtoll|strerror|strpbrk|strftime|strlen|strrchr|strxfrm|sprintf|setjmp|setvbuf|setlocale|setbuf|sqrt|sqrtf|sqrtl|swscanf|swprintf|srand|nearbyint|nearbyintf|nearbyintl|nexttoward|nexttowardf|nexttowardl|nextafter|nextafterf|nextafterl|nan|nanf|nanl|csin|csinh|csinhf|csinhl|csinf|csinl|csqrt|csqrtf|csqrtl|ccos|ccosh|ccoshf|ccosf|ccosl|cimag|cimagf|cimagl|ctime|ctan|ctanh|ctanhf|ctanhl|ctanf|ctanl|cos|cosh|coshf|coshl|cosf|cosl|conj|conjf|conjl|copysign|copysignf|copysignl|cpow|cpowf|cpowl|cproj|cprojf|cprojl|ceil|ceilf|ceill|cexp|cexpf|cexpl|clock|clog|clogf|clogl|clearerr|casin|casinh|casinhf|casinhl|casinf|casinl|cacos|cacosh|cacoshf|cacoshl|cacosf|cacosl|catan|catanh|catanhf|catanhl|catanf|catanl|calloc|carg|cargf|cargl|cabs|cabsf|cabsl|creal|crealf|creall|cbrt|cbrtf|cbrtl|time|toupper|tolower|tan|tanh|tanhf|tanhl|tanf|tanl|trunc|truncf|truncl|tgamma|tgammaf|tgammal|tmpnam|tmpfile|isspace|isnormal|isnan|iscntrl|isinf|isdigit|isunordered|isupper|ispunct|isprint|isfinite|iswspace|iswcntrl|iswctype|iswdigit|iswupper|iswpunct|iswprint|iswlower|iswalnum|iswalpha|iswgraph|iswxdigit|iswblank|islower|isless|islessequal|islessgreater|isalnum|isalpha|isgreater|isgreaterequal|isgraph|isxdigit|isblank|ilogb|ilogbf|ilogbl|imaxdiv|imaxabs|div|difftime|_Exit|ungetc|ungetwc|pow|powf|powl|puts|putc|putchar|putwc|putwchar|perror|printf|erf|erfc|erfcf|erfcl|erff|erfl|exit|exp|exp2|exp2f|exp2l|expf|expl|expm1|expm1f|expm1l|vsscanf|vsnprintf|vscanf|vsprintf|vswscanf|vswprintf|vprintf|vfscanf|vfprintf|vfwscanf|vfwprintf|vwscanf|vwprintf|va_start|va_copy|va_end|va_arg|qsort|fscanf|fsetpos|fseek|fclose|ftell|fopen|fdim|fdimf|fdiml|fpclassify|fputs|fputc|fputws|fputwc|fprintf|feholdexcept|fesetenv|fesetexceptflag|fesetround|feclearexcept|fetestexcept|feof|feupdateenv|feraiseexcept|ferror|fegetenv|fegetexceptflag|fegetround|fflush|fwscanf|fwide|fwprintf|fwrite|floor|floorf|floorl|fabs|fabsf|fabsl|fgets|fgetc|fgetpos|fgetws|fgetwc|freopen|free|fread|frexp|frexpf|frexpl|fmin|fminf|fminl|fmod|fmodf|fmodl|fma|fmaf|fmal|fmax|fmaxf|fmaxl|ldiv|ldexp|ldexpf|ldexpl|longjmp|localtime|localeconv|log|log1p|log1pf|log1pl|log10|log10f|log10l|log2|log2f|log2l|logf|logl|logb|logbf|logbl|labs|lldiv|llabs|llrint|llrintf|llrintl|llround|llroundf|llroundl|lrint|lrintf|lrintl|lround|lroundf|lroundl|lgamma|lgammaf|lgammal|wscanf|wcsstr|wcsspn|wcsncpy|wcsncat|wcsncmp|wcscspn|wcschr|wcscoll|wcscpy|wcscat|wcscmp|wcstoimax|wcstod|wcstoul|wcstoull|wcstoumax|wcstok|wcstof|wcstol|wcstold|wcstoll|wcstombs|wcspbrk|wcsftime|wcslen|wcsrchr|wcsrtombs|wcsxfrm|wctob|wctomb|wcrtomb|wprintf|wmemset|wmemchr|wmemcpy|wmemcmp|wmemmove|assert|asctime|asin|asinh|asinhf|asinhl|asinf|asinl|acos|acosh|acoshf|acoshl|acosf|acosl|atoi|atof|atol|atoll|atexit|atan|atanh|atanhf|atanhl|atan2|atan2f|atan2l|atanf|atanl|abs|abort|gets|getc|getchar|getenv|getwc|getwchar|gmtime|rint|rintf|rintl|round|roundf|roundl|rename|realloc|rewind|remove|remquo|remquof|remquol|remainder|remainderf|remainderl|rand|raise|bsearch|btowc|modf|modff|modfl|memset|memchr|memcpy|memcmp|memmove|mktime|malloc|mbsinit|mbstowcs|mbsrtowcs|mbtowc|mblen|mbrtowc|mbrlen";
var c_cppHighlightRules = function (extraKeywords) {
    var keywordControls = ("break|case|continue|default|do|else|for|goto|if|_Pragma|" +
        "return|switch|while|catch|operator|try|throw|using");
    var storageType = ("asm|__asm__|auto|bool|_Bool|char|_Complex|double|enum|float|" +
        "_Imaginary|int|int8_t|int16_t|int32_t|int64_t|long|short|signed|size_t|struct|typedef|uint8_t|uint16_t|uint32_t|uint64_t|union|unsigned|void|" +
        "class|wchar_t|template|char16_t|char32_t");
    var storageModifiers = ("const|extern|register|restrict|static|volatile|inline|private|" +
        "protected|public|friend|explicit|virtual|export|mutable|typename|" +
        "constexpr|new|delete|alignas|alignof|decltype|noexcept|thread_local");
    var keywordOperators = ("and|and_eq|bitand|bitor|compl|not|not_eq|or|or_eq|typeid|xor|xor_eq|" +
        "const_cast|dynamic_cast|reinterpret_cast|static_cast|sizeof|namespace");
    var builtinConstants = ("NULL|true|false|TRUE|FALSE|nullptr");
    var keywordMapper = this.$keywords = this.createKeywordMapper(Object.assign({
        "keyword.control": keywordControls,
        "storage.type": storageType,
        "storage.modifier": storageModifiers,
        "keyword.operator": keywordOperators,
        "variable.language": "this",
        "constant.language": builtinConstants,
        "support.function.C99.c": cFunctions
    }, extraKeywords), "identifier");
    var identifierRe = "[a-zA-Z\\$_\u00a1-\uffff][a-zA-Z\\d\\$_\u00a1-\uffff]*\\b";
    var escapeRe = /\\(?:['"?\\abfnrtv]|[0-7]{1,3}|x[a-fA-F\d]{2}|u[a-fA-F\d]{4}U[a-fA-F\d]{8}|.)/.source;
    var formatRe = "%"
        + /(\d+\$)?/.source // field (argument #)
        + /[#0\- +']*/.source // flags
        + /[,;:_]?/.source // separator character (AltiVec)
        + /((-?\d+)|\*(-?\d+\$)?)?/.source // minimum field width
        + /(\.((-?\d+)|\*(-?\d+\$)?)?)?/.source // precision
        + /(hh|h|ll|l|j|t|z|q|L|vh|vl|v|hv|hl)?/.source // length modifier
        + /(\[[^"\]]+\]|[diouxXDOUeEfFgGaACcSspn%])/.source; // conversion type
    this.$rules = {
        "start": [
            {
                token: "comment",
                regex: "//$",
                next: "start"
            }, {
                token: "comment",
                regex: "//",
                next: "singleLineComment"
            },
            DocCommentHighlightRules.getStartRule("doc-start"),
            {
                token: "comment",
                regex: "\\/\\*",
                next: "comment"
            }, {
                token: "string",
                regex: "'(?:" + escapeRe + "|.)?'"
            }, {
                token: "string.start",
                regex: '"',
                stateName: "qqstring",
                next: [
                    { token: "string", regex: /\\\s*$/, next: "qqstring" },
                    { token: "constant.language.escape", regex: escapeRe },
                    { token: "constant.language.escape", regex: formatRe },
                    { token: "string.end", regex: '"|$', next: "start" },
                    { defaultToken: "string" }
                ]
            }, {
                token: "string.start",
                regex: 'R"\\(',
                stateName: "rawString",
                next: [
                    { token: "string.end", regex: '\\)"', next: "start" },
                    { defaultToken: "string" }
                ]
            }, {
                token: "constant.numeric",
                regex: "0[xX][0-9a-fA-F]+(L|l|UL|ul|u|U|F|f|ll|LL|ull|ULL)?\\b"
            }, {
                token: "constant.numeric",
                regex: "[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?(L|l|UL|ul|u|U|F|f|ll|LL|ull|ULL)?\\b"
            }, {
                token: "keyword",
                regex: "#\\s*(?:include|import|pragma|line|define|undef)\\b",
                next: "directive"
            }, {
                token: "keyword",
                regex: "#\\s*(?:endif|if|ifdef|else|elif|ifndef)\\b"
            }, {
                token: keywordMapper,
                regex: "[a-zA-Z_$][a-zA-Z0-9_$]*"
            }, {
                token: "keyword.operator",
                regex: /--|\+\+|<<=|>>=|>>>=|<>|&&|\|\||\?:|[*%\/+\-&\^|~!<>=]=?/
            }, {
                token: "punctuation.operator",
                regex: "\\?|\\:|\\,|\\;|\\."
            }, {
                token: "paren.lparen",
                regex: "[[({]"
            }, {
                token: "paren.rparen",
                regex: "[\\])}]"
            }, {
                token: "text",
                regex: "\\s+"
            }
        ],
        "comment": [
            {
                token: "comment",
                regex: "\\*\\/",
                next: "start"
            }, {
                defaultToken: "comment"
            }
        ],
        "singleLineComment": [
            {
                token: "comment",
                regex: /\\$/,
                next: "singleLineComment"
            }, {
                token: "comment",
                regex: /$/,
                next: "start"
            }, {
                defaultToken: "comment"
            }
        ],
        "directive": [
            {
                token: "constant.other.multiline",
                regex: /\\/
            },
            {
                token: "constant.other.multiline",
                regex: /.*\\/
            },
            {
                token: "constant.other",
                regex: "\\s*<.+?>",
                next: "start"
            },
            {
                token: "constant.other",
                regex: '\\s*["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]',
                next: "start"
            },
            {
                token: "constant.other",
                regex: "\\s*['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']",
                next: "start"
            },
            {
                token: "constant.other",
                regex: /[^\\\/]+/,
                next: "start"
            }
        ]
    };
    this.embedRules(DocCommentHighlightRules, "doc-", [DocCommentHighlightRules.getEndRule("start")]);
    this.normalizeRules();
};
oop.inherits(c_cppHighlightRules, TextHighlightRules);
exports.c_cppHighlightRules = c_cppHighlightRules;

});

define("ace/mode/c_cpp",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/c_cpp_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/cstyle"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var c_cppHighlightRules = require("./c_cpp_highlight_rules").c_cppHighlightRules;
var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var CStyleFoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = c_cppHighlightRules;
    this.$outdent = new MatchingBraceOutdent();
    this.$behaviour = this.$defaultBehaviour;
    this.foldingRules = new CStyleFoldMode();
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "//";
    this.blockComment = { start: "/*", end: "*/" };
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        var tokenizedLine = this.getTokenizer().getLineTokens(line, state);
        var tokens = tokenizedLine.tokens;
        var endState = tokenizedLine.state;
        if (tokens.length && tokens[tokens.length - 1].type == "comment") {
            return indent;
        }
        if (state == "start") {
            var match = line.match(/^.*[\{\(\[]\s*$/);
            if (match) {
                indent += tab;
            }
        }
        else if (state == "doc-start") {
            if (endState == "start") {
                return "";
            }
            var match = line.match(/^\s*(\/?)\*/);
            if (match) {
                if (match[1]) {
                    indent += " ";
                }
                indent += "* ";
            }
        }
        return indent;
    };
    this.checkOutdent = function (state, line, input) {
        return this.$outdent.checkOutdent(line, input);
    };
    this.autoOutdent = function (state, doc, row) {
        this.$outdent.autoOutdent(doc, row);
    };
    this.$id = "ace/mode/c_cpp";
    this.snippetFileId = "ace/snippets/c_cpp";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/dart_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY mode_highlight_rules.tmpl.js (UUID: 958518BC-799F-477A-99F9-5B28EBF230F6) */
"use strict";
var oop = require("../lib/oop");
var DocCommentHighlightRules = require("./doc_comment_highlight_rules").DocCommentHighlightRules;
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var DartHighlightRules = function () {
    var constantLanguage = "true|false|null";
    var variableLanguage = "this|super";
    var keywordControl = "try|catch|finally|throw|rethrow|assert|break|case|continue|default|do|else|for|if|in|return|switch|while|new|deferred|async|await";
    var keywordDeclaration = "abstract|class|extends|external|factory|implements|get|native|operator|set|typedef|with|enum";
    var storageModifier = "static|final|const";
    var storageType = "void|bool|num|int|double|dynamic|var|String";
    var keywordMapper = this.createKeywordMapper({
        "constant.language.dart": constantLanguage,
        "variable.language.dart": variableLanguage,
        "keyword.control.dart": keywordControl,
        "keyword.declaration.dart": keywordDeclaration,
        "storage.modifier.dart": storageModifier,
        "storage.type.primitive.dart": storageType
    }, "identifier");
    var stringfill = [{
            token: "constant.language.escape",
            regex: /\\./
        }, {
            token: "text",
            regex: /\$(?:\w+|{[^"'}]+})?/
        }, {
            defaultToken: "string"
        }];
    this.$rules = {
        "start": [
            {
                token: "comment",
                regex: /\/\/.*$/
            },
            DocCommentHighlightRules.getStartRule("doc-start"),
            {
                token: "comment",
                regex: /\/\*/,
                next: "comment"
            },
            {
                token: ["meta.preprocessor.script.dart"],
                regex: "^(#!.*)$"
            },
            {
                token: "keyword.other.import.dart",
                regex: "(?:\\b)(?:library|import|export|part|of|show|hide)(?:\\b)"
            },
            {
                token: ["keyword.other.import.dart", "text"],
                regex: "(?:\\b)(prefix)(\\s*:)"
            },
            {
                regex: "\\bas\\b",
                token: "keyword.cast.dart"
            },
            {
                regex: "\\?|:",
                token: "keyword.control.ternary.dart"
            },
            {
                regex: "(?:\\b)(is\\!?)(?:\\b)",
                token: ["keyword.operator.dart"]
            },
            {
                regex: "(<<|>>>?|~|\\^|\\||&)",
                token: ["keyword.operator.bitwise.dart"]
            },
            {
                regex: "((?:&|\\^|\\||<<|>>>?)=)",
                token: ["keyword.operator.assignment.bitwise.dart"]
            },
            {
                regex: "(===?|!==?|<=?|>=?)",
                token: ["keyword.operator.comparison.dart"]
            },
            {
                regex: "((?:[+*/%-]|\\~)=)",
                token: ["keyword.operator.assignment.arithmetic.dart"]
            },
            {
                regex: "=",
                token: "keyword.operator.assignment.dart"
            },
            {
                token: "string",
                regex: "'''",
                next: "qdoc"
            },
            {
                token: "string",
                regex: '"""',
                next: "qqdoc"
            },
            {
                token: "string",
                regex: "'",
                next: "qstring"
            },
            {
                token: "string",
                regex: '"',
                next: "qqstring"
            },
            {
                regex: "(\\-\\-|\\+\\+)",
                token: ["keyword.operator.increment-decrement.dart"]
            },
            {
                regex: "(\\-|\\+|\\*|\\/|\\~\\/|%)",
                token: ["keyword.operator.arithmetic.dart"]
            },
            {
                regex: "(!|&&|\\|\\|)",
                token: ["keyword.operator.logical.dart"]
            },
            {
                token: "constant.numeric",
                regex: "0[xX][0-9a-fA-F]+\\b"
            },
            {
                token: "constant.numeric",
                regex: "[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"
            },
            {
                token: keywordMapper,
                regex: "[a-zA-Z_$][a-zA-Z0-9_$]*\\b"
            }
        ],
        "comment": [
            {
                token: "comment",
                regex: "\\*\\/",
                next: "start"
            }, {
                defaultToken: "comment"
            }
        ],
        "qdoc": [
            {
                token: "string",
                regex: "'''",
                next: "start"
            }
        ].concat(stringfill),
        "qqdoc": [
            {
                token: "string",
                regex: '"""',
                next: "start"
            }
        ].concat(stringfill),
        "qstring": [
            {
                token: "string",
                regex: "'|$",
                next: "start"
            }
        ].concat(stringfill),
        "qqstring": [
            {
                token: "string",
                regex: '"|$',
                next: "start"
            }
        ].concat(stringfill)
    };
    this.embedRules(DocCommentHighlightRules, "doc-", [DocCommentHighlightRules.getEndRule("start")]);
};
oop.inherits(DartHighlightRules, TextHighlightRules);
exports.DartHighlightRules = DartHighlightRules;

});

define("ace/mode/dart",["require","exports","module","ace/lib/oop","ace/mode/c_cpp","ace/mode/dart_highlight_rules","ace/mode/folding/cstyle"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY mode.tmpl.js
*/
"use strict";
var oop = require("../lib/oop");
var CMode = require("./c_cpp").Mode;
var DartHighlightRules = require("./dart_highlight_rules").DartHighlightRules;
var CStyleFoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    CMode.call(this);
    this.HighlightRules = DartHighlightRules;
    this.foldingRules = new CStyleFoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, CMode);
(function () {
    this.lineCommentStart = "//";
    this.blockComment = { start: "/*", end: "*/" };
    this.$id = "ace/mode/dart";
    this.snippetFileId = "ace/snippets/dart";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/diff_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var DiffHighlightRules = function () {
    this.$rules = {
        "start": [{
                regex: "^(?:\\*{15}|={67}|-{3}|\\+{3})$",
                token: "punctuation.definition.separator.diff",
                "name": "keyword"
            }, {
                regex: "^(@@)(\\s*.+?\\s*)(@@)(.*)$",
                token: [
                    "constant",
                    "constant.numeric",
                    "constant",
                    "comment.doc.tag"
                ]
            }, {
                regex: "^(\\d+)([,\\d]+)(a|d|c)(\\d+)([,\\d]+)(.*)$",
                token: [
                    "constant.numeric",
                    "punctuation.definition.range.diff",
                    "constant.function",
                    "constant.numeric",
                    "punctuation.definition.range.diff",
                    "invalid"
                ],
                "name": "meta."
            }, {
                regex: "^(\\-{3}|\\+{3}|\\*{3})( .+)$",
                token: [
                    "constant.numeric",
                    "meta.tag"
                ]
            }, {
                regex: "^([!+>])(.*?)(\\s*)$",
                token: [
                    "support.constant",
                    "text",
                    "invalid"
                ]
            }, {
                regex: "^([<\\-])(.*?)(\\s*)$",
                token: [
                    "support.function",
                    "string",
                    "invalid"
                ]
            }, {
                regex: "^(diff)(\\s+--\\w+)?(.+?)( .+)?$",
                token: ["variable", "variable", "keyword", "variable"]
            }, {
                regex: "^Index.+$",
                token: "variable"
            }, {
                regex: "^\\s+$",
                token: "text"
            }, {
                regex: "\\s*$",
                token: "invalid"
            }, {
                defaultToken: "invisible",
                caseInsensitive: true
            }
        ]
    };
};
oop.inherits(DiffHighlightRules, TextHighlightRules);
exports.DiffHighlightRules = DiffHighlightRules;

});

define("ace/mode/folding/diff",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range"], function(require, exports, module){"use strict";
var oop = require("../../lib/oop");
var BaseFoldMode = require("./fold_mode").FoldMode;
var Range = require("../../range").Range;
var FoldMode = exports.FoldMode = function (levels, flag) {
    this.regExpList = levels;
    this.flag = flag;
    this.foldingStartMarker = RegExp("^(" + levels.join("|") + ")", this.flag);
};
oop.inherits(FoldMode, BaseFoldMode);
(function () {
    this.getFoldWidgetRange = function (session, foldStyle, row) {
        var line = session.getLine(row);
        var start = { row: row, column: line.length };
        var regList = this.regExpList;
        for (var i = 1; i <= regList.length; i++) {
            var re = RegExp("^(" + regList.slice(0, i).join("|") + ")", this.flag);
            if (re.test(line))
                break;
        }
        for (var l = session.getLength(); ++row < l;) {
            line = session.getLine(row);
            if (re.test(line))
                break;
        }
        if (row == start.row + 1)
            return;
        return new Range(start.row, start.column, row - 1, line.length);
    };
}).call(FoldMode.prototype);

});

define("ace/mode/diff",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/diff_highlight_rules","ace/mode/folding/diff"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var HighlightRules = require("./diff_highlight_rules").DiffHighlightRules;
var FoldMode = require("./folding/diff").FoldMode;
var Mode = function () {
    this.HighlightRules = HighlightRules;
    this.foldingRules = new FoldMode(["diff", "@@|\\*{5}"], "i");
};
oop.inherits(Mode, TextMode);
(function () {
    this.$id = "ace/mode/diff";
    this.snippetFileId = "ace/snippets/diff";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/django",["require","exports","module","ace/lib/oop","ace/mode/html","ace/mode/html_highlight_rules","ace/mode/text_highlight_rules"], function(require, exports, module){var oop = require("../lib/oop");
var HtmlMode = require("./html").Mode;
var HtmlHighlightRules = require("./html_highlight_rules").HtmlHighlightRules;
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var DjangoHighlightRules = function () {
    this.$rules = {
        'start': [{
                token: "string",
                regex: '".*?"'
            }, {
                token: "string",
                regex: "'.*?'"
            }, {
                token: "constant",
                regex: '[0-9]+'
            }, {
                token: "variable",
                regex: "[-_a-zA-Z0-9:]+"
            }],
        'tag': [{
                token: "entity.name.function",
                regex: "[a-zA-Z][_a-zA-Z0-9]*",
                next: "start"
            }]
    };
};
oop.inherits(DjangoHighlightRules, TextHighlightRules);
var DjangoHtmlHighlightRules = function () {
    this.$rules = new HtmlHighlightRules().getRules();
    for (var i in this.$rules) {
        this.$rules[i].unshift({
            token: "comment.line",
            regex: "\\{#.*?#\\}"
        }, {
            token: "comment.block",
            regex: "\\{\\%\\s*comment\\s*\\%\\}",
            merge: true,
            next: "django-comment"
        }, {
            token: "constant.language",
            regex: "\\{\\{",
            next: "django-start"
        }, {
            token: "constant.language",
            regex: "\\{\\%",
            next: "django-tag"
        });
        this.embedRules(DjangoHighlightRules, "django-", [{
                token: "comment.block",
                regex: "\\{\\%\\s*endcomment\\s*\\%\\}",
                merge: true,
                next: "start"
            }, {
                token: "constant.language",
                regex: "\\%\\}",
                next: "start"
            }, {
                token: "constant.language",
                regex: "\\}\\}",
                next: "start"
            }]);
    }
};
oop.inherits(DjangoHtmlHighlightRules, HtmlHighlightRules);
var Mode = function () {
    HtmlMode.call(this);
    this.HighlightRules = DjangoHtmlHighlightRules;
};
oop.inherits(Mode, HtmlMode);
(function () {
    this.$id = "ace/mode/django";
    this.snippetFileId = "ace/snippets/django";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/sh_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var reservedKeywords = exports.reservedKeywords = ('!|{|}|case|do|done|elif|else|' +
    'esac|fi|for|if|in|then|until|while|' +
    '&|;|export|local|read|typeset|unset|' +
    'elif|select|set|function|declare|readonly');
var languageConstructs = exports.languageConstructs = ('[|]|alias|bg|bind|break|builtin|' +
    'cd|command|compgen|complete|continue|' +
    'dirs|disown|echo|enable|eval|exec|' +
    'exit|fc|fg|getopts|hash|help|history|' +
    'jobs|kill|let|logout|popd|printf|pushd|' +
    'pwd|return|set|shift|shopt|source|' +
    'suspend|test|times|trap|type|ulimit|' +
    'umask|unalias|wait');
var ShHighlightRules = function () {
    var keywordMapper = this.createKeywordMapper({
        "keyword": reservedKeywords,
        "support.function.builtin": languageConstructs,
        "invalid.deprecated": "debugger"
    }, "identifier");
    var integer = "(?:(?:[1-9]\\d*)|(?:0))";
    var fraction = "(?:\\.\\d+)";
    var intPart = "(?:\\d+)";
    var pointFloat = "(?:(?:" + intPart + "?" + fraction + ")|(?:" + intPart + "\\.))";
    var exponentFloat = "(?:(?:" + pointFloat + "|" + intPart + ")" + ")";
    var floatNumber = "(?:" + exponentFloat + "|" + pointFloat + ")";
    var fileDescriptor = "(?:&" + intPart + ")";
    var variableName = "[a-zA-Z_][a-zA-Z0-9_]*";
    var variable = "(?:" + variableName + "(?==))";
    var builtinVariable = "(?:\\$(?:SHLVL|\\$|\\!|\\?))";
    var func = "(?:" + variableName + "\\s*\\(\\))";
    this.$rules = {
        "start": [{
                token: "constant",
                regex: /\\./
            }, {
                token: ["text", "comment"],
                regex: /(^|\s)(#.*)$/
            }, {
                token: "string.start",
                regex: '"',
                push: [{
                        token: "constant.language.escape",
                        regex: /\\(?:[$`"\\]|$)/
                    }, {
                        include: "variables"
                    }, {
                        token: "keyword.operator",
                        regex: /`/ // TODO highlight `
                    }, {
                        token: "string.end",
                        regex: '"',
                        next: "pop"
                    }, {
                        defaultToken: "string"
                    }]
            }, {
                token: "string",
                regex: "\\$'",
                push: [{
                        token: "constant.language.escape",
                        regex: /\\(?:[abeEfnrtv\\'"]|x[a-fA-F\d]{1,2}|u[a-fA-F\d]{4}([a-fA-F\d]{4})?|c.|\d{1,3})/
                    }, {
                        token: "string",
                        regex: "'",
                        next: "pop"
                    }, {
                        defaultToken: "string"
                    }]
            }, {
                regex: "<<<",
                token: "keyword.operator"
            }, {
                stateName: "heredoc",
                regex: "(<<-?)(\\s*)(['\"`]?)([\\w\\-]+)(['\"`]?)",
                onMatch: function (value, currentState, stack) {
                    var next = value[2] == '-' ? "indentedHeredoc" : "heredoc";
                    var tokens = value.split(this.splitRegex);
                    stack.push(next, tokens[4]);
                    return [
                        { type: "constant", value: tokens[1] },
                        { type: "text", value: tokens[2] },
                        { type: "string", value: tokens[3] },
                        { type: "support.class", value: tokens[4] },
                        { type: "string", value: tokens[5] }
                    ];
                },
                rules: {
                    heredoc: [{
                            onMatch: function (value, currentState, stack) {
                                if (value === stack[1]) {
                                    stack.shift();
                                    stack.shift();
                                    this.next = stack[0] || "start";
                                    return "support.class";
                                }
                                this.next = "";
                                return "string";
                            },
                            regex: ".*$",
                            next: "start"
                        }],
                    indentedHeredoc: [{
                            token: "string",
                            regex: "^\t+"
                        }, {
                            onMatch: function (value, currentState, stack) {
                                if (value === stack[1]) {
                                    stack.shift();
                                    stack.shift();
                                    this.next = stack[0] || "start";
                                    return "support.class";
                                }
                                this.next = "";
                                return "string";
                            },
                            regex: ".*$",
                            next: "start"
                        }]
                }
            }, {
                regex: "$",
                token: "empty",
                next: function (currentState, stack) {
                    if (stack[0] === "heredoc" || stack[0] === "indentedHeredoc")
                        return stack[0];
                    return currentState;
                }
            }, {
                token: ["keyword", "text", "text", "text", "variable"],
                regex: /(declare|local|readonly)(\s+)(?:(-[fixar]+)(\s+))?([a-zA-Z_][a-zA-Z0-9_]*\b)/
            }, {
                token: "variable.language",
                regex: builtinVariable
            }, {
                token: "variable",
                regex: variable
            }, {
                include: "variables"
            }, {
                token: "support.function",
                regex: func
            }, {
                token: "support.function",
                regex: fileDescriptor
            }, {
                token: "string",
                start: "'", end: "'"
            }, {
                token: "constant.numeric",
                regex: floatNumber
            }, {
                token: "constant.numeric",
                regex: integer + "\\b"
            }, {
                token: keywordMapper,
                regex: "[a-zA-Z_][a-zA-Z0-9_]*\\b"
            }, {
                token: "keyword.operator",
                regex: "\\+|\\-|\\*|\\*\\*|\\/|\\/\\/|~|<|>|<=|=>|=|!=|[%&|`]"
            }, {
                token: "punctuation.operator",
                regex: ";"
            }, {
                token: "paren.lparen",
                regex: "[\\[\\(\\{]"
            }, {
                token: "paren.rparen",
                regex: "[\\]]"
            }, {
                token: "paren.rparen",
                regex: "[\\)\\}]",
                next: "pop"
            }],
        variables: [{
                token: "variable",
                regex: /(\$)(\w+)/
            }, {
                token: ["variable", "paren.lparen"],
                regex: /(\$)(\()/,
                push: "start"
            }, {
                token: ["variable", "paren.lparen", "keyword.operator", "variable", "keyword.operator"],
                regex: /(\$)(\{)([#!]?)(\w+|[*@#?\-$!0_])(:[?+\-=]?|##?|%%?|,,?\/|\^\^?)?/,
                push: "start"
            }, {
                token: "variable",
                regex: /\$[*@#?\-$!0_]/
            }, {
                token: ["variable", "paren.lparen"],
                regex: /(\$)(\{)/,
                push: "start"
            }]
    };
    this.normalizeRules();
};
oop.inherits(ShHighlightRules, TextHighlightRules);
exports.ShHighlightRules = ShHighlightRules;

});

define("ace/mode/sh",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/sh_highlight_rules","ace/range","ace/mode/folding/cstyle"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var ShHighlightRules = require("./sh_highlight_rules").ShHighlightRules;
var Range = require("../range").Range;
var CStyleFoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = ShHighlightRules;
    this.foldingRules = new CStyleFoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "#";
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        var tokenizedLine = this.getTokenizer().getLineTokens(line, state);
        var tokens = tokenizedLine.tokens;
        if (tokens.length && tokens[tokens.length - 1].type == "comment") {
            return indent;
        }
        if (state == "start") {
            var match = line.match(/^.*[\{\(\[:]\s*$/);
            if (match) {
                indent += tab;
            }
        }
        return indent;
    };
    var outdents = {
        "pass": 1,
        "return": 1,
        "raise": 1,
        "break": 1,
        "continue": 1
    };
    this.checkOutdent = function (state, line, input) {
        if (input !== "\r\n" && input !== "\r" && input !== "\n")
            return false;
        var tokens = this.getTokenizer().getLineTokens(line.trim(), state).tokens;
        if (!tokens)
            return false;
        do {
            var last = tokens.pop();
        } while (last && (last.type == "comment" || (last.type == "text" && last.value.match(/^\s+$/))));
        if (!last)
            return false;
        return (last.type == "keyword" && outdents[last.value]);
    };
    this.autoOutdent = function (state, doc, row) {
        row += 1;
        var indent = this.$getIndent(doc.getLine(row));
        var tab = doc.getTabString();
        if (indent.slice(-tab.length) == tab)
            doc.remove(new Range(row, indent.length - tab.length, row, indent.length));
    };
    this.$id = "ace/mode/sh";
    this.snippetFileId = "ace/snippets/sh";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/dockerfile_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/sh_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var ShHighlightRules = require("./sh_highlight_rules").ShHighlightRules;
var DockerfileHighlightRules = function () {
    ShHighlightRules.call(this);
    var startRules = this.$rules.start;
    for (var i = 0; i < startRules.length; i++) {
        if (startRules[i].token == "variable.language") {
            startRules.splice(i, 0, {
                token: "constant.language",
                regex: "(?:^(?:FROM|MAINTAINER|RUN|CMD|EXPOSE|ENV|ADD|ENTRYPOINT|VOLUME|USER|WORKDIR|ONBUILD|COPY|LABEL)\\b)",
                caseInsensitive: true
            });
            break;
        }
    }
};
oop.inherits(DockerfileHighlightRules, ShHighlightRules);
exports.DockerfileHighlightRules = DockerfileHighlightRules;

});

define("ace/mode/dockerfile",["require","exports","module","ace/lib/oop","ace/mode/sh","ace/mode/dockerfile_highlight_rules","ace/mode/folding/cstyle"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var ShMode = require("./sh").Mode;
var DockerfileHighlightRules = require("./dockerfile_highlight_rules").DockerfileHighlightRules;
var CStyleFoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    ShMode.call(this);
    this.HighlightRules = DockerfileHighlightRules;
    this.foldingRules = new CStyleFoldMode();
};
oop.inherits(Mode, ShMode);
(function () {
    this.$id = "ace/mode/dockerfile";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/dot_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules","ace/mode/doc_comment_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var lang = require("../lib/lang");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var DocCommentHighlightRules = require("./doc_comment_highlight_rules").DocCommentHighlightRules;
var DotHighlightRules = function () {
    var keywords = lang.arrayToMap(("strict|node|edge|graph|digraph|subgraph").split("|"));
    var attributes = lang.arrayToMap(("damping|k|url|area|arrowhead|arrowsize|arrowtail|aspect|bb|bgcolor|center|charset|clusterrank|color|colorscheme|comment|compound|concentrate|constraint|decorate|defaultdist|dim|dimen|dir|diredgeconstraints|distortion|dpi|edgeurl|edgehref|edgetarget|edgetooltip|epsilon|esep|fillcolor|fixedsize|fontcolor|fontname|fontnames|fontpath|fontsize|forcelabels|gradientangle|group|headurl|head_lp|headclip|headhref|headlabel|headport|headtarget|headtooltip|height|href|id|image|imagepath|imagescale|label|labelurl|label_scheme|labelangle|labeldistance|labelfloat|labelfontcolor|labelfontname|labelfontsize|labelhref|labeljust|labelloc|labeltarget|labeltooltip|landscape|layer|layerlistsep|layers|layerselect|layersep|layout|len|levels|levelsgap|lhead|lheight|lp|ltail|lwidth|margin|maxiter|mclimit|mindist|minlen|mode|model|mosek|nodesep|nojustify|normalize|nslimit|nslimit1|ordering|orientation|outputorder|overlap|overlap_scaling|pack|packmode|pad|page|pagedir|pencolor|penwidth|peripheries|pin|pos|quadtree|quantum|rank|rankdir|ranksep|ratio|rects|regular|remincross|repulsiveforce|resolution|root|rotate|rotation|samehead|sametail|samplepoints|scale|searchsize|sep|shape|shapefile|showboxes|sides|size|skew|smoothing|sortv|splines|start|style|stylesheet|tailurl|tail_lp|tailclip|tailhref|taillabel|tailport|tailtarget|tailtooltip|target|tooltip|truecolor|vertices|viewport|voro_margin|weight|width|xlabel|xlp|z").split("|"));
    this.$rules = {
        "start": [
            {
                token: "comment",
                regex: /\/\/.*$/
            }, {
                token: "comment",
                regex: /#.*$/
            }, {
                token: "comment",
                merge: true,
                regex: /\/\*/,
                next: "comment"
            }, {
                token: "string",
                regex: "'(?=.)",
                next: "qstring"
            }, {
                token: "string",
                regex: '"(?=.)',
                next: "qqstring"
            }, {
                token: "constant.numeric",
                regex: /[+\-]?\d+(?:(?:\.\d*)?(?:[eE][+\-]?\d+)?)?\b/
            }, {
                token: "keyword.operator",
                regex: /\+|=|\->/
            }, {
                token: "punctuation.operator",
                regex: /,|;/
            }, {
                token: "paren.lparen",
                regex: /[\[{]/
            }, {
                token: "paren.rparen",
                regex: /[\]}]/
            }, {
                token: "comment",
                regex: /^#!.*$/
            }, {
                token: function (value) {
                    if (keywords.hasOwnProperty(value.toLowerCase())) {
                        return "keyword";
                    }
                    else if (attributes.hasOwnProperty(value.toLowerCase())) {
                        return "variable";
                    }
                    else {
                        return "text";
                    }
                },
                regex: "\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"
            }
        ],
        "comment": [
            {
                token: "comment",
                regex: "\\*\\/",
                next: "start"
            }, {
                defaultToken: "comment"
            }
        ],
        "qqstring": [
            {
                token: "string",
                regex: '[^"\\\\]+',
                merge: true
            }, {
                token: "string",
                regex: "\\\\$",
                next: "qqstring",
                merge: true
            }, {
                token: "string",
                regex: '"|$',
                next: "start",
                merge: true
            }
        ],
        "qstring": [
            {
                token: "string",
                regex: "[^'\\\\]+",
                merge: true
            }, {
                token: "string",
                regex: "\\\\$",
                next: "qstring",
                merge: true
            }, {
                token: "string",
                regex: "'|$",
                next: "start",
                merge: true
            }
        ]
    };
};
oop.inherits(DotHighlightRules, TextHighlightRules);
exports.DotHighlightRules = DotHighlightRules;

});

define("ace/mode/dot",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/matching_brace_outdent","ace/mode/dot_highlight_rules","ace/mode/folding/cstyle"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var DotHighlightRules = require("./dot_highlight_rules").DotHighlightRules;
var DotFoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = DotHighlightRules;
    this.$outdent = new MatchingBraceOutdent();
    this.foldingRules = new DotFoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = ["//", "#"];
    this.blockComment = { start: "/*", end: "*/" };
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        var tokenizedLine = this.getTokenizer().getLineTokens(line, state);
        var tokens = tokenizedLine.tokens;
        var endState = tokenizedLine.state;
        if (tokens.length && tokens[tokens.length - 1].type == "comment") {
            return indent;
        }
        if (state == "start") {
            var match = line.match(/^.*(?:\bcase\b.*:|[\{\(\[])\s*$/);
            if (match) {
                indent += tab;
            }
        }
        return indent;
    };
    this.checkOutdent = function (state, line, input) {
        return this.$outdent.checkOutdent(line, input);
    };
    this.autoOutdent = function (state, doc, row) {
        this.$outdent.autoOutdent(doc, row);
    };
    this.$id = "ace/mode/dot";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/eiffel_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var EiffelHighlightRules = function () {
    var keywords = "across|agent|alias|all|attached|as|assign|attribute|check|" +
        "class|convert|create|debug|deferred|detachable|do|else|elseif|end|" +
        "ensure|expanded|export|external|feature|from|frozen|if|inherit|" +
        "inspect|invariant|like|local|loop|not|note|obsolete|old|once|" +
        "Precursor|redefine|rename|require|rescue|retry|select|separate|" +
        "some|then|undefine|until|variant|when";
    var operatorKeywords = "and|implies|or|xor";
    var languageConstants = "Void";
    var booleanConstants = "True|False";
    var languageVariables = "Current|Result";
    var keywordMapper = this.createKeywordMapper({
        "constant.language": languageConstants,
        "constant.language.boolean": booleanConstants,
        "variable.language": languageVariables,
        "keyword.operator": operatorKeywords,
        "keyword": keywords
    }, "identifier", true);
    var simpleString = /(?:[^"%\b\f\v]|%[A-DFHLNQR-V%'"()<>]|%\/(?:0[xX][\da-fA-F](?:_*[\da-fA-F])*|0[cC][0-7](?:_*[0-7])*|0[bB][01](?:_*[01])*|\d(?:_*\d)*)\/)+?/;
    this.$rules = {
        "start": [{
                token: "string.quoted.other",
                regex: /"\[/,
                next: "aligned_verbatim_string"
            }, {
                token: "string.quoted.other",
                regex: /"\{/,
                next: "non-aligned_verbatim_string"
            }, {
                token: "string.quoted.double",
                regex: /"(?:[^%\b\f\n\r\v]|%[A-DFHLNQR-V%'"()<>]|%\/(?:0[xX][\da-fA-F](?:_*[\da-fA-F])*|0[cC][0-7](?:_*[0-7])*|0[bB][01](?:_*[01])*|\d(?:_*\d)*)\/)*?"/
            }, {
                token: "comment.line.double-dash",
                regex: /--.*/
            }, {
                token: "constant.character",
                regex: /'(?:[^%\b\f\n\r\t\v]|%[A-DFHLNQR-V%'"()<>]|%\/(?:0[xX][\da-fA-F](?:_*[\da-fA-F])*|0[cC][0-7](?:_*[0-7])*|0[bB][01](?:_*[01])*|\d(?:_*\d)*)\/)'/
            }, {
                token: "constant.numeric",
                regex: /\b0(?:[xX][\da-fA-F](?:_*[\da-fA-F])*|[cC][0-7](?:_*[0-7])*|[bB][01](?:_*[01])*)\b/
            }, {
                token: "constant.numeric",
                regex: /(?:\d(?:_*\d)*)?\.(?:(?:\d(?:_*\d)*)?[eE][+-]?)?\d(?:_*\d)*|\d(?:_*\d)*\.?/
            }, {
                token: "paren.lparen",
                regex: /[\[({]|<<|\|\(/
            }, {
                token: "paren.rparen",
                regex: /[\])}]|>>|\|\)/
            }, {
                token: "keyword.operator",
                regex: /:=|->|\.(?=\w)|[;,:?]/
            }, {
                token: "keyword.operator",
                regex: /\\\\|\|\.\.\||\.\.|\/[~\/]?|[><\/]=?|[-+*^=~]/
            }, {
                token: function (v) {
                    var result = keywordMapper(v);
                    if (result === "identifier" && v === v.toUpperCase()) {
                        result = "entity.name.type";
                    }
                    return result;
                },
                regex: /[a-zA-Z][a-zA-Z\d_]*\b/
            }, {
                token: "text",
                regex: /\s+/
            }
        ],
        "aligned_verbatim_string": [{
                token: "string",
                regex: /]"/,
                next: "start"
            }, {
                token: "string",
                regex: simpleString
            }
        ],
        "non-aligned_verbatim_string": [{
                token: "string.quoted.other",
                regex: /}"/,
                next: "start"
            }, {
                token: "string.quoted.other",
                regex: simpleString
            }
        ]
    };
};
oop.inherits(EiffelHighlightRules, TextHighlightRules);
exports.EiffelHighlightRules = EiffelHighlightRules;

});

define("ace/mode/eiffel",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/eiffel_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var EiffelHighlightRules = require("./eiffel_highlight_rules").EiffelHighlightRules;
var Mode = function () {
    this.HighlightRules = EiffelHighlightRules;
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "--";
    this.$id = "ace/mode/eiffel";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/elixir_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){/* This file was autogenerated from https://raw.githubusercontent.com/elixir-lang/elixir-tmbundle/master/Syntaxes/Elixir.tmLanguage (uuid: ) */
"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var ElixirHighlightRules = function () {
    this.$rules = { start: [{ token: ['meta.module.elixir',
                    'keyword.control.module.elixir',
                    'meta.module.elixir',
                    'entity.name.type.module.elixir'],
                regex: '^(\\s*)(defmodule)(\\s+)((?:[A-Z]\\w*\\s*\\.\\s*)*[A-Z]\\w*)' },
            { token: 'comment.documentation.heredoc',
                regex: '@(?:module|type)?doc (?:~[a-z])?"""',
                push: [{ token: 'comment.documentation.heredoc',
                        regex: '\\s*"""',
                        next: 'pop' },
                    { include: '#interpolated_elixir' },
                    { include: '#escaped_char' },
                    { defaultToken: 'comment.documentation.heredoc' }],
                comment: '@doc with heredocs is treated as documentation' },
            { token: 'comment.documentation.heredoc',
                regex: '@(?:module|type)?doc ~[A-Z]"""',
                push: [{ token: 'comment.documentation.heredoc',
                        regex: '\\s*"""',
                        next: 'pop' },
                    { defaultToken: 'comment.documentation.heredoc' }],
                comment: '@doc with heredocs is treated as documentation' },
            { token: 'comment.documentation.heredoc',
                regex: '@(?:module|type)?doc (?:~[a-z])?\'\'\'',
                push: [{ token: 'comment.documentation.heredoc',
                        regex: '\\s*\'\'\'',
                        next: 'pop' },
                    { include: '#interpolated_elixir' },
                    { include: '#escaped_char' },
                    { defaultToken: 'comment.documentation.heredoc' }],
                comment: '@doc with heredocs is treated as documentation' },
            { token: 'comment.documentation.heredoc',
                regex: '@(?:module|type)?doc ~[A-Z]\'\'\'',
                push: [{ token: 'comment.documentation.heredoc',
                        regex: '\\s*\'\'\'',
                        next: 'pop' },
                    { defaultToken: 'comment.documentation.heredoc' }],
                comment: '@doc with heredocs is treated as documentation' },
            { token: 'comment.documentation.false',
                regex: '@(?:module|type)?doc false',
                comment: '@doc false is treated as documentation' },
            { token: 'comment.documentation.string',
                regex: '@(?:module|type)?doc "',
                push: [{ token: 'comment.documentation.string',
                        regex: '"',
                        next: 'pop' },
                    { include: '#interpolated_elixir' },
                    { include: '#escaped_char' },
                    { defaultToken: 'comment.documentation.string' }],
                comment: '@doc with string is treated as documentation' },
            { token: 'keyword.control.elixir',
                regex: '\\b(?:do|end|case|bc|lc|for|if|cond|unless|try|receive|fn|defmodule|defp?|defprotocol|defimpl|defrecord|defstruct|defmacrop?|defdelegate|defcallback|defmacrocallback|defexception|defoverridable|exit|after|rescue|catch|else|raise|throw|import|require|alias|use|quote|unquote|super)\\b(?![?!])',
                TODO: 'FIXME: regexp doesn\'t have js equivalent',
                originalRegex: '(?<!\\.)\\b(do|end|case|bc|lc|for|if|cond|unless|try|receive|fn|defmodule|defp?|defprotocol|defimpl|defrecord|defstruct|defmacrop?|defdelegate|defcallback|defmacrocallback|defexception|defoverridable|exit|after|rescue|catch|else|raise|throw|import|require|alias|use|quote|unquote|super)\\b(?![?!])' },
            { token: 'keyword.operator.elixir',
                regex: '\\b(?:and|not|or|when|xor|in|inlist|inbits)\\b',
                TODO: 'FIXME: regexp doesn\'t have js equivalent',
                originalRegex: '(?<!\\.)\\b(and|not|or|when|xor|in|inlist|inbits)\\b',
                comment: ' as above, just doesn\'t need a \'end\' and does a logic operation' },
            { token: 'constant.language.elixir',
                regex: '\\b(?:nil|true|false)\\b(?![?!])' },
            { token: 'variable.language.elixir',
                regex: '\\b__(?:CALLER|ENV|MODULE|DIR)__\\b(?![?!])' },
            { token: ['punctuation.definition.variable.elixir',
                    'variable.other.readwrite.module.elixir'],
                regex: '(@)([a-zA-Z_]\\w*)' },
            { token: ['punctuation.definition.variable.elixir',
                    'variable.other.anonymous.elixir'],
                regex: '(&)(\\d*)' },
            { token: 'variable.other.constant.elixir',
                regex: '\\b[A-Z]\\w*\\b' },
            { token: 'constant.numeric.elixir',
                regex: '\\b(?:0x[\\da-fA-F](?:_?[\\da-fA-F])*|\\d(?:_?\\d)*(?:\\.(?![^[:space:][:digit:]])(?:_?\\d)*)?(?:[eE][-+]?\\d(?:_?\\d)*)?|0b[01]+|0o[0-7]+)\\b',
                TODO: 'FIXME: regexp doesn\'t have js equivalent',
                originalRegex: '\\b(0x\\h(?>_?\\h)*|\\d(?>_?\\d)*(\\.(?![^[:space:][:digit:]])(?>_?\\d)*)?([eE][-+]?\\d(?>_?\\d)*)?|0b[01]+|0o[0-7]+)\\b' },
            { token: 'punctuation.definition.constant.elixir',
                regex: ':\'',
                push: [{ token: 'punctuation.definition.constant.elixir',
                        regex: '\'',
                        next: 'pop' },
                    { include: '#interpolated_elixir' },
                    { include: '#escaped_char' },
                    { defaultToken: 'constant.other.symbol.single-quoted.elixir' }] },
            { token: 'punctuation.definition.constant.elixir',
                regex: ':"',
                push: [{ token: 'punctuation.definition.constant.elixir',
                        regex: '"',
                        next: 'pop' },
                    { include: '#interpolated_elixir' },
                    { include: '#escaped_char' },
                    { defaultToken: 'constant.other.symbol.double-quoted.elixir' }] },
            { token: 'punctuation.definition.string.begin.elixir',
                regex: '(?:\'\'\')',
                TODO: 'FIXME: regexp doesn\'t have js equivalent',
                originalRegex: '(?>\'\'\')',
                push: [{ token: 'punctuation.definition.string.end.elixir',
                        regex: '^\\s*\'\'\'',
                        next: 'pop' },
                    { include: '#interpolated_elixir' },
                    { include: '#escaped_char' },
                    { defaultToken: 'support.function.variable.quoted.single.heredoc.elixir' }],
                comment: 'Single-quoted heredocs' },
            { token: 'punctuation.definition.string.begin.elixir',
                regex: '\'',
                push: [{ token: 'punctuation.definition.string.end.elixir',
                        regex: '\'',
                        next: 'pop' },
                    { include: '#interpolated_elixir' },
                    { include: '#escaped_char' },
                    { defaultToken: 'support.function.variable.quoted.single.elixir' }],
                comment: 'single quoted string (allows for interpolation)' },
            { token: 'punctuation.definition.string.begin.elixir',
                regex: '(?:""")',
                TODO: 'FIXME: regexp doesn\'t have js equivalent',
                originalRegex: '(?>""")',
                push: [{ token: 'punctuation.definition.string.end.elixir',
                        regex: '^\\s*"""',
                        next: 'pop' },
                    { include: '#interpolated_elixir' },
                    { include: '#escaped_char' },
                    { defaultToken: 'string.quoted.double.heredoc.elixir' }],
                comment: 'Double-quoted heredocs' },
            { token: 'punctuation.definition.string.begin.elixir',
                regex: '"',
                push: [{ token: 'punctuation.definition.string.end.elixir',
                        regex: '"',
                        next: 'pop' },
                    { include: '#interpolated_elixir' },
                    { include: '#escaped_char' },
                    { defaultToken: 'string.quoted.double.elixir' }],
                comment: 'double quoted string (allows for interpolation)' },
            { token: 'punctuation.definition.string.begin.elixir',
                regex: '~[a-z](?:""")',
                TODO: 'FIXME: regexp doesn\'t have js equivalent',
                originalRegex: '~[a-z](?>""")',
                push: [{ token: 'punctuation.definition.string.end.elixir',
                        regex: '^\\s*"""',
                        next: 'pop' },
                    { include: '#interpolated_elixir' },
                    { include: '#escaped_char' },
                    { defaultToken: 'string.quoted.double.heredoc.elixir' }],
                comment: 'Double-quoted heredocs sigils' },
            { token: 'punctuation.definition.string.begin.elixir',
                regex: '~[a-z]\\{',
                push: [{ token: 'punctuation.definition.string.end.elixir',
                        regex: '\\}[a-z]*',
                        next: 'pop' },
                    { include: '#interpolated_elixir' },
                    { include: '#escaped_char' },
                    { defaultToken: 'string.interpolated.elixir' }],
                comment: 'sigil (allow for interpolation)' },
            { token: 'punctuation.definition.string.begin.elixir',
                regex: '~[a-z]\\[',
                push: [{ token: 'punctuation.definition.string.end.elixir',
                        regex: '\\][a-z]*',
                        next: 'pop' },
                    { include: '#interpolated_elixir' },
                    { include: '#escaped_char' },
                    { defaultToken: 'string.interpolated.elixir' }],
                comment: 'sigil (allow for interpolation)' },
            { token: 'punctuation.definition.string.begin.elixir',
                regex: '~[a-z]\\<',
                push: [{ token: 'punctuation.definition.string.end.elixir',
                        regex: '\\>[a-z]*',
                        next: 'pop' },
                    { include: '#interpolated_elixir' },
                    { include: '#escaped_char' },
                    { defaultToken: 'string.interpolated.elixir' }],
                comment: 'sigil (allow for interpolation)' },
            { token: 'punctuation.definition.string.begin.elixir',
                regex: '~[a-z]\\(',
                push: [{ token: 'punctuation.definition.string.end.elixir',
                        regex: '\\)[a-z]*',
                        next: 'pop' },
                    { include: '#interpolated_elixir' },
                    { include: '#escaped_char' },
                    { defaultToken: 'string.interpolated.elixir' }],
                comment: 'sigil (allow for interpolation)' },
            { token: 'punctuation.definition.string.begin.elixir',
                regex: '~[a-z][^\\w]',
                push: [{ token: 'punctuation.definition.string.end.elixir',
                        regex: '[^\\w][a-z]*',
                        next: 'pop' },
                    { include: '#interpolated_elixir' },
                    { include: '#escaped_char' },
                    { include: '#escaped_char' },
                    { defaultToken: 'string.interpolated.elixir' }],
                comment: 'sigil (allow for interpolation)' },
            { token: 'punctuation.definition.string.begin.elixir',
                regex: '~[A-Z](?:""")',
                TODO: 'FIXME: regexp doesn\'t have js equivalent',
                originalRegex: '~[A-Z](?>""")',
                push: [{ token: 'punctuation.definition.string.end.elixir',
                        regex: '^\\s*"""',
                        next: 'pop' },
                    { defaultToken: 'string.quoted.other.literal.upper.elixir' }],
                comment: 'Double-quoted heredocs sigils' },
            { token: 'punctuation.definition.string.begin.elixir',
                regex: '~[A-Z]\\{',
                push: [{ token: 'punctuation.definition.string.end.elixir',
                        regex: '\\}[a-z]*',
                        next: 'pop' },
                    { defaultToken: 'string.quoted.other.literal.upper.elixir' }],
                comment: 'sigil (without interpolation)' },
            { token: 'punctuation.definition.string.begin.elixir',
                regex: '~[A-Z]\\[',
                push: [{ token: 'punctuation.definition.string.end.elixir',
                        regex: '\\][a-z]*',
                        next: 'pop' },
                    { defaultToken: 'string.quoted.other.literal.upper.elixir' }],
                comment: 'sigil (without interpolation)' },
            { token: 'punctuation.definition.string.begin.elixir',
                regex: '~[A-Z]\\<',
                push: [{ token: 'punctuation.definition.string.end.elixir',
                        regex: '\\>[a-z]*',
                        next: 'pop' },
                    { defaultToken: 'string.quoted.other.literal.upper.elixir' }],
                comment: 'sigil (without interpolation)' },
            { token: 'punctuation.definition.string.begin.elixir',
                regex: '~[A-Z]\\(',
                push: [{ token: 'punctuation.definition.string.end.elixir',
                        regex: '\\)[a-z]*',
                        next: 'pop' },
                    { defaultToken: 'string.quoted.other.literal.upper.elixir' }],
                comment: 'sigil (without interpolation)' },
            { token: 'punctuation.definition.string.begin.elixir',
                regex: '~[A-Z][^\\w]',
                push: [{ token: 'punctuation.definition.string.end.elixir',
                        regex: '[^\\w][a-z]*',
                        next: 'pop' },
                    { defaultToken: 'string.quoted.other.literal.upper.elixir' }],
                comment: 'sigil (without interpolation)' },
            { token: ['punctuation.definition.constant.elixir', 'constant.other.symbol.elixir'],
                regex: '(:)([a-zA-Z_][\\w@]*(?:[?!]|=(?![>=]))?|\\<\\>|===?|!==?|<<>>|<<<|>>>|~~~|::|<\\-|\\|>|=>|~|~=|=|/|\\\\\\\\|\\*\\*?|\\.\\.?\\.?|>=?|<=?|&&?&?|\\+\\+?|\\-\\-?|\\|\\|?\\|?|\\!|@|\\%?\\{\\}|%|\\[\\]|\\^(?:\\^\\^)?)',
                TODO: 'FIXME: regexp doesn\'t have js equivalent',
                originalRegex: '(?<!:)(:)(?>[a-zA-Z_][\\w@]*(?>[?!]|=(?![>=]))?|\\<\\>|===?|!==?|<<>>|<<<|>>>|~~~|::|<\\-|\\|>|=>|~|~=|=|/|\\\\\\\\|\\*\\*?|\\.\\.?\\.?|>=?|<=?|&&?&?|\\+\\+?|\\-\\-?|\\|\\|?\\|?|\\!|@|\\%?\\{\\}|%|\\[\\]|\\^(\\^\\^)?)',
                comment: 'symbols' },
            { token: 'punctuation.definition.constant.elixir',
                regex: '(?:[a-zA-Z_][\\w@]*(?:[?!])?):(?!:)',
                TODO: 'FIXME: regexp doesn\'t have js equivalent',
                originalRegex: '(?>[a-zA-Z_][\\w@]*(?>[?!])?)(:)(?!:)',
                comment: 'symbols' },
            { token: ['punctuation.definition.comment.elixir',
                    'comment.line.number-sign.elixir'],
                regex: '(#)(.*)' },
            { token: 'constant.numeric.elixir',
                regex: '\\?(?:\\\\(?:x[\\da-fA-F]{1,2}(?![\\da-fA-F])\\b|[^xMC])|[^\\s\\\\])',
                TODO: 'FIXME: regexp doesn\'t have js equivalent',
                originalRegex: '(?<!\\w)\\?(\\\\(x\\h{1,2}(?!\\h)\\b|[^xMC])|[^\\s\\\\])',
                comment: '\n\t\t\tmatches questionmark-letters.\n\n\t\t\texamples (1st alternation = hex):\n\t\t\t?\\x1     ?\\x61\n\n\t\t\texamples (2rd alternation = escaped):\n\t\t\t?\\n      ?\\b\n\n\t\t\texamples (3rd alternation = normal):\n\t\t\t?a       ?A       ?0 \n\t\t\t?*       ?"       ?( \n\t\t\t?.       ?#\n\t\t\t\n\t\t\tthe negative lookbehind prevents against matching\n\t\t\tp(42.tainted?)\n\t\t\t' },
            { token: 'keyword.operator.assignment.augmented.elixir',
                regex: '\\+=|\\-=|\\|\\|=|~=|&&=' },
            { token: 'keyword.operator.comparison.elixir',
                regex: '===?|!==?|<=?|>=?' },
            { token: 'keyword.operator.bitwise.elixir',
                regex: '\\|{3}|&{3}|\\^{3}|<{3}|>{3}|~{3}' },
            { token: 'keyword.operator.logical.elixir',
                regex: '!+|\\bnot\\b|&&|\\band\\b|\\|\\||\\bor\\b|\\bxor\\b',
                originalRegex: '(?<=[ \\t])!+|\\bnot\\b|&&|\\band\\b|\\|\\||\\bor\\b|\\bxor\\b' },
            { token: 'keyword.operator.arithmetic.elixir',
                regex: '\\*|\\+|\\-|/' },
            { token: 'keyword.operator.other.elixir',
                regex: '\\||\\+\\+|\\-\\-|\\*\\*|\\\\\\\\|\\<\\-|\\<\\>|\\<\\<|\\>\\>|\\:\\:|\\.\\.|\\|>|~|=>' },
            { token: 'keyword.operator.assignment.elixir', regex: '=' },
            { token: 'punctuation.separator.other.elixir', regex: ':' },
            { token: 'punctuation.separator.statement.elixir',
                regex: '\\;' },
            { token: 'punctuation.separator.object.elixir', regex: ',' },
            { token: 'punctuation.separator.method.elixir', regex: '\\.' },
            { token: 'punctuation.section.scope.elixir', regex: '\\{|\\}' },
            { token: 'punctuation.section.array.elixir', regex: '\\[|\\]' },
            { token: 'punctuation.section.function.elixir',
                regex: '\\(|\\)' }],
        '#escaped_char': [{ token: 'constant.character.escape.elixir',
                regex: '\\\\(?:x[\\da-fA-F]{1,2}|.)' }],
        '#interpolated_elixir': [{ token: ['source.elixir.embedded.source',
                    'source.elixir.embedded.source.empty'],
                regex: '(#\\{)(\\})' },
            { todo: { token: 'punctuation.section.embedded.elixir',
                    regex: '#\\{',
                    push: [{ token: 'punctuation.section.embedded.elixir',
                            regex: '\\}',
                            next: 'pop' },
                        { include: '#nest_curly_and_self' },
                        { include: '$self' },
                        { defaultToken: 'source.elixir.embedded.source' }] } }],
        '#nest_curly_and_self': [{ token: 'punctuation.section.scope.elixir',
                regex: '\\{',
                push: [{ token: 'punctuation.section.scope.elixir',
                        regex: '\\}',
                        next: 'pop' },
                    { include: '#nest_curly_and_self' }] },
            { include: '$self' }],
        '#regex_sub': [{ include: '#interpolated_elixir' },
            { include: '#escaped_char' },
            { token: ['punctuation.definition.arbitrary-repitition.elixir',
                    'string.regexp.arbitrary-repitition.elixir',
                    'string.regexp.arbitrary-repitition.elixir',
                    'punctuation.definition.arbitrary-repitition.elixir'],
                regex: '(\\{)(\\d+)((?:,\\d+)?)(\\})' },
            { token: 'punctuation.definition.character-class.elixir',
                regex: '\\[(?:\\^?\\])?',
                push: [{ token: 'punctuation.definition.character-class.elixir',
                        regex: '\\]',
                        next: 'pop' },
                    { include: '#escaped_char' },
                    { defaultToken: 'string.regexp.character-class.elixir' }] },
            { token: 'punctuation.definition.group.elixir',
                regex: '\\(',
                push: [{ token: 'punctuation.definition.group.elixir',
                        regex: '\\)',
                        next: 'pop' },
                    { include: '#regex_sub' },
                    { defaultToken: 'string.regexp.group.elixir' }] },
            { token: ['punctuation.definition.comment.elixir',
                    'comment.line.number-sign.elixir'],
                regex: '(?:^|\\s)(#)(\\s[[a-zA-Z0-9,. \\t?!-][^\\x00-\\x7F]]*$)',
                originalRegex: '(?<=^|\\s)(#)\\s[[a-zA-Z0-9,. \\t?!-][^\\x{00}-\\x{7F}]]*$',
                comment: 'We are restrictive in what we allow to go after the comment character to avoid false positives, since the availability of comments depend on regexp flags.' }] };
    this.normalizeRules();
};
ElixirHighlightRules.metaData = { comment: 'Textmate bundle for Elixir Programming Language.',
    fileTypes: ['ex', 'exs'],
    firstLineMatch: '^#!/.*\\belixir',
    foldingStartMarker: '(after|else|catch|rescue|\\-\\>|\\{|\\[|do)\\s*$',
    foldingStopMarker: '^\\s*((\\}|\\]|after|else|catch|rescue)\\s*$|end\\b)',
    keyEquivalent: '^~E',
    name: 'Elixir',
    scopeName: 'source.elixir' };
oop.inherits(ElixirHighlightRules, TextHighlightRules);
exports.ElixirHighlightRules = ElixirHighlightRules;

});

define("ace/mode/elixir",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/elixir_highlight_rules","ace/mode/folding/coffee"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY mode.tmpl.js
*/
"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var ElixirHighlightRules = require("./elixir_highlight_rules").ElixirHighlightRules;
var FoldMode = require("./folding/coffee").FoldMode;
var Mode = function () {
    this.HighlightRules = ElixirHighlightRules;
    this.foldingRules = new FoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "#";
    this.$id = "ace/mode/elixir";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/elm_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){// TODO check with https://github.com/deadfoxygrandpa/Elm.tmLanguage
"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var ElmHighlightRules = function () {
    var keywordMapper = this.createKeywordMapper({
        "keyword": "as|case|class|data|default|deriving|do|else|export|foreign|" +
            "hiding|jsevent|if|import|in|infix|infixl|infixr|instance|let|" +
            "module|newtype|of|open|then|type|where|_|port|\u03BB"
    }, "identifier");
    var escapeRe = /\\(\d+|['"\\&trnbvf])/;
    var smallRe = /[a-z_]/.source;
    var largeRe = /[A-Z]/.source;
    var idRe = /[a-z_A-Z0-9']/.source;
    this.$rules = {
        start: [{
                token: "string.start",
                regex: '"',
                next: "string"
            }, {
                token: "string.character",
                regex: "'(?:" + escapeRe.source + "|.)'?"
            }, {
                regex: /0(?:[xX][0-9A-Fa-f]+|[oO][0-7]+)|\d+(\.\d+)?([eE][-+]?\d*)?/,
                token: "constant.numeric"
            }, {
                token: "comment",
                regex: "--.*"
            }, {
                token: "keyword",
                regex: /\.\.|\||:|=|\\|"|->|<-|\u2192/
            }, {
                token: "keyword.operator",
                regex: /[-!#$%&*+.\/<=>?@\\^|~:\u03BB\u2192]+/
            }, {
                token: "operator.punctuation",
                regex: /[,;`]/
            }, {
                regex: largeRe + idRe + "+\\.?",
                token: function (value) {
                    if (value[value.length - 1] == ".")
                        return "entity.name.function";
                    return "constant.language";
                }
            }, {
                regex: "^" + smallRe + idRe + "+",
                token: function (value) {
                    return "constant.language";
                }
            }, {
                token: keywordMapper,
                regex: "[\\w\\xff-\\u218e\\u2455-\\uffff]+\\b"
            }, {
                regex: "{-#?",
                token: "comment.start",
                onMatch: function (value, currentState, stack) {
                    this.next = value.length == 2 ? "blockComment" : "docComment";
                    return this.token;
                }
            }, {
                token: "variable.language",
                regex: /\[markdown\|/,
                next: "markdown"
            }, {
                token: "paren.lparen",
                regex: /[\[({]/
            }, {
                token: "paren.rparen",
                regex: /[\])}]/
            }],
        markdown: [{
                regex: /\|\]/,
                next: "start"
            }, {
                defaultToken: "string"
            }],
        blockComment: [{
                regex: "{-",
                token: "comment.start",
                push: "blockComment"
            }, {
                regex: "-}",
                token: "comment.end",
                next: "pop"
            }, {
                defaultToken: "comment"
            }],
        docComment: [{
                regex: "{-",
                token: "comment.start",
                push: "docComment"
            }, {
                regex: "-}",
                token: "comment.end",
                next: "pop"
            }, {
                defaultToken: "doc.comment"
            }],
        string: [{
                token: "constant.language.escape",
                regex: escapeRe
            }, {
                token: "text",
                regex: /\\(\s|$)/,
                next: "stringGap"
            }, {
                token: "string.end",
                regex: '"',
                next: "start"
            }, {
                defaultToken: "string"
            }],
        stringGap: [{
                token: "text",
                regex: /\\/,
                next: "string"
            }, {
                token: "error",
                regex: "",
                next: "start"
            }]
    };
    this.normalizeRules();
};
oop.inherits(ElmHighlightRules, TextHighlightRules);
exports.ElmHighlightRules = ElmHighlightRules;

});

define("ace/mode/elm",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/elm_highlight_rules","ace/mode/folding/cstyle"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY mode.tmpl.js
*/
"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var HighlightRules = require("./elm_highlight_rules").ElmHighlightRules;
var FoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = HighlightRules;
    this.foldingRules = new FoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "--";
    this.blockComment = { start: "{-", end: "-}", nestable: true };
    this.$id = "ace/mode/elm";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/erlang_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){/* This file was autogenerated from tm bundles\erlang.tmbundle\Syntaxes\Erlang.plist (uuid: ) */
"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var ErlangHighlightRules = function () {
    this.$rules = { start: [{ include: '#module-directive' },
            { include: '#import-export-directive' },
            { include: '#behaviour-directive' },
            { include: '#record-directive' },
            { include: '#define-directive' },
            { include: '#macro-directive' },
            { include: '#directive' },
            { include: '#function' },
            { include: '#everything-else' }],
        '#atom': [{ token: 'punctuation.definition.symbol.begin.erlang',
                regex: '\'',
                push: [{ token: 'punctuation.definition.symbol.end.erlang',
                        regex: '\'',
                        next: 'pop' },
                    { token: ['punctuation.definition.escape.erlang',
                            'constant.other.symbol.escape.erlang',
                            'punctuation.definition.escape.erlang',
                            'constant.other.symbol.escape.erlang',
                            'constant.other.symbol.escape.erlang'],
                        regex: '(\\\\)(?:([bdefnrstv\\\\\'"])|(\\^)([@-_])|([0-7]{1,3}))' },
                    { token: 'invalid.illegal.atom.erlang', regex: '\\\\\\^?.?' },
                    { defaultToken: 'constant.other.symbol.quoted.single.erlang' }] },
            { token: 'constant.other.symbol.unquoted.erlang',
                regex: '[a-z][a-zA-Z\\d@_]*' }],
        '#behaviour-directive': [{ token: ['meta.directive.behaviour.erlang',
                    'punctuation.section.directive.begin.erlang',
                    'meta.directive.behaviour.erlang',
                    'keyword.control.directive.behaviour.erlang',
                    'meta.directive.behaviour.erlang',
                    'punctuation.definition.parameters.begin.erlang',
                    'meta.directive.behaviour.erlang',
                    'entity.name.type.class.behaviour.definition.erlang',
                    'meta.directive.behaviour.erlang',
                    'punctuation.definition.parameters.end.erlang',
                    'meta.directive.behaviour.erlang',
                    'punctuation.section.directive.end.erlang'],
                regex: '^(\\s*)(-)(\\s*)(behaviour)(\\s*)(\\()(\\s*)([a-z][a-zA-Z\\d@_]*)(\\s*)(\\))(\\s*)(\\.)' }],
        '#binary': [{ token: 'punctuation.definition.binary.begin.erlang',
                regex: '<<',
                push: [{ token: 'punctuation.definition.binary.end.erlang',
                        regex: '>>',
                        next: 'pop' },
                    { token: ['punctuation.separator.binary.erlang',
                            'punctuation.separator.value-size.erlang'],
                        regex: '(,)|(:)' },
                    { include: '#internal-type-specifiers' },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.structure.binary.erlang' }] }],
        '#character': [{ token: ['punctuation.definition.character.erlang',
                    'punctuation.definition.escape.erlang',
                    'constant.character.escape.erlang',
                    'punctuation.definition.escape.erlang',
                    'constant.character.escape.erlang',
                    'constant.character.escape.erlang'],
                regex: '(\\$)(\\\\)(?:([bdefnrstv\\\\\'"])|(\\^)([@-_])|([0-7]{1,3}))' },
            { token: 'invalid.illegal.character.erlang',
                regex: '\\$\\\\\\^?.?' },
            { token: ['punctuation.definition.character.erlang',
                    'constant.character.erlang'],
                regex: '(\\$)(\\S)' },
            { token: 'invalid.illegal.character.erlang', regex: '\\$.?' }],
        '#comment': [{ token: 'punctuation.definition.comment.erlang',
                regex: '%.*$',
                push_: [{ token: 'comment.line.percentage.erlang',
                        regex: '$',
                        next: 'pop' },
                    { defaultToken: 'comment.line.percentage.erlang' }] }],
        '#define-directive': [{ token: ['meta.directive.define.erlang',
                    'punctuation.section.directive.begin.erlang',
                    'meta.directive.define.erlang',
                    'keyword.control.directive.define.erlang',
                    'meta.directive.define.erlang',
                    'punctuation.definition.parameters.begin.erlang',
                    'meta.directive.define.erlang',
                    'entity.name.function.macro.definition.erlang',
                    'meta.directive.define.erlang',
                    'punctuation.separator.parameters.erlang'],
                regex: '^(\\s*)(-)(\\s*)(define)(\\s*)(\\()(\\s*)([a-zA-Z\\d@_]+)(\\s*)(,)',
                push: [{ token: ['punctuation.definition.parameters.end.erlang',
                            'meta.directive.define.erlang',
                            'punctuation.section.directive.end.erlang'],
                        regex: '(\\))(\\s*)(\\.)',
                        next: 'pop' },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.directive.define.erlang' }] },
            { token: 'meta.directive.define.erlang',
                regex: '(?=^\\s*-\\s*define\\s*\\(\\s*[a-zA-Z\\d@_]+\\s*\\()',
                push: [{ token: ['punctuation.definition.parameters.end.erlang',
                            'meta.directive.define.erlang',
                            'punctuation.section.directive.end.erlang'],
                        regex: '(\\))(\\s*)(\\.)',
                        next: 'pop' },
                    { token: ['text',
                            'punctuation.section.directive.begin.erlang',
                            'text',
                            'keyword.control.directive.define.erlang',
                            'text',
                            'punctuation.definition.parameters.begin.erlang',
                            'text',
                            'entity.name.function.macro.definition.erlang',
                            'text',
                            'punctuation.definition.parameters.begin.erlang'],
                        regex: '^(\\s*)(-)(\\s*)(define)(\\s*)(\\()(\\s*)([a-zA-Z\\d@_]+)(\\s*)(\\()',
                        push: [{ token: ['punctuation.definition.parameters.end.erlang',
                                    'text',
                                    'punctuation.separator.parameters.erlang'],
                                regex: '(\\))(\\s*)(,)',
                                next: 'pop' },
                            { token: 'punctuation.separator.parameters.erlang', regex: ',' },
                            { include: '#everything-else' }] },
                    { token: 'punctuation.separator.define.erlang',
                        regex: '\\|\\||\\||:|;|,|\\.|->' },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.directive.define.erlang' }] }],
        '#directive': [{ token: ['meta.directive.erlang',
                    'punctuation.section.directive.begin.erlang',
                    'meta.directive.erlang',
                    'keyword.control.directive.erlang',
                    'meta.directive.erlang',
                    'punctuation.definition.parameters.begin.erlang'],
                regex: '^(\\s*)(-)(\\s*)([a-z][a-zA-Z\\d@_]*)(\\s*)(\\(?)',
                push: [{ token: ['punctuation.definition.parameters.end.erlang',
                            'meta.directive.erlang',
                            'punctuation.section.directive.end.erlang'],
                        regex: '(\\)?)(\\s*)(\\.)',
                        next: 'pop' },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.directive.erlang' }] },
            { token: ['meta.directive.erlang',
                    'punctuation.section.directive.begin.erlang',
                    'meta.directive.erlang',
                    'keyword.control.directive.erlang',
                    'meta.directive.erlang',
                    'punctuation.section.directive.end.erlang'],
                regex: '^(\\s*)(-)(\\s*)([a-z][a-zA-Z\\d@_]*)(\\s*)(\\.)' }],
        '#everything-else': [{ include: '#comment' },
            { include: '#record-usage' },
            { include: '#macro-usage' },
            { include: '#expression' },
            { include: '#keyword' },
            { include: '#textual-operator' },
            { include: '#function-call' },
            { include: '#tuple' },
            { include: '#list' },
            { include: '#binary' },
            { include: '#parenthesized-expression' },
            { include: '#character' },
            { include: '#number' },
            { include: '#atom' },
            { include: '#string' },
            { include: '#symbolic-operator' },
            { include: '#variable' }],
        '#expression': [{ token: 'keyword.control.if.erlang',
                regex: '\\bif\\b',
                push: [{ token: 'keyword.control.end.erlang',
                        regex: '\\bend\\b',
                        next: 'pop' },
                    { include: '#internal-expression-punctuation' },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.expression.if.erlang' }] },
            { token: 'keyword.control.case.erlang',
                regex: '\\bcase\\b',
                push: [{ token: 'keyword.control.end.erlang',
                        regex: '\\bend\\b',
                        next: 'pop' },
                    { include: '#internal-expression-punctuation' },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.expression.case.erlang' }] },
            { token: 'keyword.control.receive.erlang',
                regex: '\\breceive\\b',
                push: [{ token: 'keyword.control.end.erlang',
                        regex: '\\bend\\b',
                        next: 'pop' },
                    { include: '#internal-expression-punctuation' },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.expression.receive.erlang' }] },
            { token: ['keyword.control.fun.erlang',
                    'text',
                    'entity.name.type.class.module.erlang',
                    'text',
                    'punctuation.separator.module-function.erlang',
                    'text',
                    'entity.name.function.erlang',
                    'text',
                    'punctuation.separator.function-arity.erlang'],
                regex: '\\b(fun)(\\s*)(?:([a-z][a-zA-Z\\d@_]*)(\\s*)(:)(\\s*))?([a-z][a-zA-Z\\d@_]*)(\\s*)(/)' },
            { token: 'keyword.control.fun.erlang',
                regex: '\\bfun\\b',
                push: [{ token: 'keyword.control.end.erlang',
                        regex: '\\bend\\b',
                        next: 'pop' },
                    { token: 'text',
                        regex: '(?=\\()',
                        push: [{ token: 'punctuation.separator.clauses.erlang',
                                regex: ';|(?=\\bend\\b)',
                                next: 'pop' },
                            { include: '#internal-function-parts' }] },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.expression.fun.erlang' }] },
            { token: 'keyword.control.try.erlang',
                regex: '\\btry\\b',
                push: [{ token: 'keyword.control.end.erlang',
                        regex: '\\bend\\b',
                        next: 'pop' },
                    { include: '#internal-expression-punctuation' },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.expression.try.erlang' }] },
            { token: 'keyword.control.begin.erlang',
                regex: '\\bbegin\\b',
                push: [{ token: 'keyword.control.end.erlang',
                        regex: '\\bend\\b',
                        next: 'pop' },
                    { include: '#internal-expression-punctuation' },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.expression.begin.erlang' }] },
            { token: 'keyword.control.query.erlang',
                regex: '\\bquery\\b',
                push: [{ token: 'keyword.control.end.erlang',
                        regex: '\\bend\\b',
                        next: 'pop' },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.expression.query.erlang' }] }],
        '#function': [{ token: ['meta.function.erlang',
                    'entity.name.function.definition.erlang',
                    'meta.function.erlang'],
                regex: '^(\\s*)([a-z][a-zA-Z\\d@_]*|\'[^\']*\')(\\s*)(?=\\()',
                push: [{ token: 'punctuation.terminator.function.erlang',
                        regex: '\\.',
                        next: 'pop' },
                    { token: ['text', 'entity.name.function.erlang', 'text'],
                        regex: '^(\\s*)([a-z][a-zA-Z\\d@_]*|\'[^\']*\')(\\s*)(?=\\()' },
                    { token: 'text',
                        regex: '(?=\\()',
                        push: [{ token: 'punctuation.separator.clauses.erlang',
                                regex: ';|(?=\\.)',
                                next: 'pop' },
                            { include: '#parenthesized-expression' },
                            { include: '#internal-function-parts' }] },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.function.erlang' }] }],
        '#function-call': [{ token: 'meta.function-call.erlang',
                regex: '(?=(?:[a-z][a-zA-Z\\d@_]*|\'[^\']*\')\\s*(?:\\(|:\\s*(?:[a-z][a-zA-Z\\d@_]*|\'[^\']*\')\\s*\\())',
                push: [{ token: 'punctuation.definition.parameters.end.erlang',
                        regex: '\\)',
                        next: 'pop' },
                    { token: ['entity.name.type.class.module.erlang',
                            'text',
                            'punctuation.separator.module-function.erlang',
                            'text',
                            'entity.name.function.guard.erlang',
                            'text',
                            'punctuation.definition.parameters.begin.erlang'],
                        regex: '(?:(erlang)(\\s*)(:)(\\s*))?(is_atom|is_binary|is_constant|is_float|is_function|is_integer|is_list|is_number|is_pid|is_port|is_reference|is_tuple|is_record|abs|element|hd|length|node|round|self|size|tl|trunc)(\\s*)(\\()',
                        push: [{ token: 'text', regex: '(?=\\))', next: 'pop' },
                            { token: 'punctuation.separator.parameters.erlang', regex: ',' },
                            { include: '#everything-else' }] },
                    { token: ['entity.name.type.class.module.erlang',
                            'text',
                            'punctuation.separator.module-function.erlang',
                            'text',
                            'entity.name.function.erlang',
                            'text',
                            'punctuation.definition.parameters.begin.erlang'],
                        regex: '(?:([a-z][a-zA-Z\\d@_]*|\'[^\']*\')(\\s*)(:)(\\s*))?([a-z][a-zA-Z\\d@_]*|\'[^\']*\')(\\s*)(\\()',
                        push: [{ token: 'text', regex: '(?=\\))', next: 'pop' },
                            { token: 'punctuation.separator.parameters.erlang', regex: ',' },
                            { include: '#everything-else' }] },
                    { defaultToken: 'meta.function-call.erlang' }] }],
        '#import-export-directive': [{ token: ['meta.directive.import.erlang',
                    'punctuation.section.directive.begin.erlang',
                    'meta.directive.import.erlang',
                    'keyword.control.directive.import.erlang',
                    'meta.directive.import.erlang',
                    'punctuation.definition.parameters.begin.erlang',
                    'meta.directive.import.erlang',
                    'entity.name.type.class.module.erlang',
                    'meta.directive.import.erlang',
                    'punctuation.separator.parameters.erlang'],
                regex: '^(\\s*)(-)(\\s*)(import)(\\s*)(\\()(\\s*)([a-z][a-zA-Z\\d@_]*|\'[^\']*\')(\\s*)(,)',
                push: [{ token: ['punctuation.definition.parameters.end.erlang',
                            'meta.directive.import.erlang',
                            'punctuation.section.directive.end.erlang'],
                        regex: '(\\))(\\s*)(\\.)',
                        next: 'pop' },
                    { include: '#internal-function-list' },
                    { defaultToken: 'meta.directive.import.erlang' }] },
            { token: ['meta.directive.export.erlang',
                    'punctuation.section.directive.begin.erlang',
                    'meta.directive.export.erlang',
                    'keyword.control.directive.export.erlang',
                    'meta.directive.export.erlang',
                    'punctuation.definition.parameters.begin.erlang'],
                regex: '^(\\s*)(-)(\\s*)(export)(\\s*)(\\()',
                push: [{ token: ['punctuation.definition.parameters.end.erlang',
                            'meta.directive.export.erlang',
                            'punctuation.section.directive.end.erlang'],
                        regex: '(\\))(\\s*)(\\.)',
                        next: 'pop' },
                    { include: '#internal-function-list' },
                    { defaultToken: 'meta.directive.export.erlang' }] }],
        '#internal-expression-punctuation': [{ token: ['punctuation.separator.clause-head-body.erlang',
                    'punctuation.separator.clauses.erlang',
                    'punctuation.separator.expressions.erlang'],
                regex: '(->)|(;)|(,)' }],
        '#internal-function-list': [{ token: 'punctuation.definition.list.begin.erlang',
                regex: '\\[',
                push: [{ token: 'punctuation.definition.list.end.erlang',
                        regex: '\\]',
                        next: 'pop' },
                    { token: ['entity.name.function.erlang',
                            'text',
                            'punctuation.separator.function-arity.erlang'],
                        regex: '([a-z][a-zA-Z\\d@_]*|\'[^\']*\')(\\s*)(/)',
                        push: [{ token: 'punctuation.separator.list.erlang',
                                regex: ',|(?=\\])',
                                next: 'pop' },
                            { include: '#everything-else' }] },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.structure.list.function.erlang' }] }],
        '#internal-function-parts': [{ token: 'text',
                regex: '(?=\\()',
                push: [{ token: 'punctuation.separator.clause-head-body.erlang',
                        regex: '->',
                        next: 'pop' },
                    { token: 'punctuation.definition.parameters.begin.erlang',
                        regex: '\\(',
                        push: [{ token: 'punctuation.definition.parameters.end.erlang',
                                regex: '\\)',
                                next: 'pop' },
                            { token: 'punctuation.separator.parameters.erlang', regex: ',' },
                            { include: '#everything-else' }] },
                    { token: 'punctuation.separator.guards.erlang', regex: ',|;' },
                    { include: '#everything-else' }] },
            { token: 'punctuation.separator.expressions.erlang',
                regex: ',' },
            { include: '#everything-else' }],
        '#internal-record-body': [{ token: 'punctuation.definition.class.record.begin.erlang',
                regex: '\\{',
                push: [{ token: 'meta.structure.record.erlang',
                        regex: '(?=\\})',
                        next: 'pop' },
                    { token: ['variable.other.field.erlang',
                            'variable.language.omitted.field.erlang',
                            'text',
                            'keyword.operator.assignment.erlang'],
                        regex: '(?:([a-z][a-zA-Z\\d@_]*|\'[^\']*\')|(_))(\\s*)(=|::)',
                        push: [{ token: 'punctuation.separator.class.record.erlang',
                                regex: ',|(?=\\})',
                                next: 'pop' },
                            { include: '#everything-else' }] },
                    { token: ['variable.other.field.erlang',
                            'text',
                            'punctuation.separator.class.record.erlang'],
                        regex: '([a-z][a-zA-Z\\d@_]*|\'[^\']*\')(\\s*)((?:,)?)' },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.structure.record.erlang' }] }],
        '#internal-type-specifiers': [{ token: 'punctuation.separator.value-type.erlang',
                regex: '/',
                push: [{ token: 'text', regex: '(?=,|:|>>)', next: 'pop' },
                    { token: ['storage.type.erlang',
                            'storage.modifier.signedness.erlang',
                            'storage.modifier.endianness.erlang',
                            'storage.modifier.unit.erlang',
                            'punctuation.separator.type-specifiers.erlang'],
                        regex: '(integer|float|binary|bytes|bitstring|bits)|(signed|unsigned)|(big|little|native)|(unit)|(-)' }] }],
        '#keyword': [{ token: 'keyword.control.erlang',
                regex: '\\b(?:after|begin|case|catch|cond|end|fun|if|let|of|query|try|receive|when)\\b' }],
        '#list': [{ token: 'punctuation.definition.list.begin.erlang',
                regex: '\\[',
                push: [{ token: 'punctuation.definition.list.end.erlang',
                        regex: '\\]',
                        next: 'pop' },
                    { token: 'punctuation.separator.list.erlang',
                        regex: '\\||\\|\\||,' },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.structure.list.erlang' }] }],
        '#macro-directive': [{ token: ['meta.directive.ifdef.erlang',
                    'punctuation.section.directive.begin.erlang',
                    'meta.directive.ifdef.erlang',
                    'keyword.control.directive.ifdef.erlang',
                    'meta.directive.ifdef.erlang',
                    'punctuation.definition.parameters.begin.erlang',
                    'meta.directive.ifdef.erlang',
                    'entity.name.function.macro.erlang',
                    'meta.directive.ifdef.erlang',
                    'punctuation.definition.parameters.end.erlang',
                    'meta.directive.ifdef.erlang',
                    'punctuation.section.directive.end.erlang'],
                regex: '^(\\s*)(-)(\\s*)(ifdef)(\\s*)(\\()(\\s*)([a-zA-Z\\d@_]+)(\\s*)(\\))(\\s*)(\\.)' },
            { token: ['meta.directive.ifndef.erlang',
                    'punctuation.section.directive.begin.erlang',
                    'meta.directive.ifndef.erlang',
                    'keyword.control.directive.ifndef.erlang',
                    'meta.directive.ifndef.erlang',
                    'punctuation.definition.parameters.begin.erlang',
                    'meta.directive.ifndef.erlang',
                    'entity.name.function.macro.erlang',
                    'meta.directive.ifndef.erlang',
                    'punctuation.definition.parameters.end.erlang',
                    'meta.directive.ifndef.erlang',
                    'punctuation.section.directive.end.erlang'],
                regex: '^(\\s*)(-)(\\s*)(ifndef)(\\s*)(\\()(\\s*)([a-zA-Z\\d@_]+)(\\s*)(\\))(\\s*)(\\.)' },
            { token: ['meta.directive.undef.erlang',
                    'punctuation.section.directive.begin.erlang',
                    'meta.directive.undef.erlang',
                    'keyword.control.directive.undef.erlang',
                    'meta.directive.undef.erlang',
                    'punctuation.definition.parameters.begin.erlang',
                    'meta.directive.undef.erlang',
                    'entity.name.function.macro.erlang',
                    'meta.directive.undef.erlang',
                    'punctuation.definition.parameters.end.erlang',
                    'meta.directive.undef.erlang',
                    'punctuation.section.directive.end.erlang'],
                regex: '^(\\s*)(-)(\\s*)(undef)(\\s*)(\\()(\\s*)([a-zA-Z\\d@_]+)(\\s*)(\\))(\\s*)(\\.)' }],
        '#macro-usage': [{ token: ['keyword.operator.macro.erlang',
                    'meta.macro-usage.erlang',
                    'entity.name.function.macro.erlang'],
                regex: '(\\?\\??)(\\s*)([a-zA-Z\\d@_]+)' }],
        '#module-directive': [{ token: ['meta.directive.module.erlang',
                    'punctuation.section.directive.begin.erlang',
                    'meta.directive.module.erlang',
                    'keyword.control.directive.module.erlang',
                    'meta.directive.module.erlang',
                    'punctuation.definition.parameters.begin.erlang',
                    'meta.directive.module.erlang',
                    'entity.name.type.class.module.definition.erlang',
                    'meta.directive.module.erlang',
                    'punctuation.definition.parameters.end.erlang',
                    'meta.directive.module.erlang',
                    'punctuation.section.directive.end.erlang'],
                regex: '^(\\s*)(-)(\\s*)(module)(\\s*)(\\()(\\s*)([a-z][a-zA-Z\\d@_]*)(\\s*)(\\))(\\s*)(\\.)' }],
        '#number': [{ token: 'text',
                regex: '(?=\\d)',
                push: [{ token: 'text', regex: '(?!\\d)', next: 'pop' },
                    { token: ['constant.numeric.float.erlang',
                            'punctuation.separator.integer-float.erlang',
                            'constant.numeric.float.erlang',
                            'punctuation.separator.float-exponent.erlang'],
                        regex: '(\\d+)(\\.)(\\d+)((?:[eE][\\+\\-]?\\d+)?)' },
                    { token: ['constant.numeric.integer.binary.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.binary.erlang'],
                        regex: '(2)(#)([0-1]+)' },
                    { token: ['constant.numeric.integer.base-3.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-3.erlang'],
                        regex: '(3)(#)([0-2]+)' },
                    { token: ['constant.numeric.integer.base-4.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-4.erlang'],
                        regex: '(4)(#)([0-3]+)' },
                    { token: ['constant.numeric.integer.base-5.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-5.erlang'],
                        regex: '(5)(#)([0-4]+)' },
                    { token: ['constant.numeric.integer.base-6.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-6.erlang'],
                        regex: '(6)(#)([0-5]+)' },
                    { token: ['constant.numeric.integer.base-7.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-7.erlang'],
                        regex: '(7)(#)([0-6]+)' },
                    { token: ['constant.numeric.integer.octal.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.octal.erlang'],
                        regex: '(8)(#)([0-7]+)' },
                    { token: ['constant.numeric.integer.base-9.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-9.erlang'],
                        regex: '(9)(#)([0-8]+)' },
                    { token: ['constant.numeric.integer.decimal.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.decimal.erlang'],
                        regex: '(10)(#)(\\d+)' },
                    { token: ['constant.numeric.integer.base-11.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-11.erlang'],
                        regex: '(11)(#)([\\daA]+)' },
                    { token: ['constant.numeric.integer.base-12.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-12.erlang'],
                        regex: '(12)(#)([\\da-bA-B]+)' },
                    { token: ['constant.numeric.integer.base-13.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-13.erlang'],
                        regex: '(13)(#)([\\da-cA-C]+)' },
                    { token: ['constant.numeric.integer.base-14.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-14.erlang'],
                        regex: '(14)(#)([\\da-dA-D]+)' },
                    { token: ['constant.numeric.integer.base-15.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-15.erlang'],
                        regex: '(15)(#)([\\da-eA-E]+)' },
                    { token: ['constant.numeric.integer.hexadecimal.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.hexadecimal.erlang'],
                        regex: '(16)(#)([\\da-fA-F]+)' },
                    { token: ['constant.numeric.integer.base-17.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-17.erlang'],
                        regex: '(17)(#)([\\da-gA-G]+)' },
                    { token: ['constant.numeric.integer.base-18.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-18.erlang'],
                        regex: '(18)(#)([\\da-hA-H]+)' },
                    { token: ['constant.numeric.integer.base-19.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-19.erlang'],
                        regex: '(19)(#)([\\da-iA-I]+)' },
                    { token: ['constant.numeric.integer.base-20.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-20.erlang'],
                        regex: '(20)(#)([\\da-jA-J]+)' },
                    { token: ['constant.numeric.integer.base-21.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-21.erlang'],
                        regex: '(21)(#)([\\da-kA-K]+)' },
                    { token: ['constant.numeric.integer.base-22.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-22.erlang'],
                        regex: '(22)(#)([\\da-lA-L]+)' },
                    { token: ['constant.numeric.integer.base-23.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-23.erlang'],
                        regex: '(23)(#)([\\da-mA-M]+)' },
                    { token: ['constant.numeric.integer.base-24.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-24.erlang'],
                        regex: '(24)(#)([\\da-nA-N]+)' },
                    { token: ['constant.numeric.integer.base-25.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-25.erlang'],
                        regex: '(25)(#)([\\da-oA-O]+)' },
                    { token: ['constant.numeric.integer.base-26.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-26.erlang'],
                        regex: '(26)(#)([\\da-pA-P]+)' },
                    { token: ['constant.numeric.integer.base-27.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-27.erlang'],
                        regex: '(27)(#)([\\da-qA-Q]+)' },
                    { token: ['constant.numeric.integer.base-28.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-28.erlang'],
                        regex: '(28)(#)([\\da-rA-R]+)' },
                    { token: ['constant.numeric.integer.base-29.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-29.erlang'],
                        regex: '(29)(#)([\\da-sA-S]+)' },
                    { token: ['constant.numeric.integer.base-30.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-30.erlang'],
                        regex: '(30)(#)([\\da-tA-T]+)' },
                    { token: ['constant.numeric.integer.base-31.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-31.erlang'],
                        regex: '(31)(#)([\\da-uA-U]+)' },
                    { token: ['constant.numeric.integer.base-32.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-32.erlang'],
                        regex: '(32)(#)([\\da-vA-V]+)' },
                    { token: ['constant.numeric.integer.base-33.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-33.erlang'],
                        regex: '(33)(#)([\\da-wA-W]+)' },
                    { token: ['constant.numeric.integer.base-34.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-34.erlang'],
                        regex: '(34)(#)([\\da-xA-X]+)' },
                    { token: ['constant.numeric.integer.base-35.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-35.erlang'],
                        regex: '(35)(#)([\\da-yA-Y]+)' },
                    { token: ['constant.numeric.integer.base-36.erlang',
                            'punctuation.separator.base-integer.erlang',
                            'constant.numeric.integer.base-36.erlang'],
                        regex: '(36)(#)([\\da-zA-Z]+)' },
                    { token: 'invalid.illegal.integer.erlang',
                        regex: '\\d+#[\\da-zA-Z]+' },
                    { token: 'constant.numeric.integer.decimal.erlang',
                        regex: '\\d+' }] }],
        '#parenthesized-expression': [{ token: 'punctuation.section.expression.begin.erlang',
                regex: '\\(',
                push: [{ token: 'punctuation.section.expression.end.erlang',
                        regex: '\\)',
                        next: 'pop' },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.expression.parenthesized' }] }],
        '#record-directive': [{ token: ['meta.directive.record.erlang',
                    'punctuation.section.directive.begin.erlang',
                    'meta.directive.record.erlang',
                    'keyword.control.directive.import.erlang',
                    'meta.directive.record.erlang',
                    'punctuation.definition.parameters.begin.erlang',
                    'meta.directive.record.erlang',
                    'entity.name.type.class.record.definition.erlang',
                    'meta.directive.record.erlang',
                    'punctuation.separator.parameters.erlang'],
                regex: '^(\\s*)(-)(\\s*)(record)(\\s*)(\\()(\\s*)([a-z][a-zA-Z\\d@_]*|\'[^\']*\')(\\s*)(,)',
                push: [{ token: ['punctuation.definition.class.record.end.erlang',
                            'meta.directive.record.erlang',
                            'punctuation.definition.parameters.end.erlang',
                            'meta.directive.record.erlang',
                            'punctuation.section.directive.end.erlang'],
                        regex: '(\\})(\\s*)(\\))(\\s*)(\\.)',
                        next: 'pop' },
                    { include: '#internal-record-body' },
                    { defaultToken: 'meta.directive.record.erlang' }] }],
        '#record-usage': [{ token: ['keyword.operator.record.erlang',
                    'meta.record-usage.erlang',
                    'entity.name.type.class.record.erlang',
                    'meta.record-usage.erlang',
                    'punctuation.separator.record-field.erlang',
                    'meta.record-usage.erlang',
                    'variable.other.field.erlang'],
                regex: '(#)(\\s*)([a-z][a-zA-Z\\d@_]*|\'[^\']*\')(\\s*)(\\.)(\\s*)([a-z][a-zA-Z\\d@_]*|\'[^\']*\')' },
            { token: ['keyword.operator.record.erlang',
                    'meta.record-usage.erlang',
                    'entity.name.type.class.record.erlang'],
                regex: '(#)(\\s*)([a-z][a-zA-Z\\d@_]*|\'[^\']*\')',
                push: [{ token: 'punctuation.definition.class.record.end.erlang',
                        regex: '\\}',
                        next: 'pop' },
                    { include: '#internal-record-body' },
                    { defaultToken: 'meta.record-usage.erlang' }] }],
        '#string': [{ token: 'punctuation.definition.string.begin.erlang',
                regex: '"',
                push: [{ token: 'punctuation.definition.string.end.erlang',
                        regex: '"',
                        next: 'pop' },
                    { token: ['punctuation.definition.escape.erlang',
                            'constant.character.escape.erlang',
                            'punctuation.definition.escape.erlang',
                            'constant.character.escape.erlang',
                            'constant.character.escape.erlang'],
                        regex: '(\\\\)(?:([bdefnrstv\\\\\'"])|(\\^)([@-_])|([0-7]{1,3}))' },
                    { token: 'invalid.illegal.string.erlang', regex: '\\\\\\^?.?' },
                    { token: ['punctuation.definition.placeholder.erlang',
                            'punctuation.separator.placeholder-parts.erlang',
                            'constant.other.placeholder.erlang',
                            'punctuation.separator.placeholder-parts.erlang',
                            'punctuation.separator.placeholder-parts.erlang',
                            'constant.other.placeholder.erlang',
                            'punctuation.separator.placeholder-parts.erlang',
                            'punctuation.separator.placeholder-parts.erlang',
                            'punctuation.separator.placeholder-parts.erlang',
                            'constant.other.placeholder.erlang',
                            'constant.other.placeholder.erlang'],
                        regex: '(~)(?:((?:\\-)?)(\\d+)|(\\*))?(?:(\\.)(?:(\\d+)|(\\*)))?(?:(\\.)(?:(\\*)|(.)))?([~cfegswpWPBX#bx\\+ni])' },
                    { token: ['punctuation.definition.placeholder.erlang',
                            'punctuation.separator.placeholder-parts.erlang',
                            'constant.other.placeholder.erlang',
                            'constant.other.placeholder.erlang'],
                        regex: '(~)((?:\\*)?)((?:\\d+)?)([~du\\-#fsacl])' },
                    { token: 'invalid.illegal.string.erlang', regex: '~.?' },
                    { defaultToken: 'string.quoted.double.erlang' }] }],
        '#symbolic-operator': [{ token: 'keyword.operator.symbolic.erlang',
                regex: '\\+\\+|\\+|--|-|\\*|/=|/|=/=|=:=|==|=<|=|<-|<|>=|>|!|::' }],
        '#textual-operator': [{ token: 'keyword.operator.textual.erlang',
                regex: '\\b(?:andalso|band|and|bxor|xor|bor|orelse|or|bnot|not|bsl|bsr|div|rem)\\b' }],
        '#tuple': [{ token: 'punctuation.definition.tuple.begin.erlang',
                regex: '\\{',
                push: [{ token: 'punctuation.definition.tuple.end.erlang',
                        regex: '\\}',
                        next: 'pop' },
                    { token: 'punctuation.separator.tuple.erlang', regex: ',' },
                    { include: '#everything-else' },
                    { defaultToken: 'meta.structure.tuple.erlang' }] }],
        '#variable': [{ token: ['variable.other.erlang', 'variable.language.omitted.erlang'],
                regex: '(_[a-zA-Z\\d@_]+|[A-Z][a-zA-Z\\d@_]*)|(_)' }] };
    this.normalizeRules();
};
ErlangHighlightRules.metaData = { comment: 'The recognition of function definitions and compiler directives (such as module, record and macro definitions) requires that each of the aforementioned constructs must be the first string inside a line (except for whitespace).  Also, the function/module/record/macro names must be given unquoted.  -- desp',
    fileTypes: ['erl', 'hrl'],
    keyEquivalent: '^~E',
    name: 'Erlang',
    scopeName: 'source.erlang' };
oop.inherits(ErlangHighlightRules, TextHighlightRules);
exports.ErlangHighlightRules = ErlangHighlightRules;

});

define("ace/mode/erlang",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/erlang_highlight_rules","ace/mode/folding/cstyle"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY mode.tmpl.js
*/
"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var ErlangHighlightRules = require("./erlang_highlight_rules").ErlangHighlightRules;
var FoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = ErlangHighlightRules;
    this.foldingRules = new FoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "%";
    this.blockComment = null;
    this.$id = "ace/mode/erlang";
    this.snippetFileId = "ace/snippets/erlang";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/forth_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){/* This file was autogenerated from https://raw.github.com/vze26m98/Forth.tmbundle/master/Syntaxes/Forth.tmLanguage (uuid: ) */
"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var ForthHighlightRules = function () {
    this.$rules = { start: [{ include: '#forth' }],
        '#comment': [{ token: 'comment.line.double-dash.forth',
                regex: '(?:^|\\s)--\\s.*$',
                comment: 'line comments for iForth' },
            { token: 'comment.line.backslash.forth',
                regex: '(?:^|\\s)\\\\[\\s\\S]*$',
                comment: 'ANSI line comment' },
            { token: 'comment.line.backslash-g.forth',
                regex: '(?:^|\\s)\\\\[Gg] .*$',
                comment: 'gForth line comment' },
            { token: 'comment.block.forth',
                regex: '(?:^|\\s)\\(\\*(?=\\s|$)',
                push: [{ token: 'comment.block.forth',
                        regex: '(?:^|\\s)\\*\\)(?=\\s|$)',
                        next: 'pop' },
                    { defaultToken: 'comment.block.forth' }],
                comment: 'multiline comments for iForth' },
            { token: 'comment.block.documentation.forth',
                regex: '\\bDOC\\b',
                caseInsensitive: true,
                push: [{ token: 'comment.block.documentation.forth',
                        regex: '\\bENDDOC\\b',
                        caseInsensitive: true,
                        next: 'pop' },
                    { defaultToken: 'comment.block.documentation.forth' }],
                comment: 'documentation comments for iForth' },
            { token: 'comment.line.parentheses.forth',
                regex: '(?:^|\\s)\\.?\\( [^)]*\\)',
                comment: 'ANSI line comment' }],
        '#constant': [{ token: 'constant.language.forth',
                regex: '(?:^|\\s)(?:TRUE|FALSE|BL|PI|CELL|C/L|R/O|W/O|R/W)(?=\\s|$)',
                caseInsensitive: true },
            { token: 'constant.numeric.forth',
                regex: '(?:^|\\s)[$#%]?[-+]?[0-9]+(?:\\.[0-9]*e-?[0-9]+|\\.?[0-9a-fA-F]*)(?=\\s|$)' },
            { token: 'constant.character.forth',
                regex: '(?:^|\\s)(?:[&^]\\S|(?:"|\')\\S(?:"|\'))(?=\\s|$)' }],
        '#forth': [{ include: '#constant' },
            { include: '#comment' },
            { include: '#string' },
            { include: '#word' },
            { include: '#variable' },
            { include: '#storage' },
            { include: '#word-def' }],
        '#storage': [{ token: 'storage.type.forth',
                regex: '(?:^|\\s)(?:2CONSTANT|2VARIABLE|ALIAS|CONSTANT|CREATE-INTERPRET/COMPILE[:]?|CREATE|DEFER|FCONSTANT|FIELD|FVARIABLE|USER|VALUE|VARIABLE|VOCABULARY)(?=\\s|$)',
                caseInsensitive: true }],
        '#string': [{ token: 'string.quoted.double.forth',
                regex: '(ABORT" |BREAK" |\\." |C" |0"|S\\\\?" )([^"]+")',
                caseInsensitive: true },
            { token: 'string.unquoted.forth',
                regex: '(?:INCLUDE|NEEDS|REQUIRE|USE)[ ]\\S+(?=\\s|$)',
                caseInsensitive: true }],
        '#variable': [{ token: 'variable.language.forth',
                regex: '\\b(?:I|J)\\b',
                caseInsensitive: true }],
        '#word': [{ token: 'keyword.control.immediate.forth',
                regex: '(?:^|\\s)\\[(?:\\?DO|\\+LOOP|AGAIN|BEGIN|DEFINED|DO|ELSE|ENDIF|FOR|IF|IFDEF|IFUNDEF|LOOP|NEXT|REPEAT|THEN|UNTIL|WHILE)\\](?=\\s|$)',
                caseInsensitive: true },
            { token: 'keyword.other.immediate.forth',
                regex: '(?:^|\\s)(?:COMPILE-ONLY|IMMEDIATE|IS|RESTRICT|TO|WHAT\'S|])(?=\\s|$)',
                caseInsensitive: true },
            { token: 'keyword.control.compile-only.forth',
                regex: '(?:^|\\s)(?:-DO|\\-LOOP|\\?DO|\\?LEAVE|\\+DO|\\+LOOP|ABORT\\"|AGAIN|AHEAD|BEGIN|CASE|DO|ELSE|ENDCASE|ENDIF|ENDOF|ENDTRY\\-IFERROR|ENDTRY|FOR|IF|IFERROR|LEAVE|LOOP|NEXT|RECOVER|REPEAT|RESTORE|THEN|TRY|U\\-DO|U\\+DO|UNTIL|WHILE)(?=\\s|$)',
                caseInsensitive: true },
            { token: 'keyword.other.compile-only.forth',
                regex: '(?:^|\\s)(?:\\?DUP-0=-IF|\\?DUP-IF|\\)|\\[|\\[\'\\]|\\[CHAR\\]|\\[COMPILE\\]|\\[IS\\]|\\[TO\\]|<COMPILATION|<INTERPRETATION|ASSERT\\(|ASSERT0\\(|ASSERT1\\(|ASSERT2\\(|ASSERT3\\(|COMPILATION>|DEFERS|DOES>|INTERPRETATION>|OF|POSTPONE)(?=\\s|$)',
                caseInsensitive: true },
            { token: 'keyword.other.non-immediate.forth',
                regex: '(?:^|\\s)(?:\'|<IS>|<TO>|CHAR|END-STRUCT|INCLUDE[D]?|LOAD|NEEDS|REQUIRE[D]?|REVISION|SEE|STRUCT|THRU|USE)(?=\\s|$)',
                caseInsensitive: true },
            { token: 'keyword.other.warning.forth',
                regex: '(?:^|\\s)(?:~~|BREAK:|BREAK"|DBG)(?=\\s|$)',
                caseInsensitive: true }],
        '#word-def': [{ token: ['keyword.other.compile-only.forth',
                    'keyword.other.compile-only.forth',
                    'meta.block.forth',
                    'entity.name.function.forth'],
                regex: '(:NONAME)|(^:|\\s:)(\\s)(\\S+)(?=\\s|$)',
                caseInsensitive: true,
                push: [{ token: 'keyword.other.compile-only.forth',
                        regex: ';(?:CODE)?',
                        caseInsensitive: true,
                        next: 'pop' },
                    { include: '#constant' },
                    { include: '#comment' },
                    { include: '#string' },
                    { include: '#word' },
                    { include: '#variable' },
                    { include: '#storage' },
                    { defaultToken: 'meta.block.forth' }] }] };
    this.normalizeRules();
};
ForthHighlightRules.metaData = { fileTypes: ['frt', 'fs', 'ldr', 'fth', '4th'],
    foldingStartMarker: '/\\*\\*|\\{\\s*$',
    foldingStopMarker: '\\*\\*/|^\\s*\\}',
    keyEquivalent: '^~F',
    name: 'Forth',
    scopeName: 'source.forth' };
oop.inherits(ForthHighlightRules, TextHighlightRules);
exports.ForthHighlightRules = ForthHighlightRules;

});

define("ace/mode/forth",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/forth_highlight_rules","ace/mode/folding/cstyle"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY mode.tmpl.js
*/
"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var ForthHighlightRules = require("./forth_highlight_rules").ForthHighlightRules;
var FoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = ForthHighlightRules;
    this.foldingRules = new FoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "--";
    this.blockComment = null;
    this.$id = "ace/mode/forth";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/ftl_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/html_highlight_rules","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var HtmlHighlightRules = require("./html_highlight_rules").HtmlHighlightRules;
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var FtlLangHighlightRules = function () {
    var stringBuiltIns = "\\?|substring|cap_first|uncap_first|capitalize|chop_linebreak|date|time|datetime|"
        + "ends_with|html|groups|index_of|j_string|js_string|json_string|last_index_of|length|lower_case|"
        + "left_pad|right_pad|contains|matches|number|replace|rtf|url|split|starts_with|string|trim|"
        + "upper_case|word_list|xhtml|xml";
    var numberBuiltIns = "c|round|floor|ceiling";
    var dateBuiltIns = "iso_[a-z_]+";
    var seqBuiltIns = "first|last|seq_contains|seq_index_of|seq_last_index_of|reverse|size|sort|sort_by|chunk";
    var hashBuiltIns = "keys|values";
    var xmlBuiltIns = "children|parent|root|ancestors|node_name|node_type|node_namespace";
    var expertBuiltIns = "byte|double|float|int|long|short|number_to_date|number_to_time|number_to_datetime|"
        + "eval|has_content|interpret|is_[a-z_]+|namespacenew";
    var allBuiltIns = stringBuiltIns + numberBuiltIns + dateBuiltIns + seqBuiltIns + hashBuiltIns
        + xmlBuiltIns + expertBuiltIns;
    var deprecatedBuiltIns = "default|exists|if_exists|web_safe";
    var variables = "data_model|error|globals|lang|locale|locals|main|namespace|node|current_node|"
        + "now|output_encoding|template_name|url_escaping_charset|vars|version";
    var operators = "gt|gte|lt|lte|as|in|using";
    var reserved = "true|false";
    var attributes = "encoding|parse|locale|number_format|date_format|time_format|datetime_format|time_zone|"
        + "url_escaping_charset|classic_compatible|strip_whitespace|strip_text|strict_syntax|ns_prefixes|"
        + "attributes";
    this.$rules = {
        "start": [{
                token: "constant.character.entity",
                regex: /&[^;]+;/
            }, {
                token: "support.function",
                regex: "\\?(" + allBuiltIns + ")"
            }, {
                token: "support.function.deprecated",
                regex: "\\?(" + deprecatedBuiltIns + ")"
            }, {
                token: "language.variable",
                regex: "\\.(?:" + variables + ")"
            }, {
                token: "constant.language",
                regex: "\\b(" + reserved + ")\\b"
            }, {
                token: "keyword.operator",
                regex: "\\b(?:" + operators + ")\\b"
            }, {
                token: "entity.other.attribute-name",
                regex: attributes
            }, {
                token: "string",
                regex: /['"]/,
                next: "qstring"
            }, {
                token: function (value) {
                    if (value.match("^[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?$")) {
                        return "constant.numeric";
                    }
                    else {
                        return "variable";
                    }
                },
                regex: /[\w.+\-]+/
            }, {
                token: "keyword.operator",
                regex: "!|\\.|\\$|%|&|\\*|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^="
            }, {
                token: "paren.lparen",
                regex: "[[({]"
            }, {
                token: "paren.rparen",
                regex: "[\\])}]"
            }, {
                token: "text",
                regex: "\\s+"
            }],
        "qstring": [{
                token: "constant.character.escape",
                regex: '\\\\[nrtvef\\\\"$]'
            }, {
                token: "string",
                regex: /['"]/,
                next: "start"
            }, {
                defaultToken: "string"
            }]
    };
};
oop.inherits(FtlLangHighlightRules, TextHighlightRules);
var FtlHighlightRules = function () {
    HtmlHighlightRules.call(this);
    var directives = "assign|attempt|break|case|compress|default|elseif|else|escape|fallback|function|flush|"
        + "ftl|global|if|import|include|list|local|lt|macro|nested|noescape|noparse|nt|recover|recurse|return|rt|"
        + "setting|stop|switch|t|visit";
    var startRules = [
        {
            token: "comment",
            regex: "<#--",
            next: "ftl-dcomment"
        }, {
            token: "string.interpolated",
            regex: "\\${",
            push: "ftl-start"
        }, {
            token: "keyword.function",
            regex: "</?#(" + directives + ")",
            push: "ftl-start"
        }, {
            token: "keyword.other",
            regex: "</?@[a-zA-Z\\.]+",
            push: "ftl-start"
        }
    ];
    var endRules = [
        {
            token: "keyword",
            regex: "/?>",
            next: "pop"
        }, {
            token: "string.interpolated",
            regex: "}",
            next: "pop"
        }
    ];
    for (var key in this.$rules)
        this.$rules[key].unshift.apply(this.$rules[key], startRules);
    this.embedRules(FtlLangHighlightRules, "ftl-", endRules, ["start"]);
    this.addRules({
        "ftl-dcomment": [{
                token: "comment",
                regex: "-->",
                next: "pop"
            }, {
                defaultToken: "comment"
            }]
    });
    this.normalizeRules();
};
oop.inherits(FtlHighlightRules, HtmlHighlightRules);
exports.FtlHighlightRules = FtlHighlightRules;

});

define("ace/mode/ftl",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/ftl_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var FtlHighlightRules = require("./ftl_highlight_rules").FtlHighlightRules;
var Mode = function () {
    this.HighlightRules = FtlHighlightRules;
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.$id = "ace/mode/ftl";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/gcode_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var GcodeHighlightRules = function () {
    var keywords = ("IF|DO|WHILE|ENDWHILE|CALL|ENDIF|SUB|ENDSUB|GOTO|REPEAT|ENDREPEAT|CALL");
    var builtinConstants = ("PI");
    var builtinFunctions = ("ATAN|ABS|ACOS|ASIN|SIN|COS|EXP|FIX|FUP|ROUND|LN|TAN");
    var keywordMapper = this.createKeywordMapper({
        "support.function": builtinFunctions,
        "keyword": keywords,
        "constant.language": builtinConstants
    }, "identifier", true);
    this.$rules = {
        "start": [{
                token: "comment",
                regex: "\\(.*\\)"
            }, {
                token: "comment",
                regex: "([N])([0-9]+)"
            }, {
                token: "string",
                regex: "([G])([0-9]+\\.?[0-9]?)"
            }, {
                token: "string",
                regex: "([M])([0-9]+\\.?[0-9]?)"
            }, {
                token: "constant.numeric",
                regex: "([-+]?([0-9]*\\.?[0-9]+\\.?))|(\\b0[xX][a-fA-F0-9]+|(\\b\\d+(\\.\\d*)?|\\.\\d+)([eE][-+]?\\d+)?)"
            }, {
                token: keywordMapper,
                regex: "[A-Z]"
            }, {
                token: "keyword.operator",
                regex: "EQ|LT|GT|NE|GE|LE|OR|XOR"
            }, {
                token: "paren.lparen",
                regex: "[\\[]"
            }, {
                token: "paren.rparen",
                regex: "[\\]]"
            }, {
                token: "text",
                regex: "\\s+"
            }]
    };
};
oop.inherits(GcodeHighlightRules, TextHighlightRules);
exports.GcodeHighlightRules = GcodeHighlightRules;

});

define("ace/mode/gcode",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/gcode_highlight_rules","ace/range"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var GcodeHighlightRules = require("./gcode_highlight_rules").GcodeHighlightRules;
var Range = require("../range").Range;
var Mode = function () {
    this.HighlightRules = GcodeHighlightRules;
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.$id = "ace/mode/gcode";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/gherkin_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var stringEscape = "\\\\(x[0-9A-Fa-f]{2}|[0-7]{3}|[\\\\abfnrtv'\"]|U[0-9A-Fa-f]{8}|u[0-9A-Fa-f]{4})";
var GherkinHighlightRules = function () {
    var languages = [{
            name: "en",
            labels: "Feature|Background|Scenario(?: Outline)?|Examples",
            keywords: "Given|When|Then|And|But"
        } 
    ];
    var labels = languages.map(function (l) {
        return l.labels;
    }).join("|");
    var keywords = languages.map(function (l) {
        return l.keywords;
    }).join("|");
    this.$rules = {
        start: [{
                token: "constant.numeric",
                regex: "(?:(?:[1-9]\\d*)|(?:0))"
            }, {
                token: "comment",
                regex: "#.*$"
            }, {
                token: "keyword",
                regex: "(?:" + labels + "):|(?:" + keywords + ")\\b"
            }, {
                token: "keyword",
                regex: "\\*"
            }, {
                token: "string",
                regex: '"{3}',
                next: "qqstring3"
            }, {
                token: "string",
                regex: '"',
                next: "qqstring"
            }, {
                token: "text",
                regex: "^\\s*(?=@[\\w])",
                next: [{
                        token: "text",
                        regex: "\\s+"
                    }, {
                        token: "variable.parameter",
                        regex: "@[\\w]+"
                    }, {
                        token: "empty",
                        regex: "",
                        next: "start"
                    }]
            }, {
                token: "comment",
                regex: "<[^>]+>"
            }, {
                token: "comment",
                regex: "\\|(?=.)",
                next: "table-item"
            }, {
                token: "comment",
                regex: "\\|$",
                next: "start"
            }],
        "qqstring3": [{
                token: "constant.language.escape",
                regex: stringEscape
            }, {
                token: "string",
                regex: '"{3}',
                next: "start"
            }, {
                defaultToken: "string"
            }],
        "qqstring": [{
                token: "constant.language.escape",
                regex: stringEscape
            }, {
                token: "string",
                regex: "\\\\$",
                next: "qqstring"
            }, {
                token: "string",
                regex: '"|$',
                next: "start"
            }, {
                defaultToken: "string"
            }],
        "table-item": [{
                token: "comment",
                regex: /$/,
                next: "start"
            }, {
                token: "comment",
                regex: /\|/
            }, {
                token: "string",
                regex: /\\./
            }, {
                defaultToken: "string"
            }]
    };
    this.normalizeRules();
};
oop.inherits(GherkinHighlightRules, TextHighlightRules);
exports.GherkinHighlightRules = GherkinHighlightRules;

});

define("ace/mode/gherkin",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/gherkin_highlight_rules"], function(require, exports, module){var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var GherkinHighlightRules = require("./gherkin_highlight_rules").GherkinHighlightRules;
var Mode = function () {
    this.HighlightRules = GherkinHighlightRules;
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "#";
    this.$id = "ace/mode/gherkin";
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        var space2 = "  ";
        var tokenizedLine = this.getTokenizer().getLineTokens(line, state);
        var tokens = tokenizedLine.tokens;
        if (line.match("[ ]*\\|")) {
            indent += "| ";
        }
        if (tokens.length && tokens[tokens.length - 1].type == "comment") {
            return indent;
        }
        if (state == "start") {
            if (line.match("Scenario:|Feature:|Scenario Outline:|Background:")) {
                indent += space2;
            }
            else if (line.match("(Given|Then).+(:)$|Examples:")) {
                indent += space2;
            }
            else if (line.match("\\*.+")) {
                indent += "* ";
            }
        }
        return indent;
    };
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/gitignore_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var GitignoreHighlightRules = function () {
    this.$rules = {
        "start": [
            {
                token: "comment",
                regex: /^\s*#.*$/
            }, {
                token: "keyword",
                regex: /^\s*!.*$/
            }
        ]
    };
    this.normalizeRules();
};
GitignoreHighlightRules.metaData = {
    fileTypes: ['gitignore'],
    name: 'Gitignore'
};
oop.inherits(GitignoreHighlightRules, TextHighlightRules);
exports.GitignoreHighlightRules = GitignoreHighlightRules;

});

define("ace/mode/gitignore",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/gitignore_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var GitignoreHighlightRules = require("./gitignore_highlight_rules").GitignoreHighlightRules;
var Mode = function () {
    this.HighlightRules = GitignoreHighlightRules;
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "#";
    this.$id = "ace/mode/gitignore";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/glsl_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/c_cpp_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var c_cppHighlightRules = require("./c_cpp_highlight_rules").c_cppHighlightRules;
var glslHighlightRules = function () {
    var keywords = ("attribute|const|uniform|varying|break|continue|do|for|while|" +
        "if|else|in|out|inout|float|int|void|bool|true|false|" +
        "lowp|mediump|highp|precision|invariant|discard|return|mat2|mat3|" +
        "mat4|vec2|vec3|vec4|ivec2|ivec3|ivec4|bvec2|bvec3|bvec4|sampler2D|" +
        "samplerCube|struct");
    var buildinConstants = ("radians|degrees|sin|cos|tan|asin|acos|atan|pow|" +
        "exp|log|exp2|log2|sqrt|inversesqrt|abs|sign|floor|ceil|fract|mod|" +
        "min|max|clamp|mix|step|smoothstep|length|distance|dot|cross|" +
        "normalize|faceforward|reflect|refract|matrixCompMult|lessThan|" +
        "lessThanEqual|greaterThan|greaterThanEqual|equal|notEqual|any|all|" +
        "not|dFdx|dFdy|fwidth|texture2D|texture2DProj|texture2DLod|" +
        "texture2DProjLod|textureCube|textureCubeLod|" +
        "gl_MaxVertexAttribs|gl_MaxVertexUniformVectors|gl_MaxVaryingVectors|" +
        "gl_MaxVertexTextureImageUnits|gl_MaxCombinedTextureImageUnits|" +
        "gl_MaxTextureImageUnits|gl_MaxFragmentUniformVectors|gl_MaxDrawBuffers|" +
        "gl_DepthRangeParameters|gl_DepthRange|" +
        "gl_Position|gl_PointSize|" +
        "gl_FragCoord|gl_FrontFacing|gl_PointCoord|gl_FragColor|gl_FragData");
    var keywordMapper = this.createKeywordMapper({
        "variable.language": "this",
        "keyword": keywords,
        "constant.language": buildinConstants
    }, "identifier");
    this.$rules = new c_cppHighlightRules().$rules;
    this.$rules.start.forEach(function (rule) {
        if (typeof rule.token == "function")
            rule.token = keywordMapper;
    });
};
oop.inherits(glslHighlightRules, c_cppHighlightRules);
exports.glslHighlightRules = glslHighlightRules;

});

define("ace/mode/glsl",["require","exports","module","ace/lib/oop","ace/mode/c_cpp","ace/mode/glsl_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/cstyle"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var CMode = require("./c_cpp").Mode;
var glslHighlightRules = require("./glsl_highlight_rules").glslHighlightRules;
var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var CStyleFoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = glslHighlightRules;
    this.$outdent = new MatchingBraceOutdent();
    this.$behaviour = this.$defaultBehaviour;
    this.foldingRules = new CStyleFoldMode();
};
oop.inherits(Mode, CMode);
(function () {
    this.$id = "ace/mode/glsl";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/golang_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"], function(require, exports, module){var oop = require("../lib/oop");
var DocCommentHighlightRules = require("./doc_comment_highlight_rules").DocCommentHighlightRules;
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var GolangHighlightRules = function () {
    var keywords = ("else|break|case|return|goto|if|const|select|" +
        "continue|struct|default|switch|for|range|" +
        "func|import|package|chan|defer|fallthrough|go|interface|map|range|" +
        "select|type|var");
    var builtinTypes = ("string|uint8|uint16|uint32|uint64|int8|int16|int32|int64|float32|" +
        "float64|complex64|complex128|byte|rune|uint|int|uintptr|bool|error");
    var builtinFunctions = ("new|close|cap|copy|panic|panicln|print|println|len|make|delete|real|recover|imag|append");
    var builtinConstants = ("nil|true|false|iota");
    var keywordMapper = this.createKeywordMapper({
        "keyword": keywords,
        "constant.language": builtinConstants,
        "support.function": builtinFunctions,
        "support.type": builtinTypes
    }, "");
    var stringEscapeRe = "\\\\(?:[0-7]{3}|x\\h{2}|u{4}|U\\h{6}|[abfnrtv'\"\\\\])".replace(/\\h/g, "[a-fA-F\\d]");
    this.$rules = {
        "start": [
            {
                token: "comment",
                regex: "\\/\\/.*$"
            },
            DocCommentHighlightRules.getStartRule("doc-start"),
            {
                token: "comment.start",
                regex: "\\/\\*",
                next: "comment"
            }, {
                token: "string",
                regex: /"(?:[^"\\]|\\.)*?"/
            }, {
                token: "string",
                regex: '`',
                next: "bqstring"
            }, {
                token: "constant.numeric",
                regex: "'(?:[^\\'\uD800-\uDBFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|" + stringEscapeRe.replace('"', '') + ")'"
            }, {
                token: "constant.numeric",
                regex: "0[xX][0-9a-fA-F]+\\b"
            }, {
                token: "constant.numeric",
                regex: "[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"
            }, {
                token: ["keyword", "text", "entity.name.function"],
                regex: "(func)(\\s+)([a-zA-Z_$][a-zA-Z0-9_$]*)\\b"
            }, {
                token: function (val) {
                    if (val[val.length - 1] == "(") {
                        return [{
                                type: keywordMapper(val.slice(0, -1)) || "support.function",
                                value: val.slice(0, -1)
                            }, {
                                type: "paren.lparen",
                                value: val.slice(-1)
                            }];
                    }
                    return keywordMapper(val) || "identifier";
                },
                regex: "[a-zA-Z_$][a-zA-Z0-9_$]*\\b\\(?"
            }, {
                token: "keyword.operator",
                regex: "!|\\$|%|&|\\*|\\-\\-|\\-|\\+\\+|\\+|~|==|=|!=|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^="
            }, {
                token: "punctuation.operator",
                regex: "\\?|\\:|\\,|\\;|\\."
            }, {
                token: "paren.lparen",
                regex: "[[({]"
            }, {
                token: "paren.rparen",
                regex: "[\\])}]"
            }, {
                token: "text",
                regex: "\\s+"
            }
        ],
        "comment": [
            {
                token: "comment.end",
                regex: "\\*\\/",
                next: "start"
            }, {
                defaultToken: "comment"
            }
        ],
        "bqstring": [
            {
                token: "string",
                regex: '`',
                next: "start"
            }, {
                defaultToken: "string"
            }
        ]
    };
    this.embedRules(DocCommentHighlightRules, "doc-", [DocCommentHighlightRules.getEndRule("start")]);
};
oop.inherits(GolangHighlightRules, TextHighlightRules);
exports.GolangHighlightRules = GolangHighlightRules;

});

define("ace/mode/golang",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/golang_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/cstyle"], function(require, exports, module){var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var GolangHighlightRules = require("./golang_highlight_rules").GolangHighlightRules;
var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var CStyleFoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = GolangHighlightRules;
    this.$outdent = new MatchingBraceOutdent();
    this.foldingRules = new CStyleFoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "//";
    this.blockComment = { start: "/*", end: "*/" };
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        var tokenizedLine = this.getTokenizer().getLineTokens(line, state);
        var tokens = tokenizedLine.tokens;
        var endState = tokenizedLine.state;
        if (tokens.length && tokens[tokens.length - 1].type == "comment") {
            return indent;
        }
        if (state == "start") {
            var match = line.match(/^.*[\{\(\[]\s*$/);
            if (match) {
                indent += tab;
            }
        }
        return indent;
    }; //end getNextLineIndent
    this.checkOutdent = function (state, line, input) {
        return this.$outdent.checkOutdent(line, input);
    };
    this.autoOutdent = function (state, doc, row) {
        this.$outdent.autoOutdent(doc, row);
    };
    this.$id = "ace/mode/golang";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/groovy_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var DocCommentHighlightRules = require("./doc_comment_highlight_rules").DocCommentHighlightRules;
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var GroovyHighlightRules = function () {
    var keywords = ("assert|with|abstract|continue|for|new|switch|" +
        "assert|default|goto|package|synchronized|" +
        "boolean|do|if|private|this|" +
        "break|double|implements|protected|throw|" +
        "byte|else|import|public|throws|" +
        "case|enum|instanceof|return|transient|" +
        "catch|extends|int|short|try|" +
        "char|final|interface|static|void|" +
        "class|finally|long|strictfp|volatile|" +
        "def|float|native|super|while");
    var buildinConstants = ("null|Infinity|NaN|undefined");
    var langClasses = ("AbstractMethodError|AssertionError|ClassCircularityError|" +
        "ClassFormatError|Deprecated|EnumConstantNotPresentException|" +
        "ExceptionInInitializerError|IllegalAccessError|" +
        "IllegalThreadStateException|InstantiationError|InternalError|" +
        "NegativeArraySizeException|NoSuchFieldError|Override|Process|" +
        "ProcessBuilder|SecurityManager|StringIndexOutOfBoundsException|" +
        "SuppressWarnings|TypeNotPresentException|UnknownError|" +
        "UnsatisfiedLinkError|UnsupportedClassVersionError|VerifyError|" +
        "InstantiationException|IndexOutOfBoundsException|" +
        "ArrayIndexOutOfBoundsException|CloneNotSupportedException|" +
        "NoSuchFieldException|IllegalArgumentException|NumberFormatException|" +
        "SecurityException|Void|InheritableThreadLocal|IllegalStateException|" +
        "InterruptedException|NoSuchMethodException|IllegalAccessException|" +
        "UnsupportedOperationException|Enum|StrictMath|Package|Compiler|" +
        "Readable|Runtime|StringBuilder|Math|IncompatibleClassChangeError|" +
        "NoSuchMethodError|ThreadLocal|RuntimePermission|ArithmeticException|" +
        "NullPointerException|Long|Integer|Short|Byte|Double|Number|Float|" +
        "Character|Boolean|StackTraceElement|Appendable|StringBuffer|" +
        "Iterable|ThreadGroup|Runnable|Thread|IllegalMonitorStateException|" +
        "StackOverflowError|OutOfMemoryError|VirtualMachineError|" +
        "ArrayStoreException|ClassCastException|LinkageError|" +
        "NoClassDefFoundError|ClassNotFoundException|RuntimeException|" +
        "Exception|ThreadDeath|Error|Throwable|System|ClassLoader|" +
        "Cloneable|Class|CharSequence|Comparable|String|Object");
    var keywordMapper = this.createKeywordMapper({
        "variable.language": "this",
        "keyword": keywords,
        "support.function": langClasses,
        "constant.language": buildinConstants
    }, "identifier");
    this.$rules = {
        "start": [
            {
                token: "comment",
                regex: "\\/\\/.*$"
            },
            DocCommentHighlightRules.getStartRule("doc-start"),
            {
                token: "comment",
                regex: "\\/\\*",
                next: "comment"
            }, {
                token: "string.regexp",
                regex: "[/](?:(?:\\[(?:\\\\]|[^\\]])+\\])|(?:\\\\/|[^\\]/]))*[/]\\w*\\s*(?=[).,;]|$)"
            }, {
                token: "string",
                regex: '"""',
                next: "qqstring"
            }, {
                token: "string",
                regex: "'''",
                next: "qstring"
            }, {
                token: "string",
                regex: '["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'
            }, {
                token: "string",
                regex: "['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"
            }, {
                token: "constant.numeric",
                regex: "0[xX][0-9a-fA-F]+\\b"
            }, {
                token: "constant.numeric",
                regex: "[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"
            }, {
                token: "constant.language.boolean",
                regex: "(?:true|false)\\b"
            }, {
                token: keywordMapper,
                regex: "[a-zA-Z_$][a-zA-Z0-9_$]*\\b"
            }, {
                token: "keyword.operator",
                regex: "\\?:|\\?\\.|\\*\\.|<=>|=~|==~|\\.@|\\*\\.@|\\.&|as|in|is|!|\\$|%|&|\\*|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^=|\\b(?:in|instanceof|new|delete|typeof|void)"
            }, {
                token: "lparen",
                regex: "[[({]"
            }, {
                token: "rparen",
                regex: "[\\])}]"
            }, {
                token: "text",
                regex: "\\s+"
            }
        ],
        "comment": [
            {
                token: "comment",
                regex: "\\*\\/",
                next: "start"
            }, {
                defaultToken: "comment"
            }
        ],
        "qqstring": [
            {
                token: "constant.language.escape",
                regex: /\\(?:u[0-9A-Fa-f]{4}|.|$)/
            }, {
                token: "constant.language.escape",
                regex: /\$[\w\d]+/
            }, {
                token: "constant.language.escape",
                regex: /\$\{[^"\}]+\}?/
            }, {
                token: "string",
                regex: '"{3,5}',
                next: "start"
            }, {
                token: "string",
                regex: '.+?'
            }
        ],
        "qstring": [
            {
                token: "constant.language.escape",
                regex: /\\(?:u[0-9A-Fa-f]{4}|.|$)/
            }, {
                token: "string",
                regex: "'{3,5}",
                next: "start"
            }, {
                token: "string",
                regex: ".+?"
            }
        ]
    };
    this.embedRules(DocCommentHighlightRules, "doc-", [DocCommentHighlightRules.getEndRule("start")]);
};
oop.inherits(GroovyHighlightRules, TextHighlightRules);
exports.GroovyHighlightRules = GroovyHighlightRules;

});

define("ace/mode/groovy",["require","exports","module","ace/lib/oop","ace/mode/javascript","ace/mode/groovy_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var JavaScriptMode = require("./javascript").Mode;
var GroovyHighlightRules = require("./groovy_highlight_rules").GroovyHighlightRules;
var Mode = function () {
    JavaScriptMode.call(this);
    this.HighlightRules = GroovyHighlightRules;
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, JavaScriptMode);
(function () {
    this.createWorker = function (session) {
        return null;
    };
    this.$id = "ace/mode/groovy";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/ruby_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var constantOtherSymbol = exports.constantOtherSymbol = {
    token: "constant.other.symbol.ruby",
    regex: "[:](?:[A-Za-z_]|[@$](?=[a-zA-Z0-9_]))[a-zA-Z0-9_]*[!=?]?"
};
exports.qString = {
    token: "string",
    regex: "['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"
};
exports.qqString = {
    token: "string",
    regex: '["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'
};
exports.tString = {
    token: "string",
    regex: "[`](?:(?:\\\\.)|(?:[^'\\\\]))*?[`]"
};
var constantNumericHex = exports.constantNumericHex = {
    token: "constant.numeric",
    regex: "0[xX][0-9a-fA-F](?:[0-9a-fA-F]|_(?=[0-9a-fA-F]))*\\b"
};
var constantNumericBinary = exports.constantNumericBinary = {
    token: "constant.numeric",
    regex: /\b(0[bB][01](?:[01]|_(?=[01]))*)\b/
};
var constantNumericDecimal = exports.constantNumericDecimal = {
    token: "constant.numeric",
    regex: /\b(0[dD](?:[1-9](?:[\d]|_(?=[\d]))*|0))\b/
};
var constantNumericOctal = exports.constantNumericDecimal = {
    token: "constant.numeric",
    regex: /\b(0[oO]?(?:[1-7](?:[0-7]|_(?=[0-7]))*|0))\b/
};
var constantNumericRational = exports.constantNumericRational = {
    token: "constant.numeric",
    regex: /\b([\d]+(?:[./][\d]+)?ri?)\b/
};
var constantNumericComplex = exports.constantNumericComplex = {
    token: "constant.numeric",
    regex: /\b([\d]i)\b/
};
var constantNumericFloat = exports.constantNumericFloat = {
    token: "constant.numeric",
    regex: "[+-]?\\d(?:\\d|_(?=\\d))*(?:(?:\\.\\d(?:\\d|_(?=\\d))*)?(?:[eE][+-]?\\d+)?)?i?\\b"
};
var instanceVariable = exports.instanceVariable = {
    token: "variable.instance",
    regex: "@{1,2}[a-zA-Z_\\d]+"
};
var RubyHighlightRules = function () {
    var builtinFunctions = ("abort|Array|assert|assert_equal|assert_not_equal|assert_same|assert_not_same|" +
        "assert_nil|assert_not_nil|assert_match|assert_no_match|assert_in_delta|assert_throws|" +
        "assert_raise|assert_nothing_raised|assert_instance_of|assert_kind_of|assert_respond_to|" +
        "assert_operator|assert_send|assert_difference|assert_no_difference|assert_recognizes|" +
        "assert_generates|assert_response|assert_redirected_to|assert_template|assert_select|" +
        "assert_select_email|assert_select_rjs|assert_select_encoded|css_select|at_exit|" +
        "attr|attr_writer|attr_reader|attr_accessor|attr_accessible|autoload|binding|block_given?|callcc|" +
        "caller|catch|chomp|chomp!|chop|chop!|defined?|delete_via_redirect|eval|exec|exit|" +
        "exit!|fail|Float|flunk|follow_redirect!|fork|form_for|form_tag|format|gets|global_variables|gsub|" +
        "gsub!|get_via_redirect|host!|https?|https!|include|Integer|lambda|link_to|" +
        "link_to_unless_current|link_to_function|link_to_remote|load|local_variables|loop|open|open_session|" +
        "p|print|printf|proc|putc|puts|post_via_redirect|put_via_redirect|raise|rand|" +
        "raw|readline|readlines|redirect?|request_via_redirect|require|scan|select|" +
        "set_trace_func|sleep|split|sprintf|srand|String|stylesheet_link_tag|syscall|system|sub|sub!|test|" +
        "throw|trace_var|trap|untrace_var|atan2|cos|exp|frexp|ldexp|log|log10|sin|sqrt|tan|" +
        "render|javascript_include_tag|csrf_meta_tag|label_tag|text_field_tag|submit_tag|check_box_tag|" +
        "content_tag|radio_button_tag|text_area_tag|password_field_tag|hidden_field_tag|" +
        "fields_for|select_tag|options_for_select|options_from_collection_for_select|collection_select|" +
        "time_zone_select|select_date|select_time|select_datetime|date_select|time_select|datetime_select|" +
        "select_year|select_month|select_day|select_hour|select_minute|select_second|file_field_tag|" +
        "file_field|respond_to|skip_before_filter|around_filter|after_filter|verify|" +
        "protect_from_forgery|rescue_from|helper_method|redirect_to|before_filter|" +
        "send_data|send_file|validates_presence_of|validates_uniqueness_of|validates_length_of|" +
        "validates_format_of|validates_acceptance_of|validates_associated|validates_exclusion_of|" +
        "validates_inclusion_of|validates_numericality_of|validates_with|validates_each|" +
        "authenticate_or_request_with_http_basic|authenticate_or_request_with_http_digest|" +
        "filter_parameter_logging|match|get|post|resources|redirect|scope|assert_routing|" +
        "translate|localize|extract_locale_from_tld|caches_page|expire_page|caches_action|expire_action|" +
        "cache|expire_fragment|expire_cache_for|observe|cache_sweeper|" +
        "has_many|has_one|belongs_to|has_and_belongs_to_many|p|warn|refine|using|module_function|extend|alias_method|" +
        "private_class_method|remove_method|undef_method");
    var keywords = ("alias|and|BEGIN|begin|break|case|class|def|defined|do|else|elsif|END|end|ensure|" +
        "__FILE__|finally|for|gem|if|in|__LINE__|module|next|not|or|private|protected|public|" +
        "redo|rescue|retry|return|super|then|undef|unless|until|when|while|yield|__ENCODING__|prepend");
    var buildinConstants = ("true|TRUE|false|FALSE|nil|NIL|ARGF|ARGV|DATA|ENV|RUBY_PLATFORM|RUBY_RELEASE_DATE|" +
        "RUBY_VERSION|STDERR|STDIN|STDOUT|TOPLEVEL_BINDING|RUBY_PATCHLEVEL|RUBY_REVISION|RUBY_COPYRIGHT|RUBY_ENGINE|RUBY_ENGINE_VERSION|RUBY_DESCRIPTION");
    var builtinVariables = ("$DEBUG|$defout|$FILENAME|$LOAD_PATH|$SAFE|$stdin|$stdout|$stderr|$VERBOSE|" +
        "$!|root_url|flash|session|cookies|params|request|response|logger|self");
    var keywordMapper = this.$keywords = this.createKeywordMapper({
        "keyword": keywords,
        "constant.language": buildinConstants,
        "variable.language": builtinVariables,
        "support.function": builtinFunctions,
        "invalid.deprecated": "debugger" // TODO is this a remnant from js mode?
    }, "identifier");
    var escapedChars = "\\\\(?:n(?:[1-7][0-7]{0,2}|0)|[nsrtvfbae'\"\\\\]|c(?:\\\\M-)?.|M-(?:\\\\C-|\\\\c)?.|C-(?:\\\\M-)?.|[0-7]{3}|x[\\da-fA-F]{2}|u[\\da-fA-F]{4}|u{[\\da-fA-F]{1,6}(?:\\s[\\da-fA-F]{1,6})*})";
    var closeParen = {
        "(": ")",
        "[": "]",
        "{": "}",
        "<": ">",
        "^": "^",
        "|": "|",
        "%": "%"
    };
    this.$rules = {
        "start": [
            {
                token: "comment",
                regex: "#.*$"
            }, {
                token: "comment.multiline",
                regex: "^=begin(?=$|\\s.*$)",
                next: "comment"
            }, {
                token: "string.regexp",
                regex: /[/](?=.*\/)/,
                next: "regex"
            },
            [{
                    token: ["constant.other.symbol.ruby", "string.start"],
                    regex: /(:)?(")/,
                    push: [{
                            token: "constant.language.escape",
                            regex: escapedChars
                        }, {
                            token: "paren.start",
                            regex: /#{/,
                            push: "start"
                        }, {
                            token: "string.end",
                            regex: /"/,
                            next: "pop"
                        }, {
                            defaultToken: "string"
                        }]
                }, {
                    token: "string.start",
                    regex: /`/,
                    push: [{
                            token: "constant.language.escape",
                            regex: escapedChars
                        }, {
                            token: "paren.start",
                            regex: /#{/,
                            push: "start"
                        }, {
                            token: "string.end",
                            regex: /`/,
                            next: "pop"
                        }, {
                            defaultToken: "string"
                        }]
                }, {
                    token: ["constant.other.symbol.ruby", "string.start"],
                    regex: /(:)?(')/,
                    push: [{
                            token: "constant.language.escape",
                            regex: /\\['\\]/
                        }, {
                            token: "string.end",
                            regex: /'/,
                            next: "pop"
                        }, {
                            defaultToken: "string"
                        }]
                }, {
                    token: "string.start",
                    regex: /%[qwx]([(\[<{^|%])/, onMatch: function (val, state, stack) {
                        if (stack.length)
                            stack = [];
                        var paren = val[val.length - 1];
                        stack.unshift(paren, state);
                        this.next = "qStateWithoutInterpolation";
                        return this.token;
                    }
                }, {
                    token: "string.start",
                    regex: /%[QWX]?([(\[<{^|%])/, onMatch: function (val, state, stack) {
                        if (stack.length)
                            stack = [];
                        var paren = val[val.length - 1];
                        stack.unshift(paren, state);
                        this.next = "qStateWithInterpolation";
                        return this.token;
                    }
                }, {
                    token: "constant.other.symbol.ruby",
                    regex: /%[si]([(\[<{^|%])/, onMatch: function (val, state, stack) {
                        if (stack.length)
                            stack = [];
                        var paren = val[val.length - 1];
                        stack.unshift(paren, state);
                        this.next = "sStateWithoutInterpolation";
                        return this.token;
                    }
                }, {
                    token: "constant.other.symbol.ruby",
                    regex: /%[SI]([(\[<{^|%])/, onMatch: function (val, state, stack) {
                        if (stack.length)
                            stack = [];
                        var paren = val[val.length - 1];
                        stack.unshift(paren, state);
                        this.next = "sStateWithInterpolation";
                        return this.token;
                    }
                }, {
                    token: "string.regexp",
                    regex: /%[r]([(\[<{^|%])/, onMatch: function (val, state, stack) {
                        if (stack.length)
                            stack = [];
                        var paren = val[val.length - 1];
                        stack.unshift(paren, state);
                        this.next = "rState";
                        return this.token;
                    }
                }],
            {
                token: "punctuation",
                regex: "::"
            },
            instanceVariable,
            {
                token: "variable.global",
                regex: "[$][a-zA-Z_\\d]+"
            }, {
                token: "support.class",
                regex: "[A-Z][a-zA-Z_\\d]*"
            }, {
                token: ["punctuation.operator", "support.function"],
                regex: /(\.)([a-zA-Z_\d]+)(?=\()/
            }, {
                token: ["punctuation.operator", "identifier"],
                regex: /(\.)([a-zA-Z_][a-zA-Z_\d]*)/
            }, {
                token: "string.character",
                regex: "\\B\\?(?:" + escapedChars + "|\\S)"
            }, {
                token: "punctuation.operator",
                regex: /\?(?=.+:)/
            },
            constantNumericRational,
            constantNumericComplex,
            constantOtherSymbol,
            constantNumericHex,
            constantNumericFloat,
            constantNumericBinary,
            constantNumericDecimal,
            constantNumericOctal,
            {
                token: "constant.language.boolean",
                regex: "(?:true|false)\\b"
            }, {
                token: keywordMapper,
                regex: "[a-zA-Z_$][a-zA-Z0-9_$]*\\b"
            }, {
                token: "punctuation.separator.key-value",
                regex: "=>"
            }, {
                stateName: "heredoc",
                onMatch: function (value, currentState, stack) {
                    var next = (value[2] == '-' || value[2] == '~') ? "indentedHeredoc" : "heredoc";
                    var tokens = value.split(this.splitRegex);
                    stack.push(next, tokens[3]);
                    return [
                        { type: "constant", value: tokens[1] },
                        { type: "string", value: tokens[2] },
                        { type: "support.class", value: tokens[3] },
                        { type: "string", value: tokens[4] }
                    ];
                },
                regex: "(<<[-~]?)(['\"`]?)([\\w]+)(['\"`]?)",
                rules: {
                    heredoc: [{
                            onMatch: function (value, currentState, stack) {
                                if (value === stack[1]) {
                                    stack.shift();
                                    stack.shift();
                                    this.next = stack[0] || "start";
                                    return "support.class";
                                }
                                this.next = "";
                                return "string";
                            },
                            regex: ".*$",
                            next: "start"
                        }],
                    indentedHeredoc: [{
                            token: "string",
                            regex: "^ +"
                        }, {
                            onMatch: function (value, currentState, stack) {
                                if (value === stack[1]) {
                                    stack.shift();
                                    stack.shift();
                                    this.next = stack[0] || "start";
                                    return "support.class";
                                }
                                this.next = "";
                                return "string";
                            },
                            regex: ".*$",
                            next: "start"
                        }]
                }
            }, {
                regex: "$",
                token: "empty",
                next: function (currentState, stack) {
                    if (stack[0] === "heredoc" || stack[0] === "indentedHeredoc")
                        return stack[0];
                    return currentState;
                }
            }, {
                token: "keyword.operator",
                regex: "!|\\$|%|&|\\*|/|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^=|\\||\\b(?:in|instanceof|new|delete|typeof|void)"
            }, {
                token: "paren.lparen",
                regex: "[[({]"
            }, {
                token: "paren.rparen",
                regex: "[\\])}]",
                onMatch: function (value, currentState, stack) {
                    this.next = '';
                    if (value == "}" && stack.length > 1 && stack[1] != "start") {
                        stack.shift();
                        this.next = stack.shift();
                    }
                    return this.token;
                }
            }, {
                token: "text",
                regex: "\\s+"
            }, {
                token: "punctuation.operator",
                regex: /[?:,;.]/
            }
        ],
        "comment": [
            {
                token: "comment.multiline",
                regex: "^=end(?=$|\\s.*$)",
                next: "start"
            }, {
                token: "comment",
                regex: ".+"
            }
        ],
        "qStateWithInterpolation": [{
                token: "string.start",
                regex: /[(\[<{]/, onMatch: function (val, state, stack) {
                    if (stack.length && val === stack[0]) {
                        stack.unshift(val, state);
                        return this.token;
                    }
                    return "string";
                }
            }, {
                token: "constant.language.escape",
                regex: escapedChars
            }, {
                token: "constant.language.escape",
                regex: /\\./
            }, {
                token: "paren.start",
                regex: /#{/,
                push: "start"
            }, {
                token: "string.end",
                regex: /[)\]>}^|%]/, onMatch: function (val, state, stack) {
                    if (stack.length && val === closeParen[stack[0]]) {
                        stack.shift();
                        this.next = stack.shift();
                        return this.token;
                    }
                    this.next = '';
                    return "string";
                }
            }, {
                defaultToken: "string"
            }],
        "qStateWithoutInterpolation": [{
                token: "string.start",
                regex: /[(\[<{]/, onMatch: function (val, state, stack) {
                    if (stack.length && val === stack[0]) {
                        stack.unshift(val, state);
                        return this.token;
                    }
                    return "string";
                }
            }, {
                token: "constant.language.escape",
                regex: /\\['\\]/
            }, {
                token: "constant.language.escape",
                regex: /\\./
            }, {
                token: "string.end",
                regex: /[)\]>}^|%]/, onMatch: function (val, state, stack) {
                    if (stack.length && val === closeParen[stack[0]]) {
                        stack.shift();
                        this.next = stack.shift();
                        return this.token;
                    }
                    this.next = '';
                    return "string";
                }
            }, {
                defaultToken: "string"
            }],
        "sStateWithoutInterpolation": [{
                token: "constant.other.symbol.ruby",
                regex: /[(\[<{]/, onMatch: function (val, state, stack) {
                    if (stack.length && val === stack[0]) {
                        stack.unshift(val, state);
                        return this.token;
                    }
                    return "constant.other.symbol.ruby";
                }
            }, {
                token: "constant.other.symbol.ruby",
                regex: /[)\]>}^|%]/, onMatch: function (val, state, stack) {
                    if (stack.length && val === closeParen[stack[0]]) {
                        stack.shift();
                        this.next = stack.shift();
                        return this.token;
                    }
                    this.next = '';
                    return "constant.other.symbol.ruby";
                }
            }, {
                defaultToken: "constant.other.symbol.ruby"
            }],
        "sStateWithInterpolation": [{
                token: "constant.other.symbol.ruby",
                regex: /[(\[<{]/, onMatch: function (val, state, stack) {
                    if (stack.length && val === stack[0]) {
                        stack.unshift(val, state);
                        return this.token;
                    }
                    return "constant.other.symbol.ruby";
                }
            }, {
                token: "constant.language.escape",
                regex: escapedChars
            }, {
                token: "constant.language.escape",
                regex: /\\./
            }, {
                token: "paren.start",
                regex: /#{/,
                push: "start"
            }, {
                token: "constant.other.symbol.ruby",
                regex: /[)\]>}^|%]/, onMatch: function (val, state, stack) {
                    if (stack.length && val === closeParen[stack[0]]) {
                        stack.shift();
                        this.next = stack.shift();
                        return this.token;
                    }
                    this.next = '';
                    return "constant.other.symbol.ruby";
                }
            }, {
                defaultToken: "constant.other.symbol.ruby"
            }],
        "rState": [{
                token: "string.regexp",
                regex: /[(\[<{]/, onMatch: function (val, state, stack) {
                    if (stack.length && val === stack[0]) {
                        stack.unshift(val, state);
                        return this.token;
                    }
                    return "constant.language.escape";
                }
            }, {
                token: "paren.start",
                regex: /#{/,
                push: "start"
            }, {
                token: "string.regexp",
                regex: /\//
            }, {
                token: "string.regexp",
                regex: /[)\]>}^|%][imxouesn]*/, onMatch: function (val, state, stack) {
                    if (stack.length && val[0] === closeParen[stack[0]]) {
                        stack.shift();
                        this.next = stack.shift();
                        return this.token;
                    }
                    this.next = '';
                    return "constant.language.escape";
                }
            },
            { include: "regex" },
            {
                defaultToken: "string.regexp"
            }],
        "regex": [
            {
                token: "regexp.keyword",
                regex: /\\[wWdDhHsS]/
            }, {
                token: "constant.language.escape",
                regex: /\\[AGbBzZ]/
            }, {
                token: "constant.language.escape",
                regex: /\\g<[a-zA-Z0-9]*>/
            }, {
                token: ["constant.language.escape", "regexp.keyword", "constant.language.escape"],
                regex: /(\\p{\^?)(Alnum|Alpha|Blank|Cntrl|Digit|Graph|Lower|Print|Punct|Space|Upper|XDigit|Word|ASCII|Any|Assigned|Arabic|Armenian|Balinese|Bengali|Bopomofo|Braille|Buginese|Buhid|Canadian_Aboriginal|Carian|Cham|Cherokee|Common|Coptic|Cuneiform|Cypriot|Cyrillic|Deseret|Devanagari|Ethiopic|Georgian|Glagolitic|Gothic|Greek|Gujarati|Gurmukhi|Han|Hangul|Hanunoo|Hebrew|Hiragana|Inherited|Kannada|Katakana|Kayah_Li|Kharoshthi|Khmer|Lao|Latin|Lepcha|Limbu|Linear_B|Lycian|Lydian|Malayalam|Mongolian|Myanmar|New_Tai_Lue|Nko|Ogham|Ol_Chiki|Old_Italic|Old_Persian|Oriya|Osmanya|Phags_Pa|Phoenician|Rejang|Runic|Saurashtra|Shavian|Sinhala|Sundanese|Syloti_Nagri|Syriac|Tagalog|Tagbanwa|Tai_Le|Tamil|Telugu|Thaana|Thai|Tibetan|Tifinagh|Ugaritic|Vai|Yi|Ll|Lm|Lt|Lu|Lo|Mn|Mc|Me|Nd|Nl|Pc|Pd|Ps|Pe|Pi|Pf|Po|No|Sm|Sc|Sk|So|Zs|Zl|Zp|Cc|Cf|Cn|Co|Cs|N|L|M|P|S|Z|C)(})/
            }, {
                token: ["constant.language.escape", "invalid", "constant.language.escape"],
                regex: /(\\p{\^?)([^/]*)(})/
            }, {
                token: "regexp.keyword.operator",
                regex: "\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"
            }, {
                token: "string.regexp",
                regex: /[/][imxouesn]*/,
                next: "start"
            }, {
                token: "invalid",
                regex: /\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/
            }, {
                token: "constant.language.escape",
                regex: /\(\?(?:[:=!>]|<'?[a-zA-Z]*'?>|<[=!])|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/
            }, {
                token: "constant.language.delimiter",
                regex: /\|/
            }, {
                token: "regexp.keyword",
                regex: /\[\[:(?:alnum|alpha|blank|cntrl|digit|graph|lower|print|punct|space|upper|xdigit|word|ascii):\]\]/
            }, {
                token: "constant.language.escape",
                regex: /\[\^?/,
                push: "regex_character_class"
            }, {
                defaultToken: "string.regexp"
            }
        ],
        "regex_character_class": [
            {
                token: "regexp.keyword",
                regex: /\\[wWdDhHsS]/
            }, {
                token: "regexp.charclass.keyword.operator",
                regex: "\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"
            }, {
                token: "constant.language.escape",
                regex: /&?&?\[\^?/,
                push: "regex_character_class"
            }, {
                token: "constant.language.escape",
                regex: "]",
                next: "pop"
            }, {
                token: "constant.language.escape",
                regex: "-"
            }, {
                defaultToken: "string.regexp.characterclass"
            }
        ]
    };
    this.normalizeRules();
};
oop.inherits(RubyHighlightRules, TextHighlightRules);
exports.RubyHighlightRules = RubyHighlightRules;

});

define("ace/mode/haml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/html_highlight_rules","ace/mode/ruby_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var HtmlHighlightRules = require("./html_highlight_rules").HtmlHighlightRules;
var RubyExports = require("./ruby_highlight_rules");
var RubyHighlightRules = RubyExports.RubyHighlightRules;
var HamlHighlightRules = function () {
    HtmlHighlightRules.call(this);
    this.$rules = {
        "start": [
            {
                token: "comment.block",
                regex: /^\/$/,
                next: "comment"
            },
            {
                token: "comment.block",
                regex: /^\-#$/,
                next: "comment"
            },
            {
                token: "comment.line",
                regex: /\/\s*.*/
            },
            {
                token: "comment.line",
                regex: /-#\s*.*/
            },
            {
                token: "keyword.other.doctype",
                regex: "^!!!\\s*(?:[a-zA-Z0-9-_]+)?"
            },
            RubyExports.qString,
            RubyExports.qqString,
            RubyExports.tString,
            {
                token: "meta.tag.haml",
                regex: /(%[\w:\-]+)/
            },
            {
                token: "keyword.attribute-name.class.haml",
                regex: /\.[\w-]+/
            },
            {
                token: "keyword.attribute-name.id.haml",
                regex: /#[\w-]+/,
                next: "element_class"
            },
            RubyExports.constantNumericHex,
            RubyExports.constantNumericFloat,
            RubyExports.constantOtherSymbol,
            {
                token: "text",
                regex: /=|-|~/,
                next: "embedded_ruby"
            }
        ],
        "element_class": [
            {
                token: "keyword.attribute-name.class.haml",
                regex: /\.[\w-]+/
            },
            {
                token: "punctuation.section",
                regex: /\{/,
                next: "element_attributes"
            },
            RubyExports.constantOtherSymbol,
            {
                token: "empty",
                regex: "$|(?!\\.|#|\\{|\\[|=|-|~|\\/])",
                next: "start"
            }
        ],
        "element_attributes": [
            RubyExports.constantOtherSymbol,
            RubyExports.qString,
            RubyExports.qqString,
            RubyExports.tString,
            RubyExports.constantNumericHex,
            RubyExports.constantNumericFloat,
            {
                token: "punctuation.section",
                regex: /$|\}/,
                next: "start"
            }
        ],
        "embedded_ruby": [
            RubyExports.constantNumericHex,
            RubyExports.constantNumericFloat,
            RubyExports.instanceVariable,
            RubyExports.qString,
            RubyExports.qqString,
            RubyExports.tString,
            {
                token: "support.class",
                regex: "[A-Z][a-zA-Z_\\d]+"
            },
            {
                token: new RubyHighlightRules().getKeywords(),
                regex: "[a-zA-Z_$][a-zA-Z0-9_$]*\\b"
            },
            {
                token: ["keyword", "text", "text"],
                regex: "(?:do|\\{)(?: \\|[^|]+\\|)?$",
                next: "start"
            },
            {
                token: ["text"],
                regex: "^$",
                next: "start"
            },
            {
                token: ["text"],
                regex: "^(?!.*\\|\\s*$)",
                next: "start"
            }
        ],
        "comment": [
            {
                token: "comment.block",
                regex: /^$/,
                next: "start"
            },
            {
                token: "comment.block",
                regex: /\s+.*/
            }
        ]
    };
    this.normalizeRules();
};
oop.inherits(HamlHighlightRules, HtmlHighlightRules);
exports.HamlHighlightRules = HamlHighlightRules;

});

define("ace/mode/haml",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/haml_highlight_rules","ace/mode/folding/coffee"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY mode.tmpl.js
*/
"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var HamlHighlightRules = require("./haml_highlight_rules").HamlHighlightRules;
var FoldMode = require("./folding/coffee").FoldMode;
var Mode = function () {
    this.HighlightRules = HamlHighlightRules;
    this.foldingRules = new FoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "//";
    this.$id = "ace/mode/haml";
    this.snippetFileId = "ace/snippets/haml";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/handlebars_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/html_highlight_rules"], function(require, exports, module){/* global define */
"use strict";
var oop = require("../lib/oop");
var HtmlHighlightRules = require("./html_highlight_rules").HtmlHighlightRules;
function pop2(currentState, stack) {
    stack.splice(0, 3);
    return stack.shift() || "start";
}
var HandlebarsHighlightRules = function () {
    HtmlHighlightRules.call(this);
    var hbs = {
        regex: "(?={{)",
        push: "handlebars"
    };
    for (var key in this.$rules) {
        this.$rules[key].unshift(hbs);
    }
    this.$rules.handlebars = [{
            token: "comment.start",
            regex: "{{!--",
            push: [{
                    token: "comment.end",
                    regex: "--}}",
                    next: pop2
                }, {
                    defaultToken: "comment"
                }]
        }, {
            token: "comment.start",
            regex: "{{!",
            push: [{
                    token: "comment.end",
                    regex: "}}",
                    next: pop2
                }, {
                    defaultToken: "comment"
                }]
        }, {
            token: "support.function",
            regex: "{{{",
            push: [{
                    token: "support.function",
                    regex: "}}}",
                    next: pop2
                }, {
                    token: "variable.parameter",
                    regex: "[a-zA-Z_$][a-zA-Z0-9_$]*"
                }]
        }, {
            token: "storage.type.start",
            regex: "{{[#\\^/&]?",
            push: [{
                    token: "storage.type.end",
                    regex: "}}",
                    next: pop2
                }, {
                    token: "variable.parameter",
                    regex: "[a-zA-Z_$][a-zA-Z0-9_$]*"
                }]
        }];
    this.normalizeRules();
};
oop.inherits(HandlebarsHighlightRules, HtmlHighlightRules);
exports.HandlebarsHighlightRules = HandlebarsHighlightRules;

});

define("ace/mode/behaviour/html",["require","exports","module","ace/lib/oop","ace/mode/behaviour/xml"], function(require, exports, module){"use strict";
var oop = require("../../lib/oop");
var XmlBehaviour = require("../behaviour/xml").XmlBehaviour;
var HtmlBehaviour = function () {
    XmlBehaviour.call(this);
};
oop.inherits(HtmlBehaviour, XmlBehaviour);
exports.HtmlBehaviour = HtmlBehaviour;

});

define("ace/mode/handlebars",["require","exports","module","ace/lib/oop","ace/mode/html","ace/mode/handlebars_highlight_rules","ace/mode/behaviour/html","ace/mode/folding/html"], function(require, exports, module){/* global define */
"use strict";
var oop = require("../lib/oop");
var HtmlMode = require("./html").Mode;
var HandlebarsHighlightRules = require("./handlebars_highlight_rules").HandlebarsHighlightRules;
var HtmlBehaviour = require("./behaviour/html").HtmlBehaviour;
var HtmlFoldMode = require("./folding/html").FoldMode;
var Mode = function () {
    HtmlMode.call(this);
    this.HighlightRules = HandlebarsHighlightRules;
    this.$behaviour = new HtmlBehaviour();
};
oop.inherits(Mode, HtmlMode);
(function () {
    this.blockComment = { start: "{{!--", end: "--}}" };
    this.$id = "ace/mode/handlebars";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/haskell_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){/* This file was autogenerated from tm bundles\haskell.tmbundle\Syntaxes\Haskell.plist (uuid: ) */
"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var HaskellHighlightRules = function () {
    this.$rules = { start: [{ token: ['punctuation.definition.entity.haskell',
                    'keyword.operator.function.infix.haskell',
                    'punctuation.definition.entity.haskell'],
                regex: '(`)([a-zA-Z_\']*?)(`)',
                comment: 'In case this regex seems unusual for an infix operator, note that Haskell allows any ordinary function application (elem 4 [1..10]) to be rewritten as an infix expression (4 `elem` [1..10]).' },
            { token: 'constant.language.unit.haskell', regex: '\\(\\)' },
            { token: 'constant.language.empty-list.haskell',
                regex: '\\[\\]' },
            { token: 'keyword.other.haskell',
                regex: '\\b(module|signature)\\b',
                push: [{ token: 'keyword.other.haskell', regex: '\\bwhere\\b', next: 'pop' },
                    { include: '#module_name' },
                    { include: '#module_exports' },
                    { token: 'invalid', regex: '[a-z]+' },
                    { defaultToken: 'meta.declaration.module.haskell' }] },
            { token: 'keyword.other.haskell',
                regex: '\\bclass\\b',
                push: [{ token: 'keyword.other.haskell',
                        regex: '\\bwhere\\b',
                        next: 'pop' },
                    { token: 'support.class.prelude.haskell',
                        regex: '\\b(?:Monad|Functor|Eq|Ord|Read|Show|Num|(?:Frac|Ra)tional|Enum|Bounded|Real(?:Frac|Float)?|Integral|Floating)\\b' },
                    { token: 'entity.other.inherited-class.haskell',
                        regex: '[A-Z][A-Za-z_\']*' },
                    { token: 'variable.other.generic-type.haskell',
                        regex: '\\b[a-z][a-zA-Z0-9_\']*\\b' },
                    { defaultToken: 'meta.declaration.class.haskell' }] },
            { token: 'keyword.other.haskell',
                regex: '\\binstance\\b',
                push: [{ token: 'keyword.other.haskell',
                        regex: '\\bwhere\\b|$',
                        next: 'pop' },
                    { include: '#type_signature' },
                    { defaultToken: 'meta.declaration.instance.haskell' }] },
            { token: 'keyword.other.haskell',
                regex: 'import',
                push: [{ token: 'meta.import.haskell', regex: '$|;|^', next: 'pop' },
                    { token: 'keyword.other.haskell', regex: 'qualified|as|hiding' },
                    { include: '#module_name' },
                    { include: '#module_exports' },
                    { defaultToken: 'meta.import.haskell' }] },
            { token: ['keyword.other.haskell', 'meta.deriving.haskell'],
                regex: '(deriving)(\\s*\\()',
                push: [{ token: 'meta.deriving.haskell', regex: '\\)', next: 'pop' },
                    { token: 'entity.other.inherited-class.haskell',
                        regex: '\\b[A-Z][a-zA-Z_\']*' },
                    { defaultToken: 'meta.deriving.haskell' }] },
            { token: 'keyword.other.haskell',
                regex: '\\b(?:deriving|where|data|type|case|of|let|in|newtype|default)\\b' },
            { token: 'keyword.operator.haskell', regex: '\\binfix[lr]?\\b' },
            { token: 'keyword.control.haskell',
                regex: '\\b(?:do|if|then|else)\\b' },
            { token: 'constant.numeric.float.haskell',
                regex: '\\b(?:[0-9]+\\.[0-9]+(?:[eE][+-]?[0-9]+)?|[0-9]+[eE][+-]?[0-9]+)\\b',
                comment: 'Floats are always decimal' },
            { token: 'constant.numeric.haskell',
                regex: '\\b(?:[0-9]+|0(?:[xX][0-9a-fA-F]+|[oO][0-7]+))\\b' },
            { token: ['meta.preprocessor.c',
                    'punctuation.definition.preprocessor.c',
                    'meta.preprocessor.c'],
                regex: '^(\\s*)(#)(\\s*\\w+)',
                comment: 'In addition to Haskell\'s "native" syntax, GHC permits the C preprocessor to be run on a source file.' },
            { include: '#pragma' },
            { token: 'punctuation.definition.string.begin.haskell',
                regex: '"',
                push: [{ token: 'punctuation.definition.string.end.haskell',
                        regex: '"',
                        next: 'pop' },
                    { token: 'constant.character.escape.haskell',
                        regex: '\\\\(?:NUL|SOH|STX|ETX|EOT|ENQ|ACK|BEL|BS|HT|LF|VT|FF|CR|SO|SI|DLE|DC1|DC2|DC3|DC4|NAK|SYN|ETB|CAN|EM|SUB|ESC|FS|GS|RS|US|SP|DEL|[abfnrtv\\\\\\"\'\\&])' },
                    { token: 'constant.character.escape.octal.haskell',
                        regex: '\\\\o[0-7]+|\\\\x[0-9A-Fa-f]+|\\\\[0-9]+' },
                    { token: 'constant.character.escape.control.haskell',
                        regex: '\\^[A-Z@\\[\\]\\\\\\^_]' },
                    { defaultToken: 'string.quoted.double.haskell' }] },
            { token: ['punctuation.definition.string.begin.haskell',
                    'string.quoted.single.haskell',
                    'constant.character.escape.haskell',
                    'constant.character.escape.octal.haskell',
                    'constant.character.escape.hexadecimal.haskell',
                    'constant.character.escape.control.haskell',
                    'punctuation.definition.string.end.haskell'],
                regex: '(\')(?:([\\ -\\[\\]-~])|(\\\\(?:NUL|SOH|STX|ETX|EOT|ENQ|ACK|BEL|BS|HT|LF|VT|FF|CR|SO|SI|DLE|DC1|DC2|DC3|DC4|NAK|SYN|ETB|CAN|EM|SUB|ESC|FS|GS|RS|US|SP|DEL|[abfnrtv\\\\\\"\'\\&]))|(\\\\o[0-7]+)|(\\\\x[0-9A-Fa-f]+)|(\\^[A-Z@\\[\\]\\\\\\^_]))(\')' },
            { token: ['meta.function.type-declaration.haskell',
                    'entity.name.function.haskell',
                    'meta.function.type-declaration.haskell',
                    'keyword.other.double-colon.haskell'],
                regex: '^(\\s*)([a-z_][a-zA-Z0-9_\']*|\\([|!%$+\\-.,=</>]+\\))(\\s*)(::)',
                push: [{ token: 'meta.function.type-declaration.haskell',
                        regex: '$',
                        next: 'pop' },
                    { include: '#type_signature' },
                    { defaultToken: 'meta.function.type-declaration.haskell' }] },
            { token: 'support.constant.haskell',
                regex: '\\b(?:Just|Nothing|Left|Right|True|False|LT|EQ|GT|\\(\\)|\\[\\])\\b' },
            { token: 'constant.other.haskell', regex: '\\b[A-Z]\\w*\\b' },
            { include: '#comments' },
            { token: 'support.function.prelude.haskell',
                regex: '\\b(?:abs|acos|acosh|all|and|any|appendFile|applyM|asTypeOf|asin|asinh|atan|atan2|atanh|break|catch|ceiling|compare|concat|concatMap|const|cos|cosh|curry|cycle|decodeFloat|div|divMod|drop|dropWhile|elem|encodeFloat|enumFrom|enumFromThen|enumFromThenTo|enumFromTo|error|even|exp|exponent|fail|filter|flip|floatDigits|floatRadix|floatRange|floor|fmap|foldl|foldl1|foldr|foldr1|fromEnum|fromInteger|fromIntegral|fromRational|fst|gcd|getChar|getContents|getLine|head|id|init|interact|ioError|isDenormalized|isIEEE|isInfinite|isNaN|isNegativeZero|iterate|last|lcm|length|lex|lines|log|logBase|lookup|map|mapM|mapM_|max|maxBound|maximum|maybe|min|minBound|minimum|mod|negate|not|notElem|null|odd|or|otherwise|pi|pred|print|product|properFraction|putChar|putStr|putStrLn|quot|quotRem|read|readFile|readIO|readList|readLn|readParen|reads|readsPrec|realToFrac|recip|rem|repeat|replicate|return|reverse|round|scaleFloat|scanl|scanl1|scanr|scanr1|seq|sequence|sequence_|show|showChar|showList|showParen|showString|shows|showsPrec|significand|signum|sin|sinh|snd|span|splitAt|sqrt|subtract|succ|sum|tail|take|takeWhile|tan|tanh|toEnum|toInteger|toRational|truncate|uncurry|undefined|unlines|until|unwords|unzip|unzip3|userError|words|writeFile|zip|zip3|zipWith|zipWith3)\\b' },
            { include: '#infix_op' },
            { token: 'keyword.operator.haskell',
                regex: '[|!%$?~+:\\-.=</>\\\\]+',
                comment: 'In case this regex seems overly general, note that Haskell permits the definition of new operators which can be nearly any string of punctuation characters, such as $%^&*.' },
            { token: 'punctuation.separator.comma.haskell', regex: ',' }],
        '#block_comment': [{ token: 'punctuation.definition.comment.haskell',
                regex: '\\{-(?!#)',
                push: [{ include: '#block_comment' },
                    { token: 'punctuation.definition.comment.haskell',
                        regex: '-\\}',
                        next: 'pop' },
                    { defaultToken: 'comment.block.haskell' }] }],
        '#comments': [{ token: 'punctuation.definition.comment.haskell',
                regex: '--.*',
                push_: [{ token: 'comment.line.double-dash.haskell',
                        regex: '$',
                        next: 'pop' },
                    { defaultToken: 'comment.line.double-dash.haskell' }] },
            { include: '#block_comment' }],
        '#infix_op': [{ token: 'entity.name.function.infix.haskell',
                regex: '\\([|!%$+:\\-.=</>]+\\)|\\(,+\\)' }],
        '#module_exports': [{ token: 'meta.declaration.exports.haskell',
                regex: '\\(',
                push: [{ token: 'meta.declaration.exports.haskell.end',
                        regex: '\\)',
                        next: 'pop' },
                    { token: 'entity.name.function.haskell',
                        regex: '\\b[a-z][a-zA-Z_\']*' },
                    { token: 'storage.type.haskell', regex: '\\b[A-Z][A-Za-z_\']*' },
                    { token: 'punctuation.separator.comma.haskell', regex: ',' },
                    { include: '#infix_op' },
                    { token: 'meta.other.unknown.haskell',
                        regex: '\\(.*?\\)',
                        comment: 'So named because I don\'t know what to call this.' },
                    { defaultToken: 'meta.declaration.exports.haskell.end' }] }],
        '#module_name': [{ token: 'support.other.module.haskell',
                regex: '[A-Z][A-Za-z._\']*' }],
        '#pragma': [{ token: 'meta.preprocessor.haskell',
                regex: '\\{-#',
                push: [{ token: 'meta.preprocessor.haskell',
                        regex: '#-\\}',
                        next: 'pop' },
                    { token: 'keyword.other.preprocessor.haskell',
                        regex: '\\b(?:LANGUAGE|UNPACK|INLINE)\\b' },
                    { defaultToken: 'meta.preprocessor.haskell' }] }],
        '#type_signature': [{ token: ['meta.class-constraint.haskell',
                    'entity.other.inherited-class.haskell',
                    'meta.class-constraint.haskell',
                    'variable.other.generic-type.haskell',
                    'meta.class-constraint.haskell',
                    'keyword.other.big-arrow.haskell'],
                regex: '(\\(\\s*)([A-Z][A-Za-z]*)(\\s+)([a-z][A-Za-z_\']*)(\\)\\s*)(=>)' },
            { include: '#pragma' },
            { token: 'keyword.other.arrow.haskell', regex: '->' },
            { token: 'keyword.other.big-arrow.haskell', regex: '=>' },
            { token: 'support.type.prelude.haskell',
                regex: '\\b(?:Int(?:eger)?|Maybe|Either|Bool|Float|Double|Char|String|Ordering|ShowS|ReadS|FilePath|IO(?:Error)?)\\b' },
            { token: 'variable.other.generic-type.haskell',
                regex: '\\b[a-z][a-zA-Z0-9_\']*\\b' },
            { token: 'storage.type.haskell',
                regex: '\\b[A-Z][a-zA-Z0-9_\']*\\b' },
            { token: 'support.constant.unit.haskell', regex: '\\(\\)' },
            { include: '#comments' }] };
    this.normalizeRules();
};
HaskellHighlightRules.metaData = { fileTypes: ['hs'],
    keyEquivalent: '^~H',
    name: 'Haskell',
    scopeName: 'source.haskell' };
oop.inherits(HaskellHighlightRules, TextHighlightRules);
exports.HaskellHighlightRules = HaskellHighlightRules;

});

define("ace/mode/haskell",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/haskell_highlight_rules","ace/mode/folding/cstyle"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY mode.tmpl.js
*/
"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var HaskellHighlightRules = require("./haskell_highlight_rules").HaskellHighlightRules;
var FoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = HaskellHighlightRules;
    this.foldingRules = new FoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "--";
    this.blockComment = null;
    this.$id = "ace/mode/haskell";
    this.snippetFileId = "ace/snippets/haskell";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/haxe_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var DocCommentHighlightRules = require("./doc_comment_highlight_rules").DocCommentHighlightRules;
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var HaxeHighlightRules = function () {
    var keywords = ("break|case|cast|catch|class|continue|default|else|enum|extends|for|function|if|implements|import|in|inline|interface|new|override|package|private|public|return|static|super|switch|this|throw|trace|try|typedef|untyped|var|while|Array|Void|Bool|Int|UInt|Float|Dynamic|String|List|Hash|IntHash|Error|Unknown|Type|Std");
    var buildinConstants = ("null|true|false");
    var keywordMapper = this.createKeywordMapper({
        "variable.language": "this",
        "keyword": keywords,
        "constant.language": buildinConstants
    }, "identifier");
    this.$rules = {
        "start": [
            {
                token: "comment",
                regex: "\\/\\/.*$"
            },
            DocCommentHighlightRules.getStartRule("doc-start"),
            {
                token: "comment",
                regex: "\\/\\*",
                next: "comment"
            }, {
                token: "string.regexp",
                regex: "[/](?:(?:\\[(?:\\\\]|[^\\]])+\\])|(?:\\\\/|[^\\]/]))*[/]\\w*\\s*(?=[).,;]|$)"
            }, {
                token: "string",
                regex: '["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'
            }, {
                token: "string",
                regex: "['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"
            }, {
                token: "constant.numeric",
                regex: "0[xX][0-9a-fA-F]+\\b"
            }, {
                token: "constant.numeric",
                regex: "[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"
            }, {
                token: "constant.language.boolean",
                regex: "(?:true|false)\\b"
            }, {
                token: keywordMapper,
                regex: "[a-zA-Z_$][a-zA-Z0-9_$]*\\b"
            }, {
                token: "keyword.operator",
                regex: "!|\\$|%|&|\\*|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^=|\\b(?:in|instanceof|new|delete|typeof|void)"
            }, {
                token: "punctuation.operator",
                regex: "\\?|\\:|\\,|\\;|\\."
            }, {
                token: "paren.lparen",
                regex: "[[({<]"
            }, {
                token: "paren.rparen",
                regex: "[\\])}>]"
            }, {
                token: "text",
                regex: "\\s+"
            }
        ],
        "comment": [
            {
                token: "comment",
                regex: "\\*\\/",
                next: "start"
            }, {
                defaultToken: "comment"
            }
        ]
    };
    this.embedRules(DocCommentHighlightRules, "doc-", [DocCommentHighlightRules.getEndRule("start")]);
};
oop.inherits(HaxeHighlightRules, TextHighlightRules);
exports.HaxeHighlightRules = HaxeHighlightRules;

});

define("ace/mode/haxe",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/haxe_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/cstyle"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var HaxeHighlightRules = require("./haxe_highlight_rules").HaxeHighlightRules;
var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var CStyleFoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = HaxeHighlightRules;
    this.$outdent = new MatchingBraceOutdent();
    this.$behaviour = this.$defaultBehaviour;
    this.foldingRules = new CStyleFoldMode();
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "//";
    this.blockComment = { start: "/*", end: "*/" };
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        var tokenizedLine = this.getTokenizer().getLineTokens(line, state);
        var tokens = tokenizedLine.tokens;
        if (tokens.length && tokens[tokens.length - 1].type == "comment") {
            return indent;
        }
        if (state == "start") {
            var match = line.match(/^.*[\{\(\[]\s*$/);
            if (match) {
                indent += tab;
            }
        }
        return indent;
    };
    this.checkOutdent = function (state, line, input) {
        return this.$outdent.checkOutdent(line, input);
    };
    this.autoOutdent = function (state, doc, row) {
        this.$outdent.autoOutdent(doc, row);
    };
    this.$id = "ace/mode/haxe";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/ini_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){/* This file was autogenerated from tool\tm bundles\ini.tmbundle\Syntaxes\Ini.plist (uuid: ) */
"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var escapeRe = "\\\\(?:[\\\\0abtrn;#=:]|x[a-fA-F\\d]{4})";
var IniHighlightRules = function () {
    this.$rules = {
        start: [{
                token: 'punctuation.definition.comment.ini',
                regex: '#.*',
                push_: [{
                        token: 'comment.line.number-sign.ini',
                        regex: '$|^',
                        next: 'pop'
                    }, {
                        defaultToken: 'comment.line.number-sign.ini'
                    }]
            }, {
                token: 'punctuation.definition.comment.ini',
                regex: ';.*',
                push_: [{
                        token: 'comment.line.semicolon.ini',
                        regex: '$|^',
                        next: 'pop'
                    }, {
                        defaultToken: 'comment.line.semicolon.ini'
                    }]
            }, {
                token: ['keyword.other.definition.ini', 'text', 'punctuation.separator.key-value.ini'],
                regex: '\\b([a-zA-Z0-9_.-]+)\\b(\\s*)(=)'
            }, {
                token: ['punctuation.definition.entity.ini', 'constant.section.group-title.ini', 'punctuation.definition.entity.ini'],
                regex: '^(\\[)(.*?)(\\])'
            }, {
                token: 'punctuation.definition.string.begin.ini',
                regex: "'",
                push: [{
                        token: 'punctuation.definition.string.end.ini',
                        regex: "'",
                        next: 'pop'
                    }, {
                        token: "constant.language.escape",
                        regex: escapeRe
                    }, {
                        defaultToken: 'string.quoted.single.ini'
                    }]
            }, {
                token: 'punctuation.definition.string.begin.ini',
                regex: '"',
                push: [{
                        token: "constant.language.escape",
                        regex: escapeRe
                    }, {
                        token: 'punctuation.definition.string.end.ini',
                        regex: '"',
                        next: 'pop'
                    }, {
                        defaultToken: 'string.quoted.double.ini'
                    }]
            }]
    };
    this.normalizeRules();
};
IniHighlightRules.metaData = {
    fileTypes: ['ini', 'conf'],
    keyEquivalent: '^~I',
    name: 'Ini',
    scopeName: 'source.ini'
};
oop.inherits(IniHighlightRules, TextHighlightRules);
exports.IniHighlightRules = IniHighlightRules;

});

define("ace/mode/folding/ini",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"], function(require, exports, module){"use strict";
var oop = require("../../lib/oop");
var Range = require("../../range").Range;
var BaseFoldMode = require("./fold_mode").FoldMode;
var FoldMode = exports.FoldMode = function () {
};
oop.inherits(FoldMode, BaseFoldMode);
(function () {
    this.foldingStartMarker = /^\s*\[([^\])]*)]\s*(?:$|[;#])/;
    this.getFoldWidgetRange = function (session, foldStyle, row) {
        var re = this.foldingStartMarker;
        var line = session.getLine(row);
        var m = line.match(re);
        if (!m)
            return;
        var startName = m[1] + ".";
        var startColumn = line.length;
        var maxRow = session.getLength();
        var startRow = row;
        var endRow = row;
        while (++row < maxRow) {
            line = session.getLine(row);
            if (/^\s*$/.test(line))
                continue;
            m = line.match(re);
            if (m && m[1].lastIndexOf(startName, 0) !== 0)
                break;
            endRow = row;
        }
        if (endRow > startRow) {
            var endColumn = session.getLine(endRow).length;
            return new Range(startRow, startColumn, endRow, endColumn);
        }
    };
}).call(FoldMode.prototype);

});

define("ace/mode/ini",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/ini_highlight_rules","ace/mode/folding/ini"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var IniHighlightRules = require("./ini_highlight_rules").IniHighlightRules;
var FoldMode = require("./folding/ini").FoldMode;
var Mode = function () {
    this.HighlightRules = IniHighlightRules;
    this.foldingRules = new FoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = ";";
    this.blockComment = null;
    this.$id = "ace/mode/ini";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/io_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){/* This file was autogenerated from tm bundles\io.tmbundle/Syntaxes/io.plist (uuid: ) */
"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var IoHighlightRules = function () {
    this.$rules = { start: [{ token: 'keyword.control.io',
                regex: '\\b(?:if|ifTrue|ifFalse|ifTrueIfFalse|for|loop|reverseForeach|foreach|map|continue|break|while|do|return)\\b' },
            { token: 'punctuation.definition.comment.io',
                regex: '/\\*',
                push: [{ token: 'punctuation.definition.comment.io',
                        regex: '\\*/',
                        next: 'pop' },
                    { defaultToken: 'comment.block.io' }] },
            { token: 'punctuation.definition.comment.io',
                regex: '//',
                push: [{ token: 'comment.line.double-slash.io',
                        regex: '$',
                        next: 'pop' },
                    { defaultToken: 'comment.line.double-slash.io' }] },
            { token: 'punctuation.definition.comment.io',
                regex: '#',
                push: [{ token: 'comment.line.number-sign.io', regex: '$', next: 'pop' },
                    { defaultToken: 'comment.line.number-sign.io' }] },
            { token: 'variable.language.io',
                regex: '\\b(?:self|sender|target|proto|protos|parent)\\b',
                comment: 'I wonder if some of this isn\'t variable.other.language? --Allan; scoping this as variable.language to match Objective-C\'s handling of \'self\', which is inconsistent with C++\'s handling of \'this\' but perhaps intentionally so -- Rob' },
            { token: 'keyword.operator.io',
                regex: '<=|>=|=|:=|\\*|\\||\\|\\||\\+|-|/|&|&&|>|<|\\?|@|@@|\\b(?:and|or)\\b' },
            { token: 'constant.other.io', regex: '\\bGL[\\w_]+\\b' },
            { token: 'support.class.io', regex: '\\b[A-Z](?:\\w+)?\\b' },
            { token: 'support.function.io',
                regex: '\\b(?:clone|call|init|method|list|vector|block|\\w+(?=\\s*\\())\\b' },
            { token: 'support.function.open-gl.io',
                regex: '\\bgl(?:u|ut)?[A-Z]\\w+\\b' },
            { token: 'punctuation.definition.string.begin.io',
                regex: '"""',
                push: [{ token: 'punctuation.definition.string.end.io',
                        regex: '"""',
                        next: 'pop' },
                    { token: 'constant.character.escape.io', regex: '\\\\.' },
                    { defaultToken: 'string.quoted.triple.io' }] },
            { token: 'punctuation.definition.string.begin.io',
                regex: '"',
                push: [{ token: 'punctuation.definition.string.end.io',
                        regex: '"',
                        next: 'pop' },
                    { token: 'constant.character.escape.io', regex: '\\\\.' },
                    { defaultToken: 'string.quoted.double.io' }] },
            { token: 'constant.numeric.io',
                regex: '\\b(?:0(?:x|X)[0-9a-fA-F]*|(?:[0-9]+\\.?[0-9]*|\\.[0-9]+)(?:(?:e|E)(?:\\+|-)?[0-9]+)?)(?:L|l|UL|ul|u|U|F|f)?\\b' },
            { token: 'variable.other.global.io', regex: 'Lobby\\b' },
            { token: 'constant.language.io',
                regex: '\\b(?:TRUE|true|FALSE|false|NULL|null|Null|Nil|nil|YES|NO)\\b' }] };
    this.normalizeRules();
};
IoHighlightRules.metaData = { fileTypes: ['io'],
    keyEquivalent: '^~I',
    name: 'Io',
    scopeName: 'source.io' };
oop.inherits(IoHighlightRules, TextHighlightRules);
exports.IoHighlightRules = IoHighlightRules;

});

define("ace/mode/io",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/io_highlight_rules","ace/mode/folding/cstyle"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY mode.tmpl.js
*/
"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var IoHighlightRules = require("./io_highlight_rules").IoHighlightRules;
var FoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = IoHighlightRules;
    this.foldingRules = new FoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "//";
    this.blockComment = { start: "/*", end: "*/" };
    this.$id = "ace/mode/io";
    this.snippetFileId = "ace/snippets/io";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/jack_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var JackHighlightRules = function () {
    this.$rules = {
        "start": [
            {
                token: "string",
                regex: '"',
                next: "string2"
            }, {
                token: "string",
                regex: "'",
                next: "string1"
            }, {
                token: "constant.numeric",
                regex: "-?0[xX][0-9a-fA-F]+\\b"
            }, {
                token: "constant.numeric",
                regex: "(?:0|[-+]?[1-9][0-9]*)\\b"
            }, {
                token: "constant.binary",
                regex: "<[0-9A-Fa-f][0-9A-Fa-f](\\s+[0-9A-Fa-f][0-9A-Fa-f])*>"
            }, {
                token: "constant.language.boolean",
                regex: "(?:true|false)\\b"
            }, {
                token: "constant.language.null",
                regex: "null\\b"
            }, {
                token: "storage.type",
                regex: "(?:Integer|Boolean|Null|String|Buffer|Tuple|List|Object|Function|Coroutine|Form)\\b"
            }, {
                token: "keyword",
                regex: "(?:return|abort|vars|for|delete|in|is|escape|exec|split|and|if|elif|else|while)\\b"
            }, {
                token: "language.builtin",
                regex: "(?:lines|source|parse|read-stream|interval|substr|parseint|write|print|range|rand|inspect|bind|i-values|i-pairs|i-map|i-filter|i-chunk|i-all\\?|i-any\\?|i-collect|i-zip|i-merge|i-each)\\b"
            }, {
                token: "comment",
                regex: "--.*$"
            }, {
                token: "paren.lparen",
                regex: "[[({]"
            }, {
                token: "paren.rparen",
                regex: "[\\])}]"
            }, {
                token: "storage.form",
                regex: "@[a-z]+"
            }, {
                token: "constant.other.symbol",
                regex: ':+[a-zA-Z_]([-]?[a-zA-Z0-9_])*[?!]?'
            }, {
                token: "variable",
                regex: '[a-zA-Z_]([-]?[a-zA-Z0-9_])*[?!]?'
            }, {
                token: "keyword.operator",
                regex: "\\|\\||\\^\\^|&&|!=|==|<=|<|>=|>|\\+|-|\\*|\\/|\\^|\\%|\\#|\\!"
            }, {
                token: "text",
                regex: "\\s+"
            }
        ],
        "string1": [
            {
                token: "constant.language.escape",
                regex: /\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|['"\\\/bfnrt])/
            }, {
                token: "string",
                regex: "[^'\\\\]+"
            }, {
                token: "string",
                regex: "'",
                next: "start"
            }, {
                token: "string",
                regex: "",
                next: "start"
            }
        ],
        "string2": [
            {
                token: "constant.language.escape",
                regex: /\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|['"\\\/bfnrt])/
            }, {
                token: "string",
                regex: '[^"\\\\]+'
            }, {
                token: "string",
                regex: '"',
                next: "start"
            }, {
                token: "string",
                regex: "",
                next: "start"
            }
        ]
    };
};
oop.inherits(JackHighlightRules, TextHighlightRules);
exports.JackHighlightRules = JackHighlightRules;

});

define("ace/mode/jack",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/jack_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/cstyle"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var HighlightRules = require("./jack_highlight_rules").JackHighlightRules;
var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var CStyleFoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = HighlightRules;
    this.$outdent = new MatchingBraceOutdent();
    this.$behaviour = this.$defaultBehaviour;
    this.foldingRules = new CStyleFoldMode();
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "--";
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        if (state == "start") {
            var match = line.match(/^.*[\{\(\[]\s*$/);
            if (match) {
                indent += tab;
            }
        }
        return indent;
    };
    this.checkOutdent = function (state, line, input) {
        return this.$outdent.checkOutdent(line, input);
    };
    this.autoOutdent = function (state, doc, row) {
        this.$outdent.autoOutdent(doc, row);
    };
    this.$id = "ace/mode/jack";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/markdown_highlight_rules",["require","exports","module","ace/config","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules","ace/mode/html_highlight_rules"], function(require, exports, module){"use strict";
var modes = require("../config").$modes;
var oop = require("../lib/oop");
var lang = require("../lib/lang");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var HtmlHighlightRules = require("./html_highlight_rules").HtmlHighlightRules;
var escaped = function (ch) {
    return "(?:[^" + lang.escapeRegExp(ch) + "\\\\]|\\\\.)*";
};
var MarkdownHighlightRules = function () {
    HtmlHighlightRules.call(this);
    var codeBlockStartRule = {
        token: "support.function",
        regex: /^\s*(```+[^`]*|~~~+[^~]*)$/,
        onMatch: function (value, state, stack, line) {
            var m = value.match(/^(\s*)([`~]+)(.*)/);
            var language = /[\w-]+|$/.exec(m[3])[0];
            if (!modes[language])
                language = "";
            stack.unshift("githubblock", [], [m[1], m[2], language], state);
            return this.token;
        },
        next: "githubblock"
    };
    var codeBlockRules = [{
            token: "support.function",
            regex: ".*",
            onMatch: function (value, state, stack, line) {
                var embedState = stack[1];
                var indent = stack[2][0];
                var endMarker = stack[2][1];
                var language = stack[2][2];
                var m = /^(\s*)(`+|~+)\s*$/.exec(value);
                if (m && m[1].length < indent.length + 3
                    && m[2].length >= endMarker.length && m[2][0] == endMarker[0]) {
                    stack.splice(0, 3);
                    this.next = stack.shift();
                    return this.token;
                }
                this.next = "";
                if (language && modes[language]) {
                    var data = modes[language].getTokenizer().getLineTokens(value, embedState.slice(0));
                    stack[1] = data.state;
                    return data.tokens;
                }
                return this.token;
            }
        }];
    this.$rules["start"].unshift({
        token: "empty_line",
        regex: '^$',
        next: "allowBlock"
    }, {
        token: "markup.heading.1",
        regex: "^=+(?=\\s*$)"
    }, {
        token: "markup.heading.2",
        regex: "^\\-+(?=\\s*$)"
    }, {
        token: function (value) {
            return "markup.heading." + value.length;
        },
        regex: /^#{1,6}(?=\s|$)/,
        next: "header"
    }, codeBlockStartRule, {
        token: "string.blockquote",
        regex: "^\\s*>\\s*(?:[*+-]|\\d+\\.)?\\s+",
        next: "blockquote"
    }, {
        token: "constant",
        regex: "^ {0,3}(?:(?:\\* ?){3,}|(?:\\- ?){3,}|(?:\\_ ?){3,})\\s*$",
        next: "allowBlock"
    }, {
        token: "markup.list",
        regex: "^\\s{0,3}(?:[*+-]|\\d+\\.)\\s+",
        next: "listblock-start"
    }, {
        include: "basic"
    });
    this.addRules({
        "basic": [{
                token: "constant.language.escape",
                regex: /\\[\\`*_{}\[\]()#+\-.!]/
            }, {
                token: "support.function",
                regex: "(`+)(.*?[^`])(\\1)"
            }, {
                token: ["text", "constant", "text", "url", "string", "text"],
                regex: "^([ ]{0,3}\\[)([^\\]]+)(\\]:\\s*)([^ ]+)(\\s*(?:[\"][^\"]+[\"])?(\\s*))$"
            }, {
                token: ["text", "string", "text", "constant", "text"],
                regex: "(\\[)(" + escaped("]") + ")(\\]\\s*\\[)(" + escaped("]") + ")(\\])"
            }, {
                token: ["text", "string", "text", "markup.underline", "string", "text"],
                regex: "(\\!?\\[)(" + // [
                    escaped("]") + // link text or alt text
                    ")(\\]\\()" + // ](
                    '((?:[^\\)\\s\\\\]|\\\\.|\\s(?=[^"]))*)' + // href or image
                    '(\\s*"' + escaped('"') + '"\\s*)?' + // "title"
                    "(\\))" // )
            }, {
                token: "string.strong",
                regex: "([*]{2}|[_]{2}(?=\\S))(.*?\\S[*_]*)(\\1)"
            }, {
                token: "string.emphasis",
                regex: "([*]|[_](?=\\S))(.*?\\S[*_]*)(\\1)"
            }, {
                token: ["text", "url", "text"],
                regex: "(<)(" +
                    "(?:https?|ftp|dict):[^'\">\\s]+" +
                    "|" +
                    "(?:mailto:)?[-.\\w]+\\@[-a-z0-9]+(?:\\.[-a-z0-9]+)*\\.[a-z]+" +
                    ")(>)"
            }],
        "allowBlock": [
            { token: "support.function", regex: "^ {4}.+", next: "allowBlock" },
            { token: "empty_line", regex: '^$', next: "allowBlock" },
            { token: "empty", regex: "", next: "start" }
        ],
        "header": [{
                regex: "$",
                next: "start"
            }, {
                include: "basic"
            }, {
                defaultToken: "heading"
            }],
        "listblock-start": [{
                token: "support.variable",
                regex: /(?:\[[ x]\])?/,
                next: "listblock"
            }],
        "listblock": [{
                token: "empty_line",
                regex: "^$",
                next: "start"
            }, {
                token: "markup.list",
                regex: "^\\s{0,3}(?:[*+-]|\\d+\\.)\\s+",
                next: "listblock-start"
            }, {
                include: "basic", noEscape: true
            },
            codeBlockStartRule,
            {
                defaultToken: "list" //do not use markup.list to allow stling leading `*` differntly
            }],
        "blockquote": [{
                token: "empty_line",
                regex: "^\\s*$",
                next: "start"
            }, {
                token: "string.blockquote",
                regex: "^\\s*>\\s*(?:[*+-]|\\d+\\.)?\\s+",
                next: "blockquote"
            }, {
                include: "basic", noEscape: true
            }, {
                defaultToken: "string.blockquote"
            }],
        "githubblock": codeBlockRules
    });
    this.normalizeRules();
};
oop.inherits(MarkdownHighlightRules, TextHighlightRules);
exports.MarkdownHighlightRules = MarkdownHighlightRules;

});

define("ace/mode/scss_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules","ace/mode/css_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var lang = require("../lib/lang");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var CssHighlightRules = require("./css_highlight_rules");
var rgb256Regex = CssHighlightRules.rgb256Regex;
var rgb256Token = CssHighlightRules.rgb256Token;
var colorToken = CssHighlightRules.colorToken;
var ScssHighlightRules = function () {
    var properties = lang.arrayToMap(CssHighlightRules.supportType.split("|"));
    var functions = lang.arrayToMap(("hsl|hsla|rgb|rgba|url|attr|counter|counters|abs|adjust_color|adjust_hue|" +
        "alpha|join|blue|ceil|change_color|comparable|complement|darken|desaturate|" +
        "floor|grayscale|green|hue|if|invert|join|length|lighten|lightness|mix|" +
        "nth|opacify|opacity|percentage|quote|red|round|saturate|saturation|" +
        "scale_color|transparentize|type_of|unit|unitless|unquote").split("|"));
    var constants = lang.arrayToMap(CssHighlightRules.supportConstant.split("|"));
    var colors = lang.arrayToMap(CssHighlightRules.supportConstantColor.split("|"));
    var keywords = lang.arrayToMap(("@mixin|@extend|@include|@import|@media|@debug|@warn|@if|@for|@each|@while|@else|@font-face|@-webkit-keyframes|if|and|!default|module|def|end|declare").split("|"));
    var tags = lang.arrayToMap(("a|abbr|acronym|address|applet|area|article|aside|audio|b|base|basefont|bdo|" +
        "big|blockquote|body|br|button|canvas|caption|center|cite|code|col|colgroup|" +
        "command|datalist|dd|del|details|dfn|dir|div|dl|dt|em|embed|fieldset|" +
        "figcaption|figure|font|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|" +
        "header|hgroup|hr|html|i|iframe|img|input|ins|keygen|kbd|label|legend|li|" +
        "link|map|mark|menu|meta|meter|nav|noframes|noscript|object|ol|optgroup|" +
        "option|output|p|param|pre|progress|q|rp|rt|ruby|s|samp|script|section|select|" +
        "small|source|span|strike|strong|style|sub|summary|sup|table|tbody|td|" +
        "textarea|tfoot|th|thead|time|title|tr|tt|u|ul|var|video|wbr|xmp").split("|"));
    var numRe = "\\-?(?:(?:[0-9]+)|(?:[0-9]*\\.[0-9]+))";
    this.$rules = {
        "start": [
            {
                token: "comment",
                regex: "\\/\\/.*$"
            },
            {
                token: "comment",
                regex: "\\/\\*",
                next: "comment"
            }, {
                token: "string",
                regex: '["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'
            }, {
                token: "string",
                regex: '["].*\\\\$',
                next: "qqstring"
            }, {
                token: "string",
                regex: "['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"
            }, {
                token: "string",
                regex: "['].*\\\\$",
                next: "qstring"
            }, {
                token: "constant.numeric",
                regex: numRe + "(?:ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"
            }, {
                regex: rgb256Regex,
                onMatch: rgb256Token
            }, {
                regex: "#[a-fA-F0-9]{8}",
                onMatch: colorToken
            }, {
                regex: "#[a-fA-F0-9]{6}",
                onMatch: colorToken
            }, {
                regex: "#[A-Fa-f0-9]{3}",
                onMatch: colorToken
            }, {
                token: "constant.numeric",
                regex: numRe
            }, {
                token: ["support.function", "string", "support.function"],
                regex: "(url\\()(.*)(\\))"
            }, {
                token: function (value) {
                    if (properties.hasOwnProperty(value.toLowerCase()))
                        return "support.type";
                    if (keywords.hasOwnProperty(value))
                        return "keyword";
                    else if (constants.hasOwnProperty(value))
                        return "constant.language";
                    else if (functions.hasOwnProperty(value))
                        return "support.function";
                    else if (colors.hasOwnProperty(value.toLowerCase()))
                        return colorToken(value);
                    else if (tags.hasOwnProperty(value.toLowerCase()))
                        return "variable.language";
                    else
                        return "text";
                },
                regex: "\\-?[@a-z_][@a-z0-9_\\-]*"
            }, {
                token: "variable",
                regex: "[a-z_\\-$][a-z0-9_\\-$]*\\b"
            }, {
                token: "variable.language",
                regex: "#[a-z0-9-_]+"
            }, {
                token: "variable.language",
                regex: "\\.[a-z0-9-_]+"
            }, {
                token: "variable.language",
                regex: ":[a-z0-9-_]+"
            }, {
                token: "constant",
                regex: "[a-z0-9-_]+"
            }, {
                token: "keyword.operator",
                regex: "<|>|<=|>=|==|!=|-|%|#|\\+|\\$|\\+|\\*"
            }, {
                token: "paren.lparen",
                regex: "[[({]"
            }, {
                token: "paren.rparen",
                regex: "[\\])}]"
            }, {
                token: "text",
                regex: "\\s+"
            }, {
                caseInsensitive: true
            }
        ],
        "comment": [
            {
                token: "comment",
                regex: "\\*\\/",
                next: "start"
            }, {
                defaultToken: "comment"
            }
        ],
        "qqstring": [
            {
                token: "string",
                regex: '(?:(?:\\\\.)|(?:[^"\\\\]))*?"',
                next: "start"
            }, {
                token: "string",
                regex: '.+'
            }
        ],
        "qstring": [
            {
                token: "string",
                regex: "(?:(?:\\\\.)|(?:[^'\\\\]))*?'",
                next: "start"
            }, {
                token: "string",
                regex: '.+'
            }
        ]
    };
};
oop.inherits(ScssHighlightRules, TextHighlightRules);
exports.ScssHighlightRules = ScssHighlightRules;

});

define("ace/mode/less_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules","ace/mode/css_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var CssHighlightRules = require('./css_highlight_rules');
var rgb256Regex = CssHighlightRules.rgb256Regex;
var rgb256Token = CssHighlightRules.rgb256Token;
var colorToken = CssHighlightRules.colorToken;
var LessHighlightRules = function () {
    var keywordList = "@import|@media|@font-face|@keyframes|@-webkit-keyframes|@supports|" +
        "@charset|@plugin|@namespace|@document|@page|@viewport|@-ms-viewport|" +
        "or|and|when|not";
    var keywords = keywordList.split('|');
    var properties = CssHighlightRules.supportType.split('|');
    var keywordMapper = this.createKeywordMapper({
        "support.constant": CssHighlightRules.supportConstant,
        "keyword": keywordList,
        "support.constant.color": CssHighlightRules.supportConstantColor,
        "support.constant.fonts": CssHighlightRules.supportConstantFonts
    }, "identifier", true);
    var numRe = "\\-?(?:(?:[0-9]+)|(?:[0-9]*\\.[0-9]+))";
    this.$rules = {
        "start": [
            {
                token: "comment",
                regex: "\\/\\/.*$"
            },
            {
                token: "comment",
                regex: "\\/\\*",
                next: "comment"
            }, {
                token: "string",
                regex: '["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'
            }, {
                token: "string",
                regex: "['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"
            }, {
                token: ["constant.numeric", "keyword"],
                regex: "(" + numRe + ")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vm|vw|%)"
            }, {
                regex: rgb256Regex,
                onMatch: rgb256Token
            }, {
                regex: "#[a-fA-F0-9]{8}",
                onMatch: colorToken
            }, {
                regex: "#[a-fA-F0-9]{6}",
                onMatch: colorToken
            }, {
                regex: "#[A-Fa-f0-9]{3}",
                onMatch: colorToken
            }, {
                token: "constant.numeric",
                regex: numRe
            }, {
                token: ["support.function", "paren.lparen", "string", "paren.rparen"],
                regex: "(url)(\\()(.*)(\\))"
            }, {
                token: ["support.function", "paren.lparen"],
                regex: "(:extend|[a-z0-9_\\-]+)(\\()"
            }, {
                token: function (value) {
                    if (keywords.indexOf(value.toLowerCase()) > -1)
                        return "keyword";
                    else
                        return "variable";
                },
                regex: "[@\\$][a-z0-9_\\-@\\$]*\\b"
            }, {
                token: "variable",
                regex: "[@\\$]\\{[a-z0-9_\\-@\\$]*\\}"
            }, {
                token: function (first, second) {
                    if (properties.indexOf(first.toLowerCase()) > -1) {
                        return ["support.type.property", "text"];
                    }
                    else {
                        return ["support.type.unknownProperty", "text"];
                    }
                },
                regex: "([a-z0-9-_]+)(\\s*:)"
            }, {
                token: "keyword",
                regex: "&" // special case - always treat as keyword
            }, {
                regex: "\\-?[@a-z_][@a-z0-9_\\-]*",
                onMatch: function (value, state, stack, line) {
                    var result = keywordMapper(value);
                    if (result == "support.constant.color") {
                        result = colorToken(value, state, stack, line);
                    }
                    return result;
                }
            }, {
                token: "variable.language",
                regex: "#[a-z0-9-_]+"
            }, {
                token: "variable.language",
                regex: "\\.[a-z0-9-_]+"
            }, {
                token: "variable.language",
                regex: ":[a-z_][a-z0-9-_]*"
            }, {
                token: "constant",
                regex: "[a-z0-9-_]+"
            }, {
                token: "keyword.operator",
                regex: "<|>|<=|>=|=|!=|-|%|\\+|\\*"
            }, {
                token: "paren.lparen",
                regex: "[[({]"
            }, {
                token: "paren.rparen",
                regex: "[\\])}]"
            }, {
                token: "text",
                regex: "\\s+"
            }, {
                caseInsensitive: true
            }
        ],
        "comment": [
            {
                token: "comment",
                regex: "\\*\\/",
                next: "start"
            }, {
                defaultToken: "comment"
            }
        ]
    };
    this.normalizeRules();
};
oop.inherits(LessHighlightRules, TextHighlightRules);
exports.LessHighlightRules = LessHighlightRules;

});

define("ace/mode/jade_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules","ace/mode/markdown_highlight_rules","ace/mode/scss_highlight_rules","ace/mode/less_highlight_rules","ace/mode/coffee_highlight_rules","ace/mode/javascript_highlight_rules"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY mode_highlight_rules.tmpl.js (UUID: C5B73B98-5F2A-42E3-9F0E-028A74A9FE4B)
*/
"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var MarkdownHighlightRules = require("./markdown_highlight_rules").MarkdownHighlightRules;
var SassHighlightRules = require("./scss_highlight_rules").ScssHighlightRules;
var LessHighlightRules = require("./less_highlight_rules").LessHighlightRules;
var CoffeeHighlightRules = require("./coffee_highlight_rules").CoffeeHighlightRules;
var JavaScriptHighlightRules = require("./javascript_highlight_rules").JavaScriptHighlightRules;
function mixin_embed(tag, prefix) {
    return {
        token: "entity.name.function.jade",
        regex: "^\\s*\\:" + tag,
        next: prefix + "start"
    };
}
var JadeHighlightRules = function () {
    var escapedRe = "\\\\(?:x[0-9a-fA-F]{2}|" + // hex
        "u[0-9a-fA-F]{4}|" + // unicode
        "[0-2][0-7]{0,2}|" + // oct
        "3[0-6][0-7]?|" + // oct
        "37[0-7]?|" + // oct
        "[4-7][0-7]?|" + //oct
        ".)";
    this.$rules =
        {
            "start": [
                {
                    token: "keyword.control.import.include.jade",
                    regex: "\\s*\\binclude\\b"
                },
                {
                    token: "keyword.other.doctype.jade",
                    regex: "^!!!\\s*(?:[a-zA-Z0-9-_]+)?"
                },
                {
                    onMatch: function (value, currentState, stack) {
                        stack.unshift(this.next, value.length - 2, currentState);
                        return "comment";
                    },
                    regex: /^\s*\/\//,
                    next: "comment_block"
                },
                mixin_embed("markdown", "markdown-"),
                mixin_embed("sass", "sass-"),
                mixin_embed("less", "less-"),
                mixin_embed("coffee", "coffee-"),
                {
                    token: ["storage.type.function.jade",
                        "entity.name.function.jade",
                        "punctuation.definition.parameters.begin.jade",
                        "variable.parameter.function.jade",
                        "punctuation.definition.parameters.end.jade"
                    ],
                    regex: "^(\\s*mixin)( [\\w\\-]+)(\\s*\\()(.*?)(\\))"
                },
                {
                    token: ["storage.type.function.jade", "entity.name.function.jade"],
                    regex: "^(\\s*mixin)( [\\w\\-]+)"
                },
                {
                    token: "source.js.embedded.jade",
                    regex: "^\\s*(?:-|=|!=)",
                    next: "js-start"
                },
                {
                    token: "string.interpolated.jade",
                    regex: "[#!]\\{[^\\}]+\\}"
                },
                {
                    token: "meta.tag.any.jade",
                    regex: /^\s*(?!\w+:)(?:[\w-]+|(?=\.|#)])/,
                    next: "tag_single"
                },
                {
                    token: "suport.type.attribute.id.jade",
                    regex: "#\\w+"
                },
                {
                    token: "suport.type.attribute.class.jade",
                    regex: "\\.\\w+"
                },
                {
                    token: "punctuation",
                    regex: "\\s*(?:\\()",
                    next: "tag_attributes"
                }
            ],
            "comment_block": [
                { regex: /^\s*(?:\/\/)?/, onMatch: function (value, currentState, stack) {
                        if (value.length <= stack[1]) {
                            if (value.slice(-1) == "/") {
                                stack[1] = value.length - 2;
                                this.next = "";
                                return "comment";
                            }
                            stack.shift();
                            stack.shift();
                            this.next = stack.shift();
                            return "text";
                        }
                        else {
                            this.next = "";
                            return "comment";
                        }
                    }, next: "start" },
                { defaultToken: "comment" }
            ],
            "tag_single": [
                {
                    token: "entity.other.attribute-name.class.jade",
                    regex: "\\.[\\w-]+"
                },
                {
                    token: "entity.other.attribute-name.id.jade",
                    regex: "#[\\w-]+"
                },
                {
                    token: ["text", "punctuation"],
                    regex: "($)|((?!\\.|#|=|-))",
                    next: "start"
                }
            ],
            "tag_attributes": [
                {
                    token: "string",
                    regex: "'(?=.)",
                    next: "qstring"
                },
                {
                    token: "string",
                    regex: '"(?=.)',
                    next: "qqstring"
                },
                {
                    token: ["entity.other.attribute-name.jade", "punctuation"],
                    regex: "([a-zA-Z:\\.-]+)(=)?",
                    next: "attribute_strings"
                },
                {
                    token: "punctuation",
                    regex: "\\)",
                    next: "start"
                }
            ],
            "attribute_strings": [
                {
                    token: "string",
                    regex: "'(?=.)",
                    next: "qstring"
                },
                {
                    token: "string",
                    regex: '"(?=.)',
                    next: "qqstring"
                },
                {
                    token: "string",
                    regex: '(?=\\S)',
                    next: "tag_attributes"
                }
            ],
            "qqstring": [
                {
                    token: "constant.language.escape",
                    regex: escapedRe
                }, {
                    token: "string",
                    regex: '[^"\\\\]+'
                }, {
                    token: "string",
                    regex: "\\\\$",
                    next: "qqstring"
                }, {
                    token: "string",
                    regex: '"|$',
                    next: "tag_attributes"
                }
            ],
            "qstring": [
                {
                    token: "constant.language.escape",
                    regex: escapedRe
                }, {
                    token: "string",
                    regex: "[^'\\\\]+"
                }, {
                    token: "string",
                    regex: "\\\\$",
                    next: "qstring"
                }, {
                    token: "string",
                    regex: "'|$",
                    next: "tag_attributes"
                }
            ]
        };
    this.embedRules(JavaScriptHighlightRules, "js-", [{
            token: "text",
            regex: ".$",
            next: "start"
        }]);
};
oop.inherits(JadeHighlightRules, TextHighlightRules);
exports.JadeHighlightRules = JadeHighlightRules;

});

define("ace/mode/jade",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/jade_highlight_rules","ace/mode/folding/coffee"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var JadeHighlightRules = require("./jade_highlight_rules").JadeHighlightRules;
var FoldMode = require("./folding/coffee").FoldMode;
var Mode = function () {
    this.HighlightRules = JadeHighlightRules;
    this.foldingRules = new FoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "//";
    this.$id = "ace/mode/jade";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/java_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/doc_comment_highlight_rules","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var DocCommentHighlightRules = require("./doc_comment_highlight_rules").DocCommentHighlightRules;
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var JavaHighlightRules = function () {
    var keywords = ("abstract|continue|for|new|switch|" +
        "assert|default|goto|package|synchronized|" +
        "boolean|do|if|private|this|" +
        "break|double|implements|protected|throw|" +
        "byte|else|import|public|throws|" +
        "case|enum|instanceof|return|transient|" +
        "catch|extends|int|short|try|" +
        "char|final|interface|static|void|" +
        "class|finally|long|strictfp|volatile|" +
        "const|float|native|super|while|" +
        "var");
    var buildinConstants = ("null|Infinity|NaN|undefined");
    var langClasses = ("AbstractMethodError|AssertionError|ClassCircularityError|" +
        "ClassFormatError|Deprecated|EnumConstantNotPresentException|" +
        "ExceptionInInitializerError|IllegalAccessError|" +
        "IllegalThreadStateException|InstantiationError|InternalError|" +
        "NegativeArraySizeException|NoSuchFieldError|Override|Process|" +
        "ProcessBuilder|SecurityManager|StringIndexOutOfBoundsException|" +
        "SuppressWarnings|TypeNotPresentException|UnknownError|" +
        "UnsatisfiedLinkError|UnsupportedClassVersionError|VerifyError|" +
        "InstantiationException|IndexOutOfBoundsException|" +
        "ArrayIndexOutOfBoundsException|CloneNotSupportedException|" +
        "NoSuchFieldException|IllegalArgumentException|NumberFormatException|" +
        "SecurityException|Void|InheritableThreadLocal|IllegalStateException|" +
        "InterruptedException|NoSuchMethodException|IllegalAccessException|" +
        "UnsupportedOperationException|Enum|StrictMath|Package|Compiler|" +
        "Readable|Runtime|StringBuilder|Math|IncompatibleClassChangeError|" +
        "NoSuchMethodError|ThreadLocal|RuntimePermission|ArithmeticException|" +
        "NullPointerException|Long|Integer|Short|Byte|Double|Number|Float|" +
        "Character|Boolean|StackTraceElement|Appendable|StringBuffer|" +
        "Iterable|ThreadGroup|Runnable|Thread|IllegalMonitorStateException|" +
        "StackOverflowError|OutOfMemoryError|VirtualMachineError|" +
        "ArrayStoreException|ClassCastException|LinkageError|" +
        "NoClassDefFoundError|ClassNotFoundException|RuntimeException|" +
        "Exception|ThreadDeath|Error|Throwable|System|ClassLoader|" +
        "Cloneable|Class|CharSequence|Comparable|String|Object");
    var keywordMapper = this.createKeywordMapper({
        "variable.language": "this",
        "keyword": keywords,
        "constant.language": buildinConstants,
        "support.function": langClasses
    }, "identifier");
    this.$rules = {
        "start": [
            {
                token: "comment",
                regex: "\\/\\/.*$"
            },
            DocCommentHighlightRules.getStartRule("doc-start"),
            {
                token: "comment",
                regex: "\\/\\*",
                next: "comment"
            }, {
                token: "string",
                regex: '["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'
            }, {
                token: "string",
                regex: "['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"
            }, {
                token: "constant.numeric",
                regex: /0(?:[xX][0-9a-fA-F][0-9a-fA-F_]*|[bB][01][01_]*)[LlSsDdFfYy]?\b/
            }, {
                token: "constant.numeric",
                regex: /[+-]?\d[\d_]*(?:(?:\.[\d_]*)?(?:[eE][+-]?[\d_]+)?)?[LlSsDdFfYy]?\b/
            }, {
                token: "constant.language.boolean",
                regex: "(?:true|false)\\b"
            }, {
                regex: "(open(?:\\s+))?module(?=\\s*\\w)",
                token: "keyword",
                next: [{
                        regex: "{",
                        token: "paren.lparen",
                        next: [{
                                regex: "}",
                                token: "paren.rparen",
                                next: "start"
                            }, {
                                regex: "\\b(requires|transitive|exports|opens|to|uses|provides|with)\\b",
                                token: "keyword"
                            }]
                    }, {
                        token: "text",
                        regex: "\\s+"
                    }, {
                        token: "identifier",
                        regex: "\\w+"
                    }, {
                        token: "punctuation.operator",
                        regex: "."
                    }, {
                        token: "text",
                        regex: "\\s+"
                    }, {
                        regex: "",
                        next: "start"
                    }]
            }, {
                token: keywordMapper,
                regex: "[a-zA-Z_$][a-zA-Z0-9_$]*\\b"
            }, {
                token: "keyword.operator",
                regex: "!|\\$|%|&|\\||\\^|\\*|\\/|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|&&|\\|\\||\\?|\\:|\\*=|\\/=|%=|\\+=|\\-=|&=|\\|=|\\^=|\\b(?:in|instanceof|new|delete|typeof|void)"
            }, {
                token: "lparen",
                regex: "[[({]"
            }, {
                token: "rparen",
                regex: "[\\])}]"
            }, {
                token: "text",
                regex: "\\s+"
            }
        ],
        "comment": [
            {
                token: "comment",
                regex: "\\*\\/",
                next: "start"
            }, {
                defaultToken: "comment"
            }
        ]
    };
    this.embedRules(DocCommentHighlightRules, "doc-", [DocCommentHighlightRules.getEndRule("start")]);
    this.normalizeRules();
};
oop.inherits(JavaHighlightRules, TextHighlightRules);
exports.JavaHighlightRules = JavaHighlightRules;

});

define("ace/mode/folding/java",["require","exports","module","ace/lib/oop","ace/mode/folding/cstyle","ace/range"], function(require, exports, module){"use strict";
var oop = require("../../lib/oop");
var CStyleFoldMode = require("./cstyle").FoldMode;
var Range = require("../../range").Range;
var FoldMode = exports.FoldMode = function () { };
oop.inherits(FoldMode, CStyleFoldMode);
(function () {
    this.importRegex = /^import /;
    this.getCStyleFoldWidget = this.getFoldWidget;
    this.getFoldWidget = function (session, foldStyle, row) {
        if (foldStyle === "markbegin") {
            var line = session.getLine(row);
            if (this.importRegex.test(line)) {
                if (row == 0 || !this.importRegex.test(session.getLine(row - 1)))
                    return "start";
            }
        }
        return this.getCStyleFoldWidget(session, foldStyle, row);
    };
    this.getCstyleFoldWidgetRange = this.getFoldWidgetRange;
    this.getFoldWidgetRange = function (session, foldStyle, row, forceMultiline) {
        var line = session.getLine(row);
        var match = line.match(this.importRegex);
        if (!match || foldStyle !== "markbegin")
            return this.getCstyleFoldWidgetRange(session, foldStyle, row, forceMultiline);
        var startColumn = match[0].length;
        var maxRow = session.getLength();
        var startRow = row;
        var endRow = row;
        while (++row < maxRow) {
            var line = session.getLine(row);
            if (line.match(/^\s*$/))
                continue;
            if (!line.match(this.importRegex))
                break;
            endRow = row;
        }
        if (endRow > startRow) {
            var endColumn = session.getLine(endRow).length;
            return new Range(startRow, startColumn, endRow, endColumn);
        }
    };
}).call(FoldMode.prototype);

});

define("ace/mode/java",["require","exports","module","ace/lib/oop","ace/mode/javascript","ace/mode/java_highlight_rules","ace/mode/folding/java"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var JavaScriptMode = require("./javascript").Mode;
var JavaHighlightRules = require("./java_highlight_rules").JavaHighlightRules;
var JavaFoldMode = require("./folding/java").FoldMode;
var Mode = function () {
    JavaScriptMode.call(this);
    this.HighlightRules = JavaHighlightRules;
    this.foldingRules = new JavaFoldMode();
};
oop.inherits(Mode, JavaScriptMode);
(function () {
    this.createWorker = function (session) {
        return null;
    };
    this.$id = "ace/mode/java";
    this.snippetFileId = "ace/snippets/java";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/julia_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){/* This file was autogenerated from https://raw.github.com/JuliaLang/julia/master/contrib/Julia.tmbundle/Syntaxes/Julia.tmLanguage (uuid: ) */
"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var JuliaHighlightRules = function () {
    this.$rules = { start: [{ include: '#function_decl' },
            { include: '#function_call' },
            { include: '#type_decl' },
            { include: '#keyword' },
            { include: '#operator' },
            { include: '#number' },
            { include: '#string' },
            { include: '#comment' }],
        '#bracket': [{ token: 'keyword.bracket.julia',
                regex: '\\(|\\)|\\[|\\]|\\{|\\}|,' }],
        '#comment': [{ token: ['punctuation.definition.comment.julia',
                    'comment.line.number-sign.julia'],
                regex: '(#)(?!\\{)(.*$)' }],
        '#function_call': [{ token: ['support.function.julia', 'text'],
                regex: '([a-zA-Z0-9_]+!?)([\\w\\xff-\\u218e\\u2455-\\uffff]*\\()' }],
        '#function_decl': [{ token: ['keyword.other.julia', 'meta.function.julia',
                    'entity.name.function.julia', 'meta.function.julia', 'text'],
                regex: '(function|macro)(\\s*)([a-zA-Z0-9_\\{]+!?)([\\w\\xff-\\u218e\\u2455-\\uffff]*)([(\\\\{])' }],
        '#keyword': [{ token: 'keyword.other.julia',
                regex: '\\b(?:function|type|immutable|macro|quote|abstract|bitstype|typealias|module|baremodule|new)\\b' },
            { token: 'keyword.control.julia',
                regex: '\\b(?:if|else|elseif|while|for|in|begin|let|end|do|try|catch|finally|return|break|continue)\\b' },
            { token: 'storage.modifier.variable.julia',
                regex: '\\b(?:global|local|const|export|import|importall|using)\\b' },
            { token: 'variable.macro.julia', regex: '@[\\w\\xff-\\u218e\\u2455-\\uffff]+\\b' }],
        '#number': [{ token: 'constant.numeric.julia',
                regex: '\\b0(?:x|X)[0-9a-fA-F]*|(?:\\b[0-9]+\\.?[0-9]*|\\.[0-9]+)(?:(?:e|E)(?:\\+|-)?[0-9]*)?(?:im)?|\\bInf(?:32)?\\b|\\bNaN(?:32)?\\b|\\btrue\\b|\\bfalse\\b' }],
        '#operator': [{ token: 'keyword.operator.update.julia',
                regex: '=|:=|\\+=|-=|\\*=|/=|//=|\\.//=|\\.\\*=|\\\\=|\\.\\\\=|^=|\\.^=|%=|\\|=|&=|\\$=|<<=|>>=' },
            { token: 'keyword.operator.ternary.julia', regex: '\\?|:' },
            { token: 'keyword.operator.boolean.julia',
                regex: '\\|\\||&&|!' },
            { token: 'keyword.operator.arrow.julia', regex: '->|<-|-->' },
            { token: 'keyword.operator.relation.julia',
                regex: '>|<|>=|<=|==|!=|\\.>|\\.<|\\.>=|\\.>=|\\.==|\\.!=|\\.=|\\.!|<:|:>' },
            { token: 'keyword.operator.range.julia', regex: ':' },
            { token: 'keyword.operator.shift.julia', regex: '<<|>>' },
            { token: 'keyword.operator.bitwise.julia', regex: '\\||\\&|~' },
            { token: 'keyword.operator.arithmetic.julia',
                regex: '\\+|-|\\*|\\.\\*|/|\\./|//|\\.//|%|\\.%|\\\\|\\.\\\\|\\^|\\.\\^' },
            { token: 'keyword.operator.isa.julia', regex: '::' },
            { token: 'keyword.operator.dots.julia',
                regex: '\\.(?=[a-zA-Z])|\\.\\.+' },
            { token: 'keyword.operator.interpolation.julia',
                regex: '\\$#?(?=.)' },
            { token: ['variable', 'keyword.operator.transposed-variable.julia'],
                regex: '([\\w\\xff-\\u218e\\u2455-\\uffff]+)((?:\'|\\.\')*\\.?\')' },
            { token: 'text',
                regex: '\\[|\\(' },
            { token: ['text', 'keyword.operator.transposed-matrix.julia'],
                regex: "([\\]\\)])((?:'|\\.')*\\.?')" }],
        '#string': [{ token: 'punctuation.definition.string.begin.julia',
                regex: '\'',
                push: [{ token: 'punctuation.definition.string.end.julia',
                        regex: '\'',
                        next: 'pop' },
                    { include: '#string_escaped_char' },
                    { defaultToken: 'string.quoted.single.julia' }] },
            { token: 'punctuation.definition.string.begin.julia',
                regex: '"',
                push: [{ token: 'punctuation.definition.string.end.julia',
                        regex: '"',
                        next: 'pop' },
                    { include: '#string_escaped_char' },
                    { defaultToken: 'string.quoted.double.julia' }] },
            { token: 'punctuation.definition.string.begin.julia',
                regex: '\\b[\\w\\xff-\\u218e\\u2455-\\uffff]+"',
                push: [{ token: 'punctuation.definition.string.end.julia',
                        regex: '"[\\w\\xff-\\u218e\\u2455-\\uffff]*',
                        next: 'pop' },
                    { include: '#string_custom_escaped_char' },
                    { defaultToken: 'string.quoted.custom-double.julia' }] },
            { token: 'punctuation.definition.string.begin.julia',
                regex: '`',
                push: [{ token: 'punctuation.definition.string.end.julia',
                        regex: '`',
                        next: 'pop' },
                    { include: '#string_escaped_char' },
                    { defaultToken: 'string.quoted.backtick.julia' }] }],
        '#string_custom_escaped_char': [{ token: 'constant.character.escape.julia', regex: '\\\\"' }],
        '#string_escaped_char': [{ token: 'constant.character.escape.julia',
                regex: '\\\\(?:\\\\|[0-3]\\d{,2}|[4-7]\\d?|x[a-fA-F0-9]{,2}|u[a-fA-F0-9]{,4}|U[a-fA-F0-9]{,8}|.)' }],
        '#type_decl': [{ token: ['keyword.control.type.julia',
                    'meta.type.julia',
                    'entity.name.type.julia',
                    'entity.other.inherited-class.julia',
                    'punctuation.separator.inheritance.julia',
                    'entity.other.inherited-class.julia'],
                regex: '(type|immutable)(\\s+)([a-zA-Z0-9_]+)(?:(\\s*)(<:)(\\s*[.a-zA-Z0-9_:]+))?' },
            { token: ['other.typed-variable.julia', 'support.type.julia'],
                regex: '([a-zA-Z0-9_]+)(::[a-zA-Z0-9_{}]+)' }] };
    this.normalizeRules();
};
JuliaHighlightRules.metaData = { fileTypes: ['jl'],
    firstLineMatch: '^#!.*\\bjulia\\s*$',
    foldingStartMarker: '^\\s*(?:if|while|for|begin|function|macro|module|baremodule|type|immutable|let)\\b(?!.*\\bend\\b).*$',
    foldingStopMarker: '^\\s*(?:end)\\b.*$',
    name: 'Julia',
    scopeName: 'source.julia' };
oop.inherits(JuliaHighlightRules, TextHighlightRules);
exports.JuliaHighlightRules = JuliaHighlightRules;

});

define("ace/mode/julia",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/julia_highlight_rules","ace/mode/folding/cstyle"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY mode.tmpl.js
*/
"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var JuliaHighlightRules = require("./julia_highlight_rules").JuliaHighlightRules;
var FoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = JuliaHighlightRules;
    this.foldingRules = new FoldMode();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "#";
    this.blockComment = "";
    this.$id = "ace/mode/julia";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/latex_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var LatexHighlightRules = function () {
    this.$rules = {
        "start": [{
                token: "comment",
                regex: "%.*$"
            }, {
                token: ["keyword", "lparen", "variable.parameter", "rparen", "lparen", "storage.type", "rparen"],
                regex: "(\\\\(?:documentclass|usepackage|input))(?:(\\[)([^\\]]*)(\\]))?({)([^}]*)(})"
            }, {
                token: ["keyword", "lparen", "variable.parameter", "rparen"],
                regex: "(\\\\(?:label|v?ref|cite(?:[^{]*)))(?:({)([^}]*)(}))?"
            }, {
                token: ["storage.type", "lparen", "variable.parameter", "rparen"],
                regex: "(\\\\begin)({)(verbatim)(})",
                next: "verbatim"
            }, {
                token: ["storage.type", "lparen", "variable.parameter", "rparen"],
                regex: "(\\\\begin)({)(lstlisting)(})",
                next: "lstlisting"
            }, {
                token: ["storage.type", "lparen", "variable.parameter", "rparen"],
                regex: "(\\\\(?:begin|end))({)([\\w*]*)(})"
            }, {
                token: "storage.type",
                regex: /\\verb\b\*?/,
                next: [{
                        token: ["keyword.operator", "string", "keyword.operator"],
                        regex: "(.)(.*?)(\\1|$)|",
                        next: "start"
                    }]
            }, {
                token: "storage.type",
                regex: "\\\\[a-zA-Z]+"
            }, {
                token: "lparen",
                regex: "[[({]"
            }, {
                token: "rparen",
                regex: "[\\])}]"
            }, {
                token: "constant.character.escape",
                regex: "\\\\[^a-zA-Z]?"
            }, {
                token: "string",
                regex: "\\${1,2}",
                next: "equation"
            }],
        "equation": [{
                token: "comment",
                regex: "%.*$"
            }, {
                token: "string",
                regex: "\\${1,2}",
                next: "start"
            }, {
                token: "constant.character.escape",
                regex: "\\\\(?:[^a-zA-Z]|[a-zA-Z]+)"
            }, {
                token: "error",
                regex: "^\\s*$",
                next: "start"
            }, {
                defaultToken: "string"
            }],
        "verbatim": [{
                token: ["storage.type", "lparen", "variable.parameter", "rparen"],
                regex: "(\\\\end)({)(verbatim)(})",
                next: "start"
            }, {
                defaultToken: "text"
            }],
        "lstlisting": [{
                token: ["storage.type", "lparen", "variable.parameter", "rparen"],
                regex: "(\\\\end)({)(lstlisting)(})",
                next: "start"
            }, {
                defaultToken: "text"
            }]
    };
    this.normalizeRules();
};
oop.inherits(LatexHighlightRules, TextHighlightRules);
exports.LatexHighlightRules = LatexHighlightRules;

});

define("ace/mode/folding/latex",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range","ace/token_iterator"], function(require, exports, module){"use strict";
var oop = require("../../lib/oop");
var BaseFoldMode = require("./fold_mode").FoldMode;
var Range = require("../../range").Range;
var TokenIterator = require("../../token_iterator").TokenIterator;
var keywordLevels = {
    "\\subparagraph": 1,
    "\\paragraph": 2,
    "\\subsubsubsection": 3,
    "\\subsubsection": 4,
    "\\subsection": 5,
    "\\section": 6,
    "\\chapter": 7,
    "\\part": 8,
    "\\begin": 9,
    "\\end": 10
};
var FoldMode = exports.FoldMode = function () { };
oop.inherits(FoldMode, BaseFoldMode);
(function () {
    this.foldingStartMarker = /^\s*\\(begin)|\s*\\(part|chapter|(?:sub)*(?:section|paragraph))\b|{\s*$/;
    this.foldingStopMarker = /^\s*\\(end)\b|^\s*}/;
    this.getFoldWidgetRange = function (session, foldStyle, row) {
        var line = session.doc.getLine(row);
        var match = this.foldingStartMarker.exec(line);
        if (match) {
            if (match[1])
                return this.latexBlock(session, row, match[0].length - 1);
            if (match[2])
                return this.latexSection(session, row, match[0].length - 1);
            return this.openingBracketBlock(session, "{", row, match.index);
        }
        var match = this.foldingStopMarker.exec(line);
        if (match) {
            if (match[1])
                return this.latexBlock(session, row, match[0].length - 1);
            return this.closingBracketBlock(session, "}", row, match.index + match[0].length);
        }
    };
    this.latexBlock = function (session, row, column, returnRange) {
        var keywords = {
            "\\begin": 1,
            "\\end": -1
        };
        var stream = new TokenIterator(session, row, column);
        var token = stream.getCurrentToken();
        if (!token || !(token.type == "storage.type" || token.type == "constant.character.escape"))
            return;
        var val = token.value;
        var dir = keywords[val];
        var getType = function () {
            var token = stream.stepForward();
            var type = token && token.type == "lparen" ? stream.stepForward().value : "";
            if (dir === -1) {
                stream.stepBackward();
                if (type)
                    stream.stepBackward();
            }
            return type;
        };
        var stack = [getType()];
        var startColumn = dir === -1 ? stream.getCurrentTokenColumn() : session.getLine(row).length;
        var startRow = row;
        stream.step = dir === -1 ? stream.stepBackward : stream.stepForward;
        while (token = stream.step()) {
            if (!token || !(token.type == "storage.type" || token.type == "constant.character.escape"))
                continue;
            var level = keywords[token.value];
            if (!level)
                continue;
            var type = getType();
            if (level === dir)
                stack.unshift(type);
            else if (stack.shift() !== type || !stack.length)
                break;
        }
        if (stack.length)
            return;
        if (dir == 1) {
            stream.stepBackward();
            stream.stepBackward();
        }
        if (returnRange)
            return stream.getCurrentTokenRange();
        var row = stream.getCurrentTokenRow();
        if (dir === -1)
            return new Range(row, session.getLine(row).length, startRow, startColumn);
        else
            return new Range(startRow, startColumn, row, stream.getCurrentTokenColumn());
    };
    this.latexSection = function (session, row, column) {
        var stream = new TokenIterator(session, row, column);
        var token = stream.getCurrentToken();
        if (!token || token.type != "storage.type")
            return;
        var startLevel = keywordLevels[token.value] || 0;
        var stackDepth = 0;
        var endRow = row;
        while (token = stream.stepForward()) {
            if (token.type !== "storage.type")
                continue;
            var level = keywordLevels[token.value] || 0;
            if (level >= 9) {
                if (!stackDepth)
                    endRow = stream.getCurrentTokenRow() - 1;
                stackDepth += level == 9 ? 1 : -1;
                if (stackDepth < 0)
                    break;
            }
            else if (level >= startLevel)
                break;
        }
        if (!stackDepth)
            endRow = stream.getCurrentTokenRow() - 1;
        while (endRow > row && !/\S/.test(session.getLine(endRow)))
            endRow--;
        return new Range(row, session.getLine(row).length, endRow, session.getLine(endRow).length);
    };
}).call(FoldMode.prototype);

});

define("ace/mode/latex",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/latex_highlight_rules","ace/mode/behaviour/cstyle","ace/mode/folding/latex"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var LatexHighlightRules = require("./latex_highlight_rules").LatexHighlightRules;
var CstyleBehaviour = require("./behaviour/cstyle").CstyleBehaviour;
var LatexFoldMode = require("./folding/latex").FoldMode;
var Mode = function () {
    this.HighlightRules = LatexHighlightRules;
    this.foldingRules = new LatexFoldMode();
    this.$behaviour = new CstyleBehaviour({ braces: true });
};
oop.inherits(Mode, TextMode);
(function () {
    this.type = "text";
    this.lineCommentStart = "%";
    this.$id = "ace/mode/latex";
    this.getMatching = function (session, row, column) {
        if (row == undefined)
            row = session.selection.lead;
        if (typeof row == "object") {
            column = row.column;
            row = row.row;
        }
        var startToken = session.getTokenAt(row, column);
        if (!startToken)
            return;
        if (startToken.value == "\\begin" || startToken.value == "\\end") {
            return this.foldingRules.latexBlock(session, row, column, true);
        }
    };
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/less",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/less_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/behaviour/css","ace/mode/css_completions","ace/mode/folding/cstyle"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var LessHighlightRules = require("./less_highlight_rules").LessHighlightRules;
var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var CssBehaviour = require("./behaviour/css").CssBehaviour;
var CssCompletions = require("./css_completions").CssCompletions;
var CStyleFoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    this.HighlightRules = LessHighlightRules;
    this.$outdent = new MatchingBraceOutdent();
    this.$behaviour = new CssBehaviour();
    this.$completer = new CssCompletions();
    this.foldingRules = new CStyleFoldMode();
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "//";
    this.blockComment = { start: "/*", end: "*/" };
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        var tokens = this.getTokenizer().getLineTokens(line, state).tokens;
        if (tokens.length && tokens[tokens.length - 1].type == "comment") {
            return indent;
        }
        var match = line.match(/^.*\{\s*$/);
        if (match) {
            indent += tab;
        }
        return indent;
    };
    this.checkOutdent = function (state, line, input) {
        return this.$outdent.checkOutdent(line, input);
    };
    this.autoOutdent = function (state, doc, row) {
        this.$outdent.autoOutdent(doc, row);
    };
    this.getCompletions = function (state, session, pos, prefix) {
        return this.$completer.getCompletions("ruleset", session, pos, prefix);
    };
    this.$id = "ace/mode/less";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var JsonHighlightRules = function () {
    this.$rules = {
        "start": [
            {
                token: "variable",
                regex: '["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'
            }, {
                token: "string",
                regex: '"',
                next: "string"
            }, {
                token: "constant.numeric",
                regex: "0[xX][0-9a-fA-F]+\\b"
            }, {
                token: "constant.numeric",
                regex: "[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"
            }, {
                token: "constant.language.boolean",
                regex: "(?:true|false)\\b"
            }, {
                token: "text",
                regex: "['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"
            }, {
                token: "comment",
                regex: "\\/\\/.*$"
            }, {
                token: "comment.start",
                regex: "\\/\\*",
                next: "comment"
            }, {
                token: "paren.lparen",
                regex: "[[({]"
            }, {
                token: "paren.rparen",
                regex: "[\\])}]"
            }, {
                token: "punctuation.operator",
                regex: /[,]/
            }, {
                token: "text",
                regex: "\\s+"
            }
        ],
        "string": [
            {
                token: "constant.language.escape",
                regex: /\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/
            }, {
                token: "string",
                regex: '"|$',
                next: "start"
            }, {
                defaultToken: "string"
            }
        ],
        "comment": [
            {
                token: "comment.end",
                regex: "\\*\\/",
                next: "start"
            }, {
                defaultToken: "comment"
            }
        ]
    };
};
oop.inherits(JsonHighlightRules, TextHighlightRules);
exports.JsonHighlightRules = JsonHighlightRules;

});

define("ace/mode/json",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/json_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/cstyle","ace/worker/worker_client"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var HighlightRules = require("./json_highlight_rules").JsonHighlightRules;
var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var CStyleFoldMode = require("./folding/cstyle").FoldMode;
var WorkerClient = require("../worker/worker_client").WorkerClient;
var Mode = function () {
    this.HighlightRules = HighlightRules;
    this.$outdent = new MatchingBraceOutdent();
    this.$behaviour = this.$defaultBehaviour;
    this.foldingRules = new CStyleFoldMode();
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "//";
    this.blockComment = { start: "/*", end: "*/" };
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        if (state == "start") {
            var match = line.match(/^.*[\{\(\[]\s*$/);
            if (match) {
                indent += tab;
            }
        }
        return indent;
    };
    this.checkOutdent = function (state, line, input) {
        return this.$outdent.checkOutdent(line, input);
    };
    this.autoOutdent = function (state, doc, row) {
        this.$outdent.autoOutdent(doc, row);
    };
    this.createWorker = function (session) {
        var worker = new WorkerClient(["ace"], "ace/mode/json_worker", "JsonWorker");
        worker.attachToDocument(session.getDocument());
        worker.on("annotate", function (e) {
            session.setAnnotations(e.data);
        });
        worker.on("terminate", function () {
            session.clearAnnotations();
        });
        return worker;
    };
    this.$id = "ace/mode/json";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/liquid_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules","ace/mode/css_highlight_rules","ace/mode/html_highlight_rules","ace/mode/json_highlight_rules","ace/mode/javascript_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var CssHighlightRules = require("./css_highlight_rules").CssHighlightRules;
var HtmlHighlightRules = require("./html_highlight_rules").HtmlHighlightRules;
var JsonHighlightRules = require("./json_highlight_rules").JsonHighlightRules;
var JavaScriptHighlightRules = require("./javascript_highlight_rules").JavaScriptHighlightRules;
var LiquidHighlightRules = function () {
    HtmlHighlightRules.call(this);
    function onMatchEmbedded(name) {
        var length = name.length;
        return function (value) {
            var idx = value.indexOf(name);
            var x = [
                {
                    type: "meta.tag.punctuation.tag-open",
                    value: "{%"
                },
                {
                    type: "text",
                    value: value.slice(2, idx)
                },
                {
                    type: "keyword.tag" + name + ".tag-name",
                    value: value.slice(idx, idx + length)
                },
                {
                    type: "text",
                    value: value.slice(idx + length, value.indexOf("%}"))
                },
                {
                    type: "meta.tag.punctuation.tag-close",
                    value: "%}"
                }
            ];
            return x;
        };
    }
    for (var rule in this.$rules) {
        this.$rules[rule].unshift({
            token: "comment.block",
            regex: /{%-?\s*comment\s*-?%}/,
            next: [
                {
                    token: "comment.block",
                    regex: /{%-?\s*endcomment\s*-?%}/,
                    next: "pop"
                },
                {
                    defaultToken: "comment",
                    caseInsensitive: false
                }
            ]
        }, {
            token: "comment.line",
            regex: /{%-?\s*#/,
            next: [
                {
                    token: "comment.line",
                    regex: /-?%}/,
                    next: "pop"
                },
                {
                    defaultToken: "comment",
                    caseInsensitive: false
                }
            ]
        }, {
            token: 'style.embedded.start',
            regex: /({%-?\s*\bstyle\b\s*-?%})/,
            next: "style-start",
            onMatch: onMatchEmbedded("style")
        }, {
            regex: /({%-?\s*\bstylesheet\b\s*-?%})/,
            next: "stylesheet-start",
            onMatch: onMatchEmbedded("stylesheet")
        }, {
            regex: /({%-?\s*\bschema\b\s*-?%})/,
            next: "schema-start",
            onMatch: onMatchEmbedded("schema")
        }, {
            regex: /({%-?\s*\bjavascript\b\s*-?%})/,
            next: "javascript-start",
            onMatch: onMatchEmbedded("javascript")
        }, {
            token: "meta.tag.punctuation.tag-open",
            regex: /({%)/,
            next: [
                {
                    token: "keyword.block",
                    regex: /-?\s*[a-zA-Z_$][a-zA-Z0-9_$]+\b/,
                    next: 'liquid-start'
                },
                {
                    token: "meta.tag.punctuation.tag-close",
                    regex: /(-?)(%})/,
                    next: "pop"
                }
            ]
        }, {
            token: "meta.tag.punctuation.ouput-open",
            regex: /({{)/,
            push: "liquid-start"
        });
    }
    this.embedRules(JsonHighlightRules, "schema-", [
        {
            token: "schema-start",
            next: "pop",
            regex: /({%-?\s*\bendschema\b\s*-?%})/,
            onMatch: onMatchEmbedded("endschema")
        }
    ]);
    this.embedRules(JavaScriptHighlightRules, "javascript-", [
        {
            token: "javascript-start",
            next: "pop",
            regex: /({%-?\s*\bendjavascript\b\s*-?%})/,
            onMatch: onMatchEmbedded("endjavascript")
        }
    ]);
    this.embedRules(CssHighlightRules, "style-", [
        {
            token: "style-start",
            next: "pop",
            regex: /({%-?\s*\bendstyle\b\s*-?%})/,
            onMatch: onMatchEmbedded("endstyle")
        }
    ]);
    this.embedRules(CssHighlightRules, "stylesheet-", [
        {
            token: "stylesheet-start",
            next: "pop",
            regex: /({%-?\s*\bendstylesheet\b\s*-?%})/,
            onMatch: onMatchEmbedded("endstylesheet")
        }
    ]);
    this.addRules({
        "liquid-start": [
            {
                token: "meta.tag.punctuation.ouput-close",
                regex: /}}/,
                next: "pop"
            },
            {
                token: "meta.tag.punctuation.tag-close",
                regex: /%}/,
                next: "pop"
            },
            {
                token: "string",
                regex: /['](?:(?:\\.)|(?:[^'\\]))*?[']/
            },
            {
                token: "string",
                regex: /["](?:(?:\\.)|(?:[^'\\]))*?["]/
            },
            {
                token: "constant.numeric",
                regex: /0[xX][0-9a-fA-F]+\b/
            },
            {
                token: "constant.numeric",
                regex: /[+-]?\d+(?:(?:\.\d*)?(?:[eE][+-]?\d+)?)?\b/
            },
            {
                token: "keyword.operator",
                regex: /\*|\-|\+|=|!=|\?\|\:/
            },
            {
                token: "constant.language.boolean",
                regex: /(?:true|false|nil|empty)\b/
            },
            {
                token: "keyword.operator",
                regex: /\s+(?:and|contains|in|with)\b\s+/
            },
            {
                token: ["keyword.operator", "support.function"],
                regex: /(\|\s*)([a-zA-Z_]+)/
            },
            {
                token: "support.function",
                regex: /\s*([a-zA-Z_]+\b)(?=:)/
            },
            {
                token: "keyword.operator",
                regex: /(:)\s*(?=[a-zA-Z_])/
            },
            {
                token: [
                    "support.class",
                    "keyword.operator",
                    "support.object",
                    "keyword.operator",
                    "variable.parameter"
                ],
                regex: /(\w+)(\.)(\w+)(\.)?(\w+)?/
            },
            {
                token: "variable.parameter",
                regex: /\.([a-zA-Z_$][a-zA-Z0-9_$]*\b)$/
            },
            {
                token: "support.class",
                regex: /(?:additional_checkout_buttons|content_for_additional_checkout_buttons)\b/
            },
            {
                token: "paren.lparen",
                regex: /[\[\({]/
            },
            {
                token: "paren.rparen",
                regex: /[\])}]/
            },
            {
                token: "text",
                regex: /\s+/
            }
        ]
    });
    this.normalizeRules();
};
oop.inherits(LiquidHighlightRules, TextHighlightRules);
exports.LiquidHighlightRules = LiquidHighlightRules;

});

define("ace/mode/liquid",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/html","ace/mode/javascript","ace/mode/json","ace/mode/css","ace/mode/liquid_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/cstyle"], function(require, exports, module){var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var HtmlMode = require("./html").Mode;
var JavascriptMode = require("./javascript").Mode;
var JsonMode = require("./json").Mode;
var CssMode = require("./css").Mode;
var LiquidHighlightRules = require("./liquid_highlight_rules").LiquidHighlightRules;
var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var FoldMode = require("./folding/cstyle").FoldMode;
var Mode = function () {
    JsonMode.call(this);
    HtmlMode.call(this);
    CssMode.call(this);
    JavascriptMode.call(this);
    this.HighlightRules = LiquidHighlightRules;
    this.foldingRules = new FoldMode();
};
oop.inherits(Mode, TextMode);
(function () {
    this.blockComment = { start: "<!--", end: "-->" };
    this.voidElements = new HtmlMode().voidElements;
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        var tokenizedLine = this.getTokenizer().getLineTokens(line, state);
        var tokens = tokenizedLine.tokens;
        var endState = tokenizedLine.state;
        if (tokens.length && tokens[tokens.length - 1].type == "comment") {
            return indent;
        }
        if (state == "start") {
            var match = line.match(/^.*[\{\(\[]\s*$/);
            if (match) {
                indent += tab;
            }
        }
        return indent;
    };
    this.checkOutdent = function (state, line, input) {
        return this.$outdent.checkOutdent(line, input);
    };
    this.autoOutdent = function (state, doc, row) {
        this.$outdent.autoOutdent(doc, row);
    };
    this.$id = "ace/mode/liquid";
    this.snippetFileId = "ace/snippets/liquid";
}.call(Mode.prototype));
exports.Mode = Mode;

});

define("ace/mode/lisp_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY Lisp.tmlanguage (UUID: 00D451C9-6B1D-11D9-8DFA-000D93589AF6) */
"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var LispHighlightRules = function () {
    var keywordControl = "case|do|let|loop|if|else|when";
    var keywordOperator = "eq|neq|and|or";
    var constantLanguage = "null|nil";
    var supportFunctions = "cons|car|cdr|cond|lambda|format|setq|setf|quote|eval|append|list|listp|memberp|t|load|progn";
    var keywordMapper = this.createKeywordMapper({
        "keyword.control": keywordControl,
        "keyword.operator": keywordOperator,
        "constant.language": constantLanguage,
        "support.function": supportFunctions
    }, "identifier", true);
    this.$rules =
        {
            "start": [
                {
                    token: "comment",
                    regex: ";.*$"
                },
                {
                    token: ["storage.type.function-type.lisp", "text", "entity.name.function.lisp"],
                    regex: "(?:\\b(?:(defun|defmethod|defmacro))\\b)(\\s+)((?:\\w|\\-|\\!|\\?)*)"
                },
                {
                    token: ["punctuation.definition.constant.character.lisp", "constant.character.lisp"],
                    regex: "(#)((?:\\w|[\\\\+-=<>'\"&#])+)"
                },
                {
                    token: ["punctuation.definition.variable.lisp", "variable.other.global.lisp", "punctuation.definition.variable.lisp"],
                    regex: "(\\*)(\\S*)(\\*)"
                },
                {
                    token: "constant.numeric",
                    regex: "0[xX][0-9a-fA-F]+(?:L|l|UL|ul|u|U|F|f|ll|LL|ull|ULL)?\\b"
                },
                {
                    token: "constant.numeric",
                    regex: "[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?(?:L|l|UL|ul|u|U|F|f|ll|LL|ull|ULL)?\\b"
                },
                {
                    token: keywordMapper,
                    regex: "[a-zA-Z_$][a-zA-Z0-9_$]*\\b"
                },
                {
                    token: "string",
                    regex: '"(?=.)',
                    next: "qqstring"
                }
            ],
            "qqstring": [
                {
                    token: "constant.character.escape.lisp",
                    regex: "\\\\."
                },
                {
                    token: "string",
                    regex: '[^"\\\\]+'
                }, {
                    token: "string",
                    regex: "\\\\$",
                    next: "qqstring"
                }, {
                    token: "string",
                    regex: '"|$',
                    next: "start"
                }
            ]
        };
};
oop.inherits(LispHighlightRules, TextHighlightRules);
exports.LispHighlightRules = LispHighlightRules;

});

define("ace/mode/lisp",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/lisp_highlight_rules"], function(require, exports, module){/*
  THIS FILE WAS AUTOGENERATED BY mode.tmpl.js
*/
"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var LispHighlightRules = require("./lisp_highlight_rules").LispHighlightRules;
var Mode = function () {
    this.HighlightRules = LispHighlightRules;
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = ";";
    this.$id = "ace/mode/lisp";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/livescript",["require","exports","module","ace/tokenizer","ace/mode/matching_brace_outdent","ace/mode/behaviour/cstyle","ace/mode/text"], function(require, exports, module){var identifier, LiveScriptMode, keywordend, stringfill;
identifier = '(?![\\d\\s])[$\\w\\xAA-\\uFFDC](?:(?!\\s)[$\\w\\xAA-\\uFFDC]|-[A-Za-z])*';
exports.Mode = LiveScriptMode = (function (superclass) {
    var indenter, prototype = extend$((import$(LiveScriptMode, superclass).displayName = 'LiveScriptMode', LiveScriptMode), superclass).prototype, constructor = LiveScriptMode;
    function LiveScriptMode() {
        var that;
        this.$tokenizer = new (require('../tokenizer')).Tokenizer(LiveScriptMode.Rules);
        if (that = require('../mode/matching_brace_outdent')) {
            this.$outdent = new that.MatchingBraceOutdent;
        }
        this.$id = "ace/mode/livescript";
        this.$behaviour = new (require("./behaviour/cstyle").CstyleBehaviour)();
    }
    indenter = RegExp('(?:[({[=:]|[-~]>|\\b(?:e(?:lse|xport)|d(?:o|efault)|t(?:ry|hen)|finally|import(?:\\s*all)?|const|var|let|new|catch(?:\\s*' + identifier + ')?))\\s*$');
    prototype.getNextLineIndent = function (state, line, tab) {
        var indent, tokens;
        indent = this.$getIndent(line);
        tokens = this.$tokenizer.getLineTokens(line, state).tokens;
        if (!(tokens.length && tokens[tokens.length - 1].type === 'comment')) {
            if (state === 'start' && indenter.test(line)) {
                indent += tab;
            }
        }
        return indent;
    };
    prototype.lineCommentStart = "#";
    prototype.blockComment = { start: "###", end: "###" };
    prototype.checkOutdent = function (state, line, input) {
        var ref$;
        return (ref$ = this.$outdent) != null ? ref$.checkOutdent(line, input) : void 8;
    };
    prototype.autoOutdent = function (state, doc, row) {
        var ref$;
        return (ref$ = this.$outdent) != null ? ref$.autoOutdent(doc, row) : void 8;
    };
    return LiveScriptMode;
}(require('../mode/text').Mode));
keywordend = '(?![$\\w]|-[A-Za-z]|\\s*:(?![:=]))';
stringfill = {
    defaultToken: 'string'
};
LiveScriptMode.Rules = {
    start: [
        {
            token: 'keyword',
            regex: '(?:t(?:h(?:is|row|en)|ry|ypeof!?)|c(?:on(?:tinue|st)|a(?:se|tch)|lass)|i(?:n(?:stanceof)?|mp(?:ort(?:\\s+all)?|lements)|[fs])|d(?:e(?:fault|lete|bugger)|o)|f(?:or(?:\\s+own)?|inally|unction)|s(?:uper|witch)|e(?:lse|x(?:tends|port)|val)|a(?:nd|rguments)|n(?:ew|ot)|un(?:less|til)|w(?:hile|ith)|o[fr]|return|break|let|var|loop)' + keywordend
        }, {
            token: 'constant.language',
            regex: '(?:true|false|yes|no|on|off|null|void|undefined)' + keywordend
        }, {
            token: 'invalid.illegal',
            regex: '(?:p(?:ackage|r(?:ivate|otected)|ublic)|i(?:mplements|nterface)|enum|static|yield)' + keywordend
        }, {
            token: 'language.support.class',
            regex: '(?:R(?:e(?:gExp|ferenceError)|angeError)|S(?:tring|yntaxError)|E(?:rror|valError)|Array|Boolean|Date|Function|Number|Object|TypeError|URIError)' + keywordend
        }, {
            token: 'language.support.function',
            regex: '(?:is(?:NaN|Finite)|parse(?:Int|Float)|Math|JSON|(?:en|de)codeURI(?:Component)?)' + keywordend
        }, {
            token: 'variable.language',
            regex: '(?:t(?:hat|il|o)|f(?:rom|allthrough)|it|by|e)' + keywordend
        }, {
            token: 'identifier',
            regex: identifier + '\\s*:(?![:=])'
        }, {
            token: 'variable',
            regex: identifier
        }, {
            token: 'keyword.operator',
            regex: '(?:\\.{3}|\\s+\\?)'
        }, {
            token: 'keyword.variable',
            regex: '(?:@+|::|\\.\\.)',
            next: 'key'
        }, {
            token: 'keyword.operator',
            regex: '\\.\\s*',
            next: 'key'
        }, {
            token: 'string',
            regex: '\\\\\\S[^\\s,;)}\\]]*'
        }, {
            token: 'string.doc',
            regex: '\'\'\'',
            next: 'qdoc'
        }, {
            token: 'string.doc',
            regex: '"""',
            next: 'qqdoc'
        }, {
            token: 'string',
            regex: '\'',
            next: 'qstring'
        }, {
            token: 'string',
            regex: '"',
            next: 'qqstring'
        }, {
            token: 'string',
            regex: '`',
            next: 'js'
        }, {
            token: 'string',
            regex: '<\\[',
            next: 'words'
        }, {
            token: 'string.regex',
            regex: '//',
            next: 'heregex'
        }, {
            token: 'comment.doc',
            regex: '/\\*',
            next: 'comment'
        }, {
            token: 'comment',
            regex: '#.*'
        }, {
            token: 'string.regex',
            regex: '\\/(?:[^[\\/\\n\\\\]*(?:(?:\\\\.|\\[[^\\]\\n\\\\]*(?:\\\\.[^\\]\\n\\\\]*)*\\])[^[\\/\\n\\\\]*)*)\\/[gimy$]{0,4}',
            next: 'key'
        }, {
            token: 'constant.numeric',
            regex: '(?:0x[\\da-fA-F][\\da-fA-F_]*|(?:[2-9]|[12]\\d|3[0-6])r[\\da-zA-Z][\\da-zA-Z_]*|(?:\\d[\\d_]*(?:\\.\\d[\\d_]*)?|\\.\\d[\\d_]*)(?:e[+-]?\\d[\\d_]*)?[\\w$]*)'
        }, {
            token: 'lparen',
            regex: '[({[]'
        }, {
            token: 'rparen',
            regex: '[)}\\]]',
            next: 'key'
        }, {
            token: 'keyword.operator',
            regex: '[\\^!|&%+\\-]+'
        }, {
            token: 'text',
            regex: '\\s+'
        }
    ],
    heregex: [
        {
            token: 'string.regex',
            regex: '.*?//[gimy$?]{0,4}',
            next: 'start'
        }, {
            token: 'string.regex',
            regex: '\\s*#{'
        }, {
            token: 'comment.regex',
            regex: '\\s+(?:#.*)?'
        }, {
            defaultToken: 'string.regex'
        }
    ],
    key: [
        {
            token: 'keyword.operator',
            regex: '[.?@!]+'
        }, {
            token: 'identifier',
            regex: identifier,
            next: 'start'
        }, {
            token: 'text',
            regex: '',
            next: 'start'
        }
    ],
    comment: [
        {
            token: 'comment.doc',
            regex: '.*?\\*/',
            next: 'start'
        }, {
            defaultToken: 'comment.doc'
        }
    ],
    qdoc: [
        {
            token: 'string',
            regex: ".*?'''",
            next: 'key'
        }, stringfill
    ],
    qqdoc: [
        {
            token: 'string',
            regex: '.*?"""',
            next: 'key'
        }, stringfill
    ],
    qstring: [
        {
            token: 'string',
            regex: '[^\\\\\']*(?:\\\\.[^\\\\\']*)*\'',
            next: 'key'
        }, stringfill
    ],
    qqstring: [
        {
            token: 'string',
            regex: '[^\\\\"]*(?:\\\\.[^\\\\"]*)*"',
            next: 'key'
        }, stringfill
    ],
    js: [
        {
            token: 'string',
            regex: '[^\\\\`]*(?:\\\\.[^\\\\`]*)*`',
            next: 'key'
        }, stringfill
    ],
    words: [
        {
            token: 'string',
            regex: '.*?\\]>',
            next: 'key'
        }, stringfill
    ]
};
function extend$(sub, sup) {
    function fun() { }
    fun.prototype = (sub.superclass = sup).prototype;
    (sub.prototype = new fun).constructor = sub;
    if (typeof sup.extended == 'function')
        sup.extended(sub);
    return sub;
}
function import$(obj, src) {
    var own = {}.hasOwnProperty;
    for (var key in src)
        if (own.call(src, key))
            obj[key] = src[key];
    return obj;
}

});

define("ace/mode/logiql_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){/* THIS FILE WAS AUTOGENERATED FROM tool\LogicBlox.tmbundle\Syntaxes\LogicBlox.tmLanguage (UUID: 59bf5022-e261-453f-b1cb-9f9fa0712413) */
"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
var LogiQLHighlightRules = function () {
    this.$rules = { start: [{ token: 'comment.block',
                regex: '/\\*',
                push: [{ token: 'comment.block', regex: '\\*/', next: 'pop' },
                    { defaultToken: 'comment.block' }]
            },
            { token: 'comment.single',
                regex: '//.*'
            },
            { token: 'constant.numeric',
                regex: '\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?[fd]?'
            },
            { token: 'string',
                regex: '"',
                push: [{ token: 'string', regex: '"', next: 'pop' },
                    { defaultToken: 'string' }]
            },
            { token: 'constant.language',
                regex: '\\b(true|false)\\b'
            },
            { token: 'entity.name.type.logicblox',
                regex: '`[a-zA-Z_:]+(\\d|\\a)*\\b'
            },
            { token: 'keyword.start', regex: '->', comment: 'Constraint' },
            { token: 'keyword.start', regex: '-->', comment: 'Level 1 Constraint' },
            { token: 'keyword.start', regex: '<-', comment: 'Rule' },
            { token: 'keyword.start', regex: '<--', comment: 'Level 1 Rule' },
            { token: 'keyword.end', regex: '\\.', comment: 'Terminator' },
            { token: 'keyword.other', regex: '!', comment: 'Negation' },
            { token: 'keyword.other', regex: ',', comment: 'Conjunction' },
            { token: 'keyword.other', regex: ';', comment: 'Disjunction' },
            { token: 'keyword.operator', regex: '<=|>=|!=|<|>', comment: 'Equality' },
            { token: 'keyword.other', regex: '@', comment: 'Equality' },
            { token: 'keyword.operator', regex: '\\+|-|\\*|/', comment: 'Arithmetic operations' },
            { token: 'keyword', regex: '::', comment: 'Colon colon' },
            { token: 'support.function',
                regex: '\\b(agg\\s*<<)',
                push: [{ include: '$self' },
                    { token: 'support.function',
                        regex: '>>',
                        next: 'pop' }]
            },
            { token: 'storage.modifier',
                regex: '\\b(lang:[\\w:]*)'
            },
            { token: ['storage.type', 'text'],
                regex: '(export|sealed|clauses|block|alias|alias_all)(\\s*\\()(?=`)'
            },
            { token: 'entity.name',
                regex: '[a-zA-Z_][a-zA-Z_0-9:]*(@prev|@init|@final)?(?=(\\(|\\[))'
            },
            { token: 'variable.parameter',
                regex: '([a-zA-Z][a-zA-Z_0-9]*|_)\\s*(?=(,|\\.|<-|->|\\)|\\]|=))'
            }] };
    this.normalizeRules();
};
oop.inherits(LogiQLHighlightRules, TextHighlightRules);
exports.LogiQLHighlightRules = LogiQLHighlightRules;

});

define("ace/mode/logiql",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/logiql_highlight_rules","ace/mode/folding/coffee","ace/token_iterator","ace/range","ace/mode/matching_brace_outdent"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextMode = require("./text").Mode;
var LogiQLHighlightRules = require("./logiql_highlight_rules").LogiQLHighlightRules;
var FoldMode = require("./folding/coffee").FoldMode;
var TokenIterator = require("../token_iterator").TokenIterator;
var Range = require("../range").Range;
var MatchingBraceOutdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var Mode = function () {
    this.HighlightRules = LogiQLHighlightRules;
    this.foldingRules = new FoldMode();
    this.$outdent = new MatchingBraceOutdent();
    this.$behaviour = this.$defaultBehaviour;
};
oop.inherits(Mode, TextMode);
(function () {
    this.lineCommentStart = "//";
    this.blockComment = { start: "/*", end: "*/" };
    this.getNextLineIndent = function (state, line, tab) {
        var indent = this.$getIndent(line);
        var tokenizedLine = this.getTokenizer().getLineTokens(line, state);
        var tokens = tokenizedLine.tokens;
        var endState = tokenizedLine.state;
        if (/comment|string/.test(endState))
            return indent;
        if (tokens.length && tokens[tokens.length - 1].type == "comment.single")
            return indent;
        var match = line.match();
        if (/(-->|<--|<-|->|{)\s*$/.test(line))
            indent += tab;
        return indent;
    };
    this.checkOutdent = function (state, line, input) {
        if (this.$outdent.checkOutdent(line, input))
            return true;
        if (input !== "\n" && input !== "\r\n")
            return false;
        if (!/^\s+/.test(line))
            return false;
        return true;
    };
    this.autoOutdent = function (state, doc, row) {
        if (this.$outdent.autoOutdent(doc, row))
            return;
        var prevLine = doc.getLine(row);
        var match = prevLine.match(/^\s+/);
        var column = prevLine.lastIndexOf(".") + 1;
        if (!match || !row || !column)
            return 0;
        var line = doc.getLine(row + 1);
        var startRange = this.getMatching(doc, { row: row, column: column });
        if (!startRange || startRange.start.row == row)
            return 0;
        column = match[0].length;
        var indent = this.$getIndent(doc.getLine(startRange.start.row));
        doc.replace(new Range(row + 1, 0, row + 1, column), indent);
    };
    this.getMatching = function (session, row, column) {
        if (row == undefined)
            row = session.selection.lead;
        if (typeof row == "object") {
            column = row.column;
            row = row.row;
        }
        var startToken = session.getTokenAt(row, column);
        var KW_START = "keyword.start", KW_END = "keyword.end";
        var tok;
        if (!startToken)
            return;
        if (startToken.type == KW_START) {
            var it = new TokenIterator(session, row, column);
            it.step = it.stepForward;
        }
        else if (startToken.type == KW_END) {
            var it = new TokenIterator(session, row, column);
            it.step = it.stepBackward;
        }
        else
            return;
        while (tok = it.step()) {
            if (tok.type == KW_START || tok.type == KW_END)
                break;
        }
        if (!tok || tok.type == startToken.type)
            return;
        var col = it.getCurrentTokenColumn();
        var row = it.getCurrentTokenRow();
        return new Range(row, col, row, col + tok.value.length);
    };
    this.$id = "ace/mode/logiql";
}).call(Mode.prototype);
exports.Mode = Mode;

});

define("ace/mode/lsl_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"], function(require, exports, module){"use strict";
var oop = require("../lib/oop");
var TextHighlightRules = require("./text_highlight_rules").TextHighlightRules;
oop.inherits(LSLHighlightRules, TextHighlightRules);
function LSLHighlightRules() {
    var keywordMapper = this.createKeywordMapper({
        "constant.language.float.lsl": "DEG_TO_RAD|PI|PI_BY_TWO|RAD_TO_DEG|SQRT2|TWO_PI",
        "constant.language.integer.lsl": "ACTIVE|AGENT|AGENT_ALWAYS_RUN|AGENT_ATTACHMENTS|AGENT_AUTOPILOT|AGENT_AWAY|AGENT_BUSY|AGENT_BY_LEGACY_NAME|AGENT_BY_USERNAME|AGENT_CROUCHING|AGENT_FLYING|AGENT_IN_AIR|AGENT_LIST_PARCEL|AGENT_LIST_PARCEL_OWNER|AGENT_LIST_REGION|AGENT_MOUSELOOK|AGENT_ON_OBJECT|AGENT_SCRIPTED|AGENT_SITTING|AGENT_TYPING|AGENT_WALKING|ALL_SIDES|ANIM_ON|ATTACH_AVATAR_CENTER|ATTACH_BACK|ATTACH_BELLY|ATTACH_CHEST|ATTACH_CHIN|ATTACH_HEAD|ATTACH_HUD_BOTTOM|ATTACH_HUD_BOTTOM_LEFT|ATTACH_HUD_BOTTOM_RIGHT|ATTACH_HUD_CENTER_1|ATTACH_HUD_CENTER_2|ATTACH_HUD_TOP_CENTER|ATTACH_HUD_TOP_LEFT|ATTACH_HUD_TOP_RIGHT|ATTACH_LEAR|ATTACH_LEFT_PEC|ATTACH_LEYE|ATTACH_LFOOT|ATTACH_LHAND|ATTACH_LHIP|ATTACH_LLARM|ATTACH_LLLEG|ATTACH_LSHOULDER|ATTACH_LUARM|ATTACH_LULEG|ATTACH_MOUTH|ATTACH_NECK|ATTACH_NOSE|ATTACH_PELVIS|ATTACH_REAR|ATTACH_REYE|ATTACH_RFOOT|ATTACH_RHAND|ATTACH_RHIP|ATTACH_RIGHT_PEC|ATTACH_RLARM|ATTACH_RLLEG|ATTACH_RSHOULDER|ATTACH_RUARM|ATTACH_RULEG|AVOID_CHARACTERS|AVOID_DYNAMIC_OBSTACLES|AVOID_NONE|CAMERA_ACTIVE|CAMERA_BEHINDNESS_ANGLE|CAMERA_BEHINDNESS_LAG|CAMERA_DISTANCE|CAMERA_FOCUS|CAMERA_FOCUS_LAG|CAMERA_FOCUS_LOCKED|CAMERA_FOCUS_OFFSET|CAMERA_FOCUS_THRESHOLD|CAMERA_PITCH|CAMERA_POSITION|CAMERA_POSITION_LAG|CAMERA_POSITION_LOCKED|CAMERA_POSITION_THRESHOLD|CHANGED_ALLOWED_DROP|CHANGED_COLOR|CHANGED_INVENTORY|CHANGED_LINK|CHANGED_MEDIA|CHANGED_OWNER|CHANGED_REGION|CHANGED_REGION_START|CHANGED_SCALE|CHANGED_SHAPE|CHANGED_TELEPORT|CHANGED_TEXTURE|CHARACTER_ACCOUNT_FOR_SKIPPED_FRAMES|CHARACTER_AVOIDANCE_MODE|CHARACTER_CMD_JUMP|CHARACTER_CMD_SMOOTH_STOP|CHARACTER_CMD_STOP|CHARACTER_DESIRED_SPEED|CHARACTER_DESIRED_TURN_SPEED|CHARACTER_LENGTH|CHARACTER_MAX_ACCEL|CHARACTER_MAX_DECEL|CHARACTER_MAX_SPEED|CHARACTER_MAX_TURN_RADIUS|CHARACTER_ORIENTATION|CHARACTER_RADIUS|CHARACTER_STAY_WITHIN_PARCEL|CHARACTER_TYPE|CHARACTER_TYPE_A|CHARACTER_TYPE_B|CHARACTER_TYPE_C|CHARACTER_TYPE_D|CHARACTER_TYPE_NONE|CLICK_ACTION_BUY|CLICK_ACTION_NONE|CLICK_ACTION_OPEN|CLICK_ACTION_OPEN_MEDIA|CLICK_ACTION_PAY|CLICK_ACTION_PLAY|CLICK_ACTION_SIT|CLICK_ACTION_TOUCH|CONTENT_TYPE_ATOM|CONTENT_TYPE_FORM|CONTENT_TYPE_HTML|CONTENT_TYPE_JSON|CONTENT_TYPE_LLSD|CONTENT_TYPE_RSS|CONTENT_TYPE_TEXT|CONTENT_TYPE_XHTML|CONTENT_TYPE_XML|CONTROL_BACK|CONTROL_DOWN|CONTROL_FWD|CONTROL_LBUTTON|CONTROL_LEFT|CONTROL_ML_LBUTTON|CONTROL_RIGHT|CONTROL_ROT_LEFT|CONTROL_ROT_RIGHT|CONTROL_UP|DATA_BORN|DATA_NAME|DATA_ONLINE|DATA_PAYINFO|DATA_SIM_POS|DATA_SIM_RATING|DATA_SIM_STATUS|DEBUG_CHANNEL|DENSITY|ERR_GENERIC|ERR_MALFORMED_PARAMS|ERR_PARCEL_PERMISSIONS|ERR_RUNTIME_PERMISSIONS|ERR_THROTTLED|ESTATE_ACCESS_ALLOWED_AGENT_ADD|ESTATE_ACCESS_ALLOWED_AGENT_REMOVE|ESTATE_ACCESS_ALLOWED_GROUP_ADD|ESTATE_ACCESS_ALLOWED_GROUP_REMOVE|ESTATE_ACCESS_BANNED_AGENT_ADD|ESTATE_ACCESS_BANNED_AGENT_REMOVE|FALSE|FORCE_DIRECT_PATH|FRICTION|GCNP_RADIUS|GCNP_STATIC|GRAVITY_MULTIPLIER|HORIZONTAL|HTTP_BODY_MAXLENGTH|HTTP_BODY_TRUNCATED|HTTP_CUSTOM_HEADER|HTTP_METHOD|HTTP_MIMETYPE|HTTP_PRAGMA_NO_CACHE|HTTP_VERBOSE_THROTTLE|HTTP_VERIFY_CERT|INVENTORY_ALL|INVENTORY_ANIMATION|INVENTORY_BODYPART|INVENTORY_CLOTHING|INVENTORY_GESTURE|INVENTORY_LANDMARK|INVENTORY_NONE|INVENTORY_NOTECARD|INVENTORY_OBJECT|INVENTORY_SCRIPT|INVENTORY_SOUND|INVENTORY_TEXTURE|JSON_APPEND|KFM_CMD_PAUSE|KFM_CMD_PLAY|KFM_CMD_SET_MODE|KFM_CMD_STOP|KFM_COMMAND|KFM_DATA|KFM_FORWARD|KFM_LOOP|KFM_MODE|KFM_PING_PONG|KFM_REVERSE|KFM_ROTATION|KFM_TRANSLATION|LAND_LEVEL|LAND_LOWER|LAND_NOISE|LAND_RAISE|LAND_REVERT|LAND_SMOOTH|LINK_ALL_CHILDREN|LINK_ALL_OTHERS|LINK_ROOT|LINK_SET|LINK_THIS|LIST_STAT_GEOMETRIC_MEAN|LIST_STAT_MAX|LIST_STAT_MEAN|LIST_STAT_MEDIAN|LIST_STAT_MIN|LIST_STAT_NUM_COUNT|LIST_STAT_RANGE|LIST_STAT_STD_DEV|LIST_STAT_SUM|LIST_STAT_SUM_SQUARES|LOOP|MASK_BASE|MASK_EVERYONE|MASK_GROUP|MASK_NEXT|MASK_OWNER|OBJECT_ATTACHED_POINT|OBJECT_BODY_SHAPE_TYPE|OBJECT_CHARACTER_TIME|OBJECT_CLICK_ACTION|OBJECT_CREATOR|OBJECT_DESC|OBJECT_GROUP|OBJECT_HOVER_HEIGHT|OBJECT_LAST_OWNER_ID|OBJECT_NAME|OBJECT_OWNER|OBJECT_PATHFINDING_TYPE|OBJECT_PHANTOM|OBJECT_PHYSICS|OBJECT_PHYSICS_COST|OBJECT_POS|OBJECT_PRIM_EQUIVALENCE|OBJECT_RENDER_WEIGHT|OBJECT_RETURN_PARCEL|OBJECT_RETURN_PARCEL_OWNER|OBJECT_RETURN_REGION|OBJECT_ROOT|OBJECT_ROT|OBJECT_RUNNING_SCRIPT_COUNT|OBJECT_SCRIPT_MEMORY|OBJECT_SCRIPT_TIME|OBJECT_SERVER_COST|OBJECT_STREAMING_COST|OBJECT_TEMP_ON_REZ|OBJECT_TOTAL_SCRIPT_COUNT|OBJECT_UNKNOWN_DETAIL|OBJECT_VELOCITY|OPT_AVATAR|OPT_CHARACTER|OPT_EXCLUSION_VOLUME|OPT_LEGACY_LINKSET|OPT_MATERIAL_VOLUME|OPT_OTHER|OPT_STATIC_OBSTACLE|OPT_WALKABLE|PARCEL_COUNT_GROUP|PARCEL_COUNT_OTHER|PARCEL_COUNT_OWNER|PARCEL_COUNT_SELECTED|PARCEL_COUNT_TEMP|PARCEL_COUNT_TOTAL|PARCEL_DETAILS_AREA|PARCEL_DETAILS_DESC|PARCEL_DETAILS_GROUP|PARCEL_DETAILS_ID|PARCEL_DETAILS_NAME|PARCEL_DETAILS_OWNER|PARCEL_DETAILS_SEE_AVATARS|PARCEL_FLAG_ALLOW_ALL_OBJECT_ENTRY|PARCEL_FLAG_ALLOW_CREATE_GROUP_OBJECTS|PARCEL_FLAG_ALLOW_CREATE_OBJECTS|PARCEL_FLAG_ALLOW_DAMAGE|PARCEL_FLAG_ALLOW_FLY|PARCEL_FLAG_ALLOW_GROUP_OBJECT_ENTRY|PARCEL_FLAG_ALLOW_GROUP_SCRIPTS|PARCEL_FLAG_ALLOW_LANDMARK|PARCEL_FLAG_ALLOW_SCRIPTS|PARCEL_FLAG_ALLOW_TERRAFORM|PARCEL_FLAG_LOCAL_SOUND_ONLY|PARCEL_FLAG_RESTRICT_PUSHOBJECT|PARCEL_FLAG_USE_ACCESS_GROUP|PARCEL_FLAG_USE_ACCESS_LIST|PARCEL_FLAG_USE_BAN_LIST|PARCEL_FLAG_USE_LAND_PASS_LIST|PARCEL_MEDIA_COMMAND_AGENT|PARCEL_MEDIA_COMMAND_AUTO_ALIGN|PARCEL_MEDIA_COMMAND_DESC|PARCEL_MEDIA_COMMAND_LOOP|PARCEL_MEDIA_COMMAND_LOOP_SET|PARCEL_MEDIA_COMMAND_PAUSE|PARCEL_MEDIA_COMMAND_PLAY|PARCEL_MEDIA_COMMAND_SIZE|PARCEL_MEDIA_COMMAND_STOP|PARCEL_MEDIA_COMMAND_TEXTURE|PARCEL_MEDIA_COMMAND_TIME|PARCEL_MEDIA_COMMAND_TYPE|PARCEL_MEDIA_COMMAND_UNLOAD|PARCEL_MEDIA_COMMAND_URL|PASS_ALWAYS|PASS_IF_NOT_HANDLED|PASS_NEVER|PASSIVE|PATROL_PAUSE_AT_WAYPOINTS|PAYMENT_INFO_ON_FILE|PAYMENT_INFO_USED|PAY_DEFAULT|PAY_HIDE|PERMISSION_ATTACH|PERMISSION_CHANGE_LINKS|PERMISSION_CONTROL_CAMERA|PERMISSION_DEBIT|PERMISSION_OVERRIDE_ANIMATIONS|PERMISSION_RETURN_OBJECTS|PERMISSION_SILENT_ESTATE_MANAGEMENT|PERMISSION_TAKE_CONTROLS|PERMISSION_TELEPORT|PERMISSION_TRACK_CAMERA|PERMISSION_TRIGGER_ANIMATION|PERM_ALL|PERM_COPY|PERM_MODIFY|PERM_MOVE|PERM_TRANSFER|PING_PONG|PRIM_ALPHA_MODE|PRIM_ALPHA_MODE_BLEND|PRIM_ALPHA_MODE_EMISSIVE|PRIM_ALPHA_MODE_MASK|PRIM_ALPHA_MODE_NONE|PRIM_BUMP_BARK|PRIM_BUMP_BLOBS|PRIM_BUMP_BRICKS|PRIM_BUMP_BRIGHT|PRIM_BUMP_CHECKER|PRIM_BUMP_CONCRETE|PRIM_BUMP_DARK|PRIM_BUMP_DISKS|PRIM_BUMP_GRAVEL|PRIM_BUMP_LARGETILE|PRIM_BUMP_NONE|PRIM_BUMP_SHINY|PRIM_BUMP_SIDING|PRIM_BUMP_STONE|PRIM_BUMP_STUCCO|PRIM_BUMP_SUCTION|PRIM_BUMP_TILE|PRIM_BUMP_WEAVE|PRIM_BUMP_WOOD|PRIM_COLOR|PRIM_DESC|PRIM_FLEXIBLE|PRIM_FULLBRIGHT|PRIM_GLOW|PRIM_HOLE_CIRCLE|PRIM_HOLE_DEFAULT|PRIM_HOLE_SQUARE|PRIM_HOLE_TRIANGLE|PRIM_LINK_TARGET|PRIM_MATERIAL|PRIM_MATERIAL_FLESH|PRIM_MATERIAL_GLASS|PRIM_MATERIAL_METAL|PRIM_MATERIAL_PLASTIC|PRIM_MATERIAL_RUBBER|PRIM_MATERIAL_STONE|PRIM_MATERIAL_WOOD|PRIM_MEDIA_ALT_IMAGE_ENABLE|PRIM_MEDIA_AUTO_LOOP|PRIM_MEDIA_AUTO_PLAY|PRIM_MEDIA_AUTO_SCALE|PRIM_MEDIA_AUTO_ZOOM|PRIM_MEDIA_CONTROLS|PRIM_MEDIA_CONTROLS_MINI|PRIM_MEDIA_CONTROLS_STANDARD|PRIM_MEDIA_CURRENT_URL|PRIM_MEDIA_FIRST_CLICK_INTERACT|PRIM_MEDIA_HEIGHT_PIXELS|PRIM_MEDIA_HOME_URL|PRIM_MEDIA_MAX_HEIGHT_PIXELS|PRIM_MEDIA_MAX_URL_LENGTH|PRIM_MEDIA_MAX_WHITELIST_COUNT|PRIM_MEDIA_MAX_WHITELIST_SIZE|PRIM_MEDIA_MAX_WIDTH_PIXELS|PRIM_MEDIA_PARAM_MAX|PRIM_MEDIA_PERMS_CONTROL|PRIM_MEDIA_PERMS_INTERACT|PRIM_MEDIA_PERM_ANYONE|PRIM_MEDIA_PERM_GROUP|PRIM_MEDIA_PERM_NONE|PRIM_MEDIA_PERM_OWNER|PRIM_MEDIA_WHITELIST|PRIM_MEDIA_WHITELIST_ENABLE|PRIM_MEDIA_WIDTH_PIXELS|PRIM_NAME|PRIM_NORMAL|PRIM_OMEGA|PRIM_PHANTOM|PRIM_PHYSICS|PRIM_PHYSICS_SHAPE_CONVEX|PRIM_PHYSICS_SHAPE_NONE|PRIM_PHYSICS_SHAPE_PRIM|PRIM_PHYSICS_SHAPE_TYPE|PRIM_POINT_LIGHT|PRIM_POSITION|PRIM_POS_LOCAL|PRIM_ROTATION|PRIM_ROT_LOCAL|PRIM_SCULPT_FLAG_INVERT|PRIM_SCULPT_FLAG_MIRROR|PRIM_SCULPT_TYPE_CYLINDER|PRIM_SCULPT_TYPE_MASK|PRIM_SCULPT_TYPE_PLANE|PRIM_SCULPT_TYPE_SPHERE|PRIM_SCULPT_TYPE_TORUS|PRIM_SHINY_HIGH|PRIM_SHINY_LOW|PRIM_SHINY_MEDIUM|PRIM_SHINY_NONE|PRIM_SIZE|PRIM_SLICE|PRIM_SPECULAR|PRIM_TEMP_ON_REZ|PRIM_TEXGEN|PRIM_TEXGEN_DEFAULT|PRIM_TEXGEN_PLANAR|PRIM_TEXT|PRIM_TEXTURE|PRIM_TYPE|PRIM_TYPE_BOX|PRIM_TYPE_CYLINDER|PRIM_TYPE_PRISM|PRIM_TYPE_RING|PRIM_TYPE_SCULPT|PRIM_TYPE_SPHERE|PRIM_TYPE_TORUS|PRIM_TYPE_TUBE|PROFILE_NONE|PROFILE_SCRIPT_MEMORY|PSYS_PART_BF_DEST_COLOR|PSYS_PART_BF_ONE|PSYS_PART_BF_ONE_MINUS_DEST_COLOR|PSYS_PART_BF_ONE_MINUS_SOURCE_ALPHA|PSYS_PART_BF_ONE_MINUS_SOURCE_COLOR|PSYS_PART_BF_SOURCE_ALPHA|PSYS_PART_BF_SOURCE_COLOR|PSYS_PART_BF_ZERO|PSYS_PART_BLEND_FUNC_DEST|PSYS_PART_BLEND_FUNC_SOURCE|PSYS_PART_BOUNCE_MASK|PSYS_PART_EMISSIVE_MASK|PSYS_PART_END_ALPHA|PSYS_PART_END_COLOR|PSYS_PART_END_GLOW|PSYS_PART_END_SCALE|PSYS_PART_FLAGS|PSYS_PART_FOLLOW_SRC_MASK|PSYS_PART_FOLLOW_VELOCITY_MASK|PSYS_PART_INTERP_COLOR_MASK|PSYS_PART_INTERP_SCALE_MASK|PSYS_PART_MAX_AGE|PSYS_PART_RIBBON_MASK|PSYS_PART_START_ALPHA|PSYS_PART_START_COLOR|PSYS_PART_START_GLOW|PSYS_PART_START_SCALE|PSYS_PART_TARGET_LINEAR_MASK|PSYS_PART_TARGET_POS_MASK|PSYS_PART_WIND_MASK|PSYS_SRC_ACCEL|PSYS_SRC_ANGLE_BEGIN|PSYS_SRC_ANGLE_END|PSYS_SRC_BURST_PART_COUNT|PSYS_SRC_BURST_RADIUS|PSYS_SRC_BURST_RATE|PSYS_SRC_BURST_SPEED_MAX|PSYS_SRC_BURST_SPEED_MIN|PSYS_SRC_MAX_AGE|PSYS_SRC_OMEGA|PSYS_SRC_PATTERN|PSYS_SRC_PATTERN_ANGLE|PSYS_SRC_PATTERN_ANGLE_CONE|PSYS_SRC_PATTERN_ANGLE_CONE_EMPTY|PSYS_SRC_PATTERN_DROP|PSYS_SRC_PATTERN_EXPLODE|PSYS_SRC_TARGET_KEY|PSYS_SRC_TEXTURE|PUBLIC_CHANNEL|PURSUIT_FUZZ_FACTOR|PURSUIT_GOAL_TOLERANCE|PURSUIT_INTERCEPT|PURSUIT_OFFSET|PU_EVADE_HIDDEN|PU_EVADE_SPOTTED|PU_FAILURE_DYNAMIC_PATHFINDING_DISABLED|PU_FAILURE_INVALID_GOAL|PU_FAILURE_INVALID_START|PU_FAILURE_NO_NAVMESH|PU_FAILURE_NO_VALID_DESTINATION|PU_FAILURE_OTHER|PU_FAILURE_PARCEL_UNREACHABLE|PU_FAILURE_TARGET_GONE|PU_FAILURE_UNREACHABLE|PU_GOAL_REACHED|PU_SLOWDOWN_DISTANCE_REACHED|RCERR_CAST_TIME_EXCEEDED|RCERR_SIM_PERF_LOW|RCERR_UNKNOWN|RC_DATA_FLAGS|RC_DETECT_PHANTOM|RC_GET_LINK_NUM|RC_GET_NORMAL|RC_GET_ROOT_KEY|RC_MAX_HITS|RC_REJECT_AGENTS|RC_REJECT_LAND|RC_REJECT_NONPHYSICAL|RC_REJECT_PHYSICAL|RC_REJECT_TYPES|REGION_FLAG_ALLOW_DAMAGE|REGION_FLAG_ALLOW_DIRECT_TELEPORT|REGION_FLAG_BLOCK_FLY|REGION_FLAG_BLOCK_TERRAFORM|REGION_FLAG_DISABLE_COLLISIONS|REGION_FLAG_DISABLE_PHYSICS|REGION_FLAG_FIXED_SUN|REGION_FLAG_RESTRICT_PUSHOBJECT|REGION_FLAG_SANDBOX|REMOTE_DATA_CHANNEL|REMOTE_DATA_REPLY|REMOTE_DATA_REQUEST|REQUIRE_LINE_OF_SIGHT|RESTITUTION|REVERSE|ROTATE|SCALE|SCRIPTED|SIM_STAT_PCT_CHARS_STEPPED|SMOOTH|STATUS_BLOCK_GRAB|STATUS_BLOCK_GRAB_OBJECT|STATUS_BOUNDS_ERROR|STATUS_CAST_SHADOWS|STATUS_DIE_AT_EDGE|STATUS_INTERNAL_ERROR|STATUS_MALFORMED_PARAMS|STATUS_NOT_FOUND|STATUS_NOT_SUPPORTED|STATUS_OK|STATUS_PHANTOM|STATUS_PHYSICS|STATUS_RETURN_AT_EDGE|STATUS_ROTATE_X|STATUS_ROTATE_Y|STATUS_ROTATE_Z|STATUS_SANDBOX|STATUS_TYPE_MISMATCH|STATUS_WHITELIST_FAILED|STRING_TRIM|STRING_TRIM_HEAD|STRING_TRIM_TAIL|TOUCH_INVALID_FACE|TRAVERSAL_TYPE|TRAVERSAL_TYPE_FAST|TRAVERSAL_TYPE_NONE|TRAVERSAL_TYPE_SLOW|TRUE|TYPE_FLOAT|TYPE_INTEGER|TYPE_INVALID|TYPE_KEY|TYPE_ROTATION|TYPE_STRING|TYPE_VECTOR|VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY|VEHICLE_ANGULAR_DEFLECTION_TIMESCALE|VEHICLE_ANGULAR_FRICTION_TIMESCALE|VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE|VEHICLE_ANGULAR_MOTOR_DIRECTION|VEHICLE_ANGULAR_MOTOR_TIMESCALE|VEHICLE_BANKING_EFFICIENCY|VEHICLE_BANKING_MIX|VEHICLE_BANKING_TIMESCALE|VEHICLE_BUOYANCY|VEHICLE_FLAG_CAMERA_DECOUPLED|VEHICLE_FLAG_HOVER_GLOBAL_HEIGHT|VEHICLE_FLAG_HOVER_TERRAIN_ONLY|VEHICLE_FLAG_HOVER_UP_ONLY|VEHICLE_FLAG_HOVER_WATER_ONLY|VEHICLE_FLAG_LIMIT_MOTOR_UP|VEHICLE_FLAG_LIMIT_ROLL_ONLY|VEHICLE_FLAG_MOUSELOOK_BANK|VEHICLE_FLAG_MOUSELOOK_STEER|VEHICLE_FLAG_NO_DEFLECTION_UP|VEHICLE_HOVER_EFFICIENCY|VEHICLE_HOVER_HEIGHT|VEHICLE_HOVER_TIMESCALE|VEHICLE_LINEAR_DEFLECTION_EFFICIENCY|VEHICLE_LINEAR_DEFLECTION_TIMESCALE|VEHICLE_LINEAR_FRICTION_TIMESCALE|VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE|VEHICLE_LINEAR_MOTOR_DIRECTION|VEHICLE_LINEAR_MOTOR_OFFSET|VEHICLE_LINEAR_MOTOR_TIMESCALE|VEHICLE_REFERENCE_FRAME|VEHICLE_TYPE_AIRPLANE|VEHICLE_TYPE_BALLOON|VEHICLE_TYPE_BOAT|VEHICLE_TYPE_CAR|VEHICLE_TYPE_NONE|VEHICLE_TYPE_SLED|VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY|VEHICLE_VERTICAL_ATTRACTION_TIMESCALE|VERTICAL|WANDER_PAUSE_AT_WAYPOINTS|XP_ERROR_EXPERIENCES_DISABLED|XP_ERROR_EXPERIENCE_DISABLED|XP_ERROR_EXPERIENCE_SUSPENDED|XP_ERROR_INVALID_EXPERIENCE|XP_ERROR_INVALID_PARAMETERS|XP_ERROR_KEY_NOT_FOUND|XP_ERROR_MATURITY_EXCEEDED|XP_ERROR_NONE|XP_ERROR_NOT_FOUND|XP_ERROR_NOT_PERMITTED|XP_ERROR_NO_EXPERIENCE|XP_ERROR_QUOTA_EXCEEDED|XP_ERROR_RETRY_UPDATE|XP_ERROR_STORAGE_EXCEPTION|XP_ERROR_STORE_DISABLED|XP_ERROR_THROTTLED|XP_ERROR_UNKNOWN_ERROR",
        "constant.language.integer.boolean.lsl": "FALSE|TRUE",
        "constant.language.quaternion.lsl": "ZERO_ROTATION",
        "constant.language.string.lsl": "EOF|JSON_ARRAY|JSON_DELETE|JSON_FALSE|JSON_INVALID|JSON_NULL|JSON_NUMBER|JSON_OBJECT|JSON_STRING|JSON_TRUE|NULL_KEY|TEXTURE_BLANK|TEXTURE_DEFAULT|TEXTURE_MEDIA|TEXTURE_PLYWOOD|TEXTURE_TRANSPARENT|URL_REQUEST_DENIED|URL_REQUEST_GRANTED",
        "constant.language.vector.lsl": "TOUCH_INVALID_TEXCOORD|TOUCH_INVALID_VECTOR|ZERO_VECTOR",
        "invalid.broken.lsl": "LAND_LARGE_BRUSH|LAND_MEDIUM_BRUSH|LAND_SMALL_BRUSH",
        "invalid.deprecated.lsl": "ATTACH_LPEC|ATTACH_RPEC|DATA_RATING|OBJECT_ATTACHMENT_GEOMETRY_BYTES|OBJECT_ATTACHMENT_SURFACE_AREA|PRIM_CAST_SHADOWS|PRIM_MATERIAL_LIGHT|PRIM_TYPE_LEGACY|PSYS_SRC_INNERANGLE|PSYS_SRC_OUTERANGLE|VEHICLE_FLAG_NO_FLY_UP|llClearExperiencePermissions|llCloud|llGetExperienceList|llMakeExplosion|llMakeFire|llMakeFountain|llMakeSmoke|llRemoteDataSetRegion|llSound|llSoundPreload|llXorBase64Strings|llXorBase64StringsCorrect",
        "invalid.illegal.lsl": "event",
        "invalid.unimplemented.lsl": "CHARACTER_MAX_ANGULAR_ACCEL|CHARACTER_MAX_ANGULAR_SPEED|CHARACTER_TURN_SPEED_MULTIPLIER|PERMISSION_CHANGE_JOINTS|PERMISSION_CHANGE_PERMISSIONS|PERMISSION_EXPERIENCE|PERMISSION_RELEASE_OWNERSHIP|PERMISSION_REMAP_CONTROLS|PRIM_PHYSICS_MATERIAL|PSYS_SRC_OBJ_REL_MASK|llCollisionSprite|llPointAt|llRefreshPrimURL|llReleaseCamera|llRemoteLoadScript|llSetPrimURL|llStopPointAt|llTakeCamera",
        "reserved.godmode.lsl": "llGodLikeRezObject|llSetInventoryPermMask|llSetObjectPermMask",
        "reserved.log.lsl": "print",
        "keyword.control.lsl": "do|else|for|if|jump|return|while",
        "storage.type.lsl": "float|integer|key|list|quaternion|rotation|string|vector",
        "support.function.lsl": "llAbs|llAcos|llAddToLandBanList|llAddToLandPassList|llAdjustSoundVolume|llAgentInExperience|llAllowInventoryDrop|llAngleBetween|llApplyImpulse|llApplyRotationalImpulse|llAsin|llAtan2|llAttachToAvatar|llAttachToAvatarTemp|llAvatarOnLinkSitTarget|llAvatarOnSitTarget|llAxes2Rot|llAxisAngle2Rot|llBase64ToInteger|llBase64ToString|llBreakAllLinks|llBreakLink|llCSV2List|llCastRay|llCeil|llClearCameraParams|llClearLinkMedia|llClearPrimMedia|llCloseRemoteDataChannel|llCollisionFilter|llCollisionSound|llCos|llCreateCharacter|llCreateKeyValue|llCreateLink|llDataSizeKeyValue|llDeleteCharacter|llDeleteKeyValue|llDeleteSubList|llDeleteSubString|llDetachFromAvatar|llDetectedGrab|llDetectedGroup|llDetectedKey|llDetectedLinkNumber|llDetectedName|llDetectedOwner|llDetectedPos|llDetectedRot|llDetectedTouchBinormal|llDetectedTouchFace|llDetectedTouchNormal|llDetectedTouchPos|llDetectedTouchST|llDetectedTouchUV|llDetectedType|llDetectedVel|llDialog|llDie|llDumpList2String|llEdgeOfWorld|llEjectFromLand|llEmail|llEscapeURL|llEuler2Rot|llEvade|llExecCharacterCmd|llFabs|llFleeFrom|llFloor|llForceMouselook|llFrand|llGenerateKey|llGetAccel|llGetAgentInfo|llGetAgentLanguage|llGetAgentList|llGetAgentSize|llGetAlpha|llGetAndResetTime|llGetAnimation|llGetAnimationList|llGetAnimationOverride|llGetAttached|llGetAttachedList|llGetBoundingBox|llGetCameraPos|llGetCameraRot|llGetCenterOfMass|llGetClosestNavPoint|llGetColor|llGetCreator|llGetDate|llGetDisplayName|llGetEnergy|llGetEnv|llGetExperienceDetails|llGetExperienceErrorMessage|llGetForce|llGetFreeMemory|llGetFreeURLs|llGetGMTclock|llGetGeometricCenter|llGetHTTPHeader|llGetInventoryCreator|llGetInventoryKey|llGetInventoryName|llGetInventoryNumber|llGetInventoryPermMask|llGetInventoryType|llGetKey|llGetLandOwnerAt|llGetLinkKey|llGetLinkMedia|llGetLinkName|llGetLinkNumber|llGetLinkNumberOfSides|llGetLinkPrimitiveParams|llGetListEntryType|llGetListLength|llGetLocalPos|llGetLocalRot|llGetMass|llGetMassMKS|llGetMaxScaleFactor|llGetMemoryLimit|llGetMinScaleFactor|llGetNextEmail|llGetNotecardLine|llGetNumberOfNotecardLines|llGetNumberOfPrims|llGetNumberOfSides|llGetObjectDesc|llGetObjectDetails|llGetObjectMass|llGetObjectName|llGetObjectPermMask|llGetObjectPrimCount|llGetOmega|llGetOwner|llGetOwnerKey|llGetParcelDetails|llGetParcelFlags|llGetParcelMaxPrims|llGetParcelMusicURL|llGetParcelPrimCount|llGetParcelPrimOwners|llGetPermissions|llGetPermissionsKey|llGetPhysicsMaterial|llGetPos|llGetPrimMediaParams|llGetPrimitiveParams|llGetRegionAgentCount|llGetRegionCorner|llGetRegionFPS|llGetRegionFlags|llGetRegionName|llGetRegionTimeDilation|llGetRootPosition|llGetRootRotation|llGetRot|llGetSPMaxMemory|llGetScale|llGetScriptName|llGetScriptState|llGetSimStats|llGetSimulatorHostname|llGetStartParameter|llGetStaticPath|llGetStatus|llGetSubString|llGetSunDirection|llGetTexture|llGetTextureOffset|llGetTextureRot|llGetTextureScale|llGetTime|llGetTimeOfDay|llGetTimestamp|llGetTorque|llGetUnixTime|llGetUsedMemory|llGetUsername|llGetVel|llGetWallclock|llGiveInventory|llGiveInventoryList|llGiveMoney|llGround|llGroundContour|llGroundNormal|llGroundRepel|llGroundSlope|llHTTPRequest|llHTTPResponse|llInsertString|llInstantMessage|llIntegerToBase64|llJson2List|llJsonGetValue|llJsonSetValue|llJsonValueType|llKey2Name|llKeyCountKeyValue|llKeysKeyValue|llLinkParticleSystem|llLinkSitTarget|llList2CSV|llList2Float|llList2Integer|llList2Json|llList2Key|llList2List|llList2ListStrided|llList2Rot|llList2String|llList2Vector|llListFindList|llListInsertList|llListRandomize|llListReplaceList|llListSort|llListStatistics|llListen|llListenControl|llListenRemove|llLoadURL|llLog|llLog10|llLookAt|llLoopSound|llLoopSoundMaster|llLoopSoundSlave|llMD5String|llManageEstateAccess|llMapDestination|llMessageLinked|llMinEventDelay|llModPow|llModifyLand|llMoveToTarget|llNavigateTo|llOffsetTexture|llOpenRemoteDataChannel|llOverMyLand|llOwnerSay|llParcelMediaCommandList|llParcelMediaQuery|llParseString2List|llParseStringKeepNulls|llParticleSystem|llPassCollisions|llPassTouches|llPatrolPoints|llPlaySound|llPlaySoundSlave|llPow|llPreloadSound|llPursue|llPushObject|llReadKeyValue|llRegionSay|llRegionSayTo|llReleaseControls|llReleaseURL|llRemoteDataReply|llRemoteLoadScriptPin|llRemoveFromLandBanList|llRemoveFromLandPassList|llRemoveInventory|llRemoveVehicleFlags|llRequestAgentData|llRequestDisplayName|llRequestExperiencePermissions|llRequestInventoryData|llRequestPermissions|llRequestSecureURL|llRequestSimulatorData|llRequestURL|llRequestUsername|llResetAnimationOverride|llResetLandBanList|llResetLandPassList|llResetOtherScript|llResetScript|llResetTime|llReturnObjectsByID|llReturnObjectsByOwner|llRezAtRoot|llRezObject|llRot2Angle|llRot2Axis|llRot2Euler|llRot2Fwd|llRot2Left|llRot2Up|llRotBetween|llRotLookAt|llRotTarget|llRotTargetRemove|llRotateTexture|llRound|llSHA1String|llSameGroup|llSay|llScaleByFactor|llScaleTexture|llScriptDanger|llScriptProfiler|llSendRemoteData|llSensor|llSensorRemove|llSensorRepeat|llSetAlpha|llSetAngularVelocity|llSetAnimationOverride|llSetBuoyancy|llSetCameraAtOffset|llSetCameraEyeOffset|llSetCameraParams|llSetClickAction|llSetColor|llSetContentType|llSetDamage|llSetForce|llSetForceAndTorque|llSetHoverHeight|llSetKeyframedMotion|llSetLinkAlpha|llSetLinkCamera|llSetLinkColor|llSetLinkMedia|llSetLinkPrimitiveParams|llSetLinkPrimitiveParamsFast|llSetLinkTexture|llSetLinkTextureAnim|llSetLocalRot|llSetMemoryLimit|llSetObjectDesc|llSetObjectName|llSetParcelMusicURL|llSetPayPrice|llSetPhysicsMaterial|llSetPos|llSetPrimMediaParams|llSetPrimitiveParams|llSetRegionPos|llSetRemoteScriptAccessPin|llSetRot|llSetScale|llSetScriptState|llSetSitText|llSetSoundQueueing|llSetSoundRadius|llSetStatus|llSetText|llSetTexture|llSetTextureAnim|llSetTimerEvent|llSetTorque|llSetTouchText|llSetVehicleFlags|llSetVehicleFloatParam|llSetVehicleRotationParam|llSetVehicleType|llSetVehicleVectorParam|llSetVelocity|llShout|llSin|llSitTarget|llSleep|llSqrt|llStartAnimation|llStopAnimation|llStopHover|llStopLookAt|llStopMoveToTarget|llStopSound|llStringLength|llStringToBase64|llStringTrim|llSubStringIndex|llTakeControls|llTan|llTarget|llTargetOmega|llTargetRemove|llTeleportAgent|llTeleportAgentGlobalCoords|llTeleportAgentHome|llTextBox|llToLower|llToUpper|llTransferLindenDollars|llTriggerSound|llTriggerSoundLimited|llUnSit|llUnescapeURL|llUpdateCharacter|llUpdateKeyValue|llVecDist|llVecMag|llVecNorm|llVolumeDetect|llWanderWithin|llWater|llWhisper|llWind|llXorBase64",
        "support.function.event.lsl": "at_rot_target|at_target|attach|changed|collision|collision_end|collision_start|control|dataserver|email|experience_permissions|experience_permissions_denied|http_request|http_response|land_collision|land_collision_end|land_collision_start|link_message|listen|money|moving_end|moving_start|no_sensor|not_at_rot_target|not_at_target|object_rez|on_rez|path_update|remote_data|run_time_permissions|sensor|state_entry|state_exit|timer|touch|touch_end|touch_start|transaction_result"
    }, "identifier");
    this.$rules = {
        "start": [
            {
                token: "comment.line.double-slash.lsl",
                regex: "\\/\\/.*$"
            }, {
                token: "comment.block.begin.lsl",
                regex: "\\/\\*",
                next: "comment"
            }, {
                token: "string.quoted.double.lsl",
                start: '"',
                end: '"',
                next: [{
                        token: "constant.character.escape.lsl",
                        regex: /\\[tn"\\]/
                    }]
            }, {
                token: "constant.numeric.lsl",
                regex: "(0[xX][0-9a-fA-F]+|[+-]?[0-9]+(?:(?:\\.[0-9]*)?(?:[eE][+-]?[0-9]+)?)?)\\b"
            }, {
                token: "entity.name.state.lsl",
                regex: "\\b((state)\\s+[A-Za-z_]\\w*|default)\\b"
            }, {
                token: keywordMapper,
                regex: "\\b[a-zA-Z_][a-zA-Z0-9_]*\\b"
            }, {
                token: "support.function.user-defined.lsl",
                regex: /\b([a-zA-Z_]\w*)(?=\(.*?\))/
            }, {
                token: "keyword.operator.lsl",
                regex: "\\+\\+|\\-\\-|<<|>>|&&?|\\|\\|?|\\^|~|[!%<>=*+\\-\\/]=?"
            }, {
                token: "invalid.illegal.keyword.operator.lsl",
                regex: ":=?"
            }, {
                token: "punctuation.operator.lsl",
                regex: "\\,|\\;"
            }, {
                token: "paren.lparen.lsl",
                regex: "[\\[\\(\\{]"
            }, {
                token: "paren.rparen.lsl",
                regex: "[\\]\\)\\}]"
            }, {
                token: "text.lsl",
                regex: "\\s+"
            }
        ],
        "comment": [
            {
                token: "comment.block.end.lsl",
                regex: "\\*\\/",
                next: "start"
            }, {
                defaultToken: "comment.block.lsl"
            }
        ]
    };
    this.normalizeRules();
}
exports.LSLHighlightRules = LSLHighlightRules;

});

define("ace/mode/lsl",["require","exports","module","ace/mode/lsl_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/text","ace/mode/folding/cstyle","ace/lib/oop"], function(require, exports, module){"use strict";
var Rules = require("./lsl_highlight_rules").LSLHighlightRules;
var Outdent = require("./matching_brace_outdent").MatchingBraceOutdent;
var TextMode = require("./text").Mode;
var CStyleFoldMode = require("./folding/cstyle").FoldMode;
var oop = require("../lib/oop");
var Mode = function () {
    this.HighlightRules = Rules;
    t